<?php include_once('config.php') ?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Loja - Principal</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.239.11.1">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.239.11.1">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="plugins/daterangepicker/daterangepicker.css?versao=3.239.11.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="dist/css/animate.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.239.11.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.239.11.1">
  <link rel="stylesheet" href="dist/css/cadastro.css?versao=3.239.11.1">
  <link rel="stylesheet" href="dist/css/default.min.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.239.11.1" />
  <link rel="shortcut icon" href="favicon.ico">

  <link href='dist/css/bootstrap.min.css?versao=3.239.11.1'>
  <link rel="stylesheet" href="dist/css/normalize.css?versao=3.239.11.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.239.11.1">
  <style>
    .progress-bar {
      background-color: var(--primary-color) !important;
    }

    .chart {
      width: 100%;
    }

    .card-body {
      padding: 0 !important;
    }
  </style>
  <!--Load the AJAX API-->
  <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('menu.php');
    ?>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row">
            <div class="col-sm-12 d-none" id='div-welcome'>
              <h3>Bem Vindo!</h3>
            </div>
            <div class="col-sm-12">
              <nav>
                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                  <!-- <a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">Home</a>
                  <a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false">Profile</a>
                  <a class="nav-item nav-link" id="nav-contact-tab" data-toggle="tab" href="#nav-contact" role="tab" aria-controls="nav-contact" aria-selected="false">Contact</a> -->
                </div>
              </nav>
            </div>
          </div>
          <div class="row">
            <div class="col-sm-12">
              <div class="tab-content" id="nav-tabContent">
                <!-- <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">.aaa.</div>
                <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">..bbb.</div>
                <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">.ccc..</div> -->
              </div>
            </div>
          </div>
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <div style="text-align:center;" class="mt-2">
                <label id="switch" class="switch d-none">
                  <input type="checkbox" onchange="toggleTheme()" id="theme-slider">
                  <span class="theme-slider round"></span>
                </label>
              </div>
              <h1 class="m-0 text-dark" id="txtNome">
              </h1>

            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">Início</li>
              </ol>
            </div>
          </div>
        </div>
        <div class="container-fluid">
          <div class="row d-none" id="card-carregando">
            <div class="col-sm-12" style="text-align:center">
              <h5>Carregando dashboard</h5>
              <div class="progress progress-stripedactive">
                <div class="progress-bar progress-bar-striped bg-danger progress-bar-animated" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
                </div>
              </div>
            </div>
          </div>
          <div id="conteudo" class="row">
            <div class="col-sm-12">
              <textarea id="txtSelect" class="d-none" rows="10" placeholder="Monte o SQL aqui"></textarea>
              <div id="resultados" class="col-sm-12 table-responsive d-none">
              </div>
            </div>
            <div id="chart_div"></div>
          </div>
          <div class="modal fade" id="modal-info" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h4 id="modal-info-title" class="modal-title">Vendas Semanais</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-sm-12">
                      <div class="table-responsive" id="modal-info-table">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('footer.php');
  ?>
  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.239.11.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.239.11.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.239.11.1"></script>
  <!-- Sparkline -->
  <script src="plugins/sparklines/sparkline.js?versao=3.239.11.1"></script>
  <script src="dist/js/sisplan.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.239.11.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.239.11.1"></script>
  <script src="dist/js/jquery.dataTables.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.239.11.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.239.11.1"></script>
  <script src="utils/cookies.js?versao=3.239.11.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.239.11.1"></script>
  <script src="dist/js/sql-formatter.min.js?versao=3.239.11.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.239.11.1"></script>
  <script src="dist/js/underscore.js?versao=3.239.11.1"></script>
  <script type="text/javascript">
    google.charts.load('current', {
      'packages': ['corechart'],
      language: 'pt-BR'
    });
  </script>

  <script>
    $(document).ready(async function() {
      var queryString = window.location.href;
      var parametros = queryString.split('/');
      ipInterno = '<?php echo IP_INTERNO; ?>';
      ipExterno = '<?php echo IP_EXTERNO; ?>';
      basicAuth = '<?php echo BASIC_AUTH; ?>';
      var arrDados = [];
      var arrGraficos = [];
      var contadorGrafico = 0;
      var ultimoInterval = 0;

      async function buscaDashboardsLiberados() {
        const usuario = getCookie('cod_usuario');
        if (usuario === '') {
          msgErro('Usuário deve estar logado para continuar.');
          window.location.href = '<?php echo BASE_URI; ?>/';
        }
        const pesquisa = {
          tabela: 'DASH_ACESSO_WEB',
          camposSelect: ['DASH_ACESSO_WEB.ID_DASH', 'DASH_WEB.NOME'],
          leftJoin: [{
            tabela: 'DASH_WEB',
            condicao: 'DASH_WEB.ID = DASH_ACESSO_WEB.ID_DASH'
          }],
          where: [`DASH_ACESSO_WEB.CODIGO = '${usuario}' AND DASH_ACESSO_WEB.CONSULTA = 'S'`],
          orderBy: ['DASH_ACESSO_WEB.ID_DASH ASC']
        }
        //adicionar where dos filtros
        const listaDashboards = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        if (listaDashboards.length === 0) {
          $('#nav-tab').remove();
          $('#nav-tabContent').remove();
          $('#div-welcome').removeClass('d-none');
        } else {
          $('#div-welcome').addClass('d-none');
        }

        listaDashboards.forEach((dashboard, index) => {
          const ativo = index === 0 ? 'active' : '';
          const texto = `<a class="nav-item nav-link ${ativo}" data-id-dash="${dashboard.ID_DASH}" id="nav-dash-${dashboard.ID_DASH}" data-toggle="tab" href="#tab-content" role="tab">${dashboard.NOME}</a>`
          $('#nav-tab').append(texto);
          // $('#nav-tabContent').append(dashboard.NOME);
        });
        $('a.nav-item.nav-link').on('click', async function() {
          const id = $(this).attr('data-id-dash');
          await carregaDashboardCompleto(id);
        });
        $($('a.nav-item.nav-link')[0]).trigger('click');
      }

      async function buscaDashboard(id_dashboard) {
        const _url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
          try {
            var response = await requisicao('GET', _url,
              `JSON={ "tabela":"dash_web", "camposSelect":["nome", "minutos"], "where": ["id = '${id_dashboard}'"] }`,
              null);

            if (!response) {
              return;
            }
            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }
            $('#txtNome').html(jsonStr.RESULT[0][0].NOME);
            if (jsonStr.RESULT[0][0].MINUTOS > 0) {
              const segundos = jsonStr.RESULT[0][0].MINUTOS * 60000;
              if (ultimoInterval != 0) {
                clearInterval(ultimoInterval);
              }
              ultimoInterval = setInterval(() => {
                $(`#nav-dash-${id_dashboard}`).trigger('click');
              } , segundos);
            }
          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados dos dashboards.');
          }
        } finally {

        }
      }
      async function buscaDatasets(id_dashboard) {
        const _url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
          try {
            var response = await requisicao('GET', _url,
              `JSON={ "tabela":"dataset_web", "camposSelect":["id","nome","sql"], "where": ["id_dash = '${id_dashboard}'"] }&REPLACE_LINE_BREAK=true`,
              null);
            if (!response) {
              return;
            }
            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }

            arrDados.splice(0, arrGraficos.length);
            for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
              const dataset = jsonStr['RESULT'][0][i];
              $('#txtSelect').val(dataset.SQL);
              const dados = {}
              const sqlReplaced = $('#txtSelect').val()
                .replaceAll('&#013;', '\r\n')
                .replaceAll('  ', ' ')
                .replaceAll(':EMP_ID', getCookie('emp_id'))
                .replaceAll(':EMP_PAT', getCookie('empresa'))
                .replaceAll(':COD_USUARIO', getCookie('cod_usuario'));;
              dados.data = await rotinaValidarSQL(sqlReplaced),
                dados.id = dataset.ID,
                dados.nome = dataset.NOME
              arrDados.push(dados);
            }

          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados dos datasets.');
          }
        } finally {

        }
      }

      async function buscaGraficos(id_dashboard) {
        const _url = `/Sisplan/dashboard/v1/grafico?`;
        try {
          try {
            var response = await requisicao('GET', _url, `ID_DASH=${id_dashboard}`, null);
            if (!response) {
              return;
            }
            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }

            // arrGraficos.splice(0, arrGraficos.length);

            for (let i = 0; i < jsonStr.length; i++) {
              const grafico = jsonStr[i];
              grafico.DATASET = grafico.DATASET.replace('\r\n', '');
              const arrDataSets = grafico.DATASET.split(', ');
              grafico.DATASET_INFO = [];
              arrDataSets.forEach(element => {
                const nome_dataset = arrDados.find(dado => dado.id == element).nome;
                grafico.DATASET_INFO.push(nome_dataset);
              });

              switch (grafico.TIPO) {
                case 0:
                  await criaCard(grafico);
                  break;
                case 1:
                  await criaGrafico(grafico);
                  break;
                case 2:
                  await criaGrafico(grafico);
                  break;
                case 3:
                  await criaGrafico(grafico);
                  break;
                case 4:
                  await criaGrafico(grafico);
                  break;
                case 5:
                  await criaGrafico(grafico);
                  break;
                case 6:
                  await criaGrafico(grafico);
                  break;
                default:
                  break;
              }
              arrGraficos.push(grafico);
            }

          } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados dos gráficos.');
          }
        } finally {

        }
      }

      async function incrementaContador() {
        contadorGrafico++;
      }

      async function converteProporcaoEmTamanhoBootstrap(proporcao) {
        return parseInt(proporcao) * 2;
      }

      async function ajustaDadosDataSetMultiSerie(dados, totalDataSets) {
        function ordenaArray(array) {
          array.sort((a, b) => {
            if (a[2] > b[2]) {
              return 1;
            }
            if (a[2] < b[2]) {
              return -1;
            }
            return 0;
          })
        }

        const concatenacao = _.union(...dados);
        const arrConcatenado = concatenacao;
        ordenaArray(arrConcatenado);
        let arrNovoArray = [];
        for (let i = 0; i < arrConcatenado.length; i++) {
          const arrSeparado = arrConcatenado[i];
          const arrControleEixo = [];
          for (let y = 0; y < totalDataSets; y++) {
            const arrDadosAtual = dados[y];
            if (arrControleEixo.length == 0) {
              arrControleEixo.push(arrSeparado[0]);
            }
            const iPosicaoAtual = arrDadosAtual.findIndex(obj => {
              return obj[0] == arrSeparado[0];
            });
            if (iPosicaoAtual == -1) {
              arrControleEixo.push(0);
            } else {
              arrControleEixo.push(arrDadosAtual[iPosicaoAtual][1]);
            }
          }
          const iPosicaoNovoArray = arrNovoArray.findIndex(obj => {
            return obj[0] == arrSeparado[0];
          });

          if (iPosicaoNovoArray == -1) {
            arrNovoArray.push(arrControleEixo);
          }
        }
        arrNovoArray = _.groupBy(arrNovoArray, 0);
        arrNovoArray = _.map(arrNovoArray);
        return arrNovoArray;
      };

      async function utilizaGoogleCharts(dados, grafico) {
        const ordemDecrescente = grafico.TIPO_ORDENACAO == 0;
        const semOrdenacao = grafico.TIPO_ORDENACAO == -1;
        const tipoApresentacaoMonetario = grafico.TIPO_APRESENTACAO == 2;
        const tipoEhColuna = grafico.TIPO == 2;
        const formatoValor = tipoApresentacaoMonetario ? 'currency' : 'decimal';
        google.charts.setOnLoadCallback(drawChart);

        async function drawChart() {
          const arrDadosDataSets = [];
          const data = new google.visualization.DataTable();
          for (let i = 0; i < dados.length; i++) {
            const regAgrupados = [];
            const dataset = dados[i]; // numero de datasets
            for (let y = 0; y < dataset.length; y++) {
              let totGrupo = 0;
              const registros = dataset[y]; // array de registros por dataset
              for (let z = 0; z < registros.length; z++) {
                totGrupo += registros[z][grafico.VALOR];
                if (z == registros.length - 1) {
                  regAgrupados.push([String(registros[z][grafico.EIXO]), totGrupo, registros[z][grafico.CAMPO_ORDENACAO]]);
                }
              }
            }
            arrDadosDataSets.push(regAgrupados);
          }

          if (arrDadosDataSets.length > 1) {
            const arrTeste = await ajustaDadosDataSetMultiSerie(arrDadosDataSets, grafico.DATASET_INFO.length);
            let novoArray = [];
            const arrDadosFinais = [];

            data.addColumn('string', grafico.EIXO);
            for (let i = 0; i < arrDadosDataSets.length; i++) {
              data.addColumn('number', grafico.DATASET_INFO[i]);
            }
            novoArray = arrTeste;

            for (let i = 0; i < novoArray.length; i++) {
              const dataNovoArray = novoArray[i];
              const arrDadosAtuais = [];
              for (let y = 0; y < dataNovoArray.length; y++) {
                const registro = dataNovoArray[y];
                for (let z = 0; z < registro.length; z++) {
                  if (!((y != 0) && (z == 0))) { //nao repetir a legenda do dataset...
                    const dadoReg = registro[z];
                    arrDadosAtuais.push(dadoReg);
                  }
                }
              }
              while (arrDadosAtuais.length - 1 < grafico.DATASET_INFO.length) {
                arrDadosAtuais.push(0);
              }
              arrDadosFinais.push(arrDadosAtuais);
            }
            data.addRows(arrDadosFinais);
          } else {
            data.addColumn('string', grafico.EIXO);
            data.addColumn('number', grafico.VALOR);
            if (tipoEhColuna || tipoEhBarra || tipoEhLinha) {
              if (!semOrdenacao && ordemDecrescente) {
                arrDadosDataSets[0] = _.sortBy(arrDadosDataSets[0], 1).reverse();
              } else if (!semOrdenacao) {
                arrDadosDataSets[0] = _.sortBy(arrDadosDataSets[0], 1);
              }
            }

            if (grafico.MAX_REGISTROS > 0) {
              arrDadosDataSets[0].splice(grafico.MAX_REGISTROS, arrDadosDataSets[0].length);
            }
            arrDadosDataSets[0].map((dataset) => {
              dataset.splice(2, 1);
            });
            data.addRows(arrDadosDataSets[0]);
          }

          const view = new google.visualization.DataView(data);
          const options = {
            pieHole: grafico.TIPO == 5 ? 0.5 : 0,
            displayAnnotations: true,
            'backgroundColor': 'none',
            'width': '100%',
            'height': 250,
            'titleTextStyle': {
              color: '#FFF',
              fontSize: '15',
              fontName: '"Arial"'
            },
            'hAxis': {
              textStyle: {
                color: $('html').hasClass('theme-light') ? '#000000' : '#ffffff'
              },
              title: tipoEhColuna ? grafico.EIXO : grafico.VALOR,
              titleTextStyle: {
                color: '#FFF',
                fontSize: '15',
                fontName: '"Arial"'
              },
              color: 'red'
            },
            // legend: 'none',
            legend: {
              textStyle: {
                color: $('html').hasClass('theme-light') ? '#000000' : '#ffffff'
              }
            },
            'vAxis': {
              format: formatoValor,
              textStyle: {
                color: $('html').hasClass('theme-light') ? '#000000' : '#ffffff'
              },
              title: tipoEhColuna ? grafico.VALOR : grafico.EIXO,
              titleTextStyle: {
                color: '#FFF',
                fontSize: '15',
                fontName: '"Arial"'
              }
            },
            // colors: ['#1055A3'],
            annotations: {
              textStyle: {
                color: $('html').hasClass('theme-light') ? '#000000' : '#ffffff',
              }
            }
          };

          function retornaChart(tipoGrafico) {
            const tipoEhColuna = tipoGrafico == 2;
            const tipoEhBarra = tipoGrafico == 1;
            const tipoEhLinha = tipoGrafico == 3;
            const tipoEhPizza = tipoGrafico == 4;
            const tipoEhRosca = tipoGrafico == 5;
            if (tipoEhColuna) {
              return new google.visualization.ColumnChart(document.getElementById(`graf-${contadorGrafico}`));
            } else
            if (tipoEhBarra) {
              return new google.visualization.BarChart(document.getElementById(`graf-${contadorGrafico}`));
            } else
            if (tipoEhLinha) {
              return new google.visualization.LineChart(document.getElementById(`graf-${contadorGrafico}`));
            } else
            if (tipoEhPizza) {
              return new google.visualization.PieChart(document.getElementById(`graf-${contadorGrafico}`));
            } else
            if (tipoEhRosca) {
              return new google.visualization.PieChart(document.getElementById(`graf-${contadorGrafico}`));
            }
          }

          const chart = retornaChart(grafico.TIPO);
          chart.draw(view, options);
          $(window).resize(function() {
            chart.draw(view, options);
          });
        }
      }

      async function criaGrafico(grafico) {
        const TOTAL_GRAFICO_NAO_UTILIZADO = 0;
        const dadosGraf = await montaDadosGrafico(grafico);
        const tam = await converteProporcaoEmTamanhoBootstrap(grafico.PROPORCAO);
        await incrementaContador();
        await insereGraficoNoPainel(TOTAL_GRAFICO_NAO_UTILIZADO, grafico, tam);
        if (grafico.TIPO != 6) {
          await utilizaGoogleCharts(dadosGraf, grafico);
        } else {
          await criaGrid(dadosGraf, grafico);
        }
      }


      async function criaGrid(dados, grafico) {
        const ordemDecrescente = grafico.TIPO_ORDENACAO == 0;
        const semOrdenacao = grafico.TIPO_ORDENACAO == -1;
        const tipoApresentacaoInteiro = grafico.TIPO_APRESENTACAO == 0;
        const tipoApresentacaoDecimal = grafico.TIPO_APRESENTACAO == 1;
        const tipoApresentacaoMonetario = grafico.TIPO_APRESENTACAO == 2;
        const formatoValor = tipoApresentacaoMonetario ? 'currency' : 'decimal';
        const local = $(`#graf-${contadorGrafico}`);
        const keys = grafico.EIXO.replaceAll(' ', '').split(',')
        const dataSetCols = [];

        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k].toUpperCase(),
            'data': keys[k]
          });
        }
        local.html(`<div class="table-responsive p-2"><table class="table table-sm" id="tabela-${contadorGrafico}"><thead></thead><tbody></tbody></table></div>`)
        criaDataTablePadrao(`#tabela-${contadorGrafico}`, false, false, false, false, true, true, '210px', dados[0][0], dataSetCols, []);
        $(`#tabela-${contadorGrafico}`).DataTable().columns.adjust().draw(false);

      }

      async function somaRegistros(dados, grafico) {
        let totGrupo = 0;
        for (let i = 0; i < dados.length; i++) {
          const grupos = dados[i];
          for (let y = 0; y < grupos.length; y++) {
            const registro = grupos[y];
            totGrupo += registro[grafico.VALOR];
          }
        }
        return totGrupo;
      }

      async function mediaRegistros(dados, grafico) {
        let totGrupo = 0;
        for (let i = 0; i < dados.length; i++) {
          const grupos = dados[i];
          for (let y = 0; y < grupos.length; y++) {
            const registro = grupos[y];
            totGrupo += registro[grafico.VALOR];
          }
        }
        return totGrupo / dados.length;
      }

      async function maximoRegistros(dados, grafico) {
        let totGrupo = 0;
        for (let i = 0; i < dados.length; i++) {
          const grupos = dados[i];
          for (let y = 0; y < grupos.length; y++) {
            const registro = grupos[y];
            if (totGrupo < registro[grafico.VALOR]) {
              totGrupo = registro[grafico.VALOR];
            }
          }
        }
        return totGrupo;
      }

      async function minimoRegistros(dados, grafico) {
        let totGrupo = 0;
        for (let i = 0; i < dados.length; i++) {
          const grupos = dados[i];
          for (let y = 0; y < grupos.length; y++) {
            const registro = grupos[y];
            if (totGrupo == 0 || totGrupo > registro[grafico.VALOR]) {
              totGrupo = registro[grafico.VALOR];
            }
          }
        }
        return totGrupo;
      }

      async function contaRegistros(grafico) {
        const indice = parseInt(grafico.DATASET.split(', ')[0]);
        return arrDados.find(dado => dado.id == indice).data.length;
      }

      async function retornaHtmlCard(total, grafico, tam) {
        const tipoApresentacaoInteiro = grafico.TIPO_APRESENTACAO == 0;
        const tipoApresentacaoDecimal = grafico.TIPO_APRESENTACAO == 1;
        const tipoApresentacaoMonetario = grafico.TIPO_APRESENTACAO == 2;
        let valorFormatado;
        if (tipoApresentacaoInteiro) {
          valorFormatado = parseInt(total)
        } else if (tipoApresentacaoDecimal) {
          valorFormatado = total.toLocaleString('pt-BR')
        } else if (tipoApresentacaoMonetario) {
          valorFormatado = 'R$ ' + total.toLocaleString('pt-BR')
        }

        const html = `<div class="col-lg-${tam} col-12 animate__animated animate__fadeIn" id="card-${contadorGrafico}">
                            <div class="small-box bg-info">
                              <div class="inner">
                                <h3>${valorFormatado}</h3>
                                <p>${grafico.NOME}</p>
                              </div>
                              <div class="icon">
                                <i class="ion ion-bag"></i>
                              </div>
                              <a href="" id="info-${contadorGrafico}" class="small-box-footer">Mais Informações 
                                <i class="fas fa-arrow-circle-right"></i>
                              </a>
                             </div>
                          </div> `;
        return html;
      }

      async function retornaHtmlGraficoBarraEColuna(total, grafico, tam) {
        const html = `<div class="col-lg-${tam} col-12 animate__animated animate__fadeIn">
                            <div class="card">
                              <div class="card-header bg-info">
                                <h3 class="card-title">${grafico.NOME}</h3>

                                <div class="card-tools">
                                  <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i>
                                  </button>
                                </div>
                              </div>
                              <div class="card-body">
                                <div id="graf-${contadorGrafico}">
                                </div>
                              </div>
                            </div>
                          </div> `;
        return html;
      }

      async function MostraModalInfo(grafico, dados) {
        if (!dados || dados.length === 0) {
          return;
        }
        var keys = Object.keys(dados[0]);
        let dataSetCols = [];
        for (var k in keys) {
          dataSetCols.push({
            'title': keys[k],
            'data': keys[k]
          });
        }
        const htmlTable =
          `<table width="100%" style="width:100%" id="table-info-card" class="table table-sm table-condensed table-select table-hover"></table>`
        $('#modal-info-table').html(htmlTable);
        $('#modal-info-title').html(grafico.NOME);
        $('#table-info-card').DataTable({
          paging: true,
          filter: false,
          info: true,
          order: true,
          destroy: true,
          autowidth: true,
          dom: 'Bfrtip',
          buttons: [{
              "extend": 'excel',
              "text": 'Exportar Excel',
              "className": 'btn btn-primary btn-sm btn-sisp',
              "title": `Dashboard - ${grafico.NOME}`
            },
            {
              alignment: "center",
              "extend": 'pdf',
              "text": 'Exportar PDF',
              "className": 'btn btn-secondary btn-sm btn-sisp',
              customize: function(doc) {
                doc.styles.tableBodyEven.alignment = 'center';
                doc.styles.tableBodyOdd.alignment = 'center';
                doc.content[1].table.widths =
                  Array(doc.content[1].table.body[0].length + 1).join('*').split('');
              },
              "title": `Dashboard - ${grafico.NOME}`
            }
          ],
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar (geral): ",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          "data": dados,
          "columns": dataSetCols
        });

        $('#modal-info').modal('show');
        $('#table-info-card').DataTable().columns.adjust().draw(false);

      }

      async function insereGraficoNoPainel(total, grafico, tam) {
        const [graficoTipoCard, graficoTipoBarra, graficoTipoColuna] = [grafico.TIPO == 0, grafico.TIPO == 1,
          grafico.TIPO == 2
        ];
        const html = graficoTipoCard ? await retornaHtmlCard(total, grafico, tam) :
          await retornaHtmlGraficoBarraEColuna(total, grafico, tam);
        $('#conteudo').append(html);
        if (graficoTipoCard) {
          $(`#info-${contadorGrafico}`).on('click', async function() {
            window.event.preventDefault();
            const id = parseInt($(this).attr('id').split('-')[1]);
            const grafico = arrGraficos[id - 1];
            const dados = arrDados.find(dado => dado.id == grafico.DATASET.split(', ')[0]);
            await MostraModalInfo(grafico, dados.data);
            return;
          });
        }
      }

      async function criaCard(grafico) {
        const [tipoValorSoma, tipoValorMedia, tipoValorMaximo, tipoValorMinimo, tipoValorContagem,
          tipoValorContagemDistinta
        ] = [grafico.TIPO_VALOR == 0, grafico.TIPO_VALOR == 1, grafico.TIPO_VALOR == 2, grafico.TIPO_VALOR ==
          3, grafico.TIPO_VALOR == 4, grafico.TIPO_VALOR == 5
        ];
        const dadosGraf = await montaDadosGrafico(grafico);
        await incrementaContador();
        const tam = await converteProporcaoEmTamanhoBootstrap(grafico.PROPORCAO);
        let total = 0;
        if (tipoValorSoma) {
          total = await somaRegistros(dadosGraf[0], grafico);
        } else
        if (tipoValorContagem || tipoValorContagemDistinta) {
          total = await contaRegistros(grafico);
        } else
        if (tipoValorMedia) {
          total = await mediaRegistros(dadosGraf[0], grafico);
        } else
        if (tipoValorMaximo) {
          total = await maximoRegistros(dadosGraf[0], grafico);
        } else
        if (tipoValorMinimo) {
          total = await minimoRegistros(dadosGraf[0], grafico);
        }
        await insereGraficoNoPainel(total, grafico, tam);
      }

      async function rotinaValidarSQL(sql) {
        const _url = `/sisplan/funcoes/v1/EditorSQL?`;
        try {
          try {
            var response = await requisicao('POST', _url, '',
              `JSON=${encodeURIComponent(sql)}`, null);

            if (!response) {
              return;
            }

            var jsonStr = await response.json();
            if (response.status === 400) {
              msgErro(jsonStr.mensagem);
              return;
            } else
            if (response.status === 202) {
              return [];
            }

            return jsonStr;
          } catch (error) {
            console.error(error);
            msgErro('Erro ao validar sql.');
          }
        } finally {}
      }

      async function criaAviso(sMensagem) {
        if ($('#card-carregando').hasClass('d-none')) {
          await $('#card-carregando').removeClass('d-none');
        }
        await $('#card-carregando h5').html(sMensagem);

      }

      async function destroiAviso() {
        await $('#card-carregando').addClass('d-none');
        await $('#card-carregando h5').html('');
      }

      async function montaDadosGrafico(grafico) {
        const tipoEhCard = grafico.tipo == '0';
        const {
          TIPO: tipo,
          EIXO: eixo,
          VALOR: valor,
          CAMPO_ORDENACAO: ordenacao
        } = grafico;
        const arrDataSets = grafico.DATASET.split(', ');
        let arrRetorno = [];
        arrDataSets.forEach(dataset => {
          const arrayDados = arrDados.find(dado => dado.id == dataset).data;
          let dadosNovos = [];
          dadosNovos = _.sortBy(arrayDados, eixo);
          if (tipoEhCard) {
            dadosNovos = _.groupBy(dadosNovos, ''); //agrupa pelo indice do EIXO
          } else {
            dadosNovos = _.groupBy(dadosNovos, eixo); //agrupa pelo indice do EIXO
          }
          dadosNovos = _.map(dadosNovos); //mapea o objeto como array
          arrRetorno.push(dadosNovos);
        });
        return arrRetorno;
      }

      // mostrar dashboardas liberados para o usuário
      // auto clicar no primeiro
      // no clique fazer o carregamento dos gráficos/datasets

      async function carregaDashboardCompleto(id_dashboard) {
        try {
          $('#conteudo').html(`<div class="col-sm-12">
              <textarea id="txtSelect" class="d-none" rows="10" placeholder="Monte o SQL aqui"></textarea>
              <div id="resultados" class="col-sm-12 table-responsive d-none">
              </div>
            </div>`);
          await buscaDashboard(id_dashboard);
          await criaAviso('Carregando Dados');
          await buscaDatasets(id_dashboard);
          await buscaGraficos(id_dashboard);

        } finally {
          await destroiAviso();
        }
      }

      buscaDashboardsLiberados();


    });
  </script>
</body>

</html>