$('#tutorial').on('click', function () {
	$(document).ready(async function () {
		const driver = new Driver({
			doneBtnText: 'Sair',
			closeBtnText: 'Fechar',
			nextBtnText: 'Próximo',
			prevBtnText: 'Anterior',
			allowClose: false
		});

		driver.defineSteps([{
			element: '#divFiltros',
			popover: {
				title: 'Filtros',
				description: 'Aqui estão os campos disponíveis de filtro, botão de consultar e imprimir os dados.',
				position: 'botton'
			}
		},
		{
			element: '#divTabela',
			popover: {
				title: 'Consignados/vendas',
				description: 'Aqui você seleciona os consignados/vendas que deseja conferir/devolver.',
				position: 'top'
			}
		},
		{
			element: '#btnDevolver',
			popover: {
				title: 'Devolver Parcial',
				description: 'Faça a devolução por esse botão quando o cliente quiser devolver itens porém sem dar por finalizado o(s) consignado(s), dessa forma será criado apenas uma venda de devolução com os itens devolvidos, podendo finalizar o(s) consignado(s) posteriormente através do botão Conferir.',
				position: 'top'
			}
		},
		{
			element: '#btnConferir',
			popover: {
				title: 'Conferir/Finalizar',
				description: 'Utilize esse botão quando quiser finalizar o(s) consignado(s), tendo a opção de devolver itens que o cliente não ficou e gerar uma nova venda com apenas os itens que o cliente ficou.',
				position: 'top'
			}
		}, {
			element: '#divTotais',
			popover: {
				title: 'Totalizadores',
				description: 'Aqui você pode acompanhar os totalizadores conforme os dados consultados em tela',
				position: 'top'
			}
		}
		]);

		driver.start();

		const activeElement = driver.getHighlightedElement();
	});
});

$(document).ready(async function () {

	const permissaoUsuarioLogado = await permissaoAcessos("AGRUPAMENTO_VENDA");
	await setarDataAtual('dtInicio');
	await setarDataAtual('dtFim');
	const parametrosVenda = await BuscaParametrosVenda();
	const utilizaBarraLog = parametrosVenda[46] === '1';
	let listaBarrasBipadas = [];
	let listaBarrasNaoBipadas = [];

	let quantidadeCasasDecimaisParametro = await CopiaParametro('SISTEMA', 1);
	let quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;

	let response = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"PERMISSOES_TELA","camposSelect":["PERMISSAO"], "where": ["USUARIO = '${getCookie("cod_usuario")}' AND EMP_ID = ${getCookie("emp_id")} AND TELA = 'AGRUPAMENTO_VENDA' AND ACAO = 'CHECK_CONFERENCIA_CONSIGNADO'"]}`, null);

	if (!response || response.status != 200) {
		return;
	}

	let jsonStr = await response.json();

	let podeAlterarCheck;
	if (jsonStr.RESULT[0].length > 0) {
		podeAlterarCheck = jsonStr.RESULT[0][0].PERMISSAO == "S";
	} else {
		podeAlterarCheck = false;
	}

	criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '300px');
	function retornaPrimeiroDia() {
    const agora = new Date();
    const primeiroDia = new Date(agora.getFullYear(), agora.getMonth(), 1);
    return primeiroDia;
	}


	$('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
	$('#btnCliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["ativo = 'S'"]}`, 'Pesquisa Cliente');
	// $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
	// $('#btnCliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Cliente');
	$('#btnACliente').on('click', function () { $('#txtCliente').val(''); });

	// $('#txtCaixa').listaFiltros();
	$('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
	$('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
	$('#btnLimpaCaixa').on('click', function () { $('#txtCaixa').val(''); });
	$('#txtTipoVendaFiltro').autocompleta(1, `JSON={ "tabela":"VENDA_TIPO", "camposSelect":["ID CHAVE, DESCRICAO DESCRICAO"], "where": []}`);
	$('#btnPesquisaTipoVenda').pesquisa('#txtTipoVendaFiltro', 'ID', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID", "DESCRICAO"], "where": null}', 'Pesquisa Tipo Venda', 'VENDA_TIPO');
  $('#btnLimpaTipoVenda').on('click', function() {
		$('#txtTipoVendaFiltro').val('');
	});

	$('#txtCliente').focus();

	async function buscarDados(sCodcli, sDtIni, sDtFim, sCaixa, stipoVenda) {
		$.LoadingOverlay("show");
		try {
			const pesquisaParam = {
				tabela: 'VENDA',
				camposSelect: ['VENDA.CODVEN', 'VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.VALOR',
					`VENDA.VALOR - (SELECT COALESCE(SUM(VALOR*QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDADEV.EMP_ID AND ITVENDADEV.CANCELADO = 'N' )  VALOR_RESTANTE`,
					'SUM(ITVENDA.QUANTIDADE) QUANTIDADE',
					`(SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDADEV.EMP_ID AND ITVENDADEV.CANCELADO = 'N') QTDE_DEV`,
					`SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = VENDA.CODVEN AND VENDA.EMP_ID = ITVENDADEV.EMP_ID AND ITVENDADEV.CANCELADO = 'N') QUANT_RESTANTE`,
					'VENDA.TIPO_VENDA','VENDA_TIPO.DESCRICAO DESC_TIPO_VENDA'
				],
				leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' },
				{ tabela: 'ITVENDA', condicao: 'ITVENDA.CODVEN = VENDA.CODVEN AND ITVENDA.EMP_ID = VENDA.EMP_ID' },
				{ tabela: 'VENDA_TIPO', condicao: 'VENDA.TIPO_VENDA = VENDA_TIPO.ID' }
				],
				where: [`VENDA.CODCLI = '${sCodcli}' AND VENDA.DATA >= '${sDtIni}' AND VENDA.DATA <= '${sDtFim}' AND VENDA.NRCAIXA = '${sCaixa}' AND VENDA.FECHADA = 0 AND VENDA.CANCELADA = 0 AND VENDA.DEVOLUCAO=0 AND VENDA.EMP_ID= ${getCookie('emp_id')} AND VENDA_TIPO.ESTOQUE = 'S'`],
				groupBy: ['VENDA.CODVEN', 'VENDA.EMP_ID', 'VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.VALOR', 'VENDA.TIPO_VENDA', 'VENDA_TIPO.DESCRICAO']
			};

			if (stipoVenda != ''){
				pesquisaParam.where.push(`VENDA.TIPO_VENDA = ${stipoVenda}`); 	
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			const totalDevolvido = jsonStr.reduce((total, vendas) => { return total += vendas.QTDE_DEV }, 0);
			$('#txtTotalDevolucao').val(totalDevolvido);
			return jsonStr;
		} finally {
			$.LoadingOverlay("hide");
		}
	};

	$('#check_todos').on('change', function () {
		$('.campoSel').prop('checked', $('#check_todos').prop('checked'));
		if ($('#check_todos').prop('checked')) {
			$('.campoSel').addClass('selecionado');
		} else {
			$('.campoSel').removeClass('selecionado');
		}
		atualizaTotaisSelecionados();
	});

	$("#btnConsultar").on("keydown", async function (event) {
		if (event.key == "Enter") {
			$("#btnConsultar").trigger("click");
		}
	});

	$('#btnConsultar').on('click', async function () {
		$('#tabelaVendas').empty();
		const codcli = pegaChave('#txtCliente');
		const dtIni = $('#dtInicio').val();
		const dtFim = $('#dtFim').val();
		// const nrCaixa = await formataListas($('#listaCaixa').val());
		const nrCaixa = pegaChave('#txtCaixa');
		const tipoVenda = pegaChave('#txtTipoVendaFiltro');

		if ([codcli, dtIni, dtFim, nrCaixa].includes('')) {
			msgAlerta('Necessário preencher todos os dados.');
			return;
		}

		const dados = await buscarDados(codcli, dtIni, dtFim, nrCaixa, tipoVenda);

		if (dados.length == 0) {
			msgAlerta('Nenhuma venda encontrada, favor verificar.');
			return;
		}

		let dataSetCols = [];

		let keys = Object.keys(dados[0]);
		dataSetCols.push({
			'title': 'SEL',
			'data': 'SEL',
			'width': '15px'
		});

		dataSetCols[0].render = function (data, type, row, meta) {
			return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
		}

		for (var k in keys) {
			dataSetCols.push({
				'data': keys[k]
			});
		}
		criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '300px', dados, dataSetCols, [], [], [], [4, 5]);

		$('.campoSel').on('change', function () {
			if (this.checked) {
				$(this).addClass('selecionado');
			} else {
				$(this).removeClass('selecionado');
			}
			$('#check_todos').prop('checked', $('.campoSel').length == $('.selecionado').length);
			atualizaTotaisSelecionados();
		});
	});

	function atualizaTotaisSelecionados() {
		let quantidade = 0;
		let valor = 0;
		let quantidadeRestante = 0;
		let valorRestante = 0;
		for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
			if ($('#check_col_' + i + '_row_0').prop('checked')) {
				quantidade += $('#tabelaVendas').DataTable().row(i).data().QUANTIDADE;
				valor += $('#tabelaVendas').DataTable().row(i).data().VALOR;
				quantidadeRestante += $('#tabelaVendas').DataTable().row(i).data().QUANT_RESTANTE;
				valorRestante += $('#tabelaVendas').DataTable().row(i).data().VALOR_RESTANTE;
			}
		}
		$('#txtTotalQuantSelec').val(quantidade);
		$('#txtTotalValorSelec').val(TruncaDecimaisNova(2, valor));
		$('#txtTotalQuantRestante').val(quantidadeRestante);
		$('#txtTotalValorRestante').val(TruncaDecimaisNova(2, valorRestante));
	}

	async function retornaFiltros() {
		try {
			const cliente = pegaChave('#txtCliente');
			const dataIni = $('#dtInicio').val();
			const dataFim = $('#dtFim').val();
			const tipoVenda = pegaChave('#txtTipoVendaFiltro');
			// const nrCaixa = await formataListas($('#listaCaixa').val())
			const nrCaixa = pegaChave('#txtCaixa');

			const retorno =
				`CLIENTE=${cliente}` +
				`&DATAINI=${dataIni}` +
				`&CAIXA=${nrCaixa}` +
				`&EMP_ID=${getCookie('emp_id')}` +
				`&DATAFIM=${dataFim}`+
				`&TIPO_VENDA=${tipoVenda}`;
			return retorno;
		} catch (error) {
			console.error(error);
		}
	}

	$('#btnLojaPrincipal').on('click', function () {
		window.location.href = `${BASE_URI}/loja`;
	});

	$('#btnImprimir').on('click', async function () {
		await imprimirAgrupamento();
	});

	async function imprimirAgrupamento() {
		try {
			$.LoadingOverlay('show');
			try {
				if ($('#txtCliente').val() == '') {
					msgAlerta('Necessário preencher os dados');
					return;
				}
				let url = `/sisplan/impressao/v1/agrupamentoconsig?`;
				const dados = await retornaFiltros();
				const bImprimeAutomatico = await verificaImprimirAutomatico('AgrupamentoConsig');
				let arquivo = await GeraRelatorio(`${url}${dados}`, 'GET', 1000000, false, 'AgrupamentoConsig');
				if (arquivo != undefined) {
					if (!bImprimeAutomatico) {
						window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
					}
					await limparRelatorios();
				}

			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	$('#btnConferir').on('click', async function () {
		if (permissaoUsuarioLogado.INCLUI == 'S') {
			const arrVendas = [];
			for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
				if ($('#check_col_' + i + '_row_0').prop('checked')) {
					arrVendas.push({
						CODIGO: $('#tabelaVendas').DataTable().row(i).data().CODVEN,
						TIPO_VENDA: $('#tabelaVendas').DataTable().row(i).data().TIPO_VENDA,
					});
				}
			}

			if (arrVendas.length == 0) {
				msgAlerta('Nenhuma venda selecionada, favor verificar.');
				return;
			}

			const tiposDiferentes = arrVendas.filter((venda) => venda.TIPO_VENDA !== arrVendas[0].TIPO_VENDA).length > 0;
			if (tiposDiferentes) {
				msgAlerta('Os tipos de venda devem ser iguais');
				return;
			}

			const ListaNumeroVendas = arrVendas.map((venda) => venda.CODIGO);

			if (arrVendas[0].TIPO_VENDA == 1) {
				await preencheConferenciaVenda(ListaNumeroVendas);
			} else {
				await preencheConferenciaConsignado(ListaNumeroVendas);
				$('#txtTotalConferido').val(0);
				$('#txtValorTotalConferido').val(0);
			}
		} else {
			msgAlertaSemConfirmacao("Sem permissão para incluir!");
		}
	});

	$('#btnDevolver').on('click', async function () {
		let bConsignado = false;
		for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
			if ($('#check_col_' + i + '_row_0').prop('checked')) {
				if ($('#tabelaVendas').DataTable().row(i).data().DESC_TIPO_VENDA == 'CONSIGNADO') {
					bConsignado = true;
					break;
				}
			}
		}

		if (!bConsignado) {
			msgAlerta('Não é possível devolver Vendas por aqui, apenas consignados.');
			return;
		}

		if ((!bConsignado) || (parametrosVenda[73] == 0) || (parametrosVenda[73] == undefined)) {
			await abreTelaDevolucao();
			$('#txtTotalDevolvido').val(0);
			$('#txtValorTotalDevolvido').val(0);
		} else if (parametrosVenda[73] == 1) {
			senhaSupervisor('Para devolução de consignado, ', async () => {
				await abreTelaDevolucao();
				$('#txtTotalDevolvido').val(0);
				$('#txtValorTotalDevolvido').val(0);
			})
		} else if (parametrosVenda[73] == 2) {
			msgAlerta('Não é possível fazer devolução de consignados!');
		}
	});

	async function barraJaEstaBipada(sBarra) {
		try {
			if (listaBarrasBipadas.find(item => item.barra === sBarra)) {
				msgErro(`Barra ${sBarra} já lida, verifique.`);
				return true;
			}
			return false;
		} catch (error) {
			console.error('barra_log', error);
			msgErro('Erro ao processar barra log.');
			return false;
		}
	}

	async function retornaBarraLogLida(sBarra) {
		try {
			const url = `/sisplan/barralog/v1/validarbarra?`;
			const params = `barra=${encodeURIComponent(sBarra)}`;
			const response = await requisicao('GET', url, params, 15000);

			if (!response) {
				return;
			}

			jsonStr = await response.json();
			if (response.status != 200) {
				return jsonStr.mensagem;
			}

			return jsonStr.mensagem;
		} catch (error) {
			console.error(error);
		}
	}

	async function adicionaBarraBipada(objItem) {
		try {
			const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
			if (['barra_log'].includes(retornoBarraLog)) {
				listaBarrasBipadas.push(objItem);
				listaBarrasNaoBipadas = listaBarrasNaoBipadas.filter(barra => objItem.barra != barra.barra);
			}
		} catch (error) {
			console.error(error);
		}
	}

	// executa após definicao das rotinas
	if (localStorage.getItem('@venda.cliente')) {
    const dadosCli = localStorage.getItem('@venda.cliente');
		const nomeCli = localStorage.getItem('@venda.cliente_nome');
		const dadosCaixa = localStorage.getItem('@venda.caixa');
  	insereValor('#txtCliente', dadosCli, nomeCli);
		insereValor('#txtCaixa', dadosCaixa);
		const primeiroDia = retornaPrimeiroDia();
    const dia01 = primeiroDia;
    const dia01ISO = dia01.toISOString();
    const dia01String = dia01ISO.substr(0, 10);
    $('#dtInicio').val(dia01String);
    $('#dtFim').val('2500-12-31');
    localStorage.removeItem("@venda.cliente");
		localStorage.removeItem("@venda.caixa");
		localStorage.removeItem("@venda.cliente_nome");
    $('#btnConsultar').trigger('click');
  }

	async function abreTelaDevolucao() {
		$.LoadingOverlay("show");
		try {
			const arrVendas = [];
			for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
				if ($('#check_col_' + i + '_row_0').prop('checked')) {
					arrVendas.push($('#tabelaVendas').DataTable().row(i).data().CODVEN);
				}
			}

			if (arrVendas.length == 0) {
				msgAlerta('Nenhuma venda selecionada, favor verificar.');
				return;
			}

			const pesquisaParam = {
				tabela: 'ITVENDA',
				camposSelect: [
					'ITVENDA.CODVEN VENDA', 'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
					'ITVENDA.COR', 'ITVENDA.TAM', `SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = ITVENDA.CODVEN ` +
					`AND ITVENDA.CODIGO = ITVENDADEV.CODIGO ` +
					`AND ITVENDA.COR = ITVENDADEV.COR ` +
					`AND ITVENDA.TAM = ITVENDADEV.TAM ` +
					`AND ITVENDA.QUALIDADE = ITVENDADEV.QUALIDADE ` +
					`AND ITVENDA.LOTE = ITVENDADEV.LOTE ` +
					`AND ITVENDA.EMP_ID = ITVENDADEV.EMP_ID ` +
					`AND ITVENDADEV.CANCELADO = 'N') QTDE`,
					`0 QTDE_DEV`, `0 QTD_DEV`, 'ITVENDA.TIPO', 'ITVENDA.BARRA BARRA_LOJA', 'ITVENDA.LOTE',
					`CASE ITVENDA.TIPO WHEN 'P' THEN PA_ITEN.ID_PA_ITEN ELSE MAT_ITEN.ID_MAT_ITEN END ID`, 'ITVENDA.PRECO_LIQ VALOR',
					'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				],
				leftJoin: [
					{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
					{ tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = ITVENDA.CODIGO AND PA_ITEN.COR = ITVENDA.COR AND PA_ITEN.TAM = ITVENDA.TAM AND PA_ITEN.LOTE = ITVENDA.LOTE AND PA_ITEN.DEPOSITO = ITVENDA.DEPOSITO AND PA_ITEN.TIPO = ITVENDA.QUALIDADE' },
					{ tabela: 'MAT_ITEN', condicao: 'MAT_ITEN.CODIGO = ITVENDA.CODIGO AND MAT_ITEN.COR = ITVENDA.COR AND MAT_ITEN.LOTE = ITVENDA.LOTE AND MAT_ITEN.DEPOSITO = ITVENDA.DEPOSITO' }
				],
				where: [`ITVENDA.CODVEN IN (${arrVendas.toString()}) AND ITVENDA.EMP_ID = ${getCookie('emp_id')}`],
				groupby: [
					'ITVENDA.CODVEN', 'ITVENDA.EMP_ID', 'ITVENDA.CODIGO', 'PRODUTO.DESCRICAO', 'MATERIAL.DESCRICAO', 'ITVENDA.COR', 'ITVENDA.TAM', 'ITVENDA.TIPO', 'ITVENDA.BARRA', 'ITVENDA.LOTE', 'PA_ITEN.ID_PA_ITEN', 'MAT_ITEN.ID_MAT_ITEN',
					'ITVENDA.PRECO_LIQ', 'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				]
			}

			let jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			if (jsonStr && jsonStr.length > 0) {
				$('#txtVendasDev').val(arrVendas.toString().replaceAll(',', ', '));

				let dataSetCols = [];
				const keys = Object.keys(jsonStr[0]);
				for (var k in keys) {
					if (keys[k].toUpperCase() == 'DESCRICAO') {
						dataSetCols.push({
							'title': keys[k],
							'data': keys[k],
							'width': '100px'
						});
					} else {
						dataSetCols.push({
							'title': keys[k],
							'data': keys[k]
						});
					}
				};
				let i = 0;
				jsonStr.forEach(dado => {
					dado.QTD_DEV = `<input type="text" class="input-default focus form-control qtdeDev" id="qtdeDev_${i}" value="0">`;
					i++;
				});

				criaDataTablePadrao('#tabelaDevolucao', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [6, 8, 9, 10, 11, 12, 13, 14, 17, 18]);
				await carregaBarrasLog();

				i = 0;
				jsonStr.forEach(dado => {
					if (dado.TIPO == 'M') {
						$(`#qtdeDev_${i}`).maskMoney({
							decimal: ".",
							thousands: "",
							precision: quantidadeCasasDecimaisCampo,
						});
					} else {
						$(`#qtdeDev_${i}`).maskMoney({
							decimal: ".",
							thousands: "",
							precision: 0,
						});
					}
					i++;
				});

				adicionaFocusout('.qtdeDev');
			}

			$('#modalDevolucao').modal('show');
			$("#tabelaDevolucao").DataTable().columns.adjust().draw(false);

		} finally {
			$.LoadingOverlay("hide");
			$('#txtBarra').focus();
		}
	};

	function adicionaFocusout(input) {
		let itens = $(input);
		for (let index = 0; index < itens.length; index++) {
			const element = itens[index];
			$(`#${element.id}`).on('focusout', async function () {
				await confereBarraDevDig(this);
			});
		}
	}

	async function preencheConferenciaConsignado(arrVendas) {
		$.LoadingOverlay("show");
		try {
			const pesquisaParam = {
				tabela: 'ITVENDA',
				camposSelect: [
					'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
					'ITVENDA.COR', 'ITVENDA.TAM', `SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = ITVENDA.CODVEN AND ITVENDADEV.EMP_ID = ${getCookie('emp_id')} ` +
					`AND ITVENDA.CODIGO = ITVENDADEV.CODIGO ` +
					`AND ITVENDA.COR = ITVENDADEV.COR ` +
					`AND ITVENDA.TAM = ITVENDADEV.TAM ` +
					`AND ITVENDA.QUALIDADE = ITVENDADEV.QUALIDADE ` +
					`AND ITVENDA.LOTE = ITVENDADEV.LOTE ` +
					`AND ITVENDA.EMP_ID = ITVENDADEV.EMP_ID ` +
					`AND ITVENDADEV.CANCELADO = 'N') QTDE`,
					`0 QTDE_CONF`, 'ITVENDA.TIPO', 'ITVENDA.BARRA BARRA_LOJA', 'ITVENDA.LOTE',
					`CASE ITVENDA.TIPO WHEN 'P' THEN PA_ITEN.ID_PA_ITEN ELSE MAT_ITEN.ID_MAT_ITEN END ID`, 'ITVENDA.PRECO_LIQ VALOR',
					'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				],
				leftJoin: [
					{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
					{ tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = ITVENDA.CODIGO AND PA_ITEN.COR = ITVENDA.COR AND PA_ITEN.TAM = ITVENDA.TAM AND PA_ITEN.LOTE = ITVENDA.LOTE AND PA_ITEN.DEPOSITO = ITVENDA.DEPOSITO AND PA_ITEN.TIPO = ITVENDA.QUALIDADE' },
					{ tabela: 'MAT_ITEN', condicao: 'MAT_ITEN.CODIGO = ITVENDA.CODIGO AND MAT_ITEN.COR = ITVENDA.COR AND MAT_ITEN.LOTE = ITVENDA.LOTE AND MAT_ITEN.DEPOSITO = ITVENDA.DEPOSITO' }
				],
				where: [`ITVENDA.CODVEN IN (${arrVendas.toString()}) AND ITVENDA.EMP_ID = ${getCookie('emp_id')}`],
				groupby: [
					'ITVENDA.EMP_ID', 'ITVENDA.CODIGO', 'PRODUTO.DESCRICAO', 'MATERIAL.DESCRICAO', 'ITVENDA.COR', 'ITVENDA.TAM', 'ITVENDA.TIPO', 'ITVENDA.BARRA', 'ITVENDA.LOTE', 'PA_ITEN.ID_PA_ITEN', 'MAT_ITEN.ID_MAT_ITEN',
					'ITVENDA.PRECO_LIQ', 'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', 'ITVENDA.CODVEN'
				]
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

			$('#txtVendas').val(arrVendas.toString().replaceAll(',', ', '));

			let dataSetCols = [];
			const keys = Object.keys(jsonStr[0]);
			for (var k in keys) {
				if (keys[k].toUpperCase() == 'DESCRICAO') {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k],
						'width': '100px'
					});
				} else {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k]
					});
				}
			};

			criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [7, 8, 9, 10, 11, 12, 15, 16]);
			await carregaBarrasLog();

			$('#modalConferencia').modal('show');
			$("#tabelaItens").DataTable().columns.adjust().draw(false);

			if (!podeAlterarCheck) {
				$("#checkConsig").prop("disabled", true);
			}

		} finally {
			$.LoadingOverlay("hide");
			$('#txtBarra').focus();
		}
	};

	async function preencheConferenciaVenda(arrVendas) {
		$.LoadingOverlay("show");
		try {

			const pesquisaParam = {
				tabela: 'ITVENDA',
				camposSelect: [
					'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
					'ITVENDA.COR', 'ITVENDA.TAM', //`ITVENDA.QUANTIDADE QTDE`,
					`SUM(ITVENDA.QUANTIDADE) - (SELECT COALESCE(SUM(QUANTIDADE),0) FROM [ITVENDA] ITVENDADEV WHERE ITVENDADEV.CODVENORIG = ITVENDA.CODVEN AND ITVENDADEV.EMP_ID = ${getCookie('emp_id')} ` +
					`AND ITVENDA.CODIGO = ITVENDADEV.CODIGO ` +
					`AND ITVENDA.COR = ITVENDADEV.COR ` +
					`AND ITVENDA.TAM = ITVENDADEV.TAM ` +
					`AND ITVENDA.QUALIDADE = ITVENDADEV.QUALIDADE ` +
					`AND ITVENDA.LOTE = ITVENDADEV.LOTE ` +
					`AND ITVENDA.EMP_ID = ITVENDADEV.EMP_ID ` +
					`AND ITVENDADEV.CANCELADO = 'N') QTDE`,
					'ITVENDA.TIPO', 'ITVENDA.BARRA BARRA_LOJA', 'ITVENDA.LOTE', 'ITVENDA.VALOR', 'SUM(ITVENDA.DESC_ITEM) DESC_ITEM', 'ITVENDA.PERC_DESC', 'VENDA.CODREP', 'ITVENDA.CODVEN',
					`CASE ITVENDA.TIPO WHEN 'P' THEN PA_ITEN.ID_PA_ITEN ELSE MAT_ITEN.ID_MAT_ITEN END ID`, 'ITVENDA.PRECO_LIQ', 'SUM(ITVENDA.TOTAL) TOTAL', 'SUM(ITVENDA.TOTAL_LIQ) TOTAL_LIQ',
					'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO DESC_COR', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI'
				],
				leftJoin: [
					{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
					{ tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' },
					{ tabela: 'PA_ITEN', condicao: 'PA_ITEN.CODIGO = ITVENDA.CODIGO AND PA_ITEN.COR = ITVENDA.COR AND PA_ITEN.TAM = ITVENDA.TAM AND PA_ITEN.LOTE = ITVENDA.LOTE AND PA_ITEN.DEPOSITO = ITVENDA.DEPOSITO AND PA_ITEN.TIPO = ITVENDA.QUALIDADE' },
					{ tabela: 'MAT_ITEN', condicao: 'MAT_ITEN.CODIGO = ITVENDA.CODIGO AND MAT_ITEN.COR = ITVENDA.COR AND MAT_ITEN.LOTE = ITVENDA.LOTE AND MAT_ITEN.DEPOSITO = ITVENDA.DEPOSITO' },
					{ tabela: 'VENDA', condicao: 'VENDA.CODVEN = ITVENDA.CODVEN AND VENDA.EMP_ID = ITVENDA.EMP_ID' }
				],
				where: [`ITVENDA.CODVEN IN (${arrVendas.toString()}) AND ITVENDA.EMP_ID = ${getCookie('emp_id')}`],
				groupby: [
					'ITVENDA.EMP_ID', 'ITVENDA.CODIGO', 'PRODUTO.DESCRICAO', 'MATERIAL.DESCRICAO', 'ITVENDA.COR', 'ITVENDA.TAM', 'ITVENDA.TIPO', 'ITVENDA.BARRA', 'ITVENDA.LOTE', 'ITVENDA.VALOR'
					, 'ITVENDA.PERC_DESC', 'VENDA.CODREP', 'ITVENDA.CODVEN', 'PA_ITEN.ID_PA_ITEN', 'MAT_ITEN.ID_MAT_ITEN', 'ITVENDA.CODVEN', 'ITVENDA.PRECO_LIQ'
					, 'ITVENDA.QUALIDADE', 'ITVENDA.DEPOSITO', 'CADCOR.DESCRICAO', 'PA_ITEN.BARRA', 'PA_ITEN.BARRA28', 'PA_ITEN.BARRACLI', 'VENDA.CODREP'
				]
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

			$('#txtAgrupaVendas').val(arrVendas.toString().replaceAll(',', ', '));

			let dataSetCols = [];
			const keys = Object.keys(jsonStr[0]);
			for (var k in keys) {
				if (keys[k].toUpperCase() == 'DESCRICAO') {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k],
						'width': '100px'
					});
				} else {
					dataSetCols.push({
						'title': keys[k],
						'data': keys[k]
					});
				}
			};

			criaDataTablePadrao('#tabelaItensAgrupaVendas', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 18, 21, 22]);

			$('#modalAgrupaVendas').modal('show');
			$("#tabelaItensAgrupaVendas").DataTable().columns.adjust().draw(false);

		} finally {
			$.LoadingOverlay("hide");
		}
	};

	$('#modalConferencia').on('hidden.bs.modal', function (_) {
		listaBarrasBipadas = [];
		listaBarrasNaoBipadas = [];
	});

	$('#txtBarra').on('blur', async function () {
		await confereBarra();
	});

	$('#txtBarraDev').on('blur', async function () {
		await confereBarraDev();
	});

	$('#txtBarra').on('keydown', async function (event) {
		if ((event.key == 'Enter')) {
			$('#txtBarra').trigger('blur');
			$('#txtBarra').focus();
		}
	});

	$('#txtBarraDev').on('keydown', async function (event) {
		if ((event.key == 'Enter')) {
			event.preventDefault();
			$('#txtBarraDev').trigger('blur');
			$('#txtBarraDev').focus();
		}
	});

	$('#tabelaItens tbody').on('click', 'tr', async function () {
		$("#tabelaItens tbody tr td")[0].click();
		$('#tabelaItens tbody tr.selected').removeClass('selected');
		$(this).addClass('selected');
	});

	$('#tabelaDevolucao tbody').on('click', 'tr', async function () {
		$("#tabelaDevolucao tbody tr td")[0].click();
		$('#tabelaDevolucao tbody tr.selected').removeClass('selected');
		$(this).addClass('selected');
	});

	$('#txtTotalDevolvido').val(0);
	$('#txtValorTotalDevolvido').val(0);

	async function atualizaTotalDevolvido() {
		const quantidadeDevolvida = $('#tabelaDevolucao').DataTable().column(6, {}).data().sum();
		$('#txtTotalDevolvido').val(+quantidadeDevolvida);
	}

	async function atualizaValorTotalDevolvido(valor) {
		$('#txtValorTotalDevolvido').val(TruncaDecimaisNova(2, +$('#txtValorTotalDevolvido').val() + valor));
	}

	async function confereBarraDev() {
		let barra = $('#txtBarraDev').val();
		let bEstorno = false;

		let quantidade = 1;
		if (barra.indexOf("*") > 0) {
			quantidade = +barra.substring(0, barra.indexOf("*"));
			barra = barra.substring(barra.indexOf("*") + 1, barra.length);
		}

		if (barra.substring(0, 1) == '-') {
			barra = barra.substring(barra.indexOf("-") + 1, barra.length);
			bEstorno = true;
		}

		if (barra == '') {
			return;
		}

		const dados = $('#tabelaDevolucao').DataTable().rows().data().toArray();
		const indiceQtde = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE > item.QTDE_DEV)
		);

		const indiceEstorno = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE_DEV > 0)
		);
		const indice = indiceQtde != -1 && !bEstorno ? indiceQtde : indiceEstorno;

		if (indice != -1) {
			const dadosItem = $('#tabelaDevolucao').DataTable().row(indice).data();
			// validacao barra_log
			// if (utilizaBarraLog) {
			// 	const item = {
			// 		codigo: dadosItem.CODIGO,
			// 		cor: dadosItem.COR,
			// 		tam: dadosItem.TAM,
			// 		barra: barra
			// 	}
			// 	if (await barraJaEstaBipada(barra)) {
			// 		$('#txtBarra').val('');
			// 		return;
			// 	} else {
			// 		await adicionaBarraBipada(item);
			// 	}
			// }
			if (!bEstorno) {
				if (dadosItem.QTDE_DEV < dadosItem.QTDE) {
					if (quantidade > 1 && quantidade + dadosItem.QTDE_DEV <= dadosItem.QTDE) {
						dadosItem.QTDE_DEV += quantidade;
					} else if (quantidade == 1) {
						dadosItem.QTDE_DEV += quantidade;
					} else {
						msgAlerta('Quantidade informada inválida ou maior que o saldo para devolução, verifique');
						$('#txtBarraDev').val('');
						$('#txtBarraDev').focus();
						return;
					}
					atualizaTotalDevolvido();
					atualizaValorTotalDevolvido(dadosItem.VALOR * quantidade);
				} else {
					msgAlerta(`Quantidade total do item: ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} já conferida`, null, null, () => { $('#txtBarraDev').focus(); });
					$('#txtBarraDev').val('');
				}
			} else {
				if (dadosItem.QTDE_DEV > 0) {
					dadosItem.QTDE_DEV -= 1;
					atualizaTotalDevolvido();
					atualizaValorTotalDevolvido(-dadosItem.VALOR);
				} else {
					msgAlerta(`Item ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} sem quantidades para estornar!`, null, null, () => { $('#txtBarraDev').focus(); });
					$('#txtBarraDev').val('');
				}
			}


			$('#tabelaDevolucao').DataTable().row(indice).data(dadosItem).draw(false);
			$(`#qtdeDev_${indice}`).val(dadosItem.QTDE_DEV);
			adicionaFocusout(`#qtdeDev_${indice}`);
			$($('#tabelaDevolucao tbody tr')[indice]).click();

			$('#tabelaDevolucao').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));

			$('#txtBarraDev').val('');
			$('#txtBarraDev').focus();
		} else {
			msgAlerta('Nenhuma barra com saldo disponível localizada', null, null, () => { $('#txtBarraDev').focus(); });
			$('#txtBarraDev').val('');
		}

	}

	async function confereBarraDevDig(input) {
		const id = input.id.substring(input.id.indexOf('_') + 1);
		const quantidade = parseFloat(input.value);
		const indice = id;

		if (indice != -1) {
			const dadosItem = $('#tabelaDevolucao').DataTable().row(indice).data();

			if (quantidade <= dadosItem.QTDE) {
				dadosItem.QTDE_DEV = quantidade;
				atualizaTotalDevolvido();
				$('#tabelaDevolucao').DataTable().row(indice).data(dadosItem).draw(false);
				atualizaValorTotalDevolvidoManual();
				$(`#${input.id}`).val(quantidade);
			} else {
				msgAlerta(`Quantidade maior que o campo QTDE, impossível continuar!`);
				dadosItem.QTDE_DEV = 0;
				$('#tabelaDevolucao').DataTable().row(indice).data(dadosItem).draw(false);
				atualizaValorTotalDevolvidoManual();
				$(`#${input.id}`).val('0');
			}
			adicionaFocusout(`#${input.id}`);
		}
	}

	function atualizaValorTotalDevolvidoManual() {
		const dados = $('#tabelaDevolucao').DataTable().rows().data().toArray();
		let valor = 0;
		dados.forEach(item => {
			valor += TruncaDecimaisNova(2, item.QTDE_DEV * item.VALOR);
		});
		$('#txtValorTotalDevolvido').val(valor);
	}

	$('#txtTotalConferido').val(0);
	$('#txtValorTotalConferido').val(0);

	async function atualizaTotalConferido() {
		const quantidadeConferida = $('#tabelaItens').DataTable().column(5, {}).data().sum();
		$('#txtTotalConferido').val(+quantidadeConferida);
	}

	async function atualizaValorTotalConferido(valor) {
		$('#txtValorTotalConferido').val(TruncaDecimaisNova(2, +$('#txtValorTotalConferido').val() + valor));
	}


	async function confereBarra() {
		let barra = $('#txtBarra').val();
		let bEstorno = false;

		let quantidade = 1;
		if (barra.indexOf("*") > 0) {
			quantidade = +barra.substring(0, barra.indexOf("*"));
			barra = barra.substring(barra.indexOf("*") + 1, barra.length);
		}

		if (barra.substring(0, 1) == '-') {
			barra = barra.substring(barra.indexOf("-") + 1, barra.length);
			bEstorno = true;
		}

		if (barra == '') {
			return;
		}

		const dados = $('#tabelaItens').DataTable().rows().data().toArray();
		const indiceQtde = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE > item.QTDE_CONF));

		const indiceEstorno = dados.findIndex((item) => (item.BARRA == barra
			|| item.LOTE == barra
			|| item.BARRA28 == barra
			|| item.BARRACLI == barra
			|| item.BARRA28 == barra.substring(0, 6)) && (item.QTDE_CONF > 0));

		const indice = indiceQtde != -1 && !bEstorno ? indiceQtde : indiceEstorno;

		if (indice != -1) {
			const dadosItem = $('#tabelaItens').DataTable().row(indice).data();
			// validacao barra_log
			if (utilizaBarraLog) {
				const item = {
					codigo: dadosItem.CODIGO,
					cor: dadosItem.COR,
					tam: dadosItem.TAM,
					barra: barra
				}
				if (await barraJaEstaBipada(barra)) {
					$('#txtBarra').val('');
					return;
				} else {
					await adicionaBarraBipada(item);
				}
			}
			if (!bEstorno) {
				if (dadosItem.QTDE_CONF < dadosItem.QTDE) {
					if (quantidade > 1 && quantidade + dadosItem.QTDE_CONF <= dadosItem.QTDE) {
						dadosItem.QTDE_CONF += quantidade;
					} else if (quantidade == 1) {
						dadosItem.QTDE_CONF += quantidade;
					} else {
						msgAlerta('Quantidade informada inválida ou maior que o saldo para devolução, verifique');
						$('#txtBarra').val('');
						$('#txtBarra').focus();
						return;
					}
					atualizaTotalConferido();
					atualizaValorTotalConferido(dadosItem.VALOR * quantidade);
				} else {
					msgAlerta(`Quantidade total do item: ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} já conferida`, null, null, () => { $('#txtBarra').focus(); });
					$('#txtBarra').val('');
				}
			} else {
				if (dadosItem.QTDE_CONF > 0) {
					dadosItem.QTDE_CONF -= 1;
					atualizaTotalConferido();
					atualizaValorTotalConferido(-dadosItem.VALOR);
				} else {
					msgAlerta(`Item ${dadosItem.CODIGO} - ${dadosItem.DESCRICAO} sem quantidades para estornar!`, null, null, () => { $('#txtBarra').focus(); });
					$('#txtBarra').val('');
				}
			}

			$('#tabelaItens').DataTable().row(indice).data(dadosItem).draw(false);
			$($('#tabelaItens tbody tr')[indice]).click();

			$('#tabelaItens').DataTable().context[0].nScrollBody.scrollTo(0, ($('.selected')[0].offsetTop));

			$('#txtBarra').val('');
			$('#txtBarra').focus();
		} else {
			msgAlerta('Nenhuma barra com saldo disponível localizada', null, null, () => { $('#txtBarra').focus(); });
			$('#txtBarra').val('');
		}
	}


	$('#txtTipoVendaFiltro').on('blur', function () {
		$('#btnConsultar').focus();
	});

	$('#btnConfirmarConf').on('click', async function () {
		$('#btnConfirmarConf').prop('disabled', true);
		try {
			await confirmaConferencia();
		} finally {
			$('#btnConfirmarConf').prop('disabled', false);
		}

	});

	$('#btnConfirmarDev').on('click', async function () {
		$("#btnConfirmarDev").prop("disabled", true);
		try {
			await confirmaDevolucao();
		} finally {
			$("#btnConfirmarDev").prop("disabled", false);
		}
		
	});

	$('#btnConfirmarAgrupaVendas').on('click', async function () {
		$('#btnConfirmarAgrupaVendas').prop('disabled', true);
		try {
			await confirmaAgrupaVendas();
		} finally {
			$('#btnConfirmarAgrupaVendas').prop('disabled', false);
		}

	});

	function retornaJsonAgrupamentoVendas(infosVenda, dtAtual) {
		let venda = {
			DEBITADUPLICATAS: false,
			VALOR_FRETE: '0',
			VENDACUPOM: false,
			VENDA_TIPO: '1',
			ACRES: '0',
			CNPJ_CONSUMIDOR: infosVenda.CNPJ,
			CODCLI: infosVenda.CODCLI,
			CODREP: infosVenda.CODREP,
			CODREP2: '',
			CODVEN: '',
			CONDICAO: [],
			DATA: dtAtual,
			DESCONTO: 0,
			DEVOLUCAO: false,
			DT_ORIG: dtAtual,
			FECHADA: false,
			HR_VENDA: dtAtual,
			LANCAMENTO: '',
			NOME_CONSUMIDOR: infosVenda.NOME,
			NRCAIXA: infosVenda.NRCAIXA,
			OBSERVACAO: '',
			PRAZO: 0,
			PREVENDA: '',
			REGRA: '',
			STATUS: infosVenda.STATUS,
			TABELA: infosVenda.TABELA,
			USUARIO: getCookie('usuario'),
			VALOR_PROMO: 0,
			BASE_DESC: 0,
			VALOR: 0,
			VALOR_BRUTO: 0,
			ITENS: []
		};

		$('#tabelaItensAgrupaVendas').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA ?
					item.BARRA : item.BARRA28
						? item.BARRA28 : item.BARRACLI,
				CAIXA: '',
				CODREP: item.CODREP,
				CODVENDEV: item.CODVEN,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESC_ITEM: item.DESC_ITEM,
				DESCONTO: item.DESC_ITEM,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: dtAtual,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: item.PERC_DESC,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.PRECO_LIQ,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * item.QTDE),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * item.QTDE),
				VALOR: item.VALOR,
				VALOR_DESC: item.VALOR_DESC
			};

			if (itemVenda.QUANTIDADE > 0) {
				venda.BASE_DESC += itemVenda.TOTAL;
				venda.VALOR += itemVenda.TOTAL - itemVenda.DESC_ITEM;
				venda.VALOR_BRUTO += itemVenda.VALOR * itemVenda.QUANTIDADE;
				venda.ITENS.push(itemVenda);
			}
		});

		return venda;
	}

	function retornaJsonDevolucao(infosVenda, dtAtual) {
		let venda = {
			DEBITADUPLICATAS: false,
			VALOR_FRETE: '0',
			VENDACUPOM: false,
			VENDA_TIPO: '2',
			ACRES: '0',
			CNPJ_CONSUMIDOR: infosVenda.CNPJ,
			CODCLI: infosVenda.CODCLI,
			CODREP: infosVenda.CODREP,
			CODREP2: '',
			CODVEN: '',
			CONDICAO: [],
			DATA: dtAtual,
			DESCONTO: 0,
			DEVOLUCAO: true,
			DT_ORIG: dtAtual,
			FECHADA: false,
			HR_VENDA: dtAtual,
			LANCAMENTO: '',
			NOME_CONSUMIDOR: infosVenda.NOME,
			NRCAIXA: infosVenda.NRCAIXA,
			OBSERVACAO: '',
			PRAZO: 0,
			PREVENDA: '',
			REGRA: '',
			STATUS: '',
			TABELA: infosVenda.TABELA,
			USUARIO: getCookie('usuario'),
			VALOR_PROMO: 0,
			BASE_DESC: 0,
			VALOR: 0,
			VALOR_BRUTO: 0,
			ITENS: []
		};

		$('#tabelaDevolucao').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA ?
					item.BARRA : item.BARRA28
						? item.BARRA28 : item.BARRACLI,
				CAIXA: '',
				CODREP: infosVenda.CODREP,
				CODVENDEV: item.VENDA,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESCONTO: 0,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: dtAtual,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: 0,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.VALOR,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE_DEV,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * (item.QTDE_DEV)),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * (item.QTDE_DEV)),
				VALOR: item.VALOR,
				VALOR_DESC: 0,
				// BARRAS_LOG: retornaBarraLog(item.CODIGO, item.COR, item.TAM, utilizaBarraLog)
			};

			if (itemVenda.QUANTIDADE > 0) {
				venda.BASE_DESC += itemVenda.TOTAL;
				venda.VALOR += itemVenda.TOTAL;
				venda.VALOR_BRUTO += itemVenda.TOTAL;
				venda.ITENS.push(itemVenda);
			}
		});
		return venda;
	}

	function retornaJsonVenda(infosVenda, dtAtual) {
		let venda = {
			DEBITADUPLICATAS: false,
			VALOR_FRETE: '0',
			VENDACUPOM: false,
			VENDA_TIPO: '1',
			ACRES: '0',
			CNPJ_CONSUMIDOR: infosVenda.CNPJ,
			CODCLI: infosVenda.CODCLI,
			CODREP: infosVenda.CODREP,
			CODREP2: '',
			CODVEN: '',
			CONDICAO: [],
			DATA: dtAtual,
			DESCONTO: 0,
			DEVOLUCAO: false,
			DT_ORIG: dtAtual,
			FECHADA: false,
			HR_VENDA: dtAtual,
			LANCAMENTO: '',
			NOME_CONSUMIDOR: infosVenda.NOME,
			NRCAIXA: infosVenda.NRCAIXA,
			OBSERVACAO: '',
			PRAZO: 0,
			PREVENDA: '',
			REGRA: '',
			STATUS: infosVenda.STATUS,
			TABELA: infosVenda.TABELA,
			USUARIO: getCookie('usuario'),
			VALOR_PROMO: 0,
			BASE_DESC: 0,
			VALOR: 0,
			VALOR_BRUTO: 0,
			ITENS: []
		};

		$('#tabelaItens').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA ?
					item.BARRA : item.BARRA28
						? item.BARRA28 : item.BARRACLI,
				CAIXA: '',
				CODREP: infosVenda.CODREP,
				CODVENDEV: 0,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESCONTO: 0,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: dtAtual,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: 0,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.VALOR,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE - item.QTDE_CONF,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * (item.QTDE - item.QTDE_CONF)),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * (item.QTDE - item.QTDE_CONF)),
				VALOR: item.VALOR,
				VALOR_DESC: 0,
				BARRAS_LOG: retornaBarraLog(item.CODIGO, item.COR, item.TAM, utilizaBarraLog)
			};

			if (itemVenda.QUANTIDADE > 0) {
				venda.BASE_DESC += itemVenda.TOTAL;
				venda.VALOR += itemVenda.TOTAL;
				venda.VALOR_BRUTO += itemVenda.TOTAL;
				venda.ITENS.push(itemVenda);
			}
		});

		return venda;
	}

	function retornaBarraLog(sCodigo, sCor, sTam, utilizaBarraLog) {
		const barras = utilizaBarraLog
			? listaBarrasNaoBipadas
				.filter((item) => item.codigo == sCodigo && item.cor == sCor && item.tam == sTam)
				.map((item) => item.barra)
			: [];
		return barras;
	}

	function retornaJsonConsignado(sVenda) {
		sVenda.VENDA_TIPO = '2';
		sVenda.ITENS = [];
		sVenda.BASE_DESC = 0;
		sVenda.VALOR = 0;
		sVenda.VALOR_BRUTO = 0;
		$('#tabelaItens').DataTable().data().map((item) => {
			const itemVenda = {
				BASEDESC_REGRAPROMO: 0,
				PERCDESC_REGRAPROMO: 0,
				VALORDESC_REGRAPROMO: 0,
				BARRA: item.BARRA,
				CAIXA: '',
				CODREP: sVenda.CODREP,
				CODVENDEV: 0,
				CODIGO: item.CODIGO,
				CONCATENACAO: `${item.CODIGO} - ${item.COR}${item.TIPO == 'P' ? ` - ${item.TAM}` : ''}`,
				COR: item.COR,
				DEPOSITO: item.DEPOSITO,
				DESC_COR: item.DESC_COR,
				DESCONTO: 0,
				DESCRICAO: item.DESCRICAO,
				DT_INCLUSAO: sVenda.DATA,
				ID_ESTOQUE: item.ID,
				LOTE: item.LOTE,
				ORDEM_PED: 0,
				PEDIDO: 0,
				PERC_DESC: 0,
				PERC_ICMS: 0,
				PRECO_CUSTO: 0,
				PRECO_LIQ: item.VALOR,
				PRESENTE: false,
				PROMOCAO: false,
				QUALIDADE: item.QUALIDADE,
				QUANTIDADE: item.QTDE_CONF,
				TAM: item.TAM,
				TIPO: item.TIPO,
				TOTAL: TruncaDecimaisNova(2, item.VALOR * item.QTDE_CONF),
				TOTAL_LIQ: TruncaDecimaisNova(2, item.VALOR * item.QTDE_CONF),
				VALOR: item.VALOR,
				VALOR_DESC: 0
			};
			if (itemVenda.QUANTIDADE > 0) {
				sVenda.BASE_DESC += itemVenda.TOTAL;
				sVenda.VALOR += itemVenda.TOTAL;
				sVenda.VALOR_BRUTO += itemVenda.TOTAL;
				sVenda.ITENS.push(itemVenda);
			}
		});
		return sVenda;
	}

	async function gravaConsignado(consignado) {
		try {
			const responseConsig = await requisicao('POST', '/sisplan/vendas/v1/venda?', `FECHAF10=${false}&NRSERIE=${getCookie('serie_ecf')}`, `JSON=${encodeURIComponent(JSON.stringify(consignado))}`, 180000);

			if (!responseConsig) {
				return false;
			}

			const jsonStrConsig = await responseConsig.json();

			if (responseConsig.status != 200) {
				msgErro(jsonStrConsig.mensagem);
				return;
			}
		} catch (error) {
			console.error(error);
		}
	}

	async function gravaVenda(venda, bDevolucao = false) {
		const response = await requisicao('POST', '/sisplan/vendas/v1/venda?', `SEMANTECIPACAO=${bDevolucao ? 'S' : 'N'}&FECHAF10=${false}&NRSERIE=${getCookie('serie_ecf')}&VERIFICA_CAIXA=${false}`, `JSON=${encodeURIComponent(JSON.stringify(venda))}`, 180000);

		if (!response) {
			return false;
		}

		const jsonStr = await response.json();

		if (response.status != 200) {
			msgErro(jsonStr.mensagem);
			return;
		}
	}

	async function cancelaVendasConferidas(sVendas) {
		for (let i = 0; i < sVendas.length; i++) {
			const paramConsigFinalizado = '&CONSIG_FINALIZADO=S';
			const response = await requisicao('POST', '/Sisplan/Vendas/V1/Cancelar?', `OBS=${'CANCELAMENTO EFETUADO PELA TELA AGRUPAMENTO DE VENDA'}&MOV_ESTOQUE=N&CODVEN=${sVendas[i]}${paramConsigFinalizado}`, '', 150000);
			const jsonStr = response.text();
			if (response.status != 200) {
				msgErro(jsonStr.mensagem);
				return;
			}

		}
	}

	async function carregaBarrasLog() {
		const arrVendas = [];
		for (let i = 0; i < $('#tabelaVendas').DataTable().rows().count(); i++) {
			if ($('#check_col_' + i + '_row_0').prop('checked')) {
				arrVendas.push($('#tabelaVendas').DataTable().row(i).data().CODVEN);
			}
		}

		if (arrVendas.length > 0) {
			const pesquisaParam = {
				tabela: 'ITVENDA_BARRA',
				camposSelect: ['CODIGO', 'COR', 'TAMANHO', 'BARRA_LOG'],
				where: [`CODVEN IN (${arrVendas.toString()}) AND EMP_ID = ${getCookie('emp_id')}`],
			}
			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			if (jsonStr && jsonStr.length > 0) {
				for (let i = 0; i < jsonStr.length; i++) {
					const item = {
						codigo: jsonStr[i].CODIGO,
						cor: jsonStr[i].COR,
						tam: jsonStr[i].TAMANHO,
						barra: jsonStr[i].BARRA_LOG
					}
					listaBarrasNaoBipadas.push(item);
				}
			}
		}
	}

	async function confirmaConferencia() {

		if (await verificaCaixa()) {
			return;
		}

		const infosVenda = [];
		const vendedorPadraoVenda = parametrosVenda[59];
		const mantemTipoConsignado = parametrosVenda[80] == "1"; 

		try {
			for (let i = 0; i < $('#txtVendas').val().split(', ').length; i++) {
				infosVenda[i] = await retornaInfosVenda($('#txtVendas').val().split(', ')[i]);
			}
			const mantemStatus = infosVenda.filter(info => info.STATUS !== '');
			const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;
			const possuiStatusDiferente = infosVenda.filter(info => info.STATUS === infosVenda[0].STATUS && info.STATUS !== '').length > 0;
			const possuiStatusVazio = infosVenda.filter(info => info.STATUS === '').length > 0;
			const bGuiasIguais = infosVenda.map(info => info.CODREP2).every(guia => guia === infosVenda[0].CODREP2);
			if ((possuiStatusDiferente) && (!possuiStatusVazio)) {
				for (let i = 0; i < infosVenda.length; i++) {
					infosVenda[i].STATUS = '';
				}
			} else {
				if (!possuiStatusVazio) {
					for (let i = 0; i < infosVenda.length; i++) {
						infosVenda[i].STATUS = mantemStatus[0].STATUS;
					}
				}
			}

			const venda = retornaJsonVenda(infosVenda[0], dtAtual);

			if (bGuiasIguais) {
				venda.CODREP2 = infosVenda[0].CODREP2;
			}

			let gerouConsignado = false;
			$.LoadingOverlay('show');
			try {

				// cancela vendas selecionadas para conferência
				await cancelaVendasConferidas($('#txtVendas').val().split(', '));

				// grava venda com itens não conferidos
				if (venda.ITENS.length > 0) {
					const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
					venda.CODVEN = sCodven;
					if (vendedorPadraoVenda != '') {
						venda.CODREP = pegaChave(vendedorPadraoVenda);
					}
					if (mantemTipoConsignado) {
						venda.VENDA_TIPO = "2";
					}
					await gravaVenda(venda, false);
					await salvaAgrupado($('#txtVendas').val().split(', '), sCodven, true);
				}

				// se check estiver marcado grava itens conferidos como consignado
				if ($('#checkConsig').is(':checked')) {
					if (validaConsignado()) {
						gerouConsignado = true;
						const sCodvenConsig = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
						venda.CODVEN = sCodvenConsig;
						const consignado = retornaJsonConsignado(venda);
						await gravaConsignado(consignado);
					} else {
						msgAlerta('Consignado não gerado pois não havia nenhum item bipado.');
					}
				}


				await criaMensagemSucesso(($('#checkConsig').is(':checked') && gerouConsignado) ? `Venda pendente:${venda.CODVEN} e consignado criados com sucesso` : venda.CODVEN != '' ? `Venda pendente: ${venda.CODVEN} criada com sucesso!` : '', () => {
					setCookie('vai_para_aba_itens', 'true');
					if (venda.CODVEN != '') {
						window.location.href = `${BASE_URI}/venda/${venda.CODVEN}`;
					} else {
						window.location.href = `${BASE_URI}/agrupamento_venda`
					}
				});

			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	async function cancelaVendasSemSaldo(listaVendas) {
		const dados = $('#tabelaDevolucao').DataTable().data().toArray();
		const dadosComSaldo = dados.filter(item => item.QTDE > item.QTDE_DEV);
		const vendasComSaldo = [...new Set(dadosComSaldo)].map(item => String(item.VENDA));

		const vendasFinalizadas = listaVendas.filter(venda => {
			if (!vendasComSaldo.includes(venda)) {
				return venda;
			}
		});
		if (vendasFinalizadas.length > 0) {
			await cancelaVendasConferidas(vendasFinalizadas);
		}
	}

	async function confirmaDevolucao() {
		try {

			if (await verificaCaixa()) {
				return;
			}

			// await cancelaVendasSemSaldo($('#txtVendasDev').val().split(', '));
			const infosVenda = await retornaInfosVenda($('#txtVendasDev').val().split(', ')[0]);
			const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;
			const venda = retornaJsonDevolucao(infosVenda, dtAtual);

			$.LoadingOverlay('show');
			try {
				if (venda.ITENS.length > 0) {
					msgAlerta('Deseja imprimir a venda?', async () => {
						try {
							$.LoadingOverlay('show');
							const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
							venda.CODVEN = sCodven;
							await gravaVenda(venda, true);
							await cancelaVendasSemSaldo($('#txtVendasDev').val().split(', '));
							await imprimirAgrupamento();
							await criaMensagemSucesso('Devolução criada com sucesso', () => {
								$('#modalDevolucao').modal('hide');
								$('#btnConsultar').trigger('click');
							});
						} finally {
							$.LoadingOverlay('hide');
						}
					},
						async () => {
							try {
								$.LoadingOverlay('show');
								const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
								venda.CODVEN = sCodven;
								await gravaVenda(venda, true);
								await cancelaVendasSemSaldo($('#txtVendasDev').val().split(', '));
								await criaMensagemSucesso('Devolução criada com sucesso', () => {
									$('#modalDevolucao').modal('hide');
									$('#btnConsultar').trigger('click');
								});
							} finally {
								$.LoadingOverlay('hide');
							}
						}
					);
				} else {
					await criaMensagemErro('Nenhum item devolvido, impossível continuar.', () => { });
				}
			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	async function confirmaAgrupaVendas() {

		if (await verificaCaixa()) {
			return;
		}

		const infosVenda = [];
		const vendedorPadraoVenda = parametrosVenda[59];

		try {
			for (let i = 0; i < $('#txtAgrupaVendas').val().split(', ').length; i++) {
				infosVenda[i] = await retornaInfosVenda($('#txtAgrupaVendas').val().split(', ')[i]);
			}
			const mantemStatus = infosVenda.filter(info => info.STATUS !== '');
			const dtAtual = `${new Date().getFullYear()}-${String(new Date().getMonth() + 1).padStart(2, '0')}-${String(new Date().getDate()).padStart(2, '0')}`;
			const possuiStatusDiferente = infosVenda.filter(info => info.STATUS === infosVenda[0].STATUS && info.STATUS !== '').length > 0;
			const possuiStatusVazio = infosVenda.filter(info => info.STATUS === '').length > 0;
			const bGuiasIguais = infosVenda.map(info => info.CODREP2).every(guia => guia === infosVenda[0].CODREP2);
			if ((possuiStatusDiferente) && (!possuiStatusVazio)) {
				for (let i = 0; i < infosVenda.length; i++) {
					infosVenda[i].STATUS = '';
				}
			} else {
				if (!possuiStatusVazio) {
					for (let i = 0; i < infosVenda.length; i++) {
						infosVenda[i].STATUS = mantemStatus[0].STATUS;
					}
				}
			}

			const venda = retornaJsonAgrupamentoVendas(infosVenda[0], dtAtual);

			if (bGuiasIguais) {
				venda.CODREP2 = infosVenda[0].CODREP2;
			}

			$.LoadingOverlay('show');
			try {

				// cancela vendas selecionadas para conferência
				await cancelaVendasConferidas($('#txtAgrupaVendas').val().split(', '));

				// grava venda com itens não conferidos
				if (venda.ITENS.length > 0) {
					const sCodven = await RetornaProximo('VENDA', 'VENDA', 'CODVEN', 0);
					venda.CODVEN = sCodven;
					if (vendedorPadraoVenda != '') {
						venda.CODREP = pegaChave(vendedorPadraoVenda);
					}
					await gravaVenda(venda, false);
					await salvaAgrupado($('#txtAgrupaVendas').val().split(', '), sCodven, false);
				}

				await criaMensagemSucesso(`Venda pendente: ${venda.CODVEN} criada com sucesso!`, () => { window.location.href = `${BASE_URI}/loja` });

			} catch (error) {
				console.error(error);
			}
		} finally {
			$.LoadingOverlay('hide');
		}
	}

	function validaConsignado() {
		return $("#tabelaItens").DataTable().column(5, {}).data().sum() > 0;
	}

	async function retornaInfosVenda(sCodVen) {
		const pesquisaParam = {
			tabela: 'VENDA',
			camposSelect: ['ENTIDADE.NOME', 'VENDA.CODCLI', 'VENDA.TABELA', 'ENTIDADE.CNPJ', 'VENDA.CODREP', 'VENDA.NRCAIXA', 'VENDA.STATUS', 'VENDA.CODREP2'],
			leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' }],
			where: [`VENDA.CODVEN = ${sCodVen} AND VENDA.EMP_ID= ${getCookie('emp_id')}`]
		}
		const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
		return jsonStr[0];
	}

	async function salvaAgrupado(sVendas, sCodven, consignado) {
		const response = await requisicao('POST', '/sisplan/vendas/v1/salvaagrupado?', `&VENDAS=${sVendas}&CDAGRUPADA=${sCodven}&CONSIGNADO=${consignado}`);
		const jsonStr = await response.text();
		if (response.status != 200) {
			msgErro(jsonStr.mensagem);
			return;
		}
	}

	async function verificaCaixa() {
		const caixa = pegaChave("#txtCaixa");
		const data = new Date();
		try {
			const response = await requisicao('GET', '/sisplan/vendas/v1/verificastatuscaixa?', `CAIXA=${caixa}&DATA=${data.toISOString().slice(0,10)}`, '', 30000);

			if (!response) {
				msgAlerta("Não foi possível verificar o caixa, tente novamente.");
				return true;
			}

			const jsonStr = await response.json();
			if (response.status != 200) {
				msgAlerta("Não foi possível verificar o caixa, tente novamente.");
				return true;
			}

			if (jsonStr == "true") {
				msgAlerta("Não foi possível fechar a venda. \r\nMotivo: Caixa do dia "+data.toLocaleDateString()+" já fechado!");
				return true;
			} else {
				return false;
			}

		} catch (error) {
			console.error(error);
			return true;
		}
	}

});