$(document).ready(async function () {
    $.LoadingOverlay('show')
    const listaDePrecosAlterados = [];
    const utilizaProdMat = await CopiaParametro('VENDA', 17);
    const utilizaTabCorTam = await CopiaParametro('VENDA', 5);
    const tabPrecoPadrao = await CopiaParametro('VENDA', 2);



    if (utilizaTabCorTam == 0 || utilizaProdMat == 1) {
        $('#divCor').addClass('d-none');
        $('#divTamanho').addClass('d-none');
        $('#divCodigo').removeClass('col-sm-3');
        $('#divCodigo').addClass('col-sm-6');
        $('#divTabeladePreco').removeClass('col-sm-3');
        $('#divTabeladePreco').addClass('col-sm-6');
    }

    let decimais = parseInt(await CopiaParametro("SISTEMA", 1)) + 2;

    if (isNaN(decimais)) {
        decimais = 2;
    };

    criaAutocompletasEPesquisas();
    // await carregaDataTable('');

    $('#tabelaAlteraPreco').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    $('#radioProduto').on('click', async function () {
        if (utilizaTabCorTam == 0) {
            $('#divCor').addClass('d-none');
            $('#divTamanho').addClass('d-none');
            $('#divCodigo').removeClass('col-sm-3');
            $('#divCodigo').addClass('col-sm-6');
            $('#divTabeladePreco').removeClass('col-sm-3');
            $('#divTabeladePreco').addClass('col-sm-6');
        } else {
            $('#divCor').removeClass('d-none');
            $('#divTamanho').removeClass('d-none');
            $('#divCodigo').addClass('col-sm-3');
            $('#divCodigo').removeClass('col-sm-6');
            $('#divTabeladePreco').addClass('col-sm-3');
            $('#divTabeladePreco').removeClass('col-sm-6');

            $('#txtTamanho').pesquisa_variosServerside(1, '{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA" ], "where": null}', 'TAM', 'FAIXA');
            $('#btnTamanho').pesquisa_serversideSel('#txtTamanho', `{ "tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"], "where": null}`, 'Pesquisa de Tamanho');

            $('#txtCor').pesquisa_variosServerside(1, '{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'COR', 'DESCRICAO');
            $('#btnCor').pesquisa_serversideSel('#txtCor', `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cor');
        }

        $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Produto');
    });

    $('#radioMaterial').on('click', async function () {
        $('#divCor').addClass('d-none');
        $('#divTamanho').addClass('d-none');
        $('#divCodigo').removeClass('col-sm-3');
        $('#divCodigo').addClass('col-sm-6');
        $('#divTabeladePreco').removeClass('col-sm-3');
        $('#divTabeladePreco').addClass('col-sm-6');

        $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
        $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Material');
    });

    $('#btnConsultar').on('click', async function () {

        if ($('#txtTabPreco').val() == '') {
            msgErro('Obrigatório informar uma tabela de preço específica para fazer a consulta!');
            return;
        };

        try {
            $.LoadingOverlay('show');
            if (utilizaTabCorTam == 1 && utilizaProdMat == 0 && $('#radioProduto').is(':checked')) {
                await fazConsultaTabPrecoCorTam();
            } else {
                if ((utilizaProdMat == 0 && $('#radioProduto').is(':checked')) || $('#radioProduto').is(':checked')) {
                    await fazConsultaTabPrecoNormal();
                } else {
                    await fazConsultaMaterial();
                }
            }
        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravar').on('click', async function () {
        const qtdeRegistrosDataTable = $('#tabelaAlteraPreco').DataTable().data().toArray();

        if (qtdeRegistrosDataTable <= 0) {
            msgErro('Não existe registro para gravar! Verifique.');
            return;
        };

        if (listaDePrecosAlterados.length <= 0) {
            msgErro('Você não informou nenhum preço para alteração! Verifique');
            return;
        };

        await gravaNovosPrecos();
    });

    $('#txtTabPreco').val(tabPrecoPadrao);

    async function fazConsultaTabPrecoCorTam() {
        const tabPreco = pegaChave('#txtTabPreco');
        const tamanhoProduto = await formataListas($('#txtTamanho').val().toString())
        const corProduto = await formataListas($('#txtCor').val().toString());
        const codigoProd = await formataListas($('#txtCodigo').val().toString());

        let whereSql = ''

        if (tamanhoProduto != '' && tamanhoProduto != null && tamanhoProduto != undefined) {
            whereSql += `AND PRECO_COR_TAM.TAM IN (${tamanhoProduto})`;
        };

        if (corProduto != '' && corProduto != null && corProduto != undefined) {
            whereSql += `AND PRECO_COR_TAM.COR IN (${corProduto})`;
        };

        if (codigoProd != '' && codigoProd != null && codigoProd != undefined) {
            whereSql += `AND PRECO_COR_TAM.CODIGO IN (${codigoProd})`;
        };

        const camposSelect = `["DISTINCT PRECO_COR_TAM.CODIGO",` +
            `"PRODUTO.DESCRICAO",` +
            `"PRECO_COR_TAM.COR",` +
            `"CADCOR.DESCRICAO AS DESC_COR",` +
            `"PRECO_COR_TAM.TAM",` +
            `"PRECO_COR_TAM.REGIAO",` +
            `"REGIAO.DESCRICAO AS DESC_REGIAO",` +
            `"PRECO_COR_TAM.PRECO",` +
            `"''"]`;

        const innerJoins = `{ "tabela": "PRODUTO", "condicao": "PRECO_COR_TAM.CODIGO = PRODUTO.CODIGO" },` +
            `{ "tabela": "CADCOR", "condicao": "CADCOR.COR = PRECO_COR_TAM.COR" },` +
            `{ "tabela": "REGIAO", "condicao": "REGIAO.REGIAO = PRECO_COR_TAM.REGIAO" }`;

        const ajaxData = {
            "EMPRESA": getCookie('empresa'),
            "JSON": `{"tabela": "PRECO_COR_TAM", 
                      "camposSelect": ${camposSelect},
                      "innerJoin": [${innerJoins}],
                      "where": ["PRECO_COR_TAM.REGIAO = '${tabPreco}' AND PRECO_COR_TAM.TIPO = 'P' ${whereSql}"],
                      "groupBy": ["PRECO_COR_TAM.CODIGO, PRECO_COR_TAM.COR, PRECO_COR_TAM.TAM, CADCOR.DESCRICAO, PRECO_COR_TAM.REGIAO, PRODUTO.DESCRICAO, REGIAO.DESCRICAO, PRECO_COR_TAM.PRECO"],
                      "orderBy":["PRECO_COR_TAM.CODIGO, PRECO_COR_TAM.COR, PRECO_COR_TAM.TAM"]
                    }`,
            "CLIENTE": 'N',
        };

        await carregaDataTable(ajaxData);
    };

    async function fazConsultaMaterial() {
        const tabelaPreco = pegaChave('#txtTabPreco');
        const codigoMat = await formataListas($('#txtCodigo').val().toString());

        let whereSqlNormal = '';

        if (codigoMat != '' && codigoMat != null && codigoMat != undefined) {
            whereSqlNormal += `AND TABPRECO.CODIGO IN (${codigoMat})`;
        };

        const camposSelectNormal = `["DISTINCT TABPRECO.CODIGO",` +
            `"MATERIAL.DESCRICAO",` +
            `"TABPRECO.REGIAO",` +
            `"REGIAO.DESCRICAO AS DESC_REGIAO",` +
            `"TABPRECO.PRECO_00",` +
            `"''"]`;

        const innerJoins = `{ "tabela": "MATERIAL", "condicao": "TABPRECO.CODIGO = MATERIAL.CODIGO" },` +
            `{ "tabela": "REGIAO", "condicao": "REGIAO.REGIAO = TABPRECO.REGIAO" }`;

        const ajaxData = {
            "EMPRESA": getCookie('empresa'),
            "JSON": `{"tabela": "TABPRECO", 
                          "camposSelect": ${camposSelectNormal},
                          "innerJoin": [${innerJoins}],
                          "where": ["TABPRECO.REGIAO = '${tabelaPreco}' AND TABPRECO.TIPO = 'M' ${whereSqlNormal}"],
                          "groupBy": ["TABPRECO.CODIGO, TABPRECO.REGIAO, MATERIAL.DESCRICAO, REGIAO.DESCRICAO, TABPRECO.PRECO_00"],
                          "orderBy":["TABPRECO.CODIGO"]
                        }`,
            "CLIENTE": 'N',
        };

        await carregaDataTable(ajaxData);
    };

    async function fazConsultaTabPrecoNormal() {
        const tabelaPreco = pegaChave('#txtTabPreco');
        const codigoProd = await formataListas($('#txtCodigo').val().toString());

        let whereSqlNormal = '';

        if (codigoProd != '' && codigoProd != null && codigoProd != undefined) {
            whereSqlNormal += `AND TABPRECO.CODIGO IN (${codigoProd})`;
        };

        const camposSelectNormal = `["DISTINCT TABPRECO.CODIGO",` +
            `"PRODUTO.DESCRICAO",` +
            `"TABPRECO.REGIAO",` +
            `"REGIAO.DESCRICAO AS DESC_REGIAO",` +
            `"TABPRECO.PRECO_00",` +
            `"''"]`;

        const innerJoins = `{ "tabela": "PRODUTO", "condicao": "TABPRECO.CODIGO = PRODUTO.CODIGO" },` +
            `{ "tabela": "REGIAO", "condicao": "REGIAO.REGIAO = TABPRECO.REGIAO" }`;

        const ajaxData = {
            "EMPRESA": getCookie('empresa'),
            "JSON": `{"tabela": "TABPRECO", 
                          "camposSelect": ${camposSelectNormal},
                          "innerJoin": [${innerJoins}],
                          "where": ["TABPRECO.REGIAO = '${tabelaPreco}' AND TABPRECO.TIPO = 'P' ${whereSqlNormal}"],
                          "groupBy": ["TABPRECO.CODIGO, TABPRECO.REGIAO, PRODUTO.DESCRICAO, REGIAO.DESCRICAO, TABPRECO.PRECO_00"],
                          "orderBy": ["TABPRECO.CODIGO"]
                        }`,
            "CLIENTE": 'N',
        };

        await carregaDataTable(ajaxData);
    };

    async function gravaNovosPrecos() {
        try {
            $.LoadingOverlay('show');

            let tipoTabelaPreco;

            if (utilizaTabCorTam == 1 && utilizaProdMat == 0) {
                tipoTabelaPreco = 1;
            } else {
                tipoTabelaPreco = 0
            }

            const url = '/sisplan/alterapreco/v1/atualizapreco?';
            const response = await requisicao('PUT', url, `LISTAPRECOSATUALIZA=${JSON.stringify({ PRECOSALTERADOS: listaDePrecosAlterados })}&TIPOTABELAPRECO=${tipoTabelaPreco}`, '', 180000);

            if (!response) {
                msgErro('Não foi possível alterar os preços! Verifique.');
                return;
            };

            if (response.status == 200) {
                criaMensagemSucesso('Preços alterados com sucesso!', () => { window.location.href = window.location.href; });
                return;
            };

            if (response.status != 200) {
                msgErro('Não foi possível alterar os preços! Verifique.');
                return;
            };

        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function preencheInputComValor() {
        const infosDataTable = $('#tabelaAlteraPreco').DataTable().data().toArray();
        const qtdeRegistros = infosDataTable.length;
        if (listaDePrecosAlterados.length <= 0) {
            return;
        };

        if (utilizaTabCorTam == 1) {
            for (i = 0; i < qtdeRegistros; i++) {
                const procuraObjeto = { codigo: infosDataTable[i][0], cor: infosDataTable[i][2], tam: infosDataTable[i][4], regiao: infosDataTable[i][5] }
                const procuraIndice = listaDePrecosAlterados.findIndex(index => index.codigo == procuraObjeto.codigo && index.cor == procuraObjeto.cor && index.tam == procuraObjeto.tam && index.regiao == procuraObjeto.regiao);
                if (procuraIndice != -1) {
                    $($('#tabelaAlteraPreco .form-control')[i]).val(listaDePrecosAlterados[procuraIndice].preco_novo);
                };
            };
        } else {
            for (i = 0; i < qtdeRegistros; i++) {
                const procuraNalista = { codigo: infosDataTable[i][0], regiao: infosDataTable[i][2] };
                const procuraIndiceNaLista = listaDePrecosAlterados.findIndex(index => index.codigo == procuraNalista.codigo && index.regiao == procuraNalista.regiao)
                if (procuraIndiceNaLista != -1) {
                    $($('#tabelaAlteraPreco .form-control')[i]).val(listaDePrecosAlterados[procuraIndiceNaLista].preco_novo);
                }
            }
        };
    };

    async function adicionaNaLista() {
        if (utilizaTabCorTam == 1 && utilizaProdMat == 0) {

            const data = $('#tabelaAlteraPreco').DataTable().row('tr.selected').data();
            const valorInput = $('#tabelaAlteraPreco tr.selected .form-control').val();
            const valorInputFormatado = parseFloat(valorInput.replace(',', '.')).toFixed(decimais).replace('.', ',');
            const novoObjeto = { codigo: data[0], cor: data[2], tam: data[4], regiao: data[5], preco_antigo: data[7], preco_novo: valorInputFormatado };
            if (listaDePrecosAlterados.length == 0) {
                if (valorInputFormatado != '' && valorInputFormatado != null && valorInputFormatado != undefined && valorInputFormatado != 0 && valorInputFormatado != 'NaN') {
                    listaDePrecosAlterados.push(novoObjeto);
                };
            } else {
                const indiceEncontrado = listaDePrecosAlterados.findIndex(index => index.codigo == novoObjeto.codigo && index.cor == novoObjeto.cor && index.regiao == novoObjeto.regiao && index.tam == novoObjeto.tam);
                if (indiceEncontrado == -1 && valorInputFormatado != '' && valorInputFormatado != null && valorInputFormatado != undefined && valorInputFormatado != 0 && valorInputFormatado != 'NaN') {
                    listaDePrecosAlterados.push(novoObjeto);
                } else if (indiceEncontrado != -1 && valorInputFormatado == null || valorInputFormatado == '' || valorInputFormatado == undefined || valorInputFormatado == 'NaN') {
                    listaDePrecosAlterados.splice([indiceEncontrado], 1);
                } else if (indiceEncontrado != -1 && valorInputFormatado != listaDePrecosAlterados[indiceEncontrado].preco_novo) {
                    listaDePrecosAlterados[indiceEncontrado].preco_novo = valorInputFormatado;
                } else {
                    return;
                }
            };

        } else {

            const data = $('#tabelaAlteraPreco').DataTable().row('tr.selected').data();
            const valorInput = $('#tabelaAlteraPreco tr.selected .form-control').val();
            const valorInputFormatado = parseFloat(valorInput.replace(',', '.')).toFixed(decimais).replace('.', ',');
            const novoObjeto = { codigo: data[0], regiao: data[2], preco_antigo: data[4], preco_novo: valorInputFormatado };
            if (listaDePrecosAlterados.length == 0) {
                if (valorInputFormatado != '' && valorInputFormatado != null && valorInputFormatado != undefined && valorInputFormatado != 0 && valorInputFormatado != 'NaN') {
                    listaDePrecosAlterados.push(novoObjeto);
                };
            } else {
                const indiceDataTable = listaDePrecosAlterados.findIndex(index => index.codigo == novoObjeto.codigo && index.regiao == novoObjeto.regiao);
                if (indiceDataTable == -1 && valorInputFormatado != '' && valorInputFormatado != null && valorInputFormatado != undefined && valorInputFormatado != 0 && valorInputFormatado != 'NaN') {
                    listaDePrecosAlterados.push(novoObjeto);
                } else if (indiceDataTable != -1 && valorInputFormatado == null || valorInputFormatado == '' || valorInputFormatado == undefined || valorInputFormatado == 'NaN') {
                    listaDePrecosAlterados.splice([indiceDataTable], 1);
                } else if (indiceDataTable != -1 && valorInputFormatado != listaDePrecosAlterados[indiceDataTable].preco_novo) {
                    listaDePrecosAlterados[indiceDataTable].preco_novo = valorInputFormatado;
                } else {
                    return;
                }
            }
        }

    };

    async function criaFuncoesDosInputsDePreco() {
        $('.input-preconovo').on('blur', async function () {
            await adicionaNaLista();
        });

        $('.input-preconovo').on('focusin', async function () {
            $("#tabelaAlteraPreco").dataTable().$("tr.selected").removeClass("selected");
            $(this).closest('tr').addClass("selected");
        });
    };

    function retornaInputDePreco() {
        return `<input type="text" class="input-default form-control input-preconovo" id="txtPrecoNovo" class="form-control"></input>`
    };

    async function carregaDataTable(ajaxData) {
        const colunasDataTable = await retornaColunas();
        if ($.fn.DataTable.isDataTable('#tabelaAlteraPreco')) {
            $("#tabelaAlteraPreco").DataTable().destroy();
            $("#tabelaAlteraPreco").empty();
        };
        if (utilizaTabCorTam == 1 && ajaxData != '' && utilizaProdMat == 0) {
            $('#tabelaAlteraPreco').DataTable({
                paging: true,
                lengthChange: false,
                filter: false,
                info: true,
                order: false,
                sort: false,
                autoWidth: true,
                destroy: true,
                serverSide: true,
                processing: true,
                searching: false,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "GET",
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: ajaxData,
                },
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",

                    },
                },
                columns: colunasDataTable,
                columnDefs: [
                    {
                        targets: [8], render: function (data, type, row) {
                            return retornaInputDePreco();
                        }
                    },
                    {
                        targets: [7], render: function (data, type, row) {

                            const numeroformatado = parseFloat(data.replace(',', '.')).toFixed(decimais).replace('.', ',')
                            return numeroformatado;
                        }
                    }
                ]
            });

            $('#tabelaAlteraPreco').on('draw.dt', async function () {
                await preencheInputComValor();
                await criaFuncoesDosInputsDePreco();
            });

        } else if (ajaxData != '') {

            $('#tabelaAlteraPreco').DataTable({
                paging: true,
                lengthChange: true,
                filter: false,
                info: true,
                order: false,
                sort: false,
                autoWidth: true,
                destroy: true,
                serverSide: true,
                processing: true,
                searching: false,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "GET",
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: ajaxData,
                },
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columns: colunasDataTable,
                columnDefs: [
                    {
                        targets: [5], render: function (data, type, row) {
                            return retornaInputDePreco();
                        }
                    },
                    {
                        targets: [4], render: function (data, type, row) {

                            const numeroformatado = parseFloat(data.replace(',', '.')).toFixed(decimais).replace('.', ',')
                            return numeroformatado;
                        }
                    }
                ]
            });

            $('#tabelaAlteraPreco').on('draw.dt', async function () {
                await preencheInputComValor();
                await criaFuncoesDosInputsDePreco();
            });

        } else {

            $('#tabelaAlteraPreco').DataTable({
                bPaginate: true,
                order: false,
                sort: false,
                autoWidth: true,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columns: colunasDataTable,
            });
        };
    };

    async function retornaColunas() {
        const dataSetCols = [];
        if (utilizaTabCorTam == '1' && utilizaProdMat == 0) {
            dataSetCols.push({
                "title": "Código",
            });
            dataSetCols.push({
                "title": "Descrição",
            });
            dataSetCols.push({
                "title": "Cor",
            });
            dataSetCols.push({
                "title": "Desc Cor",
            });
            dataSetCols.push({
                "title": "Tam",
            });
            dataSetCols.push({
                "title": "Região",
            });
            dataSetCols.push({
                "title": "Desc Região",
            });
            dataSetCols.push({
                "title": "Preço Antigo",
            });
            dataSetCols.push({
                "title": "Preço Novo",
            });
        } else {
            dataSetCols.push({
                "title": "Código",
            });
            dataSetCols.push({
                "title": "Descrição",
            });
            dataSetCols.push({
                "title": "Região",
            });
            dataSetCols.push({
                "title": "Desc Região",
            });
            dataSetCols.push({
                "title": "Preço Antigo",
            });
            dataSetCols.push({
                "title": "Preço Novo",
            });
        };
        return dataSetCols;
    };

    function criaAutocompletasEPesquisas() {
        $.LoadingOverlay('show')
        try {
            if (utilizaProdMat == '1') {
                $('#radioMaterial').prop('checked', true);
                $('#radioProduto').prop('checked', false);
                // $('#btnCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Material');
                $('#btnCodigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Material');
                $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
            } else {
                $('#radioProduto').prop('checked', true);
                $('#radioMaterial').prop('checked', false);
                $('#btnCodigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Produto');
                $('#btnCor').pesquisa_serverside(['#txtCor'], ["COR"], ["DESCRICAO"], `{"tabela":"CADCOR", "camposSelect":["COR", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Cor');
                $('#btnTamanho').pesquisa_serverside(['#txtTamanho'], ["TAM"], ["FAIXA"], `{"tabela":"TABTAM", "camposSelect":["TAM", "FAIXA"], "where": ["1=1"]}`, 'Pesquisa de Tamanho');
                $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE", "FAIXA DESCRICAO"], "where": null}`);
                $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
                $('#txtTamanho').listaFiltros();
                $('#txtCor').listaFiltros();
                $('#btnlimparTamanho').on('click', function () {
                    if ($('#txtTamanho').val() == '') {
                        $('#listaTamanho').val('');
                    }
                    $('#txtTamanho').val('');
                });
                $('#btnlimparCor').on('click', function () {
                    if ($('#txtCor').val() == '') {
                        $('#listaCor').val('');
                    }
                    $('#txtCor').val('');
                });
            };

            $('#txtCodigo').listaFiltros();

            $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": ["LIBERADO = 'S'"]}`);
            $('#btnTabPreco').pesquisa_serverside(['#txtTabPreco'], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":["REGIAO", "DESCRICAO"], "where": ["LIBERADO = 'S'"]}`, 'Pesquisa de Tabela de Preço');

            $('#btnlimparTabPreco').on('click', function () {
                $('#txtTabPreco').val('');
            });
        } finally {
            $.LoadingOverlay('hide')
        }
    };

    $("#btnlimparTamanho").on('click', function () {
        $('#txtTamanho').empty().trigger('change');
    });

    $("#btnlimparCor").on('click', function () {
        $('#txtCor').empty().trigger('change');
    });

    $("#btnlimparTabPreco").on('click', function () {
        $('#txtTabPreco').empty().trigger('change');
    });

    $("#btnlimparCodigo").on('click', function () {
        $('#txtCodigo').empty().trigger('change');
    });

    $('#btnLimpar').on('click', function () {
        $('#txtTabPreco').val('');
        $('#txtCodigo').empty().trigger('change');
        $('#txtTabPreco').empty().trigger('change');
        $('#txtCor').empty().trigger('change');
        $('#txtTamanho').empty().trigger('change');
    });

    if (utilizaProdMat == '1') {
        $('#radioProduto').trigger('click');
        $('#radioMaterial').trigger('click');
    } else {
        $('#radioMaterial').trigger('click');
        $('#radioProduto').trigger('click');
    }
    $.LoadingOverlay('hide')
});