$(document).ready(async function () {

    $("#btnGravar").click(function () {

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            gravaInf();
        }
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let cadinfcomplementar = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('PRODUTO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/cadinfcomplementar`;
    });

    if (cadinfcomplementar != '' && cadinfcomplementar != 'create') {
        carregaDados();
    }

    async function carregaDados() {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"TABREF", 
                        "camposSelect":["codigo", "descricao"], 
                        "where": ["codigo = '${cadinfcomplementar}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravaInf() {
        try {
            $.LoadingOverlay("show");
            cadInf = {};

            cadInf.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo("CODIGO", "TABREF", "CODIGO", 2) : $('#txtCodigo').val();
            cadInf.DESCRICAO = $('#txtDescricao').val().toUpperCase();

            let response = await requisicao('POST', '/Sisplan/Cadastros/v1/cadinfcomplementar?', `JSON=${encodeURIComponent(JSON.stringify(cadInf))}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
                'Cadastro efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadinfcomplementar`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados de Cadastrado de Informações Complementare: ${error}`);
        }
    };
});

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#telatour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Este campo é preenchido automaticamente após clicar em gravar, nela é gerado o código do cadastro, em caso de alteração do registro, irá retornar o código do cadastro que está sendo alterado.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o cadastro ou alteração da informação complementar.',
                position: 'top'
            }
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Ao clicar nesse botão você retorna para a tela de consulta.',
                position: 'left'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a informação complementar.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});