$(document).ready(async function () {

    const produtoCodigo = await retornaCodigodoProdutoUrl();
    let coresCodigo = [];
    let contadorInputCorInsumo = 0;
    let indiceSelecionado = -1;
    let ordemManutencao = 0;
    let listaCoresProdutoAlteradas = [];
    let ordemSendoAlterada = -1;
    let incluindoGradeTam = false;
    let alterandoGradeTam = false;
    let btnAltera = '';
    let listaGradesAdicionadasModal = [];
    // ta aqui pra prestar manutenção? sinto muito kkkkkkkk 


    $('#btn-CodigoConsumo').pesquisa_serverside(['#txtCodigoConsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
    $('#txtCodigoConsumo').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');

    $('#btnManutencao').on('click', async function () {
        $('#modal-manutencaoconsumos').modal('show');
    })

    $('#btnEdicao').on('click', async function () {
        $('#btnEdicao').addClass('d-none');
        $('#btnGravar').removeClass('d-none');
        $('#btnCancelar').removeClass('d-none');
        $('#btnImportaCons').removeClass('d-none');
        $('#btnExcluir').addClass('d-none');
        $('#btnImprimir').addClass('d-none');
        $('#btnFotoMaterial').addClass('d-none');
    });

    $('#btnCancelar').on('click', async function () {
        $('#btnEdicao').removeClass('d-none');
        $('#btnGravar').addClass('d-none');
        $('#btnCancelar').addClass('d-none');
        $('#btnImportaCons').addClass('d-none');
        $('#btnExcluir').removeClass('d-none');
        $('#btnImprimir').removeClass('d-none');
        $('#btnFotoMaterial').removeClass('d-none');
    });

    $('#cbSomenteCorAtiva').on('change', async function () {
        if ($('#cbSomenteCorAtiva').is(':checked')) {
            const cbSomenteCorAtiva = true;
            await fazConsulta(cbSomenteCorAtiva);
        } else {
            await fazConsulta(false);
        }
    });

    $('#txtCodigoConsumo').on('blur', async function () {
        if ($('#txtCodigoConsumo').val() != '') {
            try {
                $.LoadingOverlay('show');
                const codigoConsultado = pegaChave('#txtCodigoConsumo');
                window.location.href = `${btoa(codigoConsultado)}`;
            } catch (error) {
                msgErro('Não foi possível buscar os consumos.');
            } finally {
                $.LoadingOverlay('hide');
            }
        };
    });

    $('#tabelaConsumos').on('click', '#btn-excluirConsumo', async function (event) {
        event.preventDefault(); /// adicionado isso pois estava recarregando a pagina toda vez q clicava nesse botão
        msgAlerta('Você realmente deseja excluir esse consumo?', async () => {
            const data = $("#tabelaConsumos").DataTable().row($(this).parents("tr"));
            await data.remove().draw(false);
            const listaFormatada = await criaListaParaGravar();

            const url = '/sisplan/cadconsumo/v1/incluiconsumos?';
            const response = await requisicao('POST', url, `LISTADECONSUMOS=${encodeURIComponent(JSON.stringify({ LISTACONSUMOSCRIADOS: listaFormatada }))}`, '', 360000);

            if (response.status == 200) {
                criaMensagemSucesso('Consumo excluído com sucesso!', () => { window.location.href = window.location.href });
                return;
            };
        });
    });

    $('#btnExcluirConsumos').on('click', async function () {
        msgAlerta('Você realmente deseja excluir todos os consumos?', async () => {
            const registroData = $("#tabelaConsumos").DataTable().rows();
            const url = '/sisplan/cadconsumo/v1/excluitodosconsumos?';
            const response = await requisicao("DELETE", url, `CODIGO_PROD=${produtoCodigo}`, null);

            if (response.status === 400) {
                msgAlerta('Não foi possível fazer a exclusão dos consumos! Verifique.');
                return;
            }

            if (response.status === 200) {
                registroData.remove().draw(false);
                criaMensagemSucesso('Todos os consumos do produto foram excluídos com sucesso!', () => { window.location.href = window.location.href; });
                return;
            }

        });
    });

    $('#btnImprimir').on('click', async function (){
        try {
            $.LoadingOverlay("show");
            try {
                const url = `/sisplan/impressao/v1/imprimirconsumos?CODIGO_PRODUTO=${produtoCodigo}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelConsumos');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'RelConsumos');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function retornaCodigodoProdutoUrl() {
        const queryString = window.location.href;
        const parametros = queryString.split('/');
        const produtoUrl = atob(parametros[5]);
        await preencheInputCodigo(produtoUrl);

        return produtoUrl;
    };

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" style="width: 100%" id="btn-excluirConsumo">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    function retornaBotaoOpcoesGradeTam(data) {
        var retorno = '<div style="text-align:start;"> ' +
            `    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="btnOrdemGradeTam${data}" value="${data}" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ` +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            `    <button class="dropdown-item" style="width: 100%" type="button" value="${data}" title="Alterar" id="btn-alterarGradeConsumo">Alterar</button>  ` +
            `    <button class="dropdown-item" style="width: 100%" type="button" value="${data}" title="Excluir" id="btn-excluirGradeConsumo">Excluir</button>  ` +
            '</div>';
        return retorno;
    };

    async function retornaCoresProdInsumoTabConsumos(linhaDataTable) {
        const titulosColunas = $('#tabelaConsumos').DataTable().columns().header().toArray().map(function (header) {
            return header.textContent
        });

        titulosColunas.splice(0, 12);
        const coresProdInsumo = [];

        for (p = 0; p < titulosColunas.length; p++) {
            const tituloSemPipe = {
                Cor_P: titulosColunas[p].substring(0, titulosColunas[p].indexOf('|')),
                Cor_I: linhaDataTable[p + 12].substring(0, linhaDataTable[p + 12].indexOf('|')),
            };
            coresProdInsumo.push(tituloSemPipe);
        };
        return coresProdInsumo;
    };

    async function criaListaParaGravar() {
        const listaDeConsumos = [];

        const dataTabelaConsumosAntigos = $('#tabelaConsumos').DataTable().data().toArray();

        for (i = 0; i < dataTabelaConsumosAntigos.length; i++) {
            const consumoAntigo = {
                Produto_Codigo: produtoCodigo,
                Insumo_Tipo: dataTabelaConsumosAntigos[i][0],
                Insumo_IdCons: dataTabelaConsumosAntigos[i][1],
                Insumo_Ordem: dataTabelaConsumosAntigos[i][2],
                Insumo_Codigo: dataTabelaConsumosAntigos[i][3],
                Insumo_Descricao: dataTabelaConsumosAntigos[i][4],
                Insumo_Unidade: dataTabelaConsumosAntigos[i][5],
                Insumo_Setor: dataTabelaConsumosAntigos[i][6],
                Insumo_Aplicacao: dataTabelaConsumosAntigos[i][7],
                Insumo_Parte: dataTabelaConsumosAntigos[i][8],
                Insumo_Faixa: dataTabelaConsumosAntigos[i][9],
                Insumo_Preco: dataTabelaConsumosAntigos[i][10],
                Insumo_Consumo: dataTabelaConsumosAntigos[i][11],
                Insumo_ListaCores: await retornaCoresProdInsumoTabConsumos(dataTabelaConsumosAntigos[i]),
            };
            listaDeConsumos.push(consumoAntigo);
        };

        const buscaTamanhosProduto = await retornaGradeTamanhosProduto();

        if (listaGradesAdicionadasModal.length > 0) {
            for (p = 0; p < listaGradesAdicionadasModal.length; p++) {
                for (k = 0; k < buscaTamanhosProduto.length; k++) {
                    if (listaGradesAdicionadasModal[p].TAMANHOS_LISTA[k].Qtde_Consumo > 0) {
                        const consumoNovo = {
                            Produto_Codigo: produtoCodigo,
                            Insumo_Tipo: 'M',
                            Insumo_IdCons: '',
                            Insumo_Ordem: listaDeConsumos.length + 1,
                            Insumo_Codigo: listaGradesAdicionadasModal[p].INSUMO_CODIGO,
                            Insumo_Descricao: listaGradesAdicionadasModal[p].INSUMO_DESCRICAO,
                            Insumo_Unidade: listaGradesAdicionadasModal[p].INSUMO_UNIDADE,
                            Insumo_Setor: listaGradesAdicionadasModal[p].INSUMO_SETOR,
                            Insumo_Aplicacao: listaGradesAdicionadasModal[p].INSUMO_APL,
                            Insumo_Parte: listaGradesAdicionadasModal[p].INSUMO_PARTE,
                            Insumo_Faixa: listaGradesAdicionadasModal[p].TAMANHOS_LISTA[k].Tamanho,
                            Insumo_Preco: 'S',
                            Insumo_Consumo: listaGradesAdicionadasModal[p].TAMANHOS_LISTA[k].Qtde_Consumo,
                            Insumo_ListaCores: listaGradesAdicionadasModal[p].CORES_LISTA,
                        };
                        listaDeConsumos.push(consumoNovo);
                    };
                };
            };
        };

        return listaDeConsumos;
    };

    async function preencheInputCodigo(sCodigoConsumo) {
        const pesquisaDescricao = {
            tabela: 'PRODUTO',
            camposSelect: ['DESCRICAO', 'UNIDADE', 'FAIXA'],
            where: [`CODIGO = '${sCodigoConsumo}'`]
        };

        const jsonProduto = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDescricao));

        if (jsonProduto.length == 0) {
            return;
        };

        const pesquisaFaixaDesc = {
            tabela: 'FAIXA',
            camposSelect: ['DESCRICAO'],
            where: [`CODIGO = '${jsonProduto[0].FAIXA}'`]
        }

        const jsonFaixa = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFaixaDesc));

        if (jsonFaixa.length == 0) {
            return;
        };

        $('#txtCodigoConsumo').val(`[${sCodigoConsumo}] - ${jsonProduto[0].DESCRICAO} - ${jsonProduto[0].UNIDADE}`);
        $('#txtFaixaProduto').html(`${jsonFaixa[0].DESCRICAO}`);
        $('#txtCodigoProdTittle').html(`${sCodigoConsumo} - ${jsonProduto[0].DESCRICAO}`);
    };

    async function retornaCoresProduto(cbSomenteCorAtiva) {
        let whereCorAtiva = '';
        if (cbSomenteCorAtiva) {
            whereCorAtiva = `AND PA_ITEN.ATIVO = 'S'`;
        };
        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR', 'CADCOR.DESCRICAO'],
            where: [`PA_ITEN.CODIGO = '${produtoCodigo}' ${whereCorAtiva}`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        if (jsonStr.length == 0) {
            return;
        };
        const jsonFormatado = [];
        for (let i = 0; i < jsonStr.length; i++) {
            jsonFormatado.push(jsonStr[i].COR + '|' + jsonStr[i].DESCRICAO);
            coresCodigo.push(jsonStr[i].COR);
        };
        return jsonFormatado;
    };

    async function carregaDataTable(pesquisaInsumo, pesquisaCoresInsumo, cbSomenteCorAtiva) {

        if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
            $('#tabelaConsumos').DataTable().destroy();
            $('#tabelaConsumos').empty();
        };

        const dataSetCols = [];
        let dataSetData = [];
        const dataSetDataInfo = [];

        dataSetCols.push({
            title: "Tipo",
        });

        dataSetCols.push({
            title: "ID Cons",
        });

        dataSetCols.push({
            title: "Ordem",
        });

        dataSetCols.push({
            title: "Código",
        });

        dataSetCols.push({
            title: "Descrição",
        });

        dataSetCols.push({
            title: "Unid.",
        });

        dataSetCols.push({
            title: "Setor",
        });

        dataSetCols.push({
            title: "Aplic.",
        });

        dataSetCols.push({
            title: "Parte",
        });

        dataSetCols.push({
            title: "Faixa",
        });

        dataSetCols.push({
            title: "Preço",
        });

        dataSetCols.push({
            title: "Consumo",
        });


        const coresdoProduto = await retornaCoresProduto(cbSomenteCorAtiva);

        for (j in coresdoProduto) {
            dataSetCols.push({
                title: coresdoProduto[j],
            });
        };

        let contadorConsumo = 0;

        for (i in pesquisaInsumo) {
            contadorConsumo++

            dataSetData.push(pesquisaInsumo[i].TIPO == 'P' ? 'P' : 'M');

            dataSetData.push(pesquisaInsumo[i].ID_CONS);

            dataSetData.push(contadorConsumo);

            dataSetData.push(pesquisaInsumo[i].INSUMO);

            dataSetData.push(pesquisaInsumo[i].DESCRICAO);

            dataSetData.push(pesquisaInsumo[i].UNIDADE);

            dataSetData.push(pesquisaInsumo[i].SETOR);

            dataSetData.push(pesquisaInsumo[i].APLICACAO);

            dataSetData.push(pesquisaInsumo[i].PARTE);

            dataSetData.push(pesquisaInsumo[i].FAIXA);

            dataSetData.push(pesquisaInsumo[i].PRECO);

            dataSetData.push(pesquisaInsumo[i].CONSUMO);

            for (y in coresdoProduto) {
                const indiceCodigoCor = coresdoProduto[y].indexOf('|');
                const apenasCodigoCor = coresdoProduto[y].substring(0, indiceCodigoCor);
                const data = pesquisaCoresInsumo.filter(coresInsumo => coresInsumo.ID == pesquisaInsumo[i].ID && coresInsumo.COR == apenasCodigoCor);
                if (data.length > 0) {
                    dataSetData.push(data[0].COR_I + '|' + data[0].DESC_COR);
                } else {
                    dataSetData.push('');
                }

            };

            dataSetDataInfo.push(dataSetData);
            dataSetData = [];
        }

        if (pesquisaInsumo == 0 && pesquisaCoresInsumo == 0) {
            $('#tabelaConsumos').DataTable({
                bPaginate: false,
                autoWidth: true,
                searching: false,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columns: dataSetCols,
            });
        } else {
            $('#tabelaConsumos').DataTable({
                bPaginate: false,
                searching: false,
                scrollX: false,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                columns: dataSetCols,
                data: dataSetDataInfo,
                columnDefs: [
                    {
                        targets: [11],
                        render(data) {
                            return parseFloat(data).toFixed(5).replace('.', ',')
                        }
                    },
                    {
                        targets: [1],
                        render(data) {
                            return retornaBotaoOpcoes(data)
                        }
                    },
                ]
            });
        }
    };

    async function fazConsulta(cbSomenteCorAtiva) {
        const PesquisaInsumo = {
            tabela: "PCPFT2",
            camposSelect: ["PCPFT2.*",
                "CASE WHEN PCPFT2.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO",
                "CASE WHEN PCPFT2.TIPO = 'P' THEN PRODUTO.UNIDADE ELSE MATERIAL.UNIDADE END UNIDADE",
                "PCPAPL.DESCRICAO DESC_APL",
                "TIPO_APL.DESCRICAO AS DESC_PARTE"
            ],
            leftJoin: [
                { "tabela": "MATERIAL", "condicao": "PCPFT2.INSUMO = MATERIAL.CODIGO" },
                { "tabela": "PRODUTO", "condicao": "PCPFT2.INSUMO = PRODUTO.CODIGO" },
                { "tabela": "PCPAPL", "condicao": "PCPAPL.CODIGO = PCPFT2.APLICACAO" },
                { "tabela": "TIPO_APL", "condicao": "PCPFT2.PARTE = TIPO_APL.CODIGO" }
            ],
            where: [`PCPFT2.CODIGO = '${produtoCodigo}'`],
            orderBy: ["PCPFT2.ID"]
        };

        const jsonStrPesquisaInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaInsumo));

        const PesquisaCoresInsumo = {
            tabela: "PCPFT3",
            camposSelect: ["PCPFT3.COR_I",
                "PCPFT3.LOTE_TINTUR",
                "CADCOR.DESCRICAO DESC_COR",
                "PCPFT3.ID",
                "PCPFT3.COR",
                "CADCOR2.DESCRICAO DESC_COR2",
                "PCPFT3.CODIGO"
            ],
            leftJoin: [
                { "tabela": "CADCOR", "condicao": "PCPFT3.COR_I = CADCOR.COR" },
                { "tabela": "CADCOR", "alias": "CADCOR2", "condicao": "PCPFT3.COR = CADCOR2.COR" }
            ],
            where: [`PCPFT3.CODIGO = '${produtoCodigo}'`]
        };

        const jsonStrPesquisaCoresInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCoresInsumo));

        await carregaDataTable(jsonStrPesquisaInsumo, jsonStrPesquisaCoresInsumo, cbSomenteCorAtiva);
    };

    await fazConsulta(false);

    await preencheDivConsumosPorTamanho();
    await retornaCoresDoProduto();
    await criaDataTableCoresInsumo(false);

    /// aqui começa as funções do modal de manutenção 

    function bloqueiaCamposModal() {
        $('#txtInsumo').prop('disabled', true);
        $('#txtSetorInsumo').prop('disabled', true);
        $('#txtAplicacaoInsumo').prop('disabled', true);
        $('#txtParteInsumo').prop('disabled', true);
        $('#btn-CodigoInsumo').prop('disabled', true);
        $('#btn-limpa-CodigoInsumo').prop('disabled', true);
        $('#btn-SetorInsumo').prop('disabled', true);
        $('#btn-limpa-SetorInsumo').prop('disabled', true);
        $('#btn-AplicacaoInsumo').prop('disabled', true);
        $('#btn-limpa-AplicacaoInsumo').prop('disabled', true);
        $('#btn-ParteInsumo').prop('disabled', true);
        $('#btn-limpa-ParteInsumo').prop('disabled', true);
        $('#btn-limpa-CodigoInsumo').prop('disabled', true);
        $('.inputsTamanho').prop('disabled', true);
        $('.inputsCorInsumo').prop('disabled', true);
    };

    function desbloqueiaCamposModal() {
        $('#txtInsumo').prop('disabled', false);
        $('#txtSetorInsumo').prop('disabled', false);
        $('#txtAplicacaoInsumo').prop('disabled', false);
        $('#txtParteInsumo').prop('disabled', false);
        $('.inputsCorInsumo').prop('disabled', false);
        $('.inputsTamanho').prop('disabled', false);
        $('#btn-CodigoInsumo').prop('disabled', false);
        $('#btn-limpa-CodigoInsumo').prop('disabled', false);
        $('#btn-SetorInsumo').prop('disabled', false);
        $('#btn-limpa-SetorInsumo').prop('disabled', false);
        $('#btn-AplicacaoInsumo').prop('disabled', false);
        $('#btn-limpa-AplicacaoInsumo').prop('disabled', false);
        $('#btn-ParteInsumo').prop('disabled', false);
        $('#btn-limpa-ParteInsumo').prop('disabled', false);
        $('#btn-limpa-CodigoInsumo').prop('disabled', false);
    };

    function retornaInputDeCorInsumo() {
        return `<div class="input-group">
        <input type="text" autocomplete="off" class="input-default focus form-control inputsCorInsumo" disabled id="txtCorInsumo${contadorInputCorInsumo}" name="txtCorInsumo${contadorInputCorInsumo}" class="form-control">
        <div class="input-group-append">
            <button class="btn bg-danger btn-consumo" id="btn-CorInsumo${contadorInputCorInsumo}" name="btn-CorInsumo${contadorInputCorInsumo}" data-button="absolute" type="button" hidden><i class="m-0 p-0 fas fa-search"></i></button>
        </div>
        </div>`
    };

    function retornaInputDeDescricaoInsumo() {
        return `<input type="text" class="input-default form-control descInsumo" disabled id="txtDescricaoInsumo${contadorInputCorInsumo}" class="form-control"></input>`
    };

    async function retornaCoresDoProduto() {

        const dataSetCols = [];

        dataSetCols.push({
            title: 'Cor',
            data: 'COR'
        });

        dataSetCols.push({
            title: 'Descrição',
            data: 'DESCRICAO'
        });

        dataSetCols.push({
            title: 'Cor Insumo(F4)',
            data: 'CAMPOVAZIO1'
        });

        dataSetCols.push({
            title: 'Descrição Cor Insumo',
            data: 'CAMPOVAZIO2'
        });

        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR', 'CADCOR.DESCRICAO', `'CAMPOVAZIO1' AS CAMPOVAZIO1`, `'CAMPOVAZIO2' AS CAMPOVAZIO2 `],
            where: [`PA_ITEN.CODIGO = '${produtoCodigo}'`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length == 0) {
            return;
        };

        if ($.fn.DataTable.isDataTable('#tabelaCoresProduto')) {
            $("#tabelaCoresProduto").DataTable().destroy();
            $("#tabelaCoresProduto").empty();
        };

        $('#tabelaCoresProduto').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            autoWidth: true,
            scrollY: '100px',
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
            columnDefs: [
                {
                    targets: [2, 3], render: function (data) {
                        if (data == 'CAMPOVAZIO1') {
                            contadorInputCorInsumo++
                            return retornaInputDeCorInsumo();
                        } else if (data == 'CAMPOVAZIO2') {
                            return retornaInputDeDescricaoInsumo();
                        }
                    }
                }
            ],
            data: jsonStr,
        });
    };

    async function preencheDivConsumosPorTamanho() {
        const tamanhosProd = await retornaGradeTamanhosProduto();
        let divConsumosData = []
        if (tamanhosProd.length > 0) {
            for (k in tamanhosProd) {
                divConsumosData.push(`<div class="col-md-3 col-3 col-sm-3" id="idGradeTamanhosInfoTour">
                <label data-error="wrong" data-success="right" class="label-tamanho" for="txtTamanho${tamanhosProd[k].TAMANHO}">${tamanhosProd[k].TAMANHO}</label>
                <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control inputsTamanho" disabled id="txtTamanho${tamanhosProd[k].TAMANHO}" name="txtTamanho${tamanhosProd[k].TAMANHO}" class="form-control">
                </div>
            </div>`)
            }
        }
        $('#divConsumosPTamanho').append(divConsumosData);
    };

    async function retornaGradeTamanhosProduto() {
        const pesquisaTamanhos = {
            tabela: 'PRODUTO',
            camposSelect: ['FAIXA_ITEN.TAMANHO '],
            innerJoin: [
                { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA" }
            ],
            where: [`PRODUTO.CODIGO = '${produtoCodigo}'`],
            orderBy: ['FAIXA_ITEN.POSICAO']
        };

        const jsonStrTamanhos = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaTamanhos));

        return jsonStrTamanhos;
    };

    async function criaPesquisas() {

        const insumoCodigo = pegaChave('#txtInsumo')

        if (insumoCodigo == '') {
            return;
        }

        const qtdeCores = await retornaCoresProduto();

        for (l = 1; l <= qtdeCores.length; l++) {
            $(`#btn-CorInsumo${l}`).pesquisa_serverside([`#txtCorInsumo${l}`, `#txtDescricaoInsumo${l}`], ['CADCOR.COR', 'CADCOR.DESCRICAO'], ['CADCOR.DESCRICAO', 'CADCOR.COR'], `{"tabela":"MAT_ITEN", "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO"], "innerJoin": [{"tabela": "CADCOR", "condicao": "CADCOR.COR = MAT_ITEN.COR" }], "where": ["MAT_ITEN.CODIGO = '${insumoCodigo}'"], "groupBy": ["CADCOR.COR", "CADCOR.DESCRICAO"]}`, 'Pesquisa de Cor', '', [true, true]);
        }
    };

    function limpaCampos() {
        $('.inputsTamanho').val('');
        $('.inputsCorInsumo').val('');
        $('.descInsumo').val('');
        $('#txtInsumo').val('');
        $('#txtSetorInsumo').val('');
        $('#txtAplicacaoInsumo').val('');
        $('#txtParteInsumo').val('');
    };

    async function pesquisaUnidadeInsumo() {

        if ($('#txtInsumo').val() == '') {
            return;
        }

        const pesquisaUnidadeInsumo = {
            tabela: 'MATERIAL',
            camposSelect: ['UNIDADE'],
            where: [`CODIGO = '${pegaChave('#txtInsumo')}'`],
        };

        const jsonStrTamanhos = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaUnidadeInsumo));

        return jsonStrTamanhos[0].UNIDADE;
    };

    async function pesquisaSetorInsumo(setor) {

        if (setor == '') {
            return;
        }

        const pesquisaSetorInsumo = {
            tabela: 'CADFLUXO',
            camposSelect: ['CODIGO', 'DESCRICAO'],
            where: [`CODIGO = '${setor}'`],
        };

        const jsonStrSetor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaSetorInsumo));

        const setorFormatado = `[${jsonStrSetor[0].CODIGO}] - ${jsonStrSetor[0].DESCRICAO}`

        return setorFormatado;
    };

    async function pesquisaAplicacaoInsumo(aplicacao) {

        if (aplicacao == '') {
            return;
        }

        const pesquisaAplicacaoinsumo = {
            tabela: 'PCPAPL',
            camposSelect: ['CODIGO', 'DESCRICAO'],
            where: [`CODIGO = '${aplicacao}'`],
        };

        const jsonStrAplicacao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaAplicacaoinsumo));

        const aplicacaoFormatada = `[${jsonStrAplicacao[0].CODIGO}] - ${jsonStrAplicacao[0].DESCRICAO}`

        return aplicacaoFormatada;
    };

    async function pesquisaParteInsumo(parte) {

        if (parte == '') {
            return;
        }

        const pesquisaParteInsumo = {
            tabela: 'TIPO_APL',
            camposSelect: ['CODIGO', 'DESCRICAO'],
            where: [`CODIGO = '${parte}'`],
        };

        const jsonStrParte = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParteInsumo));

        const parteFormatada = `[${jsonStrParte[0].CODIGO}] - ${jsonStrParte[0].DESCRICAO}`

        return parteFormatada;
    };

    async function adicionaRegistroGradeTam() {

        ///pelo amor de Deus, se tiver duvida, pergunta, nao mexa nisso sem saber o pq das coisa..... bruno

        const novoRegistro = [];
        const novaRow = {};
        const listaCoresProd = [];
        const listaTamanhosProd = [];

        const qtdeTamanhos = await retornaGradeTamanhosProduto();
        const dataTableCoresProd = $('#tabelaCoresProduto').DataTable().data().toArray();

        ordemManutencao = ordemManutencao + 1;
        const insumoCodigo = pegaChave('#txtInsumo');
        const insumoDescricao = pegaDescricao('#txtInsumo');
        const setorInsumo = pegaChave('#txtSetorInsumo');
        const aplInsumo = pegaChave('#txtAplicacaoInsumo');
        const parteInsumo = pegaChave('#txtParteInsumo');
        const unidadeInsumo = $('#txtUndInsumo').val();

        novoRegistro.push(retornaBotaoOpcoesGradeTam(ordemManutencao));
        novoRegistro.push(insumoCodigo);
        novoRegistro.push(insumoDescricao);
        novoRegistro.push(unidadeInsumo);
        novoRegistro.push(setorInsumo);
        novoRegistro.push(aplInsumo);
        novoRegistro.push(parteInsumo);

        for (j = 0; j < dataTableCoresProd.length; j++) {
            const CorProdInsumo = {
                Cor_P: dataTableCoresProd[j].COR,
                Cor_I: $(`#txtCorInsumo${j + 1}`).val(),
                DescCor_I: $(`#txtDescricaoInsumo${j + 1}`).val()
            };
            listaCoresProd.push(CorProdInsumo);
        };

        for (i = 0; i < qtdeTamanhos.length; i++) {
            let tamanhoQtdes = $(`#txtTamanho${qtdeTamanhos[i].TAMANHO}`).val();
            const qtdeFormatada = parseFloat(tamanhoQtdes == '' ? 0 : tamanhoQtdes).toFixed(5);
            novoRegistro.push(qtdeFormatada);
            const TamanhoProdInsumo = {
                Tamanho: qtdeTamanhos[i].TAMANHO,
                Qtde_Consumo: qtdeFormatada
            }
            listaTamanhosProd.push(TamanhoProdInsumo);
        };

        novaRow.CODIGO_PROD = produtoCodigo;
        novaRow.ORDEM = ordemManutencao;
        novaRow.INSUMO_CODIGO = insumoCodigo;
        novaRow.INSUMO_DESCRICAO = insumoDescricao;
        novaRow.INSUMO_UNIDADE = unidadeInsumo;
        novaRow.INSUMO_SETOR = setorInsumo;
        novaRow.INSUMO_APL = aplInsumo;
        novaRow.INSUMO_PARTE = parteInsumo;
        novaRow.CORES_LISTA = listaCoresProd;
        novaRow.TAMANHOS_LISTA = listaTamanhosProd;

        listaGradesAdicionadasModal.push(novaRow);
        $('#tabelaGradeTamanho').DataTable().row.add(novoRegistro).draw(false);

        limpaCampos();
        bloqueiaCamposModal();
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
        indiceSelecionado = -1;
    };

    async function alteraRegistroGradeTam() {

        ///pelo amor de Deus, se tiver duvida, pergunta, nao mexa nisso sem saber o pq das coisa..... bruno

        if (ordemSendoAlterada == -1) {
            return;
        }

        const qtdeTamanhos = await retornaGradeTamanhosProduto();
        const i = btnAltera.index();
        const linhaAlterada = $('#tabelaGradeTamanho').DataTable().row([i]);
        const linhaAlteradaData = linhaAlterada.data();
        const indiceLista = listaGradesAdicionadasModal.findIndex(index => index.ORDEM == ordemSendoAlterada);
        const qtdeCoresProd = $('#tabelaCoresProduto').DataTable().data().toArray();

        if (linhaAlteradaData == '') {
            return;
        };

        linhaAlteradaData[1] = pegaChave('#txtInsumo');
        listaGradesAdicionadasModal[indiceLista].INSUMO_CODIGO = pegaChave('#txtInsumo');
        linhaAlteradaData[2] = pegaDescricao('#txtInsumo');
        listaGradesAdicionadasModal[indiceLista].INSUMO_DESCRICAO = pegaDescricao('#txtInsumo');
        linhaAlteradaData[3] = $('#txtUndInsumo').val();
        listaGradesAdicionadasModal[indiceLista].INSUMO_UNIDADE = $('#txtUndInsumo').val();
        linhaAlteradaData[4] = pegaChave('#txtSetorInsumo');
        listaGradesAdicionadasModal[indiceLista].INSUMO_SETOR = pegaChave('#txtSetorInsumo');
        linhaAlteradaData[5] = pegaChave('#txtAplicacaoInsumo');
        listaGradesAdicionadasModal[indiceLista].INSUMO_APL = pegaChave('#txtAplicacaoInsumo');
        linhaAlteradaData[6] = pegaChave('#txtParteInsumo');
        listaGradesAdicionadasModal[indiceLista].INSUMO_PARTE = pegaChave('#txtParteInsumo');

        for (g = 0; g < qtdeCoresProd.length; g++) {
            const indiceCorProduto = listaGradesAdicionadasModal[indiceLista].CORES_LISTA.findIndex(index => index.Cor_P == $('#tabelaCoresProduto').DataTable().data().toArray()[g].COR);
            listaGradesAdicionadasModal[indiceLista].CORES_LISTA[indiceCorProduto].Cor_I = $(`#txtCorInsumo${g + 1}`).val();
            listaGradesAdicionadasModal[indiceLista].CORES_LISTA[indiceCorProduto].DescCor_I = $(`#txtDescricaoInsumo${g + 1}`).val();
        };

        for (b = 0; b < qtdeTamanhos.length; b++) {
            const qtdeFormatt = $(`#txtTamanho${qtdeTamanhos[b].TAMANHO}`).val();
            linhaAlteradaData[b + 7] = parseFloat(qtdeFormatt == '' ? 0 : qtdeFormatt).toFixed(5);
            const indiceTamProduto = listaGradesAdicionadasModal[indiceLista].TAMANHOS_LISTA.findIndex(index => index.Tamanho == qtdeTamanhos[b].TAMANHO);
            listaGradesAdicionadasModal[indiceLista].TAMANHOS_LISTA[indiceTamProduto].Qtde_Consumo = $(`#txtTamanho${qtdeTamanhos[b].TAMANHO}`).val();
        };

        linhaAlterada.data(linhaAlteradaData);

        limpaCampos();
        bloqueiaCamposModal();
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
        indiceSelecionado = -1;
    };

    async function criaDataTableCoresInsumo(insumoTaInformado) {

        if ($.fn.DataTable.isDataTable('#tabelaCoresInsumo')) {
            $("#tabelaCoresInsumo").DataTable().destroy();
            $("#tabelaCoresInsumo").empty();
        };

        const insumoPesquisado = pegaChave('#txtInsumo');

        const pesquisaCoresInsumo = {
            tabela: 'MAT_ITEN',
            camposSelect: ['DISTINCT CADCOR.COR', 'CADCOR.DESCRICAO'],
            innerJoin: [
                { "tabela": "CADCOR", "condicao": "CADCOR.COR = MAT_ITEN.COR" }
            ],
            where: [`MAT_ITEN.CODIGO = '${insumoPesquisado}'`],
        };

        const jsonStrCoresInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCoresInsumo));

        const colunasDataTable = [];

        colunasDataTable.push({
            'title': 'Cor',
            'data': 'COR',
        });

        colunasDataTable.push({
            'title': 'Descrição',
            'data': 'DESCRICAO'
        });

        if (insumoTaInformado && insumoPesquisado != '') {

            $('#tabelaCoresInsumo').DataTable({
                bPaginate: false,
                order: false,
                sort: false,
                autoWidth: true,
                scrollY: '100px',
                searching: false,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columns: colunasDataTable,
                data: jsonStrCoresInsumo,
            });

        } else {

            $('#tabelaCoresInsumo').DataTable({
                bPaginate: false,
                order: false,
                sort: false,
                autoWidth: true,
                scrollY: '100px',
                searching: false,
                destroy: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                columns: colunasDataTable,
            });
        }
    };

    async function criaDataTableGradeTam() {

        if ($.fn.DataTable.isDataTable('#tabelaGradeTamanho')) {
            $("#tabelaGradeTamanho").DataTable().destroy();
            $("#tabelaGradeTamanho").empty();
        };

        const tamanhosProduto = await retornaGradeTamanhosProduto();

        const dataSetCols = [];

        dataSetCols.push({
            'title': 'Ordem',
        });

        dataSetCols.push({
            'title': 'Código',
        });

        dataSetCols.push({
            'title': 'Descrição',
        });

        dataSetCols.push({
            'title': 'Unid.',
        });

        dataSetCols.push({
            'title': 'Setor',
        });

        dataSetCols.push({
            'title': 'Aplic.',
        });

        dataSetCols.push({
            'title': 'Parte.',
        });

        if (tamanhosProduto.length > 0) {
            for (i in tamanhosProduto) {
                dataSetCols.push({
                    'title': `${tamanhosProduto[i].TAMANHO}`,
                })
            };
        };

        $('#tabelaGradeTamanho').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            autoWidth: true,
            // scrollY: '150px',
            searching: false,
            destroy: true,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            columns: dataSetCols,
        });
    };

    $('#modal-manutencaoconsumos').on('show.bs.modal', async function () {
        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableGradeTam();
        $('#btn-CodigoInsumo').pesquisa_serverside([`#txtInsumo`], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO", "UNIDADE", "CODCLI", "GRUPO", "SUB_GRUPO", "CODFIS", "CODTRI", "LINHA", "ATIVO", "EMP_ID"], "where": ["1=1"]}`, 'Pesquisa de Material');
        $('#txtInsumo').autocompleta(1, 'JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-CodigoInsumo').on('click', function () {
            $('#txtInsumo').val('');
        });
        $('#btn-SetorInsumo').pesquisa_serverside(['#txtSetorInsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":["CODIGO","DESCRICAO", "ORDEM", "CUSTO", "ATIVO", "TIPO"], "where": null}', 'Pesquisa de Setor');
        $('#txtSetorInsumo').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-SetorInsumo').on('click', function () {
            $('#txtSetorInsumo').val('');
        });
        $('#btn-AplicacaoInsumo').pesquisa_serverside(['#txtAplicacaoInsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PCPAPL", "camposSelect":["DESCRICAO", "TIPOAPL", "ATIVO", "CODIGO", "TIPO"], "where": null}', 'Pesquisa de Aplicação');
        $('#txtAplicacaoInsumo').autocompleta(1, 'JSON={ "tabela":"PCPAPL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-AplicacaoInsumo').on('click', function () {
            $('#txtAplicacaoInsumo').val('');
        });
        $('#btn-ParteInsumo').pesquisa_serverside(['#txtParteInsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TIPO_APL", "camposSelect":["DESCRICAO", "ATIVO", "CODIGO", "ESTOQUE"], "where": null}', 'Pesquisa de Parte');
        $('#txtParteInsumo').autocompleta(1, 'JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-ParteInsumo').on('click', function () {
            $('#txtParteInsumo').val('');
        })
    });

    $('#modal-manutencaoconsumos').on('shown.bs.modal', async function () {
        $('#tabelaCoresProduto').DataTable().columns.adjust().draw(false);
        $('#tabelaCoresInsumo').DataTable().columns.adjust().draw(false);
        $('#tabelaGradeTamanho').DataTable().columns.adjust().draw(false);


        $('.inputsCorInsumo').on('focusin', async function () {
            $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
            $(this).closest('tr').addClass("selected");
            let linhaSelected = $($('#tabelaCoresProduto tr.selected')[0]).index();
            indiceSelecionado = linhaSelected + 1;
            listaCoresProdutoAlteradas.push($(`#txtCorInsumo${indiceSelecionado}`)[0].id)
        });

        /// gambiarra, mas funcionou, time que ta ganhando nao mexe - Bruno
        $(`.inputsCorInsumo`).on('change', async function () {
            if ($(`#txtCorInsumo${indiceSelecionado}`).val() == '') {
                $(`#txtDescricaoInsumo${indiceSelecionado}`).val('');
            };
        });

        $('#txtInsumo').on('blur', async function () {
            await criaPesquisas();
            await criaDataTableCoresInsumo(true);
            $('#txtUndInsumo').val(await pesquisaUnidadeInsumo());
        });

        $('.inputsTamanho').on('blur', async function () {
            const qtdeInputTamanho = Number($(this).val().replace(',', '.'));
            $(this).val(qtdeInputTamanho.toFixed(5));
        });
    });

    $('#modal-manutencaoconsumos').on('hide.bs.modal', async function () {
        listaCoresProdutoAlteradas = [''];
        listaGradesAdicionadasModal = [''];
        ordemManutencao = 0;
        incluindoGradeTam = false;
        alterandoGradeTam = false;
        btnAltera = '';
    });

    $('#btnIncluirGrade').on('click', async function () {
        alterandoGradeTam = false;
        incluindoGradeTam = true;
        desbloqueiaCamposModal();
        $('#btnConfirmarGrade').removeClass('d-none');
        $('#btnCancelarGrade').removeClass('d-none');
        $('#btnIncluirGrade').addClass('d-none');
    });

    $('#btnCancelarGrade').on('click', async function () {
        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableCoresInsumo(false);
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        incluindoGradeTam = false;
        alterandoGradeTam = false;
        btnAltera = '';
    });

    $('#btnDesistirManutencao').on('click', async function () {
        $('#modal-manutencaoconsumos').modal('hide');
        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableCoresInsumo(false);
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        incluindoGradeTam = false;
        alterandoGradeTam = false;
        btnAltera = '';
    });

    $('#btnGravarManutencao').on('click', async function () {
        const qtdeRegistrosNovos = $('#tabelaGradeTamanho').DataTable().data().toArray();

        if (qtdeRegistrosNovos < 0) {
            msgErro('Não existe nenhum registro novo para gravar!');
            return;
        };

        try {
            $.LoadingOverlay('show');

            const listaFormatada = await criaListaParaGravar();

            const url = '/sisplan/cadconsumo/v1/incluiconsumos?';
            const response = await requisicao('POST', url, `LISTADECONSUMOS=${encodeURIComponent(JSON.stringify({ LISTACONSUMOSCRIADOS: listaFormatada }))}`, '', 360000);

            if (response.status == 200) {
                criaMensagemSucesso('Consumos cadastrados com sucesso!', () => { window.location.href = window.location.href; });
                return;
            };

            if (response.status != 200) {
                msgErro('Não foi possível cadastrar os consumos! Verifique.');
                return;
            };

        } catch (error) {
            console.error(error);
            msgErro('Não foi possível cadastrar os consumos! Verifique.');
        } finally {
            $.LoadingOverlay('hide');
            // window.location.href = window.location.href;
        };
    });

    $('#btnConfirmarGrade').on('click', async function () {
        const qtdeCoresProd = $('#tabelaCoresProduto').DataTable().data().toArray();

        if ($('#txtInsumo').val() == '') {
            msgErro('Insumo não informado! Por favor, verifique.');
            return;
        };

        if ($('#txtSetorInsumo').val() == '') {
            msgErro('Setor não informado! Por favor, verifique.');
            return;
        };

        if ($('#txtAplicacaoInsumo').val() == '') {
            msgErro('Aplicação não informada! Por favor, verifique.');
            return;
        };

        let NaoExisteCorInsumoInformada = false;

        for (i = 0; i < qtdeCoresProd.length; i++) {
            if ($(`#txtCorInsumo${i + 1}`).val() !== '' && $(`#txtCorInsumo${i + 1}`).val() !== undefined) {
                NaoExisteCorInsumoInformada = true;
                break;
            };
        };

        if (!NaoExisteCorInsumoInformada) {
            msgErro('Não foi informado nenhuma cor de insumo.');
            return;
        };

        if (alterandoGradeTam) {
            await alteraRegistroGradeTam();
            ordemSendoAlterada = -1;
            btnAltera = '';
        } else {
            await adicionaRegistroGradeTam();
        }

        incluindoGradeTam = false;
        alterandoGradeTam = false;
        await criaDataTableCoresInsumo(false);

    });

    $('#tabelaGradeTamanho').on('click', '#btn-excluirGradeConsumo', async function () {
        const data = $("#tabelaGradeTamanho").DataTable().row($(this).parents("tr"));
        const btnOrdem = $($(this).parents("tr"));
        const ordemRemovida = btnOrdem[0].cells[0].children[0].children[0].value;
        const indiceAremover = listaGradesAdicionadasModal.findIndex(index => index.ORDEM == ordemRemovida)
        listaGradesAdicionadasModal.splice(indiceAremover, 1);
        data.remove().draw(false);
    });

    $('#tabelaGradeTamanho').on('click', '#btn-alterarGradeConsumo', async function () {
        if (alterandoGradeTam) {
            alert('Você já está alterando um registro! Finalize a alteração.');
            return;
        };

        alterandoGradeTam = true;
        incluindoGradeTam = false;
        const data = $("#tabelaGradeTamanho").DataTable().row($(this).parents("tr"));
        btnAltera = $(this)
        const btnOrdem = $($(this).parents("tr"));
        const ordemAlterada = btnOrdem[0].cells[0].children[0].children[0].value;
        const qtdeCores = $('#tabelaCoresProduto').DataTable().data().toArray();
        const rowData = data.data();
        desbloqueiaCamposModal();
        const qtdeTamanhosProd = await retornaGradeTamanhosProduto();
        $('#btnConfirmarGrade').removeClass('d-none');
        $('#btnCancelarGrade').removeClass('d-none');
        $('#btnIncluirGrade').addClass('d-none');

        ordemSendoAlterada = ordemAlterada;

        const indiceRegistro = listaGradesAdicionadasModal.findIndex(index => index.ORDEM == ordemAlterada);

        $('#txtInsumo').val(`[${rowData[1]}] - ${rowData[2]}`);
        $('#txtSetorInsumo').val(await pesquisaSetorInsumo(rowData[4]));
        $('#txtUndInsumo').val(`${rowData[3]}`);
        $('#txtAplicacaoInsumo').val(await pesquisaAplicacaoInsumo(rowData[5]));
        $('#txtParteInsumo').val(await pesquisaParteInsumo(rowData[6]))

        for (k = 0; k < qtdeTamanhosProd.length; k++) {
            $(`#txtTamanho${qtdeTamanhosProd[k].TAMANHO}`).val(rowData[k + 7]);
        };

        for (h = 0; h < qtdeCores.length; h++) {
            const indiceCorProduto = listaGradesAdicionadasModal[indiceRegistro].CORES_LISTA.findIndex(index => index.Cor_P == $('#tabelaCoresProduto').DataTable().data().toArray()[h].COR);
            $(`#txtCorInsumo${h + 1}`).val(listaGradesAdicionadasModal[indiceRegistro].CORES_LISTA[indiceCorProduto].Cor_I);
            $(`#txtDescricaoInsumo${h + 1}`).val(listaGradesAdicionadasModal[indiceRegistro].CORES_LISTA[indiceCorProduto].DescCor_I);
        };
    });


















































































});