/* eslint-disable prefer-destructuring */
async function avancarPag() {
    if ($("#txtCodigo").val() == '') {
        $("#txtCodigo").val(' ');
    }
    if ($("#txtBanco").val() == '') {
        $("#txtBanco").val(' ');
    }
    if ($("#txtAgencia").val() == '') {
        $("#txtAgencia").val(' ');
    }
    if ($("#txtConta").val() == '') {
        $("#txtConta").val(' ');
    }
    if ($("#txtDescricao").val() == '') {
        $("#txtDescricao").val(' ');
    }
}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'avancar2')) {
                    $('#avancar2').trigger('click');
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'contas') {
                    $('#voltar').trigger('click');
                }
                if (Element.node.id == 'tipoDep') {
                    $('#voltar2').trigger('click');
                }
                if (Element.node.id == 'configuracao') {
                    $('#voltar3').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o registro que estamos criando ou alterando.',
                position: 'top'
            }
        },
        {
            element: "#txtAgencia",
            popover: {
                title: "Agência",
                description:
                    "Neste campo adicionamos a agência do banco.",
                position: "top",
            },
        },
        {
            element: "#txtBanco",
            popover: {
                title: "Banco",
                description:
                    "Aqui, selecionamos o banco desejado..",
                position: "top",
            },
        },
        {
            element: "#txtConta",
            popover: {
                title: "Conta",
                description:
                    "Neste campo adicionamos a conta.",
                position: "top",
            },
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a tela de consulta.',
                position: 'left'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#contas',
            popover: {
                title: 'Contas',
                description: 'Aqui estão os campos disponíveis para cadastrar as contas.',
                position: 'top'
            }
        },
        {
            element: '#avancar2',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#configuracao',
            popover: {
                title: 'Configurações da Conta',
                description: 'Aqui você selecionará algumas configurações.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a conta.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let conta = parametros[parametros.length - 1];

    let contaFs = 1;

    $("#checkAtivo").attr("checked", true);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADCONTA', getCookie('usuario'), String(conta));
        window.location.href = `${BASE_URI}/cadconta`;
    });

    $(function () {
        $('#txtLimite').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
    });


    $(document).ready(function () {

        let currentFs; let nextFs; let previousFs;
        let opacity;

        $(".next").click(function () {

            contaFs += 1;

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                currentFs = $(this).parent();
                nextFs = $(this).parent().next();

                $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0
                }, {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            'display': 'none',
                            'position': 'relative'
                        });
                        nextFs.css({
                            'opacity': opacity
                        });
                    },
                    duration: 600
                });
            }
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
                txtBanco: {
                    required: true,
                },
                txtAgencia: {
                    required: true,
                },
                txtConta: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida.",
                },
                txtBanco: {
                    required: "Informe um banco válido."
                },
                txtAgencia: {
                    required: "Informe uma agência válida."
                },
                txtConta: {
                    required: "Informe uma conta válida."
                }

            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $(".previous").click(function () {

            contaFs -= 1;

            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();
            $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
            previousFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        });

        $(".submit").click(function () {
            return false;
        });
    });

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    if ($("#txtCNPJ").length > 11) {
        $("#txtCNPJ").mask("00.000.000/0000-00", options);
    } else {
        $("#txtCNPJ").mask("000.000.000-00#", options);
    }

    $("#txtCNPJ").on('change', function () {
        let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
        if (validaCNPJ != false) {
            $("#txtCNPJ").val(validaCNPJ);
        }
    });

    $('#txtCodigo').prop('disabled', true);

    $('#txtBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
    $('#btnBanco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, 'Pesquisa Banco', 'CADBAN');
    $('#txtContaDebito1').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnContaDebito').pesquisa('#txtContaDebito1', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Débido', 'CONTA_CONT');
    $('#txtContaCredito1').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnContaCredito').pesquisa('#txtContaCredito1', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Crédito', 'CONTA_CONT');
    $('#txtContaCreditada').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnContaCreditada').pesquisa('#txtContaCreditada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Creditada', 'CADCONTA');

    $('#btnExcluiBanco').on('click', function () {
        $('#txtBanco').val('');
    });

    $('#btnAContaDebito').on('click', function () {
        $('#txtContaDebito1').val('');
    });

    $('#btnAContaCredito').on('click', function () {
        $('#txtContaCredito1').val('');
    });

    $('#btnLimpaContaCreditada').on('click', function () {
        $('#txtContaCreditada').val('');
    });

    if (conta != '' && conta != 'create') {
        $('#account').css('cursor', 'pointer');
        $('#payment').css('cursor', 'pointer');
        $('#personal').css('cursor', 'pointer');
        if (await liberarRegistro('CADCONTA', conta) == false) {
            window.location.href = '../cadconta';
        } else {
            carregaDados(conta);
        }
    }

    async function carregaDados(contaUrl) {
        try {
            $.LoadingOverlay("show");
            try {

                let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                if (validaCNPJ != false) {
                    $("#txtCNPJ").val(validaCNPJ);
                }

                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"CADCONTA", 
                "camposSelect":["CODIGO", "DESCRICAO", "AGENCIA", "BANCO", "CONTA", "CNPJ", "EMPRESA", "INSCRICAO", "CHAVE_PIX", "LOTE_SERVICO", "CONTADOR", "DIAS_COMP", "LIMITE", "MENSAGEM_1", "AVALISTA", "CONTA_CONT", "CONTA_CRED", "SEQ_PAGFOR", "DIG_PAGFOR", "FLOAT_TAXA", "CONTA_CREDITADA", "CONTA_COMPL", "DT_CAIXA", "AG_COOPERADO", "TIPO", "OBS", "LOCAL", "ENTRADA", "ENTRADA_LIDO", "DIR_ENV_PAGTO", "DIR_RET_PAGTO", "ATIVO", "USA_AVALISTA_EMPTAB", "PADRAO", "IMP_FLUXO", "PENDENTE", "VALIDA_BAIXA", "VALIDA_TRANSF"], 
                "where": ["CODIGO = '${contaUrl}'"]}
                `, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.RESULT[0].mensagem);
                    return;
                }

                let response2 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"CADBAN", "camposSelect":["BANCO", "NOME_BANCO"],
                "WHERE": ["BANCO = '${jsonStr.RESULT[0][0].BANCO}'"]}`, null);

                if (!response2) {
                    return;
                }
                let jsonStr2 = await response2.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr2.RESULT[0].mensagem);
                    return;
                };

                let response3 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"CONTA_CONT", "camposSelect":["CODIGO", "DESCRICAO"],
                "WHERE": ["CODIGO = '${jsonStr.RESULT[0][0].CONTA_CONT}'"]}`, null);

                if (!response3) {
                    return;
                }
                let jsonStr3 = await response3.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr3.RESULT[0].mensagem);
                    return;
                };

                let response4 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"CONTA_CONT", "camposSelect":["CODIGO", "DESCRICAO"],
                "WHERE": ["CODIGO = '${jsonStr.RESULT[0][0].CONTA_CRED}'"]}`, null);

                if (!response4) {
                    return;
                }
                let jsonStr4 = await response4.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr4.RESULT[0].mensagem);
                    return;
                };

                let response5 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={"tabela":"CADCONTA", "camposSelect":["CODIGO", "DESCRICAO"],
                "WHERE": ["CODIGO = '${jsonStr.RESULT[0][0].CONTA_CREDITADA}'"]}`, null);

                if (!response5) {
                    return;
                }
                let jsonStr5 = await response5.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr5.RESULT[0].mensagem);
                    return;
                };

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                $('#txtAgencia').val(jsonStr.RESULT[0][0].AGENCIA);
                insereValor('#txtBanco', jsonStr.RESULT[0][0].BANCO, jsonStr2.RESULT[0][0].NOME_BANCO);
                $('#txtConta').val(jsonStr.RESULT[0][0].CONTA);
                $('#txtTitular').val(jsonStr.RESULT[0][0].EMPRESA);
                $('#txtCNPJ').val(jsonStr.RESULT[0][0].CNPJ);
                $('#txtInscricao').val(jsonStr.RESULT[0][0].INSCRICAO);
                $('#txtPix').val(jsonStr.RESULT[0][0].CHAVE_PIX != null ? jsonStr.RESULT[0][0].CHAVE_PIX : '');
                $('#txtSequencial').val(jsonStr.RESULT[0][0].LOTE_SERVICO);
                $('#txtDigitos').val(jsonStr.RESULT[0][0].CONTADOR);
                $('#txtDias').val(jsonStr.RESULT[0][0].DIAS_COMP);
                parseFloat($('#txtLimite').val(jsonStr.RESULT[0][0].LIMITE));
                $('#txtMensagem').val(jsonStr.RESULT[0][0].MENSAGEM_1);
                $('#txtAvalista').val(jsonStr.RESULT[0][0].AVALISTA);
                if (jsonStr3.RESULT[0].length > 0) {
                    insereValor('#txtContaDebito1', jsonStr.RESULT[0][0].CONTA_CONT, jsonStr3.RESULT[0][0].DESCRICAO);
                } else {
                    $('#txtContaDebito1').val('');
                }
                if (jsonStr4.RESULT[0].length > 0) {
                    insereValor('#txtContaCredito1', jsonStr.RESULT[0][0].CONTA_CRED, jsonStr4.RESULT[0][0].DESCRICAO);
                } else {
                    $('#txtContaCredito1').val('');
                }
                $('#txtSequencialPg').val(jsonStr.RESULT[0][0].SEQ_PAGFOR != null ? jsonStr.RESULT[0][0].SEQ_PAGFOR : '');
                $('#txtDigitos2').val(jsonStr.RESULT[0][0].DIG_PAGFOR != null ? jsonStr.RESULT[0][0].DIG_PAGFOR : '0');
                $('#txtFloat').val(jsonStr.RESULT[0][0].FLOAT_TAXA != null ? jsonStr.RESULT[0][0].FLOAT_TAXA : '0');
                if (jsonStr5.RESULT[0].length > 0) {
                    insereValor('#txtContaCreditada', jsonStr.RESULT[0][0].CONTA_CREDITADA, jsonStr5.RESULT[0][0].DESCRICAO);
                } else {
                    $('#txtContaCreditada').val('');
                }
                $('#txtContaComplementar').val(jsonStr.RESULT[0][0].CONTA_COMPL);
                $('#txtDtConciliado').val(jsonStr.RESULT[0][0].DT_CAIXA);
                $('#txtAgCooperado').val(jsonStr.RESULT[0][0].AG_COOPERADO);

                if (jsonStr.RESULT[0][0].TIPO == '0' || jsonStr.RESULT[0][0].TIPO == '1' || jsonStr.RESULT[0][0].TIPO == '2' || jsonStr.RESULT[0][0].TIPO == '3' || jsonStr.RESULT[0][0].TIPO == '4') {
                    if (jsonStr.RESULT[0][0].TIPO == '0') {
                        $('#txtTipo').val('0');
                    };
                    if (jsonStr.RESULT[0][0].TIPO == '1') {
                        $('#txtTipo').val('1');
                    };
                    if (jsonStr.RESULT[0][0].TIPO == '2') {
                        $('#txtTipo').val('2');
                    };
                    if (jsonStr.RESULT[0][0].TIPO == '3') {
                        $('#txtTipo').val('3');
                    };
                    if (jsonStr.RESULT[0][0].TIPO == '4') {
                        $('#txtTipo').val('4');
                    };
                };

                $('#txtObs').val(jsonStr.RESULT[0][0].OBS != null ? jsonStr.RESULT[0][0].OBS : '');
                $('#txtCaminhoEnvio').val(jsonStr.RESULT[0][0].LOCAL != null ? jsonStr.RESULT[0][0].LOCAL : '');
                $('#txtCaminhoRetorno').val(jsonStr.RESULT[0][0].ENTRADA != null ? jsonStr.RESULT[0][0].ENTRADA : '');
                $('#txtCaminhoRetornoLido').val(jsonStr.RESULT[0][0].ENTRADA_LIDO != null ? jsonStr.RESULT[0][0].ENTRADA_LIDO : '');
                $('#txtCaminhoEnvioPg').val(jsonStr.RESULT[0][0].DIR_ENV_PAGTO != null ? jsonStr.RESULT[0][0].DIR_ENV_PAGTO : '');
                $('#txtCaminhoRetornoPg').val(jsonStr.RESULT[0][0].DIR_RET_PAGTO != null ? jsonStr.RESULT[0][0].DIR_RET_PAGTO : '');

                if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                    $('#checkAtivo').prop('checked', true);
                };
                if (jsonStr.RESULT[0][0].USA_AVALISTA_EMPTAB == 'S') {
                    $('#checkUsaSacador').prop('checked', true);
                };
                if (jsonStr.RESULT[0][0].PADRAO == 'S') {
                    $('#checkPadrao').prop('checked', true);
                };
                if (jsonStr.RESULT[0][0].IMP_FLUXO == 'S') {
                    $('#checkImprimeFluxo').prop('checked', true);
                };
                if (jsonStr.RESULT[0][0].PENDENTE == 'S') {
                    $('#checkLancPendente').prop('checked', true);
                };
                if (jsonStr.RESULT[0][0].VALIDA_BAIXA == 'S') {
                    $('#checkBaixaFinancerio').prop('checked', true);
                };
                if (jsonStr.RESULT[0][0].VALIDA_TRANSF == 'S') {
                    $('#checkTransferencia').prop('checked', true);
                };

            } catch (error) {
                console.error(error);
                msgAlerta(`Não foi possível buscar os dados da conta.`);
            };
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $("#checkPadrao").on("click", async function () {
        if ($("#checkPadrao").prop("checked")) {
            try {
                let response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"CADCONTA", "camposSelect":["CODIGO,PADRAO"], "where":[" PADRAO = 'S' "]}`,
                    null
                );

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.RESULT[0].mensagem);
                    return;
                }
                if (jsonStr.RESULT[0].length != 0) {
                    $("#checkPadrao").trigger("click");
                    $("#checkPadrao").attr("checked", false);
                    msgAlerta(`A conta ${jsonStr.RESULT[0][0].CODIGO} já está como padrão`);
                }
            } catch (error) {
                console.error(error);
            }
        }
    });

    $("#gravar").click(
        async function () {
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                if (validaCNPJ != false) {
                    $("#txtCNPJ").val(validaCNPJ);
                }

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    if ($('#txtDescricao').val() === '') {
                        msgAlerta(`Necessário informar uma descrição.`);
                    }

                    if ($('#txtAgencia').val() === '') {
                        msgAlerta(`Necessário informar uma agência.`);
                    }

                    if ($('#txtBanco').val() === '') {
                        msgAlerta(`Necessário informar um banco.`);
                    }

                    if ($('#txtConta').val() === '') {
                        msgAlerta(`Necessário informar uma conta.`);
                    }

                    const limite = $('#txtLimite').val() === '' ? 0 : parseFloat($('#txtLimite').val().replace(',', '.'));
                    const digitos1 = $('#txtDigitos').val() === '' ? 0 : parseFloat($('#txtDigitos').val());
                    const dias = $('#txtDias').val() === '' ? 0 : parseFloat($('#txtDias').val());
                    const digitos2 = $('#txtDigitos2').val() === '' ? 0 : parseFloat($('#txtDigitos2').val());
                    const float = $('#txtFloat').val() === '' ? 0 : parseFloat($('#txtFloat').val());
                    const data = $('#txtDtConciliado').val() === '' ? '1899-12-30T00:00:00Z' : ($('#txtDtConciliado').val() + 'T00:00:00Z');

                    conta = {};

                    conta.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('CADCONTA', 'CADCONTA', 'CODIGO', 5) : $('#txtCodigo').val();
                    conta.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    conta.AGENCIA = $('#txtAgencia').val();
                    conta.BANCO = pegaChave($('#txtBanco').val());
                    conta.CONTA = $('#txtConta').val();
                    conta.EMPRESA = $('#txtTitular').val();
                    conta.CNPJ = $('#txtCNPJ').val();
                    conta.INSCRICAO = $('#txtInscricao').val();
                    conta.CHAVE_PIX = $('#txtPix').val();
                    conta.LOTE_SERVICO = $('#txtSequencial').val();
                    conta.CONTADOR = digitos1;
                    conta.DIAS_COMP = dias;
                    conta.LIMITE = limite;
                    conta.MENSAGEM_1 = $('#txtMensagem').val();
                    conta.AVALISTA = $('#txtAvalista').val();
                    conta.CONTA_CONT = pegaChave($('#txtContaDebito1').val());
                    conta.CONTA_CRED = pegaChave($('#txtContaCredito1').val());
                    conta.SEQ_PAGFOR = $('#txtSequencialPg').val();
                    conta.DIG_PAGFOR = digitos2;
                    conta.FLOAT_TAXA = float;
                    conta.CONTA_CREDITADA = pegaChave($('#txtContaCreditada').val());
                    conta.CONTA_COMPL = $('#txtContaComplementar').val();
                    conta.DT_CAIXA = data;
                    conta.AG_COOPERADO = $('#txtAgCooperado').val();
                    conta.TIPO = $('#txtTipo').val();
                    conta.OBS = $('#txtObs').val();
                    conta.LOCAL = $('#txtCaminhoEnvio').val();
                    conta.ENTRADA = $('#txtCaminhoRetorno').val();
                    conta.ENTRADA_LIDO = $('#txtCaminhoRetornoLido').val();
                    conta.DIR_ENV_PAGTO = $('#txtCaminhoEnvioPg').val();
                    conta.DIR_RET_PAGTO = $('#txtCaminhoRetornoPg').val();

                    if ($('#checkAtivo').prop('checked')) {
                        conta.ATIVO = 'S';
                    } else {
                        conta.ATIVO = 'N';
                    }

                    if ($('#checkUsaSacador').prop('checked')) {
                        conta.USA_AVALISTA_EMPTAB = 'S';
                    } else {
                        conta.USA_AVALISTA_EMPTAB = 'N';
                    }

                    if ($('#checkPadrao').prop('checked')) {
                        conta.PADRAO = 'S';
                    } else {
                        conta.PADRAO = 'N';
                    }

                    if ($('#checkImprimeFluxo').prop('checked')) {
                        conta.IMP_FLUXO = 'S';
                    } else {
                        conta.IMP_FLUXO = 'N';
                    }

                    if ($('#checkLancPendente').prop('checked')) {
                        conta.PENDENTE = 'S';
                    } else {
                        conta.PENDENTE = 'N';
                    }

                    if ($('#checkBaixaFinancerio').prop('checked')) {
                        conta.VALIDA_BAIXA = 'S';
                    } else {
                        conta.VALIDA_BAIXA = 'N';
                    }

                    if ($('#checkTransferencia').prop('checked')) {
                        conta.VALIDA_TRANSF = 'S';
                    } else {
                        conta.VALIDA_TRANSF = 'N';
                    }

                    let response = await requisicao('POST', '/sisplan/cadastros/v1/cadconta?', '', JSON.stringify(conta), 15000);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        $.LoadingOverlay("hide");
                        msgAlerta(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Situação: ${conta.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/cadconta`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgAlerta(`Não foi possível gravar os dados da conta`);
            }

        });

    $('#account').on('click', function () {
        if (conta != 'create') {
            if (contaFs == 2) {
                $('#voltar').trigger('click');
            }
            if (contaFs == 3) {
                $('#voltar3').trigger('click');
                $('#voltar').trigger('click');
            }
            if (contaFs == 4) {
                $('#voltar4').trigger('click');
                $('#voltar3').trigger('click');
                $('#voltar').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (conta != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
            if (contaFs == 3) {
                $('#voltar3').trigger('click');
            }
            if (contaFs == 4) {
                $('#voltar4').trigger('click');
                $('#voltar3').trigger('click');
            }
        }
    });

    $('#personal').on('click', function () {
        if (conta != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
                $('#avancar2').trigger('click');
                $($('fieldset')[0]).css('display', 'none')
            }
            if (contaFs == 2) {
                $('#avancar2').trigger('click');
            }
            if (contaFs == 4) {
                $('#voltar4').trigger('click');
            }
        }
    });
});