$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos com * são obrigatórios.',
        position: 'top'
      }
    },
    {
      element: '#txtTurno',
      popover: {
        title: 'Campo Código de Turno',
        description: 'Aqui selecionamos em qual turno será cadastrado as informações.',
        position: 'top'
      }
    },
    {
      element: '#tutorialDSR',
      popover: {
        title: 'Descanso Semanal Remunerado',
        description: 'Aqui definimos se tera ou não descanso semanal remunerado.',
        position: 'top'
      }
    },
    {
      element: '#radiogroup',
      popover: {
        title: 'Dia da Semana',
        description: 'Aqui definimos o dia da semana que será aplicado as informações.',
        position: 'top'
      }
    },
    {
      element: '#tutorialAcada',
      popover: {
        title: 'Número de dias',
        description: 'Aqui definimos quantos dias serão adicionados esses horários.',
        position: 'top'
      }
    },
    {
      element: '#tutoriaPartindo',
      popover: {
        title: 'Data que iniciará',
        description: 'Aqui definimos a partir de qual data será contabilizado o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#percentualHora',
      popover: {
        title: 'Percentural de Hora Extra',
        description: 'Aqui definimos qual a porcentagem de hora extra.',
        position: 'top'
      }
    },
    {
      element: '#tutorialPeriodos',
      popover: {
        title: 'Horários para cadastro',
        description: 'Aqui definimos os horários que serão cadastrados para esse registro.',
        position: 'top'
      }
    },
    {
      element: '#tutorialPeriodos',
      popover: {
        title: 'Horários para cadastro',
        description: 'Aqui definimos os horários que serão cadastrados para esse registro.',
        position: 'top'
      }
    },
    {
      element: '#tutorialIniManha',
      popover: {
        title: 'Entrada do primeiro período',
        description: 'Definimos a entrada.',
        position: 'top'
      }
    },
    {
      element: '#tutorialFimManha',
      popover: {
        title: 'Saída do primeiro período',
        description: 'Definimos a saída do primeiro período.',
        position: 'top'
      }
    },
    {
      element: '#tutorialPausaIniManha',
      popover: {
        title: 'Intervalo do período',
        description: 'Se a empresa tiver intervalo nos períodos, aqui incluimos qual horário o intervalo do primeiro período inicia. Se a empresa não tiver intervalo, não há a necessida de preencher o campo.',
        position: 'top'
      }
    },
    {
      element: '#tutorialPausaFimManha',
      popover: {
        title: 'Intervalo do período',
        description: 'Aqui incluimos qual horário o intervalo do primeiro período termina. Se a empresa não tiver intervalo, não há a necessidade de preencher o campo.',
        position: 'top'
      }
    },
    {
      element: '#tutorialIniTarde',
      popover: {
        title: 'Entrada do segundo período',
        description: 'Definimos a entrada.',
        position: 'top'
      }
    },
    {
      element: '#tutorialFimTarde',
      popover: {
        title: 'Saída do primeiro período',
        description: 'Definimos a saída do segundo período.',
        position: 'top'
      }
    },
    {
      element: '#tutorialPausaIniTarde',
      popover: {
        title: 'Intervalo do período',
        description: 'Se a empresa tiver intervalo nos períodos, aqui incluimos qual horário o intervalo do segundo período inicia. Se a empresa não tiver intervalo, não há a necessidade de preencher o campo.',
        position: 'top'
      }
    },
    {
      element: '#tutorialPausaFimTarde',
      popover: {
        title: 'Intervalo do período',
        description: 'Aqui incluimos qual horário o intervalo do segundo período termina. Se a empresa não tiver intervalo, não há a necessidade de preencher o campo.',
        position: 'top'
      }
    },
    {
      element: '#tutorialTotal',
      popover: {
        title: 'Total de horas',
        description: 'Neste campo é apresentado o cálculo de horas que serão trabalhadas.',
        position: 'top'
      }
    },
    {
      element: '#tutorialNoturno',
      popover: {
        title: 'Adicional Noturno',
        description: 'Aqui definimos em quais horários se iniciará e terminará o adicional noturno.',
        position: 'top'
      }
    },
    {
      element: '#tutorialTolerancia',
      popover: {
        title: 'Tolerância',
        description: 'Aqui definimos os horários de tolerância da entrada, saída e Adicional Noturno.',
        position: 'top'
      }
    },
    {
      element: '#btnVoltar',
      popover: {
        title: 'Botão Voltar',
        description: 'Ao clicar, volta a tela de Acesso de Turnos.',
        position: 'top'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão de Gravar',
        description: 'Ao clicar, grava o novo registro ou a alteração do registro que está em edição.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('#txtTurno').autocompleta(1, `JSON={ "tabela":"TURNO", "camposSelect":["TURNO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnCodTurnos').pesquisa('#txtTurno', 'TURNO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TURNO", "camposSelect":[ "TURNO", "DESCRICAO" ], "where": null}', 'Pesquisar Turno', 'Turno');
  $('#btnLimpaCodTurnos').on('click', function () {
    $('#txtTurno').val('');
  });

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let status = parametros[parametros.length - 1];

  if (status != "" && status != "create") {
    const resultadoStatus = status.split('#');
    await consultaTabela(resultadoStatus[0], resultadoStatus[1]);

  }

  async function consultaTabela(turno, dia) {

    $.LoadingOverlay('show');
    try {
      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"TURNO_HORARIOS", "camposSelect":["DATA_INTERC", "DIA", "DIA_INTERC", "DSR", "ENTRADA", "INTER_FIM", "INTER_INI" ,             
      "SAIDA", "TOLERANCIA", "TOTAL", "TURNO", "PERC_EXTRA", "ADDNOT_FIM", "ADDNOT_INI", "TOLER_EXTRA", "TOLER_NOT", "PAUSAM_INI",             
      "PAUSAM_FIM", "PAUSAT_INI", "PAUSAT_FIM", "TOLER_FAL_BH"],
      "where": ["1=1 AND TURNO = '${turno}' AND DIA = '${dia}'"]}`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      concatenado = await buscaValor("TURNO", "DESCRICAO", "TURNO", jsonStr.RESULT[0][0].TURNO);

      insereValor("#txtTurno", jsonStr.RESULT[0][0].TURNO, concatenado.DESCRICAO);


      $("#slDiaSemana").val(jsonStr.RESULT[0][0].DIA);
      $('#txtAcada').val(jsonStr.RESULT[0][0].DIA_INTERC);

      $('#dtInterceDe').val(jsonStr.RESULT[0][0].DATA_INTERC);
      $('#txtPercHoraExtra').val(jsonStr.RESULT[0][0].PERC_EXTRA);
      if (jsonStr.RESULT[0][0].DSR == "S") {
        $('#cbDSR').prop('checked', true)
      };

      $('#tmEntrada1').val(jsonStr.RESULT[0][0].ENTRADA.substring(11, 16));
      $('#tmIniPausa1').val(jsonStr.RESULT[0][0].PAUSAM_INI.substring(11, 16));
      $('#tmFimPausa1').val(jsonStr.RESULT[0][0].PAUSAM_FIM.substring(11, 16));
      $('#tmFim1').val(jsonStr.RESULT[0][0].INTER_INI.substring(11, 16));

      $('#tmEntrada2').val(jsonStr.RESULT[0][0].INTER_FIM.substring(11, 16));
      $('#tmIniPausa2').val(jsonStr.RESULT[0][0].PAUSAT_INI.substring(11, 16));
      $('#tmFimPausa2').val(jsonStr.RESULT[0][0].PAUSAT_FIM.substring(11, 16));
      $('#tmFim2').val(jsonStr.RESULT[0][0].SAIDA.substring(11, 16));

      $('#tmTotalHoras').val(jsonStr.RESULT[0][0].TOTAL.substring(11, 16));

      $('#tmEntradaAdicional').val(jsonStr.RESULT[0][0].ADDNOT_INI.substring(11, 16));
      $('#tmSaidaAdicional').val(jsonStr.RESULT[0][0].ADDNOT_FIM.substring(11, 16));

      $('#tmEntradaTolerancia').val(jsonStr.RESULT[0][0].TOLERANCIA.substring(11, 16));
      $('#tmSaidaTolerancia').val(jsonStr.RESULT[0][0].TOLER_EXTRA.substring(11, 16));
      $('#tmAdicionalTolerancia').val(jsonStr.RESULT[0][0].TOLER_NOT.substring(11, 16));
    }
    finally{
      $.LoadingOverlay('hide');
    }
  }

  function formataDataEHora(seletor) {
    const data = new Date();
    data.setHours($(seletor).val().split(':')[0]);
    data.setMinutes($(seletor).val().split(':')[1]);
    return data.toISOString().slice(0, 10) + 'T' + data.toLocaleString().replace(',', '').split(' ')[1] + 'Z'
  }

  function preencheHora(hora) {
    if (hora.length == 1) {
      hora = '0' + hora;
    }
    if (hora.length == 2) {
      hora = hora + ':00';
    }
    if (hora.length == 3) {
      hora = '0' + hora;
    }
    if (hora.length == 4) {
      hora = hora.substr(0, 2) + ':' + hora.substr(2, 2);
    }
    return hora;
  }

  function calcularTotalHoras() {
    const entrada1Formatada = $('#tmEntrada1').val() !== ''? formataDataEHora('#tmEntrada1') : '1899-12-30 00:00:00.000';
    const pausa1IniFormatada = $('#tmIniPausa1').val() !== '' ? formataDataEHora('#tmIniPausa1') : '1899-12-30 00:00:00.000';
    const pausa1FimFormatada = $('#tmFimPausa1').val() !== '' ? formataDataEHora('#tmFimPausa1') : '1899-12-30 00:00:00.000';
    const saida1Formatada = $('#tmFim1').val() !== '' ? formataDataEHora('#tmFim1') : '1899-12-30 00:00:00.000';
    const entrada2Formatada = $('#tmEntrada2').val() !== '' ? formataDataEHora('#tmEntrada2') : '1899-12-30 00:00:00.000';
    const pausa2IniFormatada = $('#tmIniPausa2').val() !== '' ? formataDataEHora('#tmIniPausa2') : '1899-12-30 00:00:00.000';
    const pausa2FimFormatada = $('#tmFimPausa2').val() !== '' ? formataDataEHora('#tmFimPausa2') : '1899-12-30 00:00:00.000';
    const saida2Formatada = $('#tmFim2').val() !== '' ? formataDataEHora('#tmFim2') : '1899-12-30 00:00:00.000';

    entradaIni = preencheHora(entrada1Formatada).substring(11, 16);
    inter = preencheHora(saida1Formatada).substring(11, 16);
    interF = preencheHora(entrada2Formatada).substring(11, 16);
    saida = preencheHora(saida2Formatada).substring(11, 16);
    pausaMIni = preencheHora(pausa1IniFormatada).substring(11, 16);
    pausaMFim = preencheHora(pausa1FimFormatada).substring(11, 16);
    pausaTIni = preencheHora(pausa2IniFormatada).substring(11, 16);
    pausaTFim = preencheHora(pausa2FimFormatada).substring(11, 16);

    let periodo1, periodo2, pausaManha, pausaTarde;

    if (new Date('2000-01-01T' + inter) < new Date('2000-01-01T' + entradaIni)) {
      periodo1 = new Date('2000-01-02T' + inter) - new Date('2000-01-01T' + entradaIni);
    } else {
      periodo1 = new Date('2000-01-01T' + inter) - new Date('2000-01-01T' + entradaIni);
    }

    if (new Date('2000-01-01T' + interF) < new Date('2000-01-01T' + saida)) {
      periodo2 = new Date('2000-01-02T' + saida) - new Date('2000-01-01T' + interF);
    } else {
      periodo2 = new Date('2000-01-01T' + saida) - new Date('2000-01-01T' + interF);
    }

    if (new Date('2000-01-01T' + pausaMIni) > new Date('2000-01-01T' + pausaMFim)) {
      pausaManha = new Date('2000-01-02T' + pausaMFim) - new Date('2000-01-01T' + pausaMIni);
    } else {
      pausaManha = new Date('2000-01-01T' + pausaMFim) - new Date('2000-01-01T' + pausaMIni);
    }

    if (new Date('2000-01-01T' + pausaTIni) > new Date('2000-01-01T' + pausaTFim)) {
      pausaTarde = new Date('2000-01-02T' + pausaTFim) - new Date('2000-01-01T' + pausaTIni);
    } else {
      pausaTarde = new Date('2000-01-01T' + pausaTFim) - new Date('2000-01-01T' + pausaTIni);
    }

    let total = new Date((periodo1 - pausaManha + periodo2 - pausaTarde));
    let hours = total.getUTCHours();
    let minutes = total.getUTCMinutes();

    let formataHora = (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes;

    $('#tmTotalHoras').val(formataHora);
  };

  $('.calculaHora').on('input', function () {
    calcularTotalHoras();
  });

  $('#btnGravar').on('click', async function gravaStatus() {

    if ($('#txtTurno').val() == '') {
      msgAlerta('Preencha o campo Código.');
      setTimeout(function () {
        $('#txtTurno').focus();
      }, 2000);
      return;
    } else if (!$('#slDiaSemana').val()) {
      msgAlerta('Selecione o dia da semana que será trabalhado.');
      setTimeout(function () {
        $('#slDiaSemana').focus();
      }, 2000);
      return;
    } else if ($('#tmEntrada1').val() == '') {
      msgAlerta('Preencha a hora de início do expediente.');
      setTimeout(function () {
        $('#tmEntrada1').focus();
      }, 2000);
      return;
    } else if ($('#tmFim1').val() == '' || $('#tmFim1').val() == '00:00') {
      msgAlerta('Preencha a hora de saída do primeiro período.');
      setTimeout(function () {
        $('#tmFim1').focus();
      }, 2000);
      return;
    }

    const entrada1Formatada = $('#tmEntrada1').val() !== '' ? formataDataEHora('#tmEntrada1') : '1899-12-30 00:00:00.000';
    const pausa1IniFormatada = $('#tmIniPausa1').val() !== '' ? formataDataEHora('#tmIniPausa1') : '1899-12-30 00:00:00.000';
    const pausa1FimFormatada = $('#tmFimPausa1').val() !== '' ? formataDataEHora('#tmFimPausa1') : '1899-12-30 00:00:00.000';
    const saida1Formatada = $('#tmFim1').val() !== '' ? formataDataEHora('#tmFim1') : '1899-12-30 00:00:00.000';
    const entrada2Formatada = $('#tmEntrada2').val() !== '' ? formataDataEHora('#tmEntrada2') : '1899-12-30 00:00:00.000';
    const pausa2IniFormatada = $('#tmIniPausa2').val() !== '' ? formataDataEHora('#tmIniPausa2') : '1899-12-30 00:00:00.000';
    const pausa2FimFormatada = $('#tmFimPausa2').val() !== '' ? formataDataEHora('#tmFimPausa2') : '1899-12-30 00:00:00.000';
    const saida2Formatada = $('#tmFim2').val() !== '' ? formataDataEHora('#tmFim2') : '1899-12-30 00:00:00.000';
    const entradaAdicionalFormatada = $('#tmEntradaAdicional').val() !== '' ? formataDataEHora('#tmEntradaAdicional') : '1899-12-30 00:00:00.000';
    const saidaAdicionalFormatada = $('#tmSaidaAdicional').val() !== '' ? formataDataEHora('#tmSaidaAdicional') : '1899-12-30 00:00:00.000';
    const entradaToleranciaFormatada = $('#tmEntradaTolerancia').val() !== '' ? formataDataEHora('#tmEntradaTolerancia') : '1899-12-30 00:00:00.000';
    const saidaToleranciaFormatada = $('#tmSaidaTolerancia').val() !== '' ? formataDataEHora('#tmSaidaTolerancia') : '1899-12-30 00:00:00.000';
    const adicionalToleranciaFormatada = $('#tmAdicionalTolerancia').val() !== '' ? formataDataEHora('#tmAdicionalTolerancia') : '1899-12-30 00:00:00.000';
    const formattedTime = formataDataEHora('#tmTotalHoras');
    const toler_fal_bh = '1899-12-30 00:00:00.000';
    const bloq_sourcing = '1899-12-30 00:00:00.000';
    try {
      let status = {};

      status.TURNO = pegaChave($('#txtTurno').val());
      status.DIA = $("#slDiaSemana").val();
      status.DIA_INTERC = $('#txtAcada').val();
      status.DATA_INTERC = $('#dtInterceDe').val() + "T00:00:00Z";
      status.PERC_EXTRA = $('#txtPercHoraExtra').val();
      if ($('#cbDSR').is(':checked')) {
        status.DSR = 'S'
      } else {
        status.DSR = 'N'
      }
      status.ENTRADA = entrada1Formatada;
      status.PAUSAM_INI = pausa1IniFormatada;
      status.PAUSAM_FIM = pausa1FimFormatada;
      status.INTER_INI = saida1Formatada;
      status.INTER_FIM = entrada2Formatada;
      status.PAUSAT_INI = pausa2IniFormatada;
      status.PAUSAT_FIM = pausa2FimFormatada;
      status.SAIDA = saida2Formatada;
      status.TOTAL = formattedTime;
      status.ADDNOT_INI = entradaAdicionalFormatada;
      status.ADDNOT_FIM = saidaAdicionalFormatada;
      status.TOLERANCIA = entradaToleranciaFormatada;
      status.TOLER_EXTRA = saidaToleranciaFormatada;
      status.TOLER_NOT = adicionalToleranciaFormatada;
      status.TOLER_FAL_BH = toler_fal_bh;
      status.BLOQ_SOURCING = bloq_sourcing;

      let response = await requisicao("POST", `/Sisplan/cadastros/V1/cadhorarios?`, `JSON=${encodeURIComponent(JSON.stringify(status))}&EMP_ID=${getCookie('emp_id')}`, 15000);
      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Turno cadastrado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cadhorarios`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("CADHORARIOS", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/cadhorarios`;
  });

});
