<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Preço Material</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.231.12.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.231.12.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.231.12.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.231.12.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.231.12.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.231.12.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.231.12.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.231.12.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.231.12.1">

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .form-control:disabled,
    .form-control[readonly] {
      background-color: #f7f7f7;
      opacity: 1;
    }

    #msform {
      text-align: start;
      position: relative;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: var(--font-color);
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    #bordaImagem {
      width: 100%;
      height: 350px;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
    }

    #infoprodimagem {
      max-width: 100%;
      max-height: 345px;
      width: auto;
      height: auto;

    }

    #divImg {
      margin-left: 3%;
    }

    .check-todos {
      background-color: var(--buttonCheckMedidas);
      border: 0px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    .table.dataTable tbody td,
    th {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .bodyModal {
      overflow: auto !important;
    }

    .dataTables_filter {
      visibility: hidden;
      margin: 0px;
      padding: 0px;
      height: 0px;
    }

    /* #tabelaControleItens tbody{
      height: 1px;
    } */

    /* #tabelaControleItens thead {
      display: table;
      width: 100%;
      table-layout: fixed;
    } */
  </style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText">Modal body text goes here.</p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary btn-sisp">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary btn-sisp" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>
    <!-- Content Wrapper. Contains page content -->

    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 col-12">
            </div><!-- /.col -->
            <div class="col-sm-6 col-12">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item"><a href="../cadmatpreco">Preço Material</a></li>
                <li class="breadcrumb-item active">Cadastro Preço Material</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card" style="height:auto;min-height:715px">
                <div class="card-header bg-dark flex">
                  <h2 class="m-0 text-white">Cadastro de Preço Material</h2>

                  <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                    <i class="fas fa-question-circle"></i>
                  </button>
                </div>
                <fieldset>
                  <div class="card-body">
                    <form style="text-align:left!important;" id="msform" name="msform">
                      <div class="card card-header" role="tab" id="geral">
                        <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample1" href="#multiCollapseExample1" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-down"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Geral
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse show" id="multiCollapseExample1">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                            <div class="form-row pt-2 pl-2">
                              <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="cbProduzido">
                                <label class="form-check-label pr-4" for="cbProduzido">Produzido</label>
                              </div>
                              <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="cbEsconderFoto">
                                <label class="form-check-label pr-4" for="cbEsconderFoto">Esconder Foto</label>
                              </div>
                            </div>
                            <div class="form-row">
                              <div class="col-8" id="infoGerais">
                                <div class="form-row">
                                  <div class="col-4 form-group" id="tourcodigo">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código</label>
                                    <input type="text" class="input-default focus form-control" id="txtCodigo" aria-describedby="codError" name="txtCodigo" class="form-control" placeholder="Código">
                                  </div>
                                  <div class="col-6 form-group" id="tourdesc">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Descrição</label>
                                    <input type="text" maxlength="100" class="input-default focus form-control validate create" id="txtDescricao" required aria-describedby="descError" name="txtDescricao" class="form-control" placeholder="Descrição">
                                  </div>
                                  <div class="col-2 form-group" id="tourdesc">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidade">Unidade</label>
                                    <input type="text" maxlength="100" class="input-default focus form-control validate create" id="txtUnidade" required aria-describedby="descError" name="txtUnidade" class="form-control" placeholder="Unidade">
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-4 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupo">Grupo</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control create" id="txtGrupo" required aria-describedby="uError" name="txtGrupo" class="form-control" placeholder="Grupo">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger create" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger create" id="btnAGrupo" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-4 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtSetor">Setor</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control create" id="txtSetor" required aria-describedby="uError" name="txtSetor" class="form-control" placeholder="Setor">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger create" id="btnSetor" name="btnSetor" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger create" id="btnASetor" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-4 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtParte">Parte</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control create" id="txtParte" required aria-describedby="uError" name="txtParte" class="form-control" placeholder="Parte">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger create" id="btnParte" name="btnParte" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger create" id="btnAParte" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoCompra">Preço Compra</label>
                                    <input type="text" class="input-default focus form-control create" id="txtPrecoCompra" name="txtPrecoCompra" class="form-control" placeholder="0.00">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPreco1">Preço 1</label>
                                    <input type="text" class="input-default focus form-control create" id="txtPreco1" name="txtPreco1" class="form-control" placeholder="0.00">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPreco2">Preço 2</label>
                                    <input type="text" class="input-default focus form-control create" id="txtPreco2" name="txtPreco2" class="form-control" placeholder="0.00">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPreco3">Preço 3</label>
                                    <input type="text" class="input-default focus form-control create" id="txtPreco3" name="txtPreco3" class="form-control" placeholder="0.00">
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCreditoIPI">Crédito IPI %</label>
                                    <div class="col-12 input-group form-row p-0 m-0">
                                      <input type="text" class="input-default focus form-control col-9 create" id="txtCreditoIPI" name="txtCreditoIPI" class="form-control" placeholder="0.00">
                                      <input class="col-1 ml-3 create" type="checkbox" id="cbCreditoIPI">
                                    </div>
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCreditoICMS">Crédito ICMS %</label>
                                    <div class="col-12 input-group form-row p-0 m-0">
                                      <input type="text" class="input-default focus form-control col-9 create" id="txtCreditoICMS" name="txtCreditoICMS" class="form-control" placeholder="0.00">
                                      <input class="col-1 ml-3 create" type="checkbox" id="cbCreditoICMS">
                                    </div>
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCreditoPIS">Crédito PIS %</label>
                                    <div class="col-12 input-group form-row p-0 m-0">
                                      <input type="text" class="input-default focus form-control col-9 create" id="txtCreditoPIS" name="txtCreditoPIS" class="form-control" placeholder="0.00">
                                      <input class="col-1 ml-3 create" type="checkbox" id="cbCreditoPIS">
                                    </div>
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCreditoCOFINS">Crédito COFINS %</label>
                                    <div class="col-12 input-group form-row p-0 m-0">
                                      <input type="text" class="input-default focus form-control col-9 create" id="txtCreditoCOFINS" name="txtCreditoCOFINS" class="form-control" placeholder="0.00">
                                      <input class="col-1 ml-3 create" type="checkbox" id="cbCreditoCOFINS">
                                    </div>
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtDespesasIPI">Despesas IPI %</label>
                                    <input type="text" class="input-default focus form-control create" id="txtDespesasIPI" name="txtDespesasIPI" class="form-control" placeholder="Despesas IPI">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtFrete">Frete %</label>
                                    <input type="text" class="input-default focus form-control create" id="txtFrete" name="txtFrete" class="form-control" placeholder="Frete">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtValorFrete">Valor Frete</label>
                                    <input type="text" class="input-default focus form-control create" id="txtValorFrete" name="txtValorFrete" class="form-control" placeholder="Valor Frete">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtFatorConversao">Fator de Conversão</label>
                                    <input type="text" class="input-default focus form-control" id="txtFatorConversao" name="txtFatorConversao" class="form-control" placeholder="Fator de Conversão" disabled>
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtAproveitamento">Aproveitamento</label>
                                    <input type="text" class="input-default focus form-control create" id="txtAproveitamento" name="txtAproveitamento" class="form-control" placeholder="Aproveitamento">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label>Data</label>
                                    <input type="date" class="input-default focus form-control" id="txtData" disabled>
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoAnterior">Preço Anterior</label>
                                    <input type="text" class="input-default focus form-control" id="txtPrecoAnterior" name="txtPrecoAnterior" class="form-control" disabled placeholder="0.00">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label>Data Última Atualização</label>
                                    <input type="date" class="input-default focus form-control" disabled id="txtDataUltimaAtualizacao">
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtLarguraMalha">Largura Malha</label>
                                    <input type="text" class="input-default focus form-control create" id="txtLarguraMalha" name="txtLarguraMalha" class="form-control" placeholder="Largura Malha">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtGramatura">Gramatura</label>
                                    <input type="text" class="input-default focus form-control create" id="txtGramatura" name="txtGramatura" class="form-control" placeholder="Gramatura">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtLIndicePeso">Índice de Peso</label>
                                    <input type="text" class="input-default focus form-control create" id="txtIndicePeso" name="txtIndicePeso" class="form-control" placeholder="Índice de Peso">
                                  </div>
                                  <div class="col-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtMVA">MVA</label>
                                    <input type="text" class="input-default focus form-control create" id="txtMVA" name="txtMVA" class="form-control" placeholder="0.00">
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtInfoCompl">Informações Complementares</label>
                                    <input type="text" class="input-default focus form-control create" id="txtInfoCompl" name="txtInfoCompl" class="form-control" placeholder="Informações Complementares">
                                  </div>
                                </div>
                                <div class="form-row">
                                  <div class="col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Observações</label>
                                    <textarea class="input-default focus form-control create" id="txtObs" name="txtObs" placeholder="Observações" rows="4" cols="50" style="resize: none;"></textarea>
                                  </div>
                                </div>
                              </div>
                              <div class="col-4 pl-2" id="divImagem">
                                <div id="divImg">
                                  <label class="labelGeral" data-success="right" for="imgMat">Imagem do Material</label>
                                  <div class="d-flex justify-content-center" id="bordaImagem" style="height: 100%">
                                    <label id="btnEscolherFoto" class="btnEnviarFoto" for="fileimagem" data-button="absolute" type="button">
                                      <img class="pop img img-fluid imagem" id="imagemMat" src="./dist/img/prod-1.png">
                                    </label>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card card-header" role="tab" id="itens">
                        <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample2" href="#multiCollapseExample2" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-down"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Itens/Cores
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse hide" id="multiCollapseExample2">
                        <div class="card card-body pb-3">
                          <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="cores-tab" style="margin-left: 1%;">
                            <div id="tabelacorestour" class="col-12 table-responsive">
                              <table id="tabelaCores" class="table table-select table-hover" style="width: 100%">
                                <thead>
                                  <tr>
                                    <th class="th">Id</th>
                                    <th class="th">Ativo</th>
                                    <th class="th">Cor</th>
                                    <th class="th">Descrição</th>
                                    <th class="th">Preço Tingimento</th>
                                    <th class="th">Preço Compra</th>
                                    <th class="th">% Desperdício</th>
                                    <th class="th">Preço</th>
                                    <th class="th">Pantone</th>
                                    <th class="th">Tinturaria</th>
                                    <th class="th">Nome</th>
                                    <th class="th">Código2</th>
                                    <th class="th">Grupo</th>
                                    <th class="th">Desc_Grupo</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                            <div class="col-12 d-none">
                              <table id="tabelaQuebrasGravar" class="table table-select table-hover" style="width: 100%">
                                <thead>
                                  <tr>
                                    <th class="th">Ordem</th>
                                    <th class="th">Código</th>
                                    <th class="th">Descrição</th>
                                    <th class="th">Unidade</th>
                                    <th class="th">Quebra</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                            <div class="form-row col-12">
                              <div class="col-12 my-2 d-flex flex-row-reverse">
                                <button type="button" id="btnCustoMalhas" style="font-size:15px;" class="btn btn-secondary btn-sisp ml-3 create" data-dismiss="modal">Custo Malhas</button>
                                <button type="button" id="btnPrecoTinturaria" style="font-size:15px;" class="btn btn-secondary btn-sisp ml-3 create" data-dismiss="modal">Preço Tinturaria</button>
                                <button type="button" id="btnQuebras" style="font-size:15px;" class="btn btn-primary btn-sisp ml-3 create" data-dismiss="modal">Quebras</button>
                                <button type="button" id="btnControleItens" style="font-size:15px;" class="btn btn-primary btn-sisp ml-2 create" data-dismiss="modal">Controle de Itens</button>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card card-header" role="tab" id="aviamentos">
                        <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample3" href="#multiCollapseExample3" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-down"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Aviamentos
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse hide" id="multiCollapseExample3">
                        <div class="card card-body pb-3">
                          <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="aviamentos-tab" style="margin-left: 1%;">
                            <div id="tabelaaviamentostour" class="col-12 table-responsive">
                              <table id="tabelaAviamentos" class="table table-select table-hover" style="width: 100%">
                                <thead>
                                  <tr>
                                    <th class="th">Ordem</th>
                                    <th class="th">Código</th>
                                    <th class="th">Material</th>
                                    <th class="th">Custo</th>
                                    <th class="th">Quantidade</th>
                                    <th class="th">Valor</th>
                                    <th class="th">Acumulado</th>
                                    <th class="th">Unidade</th>
                                    <th class="th">Atualizado</th>
                                    <th class="th">Quebra</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                          <div class="form-row col-12">
                            <div class="col-12 mt-2 d-flex flex-row-reverse">
                              <button type="button" id="btnAviamentos" style="font-size:15px;" class="btn btn-primary btn-sisp ml-3 create" data-dismiss="modal">Aviamentos</button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card card-header" role="tab" id="compras">
                        <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample4" href="#multiCollapseExample4" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-down"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Últimas Compras
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse hide" id="multiCollapseExample4">
                        <div class="card card-body pb-3">
                          <div class="tab-pane fade show active" id="cardbody-compras" role="tabpanel" aria-labelledby="compras-tab">
                          </div>
                        </div>
                      </div>
                      <input id="btnGravar" type="button" style="font-size:15px;" class="btn btn-danger btn-sisp btn-lg action-button float-right" value="Gravar">
                      <button type="button" id="btnVoltar" style="font-size:15px;" class="btn btn-success btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                    </form>
                  </div>
                </fieldset>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>

    <div class="modal fade" id="modalControleItens" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalControleItens" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloControleItens">Controle de Itens</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body bodyModal pb-0 mx-3 pr-0">
            <div class="form-group form-check col-12">
              <input type="checkbox" class="form-check-input" id="cbAtivoCI">
              <label class="form-check-label pr-4" for="cbAtivoCI">Ativo</label>
            </div>
            <div class="row">
              <div class="form-row col-12">
                <div class="col-1">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtIdCI">ID</label>
                    <div class="relative">
                      <input type="text" placeholder="ID" class="input-default focus form-control validate" id="txtIdCI" name="txtIdCI" disabled>
                    </div>
                  </div>
                </div>
                <div class="col-5">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtCorCI">Cor</label>
                    <div class="relative">
                      <div class="input-group-append">
                        <input type="text" placeholder="Cor" class="input-default focus form-control validate" id="txtCorCI" name="txtCorCI" disabled>
                        <button class="btn bg-danger" id="btnCorCI" name="btnCorCI" data-button="absolute" type="button" disabled>
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-6">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtPantoneCI">Pantone</label>
                    <div class="relative">
                      <input type="text" placeholder="Pantone" class="input-default focus form-control validate" id="txtPantoneCI" name="txtPantoneCI" disabled>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="form-row col-9 d-none" id="precosCI">
                <div class="col-3">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtPrecoTingimentoCI">Preço Tingimento</label>
                    <div class="relative">
                      <div class="input-group-append">
                        <input type="text" placeholder="0.00" class="input-default focus form-control validate" id="txtPrecoTingimentoCI" name="txtPrecoTingimentoCI">
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-3">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtPrecoCompraCI">Preço Compra</label>
                    <div class="relative">
                      <input type="number" placeholder="0.00" class="input-default focus form-control validate" id="txtPrecoCompraCI" name="txtPrecoCompraCI">
                    </div>
                  </div>
                </div>
                <div class="col-3">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtPercDespCI">% Desperdício</label>
                    <div class="relative">
                      <input type="number" placeholder="0,00" class="input-default focus form-control validate" id="txtPercDespCI" name="txtPercDespCI">
                    </div>
                  </div>
                </div>
                <div class="col-3">
                  <div class="group-default form-group">
                    <label data-error="wrong" data-success="right" for="txtPrecoCI">Preço</label>
                    <div class="relative">
                      <input type="number" placeholder="0.00" class="input-default focus form-control validate" id="txtPrecoCI" name="txtPrecoCI" disabled>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-row col-9" id="precosTodosCI">
                <div class="col-3 form-group">
                  <label data-error="wrong" data-success="right" for="txtPrecoTingimentoTodosCI">Preço Tingimento</label>
                  <div class="input-group">
                    <input type="text" placeholder="0.00" class="input-default focus form-control validate col-10" id="txtPrecoTingimentoTodosCI" name="txtPrecoTingimentoTodosCI">
                    <button id="btnPrecoTingimentoTodosCI" class="check-todos col-2">
                      <i class="fas fa-check ml-1" style="color: red; font-size: 1.2em"></i>
                    </button>
                  </div>
                </div>
                <div class="col-3 form-group">
                  <label data-error="wrong" data-success="right" for="txtPrecoCompraTodosCI">Preço Compra</label>
                  <div class="input-group">
                    <input type="text" placeholder="0.00" class="input-default focus form-control validate col-10" id="txtPrecoCompraTodosCI" name="txtPrecoCompraTodosCI">
                    <button id="btnPrecoCompraTodosCI" class="check-todos col-2">
                      <i class="fas fa-check ml-1" style="color: red; font-size: 1.2em"></i>
                    </button>
                  </div>
                </div>
                <div class="col-3 form-group">
                  <label data-error="wrong" data-success="right" for="txtPercDesperdicioTodosCI">% Desperdício</label>
                  <div class="input-group">
                    <input type="text" placeholder="0.00" class="input-default focus form-control validate col-10" id="txtPercDesperdicioTodosCI" name="txtPercDesperdicioTodosCI">
                    <button id="btnPercDesperdicioTodosCI" class="check-todos col-2">
                      <i class="fas fa-check ml-1" style="color: red; font-size: 1.2em"></i>
                    </button>
                  </div>
                </div>
                <div class="col-3 form-group">
                  <label data-error="wrong" data-success="right" for="txtPrecoTodosCI">Preço</label>
                  <div class="input-group">
                    <input type="text" placeholder="0.00" class="input-default focus form-control validate col-10" id="txtPrecoTodosCI" name="txtPrecoTodosCI">
                    <button id="btnPrecoTodosCI" class="check-todos col-2">
                      <i class="fas fa-check ml-1" style="color: red; font-size: 1.2em"></i>
                    </button>
                  </div>
                </div>
              </div>
              <div class="col-3 form-group pl-0">
                <input type="checkbox" class="form-check-input ml-0" id="cbUtilizaFatConv" disabled>
                <label data-error="wrong" class="labelGeral ml-3" data-success="right" for="cbUtilizaFatConv" disabled>Utilizar Fator de Conversão no Cálculo</label>
                <div class="relative">
                  <input type="text" placeholder="0.00" class="input-default focus form-control validate col-4" id="txtUtilizaFatConv" name="txtUtilizaFatConv" disabled>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="form-row col-12">
                <div class="col-4 form-group" id="grupoCI">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupoCI">Grupo</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtGrupoCI" required aria-describedby="uError" name="txtGrupoCI" class="form-control" placeholder="Grupo">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGrupoCI" name="btnGrupoCI" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAGrupoCI" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="form-group col-2 pt-4 mt-1 pl-5">
                  <button class="btn btn-primary btn-sisp" id="btnConsultarCI" name="btnConsultarCI" data-button="absolute" type="button">Filtrar
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                </div>
              </div>
            </div>
            <div class="form-row col-12">
              <div class="form-group col-12 d-flex mt-2">
                <button class="btn btn-secondary btn-sisp" id="btnIncluirCI">Incluir</button>
                <button class="btn btn-primary btn-sisp d-none" id="btnConfirmarCI">Confirmar</button>
                <button class="btn bg-gradient-danger btn-sisp ml-2 d-none" id="btnDesistirCI">Desistir</button>
                <button class="btn btn-secondary btn-sisp ml-2" id="btnAtualizarCoresCI">Atualizar Cores</button>
              </div>
            </div>
            <div class="form-row col-12 mt-2 table-responsive">
              <div class="col-12 form-group pl-0 ml-0">
                <div class="col-12">
                  <table id="tabelaControleItens" class="pl-0 ml-0 table table-select table-hover" style="width: 100%">
                    <thead>
                      <tr>
                        <th class="th">Id</th>
                        <th class="th">Ativo</th>
                        <th class="th">Cor</th>
                        <th class="th">Descrição</th>
                        <th class="th">Preço Tingimento</th>
                        <th class="th">Preço Compra</th>
                        <th class="th">% Desperdício</th>
                        <th class="th">Preço</th>
                        <th class="th">Pantone</th>
                        <th class="th">Tinturaria</th>
                        <th class="th">Nome</th>
                        <th class="th">Codigo2</th>
                        <th class="th">Grupo</th>
                        <th class="th">Desc Grupo</th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp mr-auto" id="btnGravarControleItens"> Confirmar</button>
            <button class="btn bg-gradient-danger btn-sisp" id="btnFecharControleItens"> Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalQuebras" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalQuebras" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloQuebras"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0 bodyModal">
            <div class="form-row col-12">
              <div class="group-default form-group col-1">
                <label data-error="wrong" data-success="right" for="txtOrdemQuebras">Ordem</label>
                <div class="relative">
                  <input type="text" placeholder="Ordem" class="input-default focus form-control validate" id="txtOrdemQuebras" name="txtOrdemQuebras" disabled>
                </div>
              </div>
              <div class="col-9 form-group">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoQuebras">Código</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCodigoQuebras" required aria-describedby="uError" name="txtCodigo" class="form-control" placeholder="Código" disabled>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnCodigoQuebras" name="btnCodigoQuebras" data-button="absolute" type="button" disabled>
                      <i class="m-0 p-0 fas fa-search"></i>
                    </button>
                    <button class="btn bg-danger" id="btnACodigoQuebras" type="button" disabled>
                      <i class="m-0 p-0 fas fa-trash"></i>
                    </button>
                  </div>
                </div>
              </div>
              <div class="group-default form-group col-1">
                <label data-error="wrong" data-success="right" for="txtUnidadeQuebras" disabled>Unidade</label>
                <div class="relative">
                  <input type="text" placeholder="UN" class="input-default focus form-control validate" id="txtUnidadeQuebras" name="txtUnidadeQuebras" disabled>
                </div>
              </div>
              <div class="group-default form-group col-1">
                <label data-error="wrong" data-success="right" for="txtQuebraQuebras">Quebra</label>
                <div class="relative">
                  <input type="number" placeholder="0.00" class="input-default focus form-control validate" id="txtQuebraQuebras" name="txtQuebraQuebras" disabled>
                </div>
              </div>
            </div>
            <div class="form-row col-12">
              <div class="group-default form-group ml-1">
                <button class="btn btn-secondary btn-sisp" id="btnIncluirQuebras">Incluir</button>
                <button class="btn btn-primary btn-sisp d-none" id="btnConfirmarQuebras">Confirmar</button>
                <!-- <button class="btn bg-gradient-danger btn-sisp ml-2" id="btnExcluirQuebras" disabled>Excluir</button> -->
                <button class="btn bg-gradient-danger btn-sisp ml-2 d-none" id="btnDesistirQuebras">Desistir</button>
              </div>
            </div>
            <div class="form-row col-12 mt-2">
              <div class="col-12 form-group pr-0">
                <div class="col-12 pr-0 table-responsive">
                  <table id="tabelaQuebras" class="table table-select table-hover" style="width: 100%">
                    <thead>
                      <tr>
                        <th class="th">Ordem</th>
                        <th class="th">Código</th>
                        <th class="th">Descrição</th>
                        <th class="th">Unidade</th>
                        <th class="th">Quebra</th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp mr-auto" id="btnGravarQuebras"> Confirmar</button>
            <button class="btn bg-gradient-danger btn-sisp" id="btnFecharQuebras"> Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalPrecoTin" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalPrecoTin" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloPrecoTin"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0 bodyModal">
            <div class="form-row col-8">
              <div class="form-group col-10">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtTinturariaPrecoTin">Tinturaria</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtTinturariaPrecoTin" required aria-describedby="uError" name="txtTinturariaPrecoTin" class="form-control" placeholder="Tinturaria">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnTinturariaPrecoTin" name="btnTinturariaPrecoTin" data-button="absolute" type="button">
                      <i class="m-0 p-0 fas fa-search"></i>
                    </button>
                    <button class="btn bg-danger" id="btnATinturariaPrecoTin" type="button">
                      <i class="m-0 p-0 fas fa-trash"></i>
                    </button>
                  </div>
                </div>
              </div>
              <div class="form-group col-2 pt-4 mt-1">
                <button class="btn btn-primary" style="width: 160px;" id="btnConsultarPrecoTin" name="btnConsultarPrecoTin" data-button="absolute" type="button">Consultar
                  <i class="m-0 p-0 fas fa-search"></i>
                </button>
              </div>
            </div>
            <div class="form-row col-12">
              <div class="form-group col-2">
                <div class="group-default form-group">
                  <label data-error="wrong" data-success="right" for="txtPrecoNovoPrecoTin">Preço Novo</label>
                  <div class="relative">
                    <input type="number" placeholder="0.00" class="input-default focus form-control validate" id="txtPrecoNovoPrecoTin" name="txtPrecoNovoPrecoTin" disabled>
                  </div>
                </div>
              </div>
              <div class="form-group col-2 pt-4 mt-1">
                <button class="btn btn-primary d-none" style="width: 160px;" id="btnConfirmarPrecoTin" name="btnConfirmarPrecoTin" data-button="absolute" type="button">Confirmar
                </button>
              </div>
              <div class="form-group col-2 pt-4 mt-1">
                <button class="btn bg-gradient-danger d-none" style="width: 160px;" id="btnDesistirPrecoTin" name="btnDesistirPrecoTin" data-button="absolute" type="button">Desistir
                </button>
              </div>
            </div>
            <div class="form-row col-12">
              <div class="form-row col-12 mt-2">
                <div class="col-12 form-group">
                  <div class="col-12 table-responsive">
                    <table id="tabelaPrecoTin" class="table table-select table-hover" style="width: 100%">
                      <thead>
                        <tr>
                          <th class="th">Código</th>
                          <th class="th">Descrição</th>
                          <th class="th">Preço Atual</th>
                          <th class="th">Preço Tintur</th>
                          <th class="th">Preço Novo</th>
                          <th class="th">Pantone</th>
                          <th class="th">Tinturaria</th>
                          <th class="th">Nome</th>
                          <th class="th">Codigo2</th>
                          <th class="th">Grupo</th>
                          <th class="th">Desc Grupo</th>
                        </tr>
                      </thead>
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp mr-auto" id="btnGravarPrecoTin"> Confirmar</button>
            <button class="btn bg-gradient-danger btn-sisp" id="btnFecharPrecoTin"> Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalCustoMalhas" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalCustoMalhas" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloCustoMalhas"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>

          <div class="modal-body bodyModal p-0">
            <div id="divMalhasRotativas">
              <div class="card card-header" role="tab" id="modalCustoMalhasRotativas">
                <a style="width:100%;" data-toggle="collapse" data-parent="#collapseMalhaRotativa" href="#collapseMalhaRotativa" aria-expanded="true" aria-controls="collapseOne1">
                  <div class="row">
                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                      <i class="fas fa-angle-down"></i>
                    </div>
                    <div class="col-11">
                      <h4 class="title-page">
                        Malhas Rotativas
                      </h4>
                    </div>
                  </div>
                </a>
              </div>
              <div class="collapse show" id="collapseMalhaRotativa">
                <div class="card card-body">
                  <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                    <div class="col-12" id="gridMalhaRotativa">
                      <div class="form-row col-12">
                        <div class="form-group col-3">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtAviamentoCustoMalhas">Aviamento</label>
                          <div class="relative">
                            <input type="text" class="input-default focus form-control" id="txtAviamentoCustoMalhas" required aria-describedby="uError" name="txtAviamentoCustoMalhas" class="form-control" placeholder="Código" disabled>
                          </div>
                        </div>
                      </div>
                      <div class="form-row col-12">
                        <div class="form-row col-12 mt-2">
                          <div class="col-12 form-group">
                            <div class="col-12 table-responsive">
                              <table id="tabelaCustoMalhaRotativa" class="table table-select table-hover" style="width: 100%">
                                <thead>
                                  <tr>
                                    <th class="th">Cor Rotativa</th>
                                    <th class="th">Desc_cor</th>
                                    <th class="th">Cor Fundo</th>
                                    <th class="th">Desc_cor_fundo</th>
                                    <th class="th">Preço</th>
                                    <th class="th">Custo Malha</th>
                                    <th class="th">Desperdício</th>
                                    <th class="th">Custo Total</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div style="background-color: white; height: 1px; margin-bottom: 10px;">
            </div>
            <div id="divMalhaBase">
              <div class="card card-header" role="tab" id="modalCustoMalhaBase">
                <a style="width:100%;" data-toggle="collapse" data-parent="#collapseMalhaBase" href="#collapseMalhaBase" aria-expanded="true" aria-controls="collapseOne1">
                  <div class="row">
                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                      <i class="fas fa-angle-down"></i>
                    </div>
                    <div class="col-11">
                      <h4 class="title-page">
                        Malhas Base
                      </h4>
                    </div>
                  </div>
                </a>
              </div>
              <div class="collapse show" id="collapseMalhaBase">
                <div class="card card-body">
                  <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">

                    <div class="col-12" id="gridMalhaBase">
                      <div class="form-row col-12">
                        <div class="form-group col-3">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtMalhaBase">Código</label>
                          <div class="relative">
                            <input type="text" class="input-default focus form-control" id="txtMalhaBase" required aria-describedby="uError" name="txtMalhaBase" class="form-control" placeholder="Código" disabled>
                          </div>
                        </div>
                        <div class="form-group col-2 pt-4 mt-1 ml-auto">
                          <button class="btn btn-primary" style="width: 160px;" id="btnConsultarCustoMalhas" name="btnConsultarCustoMalhas" data-button="absolute" type="button">Buscar Custo
                            <i class="m-0 p-0 fas fa-search"></i>
                          </button>
                        </div>
                      </div>
                      <div class="form-row col-12">
                        <div class="form-row col-12 mt-2">
                          <div class="col-12 form-group">
                            <div class="col-12 table-responsive">
                              <table id="tabelaCustoMalhaBase" class="table table-select table-hover" style="width: 100%">
                                <thead>
                                  <tr>
                                    <th class="th">Cor</th>
                                    <th class="th">Descrição</th>
                                    <th class="th">Custo Crua</th>
                                    <th class="th">Custo Tint</th>
                                    <th class="th">% Desperdício</th>
                                    <th class="th">Custo Total</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div style="background-color: white; height: 1px; margin-bottom: 10px;">
            </div>
            <div id="divMalhaCrua">
              <div class="card card-header" role="tab" id="modalCustoMalhaCrua">
                <a style="width:100%;" data-toggle="collapse" data-parent="#collapseMalhaCrua" href="#collapseMalhaCrua" aria-expanded="true" aria-controls="collapseOne1">
                  <div class="row">
                    <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                      <i class="fas fa-angle-down"></i>
                    </div>
                    <div class="col-11">
                      <h4 class="title-page">
                        Malhas Cruas
                      </h4>
                    </div>
                  </div>
                </a>
              </div>
              <div class="collapse show" id="collapseMalhaCrua">
                <div class="card card-body">
                  <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">

                    <div class="col-12" id="gridMalhaCrua">
                      <div class="form-row col-12">
                        <div class="form-group col-3">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtMalhaCrua">Código</label>
                          <div class="relative">
                            <input type="text" class="input-default focus form-control" id="txtMalhaCrua" required aria-describedby="uError" name="txtMalhaCrua" class="form-control" placeholder="Código" disabled>
                          </div>
                        </div>
                        <div class="form-group col-2 ml-auto">
                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtCustoTec">Custo Tec</label>
                          <div class="relative">
                            <input type="text" class="input-default focus form-control" id="txtCustoTec" required aria-describedby="uError" name="txtCustoTec" class="form-control" placeholder="0.00">
                          </div>
                        </div>
                      </div>
                      <div class="form-row col-12">
                        <div class="form-row col-12 mt-2">
                          <div class="col-12 form-group">
                            <div class="col-12 table-responsive">
                              <table id="tabelaCustoMalhaCrua" class="table table-select table-hover" style="width: 100%">
                                <thead>
                                  <tr>
                                    <th class="th">Código</th>
                                    <th class="th">Descrição</th>
                                    <th class="th">Cor</th>
                                    <th class="th">Desc_cor</th>
                                    <th class="th">Custo Fio</th>
                                    <th class="th">Desperdício</th>
                                    <th class="th">Custo Quebra</th>
                                    <th class="th">Custo Total</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp mr-auto" id="btnGravarModalCusto"> Confirmar</button>
            <button class="btn bg-gradient-danger btn-sisp" id="btnFecharModalCusto"> Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalAviamentos" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="modalAviamentos" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title" id="tituloModalAviamentos"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body bodyModal" id="modalAviamentosBody">
            <div class="form-row col-12">
              <div class="col-1 form-group">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtOrdemModalAviamentos">Ordem</label>
                <div class="relative">
                  <input type="text" class="input-default focus form-control" id="txtOrdemModalAviamentos" required aria-describedby="uError" name="txtOrdemModalAviamentos" class="form-control" placeholder="Ordem" disabled>
                </div>
              </div>
              <div class="col-8 form-group">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtMaterialModalAviamentos">Material</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtMaterialModalAviamentos" required aria-describedby="uError" name="txtMaterialModalAviamentos" class="form-control" placeholder="Material" disabled>
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btnMaterialModalAviamentos" name="btnMaterialModalAviamentos" data-button="absolute" type="button" disabled>
                      <i class="m-0 p-0 fas fa-search"></i>
                    </button>
                    <button class="btn bg-danger" id="btnAMaterialModalAviamentos" type="button" disabled>
                      <i class="m-0 p-0 fas fa-trash"></i>
                    </button>
                  </div>
                </div>
              </div>
              <div class="col-1 form-group">
                <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeModalAviamentos">Unidade</label>
                <div class="relative">
                  <input type="text" class="input-default focus form-control" id="txtUnidadeModalAviamentos" required aria-describedby="uError" name="txtUnidadeModalAviamentos" class="form-control" placeholder="UN" disabled>
                </div>
              </div>
              <div class="col-2 form-group">
                <label class="col-3">Preço</label>
                <select class="drilldown-item form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="opcoesPrecoAviamentos" style="border-color: #a9a9a9; font-size: 15px">
                  <option class="drilldown-item" value="M">Preço Máximo</option>
                  <option class="drilldown-item" value="P">Preço Padrão</option>
                </select>
              </div>
            </div>
            <div class="form-row col-12">
              <div class="form-group col-1">
                <label data-error="wrong" data-success="right" for="txtQuantidadeModalAviamentos" disabled>Quantidade</label>
                <div class="relative">
                  <input type="text" placeholder="0" class="input-default focus form-control validate" id="txtQuantidadeModalAviamentos" name="txtQuantidadeModalAviamentos" disabled>
                </div>
              </div>
              <div class="form-group col-1">
                <label data-error="wrong" data-success="right" for="txtQuebraModalAviamentos" disabled>% Quebra</label>
                <div class="relative">
                  <input type="text" placeholder="00.00" class="input-default focus form-control validate" id="txtQuebraModalAviamentos" name="txtQuebraModalAviamentos" disabled>
                </div>
              </div>
            </div>
            <div class="form-row col-12">
              <div class="group-default form-group ml-1 d-flex">
                <button class="btn btn-primary btn-sisp" id="btnIncluirModalAviamentos">Incluir</button>
                <button class="btn btn-primary btn-sisp ml-2" id="btnRecalcularModalAviamentos">Recalcular</button>
                <button class="btn btn-primary btn-sisp d-none" id="btnConfirmarModalAviamentos">Confirmar</button>
                <button class="btn bg-gradient-danger btn-sisp ml-2 d-none" id="btnDesistirModalAviamentos">Desistir</button>
                <button class="btn btn-secondary btn-sisp ml-auto" id="btnComposicaoModalAviamentos">Composição</button>
              </div>
            </div>
            <div class="col-12 ml-0 p-0 table-responsive">
              <table id="tabelaModalAviamentos" class="p-0 mt-0 table table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th">Ordem</th>
                    <th class="th">Código</th>
                    <th class="th">Descrição</th>
                    <th class="th">Unidade</th>
                    <th class="th">Quantidade</th>
                    <th class="th">Custo</th>
                    <th class="th">Quebra</th>
                    <th class="th">Valor</th>
                    <th class="th">Acumulado</th>
                    <th class="th">Atualizado</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-primary btn-sisp mr-auto" id="btnGravarModalAviamentos"> Confirmar</button>
            <button class="btn bg-gradient-danger btn-sisp" id="btnFecharModalAviamentos"> Fechar</button>
          </div>
        </div>
      </div>
    </div>

    <?php
    include_once('../../../footer.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script>
    function formatar(mascara, documento) {
      var i = documento.value.length;
      var saida = mascara.substring(0, 1);
      var texto = mascara.substring(i);

      if (texto.substring(0, 1) != saida) {
        documento.value += texto.substring(0, 1);
      }

    }
  </script>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.231.12.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.231.12.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.231.12.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.231.12.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.231.12.1"></script>

  <script src="../dist/js/adminlte.min.js?versao=3.231.12.1"></script>

  <script src="../dist/js/requisicoes.js?versao=3.231.12.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.231.12.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.231.12.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.231.12.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.231.12.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.231.12.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.231.12.1"></script>
  <script src="../utils/funcoes.js?versao=3.231.12.1"></script>
  <script src="../utils/cookies.js?versao=3.231.12.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.231.12.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.231.12.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.231.12.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADMATPRECO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("CADMATPRECO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/cadmatpreco`
        });
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split("/");
      const material = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        e.preventDefault();
        if (material != 'create') {
          deletaRegistro("CADMATPRECO", getCookie("usuario"), material, getCookie("usuario"));
        }
        return undefined;
      });

      if (material != 'create') {
        await liberarRegistro("CADMATPRECO", material);
      }

      sArquivo = `${BASE_URI}/pages/cadmatpreco/cadastro_matpreco/cadmatpreco.js?versao=3.231.12.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>