$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar a ordem de compra a ser liberada.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de ordens de compra.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear as ordens de compra selecionadas.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const parametrosVenda = await BuscaParametrosVenda();
  if (parametrosVenda[72] != '1') {
    $('#tabCashback').addClass('d-none');
  }
  let valoresPadroes = [
    { TABELA: 'PRODUTO', CAMPO: 'UNIDADE', DESCRICAO: 'UNIDADE DO PRODUTO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'UNI_VENDA', DESCRICAO: 'UNIDADE DE VENDA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODFIS', DESCRICAO: 'CÓDIGO NCM', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ICMS', DESCRICAO: 'PERCENTUAL DE ICMS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODTRIB', DESCRICAO: 'CST DE ICMS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODIPI', DESCRICAO: 'CST DE IPI DE SAÍDA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'CODIPI_ENT', DESCRICAO: 'CST DE IPI DE ENTRADA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TRIBUTACAO', DESCRICAO: 'TRIBUTAÇÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'IPI', DESCRICAO: 'PERCENTUAL DE IPI', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'POSSE', DESCRICAO: 'POSSE', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'SPED', DESCRICAO: 'SPED', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'GRUPO_PRODUTO', DESCRICAO: 'GRUPO DE PRODUTO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ECF_TRIB', DESCRICAO: 'ST DO ICMS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TIPO_VENDA', DESCRICAO: 'TIPO DE VENDA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'TIPO_PROD', DESCRICAO: 'TIPO CÓDIGO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'SETOR', DESCRICAO: 'SETOR PADRÃO NOS CONSUMOS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'APLICACAO', DESCRICAO: 'APLICAÇÃO PADRÃO NOS CONSUMOS', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COLECAO', DESCRICAO: 'COLEÇÃO PADRÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'UNI_EXP', DESCRICAO: 'UNIDADE EXPORTAÇÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'DIV_EXP', DESCRICAO: 'CONVERSÃO EXPORTAÇÃO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ETIQUETA', DESCRICAO: 'ETIQUETA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'LINHA', DESCRICAO: 'LINHA', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'ATIVO', DESCRICAO: 'ATIVO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR_ENT_MANUAL', DESCRICAO: 'COR ENTRADA MANUAL', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR_SAI_MANUAL', DESCRICAO: 'COR SAÍDA MANUAL', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'COR', DESCRICAO: 'COR PADRÃO PARA CADASTRO DE PRODUTO', VALOR: '' },
    { TABELA: 'PRODUTO', CAMPO: 'FAIXA_TAMANHO', DESCRICAO: 'FAIXA DE TAMANHO PADRÃO PARA CADASTRO DE PRODUTO', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'UNIDADE', DESCRICAO: 'UNIDADE DO MATERIAL', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'UNI_COM', DESCRICAO: 'UNIDADE DE COMPRA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODFIS', DESCRICAO: 'CÓDIGO NCM', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODTRI', DESCRICAO: 'CST DE ICMS DE SAÍDA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODTRI_ENT', DESCRICAO: 'CST DE ICMS DE ENTRADA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODIPI', DESCRICAO: 'CST DE IPI DE SAÍDA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CODIPI_ENT', DESCRICAO: 'CST DE IPI DE ENTRADA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'CDCENTRO', DESCRICAO: 'CENTRO DE CUSTO', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'IPI', DESCRICAO: 'PERCENTUAL DE IPI', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'POSSE', DESCRICAO: 'POSSE', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'SPED', DESCRICAO: 'SPED', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'TRIBUTACAO', DESCRICAO: 'TRIBUTAÇÃO', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ENQUADRA', DESCRICAO: 'ENQUADRAMENTO IPI', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'GRUPO_MA', DESCRICAO: 'GRUPO DO MATERIAL', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'SUBGRUPO_MA', DESCRICAO: 'SUBGRUPO DO MATERIAL', VALOR: '' },
    { TABELA: 'MATERIAL', CAMPO: 'ATIVO', DESCRICAO: 'ATIVO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_CLIENTE', DESCRICAO: 'INICIO CONTA CONTABIL CLIENTE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CC_FORNECEDOR', DESCRICAO: 'INICIO CONTA CONTABIL FORNECEDOR', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'GRUPO_CLI', DESCRICAO: 'GRUPO DE ENTIDADE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'SIT_DUP', DESCRICAO: 'SITUACAO DUPLICATA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'IE_DESTINATARIO', DESCRICAO: 'INDICADOR DO IE DE DESTINATARIO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CODREP', DESCRICAO: 'REPRESENTANTE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'RAMO_ATIV', DESCRICAO: 'RAMO ATIV', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CONS_FINAL', DESCRICAO: 'CONSUMIDOR FINAL', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA SAIDA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NATUREZA_ENTRA', DESCRICAO: 'NATUREZA ENTRADA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TRANSPORTE', DESCRICAO: 'TRANSPORTADORA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TP_FRETE', DESCRICAO: 'TIPO DE FRETE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'EMAIL', DESCRICAO: 'EMAIL', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'FORMA_PAGTO', DESCRICAO: 'FORMAS DE PAGAMENTO (SEPARAR POR VIRGULA QUANDO + DE 1)', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'MARKUP', DESCRICAO: 'MARKUP', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'MOEDAS', DESCRICAO: 'MOEDAS (SEPARAR POR VIRGULA QUANDO + DE 1)', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'TIPO_ENTIDADE', DESCRICAO: 'TIPO DA ENTIDADE', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_CONSIGNADO', DESCRICAO: 'VALOR INICIAL LIMITE DE CRÉDITO CONSIGNADO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_VENDA', DESCRICAO: 'VALOR INICIAL LIMITE DE CRÉDITO VENDA', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'VAL_LIMIT_MAIOR_12', DESCRICAO: 'VALOR LIMITE DE CRÉDITO PARA CLIENTES CADASTRADOS COM MAIS DE 12 MESES', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'PERC_RECALC_LIMIT_CR', DESCRICAO: 'PERCENTUAL PARA RECALCULAR LIMITE DE CRÉDITO', VALOR: '' },
    { TABELA: 'ENTIDADE', CAMPO: 'NUMERO_MESES_RECALC', DESCRICAO: 'NÚMERO DE MESES PARA RECALCULAR LIMITE DE CRÉDITO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'OPER_FISCAL', DESCRICAO: 'OPERAÇÃO FISCAL', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'QUALIDADE', DESCRICAO: 'QUALIDADE', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO_OF', DESCRICAO: 'TIPO OF', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'ITEM', DESCRICAO: 'ITEM', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'ESQUADRETAS', DESCRICAO: 'ESQUADRETAS', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'PELICULA', DESCRICAO: 'PELÍCULA', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'PINTURA_PB', DESCRICAO: 'PINTURA PB', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'PINTURA_CL', DESCRICAO: 'PINTURA CL', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TIPO', DESCRICAO: 'TIPO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'TRANSPORTADORA', DESCRICAO: 'TRANSPORTADORA', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'SIT_DUP', DESCRICAO: 'SIT_DUP', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'DEP_FILHO', DESCRICAO: 'DEP_FILHO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_CANC_API', DESCRICAO: 'STATUS_CANC_API', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'STATUS_ANTECIPACAO', DESCRICAO: 'STATUS_ANTECIPACAO', VALOR: '' },
    { TABELA: 'PEDIDO', CAMPO: 'ITEM_PADRAO', DESCRICAO: 'ITEM PADRÃO (P/M)', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'NAT_SERVICO', DESCRICAO: 'NATUREZA SERVIÇO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACAO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'TP_MOV', DESCRICAO: 'TIPO DE MOVIMENTAÇÃO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'HISTORICO', DESCRICAO: 'HISTORICO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'BANCO', DESCRICAO: 'BANCO', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE', VALOR: '' },
    { TABELA: 'NOTA_ENTRA', CAMPO: 'TIPO_ITEM', DESCRICAO: 'TIPO ITEM PADRÃO AO CADASTRAR NOVOS ITENS NA ENTRADA DE NF', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'NATUREZA', DESCRICAO: 'NATUREZA', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'OPERACAO', DESCRICAO: 'OPERACAO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'UF_EMBARQUE', DESCRICAO: 'UF EMBARQUE', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'LOCAL_EMBARQUE', DESCRICAO: 'LOCAL EMBARQUE', VALOR: '' },
    { TABELA: 'NOTA', CAMPO: 'PRESENCA', DESCRICAO: 'PRESENÇA', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'TIPO', DESCRICAO: 'TIPO DE MOVIMENTO', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'QUALIDADE', DESCRICAO: 'QUALIDADE', VALOR: '' },
    { TABELA: 'ESTOQUE', CAMPO: 'TIPO_CONFERENCIA', DESCRICAO: 'TIPO CONFERENCIA', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'FUNCIONARIO_PROD', DESCRICAO: 'FUNCIONARIO (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_ORIGEM_PROD', DESCRICAO: 'DEPÓSITO ORIGEM (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_DEST_PROD', DESCRICAO: 'DEPÓSITO DESTINO (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_PROD', DESCRICAO: 'TIPO DE MOVIMENTO (PRODUTO)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'FUNCIONARIO_MAT', DESCRICAO: 'FUNCIONARIO (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_ORIGEM_MAT', DESCRICAO: 'DEPÓSITO ORIGEM (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'DEPOSITO_DEST_MAT', DESCRICAO: 'DEPÓSITO DESTINO (MATERIAL)', VALOR: '' },
    { TABELA: 'TRANSF_DEPOSITO', CAMPO: 'TIPO_MOVTO_MAT', DESCRICAO: 'TIPO DE MOVIMENTO (MATERIAL)', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'CLASSE', DESCRICAO: 'CLASSE GERENCIAL', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'SITUACAO', DESCRICAO: 'SITUAÇÃO', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'MOEDA', DESCRICAO: 'MOEDA', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'CONTA', DESCRICAO: 'CONTA', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'EMISSAO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'VENCIMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'RECEBER', CAMPO: 'PAGAMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'EMISSAO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'VENCIMENTO_DE', DESCRICAO: 'CONSIDERAR O DIA 1º DO MÊS ATUAL PARA A CONSULTA DAS DUPLICATAS (INFORMAR S PARA ATIVAR).', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'STATUS', DESCRICAO: 'STATUS', VALOR: '' },
    { TABELA: 'PAGTO', CAMPO: 'SITUACAO', DESCRICAO: 'SITUACAO', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'INFORMACOES_CLIENTE', DESCRICAO: 'ABRE A TELA DE INFORMAÇÕES CLIENTE AO SAIR DO CAMPO DE CLIENTE (INFORMAR S PARA ATIVAR)', VALOR: '' },
    { TABELA: 'LOJA', CAMPO: 'RETORNA_USUARIO', DESCRICAO: 'RETORNA USUÁRIO LOGADO AO ABRIR OS FILTROS DO RELATÓRIO DE VENDA (INFORMAR S PARA ATIVAR)', VALOR: '' },
    { TABELA: 'CASHBACK', CAMPO: 'VAL_MIN', DESCRICAO: 'VALOR MÍNIMO DA VENDA PARA CONSIDERAR O CASHBACK', VALOR: '' },
    { TABELA: 'CASHBACK', CAMPO: 'PERCENTUAL', DESCRICAO: 'PERCENTUAL', VALOR: '' },
    { TABELA: 'CASHBACK', CAMPO: 'VALIDADE', DESCRICAO: 'TEMPO DE VALIDADE EM DIAS', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'TIPO_BAIXA', DESCRICAO: 'TIPO DE BAIXA', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'DEPOSITO', DESCRICAO: 'DEPOSITO', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'DEPOSITO_ENTRADA', DESCRICAO: 'DEPOSITO DE ENTRADA', VALOR: '' },
    { TABELA: 'DESDOBRALOTE', CAMPO: 'LOCAL', DESCRICAO: 'LOCAL', VALOR: '' },
  ];

  criaDataTablePadrao('#tabelaProduto', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaMaterial', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEntidade', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaPedido', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEntradaNf', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaFaturamento', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaEstoque', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaTransfDep', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaReceber', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaContasPagar', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaLoja', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaCashback', false, false, false, false, true, false, '400px');
  criaDataTablePadrao('#tabelaDesdobraLote', false, false, false, false, true, false, '400px');

  preencheCampos();
  await carregaValores();

  $('#tabPedido, #tabMaterial, #tabProduto, #tabEntidade, #tabEntradaNf, #tabFaturamento, #tabEstoque, #tabTransfDep, #tabReceber, #tabContasPagar, #tabLoja, #tabCashback, #tabDesdobraLote').on('click', function () {
    setTimeout(() => {
      $('#tabelaProduto').DataTable().columns.adjust().draw(false);
      $('#tabelaMaterial').DataTable().columns.adjust().draw(false);
      $('#tabelaEntidade').DataTable().columns.adjust().draw(false);
      $('#tabelaPedido').DataTable().columns.adjust().draw(false);
      $('#tabelaEntradaNf').DataTable().columns.adjust().draw(false);
      $('#tabelaFaturamento').DataTable().columns.adjust().draw(false);
      $('#tabelaEstoque').DataTable().columns.adjust().draw(false);
      $('#tabelaTransfDep').DataTable().columns.adjust().draw(false);
      $('#tabelaReceber').DataTable().columns.adjust().draw(false);
      $('#tabelaContasPagar').DataTable().columns.adjust().draw(false);
      $('#tabelaLoja').DataTable().columns.adjust().draw(false);
      $('#tabelaCashback').DataTable().columns.adjust().draw(false);
      $('#tabelaDesdobraLote').DataTable().columns.adjust().draw(false);
    }, 180);
  });

  $('#btnGravar').on('click', async function () {
    await gravaDados();
  });

  async function preencheCampos() {
    valoresPadroes.map(item => {
      if (item.TABELA == 'PRODUTO' && item.CAMPO != 'TIPO_VENDA') {
        $('#tabelaProduto').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'MATERIAL') {
        $('#tabelaMaterial').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ENTIDADE' && item.CAMPO == "TIPO_ENTIDADE") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected>Selecione um tipo de entidade</option>` +
          `<option value="CLIENTE">Cliente</option>` +
          `<option value="FORNECEDOR">Fornecedor</option>` + 
          `<option value="TERCEIROS">Terceiros</option>` + 
          `<option value="REPRESENTANTE">Representante</option>` + 
          `<option value="PROSPECTO">Prospecto</option>` + 
          `<option value="FUNCIONARIO">Funcionário</option>` + 
          `</select>`]).draw(false);
      } else if (item.TABELA == "ENTIDADE") {
        $('#tabelaEntidade').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PEDIDO') {
        $('#tabelaPedido').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'NOTA_ENTRA' && item.CAMPO != 'TIPO_ITEM') {
        $('#tabelaEntradaNf').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'NOTA') {
        $('#tabelaFaturamento').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'ESTOQUE') {
        $('#tabelaEstoque').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'TRANSF_DEPOSITO') {
        $('#tabelaTransfDep').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'CLASSE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'STATUS') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                             <option value="TODOS">Todos</option>
                                                                             <option value="DUPL" selected>Duplicatas</option>
                                                                             <option value="ANTE">Antecipações</option>
                                                                             <option value="ORCA">Orçamentos</option>
                                                                             <option value="CHEQ">Cheques</option>
                                                                             <option value="CHDE">Cheques Devolvidos</option>
                                                                             <option value="DESD">Desdobradas</option>
                                                                             <option value="AGRU">Agrupadas</option>
                                                                             <option value="CANC">Canceladas</option>
                                                                             <option value="DEVO">Devolução</option>
                                                                             <option value="AVDD">Aviso Débito</option>
                                                                             <option value="PRESENTE">Cartão Presente</option>
                                                                             </select>` ]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'SITUACAO') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                              <option value="Todos">Todos</option>
                                                                              <option value="Em Aberto" selected>Em Aberto</option>
                                                                              <option value="Perdidas">Perdidas</option>
                                                                              <option value="Pagas">Pagas</option>
                                                                              </select>`]).draw(false);
      } else if (item.TABELA == 'RECEBER') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'EMISSAO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'VENCIMENTO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'RECEBER' && item.CAMPO == 'PAGAMENTO_DE') {
        $('#tabelaReceber').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'EMISSAO_DE') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'VENCIMENTO_DE') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'STATUS') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                  <option value="">Todos</option>
                                                                                  <option value="DUPL">A.Ps</option>
                                                                                  <option value="ANTE">Antecipações</option>
                                                                                  <option value="ORCA">Orçamentos</option>
                                                                                  <option value="CHEQ">Cheques</option>
                                                                                  <option value="CHDE">Cheques Devolvidos</option>
                                                                                  <option value="CHCA">Cheques Cancelados</option>
                                                                                  <option value="DESD">Desdobradas</option>
                                                                                  <option value="AGRU">Agrupadas</option>
                                                                                </select>` ]).draw(false);
      } else if (item.TABELA == 'PAGTO' && item.CAMPO == 'SITUACAO') {
        $('#tabelaContasPagar').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">
                                                                                <option value="">Todos</option>
                                                                                <option value="Aberto">Aberto</option>
                                                                                <option value="Pagas">Pagas</option>
                                                                                <option value="Devolvidas">Devolvidas</option>
                                                                                </select>`]).draw(false);
      } else if (item.TABELA == 'LOJA') {
        $('#tabelaLoja').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'CASHBACK') {
        $('#tabelaCashback').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'DESDOBRALOTE') {
        $('#tabelaDesdobraLote').DataTable().row.add([item.CAMPO, item.DESCRICAO, retornaInput(item.TABELA, item.CAMPO)]).draw(false);
      } else if (item.TABELA == 'PRODUTO' && item.CAMPO == 'TIPO_VENDA') {
        $('#tabelaProduto').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected></option>` +
          `<option value="0">Produção</option>` +
          `<option value="1">Revenda</option>` +
          `</select>`]).draw(false);
      } else if (item.TABELA == 'NOTA_ENTRA' && item.CAMPO == 'TIPO_ITEM') {
        $('#tabelaEntradaNf').DataTable().row.add([item.CAMPO, item.DESCRICAO, `<select id="txt${item.TABELA}${item.CAMPO}" class="input-default focus validate">` +
          `<option value="" selected></option>` +
          `<option value="P">P</option>` +
          `<option value="M">M</option>` +
          `</select>`]).draw(false);
      }
    });
  };

  function retornaInput(sTabela, sCampo) {
    return `<input type="text" class="input-default focus" id="txt${sTabela}${sCampo}">`;
  };

  async function carregaValores() {
    const valores = await retornaJsonPesquisaPadrao(JSON.stringify({ tabela: "TABPADRAO", camposSelect: ["CAMPO", "TABELA", "VALOR"] }));
    valores.map(item => { insereValor(`#txt${item.TABELA}${item.CAMPO}`, item.VALOR); });
  };

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {
      valoresPadroes.map(item => {
        item.VALOR = pegaValor(`#txt${item.TABELA}${item.CAMPO}`);
      });

      const response = await requisicao('POST', '/sisplan/cadastros/v1/cadpadrao?', '', JSON.stringify({ LISTAITENS: valoresPadroes }), 60000);

      if (!response) {
        msgAlerta('Não foi possível gravar os valores padrões, tente novamente.');
        return;
      };

      if (response.status != 200) {
        msgAlerta('Não foi possível gravar os valores padrões, tente novamente.');
        return;
      };

      criaMensagemSucesso('Valores padrões gravados com sucesso.');

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide')
    }
  };

});