/* eslint-disable prefer-rest-params */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Neste campo adicionamos o código que será utilizado nesse registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o registro.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a parte.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let codigo = parametros[parametros.length - 1];

    $(document).ready(function () {
        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADPARTE', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/cadparte`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($('#txtCodigo').val() == '') {
            const codigo = await RetornaProximo("TIPO_APL", "TIPO_APL", "CODIGO", 1);
            $('#txtCodigo').val(codigo);
            $('#txtCodigo').prop('disabled', true);
        }
        if (codigo === 'create') {
            const codigo = $('#txtCodigo').val();
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"TIPO_APL",
                    "camposSelect":["CODIGO"], 
                    "where": ["CODIGO = '${codigo}'"]}`, null);

            let json = await response.json();
            if (json.RESULT[0].length > 0) {
                msgAlerta('Código já existe. Favor verifique!');
                return;
            }
        }
    });

    $('#gravar').on('keypress', function () {
        $('#gravar').trigger('click');
    });

    if (codigo != '' && codigo != 'create') {
        if (await liberarRegistro('CADPARTE', codigo) == false) {
            window.location.href = '../cadparte';
        } else {
            try {
                $.LoadingOverlay("show");

                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TIPO_APL", 
                            "camposSelect":["CODIGO", "DESCRICAO", "ATIVO", "PADRAO", "ESTOQUE"], 
                            "where": ["CODIGO = '${codigo}'"]}`, null);

                    let json = await response.json();

                    $('#txtCodigo').val(json.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(json.RESULT[0][0].DESCRICAO);

                    if (json.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    }
                    if (json.RESULT[0][0].PADRAO == 'S') {
                        $('#checkPadrao').prop('checked', true);
                    }
                    if (json.RESULT[0][0].ESTOQUE == 'S') {
                        $('#checkEstoque').prop('checked', true);
                    }

                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#checkPadrao").on("click", async function () {
        if ($("#checkPadrao").prop("checked")) {
            try {
                let response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"TIPO_APL", "camposSelect":["CODIGO,PADRAO"], "where":[" PADRAO = 'S' "]}`,
                    null
                );

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.RESULT[0].mensagem);
                    return;
                }
                if (jsonStr.RESULT[0].length != 0) {
                    $("#checkPadrao").trigger("click");
                    $("#checkPadrao").attr("checked", false);
                    msgAlerta(`A parte ${jsonStr.RESULT[0][0].CODIGO} já está como padrão`);
                }
            } catch (error) {
                console.error(error);
            }
        }
    });

    $("#gravar").click(async function () {
        try {
            $.LoadingOverlay("show");

            const codigo = $('#txtCodigo').val().trim();
            const descricao = $('#txtDescricao').val().trim();

            if (codigo === '') {
                msgAlerta(`Necessário informar um código.`);
                $.LoadingOverlay("hide");
                return;
            }
            if (descricao === '') {
                msgAlerta(`Necessário informar uma descrição.`);
                $.LoadingOverlay("hide");
                return;
            }

            let parte = {};

            parte.CODIGO = $('#txtCodigo').val().toUpperCase();
            parte.DESCRICAO = $('#txtDescricao').val().toUpperCase();
            parte.ATIVO = $('#checkAtivo').prop('checked') ? parte.ATIVO = 'S' : parte.ATIVO = 'N';
            parte.PADRAO = $('#checkPadrao').prop('checked') ? parte.PARTE = 'S' : parte.PARTE = 'N';
            parte.ESTOQUE = $('#checkEstoque').prop('checked') ? parte.ESTOQUE = 'S' : parte.ESTOQUE = 'N';

            let response = await requisicao('POST', '/sisplan/cadastros/v1/cadparte?', '', `JSON=${JSON.stringify(parte)}`, 15000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.mensagem);
                return;
            }
            const novaParte = pegaChave('#txtCodigo')
            $.LoadingOverlay("hide");
            toastr.success(
                `Cadastro da parte: ${novaParte} efetuado com sucesso!`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadparte`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } catch (error) {
            $.LoadingOverlay("hide");
            msgAlerta(`Não foi possível gravar os dados do parte.`);
        }
    });
});