/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    // $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show')) {
                        $('#multiCollapseExample1').collapse('show');
                    }
                } else if (Element.node.id == 'itens') {
                    if (!$('#multiCollapseExample2').hasClass('show')) {
                        $('#multiCollapseExample2').collapse('show');
                    }
                } else if (Element.node.id == 'aviamentos') {
                    if (!$('#multiCollapseExample3').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                    }
                } else if (Element.node.id == 'compras') {
                    if (!$('#multiCollapseExample4').hasClass('show')) {
                        $('#multiCollapseExample4').collapse('show');
                    }
                }
            },
            onPrevious: (Element) => {
                if (Element.node.id == "geral") {
                    if ($("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample1").collapse("show");
                    }
                } else if (Element.node.id == "itens") {
                    if ($("#itens>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "aviamentos") {
                    if ($("#aviamentos>a").hasClass("collapsed")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "compras") {
                    if ($("#compras>a").hasClass("collapsed")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                }
            }
        });

        driver.defineSteps([{
            element: '#geral',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados Gerais',
                description: 'Esses são os campos que você preencherá com os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#itens',
            popover: {
                title: 'Aba Cores',
                description: 'Clique aqui para abrir a aba cores/itens.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Cores',
                description: 'Aqui ficam as cores e preços das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnControleItens',
            popover: {
                title: 'Modal Controle de Itens',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#aviamentos',
            popover: {
                title: 'Aba Aviamentos',
                description: 'Clique aqui para abrir a aba aviamentos.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample3',
            popover: {
                title: 'Dados de Aviamentos',
                description: 'Aqui ficam os aviamentos e preços dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#compras',
            popover: {
                title: 'Aba Últimas Compras',
                description: 'Clique aqui para abrir a aba últimas compras.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample4',
            popover: {
                title: 'Últimas Compras',
                description: 'Aqui ficam as últimas compras do material.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: 'Botão Voltar',
                description: 'Ao clicar nesse botão você retorna para a tela de consulta.',
                position: "left",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});


$(document).ready(async function () {

    const queryString = window.location.href;
    const parametros = queryString.split('/');
    let codProd = parametros[parametros.length - 1];

    if (codProd != 'create') {
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);
    } else {
        $('.create').prop('disabled', true);
    }

    let inclusaoCI = false;
    let impostos = 0;
    let contrModalGravar;

    if (codProd == 'create') {
        contrModalGravar = 0;
    }

    const piscofins = await retornaPisCofins();

    const cus250_4 = await buscaParametroERP('CUS', '250', '4', '1');
    const cus280_32 = await buscaParametroERP('CUS', '280', '32', '1');
    const cus280_18 = await buscaParametroERP('CUS', '280', '18', '1');
    const cus280_10 = await buscaParametroERP('CUS', '280', '10', '1');
    const cus280_23 = await buscaParametroERP('CUS', '280', '23', '1');
    const cus280_21 = await buscaParametroERP('CUS', '280', '21', '1');
    const cus280_96 = await buscaParametroERP('CUS', '280', '96', '1');
    const cus280_5 = await buscaParametroERP('CUS', '280', '5', '1');

    $('#cbEsconderFoto').on('change', function () {
        if ($('#cbEsconderFoto').prop('checked') == true) {
            $('#divImagem').addClass('d-none');
            $('#infoGerais').addClass('col-12');
        } else {
            $('#divImagem').removeClass('d-none');
            $('#infoGerais').removeClass('col-12');
            $('#infoGerais').addClass('col-8');
        }
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                $("#imagemProd").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr;
            $("#imagemProd").attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $("#imagemProd").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    $('#txtCodigo').on('input', async function () {
        codProd = $('#txtCodigo').val();

        if ($('#txtCodigo').val() != '') {
            $('.create').prop('disabled', false);
            await buscaDadosCreate(codProd);
        } else {
            $('.create').prop('disabled', true);
            $('#txtDescricao').val('');
            $('input').val('');
            $('#btnGravar').val('Gravar');
        }
    });

    $('#txtCodigo').on('blur', async function () {

        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["CODIGO, TIPO"],
                "where": ["MAT_PRECO.CODIGO = '${codProd}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

        if (!response) {
            return;
        }

        const validaMatPreco = (await response.json()).RESULT[0];
        if (response.status != 200) {
            msgErro(validaMatPreco.mensagem);
            return;
        }

        if (validaMatPreco.length > 0) {
            msgAlerta('Código já cadastrado, deseja alterar os dados?', () => {
                $.LoadingOverlay('show');
                if (validaMatPreco[0].TIPO == 'P' || validaMatPreco[0].TIPO == '') {
                    window.location.href = `${BASE_URI}/cadprodpreco/${codProd}`;
                } else {
                    window.location.href = `${BASE_URI}/cadmatpreco/${codProd}`;
                }
                $.LoadingOverlay('hide');
            }, () => {
                $.LoadingOverlay('show');
                $('.create').prop('disabled', true);
                $('#txtCodigo').val('');
                $('#txtDescricao').val('');
                $('#txtUnidade').val('');
                $('#txtCodigo').focus();
                codProd = $('#txtCodigo').val();
                $.LoadingOverlay('hide');
            })
        } else {
            $('#txtFatorConversao').val('1');
        }
    });

    async function buscaDadosCreate(codigo) {

        let descricao = '';
        let unidade = '';
        let divisor = '';

        let response = null;
        response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"PRODUTO",
                "camposSelect":["DESCRICAO, UNIDADE, DIVISOR"],
                "where": ["PRODUTO.CODIGO = '${codigo}'"]}`, null);

        if (!response) {
            return;
        }

        const data = (await response.json()).RESULT[0];
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        if (data.length > 0) {
            descricao = data[0].DESCRICAO;
            unidade = data[0].UNIDADE;
            divisor = data[0].DIVISOR;
        }

        if (descricao != '' && descricao != undefined && descricao != null) {
            $.LoadingOverlay('show');
            $('#txtDescricao').val(descricao);
            $.LoadingOverlay('hide');
        } else {
            $('#txtDescricao').val('');
        }

        if (unidade != '' && unidade != undefined && unidade != null) {
            $.LoadingOverlay('show');
            $('#txtUnidade').val(unidade);
            $.LoadingOverlay('hide');
        } else {
            $('#txtUnidade').val('');
        }

        if (divisor != '' && divisor != undefined && divisor != null) {
            $.LoadingOverlay('show');
            $('#txtDivisor').val(divisor);
            $.LoadingOverlay('hide');
        } else {
            $('#txtDivisor').val('');
        }

    };

    async function retornaPisCofins() {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"EMPRESA",
                    "camposSelect":["EMPRESA.EMP_PIS, EMPRESA.EMP_COFINS"],
                    "where": ["EMPRESA.EMP_PAT = '${getCookie('empresa')}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        const piscofins = (100 - (jsonStr.RESULT[0][0].EMP_PIS + jsonStr.RESULT[0][0].EMP_COFINS)) / 100;

        return piscofins;
    };

    function retornaOpcoes(sChave, tabela) {

        let retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcoesOrdem" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' + sChave +
            '    </button> ' +
            '    <div class="dropdown-menu"> '
        if (tabela == 'tabelaControleItens') {
            retorno += '    <button class="dropdown-item" id="btn-alterar-ci">Alterar</button>' +
                '    <button class="dropdown-item" id="btn-excluir-ci">Excluir</button>'
        } else if (tabela == 'tabelaModalAviamentos') {
            retorno += '    <button class="dropdown-item" id="btn-alterar-avi">Alterar</button>' +
                '    <button class="dropdown-item" id="btn-excluir-avi">Excluir</button>'
        }

        retorno += '    </div>';

        return retorno;
    };

    function criaTabela(tabela, cols, opcoes = null) {

        tabela.DataTable({
            paging: true,
            lengthChange: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            columnDefs: [
                {
                    targets: cols,
                    visible: false,
                },
                {
                    targets: opcoes,
                    render: function (data) {
                        return retornaOpcoes(data, tabela[0].id);
                    }
                }
            ],
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
        });

    }

    function formataData(date) {

        if (!date) {
            return '30/12/1899';
        }

        let data = date.split('-');

        if ((data[0] == '' || data[0] == undefined) || (data[1] == '' || data[1] == undefined) || (data[2] == '' || data[2] == undefined)) {
            return '30/12/1899';
        }

        return `${data[2].substring(0, 2)}/${data[1]}/${data[0]}`;
    }

    async function buscaDados() {

        try {
            $.LoadingOverlay("show");
            try {
                const pesquisaProdPreco = {
                    camposSelect: ['CODIGO'],
                    tabela: 'MAT_PRECO',
                    where: [`CODIGO = '${codProd}' AND MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'`]
                };

                const validaProdPreco = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaProdPreco));

                if (validaProdPreco.length > 0) {
                    let jsonStr = await retornaInfoMatPreco();

                    if (jsonStr.RESULT[0][0].CODIGO_IMPRESSAO != '') {
                        const pesquisaGrupo = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'PRECO_GRUPO',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].CODIGO_IMPRESSAO}'`]
                        };

                        const nomeGrupo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaGrupo));
                        insereValor('#txtGrupo', jsonStr.RESULT[0][0].CODIGO_IMPRESSAO, nomeGrupo != '' ? nomeGrupo[0].DESCRICAO : '')
                    }

                    if (jsonStr.RESULT[0][0].SETOR != '') {
                        const pesquisaSetor = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'CADFLUXO',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].SETOR}'`]
                        };

                        const nomeSetor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaSetor));
                        insereValor('#txtSetor', jsonStr.RESULT[0][0].SETOR, nomeSetor != '' ? nomeSetor[0].DESCRICAO : '')
                    }

                    if (jsonStr.RESULT[0][0].PARTE != '') {
                        const pesquisaParte = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'TIPO_APL',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].PARTE}'`]
                        };

                        const nomeParte = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParte));
                        insereValor('#txtParte', jsonStr.RESULT[0][0].PARTE, nomeParte != '' ? nomeParte[0].DESCRICAO : '')
                    }

                    const data = jsonStr.RESULT[0][0].DT_ULT_ATUALIZACAO == null ? '' : jsonStr.RESULT[0][0].DT_ULT_ATUALIZACAO;

                    $('#cbProduzido').prop('checked', jsonStr.RESULT[0][0].PRODUZIDO == 'S' ? true : false);
                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val((jsonStr.RESULT[0][0].DESCRICAO).toUpperCase());
                    $('#txtUnidade').val(jsonStr.RESULT[0][0].UNIDADE);
                    $('#txtPrecoCompra').val(jsonStr.RESULT[0][0].PRECO_COMPRA);
                    $('#txtPreco1').val(jsonStr.RESULT[0][0].PRECO_1);
                    $('#txtPreco2').val(jsonStr.RESULT[0][0].PRECO_2);
                    $('#txtPreco3').val(jsonStr.RESULT[0][0].PRECO_3);
                    $('#txtCreditoIPI').val(jsonStr.RESULT[0][0].IPI);
                    $('#cbCreditoIPI').prop('checked', jsonStr.RESULT[0][0].CREDITA_IPI == 'S' ? true : false);
                    $('#txtCreditoICMS').val(jsonStr.RESULT[0][0].ICM);
                    $('#cbCreditoICMS').prop('checked', jsonStr.RESULT[0][0].CREDITA_ICMS == 'S' ? true : false);
                    $('#txtCreditoPIS').val(jsonStr.RESULT[0][0].PIS);
                    $('#cbCreditoPIS').prop('checked', jsonStr.RESULT[0][0].CREDITA_PIS == 'S' ? true : false);
                    $('#txtCreditoCOFINS').val(jsonStr.RESULT[0][0].COFINS);
                    $('#cbCreditoCOFINS').prop('checked', jsonStr.RESULT[0][0].CREDITA_COFINS == 'S' ? true : false);
                    $('#txtDespesasIPI').val(jsonStr.RESULT[0][0].PERC_IPI);
                    $('#txtFrete').val(jsonStr.RESULT[0][0].PERC_FRETE);
                    $('#txtValorFrete').val(jsonStr.RESULT[0][0].VLR_FRETE);
                    $('#txtFatorConversao').val(jsonStr.RESULT[0][0].DIVISOR == null ? 1 : jsonStr.RESULT[0][0].DIVISOR);
                    $('#txtAproveitamento').val(jsonStr.RESULT[0][0].APROVEITAMENTO);
                    $('#txtData').val(jsonStr.RESULT[0][0].DATA.substring(0, 10));
                    $('#txtPrecoAnterior').val(jsonStr.RESULT[0][0].PRECO_4);
                    $('#txtDataUltimaAtualizacao').val(data.substring(0, 10));
                    $('#txtLarguraMalha').val(jsonStr.RESULT[0][0].LARGURA);
                    $('#txtGramatura').val(jsonStr.RESULT[0][0].GRAMATURA);
                    $('#txtIndicePeso').val(jsonStr.RESULT[0][0].INDICE_PESO);
                    $('#txtMVA').val(jsonStr.RESULT[0][0].MVA);
                    $('#txtInfoCompl').val(jsonStr.RESULT[0][0].INF_COMPL);
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS);
                    $('#txtSTIcms').val(jsonStr.RESULT[0][0].ICMS_ST);

                    if (codProd != 'create') {
                        contrModalGravar = (retornaFloat(jsonStr.RESULT[0][0].APROVEITAMENTO) + retornaFloat(jsonStr.RESULT[0][0].PRECO_1) + retornaFloat(jsonStr.RESULT[0][0].PRECO_2) + retornaFloat(jsonStr.RESULT[0][0].PRECO_3));
                    }
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaInfoMatPreco() {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["MAT_PRECO.PRODUZIDO", "MAT_PRECO.CODIGO", "MAT_PRECO.DESCRICAO", "MAT_PRECO.UNIDADE", "MAT_PRECO.CODIGO_IMPRESSAO", "MAT_PRECO.SETOR",
                                 "MAT_PRECO.PARTE", "MAT_PRECO.PRECO_COMPRA", "MAT_PRECO.PRECO_1", "MAT_PRECO.PRECO_2", "MAT_PRECO.PRECO_3",
                                 "MAT_PRECO.PERC_IPI", "MAT_PRECO.CREDITA_IPI", "MAT_PRECO.ICM", "MAT_PRECO.CREDITA_ICMS", "MAT_PRECO.PIS",
                                 "MAT_PRECO.CREDITA_PIS", "MAT_PRECO.COFINS", "MAT_PRECO.CREDITA_COFINS", "MAT_PRECO.IPI", "MAT_PRECO.PERC_FRETE", "MAT_PRECO.VLR_FRETE",
                                 "PRODUTO.DIVISOR", "MAT_PRECO.APROVEITAMENTO", "MAT_PRECO.DATA", "MAT_PRECO.PRECO_4", "MAT_PRECO.DT_ULT_ATUALIZACAO", "MAT_PRECO.LARGURA",
                                 "MAT_PRECO.GRAMATURA", "MAT_PRECO.INDICE_PESO", "MAT_PRECO.MVA", "MAT_PRECO.INF_COMPL", "MAT_PRECO.OBS", "MAT_PRECO.ICMS_ST"],
                "leftjoin": [{"tabela": "PRODUTO", "condicao": "MAT_PRECO.CODIGO = PRODUTO.CODIGO"}],
                "where": ["MAT_PRECO.CODIGO = '${codProd}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        return jsonStr;
    }

    async function buscaPrecoCores() {

        try {
            $.LoadingOverlay('show');
            try {
                const response = await requisicao("GET", `/sisplan/cadprodpreco/v1/buscaprecocores?`, `CODIGO=${codProd}`);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                if (jsonStr.length > 0) {
                    if (cus250_4 == 'S') {
                        contrModalGravar = 0;
                    }

                    jsonStr.map(e => {
                        contrModalGravar += retornaFloat(e.PRECO);
                    });

                    preencheDadosTabelaCores(jsonStr);
                }


            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    function preencheDadosTabelaCores(data) {

        for (let i = 0; i < data.length; i++) {
            let preco_ting = 0;
            let preco_compra = 0;
            let perc_desp = 0;
            let preco = 0;

            if (data[i].PRECO_TING !== '' && data[i].PRECO_TING != null && data[i].PRECO_TING != undefined) {
                preco_ting = data[i].PRECO_TING;
            }

            if (data[i].PRECO_COMPRA !== '' && data[i].PRECO_COMPRA != null && data[i].PRECO_COMPRA != undefined) {
                preco_compra = data[i].PRECO_COMPRA;
            }

            if (data[i].PERC_DESP !== '' && data[i].PERC_DESP != null && data[i].PERC_DESP != undefined) {
                perc_desp = data[i].PERC_DESP;
            }

            if (data[i].PRECO !== '' && data[i].PRECO != null && data[i].PRECO != undefined) {
                preco = data[i].PRECO;
            }

            $('#tabelaCores').DataTable().row.add([
                data[i].ID,
                data[i].ATIVO,
                data[i].COR,
                data[i].DESCRICAO,
                parseFloat(preco_ting).toFixed(6) == 'NaN' ? preco_ting : parseFloat(preco_ting).toFixed(6),
                parseFloat(preco_compra).toFixed(6) == 'NaN' ? preco_compra : parseFloat(preco_compra).toFixed(6),
                parseFloat(perc_desp).toFixed(6) == 'NaN' ? perc_desp : parseFloat(perc_desp).toFixed(6),
                parseFloat(preco).toFixed(6) == 'NaN' ? preco : parseFloat(preco).toFixed(6),
                data[i].PANTONE,
                data[i].TINTURARIA,
                data[i].NOME,
                data[i].CODIGO2,
                data[i].GRUPO,
                data[i].DESC_GRUPO
            ]).draw(false);

        }

    }

    async function buscaPrecoAviamentos() {

        try {
            $.LoadingOverlay('show');
            try {

                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_PRECO_ITEN",
                "camposSelect":["DISTINCT MAT_PRECO_ITEN.ORDEM", "MAT_PRECO_ITEN.CODIGO", "MAT_PRECO_ITEN.MATERIAL", "MAT_PRECO_ITEN.CUSTO", "MAT_PRECO_ITEN.QUANTIDADE",
                "MAT_PRECO_ITEN.VALOR", "MAT_PRECO_ITEN.ACUMULADO", "MAT_PRECO_ITEN.UNIDADE",
                "(SELECT MAX(MAT_PRECO.DT_ULT_ATUALIZACAO) FROM [MAT_PRECO] MAT_PRECO WHERE MAT_PRECO.CODIGO = MAT_PRECO_ITEN.CODIGO) DT_ULT_ATUALIZACAO", "MAT_PRECO_ITEN.QUEBRA"],
                "where": [
                    "MAT_PRECO_ITEN.ARTIGO = '${codProd}'",
                    "MAT_PRECO_ITEN.TAM = '0'",
                    "(MAT_PRECO_ITEN.MARKUP IS NULL OR MAT_PRECO_ITEN.MARKUP = '')",
                    "MAT_PRECO_ITEN.CODCLI IS NOT NULL"
                ],
                "orderby": ["MAT_PRECO_ITEN.ORDEM"]}`
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const data = jsonStr.RESULT[0];

                preencheTabelasAviamentos(data, $('#tabelaAviamentos'));

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    function preencheTabelasAviamentos(data, tabela) {

        for (let i = 0; i < data.length; i++) {

            let custo = (data[i].CUSTO);
            if (typeof custo == 'string') {
                custo = custo.replace(',', '.');
            }
            const custoFormatado = parseFloat(custo).toFixed(6) == 'NaN' ? custo : parseFloat(custo).toFixed(6);

            let acumulado = (data[i].ACUMULADO);
            if (typeof acumulado == 'string') {
                acumulado = acumulado.replace(',', '.');
            }
            const acumuladoFormatado = parseFloat(acumulado).toFixed(6) == 'NaN' ? custo : parseFloat(acumulado).toFixed(6);

            if (tabela[0].id == 'tabelaAviamentos') {
                $('#tabelaAviamentos').DataTable().row.add([
                    data[i].ORDEM,
                    data[i].CODIGO,
                    data[i].MATERIAL,
                    custoFormatado,
                    data[i].QUANTIDADE,
                    calculaValorComQuebra(data[i].QUANTIDADE, data[i].CUSTO, data[i].QUEBRA),
                    acumuladoFormatado,
                    data[i].UNIDADE,
                    formataData(data[i].DT_ULT_ATUALIZACAO),
                    data[i].QUEBRA,
                ]).draw(false);
            } else {
                $('#tabelaModalAviamentos').DataTable().row.add([
                    data[i].ORDEM,
                    data[i].CODIGO,
                    data[i].MATERIAL,
                    data[i].UNIDADE,
                    data[i].QUANTIDADE,
                    custoFormatado,
                    data[i].QUEBRA,
                    calculaValorComQuebra(data[i].QUANTIDADE, data[i].CUSTO, data[i].QUEBRA),
                    acumuladoFormatado,
                    formataData(data[i].DT_ULT_ATUALIZACAO),
                ]).draw(false);
            }
        }
    };

    $('#cbCreditoIPI').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#cbCreditoICMS').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#cbCreditoPIS').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#cbCreditoCOFINS').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtPrecoCompra').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoIPI').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoICMS').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoPIS').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoCOFINS').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtDespesasIPI').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtFrete').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtValorFrete').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtAproveitamento').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtMVA').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtSTIcms').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    function calculaPrecoComDesconto(precoCompra, descontaIPI, descontaICMS, descontaPIS, descontaCOFINS) {
        try {

            precoCompra = retornaFloat(precoCompra);

            if (precoCompra > 0) {

                let preco = precoCompra;

                preco = retornaFloat(preco);

                let aproveitamento = retornaFloat($('#txtAproveitamento').val())

                if (cus280_23 == 'S' && aproveitamento != 0) {
                    preco = preco / (aproveitamento / 100);
                };

                if (descontaIPI) {

                    let ipi = retornaFloat($('#txtCreditoIPI').val());

                    preco -= precoCompra * (ipi / 100);
                };

                if (descontaICMS) {

                    let icms = retornaFloat($('#txtCreditoICMS').val());

                    preco -= precoCompra * (icms / 100);
                };

                if (descontaPIS) {

                    let pis = retornaFloat($('#txtCreditoPIS').val());

                    preco -= precoCompra * (pis / 100);
                };

                if (descontaCOFINS) {

                    let cofins = retornaFloat($('#txtCreditoCOFINS').val());

                    preco -= precoCompra * (cofins / 100);
                };

                let percFrete = retornaFloat($('#txtFrete').val());

                let valorFrete = retornaFloat($('#txtValorFrete').val());

                let despesasIPI = retornaFloat($('#txtDespesasIPI').val());

                let mva = retornaFloat($('#txtMVA').val());

                let stIcms = retornaFloat($('#txtSTIcms').val());

                preco += (precoCompra * (percFrete / 100)) + valorFrete;

                preco += precoCompra * (despesasIPI / 100);

                preco += precoCompra * (mva / 100);

                preco += precoCompra * (stIcms / 100);

                if (cus280_23 == 'D' && aproveitamento != 0) {
                    preco = preco / (aproveitamento / 100);
                };

                impostos = preco / precoCompra;

                if (precoCompra == 1000) {
                    precoCompra = 0;
                    preco = 0;
                };

                let divisor = $('#txtFatorConversao').val();

                if (divisor == '') {
                    divisor = 1;
                };

                if (typeof divisor == 'string') {
                    divisor = divisor.replace(',', '.');
                };

                divisor = parseFloat(divisor);

                if (cus280_21 == 'S' && divisor != 0) {
                    preco = preco / divisor;
                };

                $('#txtPrecoCompra').val(precoCompra);
                $('#txtPreco1').val((preco).toFixed(6));

                if (retornaFloat($('#txtPreco2').val()) == 0) {
                    $('#txtPreco2').val((preco).toFixed(6));
                }
                if (retornaFloat($('#txtPreco3').val()) == 0) {
                    $('#txtPreco3').val((preco).toFixed(6));
                }
            }

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }
    };

    function retornaFloat(valor) {
        if (valor == '') {
            valor = 0;
        };

        if (typeof valor == 'string') {
            valor = valor.replace(',', '.');
        };

        valor = parseFloat(valor);

        return valor;
    }

    $('#btnGravar').on('click', async function () {

        msgAlerta('Deseja gravar os dados?', async () => {
            await gravaDados();
        });
    });

    $('#btnGravar').on('click', async function () {

        if ($('#txtCodigo').val() == '') {
            msgErro('Campo código deve ser preenchido, favor verificar.', () => {
                $('#txtGrupo').focus();
            });
            $('#txtCodigo').focus();
            return;
        }

        if ($('#txtDescricao').val() == '') {
            msgErro('Campo descrição deve ser preenchido, favor verificar.', () => {
                $('#txtGrupo').focus();
            });
            $('#txtDescricao').focus();
            return;
        }

        if ($('#txtGrupo').val() == '') {
            msgErro('Campo grupo deve ser preenchido, favor verificar.', () => {
                $('#txtGrupo').focus();
            });
            return;
        }

        msgAlerta('Deseja gravar os dados?', async () => {
            await gravaDados();
        });
    });

    async function retornaDataGravar() {

        let data = $('#txtDataUltimaAtualizacao').val();

        const resposta = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
        "camposSelect":["MAT_PRECO.CODIGO"],
        "where": ["MAT_PRECO.CODIGO = '${codProd}'"]}`, null);

        if (!resposta) {
            return;
        }

        let validaExisCod = (await resposta.json()).RESULT[0];
        if (resposta.status != 200) {
            msgErro(validaExisCod.mensagem);
            return;
        }

        if (validaExisCod.length > 0 && cus280_5 == 'S') {
            data = new Date().toJSON().slice(0, 10);
            return data;
        }

        preco = retornaFloat($('#txtPreco1').val());

        const preco_ant = await retornaPrecoAnt();

        if (preco != preco_ant) {
            data = new Date().toJSON().slice(0, 10);
            return data;
        }

        if (data == '') {
            data = new Date().toJSON().slice(0, 10);
        }

        return data;

    }

    async function retornaPrecoAnt() {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
        "camposSelect":["MAT_PRECO.PRECO_1"],
        "where": ["MAT_PRECO.CODIGO = '${codProd}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = (await response.json()).RESULT[0];
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        let preco_ant = 0;

        if (jsonStr.length > 0) {
            preco_ant = jsonStr[0].PRECO_1;
        }

        return retornaFloat(preco_ant);

    }

    async function gravaDados() {
        try {
            $.LoadingOverlay('show');
            try {

                let contrPreco;

                const dt_atualizacao = await retornaDataGravar();

                const preco_ant = await retornaPrecoAnt();

                const obs = preco_ant != retornaFloat($('#txtPreco1').val()) ?
                    `PRODUTO ATUALIZADO EM ${dt_atualizacao} PELO USUÁRIO ${getCookie('usuario')}` :
                    $('#txtObs').val();

                let produto = {};

                produto.APROVEITAMENTO = $('#txtAproveitamento').val() == '' ? '100' : $('#txtAproveitamento').val();
                produto.CODIGO = $('#txtCodigo').val();
                produto.CODIGO_IMPRESSAO = pegaChave('#txtGrupo');
                produto.DATA = $('#txtData').val() == '' ? new Date().toJSON().slice(0, 10) : $('#txtData').val();
                produto.DESCRICAO = $('#txtDescricao').val();
                produto.ICM = $('#txtCreditoICMS').val() == '' ? 0 : $('#txtCreditoICMS').val();
                produto.OBS = obs;
                produto.PRECO_1 = $('#txtPreco1').val() == '' ? 0 : $('#txtPreco1').val();
                produto.PRECO_2 = $('#txtPreco2').val() == '' ? 0 : $('#txtPreco2').val();
                produto.UNIDADE = $('#txtUnidade').val();
                produto.GRAMATURA = $('#txtGramatura').val();
                produto.INDICE_PESO = $('#txtIndicePeso').val();
                produto.LARGURA = $('#txtLarguraMalha').val();
                produto.SETOR = pegaChave('#txtSetor');
                produto.INF_COMPL = $('#txtInfoCompl').val();
                produto.COFINS = $('#txtCreditoCOFINS').val() == '' ? 0 : $('#txtCreditoCOFINS').val();
                produto.PIS = $('#txtCreditoPIS').val() == '' ? 0 : $('#txtCreditoPIS').val();
                produto.PRECO_COMPRA = $('#txtPrecoCompra').val() == '' ? 0 : $('#txtPrecoCompra').val();
                produto.IPI = $('#txtCreditoIPI').val() == '' ? 0 : $('#txtCreditoIPI').val();
                produto.PERC_FRETE = $('#txtFrete').val() == '' ? 0 : $('#txtFrete').val();
                produto.VLR_FRETE = $('#txtValorFrete').val() == '' ? 0 : $('#txtValorFrete').val();
                produto.DT_ULT_ATUALIZACAO = dt_atualizacao;
                produto.PARTE = pegaChave('#txtParte');
                produto.PRECO_3 = $('#txtPreco3').val() == '' ? 0 : $('#txtPreco3').val();
                produto.PRECO_4 = preco_ant;
                produto.PERC_IPI = $('#txtDespesasIPI').val() == '' ? 0 : $('#txtDespesasIPI').val();
                produto.TIPO = 'P';
                produto.PRODUZIDO = $('#cbProduzido').prop('checked') == true ? 'S' : 'N';
                produto.CREDITA_COFINS = $('#cbCreditoCOFINS').prop('checked') == true ? 'S' : 'N';
                produto.CREDITA_ICMS = $('#cbCreditoICMS').prop('checked') == true ? 'S' : 'N';
                produto.CREDITA_IPI = $('#cbCreditoIPI').prop('checked') == true ? 'S' : 'N';
                produto.CREDITA_PIS = $('#cbCreditoPIS').prop('checked') == true ? 'S' : 'N';
                produto.EMP_ID = getCookie('emp_id');
                produto.MVA = $('#txtMVA').val() == '' ? 0 : $('#txtMVA').val();
                produto.ICMS_ST = $('#txtSTIcms').val() == '' ? 0 : $('#txtSTIcms').val();

                let dadosCores = retornaCoresGravar();

                produto.PRECOCORESPROD = dadosCores;

                const response = await requisicao("POST", `/sisplan/cadprodpreco/v1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(produto))}`);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                if (cus250_4 == 'S') {
                    contrPreco = 0;
                    dadosCores.map(e => {
                        contrPreco += retornaFloat(e.PRECO);
                    });

                    if (retornaFloat(contrModalGravar) != retornaFloat(contrPreco)) {

                        const validaMPI = await buscaValor('MAT_PRECO_ITEN', 'CODIGO', 'CODIGO', codProd);
                        const validaPI = await buscaValor('PRECO_ITEN', 'CODIGO', 'CODIGO', codProd);

                        if (validaMPI != undefined) {
                            await buscaMalhasProd();
                            return;
                        } else if (validaPI != undefined) {
                            await buscaArtigosProd();
                            return;
                        }
                    }

                } else {
                    if ((retornaFloat($('#txtAproveitamento').val()) + retornaFloat($('#txtPreco1').val()) + retornaFloat($('#txtPreco2').val()) + retornaFloat($('#txtPreco3').val())) != 0) {

                        const validaMPI = await buscaValor('MAT_PRECO_ITEN', 'CODIGO', 'CODIGO', codProd);
                        const validaPI = await buscaValor('PRECO_ITEN', 'CODIGO', 'CODIGO', codProd);

                        if (validaMPI != undefined) {
                            await buscaMalhasProd();;
                            return;
                        } else if (validaPI != undefined) {
                            await buscaArtigosProd();
                            return;
                        }
                    }
                }

                toastr.success("Dados gravados com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadprodpreco`;
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    function retornaCoresGravar() {

        const dados = $('#tabelaCores').DataTable().data();

        let json = [];

        let preco_compra = 0;

        dados.map(element => {
            preco_compra = element[5];

            if (dados.length == 1 && cus280_96 == 'S') {
                preco_compra = $('#txtPrecoCompra').val();
            }

            json.push({
                ID: element[0],
                ATIVO: element[1],
                COR: element[2],
                PRECO_TING: element[4],
                PRECO_COMPRA: preco_compra,
                PERC_DESP: element[6],
                PRECO: element[7],
                CODIGO: $('#txtCodigo').val(),
                EMP_ID: getCookie('emp_id')
            })
        })

        return json;
    };

    try {
        $.LoadingOverlay('show');

        if (codProd != 'create') {
            await buscaDados();
            await buscaPrecoCores();
            await buscaPrecoAviamentos();
        }
        criaTabela($('#tabelaCores'), [12, 13]);
        criaTabela($('#tabelaAviamentos'), null);
        await buscaFoto(codProd);
    } finally {
        $.LoadingOverlay('hide');
    }

    function criaTabelaComCheckbox(tabela, coluna, data, inv = null) {

        $('#tabelaControleItens').DataTable().rows().remove().draw(false);

        const dataCols = [{
            'title': 'SEL',
            'data': 'SEL',
            'width': '15px'
        },
        {
            'data': 'ARTIGO'
        },
        {
            'data': 'DESCRICAO'
        },
        {
            'data': 'COLECAO'
        },
        {
            'data': 'DESC_COLECAO'
        }];

        dataCols[coluna].render = function (data, type, row, meta) {
            return `<div class="icheck-secondary d-inline">` +
                `<input type="checkbox" class="campoSel" id="check_${meta.row}">` +
                `<label for="check_${meta.row}"></label>` +
                `</div>`
        };

        tabela.DataTable({
            paging: true,
            lengthChange: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            columns: dataCols,
            data: data,
            columnDefs: [{
                targets: inv,
                visible: false
            }],
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
        });
    }

    async function buscaMalhasProd() {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela": "MAT_PRECO_ITEN",
                "camposSelect":["MAT_PRECO_ITEN.ARTIGO, MAT_PRECO.DESCRICAO, '' AS COLECAO, '' AS DESC_COLECAO"],
                "innerjoin": [
                    {"tabela": "MAT_PRECO", "condicao": "MAT_PRECO_ITEN.ARTIGO = MAT_PRECO.CODIGO"}
                ],
                "where": ["MAT_PRECO_ITEN.CODIGO = '${codProd}'"]}`, null);

            if (!response) {
                return;
            }

            let jsonStr = (await response.json()).RESULT[0];
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            $('#tituloMalhasProd').html(`[${codProd}] - ${$('#txtDescricao').val()}`);

            $('#modalMalhasProd').modal('show');

            $('#colecaoMalhasProd').addClass('d-none');

            criaTabelaComCheckbox($('#tabelaMalhasProd'), 0, jsonStr, [3, 4]);
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    async function buscaArtigosProd() {
        try {
            const response = await requisicao("GET", `/sisplan/cadprodpreco/v1/artigosprod?`, `CODIGO=${codProd}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tituloMalhasProd').html(`[${codProd}] - ${$('#txtDescricao').val()}`);

            $('#modalMalhasProd').modal('show');

            $('#colecaoMalhasProd').removeClass('d-none');
            

            criaTabelaComCheckbox($('#tabelaMalhasProd'), 0, jsonStr);
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    $('#btnGravarMalhasProd').on('click', async function () {
        const data = $('#tabelaMalhasProd').DataTable().data();

        let listaItens = [];

        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                if ($(`#check_${i}`).prop('checked')) {
                    listaItens.push({
                        CODIGO: data[i].ARTIGO
                    })
                }

            }
        }

        if (listaItens.length == 0) {
            $('#modalMalhasProd').modal('hide');
        } else {
            const validaPI = await buscaValor('PRECO_ITEN', 'CODIGO', 'CODIGO', codProd);

            if ($('#colecaoMalhasProd').hasClass('d-none')) {
                await gravaMalhasProd(listaItens);
                await buscaArtigosProd();
            } else if (validaPI != undefined) {
                await gravaArtigosProd(listaItens);
            }
        }

    });

    async function gravaMalhasProd(itens) {
        try {
            $.LoadingOverlay('show');
            try {

                if (itens.length > 0) {

                    let obj = {};

                    obj.PRECO = retornaFloat($('#txtPreco1').val());
                    obj.MALHAS = itens;

                    const response = await requisicao("POST", `/sisplan/cadprodpreco/v1/gravaprodmalhas?`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }
                } 3

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravaArtigosProd(itens) {
        try {
            $.LoadingOverlay('show');
            try {

                if (itens.length > 0) {

                    let obj = {};

                    obj.CODIGO = codProd;
                    obj.PRECO = retornaFloat($('#txtPreco1').val());
                    obj.ARTIGOS = itens;

                    const response = await requisicao("POST", `/sisplan/cadprodpreco/v1/artigosprod?`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

                    if (!response) {
                        return;
                    }

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }
                }

                $('#modalMalhasProd').modal('hide');

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#modalMalhasProd').on('hide.bs.modal', function () {

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                $('#modalMalhasProd').modal('hide');
                window.location.href = `${BASE_URI}/cadprodpreco`;
            },
        }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
    });

    function filtraItensMalhasProd() {

        try {
            $.LoadingOverlay('show');

            try {

                const colecao = pegaChave('#txtColecaoMalhasProd');
                $('#tabelaMalhasProd').DataTable().columns(3).search(colecao).draw(false);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#txtColecaoMalhasProd').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

    $('#btnColecaoMalhasProd').pesquisa('#txtColecaoMalhasProd', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Coleção', '');

    $('#btnAColecaoMalhasProd').on('click', function () {
        $('#txtColecaoMalhasProd').val('');
    });

    $('#btnConsultarMalhasProd').on('click', function () {
        filtraItensMalhasProd();
    });

    $('#btnFecharMalhasProd').on('click', function () {
        $('#modalMalhasProd').modal('hide');
    })

    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"PRECO_GRUPO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtParte').autocompleta(1, `JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

    $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRECO_GRUPO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo', '');
    $('#btnSetor').pesquisa('#txtSetor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Setor', '');
    $('#btnParte').pesquisa('#txtParte', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Parte', '');

    $('#btnAGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });
    $('#btnASetor').on('click', function () {
        $('#txtSetor').val('');
    });
    $('#btnAParte').on('click', function () {
        $('#txtParte').val('');
    });

    function preencheDadosTabelaConIt(data) {
        $('#tabelaControleItens').DataTable().rows().remove().draw(false);
        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                $('#tabelaControleItens').DataTable().row.add([
                    data[i].ID,
                    data[i].ATIVO,
                    data[i].COR,
                    data[i].DESCRICAO,
                    parseFloat(data[i].PRECO_TING).toFixed(6) == 'NaN' ? data[i].PRECO_TING : parseFloat(data[i].PRECO_TING).toFixed(6),
                    parseFloat(data[i].PRECO_COMPRA).toFixed(6) == 'NaN' ? data[i].PRECO_COMPRA : parseFloat(data[i].PRECO_COMPRA).toFixed(6),
                    parseFloat(data[i].PERC_DESP).toFixed(6) == 'NaN' ? data[i].PERC_DESP : parseFloat(data[i].PERC_DESP).toFixed(6),
                    parseFloat(data[i].PRECO).toFixed(6) == 'NaN' ? data[i].PRECO : parseFloat(data[i].PRECO).toFixed(6),
                    data[i].PANTONE,
                    data[i].TINTURARIA,
                    data[i].NOME,
                    data[i].CODIGO2,
                    data[i].GRUPO,
                    data[i].DESC_GRUPO
                ]).draw(false);
            }
        }
    };

    $('#btnControleItens').on('click', async function () {

        try {

            $.LoadingOverlay('show');

            $('#modalControleItens').modal('show');

            $('#tituloControleItens').html(`[${codProd}] - ${$('#txtDescricao').val()}`);

            criaTabela($('#tabelaControleItens'), [9, 10, 11], [2]);
            const dados = $('#tabelaCores').DataTable().data();

            json = [];

            for (let i = 0; i < dados.length; i++) {

                json.push(
                    {
                        ID: dados[i][0],
                        ATIVO: dados[i][1],
                        COR: dados[i][2],
                        DESCRICAO: dados[i][3],
                        PRECO_TING: dados[i][4],
                        PRECO_COMPRA: dados[i][5],
                        PERC_DESP: dados[i][6],
                        PRECO: dados[i][7],
                        PANTONE: dados[i][8],
                        TINTURARIA: dados[i][9],
                        NOME: dados[i][10],
                        CODIGO2: dados[i][11],
                        GRUPO: dados[i][12],
                        DESC_GRUPO: dados[i][13]
                    })
            }

            $('#txtUtilizaFatConv').val($('#txtFatorConversao').val());

            preencheDadosTabelaConIt(json);

        } finally {
            $.LoadingOverlay('hide');
        }

    });

    $('#btnConsultarCI').on('click', async function () {
        filtraItensPorGrupo();
    });

    $('#tabelaControleItens').on('click', '#btn-alterar-ci', async function () {
        if ($('#tabelaControleItens').DataTable().data().length > 0) {
            habAlteracaoControleItens($("#tabelaControleItens").DataTable().row($(this).parents('tr')).data());
            $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
            $('.bodyModal').scrollTop(0);
        }
    });

    $('#tabelaControleItens').on('click', '#btn-excluir-ci', async function () {
        const linha = $('#tabelaControleItens').DataTable().$($(this).parents('tr'))[0]._DT_RowIndex;
        const data = $('#tabelaControleItens').DataTable().data();
        excluiLinhaControleItens(linha, data);
    });

    $('#btnDesistirCI').on('click', function () {
        desabAlteracaoControleItens();
    });

    $('#cbUtilizaFatConv').on('change', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        )

        $('#txtPrecoCI').val(preco);
    });

    function habAlteracaoControleItens(linha) {
        if (inclusaoCI) {
            $('#cbAtivoCI').prop('checked', true);
            $('#precosTodosCI').addClass('d-none');
            $('#precosCI').removeClass('d-none');
            $('#btnIncluirCI').addClass('d-none');
            $('#btnExcluirCI').prop('disabled', false);
            $('#btnDesistirCI').removeClass('d-none');
            $('#btnConsultarCI').addClass('d-none');
            $('#grupoCI').addClass('d-none');
            $('#btnExcluirCI').addClass('d-none');
            $('#btnConfirmarCI').removeClass('d-none');
            $('#tabelaControleItens').prop('disabled', true);
            $('#txtCorCI').prop('disabled', false);
            $('#btnCorCI').prop('disabled', false);
        } else {
            $('#cbAtivoCI').prop('checked', linha[1] == 'S' ? true : false);
            $('#txtIdCI').val(linha[0]);
            insereValor('#txtCorCI', linha[2], linha[3]);
            $('#txtPantoneCI').val(linha[8]);
            $('#precosTodosCI').addClass('d-none');
            $('#precosCI').removeClass('d-none');
            $('#txtPrecoTingimentoCI').val(linha[4]);
            $('#txtPrecoCompraCI').val(linha[5]);
            $('#txtPrecoCI').val(linha[7]);
            $('#txtPercDespCI').val(linha[6]);
            $('#btnIncluirCI').addClass('d-none');
            $('#btnExcluirCI').prop('disabled', false);
            $('#btnDesistirCI').removeClass('d-none');
            $('#btnConsultarCI').addClass('d-none');
            $('#grupoCI').addClass('d-none');
            $('#btnConfirmarCI').removeClass('d-none');
        }
        $('#cbUtilizaFatConv').prop('disabled', false);
        $('#btnGravarControleItens').addClass('d-none');
    };

    function desabAlteracaoControleItens() {
        $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
        $('#cbAtivoCI').prop('checked', false);
        $('#txtIdCI').val('');
        $('#txtCorCI').val('');
        $('#txtPrecoTingimentoCI').val('');
        $('#txtPrecoCompraCI').val('');
        $('#txtPercDespCI').val('');
        $('#txtPrecoCI').val('');
        $('#txtPantoneCI').val('');
        $('#precosTodosCI').removeClass('d-none');
        $('#precosCI').addClass('d-none');
        $('#btnIncluirCI').removeClass('d-none');
        $('#btnExcluirCI').prop('disabled', true);
        $('#btnDesistirCI').addClass('d-none');
        $('#btnConsultarCI').removeClass('d-none');
        $('#grupoCI').removeClass('d-none');
        $('#txtPrecoTingimentoTodosCI').val('');
        $('#txtPrecoCompraTodosCI').val('');
        $('#txtPrecoTodosCI').val('');
        $('#txtPercDesperdicioTodosCI').val('');
        if (inclusaoCI) {
            $('#tabelaControleItens').prop('disabled', false)
            $('#btnExcluirCI').removeClass('d-none');
            $('#txtCorCI').prop('disabled', true);
            $('#btnCorCI').prop('disabled', true);
            $('#txtIdCI').prop('placeholder', 'ID');
            inclusaoCI = false;
        }
        $('#btnConfirmarCI').addClass('d-none');
        $('#cbUtilizaFatConv').prop('disabled', true);
        $('#btnGravarControleItens').removeClass('d-none');
        $('#btnPesquisaPrecoTinCI').prop('disabled', true);
    };

    $('#btnIncluirCI').on('click', function () {
        inclusaoCI = true;
        habAlteracaoControleItens(null);
    });

    $('#btnPrecoTingimentoTodosCI').on('click', function () {
        atualizaPrecoTodosCI(4, pegaChave('#txtGrupoCI'));
    });

    $('#btnPrecoCompraTodosCI').on('click', function () {
        atualizaPrecoTodosCI(5, pegaChave('#txtGrupoCI'));
    });

    $('#btnPrecoTodosCI').on('click', function () {
        atualizaPrecoTodosCI(7, pegaChave('#txtGrupoCI'));
    });

    $('#btnPercDesperdicioTodosCI').on('click', function () {
        atualizaPrecoTodosCI(6, pegaChave('#txtGrupoCI'));
    });

    function atualizaPrecoTodosCI(coluna, grupo) {

        try {
            $.LoadingOverlay('show');

            try {
                if (coluna == undefined) {
                    return;
                }
                let valorCampo = '';
                let preco = 0;

                if (coluna == 4) {
                    valorCampo = $('#txtPrecoTingimentoTodosCI').val()
                } else if (coluna == 5) {
                    valorCampo = $('#txtPrecoCompraTodosCI').val();
                } else if (coluna == 7) {
                    valorCampo = $('#txtPrecoTodosCI').val();
                } else if (coluna == 6) {
                    valorCampo = $('#txtPercDesperdicioTodosCI').val();
                } else {
                    return;
                }


                if (valorCampo == '') {
                    valorCampo = '0';
                }

                valorCampo = valorCampo.replace(',', '.');

                const data = $('#tabelaControleItens').DataTable().data();
                data.rows().remove();

                if (grupo != '' && grupo != undefined && grupo != null) {
                    for (let i = 0; i < data.length; i++) {

                        data[i][coluna] = parseFloat(valorCampo);

                        if (data[i][12] == grupo) {
                            if (coluna != 7) {
                                preco = calculaPrecoControleItens(
                                    data[i][4],
                                    data[i][5],
                                    data[i][6],
                                    0,
                                    'N');
                            } else {
                                preco = parseFloat(valorCampo).toFixed(6) == 'NaN' ? parseFloat(valorCampo) : parseFloat(valorCampo).toFixed(6);
                            }

                        }

                        $('#tabelaControleItens').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            parseFloat(data[i][4]).toFixed(6) == 'NaN' ? data[i][4] : parseFloat(data[i][4]).toFixed(6),
                            parseFloat(data[i][5]).toFixed(6) == 'NaN' ? data[i][5] : parseFloat(data[i][5]).toFixed(6),
                            parseFloat(data[i][6]).toFixed(6) == 'NaN' ? data[i][6] : parseFloat(data[i][6]).toFixed(6),
                            preco,
                            data[i][8],
                            data[i][9],
                            data[i][10],
                            data[i][11],
                            data[i][12],
                            data[i][13]
                        ]).draw(false);
                    }
                } else {
                    for (let i = 0; i < data.length; i++) {

                        data[i][coluna] = parseFloat(valorCampo);

                        if (coluna != 7) {
                            preco = calculaPrecoControleItens(
                                data[i][4],
                                data[i][5],
                                data[i][6],
                                0,
                                'N');
                        } else {
                            preco = parseFloat(valorCampo).toFixed(6) == 'NaN' ? parseFloat(valorCampo) : parseFloat(valorCampo).toFixed(6);
                        }

                        $('#tabelaControleItens').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            parseFloat(data[i][4]).toFixed(6) == 'NaN' ? data[i][4] : parseFloat(data[i][4]).toFixed(6),
                            parseFloat(data[i][5]).toFixed(6) == 'NaN' ? data[i][5] : parseFloat(data[i][5]).toFixed(6),
                            parseFloat(data[i][6]).toFixed(6) == 'NaN' ? data[i][6] : parseFloat(data[i][6]).toFixed(6),
                            preco,
                            data[i][8],
                            data[i][9],
                            data[i][10],
                            data[i][11],
                            data[i][12],
                            data[i][13]
                        ]).draw(false);
                    }
                }
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    $('#btnConfirmarCI').on('click', async function () {

        let linha = null;

        if (!inclusaoCI) {
            linha = $('#tabelaControleItens').DataTable().$('tr.selected')[0]._DT_RowIndex;
        }
        const data = $('#tabelaControleItens').DataTable().data();

        if ($('#txtCorCI').val() == '') {
            msgErro('É necessário informar uma cor, favor verificar.');
            return;
        }

        let corExistente = false;
        const corInclusa = pegaChave('#txtCorCI');

        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                if (data[i][2] == corInclusa) {
                    corExistente = true;
                }
            }
        }

        if (corExistente && inclusaoCI) {
            msgErro('Cor já Informada para o material, favor verificar.');
            return;
        }

        await confirmaAltControleItens(data, linha)
        desabAlteracaoControleItens();

    });

    $('#txtPrecoTingimentoCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    $('#txtPrecoCompraCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    $('#txtPercDespCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    function calculaPrecoControleItens(precoTin, precoCom, percDesp, divisor, calculaDivisor) {

        try {

            if (divisor < 0.000001) {
                divisor = 1;
            };

            if (precoTin == '') {
                precoTin = 0;
            }

            if (typeof precoTin == 'string') {
                precoTin = precoTin.replace(',', '.');
            }

            precoTin = parseFloat(precoTin);

            if (precoCom == '') {
                precoCom = 0;
            }

            if (typeof precoCom == 'string') {
                precoCom = precoCom.replace(',', '.');
            }

            precoCom = parseFloat(precoCom);

            if (percDesp == '') {
                percDesp = 0;
            }

            if (typeof percDesp == 'string') {
                percDesp = percDesp.replace(',', '.');
            }

            percDesp = parseFloat(percDesp);

            let preco = precoCom + precoTin;

            if (cus280_32 == 'S') {
                preco = precoCom + (precoTin * piscofins);
            }

            if (cus280_18 == 'S') {
                preco = preco * impostos;
            }

            if (preco > 0) {
                if (calculaDivisor) {
                    preco = preco / divisor;
                }

                if (cus280_10 == 'S') {
                    preco = preco / ((100 - percDesp) / 100);
                } else {
                    preco = preco + (preco * (percDesp / 100));
                }
            }

            return preco.toFixed(6);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    async function confirmaAltControleItens(data, linha) {

        try {
            $.LoadingOverlay('show');
            try {
                if (!data) {
                    return;
                }

                const info = await retornaDadosCor(pegaChave('#txtCorCI'));

                data.rows().remove();
                if (inclusaoCI) {
                    data.unshift([
                        $('#txtIdCI').val(),
                        $('#cbAtivoCI').prop('checked') == true ? 'S' : 'N',
                        pegaChave('#txtCorCI'),
                        pegaDescricao('#txtCorCI'),
                        $('#txtPrecoTingimentoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoTingimentoCI').val()).replace(',', '.')),
                        $('#txtPrecoCompraCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCompraCI').val()).replace(',', '.')),
                        $('#txtPercDespCI').val() == '' ? 0.00 : parseFloat(($('#txtPercDespCI').val()).replace(',', '.')),
                        $('#txtPrecoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCI').val()).replace(',', '.')),
                        $('#txtPantoneCI').val(),
                        info == undefined ? '' : info.TINTURARIA,
                        info == undefined ? '' : info.NOME,
                        info == undefined ? '' : info.CODIGO2,
                        info == undefined ? '' : info.GRUPO,
                        info == undefined ? '' : info.DESCRICAO
                    ]);
                } else {
                    data[linha][0] = data[linha][0];
                    data[linha][1] = $('#cbAtivoCI').prop('checked') == true ? 'S' : 'N';
                    data[linha][2] = data[linha][2];
                    data[linha][3] = data[linha][3];
                    data[linha][4] = $('#txtPrecoTingimentoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoTingimentoCI').val()).replace(',', '.'));
                    data[linha][5] = $('#txtPrecoCompraCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCompraCI').val()).replace(',', '.'));
                    data[linha][6] = $('#txtPercDespCI').val() == '' ? 0.00 : parseFloat(($('#txtPercDespCI').val()).replace(',', '.'));
                    data[linha][7] = $('#txtPrecoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCI').val()).replace(',', '.'));
                    data[linha][8] = data[linha][8];
                    data[linha][9] = data[linha][9];
                    data[linha][10] = data[linha][10];
                    data[linha][11] = data[linha][11];
                    data[linha][12] = data[linha][12];
                    data[linha][13] = data[linha][13];
                }

                for (let i = 0; i < data.length; i++) {
                    $('#tabelaControleItens').DataTable().row.add([
                        data[i][0],
                        data[i][1],
                        data[i][2],
                        data[i][3],
                        parseFloat(data[i][4]).toFixed(6) == 'NaN' ? data[i][4] : parseFloat(data[i][4]).toFixed(6),
                        parseFloat(data[i][5]).toFixed(6) == 'NaN' ? data[i][5] : parseFloat(data[i][5]).toFixed(6),
                        parseFloat(data[i][6]).toFixed(6) == 'NaN' ? data[i][6] : parseFloat(data[i][6]).toFixed(6),
                        parseFloat(data[i][7]).toFixed(6) == 'NaN' ? data[i][7] : parseFloat(data[i][7]).toFixed(6),
                        data[i][8],
                        data[i][9],
                        data[i][10],
                        data[i][11],
                        data[i][12],
                        data[i][13]
                    ]).draw(false);
                }
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        } finally {
            $('#txtPrecoTingimentoCI').val('');
            $('#txtPrecoCompraCI').val('');
            $('#txtPercDespCI').val('');
            $.LoadingOverlay('hide');
        }
    };

    function excluiLinhaControleItens(linha, data) {

        try {
            $.LoadingOverlay('show');
            try {
                data.rows().remove().draw(false);

                data.splice(linha, 1);

                if (data.length > 0) {
                    for (let i = 0; i < data.length; i++) {
                        $('#tabelaControleItens').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            parseFloat(data[i][4]).toFixed(6) == 'NaN' ? data[i][4] : parseFloat(data[i][4]).toFixed(6),
                            parseFloat(data[i][5]).toFixed(6) == 'NaN' ? data[i][5] : parseFloat(data[i][5]).toFixed(6),
                            parseFloat(data[i][6]).toFixed(6) == 'NaN' ? data[i][6] : parseFloat(data[i][6]).toFixed(6),
                            parseFloat(data[i][7]).toFixed(6) == 'NaN' ? data[i][7] : parseFloat(data[i][7]).toFixed(6),
                            data[i][8],
                            data[i][9],
                            data[i][10],
                            data[i][11],
                            data[i][12],
                            data[i][13]
                        ]).draw(false);
                    }
                } else {
                    $('#tabelaControleItens').DataTable().draw(false);
                }

                desabAlteracaoControleItens();
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível excluir o registro: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaDadosCor(cor) {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CADCOR",
                "camposSelect":["CADCOR.GRUPO, GRUPO_COR.DESCRICAO, CADCOR.TINTURARIA, ENTIDADE.NOME, CADCOR.CODIGO2"],
                "leftjoin": [
                    {"tabela": "GRUPO_COR", "condicao": "CADCOR.GRUPO = GRUPO_COR.CODIGO"},
                    {"tabela": "ENTIDADE", "condicao": "CADCOR.TINTURARIA = ENTIDADE.CODCLI"}
                ],
                "where": ["CADCOR.COR = '${cor}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        return jsonStr.RESULT[0][0];

    };

    $('#btnGravarControleItens').on('click', function () {

        if ($('#tabelaControleItens').DataTable().data().length == 0) {
            msgErro('Não há nenhum dado a ser gravado, favor verificar.');
            return;
        }

        const data = $('#tabelaControleItens').DataTable().data();
        atualizaTabelaCores(data);

    });

    function atualizaTabelaCores(data) {

        try {

            $.LoadingOverlay('show');
            try {
                let dados = [];

                for (let i = 0; i < data.length; i++) {
                    dados.push(
                        {
                            ID: data[i][0],
                            ATIVO: data[i][1],
                            COR: data[i][2],
                            DESCRICAO: data[i][3],
                            PRECO_TING: data[i][4],
                            PRECO_COMPRA: data[i][5],
                            PERC_DESP: data[i][6],
                            PRECO: data[i][7],
                            PANTONE: data[i][8],
                            TINTURARIA: data[i][9],
                            NOME: data[i][10],
                            CODIGO2: data[i][11],
                            GRUPO: data[i][12],
                            DESC_GRUPO: data[i][13]
                        }
                    )
                }

                $('#tabelaCores').DataTable().data().rows().remove();
                preencheDadosTabelaCores(dados);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        }
        finally {
            $('#modalControleItens').modal('hide');
            $.LoadingOverlay('hide');
        }
    }


    $('#modalControleItens').on('hide.bs.modal', function () {
        $('#tabelaControleItens').DataTable().data().rows().remove();
        $('.bodyModal').scrollTop(0);
        desabAlteracaoControleItens();
    });

    function filtraItensPorGrupo() {

        try {
            $.LoadingOverlay('show');

            try {

                const grupo = pegaChave('#txtGrupoCI');
                $('#tabelaControleItens').DataTable().columns(12).search(grupo).draw();

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnFecharControleItens').on('click', function () {
        msgAlerta('Podem haver informações não gravadas, deseja continuar?', () => {
            $('#modalControleItens').modal('hide');
        })
    });

    $('#txtCorCI').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE, DESCRICAO DESCRICAO, PANTONE"], "where": [] }`, ['#txtPantoneCI'], ['PANTONE'], ['PANTONE'], null, [true]);
    $('#txtGrupoCI').autocompleta(1, `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, null, null, null);

    $('#btnGrupoCI').pesquisa_serverside(['#txtGrupoCI'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_COR", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo');

    $('#btnCorCI').pesquisa_serverside(['#txtCorCI', '#txtPantoneCI'], ['COR', 'PANTONE'], ['DESCRICAO', 'PANTONE'], '{"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO", "PANTONE"], "where": null}', 'Pesquisa Cor', null, [false, true]);

    $('#btnAGrupoCI').on('click', async function () {
        $('#txtGrupoCI').val('');
    });

    function calculaValorComQuebra(quantidade, custo, quebra) {

        if (quantidade == '') {
            quantidade = 0;
        }

        if (custo == '') {
            custo = 0;
        }

        if (quebra == '') {
            quebra = 0;
        }

        if (typeof quantidade == 'string') {
            quantidade = quantidade.replace(',', '.');
        }

        if (typeof custo == 'string') {
            custo = custo.replace(',', '.');
        }

        if (typeof quebra == 'string') {
            quebra = quebra.replace(',', '.');
        }

        quantidade = parseFloat(quantidade);
        custo = parseFloat(custo);
        quebra = parseFloat(quebra);

        if (quantidade == '' || quantidade == null || quantidade == undefined) {
            quantidade = 0;
        }

        if (custo == '' || custo == null || custo == undefined) {
            custo = 0;
        }

        if (quebra == '' || quebra == null || quebra == undefined) {
            quebra = 0;
        }

        let valor = quantidade * custo;

        if (quebra > 0) {
            valor = valor / ((100 - quebra) / 100);
        }

        return parseFloat(valor).toFixed(6) == 'NaN' ? valor : parseFloat(valor).toFixed(6);

    }

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/cadprodpreco`;
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtCodigo: {
                required: true,
            },
            txtDescricao: {
                required: true,
            },
            txtGrupo: {
                required: true,
            }
        },
        messages: {
            txtCodigo: {
                required: "Código não pode ser em branco.",
            },
            txtDescricao: {
                required: "Descrição não pode ser em branco.",
            },
            txtGrupo: {
                required: "Informe um grupo válida."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });
});