/* eslint-disable prefer-rest-params */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#conteudo',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código do Setor',
                description: 'Neste campo adicionamos o código do setor.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o registro que estamos cadastrando ou alterando.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o setor.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $(function () {

        $('#txtPreco').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
        $('#txtCusto').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
        });
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let codigo = parametros[parametros.length - 1];

    $(document).ready(function () {
        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADSETOR', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/cadsetor`;
    });

    $('#txtCodigo').on('blur', async function () {
        if (codigo === 'create') {
            const codigo = $('#txtCodigo').val();
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CADFLUXO",
                    "camposSelect":["CODIGO"], 
                    "where": ["CODIGO = '${codigo}'"]}`, null);

            let json = await response.json();
            if (json.RESULT[0].length > 0) {
                msgAlerta('Código já existe. Favor verifique!');
                return;
            }
        }
    });

    if (codigo != '' && codigo != 'create') {
        if (await liberarRegistro('CADSETOR', codigo) == false) {
            window.location.href = '../cadsetor';
        } else {
            try {
                $.LoadingOverlay("show");

                try {
                    $('#txtCodigo').attr('disabled', 'disabled');
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"CADFLUXO", 
                            "camposSelect":["CODIGO", "DESCRICAO", "ATIVO", "PRECO", "CUSTO", "TIPO"], 
                            "where": ["CODIGO = '${codigo}'"]}`, null);

                    let json = await response.json();

                    $('#txtCodigo').val(json.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(json.RESULT[0][0].DESCRICAO);
                    $('#txtPreco').val(json.RESULT[0][0].PRECO);
                    $('#txtCusto').val(json.RESULT[0][0].CUSTO);

                    if (json.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    } else {
                        $('#checkAtivo').prop('checked', false);
                    }
                    if (json.RESULT[0][0].TIPO == 'P') {
                        $('#radioProduto').prop('checked', true);
                    }
                    if (json.RESULT[0][0].TIPO == 'M') {
                        $('#radioMaterial').prop('checked', true);
                    }
                    if (json.RESULT[0][0].TIPO == 'V') {
                        $('#radioVenda').prop('checked', true);
                    }

                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#btnGravar").click(async function () {
        $.LoadingOverlay("show");
        try {
            if ($('#txtCodigo').val() == '') {
                msgAlerta(`Necessário informar um código.`);
                return;
            }
            if ($('#txtDescricao').val() == '') {
                msgAlerta(`Necessário informar uma descrição.`);
                return;
            }

            let setor = {};

            setor.CODIGO = $('#txtCodigo').val();
            setor.DESCRICAO = $('#txtDescricao').val().toUpperCase();
            setor.PRECO = parseFloat($('#txtPreco').val());
            setor.CUSTO = parseFloat($('#txtCusto').val());
            setor.ATIVO = $('#checkAtivo').prop('checked') ? setor.ATIVO = 'S' : setor.ATIVO = 'N';

            if ($('#radioProduto').is(':checked')) {
                setor.TIPO = 'P'
            }
            if ($('#radioMaterial').is(':checked')) {
                setor.TIPO = 'M'
            }
            if ($('#radioVenda').is(':checked')) {
                setor.TIPO = 'V'
            }

            let response = await requisicao('POST', '/sisplan/cadastros/v1/cadsetor?', '', `JSON=${JSON.stringify(setor)}`, 15000);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
                'Cadastro efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/cadsetor`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });
        } catch (error) {
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados do setor.`);
        }
        finally{
            $.LoadingOverlay("hide");
        }
    });
});