$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtConta",
        popover: {
          title: "Conta",
          description: "Conta referente ao cadastro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Campos Obrigatórios",
          description: "Adicionamos aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a carteira.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const objConta = $(window.location.href.split('/')).get(-1);

  funcaoAvancarVoltar();
  addPesquisaAutocompleta();
  addValidacaoCamposObrigatorios();

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/carteira_cobranca`;
  });


  await carregaDados();

  async function carregaDados() {

    if (objConta == 'create') {
      return;
    }

    const objEdicao = JSON.parse(atob(objConta));

    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'CARTEIRA',
        camposSelect: [
          'CARTEIRA.CONTA',
          'CARTEIRA.DESCRICAO',
          'CARTEIRA.CONVENIO',
          'CARTEIRA.NOME_ARQ',
          'CARTEIRA.EXTENSAO_ARQUIVO',
          'CARTEIRA.NOME_ARQUIVO',
          'CADCONTA.DESCRICAO DESC_CONTA',
          'CARTEIRA.CARTEIRA',
          'CARTEIRA.SITUA_BCO',
          'CARTEIRA.SITUACAO',
          'TABSIT.DESCRICAO DESC_SITUACAO_BANCO',
          'SIT.DESCRICAO DESC_SITUACAO',
          'CARTEIRA.NR_BANCO',
          'CARTEIRA.NR_BANCO_FIM',
          'CARTEIRA.INSTRUCAO_1',
          'CARTEIRA.INSTRUCAO_2',
          'CARTEIRA.DESCRICAO2',
          'CARTEIRA.DESCRICAO3',
          'CARTEIRA.ACEITE',
          'CARTEIRA.DIASPROTESTO',
          'CARTEIRA.CEB',
          'CARTEIRA.TIPO',
          'CARTEIRA.DT_VENDOR',
          'CARTEIRA.TAXA1',
          'CARTEIRA.TAXA2',
          'CARTEIRA.LAYOUT',
          'CARTEIRA.EXTENSAO_ARQ_SEQ',
          'CARTEIRA.CONTA_CONVENIADA',
          'CARTEIRA.TP_CARTEIRA',
          'CARTEIRA.LOCAL_PAGTO',
          'CARTEIRA.COD_PRACA_SACADO',
          'CARTEIRA.PADRAO_INSTR_1',
          'CARTEIRA.PADRAO_INSTR_2',
          'CARTEIRA.ENVIA_INSTR_1',
          'CARTEIRA.ENVIA_INSTR_2',
          'CARTEIRA.IMP_BOLETO',
          'CARTEIRA.GERA_NOSSO',
          'CARTEIRA.PADRAO_BOLETO',
          'CARTEIRA.IMP_COBREBEM',
          'CARTEIRA.COD_BAIXADEV',
          'CARTEIRA.TIPO_LAYOUT',
          'CARTEIRA.DIAS_BAIXADEV',
          'CARTEIRA.AGENCIA_4_DIG',
          'CARTEIRA.POSICOES_240',
          'CARTEIRA.COD_BAN_EMITE_BOL',
          'CARTEIRA.BAIRRO_ZERO',
          'CARTEIRA.BYTE_NOSSO_NUM',
          'CARTEIRA.ZEROE',
          'CARTEIRA.TIPO_DIAS_PROT',
          'CARTEIRA.TIPO_DIAS_CLASSIF'
        ],
        where: [`CARTEIRA.CONTA = '${objEdicao.CONTA}' AND CARTEIRA.CARTEIRA = '${objEdicao.CARTEIRA}'`],
        leftJoin: [
          { tabela: 'CADCONTA', condicao: 'CADCONTA.CONTA = CARTEIRA.CONTA' },
          { tabela: 'TABSIT', condicao: 'TABSIT.CODIGO = CARTEIRA.SITUA_BCO' },
          { tabela: 'TABSIT', alias: 'SIT', condicao: 'TABSIT.CODIGO = CARTEIRA.SITUACAO' },
        ]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      insereValor('#txtConta', jsonStr[0].CONTA, jsonStr[0].DESC_CONTA);
      insereValor('#txtDescricao', jsonStr[0].DESCRICAO);
      insereValor('#txtConvenio', jsonStr[0].CONVENIO);
      insereValor('#txtCarteira', objEdicao.CARTEIRA);
      insereValor('#txtSitBanco', jsonStr[0].SITUA_BCO, jsonStr[0].DESC_SITUACAO_BANCO);
      insereValor('#txtSituacao', jsonStr[0].SITUACAO, jsonStr[0].DESC_SITUACAO);
      insereValor('#txtByteNossoNumero', jsonStr[0].BYTE_NOSSO_NUM);
      insereValor('#txtSeqNossoNroIni', jsonStr[0].NR_BANCO);
      insereValor('#txtSeqNossoNroFim', jsonStr[0].NR_BANCO_FIM);
      insereValor('#txtDado1', jsonStr[0].INSTRUCAO_1);
      insereValor('#txtDado2', jsonStr[0].INSTRUCAO_2);
      insereValor('#txtInstrucaoCob1', jsonStr[0].DESCRICAO2);
      insereValor('#txtInstrucaoCob2', jsonStr[0].DESCRICAO3);
      insereValor('#txtAceite', jsonStr[0].ACEITE);
      insereValor('#txtCEB', jsonStr[0].CEB);
      insereValor('#txtTaxa1', jsonStr[0].TAXA1);
      insereValor('#txtTaxa2', jsonStr[0].TAXA2);
      insereValor('#txtDiasProtesto', jsonStr[0].DIASPROTESTO);
      insereValor('#dtVendor', jsonStr[0].DT_VENDOR);
      insereValor('#txtTipo', jsonStr[0].TIPO);
      insereValor('#txtArquivoLayout', jsonStr[0].LAYOUT);
      insereValor('#txtExtensaoArquivo', jsonStr[0].EXTENSAO_ARQUIVO);
      insereValor('#txtContaConveniada', jsonStr[0].CONTA_CONVENIADA);
      insereValor('#txtTipoCarteira', jsonStr[0].TP_CARTEIRA);
      insereValor('#txtLocalPagamento', jsonStr[0].LOCAL_PAGTO);
      insereValor('#txtNomeArquivo', jsonStr[0].NOME_ARQ);
      insereValor('#txtZeroEscEnv', jsonStr[0].ZEROE);
      insereValor('#txtCodBanco', jsonStr[0].COD_BAN_EMITE_BOL);
      insereValor('#txtInstrPadrao1', jsonStr[0].PADRAO_INSTR_1);
      insereValor('#txtInstrPadrao2', jsonStr[0].PADRAO_INSTR_2);
      insereValor('#txtCodBaixaDev', jsonStr[0].COD_BAIXADEV);
      insereValor('#txtDiasBaixaDev', jsonStr[0].DIAS_BAIXADEV);
      insereValor('#txtExtArqSeq', jsonStr[0].EXTENSAO_ARQ_SEQ);
      insereValor('#txtCodPracaSacado', jsonStr[0].COD_PRACA_SACADO);

      $('#cbProtesto').prop('checked', jsonStr[0].TIPO_DIAS_CLASSIF == 'P');
      $('#cbNegativacao').prop('checked', jsonStr[0].TIPO_DIAS_CLASSIF == 'N');
      $('#cbDiasCorridos').prop('checked', jsonStr[0].TIPO_DIAS_PROT == 'C');
      $('#cbDiasUteis').prop('checked', jsonStr[0].TIPO_DIAS_PROT == 'U');

      $('#cbGeraNossoNumero').prop('checked', jsonStr[0].GERA_NOSSO == 'S');
      $('#cbPadraoImpBoleto').prop('checked', jsonStr[0].PADRAO_BOLETO == 'S');
      $('#cbGerarArqCobreBem').prop('checked', jsonStr[0].IMP_COBREBEM == 'S');
      $('#cbAgencia4Dig').prop('checked', jsonStr[0].AGENCIA_4_DIG == 'S');
      $('#cbCarteira240Posicoes').prop('checked', jsonStr[0].POSICOES_240 == 'S');
      $('#cbBairroComZeros').prop('checked', jsonStr[0].BAIRRO_ZERO == 'S');

      $('#cbImprimeBoleto').prop('checked', jsonStr[0].IMP_BOLETO == 'S');
      $('#cbInstrPadrao1').prop('checked', jsonStr[0].ENVIA_INSTR_1 == 'S');
      $('#cbInstrPadrao2').prop('checked', jsonStr[0].ENVIA_INSTR_2 == 'S');

      $('#rgPreencherNomeArq').val(jsonStr[0].NOME_ARQUIVO).change();
      $('#rgLayout').val(jsonStr[0].TIPO_LAYOUT).change();

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    $.LoadingOverlay('show');
    try {

      const cPagto = {
        CARTEIRA: pegaValor('#txtCarteira'),
        CONTA: pegaChave('#txtConta'),
        DESCRICAO: pegaValor('#txtDescricao'),
        NOME_ARQ: pegaValor('#txtNomeArquivo'),
        CONVENIO: pegaValor('#txtConvenio'),
        NOME_ARQUIVO: pegaValor('#rgPreencherNomeArq'),
        SITUA_BCO: pegaChave('#txtSitBanco'),
        SITUACAO: pegaChave('#txtSituacao'),
        BYTE_NOSSO_NUM: pegaValor('#txtByteNossoNumero'),
        NR_BANCO: pegaValor('#txtSeqNossoNroIni'),
        NR_BANCO_FIM: pegaValor('#txtSeqNossoNroFim'),
        INSTRUCAO_1: pegaValor('#txtDado1'),
        INSTRUCAO_2: pegaValor('#txtDado2'),
        DESCRICAO2: pegaValor('#txtInstrucaoCob1'),
        DESCRICAO3: pegaValor('#txtInstrucaoCob2'),
        ACEITE: pegaValor('#txtAceite'),
        CEB: pegaValor('#txtCEB'),
        TAXA1: pegaValor('#txtTaxa1'),
        TAXA2: pegaValor('#txtTaxa2'),
        DIASPROTESTO: pegaValor('#txtDiasProtesto'),
        DT_VENDOR: pegaValor('#dtVendor') != '' ? (pegaValor('#dtVendor') + 'T00:00:00Z') : '1899-12-30T00:00:00Z',
        TIPO: pegaValor('#txtTipo'),
        LAYOUT: pegaValor('#txtArquivoLayout'),
        EXTENSAO_ARQUIVO: pegaValor('#txtExtensaoArquivo'),
        CONTA_CONVENIADA: pegaValor('#txtContaConveniada'),
        TP_CARTEIRA: pegaValor('#txtTipoCarteira'),
        LOCAL_PAGTO: pegaValor('#txtLocalPagamento'),
        ZEROE: pegaValor('#txtZeroEscEnv'),
        COD_BAN_EMITE_BOL: pegaValor('#txtCodBanco'),
        PADRAO_INSTR_1: pegaValor('#txtInstrPadrao1'),
        PADRAO_INSTR_2: pegaValor('#txtInstrPadrao2'),
        COD_BAIXADEV: pegaValor('#txtCodBaixaDev'),
        DIAS_BAIXADEV: pegaValor('#txtDiasBaixaDev'),
        EXTENSAO_ARQ_SEQ: pegaValor('#txtExtArqSeq'),
        COD_PRACA_SACADO: pegaValor('#txtCodPracaSacado'),
        TIPO_LAYOUT: pegaValor('#rgLayout'),
        TIPO_DIAS_CLASSIF: isChecked('#cbProtesto') ? 'P' : 'N',
        TIPO_DIAS_PROT: isChecked('#cbDiasCorridos') ? 'C' : 'U',
        GERA_NOSSO: isChecked('#cbGeraNossoNumero') ? 'S' : 'N',
        PADRAO_BOLETO: isChecked('#cbPadraoImpBoleto') ? 'S' : 'N',
        IMP_COBREBEM: isChecked('#cbGerarArqCobreBem') ? 'S' : 'N',
        AGENCIA_4_DIG: isChecked('#cbAgencia4Dig') ? 'S' : 'N',
        POSICOES_240: isChecked('#cbCarteira240Posicoes') ? 'S' : 'N',
        BAIRRO_ZERO: isChecked('#cbBairroComZeros') ? 'S' : 'N',
        IMP_BOLETO: isChecked('#cbImprimeBoleto') ? 'S' : 'N',
        ENVIA_INSTR_1: isChecked('#cbInstrPadrao1') ? 'S' : 'N',
        ENVIA_INSTR_2: isChecked('#cbInstrPadrao2') ? 'S' : 'N',
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/carteira?', `JSON=${encodeURIComponent(JSON.stringify(cPagto))}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        msgAlerta(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/carteira_cobranca` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

  function funcaoAvancarVoltar() {
    $(".next").click(function () {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          nextFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });
    });

    $(".previous").click(function () {
      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          previousFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });
    });
  };

  function addValidacaoCamposObrigatorios() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtCodigo: {
          required: "Informe uma conta válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  function addPesquisaAutocompleta() {
    $("#txtConta").autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "Conta CHAVE", "DESCRICAO"], "where": null}`);
    $("#btnConta").pesquisa("#txtConta", "CONTA", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, "Pesquisa Conta", "CADCONTA");
    $("#btnLimpaConta").on("click", function () {
      $("#txtConta").val("");
    });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
    $("#btnSituacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Situação", "TABSIT");
    $("#btnLimpaSituacao").on("click", function () {
      $("#txtSituacao").val("");
    });

    $("#txtSitBanco").autocompleta(1, `JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);
    $("#btnSitBanco").pesquisa("#txtSitBanco", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Situação", "TABSIT");
    $("#btnLimpaSitBanco").on("click", function () {
      $("#txtSitBanco").val("");
    });

    $('#txtTaxa1, #txtTaxa2').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });

    $('#txtZeroEscEnv, #txtDiasBaixaDev, #txtDiasProtesto').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 0
    });
  };

});
