/* eslint-disable guard-for-in */
/* eslint-disable no-restricted-syntax */

let empId = getCookie('emp_id');
let paramUtiliza;
setCookie('enviando_comando', false);

async function carregaConfig() {
  try {
    paramUtiliza = await CopiaParametro('VENDA', 18);
    let url = '/cfe/cfe?';
    let cfe = {};
    let natureza;
    let response;

    if (!await testeConexao()) {
      msgAlerta('Não está conectado a Api Local!');
      return;
    }

    cfe.id = '0';
    cfe.empresadao = await retornaInformacaoEmpresa();

    if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
      response = await requisicaoSat('POST', url, 'CARREGACONFIG=S', JSON.stringify(cfe), 200000);
    } else {
      response = await requisicao_ecf('GET', url, `EMPRESADAO=${JSON.stringify(cfe)}`, '', 6000);
    }

    const jsonIni = await response.json();
    if (response.status != 200) {
      console.error(jsonIni.RESULT[0][0].mensagem);
      return;
    }

    try {
      let responseNatureza = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"NATUREZA", "camposSelect":["NATUREZA", "DESCRICAO"], "where": ["NATUREZA = '${jsonIni.natureza}'"]}`, null);
      if (!responseNatureza) {
        natureza = '';
        return;
      }
      const jsonStr = await responseNatureza.json();
      if (responseNatureza.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      natureza = `[${jsonStr.RESULT[0][0].NATUREZA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

    } catch (error) {
      console.error(error);
    }

    $('#txtAmbienteSAT').val(jsonIni.ambiente);
    $('#txtCodAtivacaoSAT').val(jsonIni.codigoAtivacao);
    $('#txtModeloSAT').val(jsonIni.modelo);
    $('#txtNaturezaConfig').val(natureza);
    $('#txtPastaCencelSAT').val(jsonIni.pastaCancelamento);
    $('#txtPastaEnvioSAT').val(jsonIni.pastaEnvio);
    $('#txtPastaVendaSAT').val(jsonIni.pastaVenda);
    $('#txtAssinaturaSAT').val(jsonIni.signAc);
    $('#txtVersaoSAT').val(jsonIni.versao);
    $('#txtVersaoDadosEntSAT').val(jsonIni.versaoDadosEnt);
    $('#txtVersaoSBSAT').val(jsonIni.versaoSB);

    if (jsonIni.ambiente == '1') {
      $('#txtHomologacao').html('HOMOLOGAÇÃO');
    } else {
      $('#txtHomologacao').html('PRODUÇÃO');
    }

    if ((paramUtiliza == "2") || (paramUtiliza == "4")) {
      $('#txtChaveValidadorMFE').val(jsonIni.chaveValidador);
      $('#txtChaveRequisicaoMFE').val(jsonIni.chaveRequisicao);
      $('#checkEmiteCupomNFCe').val(jsonIni.emitirNFCE);
      $('#checkControlerAntiFraude').val(jsonIni.controleAntiFraude);
      $('#txtPastaEnvioMFE').val(jsonIni.pastaEnvioMFE);
      $('#txtPastaRespostaMFE').val(jsonIni.pastaRespostaMFE);
      $('#txtTimeOutMFE').val(jsonIni.timeOut);
    }
  } catch (error) {
    console.error(error);
    msgErro('Erro ao carregar as configs da CFE');
  }
};

// verifica parametros
async function verificaParametroCFE() {
  paramUtiliza = await CopiaParametro('VENDA', 18);
  if (paramUtiliza == "0") {
    mensagemParametro('Parametro utiliza CFE não está infomado.', abreParametros, 'Deseja ativar o parametro da tela?');
    return true;
  }

  if ((paramUtiliza == "1") || (paramUtiliza == "3")) {
    $('#titleHeader').html('Impressão CF-e SAT');
    $('#textPath').html('Impressão CF-e SAT');
    $('#textTable').html('Impressão CF-e SAT');
    $('#gerarStatus').addClass('d-none');
    $('.mfeIni').addClass('d-none');
    return false;
  }
  if ((paramUtiliza == "2") || (paramUtiliza == "4")) {
    $('#titleHeader').html('Impressão CF-e MFE');
    $('#textPath').html('Impressão CF-e MFE');
    $('#gerarStatus').removeClass('d-none');
    $('#textTable').html('Impressão CF-e MFE');
    $('.mfeIni').removeClass('d-none');
    await carregaConfig();
    return false;
  }
}

// mensagem paramtro
// fiz essa mensagem por conta de não ter a mensagem confirma no msgAlert()
function mensagemParametro($mensagem, $callback, $mensagemConfirma) {
  $('#modal-cfe-titulo').html('Atenção');
  $('#modal-cfe-conteudo1').html($mensagem);
  $('#modal-cfe-conteudo2').html($mensagemConfirma);
  if ($callback != undefined) {
    $('#modal-cfe-rodape').html('<button id="btn-msg-alerta" type="button" class="btn bg-gradient-success btn-sisp">Confirmar</button>' +
      '<button type="button" id="btnFechaModalCFE" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">Cancelar</button>');
  } else {
    $('#modal-cfe-rodape').html('<button data-dismiss="modal" id="btn-msg-alerta" type="button" class="btn bg-gradient-success btn-sisp">Ok</button>');
  }
  $('#modal-cfe').modal('show');
  $('#btn-msg-alerta').focus();
  $('#btnFechaModalCFE').on('click', function () {
    window.location.href = `${BASE_URI}/index`;
  });
  $('#btn-msg-alerta').on('click', function () {
    $callback();
    $('#modal-cfe').modal('hide');
  });
}

function abreParametros() {
  window.location.href = `${BASE_URI}/parametros`;
}

// verifica se está conectado com a API Local.
async function testeConexao() {
  try {
    $.LoadingOverlay('show');
    try {
      let porta;
      let response;
      paramUtiliza = await CopiaParametro('VENDA', 18);

      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        porta = getCookie('ipPortaServidor');
      } else {
        porta = getCookie('porta_api_local');
      }

      if (porta == '') {
        return false;
      }

      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        response = await requisicaoSat('GET', '/conexao/conexao?', ``, 1000);
      } else {
        response = await requisicao_ecf('GET', '/conexao/conexao?', ``, 1000);

      }
      if (!response) {
        return false;
      }
      if (response.status == 200) {
        return true;
      }
    } catch (error) {
      console.error(error);
      return false;
    }
  } finally {
    $.LoadingOverlay('hide');
  }
}

async function carregandoIni() {
  $('#txtNaturezaConfig').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
  $('#btn-NaturezaConfig').pesquisa('#txtNaturezaConfig', 'NATUREZA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": null}', 'Pesquisa Natureza', 'natureza');

  $('#btn-limpa-NaturezaConfig').on('click', function () {
    $('#txtNaturezaConfig').val('');
  });
};


// grava config do ini
$('#btn-confirmar-config').on('click', async function () {
  try {
    $.LoadingOverlay('show');
    try {
      paramUtiliza = await CopiaParametro('VENDA', 18);
      let natureza = pegaChave('#txtNaturezaConfig');
      let url = '/cfe/cfe?';
      let cfeIni = {};
      let params = `PARAMETRO=${paramUtiliza}&CARREGACONFIG=N`;
      let response;


      cfeIni.ambiente = $('#txtAmbienteSAT').val();
      cfeIni.codigoAtivacao = $('#txtCodAtivacaoSAT').val();
      cfeIni.modelo = $('#txtModeloSAT').val();
      cfeIni.natureza = natureza;
      cfeIni.pastaCancelamento = $('#txtPastaCencelSAT').val();
      cfeIni.pastaEnvio = $('#txtPastaEnvioSAT').val();
      cfeIni.pastaVenda = $('#txtPastaVendaSAT').val();
      cfeIni.signAc = $('#txtAssinaturaSAT').val();
      cfeIni.versao = $('#txtVersaoSAT').val();
      cfeIni.versaoDadosEnt = $('#txtVersaoDadosEntSAT').val();
      cfeIni.versaoSB = $('#txtVersaoSBSAT').val();
      cfeIni.empresadao = await retornaInformacaoEmpresa();

      if ((paramUtiliza == "2") || (paramUtiliza == "4")) {
        cfeIni.chaveValidador = $('#txtChaveValidadorMFE').val();
        cfeIni.chaveRequisicao = $('#txtChaveRequisicaoMFE').val();
        cfeIni.emitirNFCE = $('#checkEmiteCupomNFCe').val();
        cfeIni.controleAntiFraude = $('#checkControlerAntiFraude').val();
        cfeIni.pastaEnvioMFE = $('#txtPastaEnvioMFE').val();
        cfeIni.pastaRespostaMFE = $('#txtPastaRespostaMFE').val();
        cfeIni.timeOut = $('#txtTimeOutMFE').val();
      }

      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        response = await requisicaoSat('POST', url, params, JSON.stringify(cfeIni), 15000);
      } else {
        response = await requisicao_ecf('POST', url, params, JSON.stringify(cfeIni), 15000);
      }

      if (response.status == 200) {
        toastr.success(
          'Configuração gravada com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            $('#modal-Config').modal('hide');
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      } else {
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro('Erro ao gravar config do INI ');
    }
  } finally {
    $.LoadingOverlay('hide');
  }
});

$('#btn-Config').on('click', async function () {
  if (!await testeConexao()) {
    msgAlerta('Não está conectado a Api Local!');
    return;
  }

  $('#modal-Config').modal('show');
});

$('#btn-filtros').on('click', async function () {
  if (!await testeConexao()) {
    msgAlerta('Não está conectado a Api Local!');
    return;
  }

  $('#modal-filtros').modal('show');
});

// consulta cfe
$('#btn-consultar').on('click', async function () {
  try {
    $.LoadingOverlay('show');

    if (await verificaParametroCFE()) {
      return;
    }
    if (!await testeConexao()) {
      msgAlerta('Não está conectado a Api Local!');
      return;
    }

    try {
      let jsonCFE = await buscaCFE();

      tabelaCFE = $('#tabelaCFE').DataTable({
        destroy: true,
        "order": [[0, "desc"]],
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "autoWidth": true,
        "data": jsonCFE,
        "columns": [{
          "data": "ID"
        },
        {
          "data": "FATURA"
        },
        {
          "data": "DT_EMISSAO"
        },
        {
          "data": "CODCLI"
        },
        {
          "data": "CLIENTE_NOME"
        },
        {
          "data": "VALOR"
        },
        {
          "data": "VALOR_LIQ"
        },
        {
          "data": "CODVEN"
        },
        {
          "data": "IMPRESSO"
        },
        ],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoesCFE(data);
          }
        },
        {
          "type": 'date-br',
          "render": function (data) {
            x = data.slice(0, 10).split('-');
            return `${x[2]}/${x[1]}/${x[0]}`;
          },
          "targets": 2,
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString('pt-BR', {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          "targets": [5,6]
        }
        ]
      });
      if (await verificaParametroCFE()) {
        return;
      }
      await carregaConfig();
      await carregandoIni();
    } catch (error) {
      console.error(error);
      msgErro('Erro ao consultar CFE!');
    }
  } finally {
    $.LoadingOverlay('hide');
    $('#modal-filtros').modal('hide');
  }
});

$('#btnGerarGuid').on('click', async function () {
  $('#txtChaveRequisicaoMFE').val(await gerarGuid());
});

function gerarGuid() {
  return ([1e7] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, c =>
    // eslint-disable-next-line no-bitwise
    (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
  );
}

// retorna o botao opções
function retornaBotaoOpcoesCFE(data) {
  return '<div style="text-align:left;"> ' +
    '   <div class="dropdown"> ' +
    '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
    '      ' + data + ' ' +
    '    </button> ' +
    '    <div class="dropdown-menu"> ' +
    '    <a id="btn-mostrar-itens" class="dropdown-item" href="#">Mostrar Itens</a>' +
    '    </div>' +
    '  </div>' +
    '</div>';
};

// mostra os itens q estão vinculados
$('#tabelaCFE').on('click', '#btn-mostrar-itens', async function () {
  try {
    $.LoadingOverlay("show");
    try {
      let tr = this.closest('tr');
      let date = $('#tabelaCFE').DataTable().row($(tr)).data();
      let dados = await buscaItens(date.ID);
      $('#txtNotaItens').val(date.CODVEN);
      $('#txtSerieItens').val(date.SERIE);
      $('#modal-itens-title').html(`Itens da nota: ${date.CODVEN}`);
      let dataSetCols = [];

      let keys = Object.keys(dados.RESULT[0][0]);

      for (let k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      dataSetCols[11].render = function (data, type, row, meta) {
        return `${'<div class="group-default form-group">' +
          '<div class="relative">' +
          '<input type="text" placeholder="Natureza" id="natureza_col_'}${[meta.row]}_row_${[meta.col]}" readonly class="input-default focus form-control validate campoNatureza" value="${data}"> ` +
          `</div>` +
          `</div>`;
      };

      tabelaItens = $('#tabelaItens').DataTable({
        paging: false,
        filter: false,
        info: true,
        order: true,
        destroy: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "data": dados.RESULT[0],
        "columns": dataSetCols,
        "columnDefs": [{
          "targets": [0, 1, 3, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
          "visible": false
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString('pt-BR', {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          "targets": [7,8]
        }
      ],
      });

      if ($('#txtProtocoloNF').val() == '') {
        for (let i = 0; i < $('.campoNatureza').length; i++) {
          $(`#natureza_col_${i}_row_8`).pesquisa(`#natureza_col_${i}_row_8`, 'NATUREZA', 'NATUREZA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":["natureza"], "where": ["tipo = ${"'V'"} and tp_base = 1"]}`, 'Pesquisa Natureza', 'natureza', 'S');
        }
      }

      $('#modal-itens').modal('show');
    } catch (error) {
      console.error(error);
      msgErro('Erro ao mostrar os itens!');
    }
  } finally {
    $.LoadingOverlay("hide");
  }
});

// faz a busca dos itens
async function buscaItens(sId) {
  try {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    const response = await requisicao(
      'GET', 
      url, 
      `JSON={ 
        "tabela":"CFE_ITEN", 
        "camposSelect":[ 
          "CFE_ITEN.CODVEN",
          "CFE_ITEN.TIPO_IT",
          "CFE_ITEN.CODIGO",
          "CFE_ITEN.UNIDADE",
          "CFE_ITEN.COR",
          "CFE_ITEN.TAM",
          "CFE_ITEN.QUANTIDADE",
          "CFE_ITEN.PRECO",
          "CFE_ITEN.VALOR",
          "CFE_ITEN.DESCONTO",
          "CFE_ITEN.VALOR_ICMS",
          "CFE_ITEN.NATUREZA",
          "CFE_ITEN.PERC_ICMS",
          "CFE_ITEN.CLA_FIS",
          "CFE_ITEN.CLA_ICMS CLA_TRIB",
          "TABFIS.DESCRICAO NCM",
          "CFE_ITEN.VALOR_LIQ",
          "CFE_ITEN.VALOR_IMPOSTO",
          "CLA_PIS",
          "PERC_PIS",
          "VALOR_PIS",
          "CLA_COFINS",
          "PERC_COFINS",
          "VALOR_COFINS",
          "BASE_PIS_COFINS", 
          "PRODUTO.DESCRICAO", 
          "VALOR_OUTROS ", 
          "NATUREZA.PIS_COFINS"
        ], 
        "leftjoin":[
          { "tabela":"TABFIS", "condicao":"TABFIS.CODIGO = CFE_ITEN.CLA_FIS" }, 
          { "tabela":"PRODUTO", "condicao":"PRODUTO.CODIGO = CFE_ITEN.CODIGO" }, 
          { "tabela":"MATERIAL", "condicao":"MATERIAL.CODIGO = CFE_ITEN.CODIGO" }, 
          {"tabela": "NATUREZA", "condicao": "NATUREZA.NATUREZA = CFE_ITEN.NATUREZA" }
        ], 
        "where": ["CFE_ITEN.ID_CFE = ${sId} and CFE_ITEN.EMP_ID = ${empId}"] }`, 
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    return jsonStr;
  } catch (error) {
    console.error(error);
    msgErro('Não foi possível buscar as notas fiscais');
  }
}

// realiza a consulta do CFE
async function buscaCFE() {
  try {
    let idCFE;
    if ($('#txtIdCFE').val() == '') {
      idCFE = 0;
    } else {
      idCFE = $('#txtIdCFE').val();
    }
    if ($('#radioPrimary1').prop('checked')) {
      tipoimpressao = 0;
    }
    if ($('#radioPrimary2').prop('checked')) {
      tipoimpressao = 1;
    }
    if ($('#radioPrimary3').prop('checked')) {
      tipoimpressao = 2;
    }
    if ($('#radioPrimary4').prop('checked')) {
      tipoimpressao = 3;
    }
    let codcli = pegaChave('#txtCliente');
    let codvenda = pegaChave('#txtVenda');
    let dtEmissaoI = $('#txtDataDe').val();
    let dtEmissaoF = $('#txtDataAte').val();
    let params = `ID=${idCFE}&CODCLI=${codcli}&TIPOIMPRESSAO=${tipoimpressao}&CODVENDA=${codvenda}&DTEMISSAOI=${dtEmissaoI}&DTEMISSAOF=${dtEmissaoF}&EMPID=${empId}`;
    const url = '/sisplan/cfe/v1/cfe?';

    const response = await requisicao('GET', url, params, null);

    if (!response) {
      return;
    }

    let jsonCFE = await response.json();
    if (response.status != 200) {
      msgErro(jsonCFE.RESULT[0].mensagem);
      return;
    }

    return jsonCFE;
  } catch (error) {
    console.error(error);
    msgErro('Erro ao consultar CFe');
  }
}

// realiza a consulta do CFE da venda
// eslint-disable-next-line no-unused-vars
async function buscaCFEVenda(sId) {
  try {
    let params = `ID=${sId}&EMPID=${empId}`;
    const url = '/sisplan/cfe/v1/cfe?';

    const response = await requisicao('GET', url, params, null);

    if (!response) {
      return;
    }

    let jsonCFE = await response.json();
    if (response.status != 200) {
      msgErro(jsonCFE.RESULT[0].mensagem);
      return;
    }

    return jsonCFE;
  } catch (error) {
    console.error(error);
    msgErro('Erro ao consultar CFe');
  }
}

async function atualizaCFEgerada(cfe) {
  try {
    const url = '/sisplan/cfe/v1/cfe?';

    const response = await requisicao('PUT', url, '', `${JSON.stringify(cfe)}`, 90000);

    if (!response) {
      return;
    }

    // const jsonStr = await response.json();
    if (response.status != 200) {
      // msgErro(jsonStr.mensagem);
      return;
    }
  } catch (error) {
    console.error(error);
  }
}

// transmite manual e automatico na venda, cuidar pra mudar pois pode resultar em algo na venda
async function TransmiteCfe(objeto) {

  async function verificaSeJaNaoEstaTransmitido() {
    const dadosSelect = {
      tabela: `cfe`,
      camposSelect: [`ID, CHAVE_CFE`],
      where: [`CODVEN = '${objeto.CODVEN}' AND EMP_ID = '${getCookie('emp_id')}'`],
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(
      JSON.stringify(dadosSelect)
    );

    if (retornoSelect) {
      if (retornoSelect[0].CHAVE_CFE != '') {
        return false;
      }
      return true;
    }

    return true;
  }

  if (!await testeConexao()) {
    msgAlerta('Não está conectado a Api Local!');
    return;
  }
  try {
    try {
      let url = '/cfe/cfe?';
      let response;
      let cfe = {};
      paramUtiliza = await CopiaParametro('VENDA', 18);

      cfe = await preencheObjeto(objeto);
      cfe.EMPRESADAO = await retornaInformacaoEmpresa();

      if (await verificaSeJaNaoEstaTransmitido()) {
        if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
          if (await liberarRegistro('IMPRESSAOCFE', cfe.ID)) {
            response = await requisicaoSat('PUT', url, `PARAMETRO=${paramUtiliza}`, JSON.stringify(cfe), 60000);
          } else {
            msgAlerta('Registro já esta sendo gerado!');
            return true;
          }
        } else {
          if (await liberarRegistro('IMPRESSAOCFE', cfe.ID)) {
            response = await requisicao_ecf('PUT', url, `PARAMETRO=${paramUtiliza}`, JSON.stringify(cfe), 60000);
          } else {
            msgAlerta('Venda já esta sendo gerada!');
            return;
          }
        }
      } else {
        msgAlerta('Venda já transmitida!', null, null, $('#btn-consultar').trigger('click'));
        return;
      }
      if (!response) {
        msgErro('Tempo excedido! A transmissão continuará em segundo plano!');
        redireciona = true;
        return redireciona;
      }

      const jsonStr = await response.json();

      $.LoadingOverlay('show');
      if (response.status == 200) {
         setTimeout(async () => {
          toastr.success(
            'CF-e gerada com sucesso!',
            'Confirmação', {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning'
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 6000,
            fadeOut: 1000,
            async onHidden() {
              $.LoadingOverlay('hide');

            }
          }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });
          // await atualizaCFEgerada(jsonStr);
          $('#btn-consultar').trigger('click');
          let url2 = `/Sisplan/impressao/v1/CFE?ID=${jsonStr.id}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('CFE');
          let arquivo = await GeraRelatorio(`${url2}&`, 'GET', 60000, false, 'CFE');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }

          imprimirBoleto('S');
        }, 3000);
        $.LoadingOverlay('show');
      } else {
        $.LoadingOverlay("hide");
        toastr.error(
          `${jsonStr.mensagem.mensagem}`,
          'Erro', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
        return false;
      }
      redireciona = true;
      return redireciona;

    } catch (error) {
      console.error(error);
      redireciona = false;
      return redireciona;
    }
  } finally {
    $('#btn-consultar').trigger('click');
  }
}

// gera CFE
$('#btnGerar').on('click', async function () {
  try {
    $.LoadingOverlay('show');
    try {
      if (await verificaParametroCFE()) {
        return;
      }

      if (!await testeConexao()) {
        msgAlerta('Não está conectado a Api Local!');
        return;
      }

      let tr = $('#tabelaCFE tr.selected')[0];
      let data = $('#tabelaCFE').DataTable().row($(tr)).data();

      if (tr == undefined) {
        msgAlerta('Selecione uma nota para gerar.');
        return;
      }

      if (data.CHAVE_CFE != '') {
        msgAlerta('CF-e já foi gerada!');
        return;
      }

      await TransmiteCfe(data);

      $.LoadingOverlay('hide');

    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay('hide');
  }
});

// retorna os pagamentos da nota
async function retornaPagamentos(codvenda) {
  try {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let params = `JSON={ "tabela":"CONDIVENDA",
            "camposSelect": ["SUM(ITCONDIVENDA.VALOR) VALOR", "MOEDA.TIPO", "CONDIVENDA.CDMOEDA", "MOEDA.DESCRICAO", "CONDIVENDA.CDCONDICAO", "MOEDA.TIPO_CARTAO", "CONDICAO.DESCRICAO", "TEF_OPERADORA.COD_SEFAZ"], 
            "where": [" CONDIVENDA.CDVENDA = '${codvenda}' AND CONDIVENDA.EMP_ID = '${getCookie('emp_id')}'"],
            "innerJoin": [
            {"tabela": "ITCONDIVENDA", "CONDICAO": " ITCONDIVENDA.CDCONDIVENDA = CONDIVENDA.CDCONDIVENDA AND ITCONDIVENDA.CDVENDA = CONDIVENDA.CDVENDA AND ITCONDIVENDA.EMP_ID = CONDIVENDA.EMP_ID"}, 
            {"tabela": "MOEDA", "CONDICAO": " MOEDA.CODMOE = ITCONDIVENDA.CDMOEDA "}],
            "leftJoin": [{"tabela": "CONDICAO", "CONDICAO": "CONDICAO.CODCOND = CONDIVENDA.CDCONDICAO "},
            {"tabela": "ENTIDADE", "CONDICAO": "ENTIDADE.CODCLI = MOEDA.CODCLI"},
            {"tabela": "TEF_OPERADORA", "CONDICAO": "TEF_OPERADORA.ID_ENT = ENTIDADE.ID_ENT "}],
            "groupby":  ["MOEDA.TIPO", "MOEDA.TIPO_CARTAO", "CONDIVENDA.CDMOEDA","MOEDA.DESCRICAO", "CONDIVENDA.CDCONDICAO", "CONDICAO.DESCRICAO", "TEF_OPERADORA.COD_SEFAZ"]}`;
    let response = await requisicao('GET', url, params, null, 20000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    return jsonStr.RESULT;

  } catch (error) {
    console.error(error);
  }
}

// retorna os itens da nota
async function retornaItens(id) {
  try {
    let arrayItens = [];
    let itensBusca = await buscaItens(id);

    for (let i = 0; i < itensBusca.RESULT[0].length; i++) {
      const itens = {};

      itens.CODIGO = itensBusca.RESULT[0][i].CODIGO;
      itens.DESCRICAO = itensBusca.RESULT[0][i].DESCRICAO;
      itens.NCM = itensBusca.RESULT[0][i].NCM;
      itens.NATUREZA = itensBusca.RESULT[0][i].NATUREZA;
      itens.UNIDADE = itensBusca.RESULT[0][i].UNIDADE;
      itens.QUANTIDADE = itensBusca.RESULT[0][i].QUANTIDADE;
      itens.PRECO = itensBusca.RESULT[0][i].PRECO;
      itens.VALOR = itensBusca.RESULT[0][i].VALOR;
      itens.DESCONTO = itensBusca.RESULT[0][i].DESCONTO;
      itens.VALOROUTROS = itensBusca.RESULT[0][i].VALOR_OUTROS;
      itens.VALORLIQ = itensBusca.RESULT[0][i].VALOR_LIQ;
      itens.VALORIMPOSTO = itensBusca.RESULT[0][i].VALOR_IMPOSTO;
      itens.CLATRIB = itensBusca.RESULT[0][i].CLA_TRIB;
      itens.PERCICMS = itensBusca.RESULT[0][i].PERC_ICMS;
      itens.VALORICMS = itensBusca.RESULT[0][i].VALOR_ICMS;
      itens.CLAPIS = itensBusca.RESULT[0][i].CLA_PIS;
      itens.NATUREZAPISCOFINS = itensBusca.RESULT[0][i].PIS_COFINS;
      itens.VALORPIS = itensBusca.RESULT[0][i].VALOR_PIS;
      itens.PERCPIS = itensBusca.RESULT[0][i].PERC_PIS;
      itens.BASEPISCOFINS = itensBusca.RESULT[0][i].BASE_PIS_COFINS;
      itens.CLACOFINS = itensBusca.RESULT[0][i].CLA_COFINS;
      itens.VALORCOFINS = itensBusca.RESULT[0][i].VALOR_COFINS;
      itens.PERCCOFINS = itensBusca.RESULT[0][i].PERC_COFINS;

      arrayItens.push(itens);
    }


    return arrayItens;

  } catch (error) {
    console.error(error);
    msgErro('Erro ao retornar itens, Erro: ');
  }
}

// retorna a informacao da empresa
async function retornaInformacaoEmpresa() {
  try {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let response = await requisicao('GET', url, `JSON={ "tabela":"empresa", "camposSelect":["emp_inscr_municipal", "emp_inscricao", "emp_cnpj", "emp_pat", "emp_fantasia", "emp_endereco", "emp_numero", "emp_bairro", "emp_cidade", "emp_cep", "emp_crt"], "where": ["emp_id = ${getCookie('emp_id')}"] }`, null);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }


    return jsonStr.RESULT[0][0];

  } catch (error) {
    console.error(error);
    msgErro('Erro ao retornar dados da empresa, Erro: ');
  }
}

// preenche o objeto quando vem da converter venda, gerar manualmente e cancelar
async function preencheObjeto(objeto) {
  let cfe = {};
  let cliente = {};
  let arrayItens = [];
  let arrayPagamentos = [];

  arrayItens = await retornaItens(objeto.ID);
  arrayPagamentos = await retornaPagamentos(objeto.CODVEN);
  cliente.NOME = objeto.CLIENTE_NOME;
  cliente.CNPJ = objeto.CLIENTE_CNPJ;

  cfe.FATURA = objeto.FATURA;
  cfe.CNPJ = objeto.CNPJ;
  cfe.SERIE = objeto.SERIE_SAT;
  cfe.CUPOM = objeto.NRCUPOM;
  cfe.CODUF = objeto.CODUF;
  cfe.CLIENTE = cliente;
  cfe.CAIXA = objeto.CAIXA;
  cfe.ITENS = arrayItens;
  cfe.VALOR = objeto.VALOR;
  cfe.VALORIMPOSTO = objeto.VALOR_IMPOSTO;
  // eslint-disable-next-line prefer-destructuring
  cfe.PAGAMENTOS = arrayPagamentos[0];
  cfe.INFORMACAOCOMPLEMENTAR = objeto.INF_COMPL;
  cfe.VALORICMS = objeto.VALOR_ICMS;
  cfe.VALORLIQUIDO = objeto.VALOR_LIQ;
  cfe.DESCONTO = objeto.DESCONTO;
  cfe.VALORPIS = objeto.VALOR_PIS;
  cfe.VALORCOFINS = objeto.VALOR_COFINS;
  cfe.ID = objeto.ID;

  return cfe;
}

// botao de cancelar CFE
$('#btnCancelar').on('click', async function () {

  if (await verificaParametroCFE()) {
    return;
  }

  if (!await testeConexao()) {
    msgAlerta('Não está conectado a Api Local!');
    return;
  }
  let tr = $('#tabelaCFE tr.selected')[0];
  let data = $('#tabelaCFE').DataTable().row($(tr)).data();

  if (tr == undefined) {
    msgAlerta('Nenhuma nota selecionada, impossível continuar.');
    return;
  }

  if (data.IMPRESSO == 'C') {
    msgAlerta('CF-e já está cancelada!');
    return;
  }
  $('#txtCancFatura').val(data.FATURA);
  $('#txtCancSerie').val(data.SERIE_SAT);
  $('#modal-cancelamento').modal('show');

});

// confirma o cancelamento
$('#btn-confirmar-cancelamento').on('click', async function () {
  msgAlerta('Deseja realmente cancelar esse registro?', cancelaCFE);
});

async function atualizaCFEcancelada(cfe) {
  try {
    const url = '/sisplan/cfe/v1/cfe?';

    const response = await requisicao('DELETE', url, `CHAVE_CANC=NAO_APAGAR&JSON=${encodeURIComponent(JSON.stringify(cfe))}`, '', 15000);

    if (!response) {
      return;
    }

    // const jsonStr = await response.json();
    if (response.status != 200) {
      // msgErro(jsonStr.mensagem);
      return;
    }
  } catch (error) {
    console.error(error);
  }
}

async function validaSeEstaCancelada(objeto) {

  if (!objeto.id) {
    return true;
  }

  const dadosSelect = {
    tabela: `cfe`,
    camposSelect: [`ID, CHAVE_CANC`],
    where: [`ID = '${objeto.id}' AND EMP_ID = '${getCookie('emp_id')}'`],
  };
  const retornoSelect = await retornaJsonPesquisaPadrao(
    JSON.stringify(dadosSelect)
  );

  if (retornoSelect) {
    if (retornoSelect[0].CHAVE_CANC == '') {
      return false;
    }
    return true;
  }

  return true;
}

async function cancelaCFE() {
  try {
    $.LoadingOverlay("show");
    try {
      let tr = $('#tabelaCFE tr.selected')[0];
      let data = $('#tabelaCFE').DataTable().row($(tr)).data();
      let objetoCancelarCFe = {};
      let response;
      let url = '/cfe/cfe?';

      objetoCancelarCFe = await preencheObjeto(data);
      objetoCancelarCFe.empresadao = await retornaInformacaoEmpresa();


      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        if (data.CHAVE_CFE == '') {
          response = await requisicao('PUT', '/sisplan/cfe/v1/cancelarcfesistema?', `ID=${objetoCancelarCFe.ID}`, '', 60000);
        } else {
          response = await requisicaoSat('PUT', url, `CHAVE_CFE=${data.CHAVE_CFE}`, JSON.stringify(objetoCancelarCFe), 60000);
        }
      } else {
        response = await requisicao_ecf('PUT', url, `CHAVE_CFE=${data.CHAVE_CFE}`, JSON.stringify(objetoCancelarCFe), 60000);
      }

      if (!response) {
        msgErro('Erro ao cancelar CF-e');
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem.mensagem);
        return;
      }
      if (!await validaSeEstaCancelada(jsonStr) || jsonStr.mensagem == 'OK') {

        toastr.success(
          'Cancelamento efetuado com sucesso!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            await atualizaCFEcancelada(jsonStr);
            $('#modal-cancelamento').modal('hide');
            $.LoadingOverlay('show');
            setTimeout(() => {
              $('#btn-consultar').trigger('click');
              $.LoadingOverlay('hide');
            }, 5000);
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      } else {
        msgAlerta('CF-e já consta como cancelada no banco!');
        $('#modal-cancelamento').modal('hide');
        $('#btn-consultar').trigger('click');
      }
    } catch (error) {
      console.error(error);
      msgErro('Erro ao cancelar CFE!');
    }
  } finally {
    $.LoadingOverlay("hide");
    $('#modal-cancelamento').modal('hide');
  }
}


// exclui CFE
$('#btnExcluir').on('click', async function () {
  if (await verificaParametroCFE()) {
    return;
  }
  if (!await testeConexao()) {
    msgAlerta('Não está conectado a Api Local!');
    return;
  }
  let tr = $('#tabelaCFE tr.selected')[0];
  if (tr == undefined) {
    msgAlerta('Nenhuma nota selecionada, impossível continuar.');
    return;
  }

  msgAlerta('Deseja realmente excluir esse registro?', deletaCFE);
});


// deleta a nota
async function deletaCFE() {
  try {
    $.LoadingOverlay("show");
    try {
      let tr = $('#tabelaCFE tr.selected')[0];
      let data = $('#tabelaCFE').DataTable().row($(tr)).data();
      cfe = await preencheObjeto(data);
      let url = '/cfe/cfe?';
      let response;
      cfe.empresadao = await retornaInformacaoEmpresa();
      objetoCancelarCFe = await preencheObjeto(data);


      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        response = await requisicaoSat('DELETE', url, '', JSON.stringify(cfe), 60000);
      } else {
        response = await requisicao_ecf('DELETE', url, '', JSON.stringify(cfe), 60000);
      }
      if (!response) {
        return;
      }

      
      if (response.status != 200) {
        const jsonStr = await response.json();
        msgErro(jsonStr.mensagem.mensagem);
        return;
      }

      toastr.success(
        'Exclusão efetuada com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#btn-consultar').trigger('click');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (error) {
      console.error(error);
      msgErro('Erro ao deletar CFE');
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

// imprimir
$('#btnImprimirCFe').on('click', async function () {
  try {
    if (await verificaParametroCFE()) {
      return;
    }
    if (!await testeConexao()) {
      msgAlerta('Não está conectado a Api Local!');
      return;
    }
    $.LoadingOverlay('show');
    let tr = $('#tabelaCFE tr.selected')[0];
    let data = $('#tabelaCFE').DataTable().row($(tr)).data();
    if (tr == undefined) {
      msgAlerta('Nenhuma nota selecionada, impossível continuar.');
      return;
    }

    let id = data.ID;

    try {
      let url = `/Sisplan/impressao/v1/CFE?ID=${id}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('CFE');
      let arquivo = await GeraRelatorio(`${url}&`, 'GET', 15000, false, 'CFE');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
        $('#btn-consultar').trigger('click');
      }
    } catch (error) {
      console.error(error);

    }
  } finally {
    $.LoadingOverlay('hide');
    $('#dropdown-menu').removeClass("show");
  }
});

$('#btnImprimir').on('click', async function() {
  if ($("#dropdown-menu")[0].classList[1] != "show") {
    $('#dropdown-menu').addClass("show");
  } else {
    $('#dropdown-menu').removeClass("show");
  }
});

$('#btnImprimirBoleto').on('click', async function() {
  await imprimirBoleto();
});

$('#btn-log').on('click', async function () {
  try {
    $.LoadingOverlay('show');
    try {
      if (await verificaParametroCFE()) {
        return;
      }
      if (!await testeConexao()) {
        msgAlerta('Não está conectado a Api Local!');
        return;
      }
      const url = '/cfe/cfelog?';
      let response;
      paramUtiliza = await CopiaParametro('VENDA', 18);
      let cfe = {};
      cfe.id = 0;
      cfe.empresadao = await retornaInformacaoEmpresa();

      let params = `PARAMETRO=${paramUtiliza}`;


      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        response = await requisicaoSat('PUT', url, params, JSON.stringify(cfe), null);
      } else {
        response = await requisicao_ecf('PUT', url, params, JSON.stringify(cfe), null);
      }
      if (!response) {
        return;
      }

      if (response.status == 200) {

        toastr.success(
          'Log gerado com sucesso na pasta raiz!',
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      } else {
        let jsonLog = await response.json();
        msgAlerta(jsonLog.RESULT[0][0].mensagem);
      }

    } catch (error) {
      console.error(error);
      msgErro('Erro ao gerar log!');
    }
  } finally {
    $.LoadingOverlay('hide');
  }
});

async function imprimirBoleto(transmitir = 'N') {
  const fatura = `${$('#txtCodVen').val()}C`;

  if (fatura.trim() == 'C') {
    msgAlerta('Nenhuma CF-e selecionada, impossível continuar.');
    return;
  }
  var url = `/sisplan/impressao/v1/imprimirboletofat?FATURA=${fatura}&TRANSMITIR=${transmitir}&EMAIL=N`;
  try {
    $.LoadingOverlay("show");
    try {
      const bImprimeAutomatico = await verificaImprimirAutomatico('Boleto');
      var arquivo = await GeraRelatorio(url + '&', 'GET', 1000000, false, 'Boleto');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
    $('#dropdown-menu').removeClass("show");
  }
}

// selecao do datatable
$('#tabelaCFE tbody').on('click', 'tr', async function () {
  if ($(this).hasClass('selected')) {
    $(this).removeClass('selected');
  } else {
    $('#tabelaCFE').DataTable().$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
    if ($('#tabelaCFE').DataTable().rows().count() == 0) {
      $('#txtNumeroCF').val('');
      $('#txtEmissaoCF').val('');
      $('#txtCodVen').val('');
      $('#txtChaveCF').val('');
      $('#txtChaveCanc').val('');
    } else {
      let data = $('#tabelaCFE').DataTable().row($(this)).data();
      $('#txtNumeroCF').val(data.FATURA);
      $('#txtSerieCF').val(data.SERIE_SAT);
      $('#txtEmissaoCF').val(data.DT_EMISSAO);
      $('#txtCodVen').val(data.CODVEN);
      $('#txtChaveCF').val(data.CHAVE_CFE);
      $('#txtChaveCanc').val(data.CHAVE_CANC);
    }
  }
});

$('#gerarStatus').on('click', async function () {
  try {
    $.LoadingOverlay('show');
    try {
      if (!await testeConexao()) {
        msgAlerta('Não está conectado a Api Local!');
        return;
      }
      paramUtiliza = await CopiaParametro('VENDA', 18);
      const url = '/cfe/gerastatus?';
      let response;
      const cfe = {
        id: 0,
        empresadao: await retornaInformacaoEmpresa(),
      };

      if ((paramUtiliza == '3') || (paramUtiliza == '1')) {
        response = await requisicaoSat('POST', url, `PARAMETRO=${paramUtiliza}&CARREGACONFIG=N`, JSON.stringify(cfe), 30000);
      } else {
        response = await requisicao_ecf('POST', url, `PARAMETRO=${paramUtiliza}`, JSON.stringify(cfe), 30000);
      }
      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      if (response.status == 200) {
        toastr.success(
          `Status gerado no caminho ${jsonStr.caminho}`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay('hide');
  }
});


 setarDataAtual('txtDataAte');
 setarDataAtual('txtDataDe');

$('.collapse').on('shown.bs.collapse', function (e) {
  let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

  clicked
    .parent()
    .find(".fa-angle-right")
    .removeClass("fa-angle-right")
    .addClass("fa-angle-down");
})
  .on('hidden.bs.collapse', function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

    clicked
      .parent()
      .find(".fa-angle-down")
      .removeClass("fa-angle-down")
      .addClass("fa-angle-right");
  });

// consulta quando abre a tela
$('#btn-consultar').trigger('click');