$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um Cheque.",
          position: "right",
        },
      },
      {
        element: "#tabelaCheque",
        popover: {
          title: "Tabela Cheque",
          description: "Aqui estão os dados dos cheques cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  const permissaoUsuarioLogado = await permissaoAcessos("CHEQUE");

  await consultaCheque();
  await filtrosConsultaCheque();

  async function filtrosConsultaCheque() {
    //AUTOCOMPLETE
    $('#txtCliente').autocompleta(1, `JSON={ "tabela": "ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null }`);
    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela": "REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null }`);
    $('#txtHistorico').autocompleta(1, `JSON={ "tabela": "HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);
    $('#txtClasse').autocompleta(1, `JSON={ "tabela": "CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);
    $('#txtSituacao').autocompleta(1, `JSON={ "tabela": "TABSIT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);

    //SEARCH ALL    
    $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
    $("#btnRepresentante").pesquisa_serverside(["#txtRepresentante"], ["CODREP"], ["NOME"], '{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}', "Pesquisa Representante");
    $("#btnHistorico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}`, "Pesquisa Histórico", "HISTCP");
    $("#btnClasse").pesquisa("#txtClasse", "CODIGO", "DESCRICAO", `/sipslan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, "Pesquisa Classe Gerencial", "CLASSE_GER")
    $('#btnSituacao').pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSIT", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, "Pesquisa Situação", "TABSIT")
  }

  //CLEAN INDIVIDUALLY FILTERS
  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });
  $('#btnLimpaRepresentante').on('click', function () {
    $('#txtRepresentante').val('');
  });
  $('#btnLimpaHistorico').on('click', function () {
    $('#txtHistorico').val('');
  });
  $('#btnLimpaClasse').on('click', function () {
    $('#txtClasse').val('');
  });
  $('#btnLimpaSituacao').on('click', function () {
    $('#txtSituacao').val('');
  });

  //CLEAN ALL FILTERS
  function limparFiltros() {
    $('#txtCliente').val('');
    $('#txtRepresentante').val('');
    $('#txtHistorico').val('');
    $('#txtClasse').val('');
    $('#txtSituacao').val('');
  }

  $('#btnLimparFiltros').on('click', function () {
    limparFiltros();
  })

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show')
  })

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = `cheque/create`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaCheque();
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  async function consultaCheque() {
    try {
      $.LoadingOverlay("show");

      const sCampos = await montaFieldsSelect();
      const sLigacao = await montaJoin();
      const sWhere = await montaWhere();

      let dataSetCols = [];

      for (let i = 0; i < sCampos.columns.length; i++) {
        dataSetCols.push({
          'title': sCampos.columns[i],
          'data': i
        });
      }

      const ajaxData = {
        "EMPRESA": getCookie('empresa'),
        "JSON": `{"tabela":"RECEBER", "camposSelect": ${sCampos.fields}, "leftJoin": [${sLigacao}], "where": ["${sWhere}"]}`,
      };

      $("#tabelaCheque").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ordering: false,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: ajaxData,
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };

  async function montaJoin() {
    let join = "";

    join = `{ "tabela": "ENTIDADE", "condicao": "CLIENTE.CODCLI = RECEBER.CODCLI", "alias": "CLIENTE" },
      { "tabela": "REPRESEN", "condicao": "REP.CODREP = RECEBER.CODREP", "alias": "REP" },
      { "tabela": "HISTCP", "condicao": "HIST.HISTORICO = CLIENTE.HISTORICO", "alias": "HIST" },
      { "tabela": "TABSIT", "condicao": "SIT.CODIGO = RECEBER.SITUACAO", "alias": "SIT" },
      { "tabela": "CLASSE_GER", "condicao": "CLASSE.CODIGO = RECEBER.CLASSE", "alias": "CLASSE" },
      { "tabela": "CADCEP", "condicao": "CEP.CEP = CLIENTE.CEP", "alias": "CEP" },
      { "tabela": "CIDADE", "condicao": "CIDADE.CODIGO = CEP.CODMUN", "alias": "CIDADE" }`;

    return join;
  }

  async function montaFieldsSelect() {
    let fields = [];
    let columns = [];

    fields = `[
      "RECEBER.NUMERO_CH", "RECEBER.CODCLI CLIENTE", "CLIENTE.NOME", "RECEBER.NUMERO", "RECEBER.DT_VENCTO VENCTO", "CLIENTE.ENDERECO", "CLIENTE.NUMERO END_NUM", "CLIENTE.BAIRRO",
      "CLIENTE.CEP", "CIDADE.NOME CIDADE", "CIDADE.COD_UF", "RECEBER.CODREP REPRESENTANTE", "REP.NOME NOME_REP", "HIST.HISTORICO",
      "HIST.DESCRICAO DESC_HIST", "SIT.CODIGO SITUACAO", "SIT.DESCRICAO DESC_SIT", "CLASSE.CODIGO CLASSE", "CLASSE.DESCRICAO DESC_CLASSE",
      "RECEBER.BANCO_CH BANCO", "RECEBER.CONTA_CH CONTA", "RECEBER.AGENCIA_CH AGENCIA", "RECEBER.DT_EMISSAO EMISSAO",
      "RECEBER.VALOR", "RECEBER.EMISSOR_CH EMISSOR", "RECEBER.CNPJ_CH CNPJ_EMI"
    ]`

    columns = [
      "NUMERO_CH", "CLIENTE", "NOME", "NUMERO", "VENCTO", "ENDERECO", "END_NUM", "BAIRRO", "CEP", "CIDADE", "COD_UF", "REPRESENTANTE", "NOME_REP", "HISTORICO",
      "DESC_HIST", "SITUACAO", "DESC_SIT", "CLASSE", "DESC_CLASSE", "BANCO", "CONTA", "AGENCIA", "EMISSAO", "VALOR",
      "EMISSOR", "CNPJ_EMI"
    ];

    const objeto = {
      fields: fields,
      columns: columns
    }

    return objeto;
  }

  async function montaWhere() {
    let where = '';

    where += `RECEBER.STATUS = 'CHEQ'`;
    where += pegaChave('#txtCliente') != '' ? ` AND RECEBER.CODCLI = '${pegaChave('#txtCliente')}'` : '';
    where += pegaChave('#txtRepresentante') != '' ? ` AND RECEBER.CODREP = '${pegaChave('#txtRepresentante')}'` : '';
    where += pegaChave('#txtHistorico') != '' ? ` AND HIST.HISTORICO = '${pegaChave('#txtHistorico')}'` : '';
    where += pegaChave('#txtClasse') != '' ? ` AND CLASSE.CODIGO = '${pegaChave('#txtClasse')}'` : '';
    where += pegaChave('#txtSituacao') != '' ? ` AND SIT.CODIGO = '${pegaChave('#txtSituacao')}'` : '';
    where += ` AND RECEBER.NUMERO LIKE '[PERCENTUAL]${$('#txtNumero').val()}[PERCENTUAL]'`;

    return where;
  }

  $('#tabelaCheque').on('click', '#btn-excluir', async function () {

    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCheque").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cheque?", `NUMERO_CH=${encodeURIComponent(valorLinha[0])}&NUMERO=${encodeURIComponent(valorLinha[3])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

});