$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para filtrar a consulta da tabela de LOG.',
        position: 'right'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(function () {
  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnLimparFiltros").on("click", function () {
    LimpaCamposFiltro();
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaLogs();
  });

  $("#txtEmpresa").autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave", "emp_nome descricao"], "where": null}`);
  $("#btn-empresa").pesquisa("#txtEmpresa", "EMP_PAT", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"empresa", "camposSelect":[ "EMP_PAT", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");
  $("#btn-limpa-empresa").on("click", function () {
    $("#txtEmpresa").val('');
  });

  function LimpaCamposFiltro() {
    $("#txtUsuario").val("");
    $("#txtEmpresa").val("");
    $("#txtAcao").val("");
    $("#txtTela").val("");
    $("#txtForm").val("");
    $('#txtDataIni').val('1200-01-01');
    $('#txtDataFim').val('2500-12-01');
  };

  async function ConsultaLogs() {
    try {
      let dataSetCols = [];
      $.LoadingOverlay("show");
      let filtros = '1=1';
      filtros += $('#txtUsuario').val() != '' ? ` AND LOG.USUARIO = '${$('#txtUsuario').val()}'` : '';
      filtros += pegaChave('#txtEmpresa') != '' ? ` AND LOG.EMPRESA = '${pegaChave('#txtEmpresa')}'` : '';
      filtros += $('#txtAcao').val() != '' ? ` AND LOG.DESCRICAO LIKE '[PERCENTUAL]${$('#txtAcao').val()}[PERCENTUAL]'` : '';
      filtros += $('#txtTela').val() != '' ? ` AND LOG.TELA LIKE '[PERCENTUAL]${$('#txtTela').val()}[PERCENTUAL]'` : '';
      filtros += $('#txtForm').val() != '' ? ` AND LOG.FORM LIKE '[PERCENTUAL]${$('#txtForm').val()}[PERCENTUAL]'` : '';
      filtros += ` AND LOG.DATA [MAIORQUE] '` + $('#txtDataIni').val() + `'`;
      filtros += ` AND LOG.DATA [MENORQUE] '` + $('#txtDataFim').val() + `'`;

      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/V1/pesquisa?",
        `JSON={"tabela":"LOG", 
               "camposSelect":["LOG.CHAVE", "LOG.DATA", "LOG.DESCRICAO", "LOG.EMPRESA", "LOG.HORA", "LOG.OPERACAO", 
                               "LOG.TELA", "LOG.USUARIO", "LOG.FORM"], 
               "where": ["${filtros}"]}`, null
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      jsonStr = jsonStr.RESULT[0];

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      // dataSetCols[1].type = 'date-br';
      // dataSetCols[1].render = function (data, type, row) {
      //   return $.datepicker.formatDate("dd/mm/yy", new Date(data));
      // }
      dataSetCols[4].type = 'date-br';
      dataSetCols[4].render = function (data, type, row) {
        return $.datepicker.formatDate("dd/mm/yy", new Date(data)) + row['HORA'].slice(10);
      }

      $('#tabelaLogs').DataTable({
        destroy: true,
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        autoWidth: true,
        data: jsonStr,
        columns: dataSetCols,
        columnDefs: [{
          render: $.fn.dataTable.render.moment('DD/MM/YYYY'),
          targets: 1,
        }]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };
});