$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $("#btnFiltros").on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#txtUsuario').autocompleta(1, `JSON={ "tabela":"acesso_usuarios", "camposSelect":[ "codigo chave", "nome descricao"], "where": ["CODIGO <> '9999'"]}`);
  $('#btnUsuario').pesquisa('#txtUsuario', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"acesso_usuarios", "camposSelect":[ "CODIGO", "NOME"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Usuários', 'acesso_usuarios');
  $('#btn-Limpa-usuario').on('click', function () {
    $('#txtUsuario').val('');
  });

  $('#txtCaixa').autocompleta(1, `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "codigo chave", "descricao"], "where": []}`);
  $('#btnCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["CODIGO <> '9999'"]}`, 'Pesquisa Caixa', 'CAIXA_LOJA');
  $('#btn-Limpa-caixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtCaixa').val('');
    $('#txtUsuario').val('');
  });

  $('#btnConsultar').on('click', async function () {
    await buscarDados();
  });

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>     ' +
      '    <button class="botaoOpcoes" type="button" title="Imprimir" id="btn-imprimirItem"><span class="fas fa-print" style="color:green"></span>  </button>' +
      "</div>"
    );
  }

  async function buscarDados() {
    try {
      $.LoadingOverlay("show");
      const usuario = pegaChave('#txtUsuario') != '' ? ` AND CONF_CAIXA.USUARIO = '${pegaChave('#txtUsuario')}'` : '';
      const caixa = pegaChave('#txtCaixa') != '' ? ` AND CONF_CAIXA.CAIXA = '${pegaChave('#txtCaixa')}'` : '';
      const data = $('#txtPeriodo').val() != '' ? ` AND CONF_CAIXA.PERIODO = '${$('#txtPeriodo').val()}'` : '';
      const empId = getCookie('emp_id');

      const objetoPesquisa = {
        tabela: "CONF_CAIXA",
        camposSelect: ["CONF_CAIXA.CAIXA", "CAIXA_LOJA.DESCRICAO DESC_CAIXA", "CONF_CAIXA.USUARIO", "ACESSO_USUARIOS.NOME", "CONF_CAIXA.PERIODO", "'' ACOES"],
        leftJoin: [{ tabela: "CAIXA_LOJA", condicao: "CAIXA_LOJA.CODIGO = CONF_CAIXA.CAIXA" },
        { tabela: "ACESSO_USUARIOS", condicao: "ACESSO_USUARIOS.CODIGO = CONF_CAIXA.USUARIO" }],
        where: [`CONF_CAIXA.EMP_ID = ${empId} ${usuario} ${caixa} ${data}`],
        groupBy: ["CONF_CAIXA.CAIXA", "CAIXA_LOJA.DESCRICAO", "CONF_CAIXA.USUARIO", "ACESSO_USUARIOS.NOME", "CONF_CAIXA.PERIODO"],
        orderBy: ["CONF_CAIXA.PERIODO DESC"]
      }

      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON=${JSON.stringify(objetoPesquisa)}`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaContagens").DataTable({
        destroy: true,
        lengthChange: false,
        order: false,
        search: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CAIXA",
          },
          {
            data: "DESC_CAIXA",
          },
          {
            data: "USUARIO",
          },
          {
            data: "NOME",
          },
          {
            data: "PERIODO",
          },
          {
            data: "AÇÕES",
          },
        ],
        columnDefs: [
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 4,
          },
          {
            targets: -1,
            data: null,
            className: "tdBtnOpcoes",
            defaultContent: retornaBotaoOpcoes(),
          },
        ],
      });

      $("#tabelaContagens").on("click", "#btn-editar", async function () {
        const rotina = async () => {
          const data = $("#tabelaContagens").DataTable().row($(this).parents("tr")).data();
          const empId = getCookie('emp_id');
          const objeto = {
            caixa: data.CAIXA,
            desc_caixa: data.DESC_CAIXA,
            usuario: data.USUARIO,
            nome: data.NOME,
            periodo: data.PERIODO,
            emp_id: empId,
          }
          if (await reabreCaixa(data)) {
            const base64 = btoa(JSON.stringify(objeto));
            window.location.href = `contagem_caixa/${base64}`;
          }
        }
        await senhaSupervisor(
          `Necessário senha de supervisor para alterar uma contagem.`,
          () => rotina());
      });

      $("#tabelaContagens").on("dblclick", "tr", async function () {
        const data = $("#tabelaContagens").DataTable().row($(this).parents("tr")).data();
        const empId = getCookie('emp_id');
        const objeto = {
          caixa: data.CAIXA,
          desc_caixa: data.DESC_CAIXA,
          usuario: data.USUARIO,
          nome: data.NOME,
          periodo: data.PERIODO,
          emp_id: empId,
        }
        const base64 = btoa(JSON.stringify(objeto));
        window.location.href = `contagem_caixa/${base64}`;
      });

      $('#tabelaContagens').on('click', '#btn-imprimirItem', async function () {
        $.LoadingOverlay('show');
        try {
          const data = $('#tabelaContagens').DataTable().row($(this).parents('tr')).data();
          const url = `/sisplan/impressao/v1/acesso_contagem_caixa?`;

          const filtros = retornaFiltros(data);
          const ordem = `&TELA_ORDENACAO=acesso_contagem_caixa&ORDEM_ORDENACAO=1`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('RelContagemCaixaA');
          let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelContagemCaixaA');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }

        } catch (error) {
          console.error(error);
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      function retornaFiltros(tabela) {
        const filtros = `PERIODO=${tabela.PERIODO}` +
          `&CAIXA=${tabela.CAIXA}` +
          `&CODIGO_USUARIO=${tabela.USUARIO}` +
          `&EMP_ID=${getCookie('emp_id')}`;

        return filtros;
      };

      $('#modal-filtros').modal('hide');

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  buscarDados();

  async function reabreCaixa(tabela) {
    try {
      $.LoadingOverlay("show");

      const caixa = tabela.CAIXA;
      const data = tabela.PERIODO;
      let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
        `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${data}&REABRIR=True`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        if (jsonStr.mensagem != 'Fechamento de caixa não efetuado.') {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.mensagem);
          return;
        } else {
          return true;
        }
      } else {
        return true;
      }

      $.LoadingOverlay("hide");
    } catch (error) {
      console.log(error)
      $.LoadingOverlay("hide");
    }
  }
});
