$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtras as cores cadastradas.",
          position: "right",
        },
      },
      {
        element: "#btnNovaCor",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de uma cor.",
          position: "right",
        },
      },
      {
        element: "#tabelaCor",
        popover: {
          title: "Tabela Cores",
          description: "Aqui estão todas as cores cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("COR");
  let caminhoFoto = 'dist/img/prod-1.png';
  let encontrouFoto = 0;

  // autocompleta
  $("#txtGrupoCorConsulta").autocompleta(
    1,
    `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtCorConsulta").autocompleta(
    1,
    `JSON={ "tabela":"cadcor", "camposSelect":[ "cor chave", "descricao descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-GrupoCor").pesquisa(
    "#txtGrupoCorConsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Grupo Cor",
    "GRUPO_COR"
  );
  $("#btn-Cor").pesquisa(
    "#txtCorConsulta",
    "COR",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":[ "cor", "descricao"]}`,
    "Pesquisa Cor",
    "cadcor"
  );
  // limpacampo
  $("#btn-limpa-Cor").on("click", function () {
    $("#txtCorConsulta").val("");
  });

  $("#btn-limpa-GrupoCor").on("click", function () {
    $("#txtGrupoCorConsulta").val("");
  });


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  function retornaCampoRGB(rgb) {
    const r = rgb.substring(0, 3);
    const g = rgb.substring(3, 6);
    const b = rgb.substring(6, 9);

    const hexR = ("0" + parseInt(r, 10).toString(16)).slice(-2);
    const hexG = ("0" + parseInt(g, 10).toString(16)).slice(-2);
    const hexB = ("0" + parseInt(b, 10).toString(16)).slice(-2);

    const hex = '#' + hexR + hexG + hexB;

    var retorno = '<div class="form-group" style="margin-bottom: 0.2rem !important; margin-top: 0.2rem !important"> ' +
      `     <input type="color" disabled class="input-default" value="${hex}" id="inputColorRGBAcesso"></input>` +
      '</div>';

    return retorno;
  };

  await ConsultaCor();

  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovaCor").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cor/Y3JlYXRl";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaCor(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtCorConsulta").val("");
    $("#txtGrupoCorConsulta").val("");
  });

  async function buscaFotoCor(corBusca) {
    const responsej = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
    if (!responsej) {
      return;
    };
    const jsonStr = await responsej.json();
    const pastaFoto = jsonStr.mensagem;
    const pastaCor = pastaFoto + '\\COR\\';
    try {
      const urlRequisicao = '/Sisplan/Funcoes/v1/fotocor?';
      const response = await requisicao('GET', urlRequisicao, `CODIGO=${corBusca}&PDIRETORIOSALVAR=${pastaCor}&NOMEARQUIVO=${corBusca}.jpg`, null);

      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        $(`#imgFoto${corBusca}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        return;
      }

      const sBase64 = jsonStr;
      $(`#imgFoto${corBusca}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
      console.error(error);
      $(`#imgFoto${corBusca}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  };

  async function ConsultaCor(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let cor =
        pegaChave("#txtCorConsulta") != ""
          ? ` AND COR = '${pegaChave("#txtCorConsulta")}'`
          : "";
      let grupoCor =
        pegaChave("#txtGrupoCorConsulta") != ""
          ? ` AND GRUPO = '${pegaChave("#txtGrupoCorConsulta")}'`
          : "";

      $("#tabelaCor").DataTable({
        paging: true,
        lengthChange: true,
        serverSide: true,
        filter: false,
        destroy: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{"tabela":"CADCOR", "camposSelect":[ "CADCOR.COR", "CADCOR.DESCRICAO", "CADCOR.RGB", "CADCOR.SEQ AS FOTO", "CADCOR.INATIVO"], "where": ["1=1 ${cor} ${grupoCor}"]}`,
            CLIENTE: "N",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(row[0]);
            }
          },
          {
            targets: [2], render: function (data, type, row) {
              return retornaCampoRGB(row[2]);
            }
          },
          {
            targets: [3], render: function (data, type, row) {
              buscaFotoCor(row[0]);
              return `<div class="form-group" style="display: flex; justify-content: center; align-items: center;">`+`<img class="pop img img-fluid imagem" height="50" width="50" id="imgFoto${row[0]}" src="dist/img/prod-1.png" style="max-width: 50px; max-height: 50px;">`+`</div>`;
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaCor").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaCor").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("COR", data[0]);
      if (registroLiberado) {
        window.location.href = `cor/${btoa(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaCor").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaCor").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("COR", data[0]);
      if (registroLiberado) {
        window.location.href = `cor/${btoa(data[0])}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaCor').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCor").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cadcor?", `CODIGOCADCOR=${encodeURIComponent(data.data()[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
