$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um CST PIS.",
          position: "right",
        },
      },
      {
        element: "#tabelaCSTPIS",
        popover: {
          title: "Tabela CST PIS",
          description: "Aqui estão os dados dos CST PIS cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CSTPIS");

  // autocompleta
  $("#txtCSTPISConsulta").autocompleta(
    1,
    `JSON={ "tabela":"tabpis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-CSTPIS").pesquisa(
    "#txtCSTPISConsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabpis", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa CST PIS",
    "tabpis"
  );
  // limpacampo
  $("#btn-limpa-CSTPIS").on("click", function () {
    $("#txtCSTPISConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cstpis/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>   ' +
        '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
        '</div>';
    return retorno;
};

  ConsultarCSTPIS();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultarCSTPIS(true);
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtCSTPISConsulta").val("");
  });

  async function ConsultarCSTPIS(bBotao = false) {
    try {
      $.LoadingOverlay("show");
      let response;
      let cstpis =
        pegaChave("#txtCSTPISConsulta") != ""
          ? ` AND CODIGO = '${pegaChave("#txtCSTPISConsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"tabpis", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${cstpis}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"tabpis", "camposSelect":[ "codigo", "descricao"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaCSTPIS").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
          },
          {
            data: "DESCRICAO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
          }
        },
        ],
      });

      $("#tabelaCSTPIS").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaCSTPIS")
            .DataTable()
            .row($(this).parents("tr"))
            .data();
          let registroLiberado = await verificarRegistro("CSTPIS", data.CODIGO);
          if (registroLiberado) {
            window.location.href = `cstpis/${data.CODIGO}`;
          }
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $("#tabelaCSTPIS").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaCSTPIS").DataTable().row($(this)).data();
          let registroLiberado = await verificarRegistro("CSTPIS", data.CODIGO);
          if (registroLiberado) {
            window.location.href = `cstpis/${data.CODIGO}`;
          }
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#tabelaCSTPIS').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCSTPIS").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/cstpis?", `CODIGOCSTPIS=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
