<?php include_once('../../config.php') ?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Loja</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.239.11.1">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="../plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.239.11.1">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="../plugins/daterangepicker/daterangepicker.css?versao=3.239.11.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="../dist/css/animate.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.239.11.1">
  <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/highlight.js/10.7.2/styles/default.min.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.239.11.1" />
  <link rel="shortcut icon" href="../favicon.ico">
  <link href="../dist/css/jquery.gridly.css" rel="stylesheet" type="text/css?versao=3.239.11.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.239.11.1'>
  <link rel="stylesheet" href="../dist/css/normalize.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../plugins/select2/css/select2.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.239.11.1">
  <style type="text/css">
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    .select2-container--default .select2-selection--single {
      height: 38px !important;
    }

    #area-graficos {
      text-align: center;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .gridly {
      margin-left: auto;
      margin-right: auto;
      position: relative;
      width: 960px;
      background-color: rgb(255 255 255 / 2%);
    }

    .quadrados {
      display: flex;
      align-items: center;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
      color: black;
    }

    .quadrado {
      cursor: pointer;
      margin-right: 20px;
      margin-top: 5px;
      height: 80px;
      width: 140px;
      background-color: var(--blue-color);
      color: #fff !important;
      display: flex;
      align-items: center;
      justify-content: space-around;
      position: relative;
    }

    .brick {
      display: flex;
    }

    .brick.small {
      width: 140px;
      height: 200px;
    }

    .brick.large {
      width: 300px;
      height: 200px;
    }

    .brick.extralarge {
      width: 460px;
      height: 200px;
    }

    .brick.big {
      width: 620px;
      height: 200px;
    }

    .brick.extrabig {
      width: 780px;
      height: 200px;
    }

    .brick.masterbig {
      width: 940px;
      height: 200px;
    }

    .brick p {
      text-align: center;
      vertical-align: middle;
      font-size: 25px;
      flex: 1;
      display: flex;
      align-content: space-around;
      align-items: flex-end;
      justify-content: center;
      flex-wrap: wrap;
      flex-direction: row;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
    }

    .example .brick {
      opacity: 1;
      cursor: pointer;
      position: relative;
      text-align: center;
    }

    .example .brick .delete,
    .quadrado .delete {
      display: block;
      color: #FFF;
      background: rgba(255, 255, 255, 0.2);
      width: 40px;
      height: 40px;
      top: 0;
      right: 0;
      position: absolute;
      text-align: center;
      line-height: 40px;
    }

    .example .brick .edit,
    .quadrado .edit {
      display: block;
      color: #FFF;
      background: rgba(255, 255, 255, 0.2);
      width: 40px;
      height: 40px;
      top: 0;
      left: 0;
      position: absolute;
      text-align: center;
      line-height: 40px;
    }

    .example .brick.dragging {
      opacity: 0.8;
    }

    .example .brick {
      background-color: var(--blue-color);
      color: #fff !important;
    }

    .modal-body {
      max-height: calc(100vh - 210px);
      overflow-y: auto;
    }

    section {
      height: 100%;
      width: 100%;
    }

    /* #dashboard {} */
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="container-fluid">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6 flex">
            <div style="text-align:center;" class="mt-2">
              <label id="switch" class="switch d-none">
                <input type="checkbox" onchange="toggleTheme()" id="theme-slider">
                <span class="theme-slider round"></span>
              </label>
            </div>
            <h1 class="m-0 text-dark">Dashboard:
              <span id="id-dash">1</span>
            </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="../index">Início</a></li>
              <li class="breadcrumb-item"><a href="../dashboard">Dashboards</a></li>
              <li class="breadcrumb-item active">Editar Dashboard</li>
            </ol>
          </div>
        </div>
    </section>

    <section class="content-header">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-4">
            <label for="txtNomeDash">Nome: </label>
            <input type="text" placeholder="Nome Dash." class="input-default focus form-control" id="txtNomeDash" name="txtNomeDash">
          </div>
          <div class="col-sm-2">
            <label for="txtNomeDash">Tempo Atualização (minutos): </label>
            <input type="number" min="0" placeholder="Tempo Atualização" class="input-default focus form-control" id="txtTempoDash" name="txtTempoDash">
          </div>
          <div class="col-sm-12 mt-2">
            <button id="btn-dataset" title="Obter Dados" type="button" class="btn btn-sisp btn-sm btn-secondary">
              <b>Obter Dados</b> <i class="fas fa-database"></i></button>
            <button id="btn-novo" title="Novo Gráfico" type="button" class="btn btn-sisp btn-sm btn-primary"><b>Novo
                Gráfico</b> <i class="fas fa-chart-bar"></i></button>
            <button id="btn-salvar" title="Salvar Dash" type="button" class="btn btn-sisp btn-sm btn-danger"><b>Salvar
                Dash</b> <i class="fas fa-save"></i></button>
            <button id="btn-testar" title="Testar Dash" type="button" class="btn btn-sisp btn-sm btn-dark"><b>Testar
                Dash</b> <i class="fas fa-chart-line"></i></button>
          </div>
          <section id="dashboard" class="content example">
            <div class="container-fluid mt-2">
              <h1 id="dados">Dados</h1>
              <div id="panel-datasets" class="row ml-2 mr-2 mt-2 quadrados">
              </div>
            </div>
            <div class="container-fluid mt-2">
              <h1 id="graficos">Gráficos</h1>
            </div>
            <div id="area-graficos" class="container-fluid mt-2">
              <div id="panel" class="ml-2 mr-2 mt-2 gridly">
              </div>
            </div>
            <div class="modal fade" id="modal-edit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-lg">
                <div class="modal-content modal-lg">
                  <div class="modal-header">
                    <h4 id="modal-titulo" class="modal-title">Editar Gráfico: </h4>
                    <h4 class="modal-title" id="id-grafico"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body pl-5 pr-5">
                    <div class="row">
                      <div class="col-sm-12">
                        <h2 class="fs-title">Configurações Gráfico</h2>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txtNomeGrafico">Nome</label>
                          <div class="relative">
                            <input type="text" placeholder="Nome" class="d-none" id="txtIdGrafico" name="txtIdGrafico">
                            <input type="text" placeholder="Nome" class="d-none" id="txtProporcao" name="txtProporcao" value="1">
                            <input type="text" placeholder="Nome" class="d-none" id="txtOrdem" name="txtOrdem">
                            <input type="text" placeholder="Nome" autocomplete='off' class="input-default focus form-control" id="txtNomeGrafico" name="txtNomeGrafico">
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <label>Tipo Gráfico</label>
                        <div class="input-group">
                          <select class="form-control select2 select2-danger focus" id="select_tipo" name="select_tipo" data-trigger="change" data-html="true" data-placement="left" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            <option id="opt-card" value="0" selected="selected">Card</option>
                            <option id="opt-barras" value="1">Barras</option>
                            <option id="opt-colunas" value="2">Colunas</option>
                            <option id="opt-linha" value="3">Linha</option>
                            <option id="opt-pizza" value="4">Pizza</option>
                            <option id="opt-rosca" value="5">Rosca</option>
                            <option id="opt-grid" value="6">Grid</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <label>Apresentação de Valores</label>
                        <div class="input-group">
                          <select class="form-control select2 select2-danger focus" id="select_valores" name="select_valores" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            <option value="0" selected="selected">Inteiro</option>
                            <option value="1">Decimal (2 casas)</option>
                            <option value="2">Monetário(R$)</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <label>DataSet</label>
                        <div class="input-group">
                          <select class="form-control select2 select2-danger focus" id="select_dataset" name="select_dataset" data-dropdown-css-class="select2-danger" style="width: 100%;">
                          </select>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_eixo'>
                        <div class="group-default">
                          <label for="txtEixo">Eixo</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtEixo" name="txtEixo" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txtValor">Valor</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtValor" name="txtValor" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="group-default">
                          <label for="txtTipoValor">Tipo Valor</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtTipoValor" name="txtTipoValor" data-dropdown-css-class="select2-danger" style="width: 100%;">
                              <option value="0" selected="selected">Soma</option>
                              <option value="1">Média</option>
                              <option value="2">Máximo</option>
                              <option value="3">Mínimo</option>
                              <option value="4">Contagem</option>
                              <option value="5">Contagem(distinta)</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_tipo_ordenacao'>
                        <div class="group-default">
                          <label for="txtTipoOrdenacao">Tipo Ordenação</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtTipoOrdenacao" name="txtTipoOrdenacao" data-dropdown-css-class="select2-danger" style="width: 100%;">
                              <option value="-1" selected="selected">Nenhuma</option>
                              <option value="0" selected="selected">Decrescente</option>
                              <option value="1">Crescente</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_campo_ordenacao'>
                        <div class="group-default">
                          <label for="txtCampoOrdenacao">Campo Ordenação</label>
                          <div class="relative">
                            <select class="form-control select2 select2-danger focus" id="txtCampoOrdenacao" name="txtCampoOrdenacao" data-dropdown-css-class="select2-danger" style="width: 100%;">
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12" id='div_maximo_registros'>
                        <div class="group-default">
                          <label for="txtMaxRegistros">Máximo de Registros</label>
                          <div class="relative">
                            <input type="number" min=0 placeholder="Máximo de Registros" class="input-default focus form-control" id="txtMaxRegistros" name="txtMaxRegistros">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <input id="btn-confirmar-edit" type="button" name="next" class="btn btn-danger btn-sisp next action-button" value="Concluir" />
                  </div>
                </div>
              </div>
            </div>
            <div class="modal fade" id="modal-dataset" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
              <div class="modal-dialog modal-lg">
                <div class="modal-content modal-lg">
                  <div class="modal-header">
                    <h4 id="modal-titulo" class="modal-title">Consulta de Dados: </h4>
                    <h4 class="modal-title" id="id-dataset"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                  <div class="modal-body">
                    <div class="row">
                      <div class="col-sm-12">
                        <div class="row">
                          <div class="col-sm-12">
                            <div class="group-default">
                              <label for="txtNomeDataSet">Nome</label>
                              <div class="relative">
                                <input id="txtNomeDataSet" name="txtNomeDataSet" type="text" placeholder="Nome" class="input-default focus form-control">
                                <input id="txtIdDataSet" name="txtIdDataSet" type="text" placeholder="Nome" class="d-none">
                              </div>
                            </div>
                          </div>
                          <div class="col-sm-12">
                            <div class="group-default form-group">
                              <label data-error="wrong" data-success="right">SQL</label>
                              <textarea id="txtSelect" class="autoExpand forumPost form-control" rows="10" placeholder="Monte o SQL aqui"></textarea>
                            </div>
                          </div>
                          <div class="col-sm-12">
                            Opções disponíveis para se utilizar no sql <br />
                            :EMP_PAT = Irá substituir o campo ':EMP_PAT' dentro do SQL, pelo emp_path da empresa logada. Ex: '_001' <br />
                            :EMP_ID = Irá substituir o campo ':EMP_ID' dentro do SQL, pelo emp_id da empresa logada. Ex: '1' <br />
                            :COD_USUARIO = Irá substituir o campo ':COD_USUARIO' dentro do SQL, pelo código de usuário logado. Ex: '0000' <br />
                            <button id="btn-validar" type="button" class="btn btn-danger btn-sisp float-right mt-2">Validar</button>
                            <button id="btn-identar" type="button" class="btn btn-success btn-sisp float-right mt-2 ml-2 mr-2">Identar</button>
                          </div>
                          <div class="col-sm-12">
                            <h5>
                              Resultado SQL
                            </h5>
                          </div>
                          <div id="resultados" class="col-sm-12 table-responsive">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" id="btn-confirmar-dataset" class="btn btn-primary btn-sisp">Confirmar</button>
                  </div>
                </div>
              </div>
            </div>
          </section>
        </div>
      </div>
    </section>
    <?php
    include_once('../../footer.php');
    ?>
    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.239.11.1"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.239.11.1"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
      $.widget.bridge('uibutton', $.ui.button)
    </script>

    <!-- Bootstrap 4 -->
    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.239.11.1"></script>
    <!-- Sparkline -->
    <script src="../plugins/sparklines/sparkline.js?versao=3.239.11.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../utils/funcoes.js?versao=3.239.11.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/jquery.dataTables.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../dist/js/loadingoverlay.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../dist/js/sum().js?versao=3.239.11.1"></script>
    <script src="../dist/js/dataTables.keyTable.js?versao=3.239.11.1"></script>
    <script src="../utils/cookies.js?versao=3.239.11.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../plugins/jszip/jszip.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../plugins/pdfmake/pdfmake.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../plugins/pdfmake/vfs_fonts.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/jquery.gridly.js?versao=3.239.11.1" type="text/javascript"></script>
    <script src="../dist/js/sql-formatter.min.js?versao=3.239.11.1"></script>
    <script src="../plugins/select2/js/select2.full.min.js?versao=3.239.11.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.239.11.1"></script>
    <script>
      $(document).ready(async function() {
        ipInterno = '<?php echo IP_INTERNO; ?>';
        ipExterno = '<?php echo IP_EXTERNO; ?>';
        basicAuth = '<?php echo BASIC_AUTH; ?>';
        const temAcesso = await temAcessoTela('CADASTRO_DASHBOARD');
        if (!temAcesso.resultado) {
          toastrAcesso(temAcesso, '<?php echo BASE_URI; ?>');
          return;
        }



        $('.select2').select2();
        $("#select_dataset").select2({
          multiple: true,
          allowClear: true
        });
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        });

        var totalGrafs = 0;
        var totalDataSets = 0;
        var arrGraficos = [];
        var arrDataSets = [];
        var formatar = window.sqlFormatter.format;

        var reordered = function($elements) {
          for (let i = 0; i < $elements.length; i++) {
            const element = $elements[i];
            const id = element.id.split('-')[1];
            const iPosicaoArray = arrGraficos.findIndex(obj => {
              return obj.id == id;
            });

            if (iPosicaoArray != -1) {
              arrGraficos[iPosicaoArray].ordem = i;
            }
          }
        };

        $('.gridly').gridly({
          base: 60, // px 
          gutter: 20, // px
          columns: 12,
          callbacks: {
            reordered: reordered
          }
        });


        function bloqueiaEdicao() {
          $('.btn-sisp').attr('disabled', 'disabled');
          $('.btn-sisp').off();
          // $('.edit').attr('disabled', 'disabled');
          // $('.edit').off();
          // $('.delete').attr('disabled', 'disabled');
          // $('.delete').off();
        }

        $('#select_dataset').on('change', function() {
          let colunasArrayAtual = [];
          let arrayUnico = [];
          const value = $(this).val();
          if (typeof(value) === 'string') {
            const iPosicaoArray = arrDataSets.findIndex(obj => {
              return obj.id_banco == value;
            });
            // if (!arrDataSets[iPosicaoArray].dados[0]) {
            //   msgErro('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
            //   bloqueiaEdicao();
            //   throw new Error('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
            // }
            colunasArrayAtual = Object.keys(arrDataSets[iPosicaoArray].dados[0]);
            arrayUnico = unique(arrayUnico.concat(colunasArrayAtual));
          } else {
            for (const indice in value) {
              if (value[indice] === '') {
                break;
              }
              const iPosicaoArray = arrDataSets.findIndex(obj => {
                return obj.id_banco == value[indice];
              });
              // if (!arrDataSets[iPosicaoArray].dados[0]) {
              //   msgErro('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
              //   bloqueiaEdicao();
              //   throw new Error('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArray].nome + ', impossível editar');
              // }
              colunasArrayAtual = Object.keys(arrDataSets[iPosicaoArray].dados[0]);
              arrayUnico = unique(arrayUnico.concat(colunasArrayAtual));
            }
          }
          $('#txtEixo').html('');
          $('#txtValor').html('');
          $('#txtCampoOrdenacao').html('');
          for (const colunas of arrayUnico) {
            var optionText = colunas;
            var optionValue = colunas;
            $('#txtEixo').append(`<option value="${optionValue}">
                                                 ${optionText}
                                  </option>`);
            $('#txtValor').append(`<option value="${optionValue}">
                                                  ${optionText}
                                   </option>`);
            $('#txtCampoOrdenacao').append(`<option value="${optionValue}">
                                                  ${optionText}
                                   </option>`);
          }
        });

        function allowDrop(ev) {
          ev.preventDefault();
        }

        var unique = function(a) {
          return a.reduce(function(p, c) {
            if (p.indexOf(c) < 0) p.push(c);
            return p;
          }, []);
        };

        function drop(ev) {
          ev.preventDefault();
          var data = ev.dataTransfer.getData("text");
          ev.target.value = data;
        }

        var queryString = window.location.href;
        var parametros = queryString.split('/');
        var id_dashboard = parametros[parametros.length - 1];
        $('#id-dash').html(id_dashboard);

        async function RetornaDadosDashboard(id) {
          const _url = `/sisplan/funcoes/v1/pesquisa?`;
          const _params = ``;

          try {
            $.LoadingOverlay('show');
            try {
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"dash_web", "camposSelect":["nome", "minutos"], "where": ["id = '${id}'"] }`, null);
              if (!response) {
                return;
              }
              var jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }
              $('#txtNomeDash').val(jsonStr['RESULT'][0][0].NOME);
              $('#txtTempoDash').val(jsonStr['RESULT'][0][0].MINUTOS);
            } catch (error) {
              console.error(error);
              msgErro('Não foi possível buscar os dados do dashboard.');
            }

            //consulta datasets
            try {
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"dataset_web", "camposSelect":["id","nome","sql"], "where": ["id_dash = '${id}'"] }&REPLACE_LINE_BREAK=true`,
                null);
              if (!response) {
                return;
              }
              var jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }
              //aqui tem que criar os datasets no html e arrGraficos...
              for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
                $('#id-dataset').html('Nova');
                const dataset = jsonStr['RESULT'][0][i];
                $('#txtNomeDataSet').val(dataset.NOME);
                $('#txtSelect').val(dataset.SQL.replaceAll('&#013;', '\r\n'));
                await rotinaValidarSQL(false);
                $('#txtIdDataSet').val(dataset.ID);
                await rotinaConfirmarDataSet();
              }
            } catch (error) {
              console.error(error);
              msgErro(error);
            }

            //consulta gráficos
            try {
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"grafico_web", "camposSelect":["id", "nome", "tipo", "proporcao", "tipo_apresentacao", "eixo", "valor", "tipo_valor","tipo_ordenacao", "max_registros", "campo_ordenacao", "ordem"], "where": ["id_dash = '${id}'"], "orderby": ["ordem"] }`,
                null);
              if (!response) {
                return;
              }
              var jsonStr = await response.json();
              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
              }
              await carregaDataSetsSelect();
              //aqui tem que criar os gráficos no html e arrGraficos...
              for (let i = 0; i < jsonStr['RESULT'][0].length; i++) {
                totalGrafs++;
                const grafico = jsonStr['RESULT'][0][i];
                var classe = 'small';
                switch (grafico.PROPORCAO) {
                  case 1:
                    classe = 'small';
                    break;
                  case 2:
                    classe = 'large';
                    break;
                  case 3:
                    classe = 'extralarge';
                    break;
                  case 4:
                    classe = 'big';
                    break;
                  case 5:
                    classe = 'extrabig';
                    break;
                  case 6:
                    classe = 'masterbig';
                    break;
                  default:
                    classe = 'small';
                    break;
                }
                $('#panel').append(`
                  <div data-placement="bottom" id="graf-${totalGrafs}" class="brick ${classe}">
                    <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a>
                    <a title="excluir" class="delete" href="#"><i class="fas fa-trash"></i></a>
                    <p id="graf-nome-${totalGrafs}" style="color: white!important;">Gráfico ${totalGrafs}</p>
                  </div>
                `);

                $('.gridly').gridly({
                  base: 60, // px 
                  gutter: 20, // px
                  columns: 12
                });

                $('#id-grafico').html(totalGrafs);
                $('#txtNomeGrafico').val(grafico.NOME);
                $('#select_tipo').val(grafico.TIPO).trigger('change');
                $('#select_valores').val(grafico.TIPO_APRESENTACAO).trigger('change');
                
                $('#select_dataset').val(await retornaDataSets(id, grafico.ID)).trigger('change');
                if (grafico.TIPO == '6') {
                  $("#txtEixo").select2({
                    multiple: true,
                    allowClear: true
                  });
                  $('#txtEixo').val(grafico.EIXO.replaceAll(' ','').split(',')).trigger('change');
                } else {
                  $("#txtEixo").select2({
                    multiple: false,
                    allowClear: false
                  });
                  $('#txtEixo').val(grafico.EIXO).trigger('change');
                }
                $('#txtValor').val(grafico.VALOR).trigger('change');
                $('#txtCampoOrdenacao').val(grafico.CAMPO_ORDENACAO).trigger('change');
                $('#txtTipoOrdenacao').val(grafico.TIPO_ORDENACAO).trigger('change');
                $('#txtMaxRegistros').val(grafico.MAX_REGISTROS);
                $('#txtTipoValor').val(grafico.TIPO_VALOR).trigger('change');
                $('#txtIdGrafico').val(grafico.ID);
                $('#txtProporcao').val(grafico.PROPORCAO);
                $('#txtOrdem').val(grafico.ORDEM);
                await rotinaConfirmarGrafico();
              }
            } catch (error) {
              console.error(error);
              msgErro(error);
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        }

        RetornaDadosDashboard(id_dashboard);
        //ELITON REVER
        $('#select_tipo').on('change', function() {
          const tipoSelecionado = $(this).val();
          if (tipoSelecionado == '0') {
            $('#div_eixo').addClass('d-none');
            $('#div_tipo_ordenacao').addClass('d-none');
            $('#div_campo_ordenacao').addClass('d-none');
            $('#div_maximo_registros').addClass('d-none');
            $("#select_dataset").select2({
              multiple: false,
              allowClear: true
            });
            $("#txtEixo").select2({
              multiple: false,
              allowClear: false
            });
          } else if (['1', '2', '3'].includes(tipoSelecionado)) {
            $('#div_eixo').removeClass('d-none');
            $('#div_tipo_ordenacao').removeClass('d-none');
            $('#div_campo_ordenacao').removeClass('d-none');
            $('#div_maximo_registros').removeClass('d-none');
            $("#select_dataset").select2({
              multiple: true,
              allowClear: true
            });
            $("#txtEixo").select2({
              multiple: false,
              allowClear: false
            });
          } else if (tipoSelecionado == '6') {
            $('#div_eixo').removeClass('d-none');
            $('#div_tipo_ordenacao').removeClass('d-none');
            $('#div_campo_ordenacao').removeClass('d-none');
            $('#div_maximo_registros').removeClass('d-none');
            $("#select_dataset").select2({
              multiple: true,
              allowClear: true
            });
            $("#txtEixo").select2({
              multiple: true,
              allowClear: true
            });
          } else {
            $('#div_eixo').removeClass('d-none');
            $('#div_tipo_ordenacao').removeClass('d-none');
            $('#div_campo_ordenacao').removeClass('d-none');
            $('#div_maximo_registros').removeClass('d-none');
            $("#select_dataset").select2({
              multiple: true,
              allowClear: true
            });
            $("#txtEixo").select2({
              multiple: false,
              allowClear: false
            });
          }

        });

        async function retornaDataSets(id_dash, id_grafico) {
          try {
            const _url = `/sisplan/funcoes/v1/pesquisa?`;
            const _params = ``;
            var response = await requisicao('GET', _url,
              `JSON={ "tabela":"GRAFICO_DATASET", "camposSelect":["id_dataset"], "where": ["id_dash = ${id_dash} and id_grafico = ${id_grafico}"] }`,
              null);
            if (!response) {
              return;
            }
            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem)
              return;
            }
            //aqui tem que criar os gráficos no html e arrGraficos...
            const arrResultado = jsonStr['RESULT'][0][0]['ID_DATASET'].split(', ');
            return arrResultado;
          } catch (error) {
            console.error(error);
          }
        }

        function preencheGrafico() {
          let id_graf = $('#id-grafico').html().trim();
          const grafico = new Object();
          grafico.id = id_graf;
          grafico.id_banco = $('#txtIdGrafico').val();
          grafico.proporcao = $('#txtProporcao').val();
          grafico.ordem = $('#txtOrdem').val();
          grafico.nome = $('#txtNomeGrafico').val();
          grafico.tipo_grafico = $('#select_tipo').val();
          grafico.tipo_valores = $('#select_valores').val();
          grafico.dataset = $('#select_dataset').val();
          grafico.eixo = $('#txtEixo').val();
          grafico.valor = $('#txtValor').val();
          grafico.tipo_valor = $('#txtTipoValor').val();
          grafico.campo_ordenacao = $('#txtCampoOrdenacao').val();
          grafico.tipo_ordenacao = $('#txtTipoOrdenacao').val();
          grafico.max_registros = $('#txtMaxRegistros').val();
          return grafico;
        }

        function preencheDataSet() {
          let id_dataset = -1;
          if ($('#id-dataset').html().trim() == 'Nova') {
            id_dataset = totalDataSets;
          } else {
            id_dataset = $('#id-dataset').html().trim();
          }
          const dataset = new Object();
          dataset.id = id_dataset;
          dataset.nome = $('#txtNomeDataSet').val();
          dataset.sql = $('#txtSelect').val().replace(/\n/g, ' ');
          dataset.dados = $('#tabela-resultados').DataTable().data().toArray();
          dataset.id_banco = $('#txtIdDataSet').val();
          return dataset;
        }

        async function limpaGrafico() {
          $('#id-grafico').html('');
          $('#txtNomeGrafico').val('');
          $('#select_tipo').val(0).trigger('change');
          $('#select_valores').val(0).trigger('change');
          $('#txtEixo').val('');
          $('#txtEixo').html('');
          $('#txtValor').val('');
          $('#txtValor').html('');
          $('#txtCampoOrdenacao').val('');
          $('#txtCampoOrdenacao').html('');
          $('#txtTipoValor').val(0).trigger('change'); //padrao soma
          $('#txtTipoOrdenacao').val(-1); //padrao soma
          $('#txtMaxRegistros').val(0);
          $('#select_dataset').val('');
          $('#txtIdGrafico').val('');
          $('#txtProporcao').val('1');
          $('#txtOrdem').val('');
        }

        async function limpaDataSet() {
          $('#id-dataset').html('');
          $('#txtNomeDataSet').val('');
          $('#txtIdDataSet').val('');
          $('#txtSelect').val('');
          $('#resultados').html('');
        }

        async function adicionaGrafico() {
          var grafico = preencheGrafico();
          arrGraficos.push(grafico);
        }

        async function editaGrafico(iPosicaoArray) {
          var grafico = preencheGrafico();
          arrGraficos[iPosicaoArray] = grafico;
        }

        async function adicionaDataSet() {
          var dataset = preencheDataSet();
          arrDataSets.push(dataset);
        }

        async function editaDataSet(iPosicaoArray) {
          var dataset = preencheDataSet();
          arrDataSets[iPosicaoArray] = dataset;
        }

        async function carregaGrafico(iPosicaoArray) {
          $('#id-grafico').html(arrGraficos[iPosicaoArray].id);
          $('#txtIdGrafico').val(arrGraficos[iPosicaoArray].id_banco);
          $('#txtProporcao').val(arrGraficos[iPosicaoArray].proporcao);
          $('#txtOrdem').val(arrGraficos[iPosicaoArray].ordem);
          $('#txtNomeGrafico').val(arrGraficos[iPosicaoArray].nome);
          $('#select_tipo').val(arrGraficos[iPosicaoArray].tipo_grafico).trigger('change');
          $('#select_valores').val(arrGraficos[iPosicaoArray].tipo_valores).trigger('change');
          //aqui pode ser que é mais de um dataset verificar depois Eliton \/
          $('#select_dataset').val(arrGraficos[iPosicaoArray].dataset).trigger('change');
          $('#txtEixo').val(arrGraficos[iPosicaoArray].eixo).trigger('change');
          $('#txtValor').val(arrGraficos[iPosicaoArray].valor).trigger('change');
          $('#txtTipoValor').val(arrGraficos[iPosicaoArray].tipo_valor).trigger('change');
          $('#txtCampoOrdenacao').val(arrGraficos[iPosicaoArray].campo_ordenacao).trigger('change');
          $('#txtTipoOrdenacao').val(arrGraficos[iPosicaoArray].tipo_ordenacao).trigger('change');
          $('#txtMaxRegistros').val(arrGraficos[iPosicaoArray].max_registros);
        }

        async function carregaDataSet(iPosicaoArray) {
          var dataSet = [];
          var dataSetCols = [];
          $('#id-dataset').html(arrDataSets[iPosicaoArray].id);
          $('#txtIdDataSet').val(arrDataSets[iPosicaoArray].id_banco);
          $('#txtNomeDataSet').val(arrDataSets[iPosicaoArray].nome);
          $('#txtSelect').val(arrDataSets[iPosicaoArray].sql);

          // if (!$.isEmptyObject(arrDataSets[iPosicaoArray].dados)) {
          //   dataSet = arrDataSets[iPosicaoArray].dados;
          //   var keys = Object.keys(dataSet[0]);
          //   for (var k in keys) {
          //     dataSetCols.push({
          //       'title': keys[k],
          //       'data': keys[k]
          //     });
          //   }

          //   $(`#resultados`).html(`<table id="tabela-resultados" class="table table-sm table-select table-hover display"></table>`);

          //   // $(`#tabela-resultados`).DataTable({
          //   //   paging: true,
          //   //   filter: false,
          //   //   info: false,
          //   //   order: false,
          //   //   destroy: true,
          //   //   autowidth: true,
          //   //   "language": {
          //   //     "sEmptyTable": "Nenhum registro encontrado",
          //   //     "sInfo": "_TOTAL_ registros",
          //   //     "sInfoEmpty": " 0 registros",
          //   //     "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          //   //     "sInfoPostFix": "",
          //   //     "sInfoThousands": ".",
          //   //     "sLengthMenu": "_MENU_ resultados",
          //   //     "sLoadingRecords": "Carregando...",
          //   //     "sProcessing": "Processando...",
          //   //     "sZeroRecords": "Nenhum registro encontrado",
          //   //     "sSearch": "Pesquisar",
          //   //     "oPaginate": {
          //   //       "sNext": "Próximo",
          //   //       "sPrevious": "Anterior",
          //   //       "sFirst": "Primeiro",
          //   //       "sLast": "Último"
          //   //     },
          //   //     "oAria": {
          //   //       "sSortAscending": ": Ordenar colunas de forma ascendente",
          //   //       "sSortDescending": ": Ordenar colunas de forma descendente"
          //   //     }
          //   //   },
          //   //   "columns": dataSetCols,
          //   //   "data": dataSet
          //   // });

          //   // for (let i = 0; i < $(`#tabela-resultados th`).length; i++) {
          //   //   const coluna = $($(`#tabela-resultados th`)[i]);
          //   //   coluna.prop('draggable', true);
          //   //   coluna.on('dragstart', function(event) {
          //   //     event.originalEvent.dataTransfer.setData("text", event.target.innerHTML);
          //   //   });
          //   // }
          // }
        }

        $('#btn-dataset').on('click', function() {
          limpaDataSet();
          $('#id-dataset').html('Nova');
          $('#modal-dataset').modal({
            backdrop: 'static',
            keyboard: false
          });
        });

        $('#btn-novo').on('click', function() {
          if ($('.quadrado').length == 0) {
            msgAlerta('Nenhum dataset disponível, impossível criar gráfico.');
            return;
          }

          if (arrDataSets.filter(dataset => dataset.id_banco === '').length != 0) {
            msgAlerta('Datasets não gravados, necessário salvar o dashboard antes de criar novos gráficos.');
            return;
          }

          totalGrafs++;
          $('#panel').append(`
            <div data-placement="bottom" id="graf-${totalGrafs}" class="brick small">
              <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a>
              <a title="excluir" class="delete" href="#"><i class="fas fa-trash"></i></a>
              <p id="graf-nome-${totalGrafs}" style="color: white!important;">Gráfico ${totalGrafs}</p>
            </div>
          `);

          $('.gridly').gridly({
            base: 60, // px 
            gutter: 20, // px
            columns: 12
          });

          $(`#graf-${totalGrafs} a:first-child`).trigger('click');

        });

        $('#btn-testar').on('click', function() {
          window.open(`${BASE_URI}/dash_teste/${id_dashboard}`, "_blank");
        });

        $('#btn-salvar').on('click', async function() {
          try {
            try {
              $.LoadingOverlay('show');
              if (arrDataSets.length === 0) {
                msgErro('Necessário criar algum dataset de dados para salvar');
                return;
              }

              if (parseFloat($('#txtTempoDash').val()) < 0) {
                msgErro('Tempo de Atualização inválido.');
                return;
              }

              var graficos = [];
              var datasets = [];
              var dashboard = new Object();
              dashboard.id = id_dashboard;
              dashboard.nome = $('#txtNomeDash').val();
              dashboard.minutos = $('#txtTempoDash').val();

              for (let i = 0; i < arrDataSets.length; i++) {
                const datasetObj = arrDataSets[i];
                const dataset = new Object();
                dataset.id = datasetObj.id_banco;
                dataset.nome = datasetObj.nome;
                dataset.sql = datasetObj.sql;
                dataset.id_dash = id_dashboard;
                datasets.push(dataset);
              }

              for (let y = 0; y < arrGraficos.length; y++) {
                const graficoObj = arrGraficos[y];
                const grafico = new Object();
                grafico.id = graficoObj.id_banco;
                grafico.nome = graficoObj.nome;
                grafico.id_dash = id_dashboard;
                grafico.tipo = graficoObj.tipo_grafico;
                grafico.tipo_apresentacao = graficoObj.tipo_valores;
                if (graficoObj.tipo_grafico == '6') {
                  grafico.eixo_list = graficoObj.eixo;
                } else {
                  grafico.eixo = graficoObj.eixo;
                }
                grafico.valor = graficoObj.valor;
                grafico.tipo_valor = graficoObj.tipo_valor;
                grafico.ordem = graficoObj.ordem;
                grafico.proporcao = graficoObj.proporcao;
                grafico.datasets = [];
                grafico.tipo_ordenacao = graficoObj.tipo_ordenacao;
                grafico.campo_ordenacao = graficoObj.campo_ordenacao;
                grafico.max_registros = graficoObj.max_registros;
                graficos.push(grafico);
              }
              dashboard.graficos = graficos;
              dashboard.datasets = datasets;

              const _url = '/sisplan/dashboard/v1/dashboard?';
              var response = await requisicao('POST', _url, '', `JSON=${JSON.stringify(dashboard)}`, null);

              if (!response) {
                return;
              }

              if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem);
                return;
              }

              var jsonStr = await response.json();
              const datasetsResponse = jsonStr.dataSets ?? [];
              const graficosResponse = jsonStr.graficos ?? [];

              for (let i = 0; i < datasetsResponse.length; i++) {
                const element = datasetsResponse[i];
                const iPosicaoArray = arrDataSets.findIndex(obj => {
                  return obj.nome == element.nome
                });
                arrDataSets[iPosicaoArray].id_banco = element.iD;
              }

              for (let i = 0; i < graficosResponse.length; i++) {
                const element = graficosResponse[i];
                const iPosicaoArray = arrGraficos.findIndex(obj => {
                  return obj.nome == element.nOME
                });
                arrGraficos[iPosicaoArray].id_banco = element.iD;
              }

              const arrLigacao = [];
              for (let i = 0; i < arrGraficos.length; i++) {
                const datasetArray = typeof(arrGraficos[i].dataset) === 'string' ? [arrGraficos[i].dataset] : arrGraficos[i].dataset;
                for (let z = 0; z < datasetArray.length; z++) {
                  const datasetUsado = datasetArray[z]; //posicao iniciando em 1
                  const graf = new Object();
                  graf.id_dash = id_dashboard;
                  graf.id_grafico = arrGraficos[i].id_banco;
                  graf.id_dataset = datasetUsado;

                  const iPosicaoLigacao = arrLigacao.findIndex(obj => {
                    return obj.id_dash == graf.id_dash && obj.id_grafico == graf.id_grafico
                  });
                  if (iPosicaoLigacao == -1) {
                    arrLigacao.push(graf);
                  } else {
                    arrLigacao[iPosicaoLigacao].id_dataset = arrLigacao[iPosicaoLigacao].id_dataset + ', ' +
                      graf.id_dataset;
                  }
                }
              }

              const objetoLigacao = new Object();
              objetoLigacao.graficos = arrLigacao;
              await gravaLigacaoDataSetGrafico(objetoLigacao);
            } catch (error) {
              console.error(error);
              msgErro('Erro ao salvar Dashboard.');
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        });

        async function gravaLigacaoDataSetGrafico(objeto) {
          try {
            const _url = '/sisplan/dashboard/v1/grafico_dataset?';
            var response = await requisicao('POST', _url, `JSON=${encodeURIComponent(JSON.stringify(objeto))}`,
              null);

            if (!response) {
              return;
            }

            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return;
            }
          } catch (error) {
            console.error(error);
          }
        }

        async function deletaGrafico(objeto) {
          try {
            const _url = '/sisplan/dashboard/v1/grafico?';
            var response = await requisicao('DELETE', _url, `JSON=${JSON.stringify(objeto)}`,
              null);

            if (!response) {
              return false;
            }

            if (response.status != 200) {
              msgErro('Erro ao deletar grafico');
              return false;
            }
            return true;
          } catch (error) {
            console.error(error);
            return false;
          }
        }

        async function deletaDataSet(objeto) {
          try {
            const _url = '/sisplan/dashboard/v1/dataset_web?';
            var response = await requisicao('DELETE', _url, `JSON=${JSON.stringify(objeto)}`, null);

            if (!response) {
              return false;
            }

            if (response.status != 200) {
              msgErro(jsonStr['RESULT'][0].mensagem);
              return false;
            }
            return true;
          } catch (error) {
            console.error(error);
            return false;
          }
        }

        async function carregaDataSetsSelect() {
          $('#select_dataset').html(``);

          for (const dataset of arrDataSets) {
            var optionText = dataset.nome;
            var optionValue = dataset.id_banco;
            $('#select_dataset').append(`<option value="${optionValue}">
                                                        ${optionText}
                                         </option>`);

          }

          // $('#select_dataset').unbind('change');

        }

        $('#btn-identar').on('click', function() {
          $(`#txtSelect`).val(window.sqlFormatter.format($(`#txtSelect`).val()));
        });


        $('#btn-validar').on('click', async function() {
          await rotinaValidarSQL();
        });

        async function rotinaValidarSQL(bMensagem = true) {
          if ($(`#txtSelect`).val() == '') {
            msgAlerta('Nenhum select informado.');
            return;
          }
          let _url = `/sisplan/funcoes/v1/EditorSQL?`;
          try {
            try {
              $.LoadingOverlay("show");

              let dataSet = [];
              let dataSetCols = [];
              const SQL = $(`#txtSelect`).val().replaceAll(':EMP_ID', getCookie('emp_id'))
                .replaceAll(':EMP_PAT', getCookie('empresa'))
                .replaceAll(':COD_USUARIO', getCookie('cod_usuario'));
              var response = await requisicao('POST', _url, '', `JSON=${encodeURIComponent(SQL)}`, null);


              if (!response) {
                return;
              }

              var jsonStr = await response.json();
              if (response.status === 400) {
                msgErro(jsonStr.mensagem)
                return;
              }

              if (!$.isEmptyObject(jsonStr)) {
                dataSet = jsonStr;
                var keys = Object.keys(dataSet[0]);
                for (var k in keys) {
                  dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                  });
                }

                $(`#resultados`).html(
                  `<table id="tabela-resultados" class="table table-sm table-select table-hover display"></table>`
                );

                $(`#tabela-resultados`).DataTable({
                  paging: true,
                  filter: false,
                  info: false,
                  order: false,
                  destroy: true,
                  autowidth: true,
                  "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                      "sNext": "Próximo",
                      "sPrevious": "Anterior",
                      "sFirst": "Primeiro",
                      "sLast": "Último"
                    },
                    "oAria": {
                      "sSortAscending": ": Ordenar colunas de forma ascendente",
                      "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                  },
                  "columns": dataSetCols,
                  "data": dataSet
                });

              }
              if (bMensagem) {
                msgSucesso('Consulta efetuada com sucesso.');
              }

            } catch (error) {
              console.error(error);
              msgErro('Erro ao validar sql.');
            }
          } finally {
            $.LoadingOverlay("hide");
          }
        }

        $('.brick').unbind('click');
        $('.brick').on('click', function() {
          $(this).toggle();
        });
        // Generated by CoffeeScript 2.5.1
        (function() {
          $(function() {
            var brick;
            brick = "<div class='brick small'><div class='delete'>&times;</div></div>";
            $(document).on("click touchend", ".gridly .brick", function(event) {
              var $this, size;
              let proporcao = 0;

              event.preventDefault();
              event.stopPropagation();
              $this = $(this);
              if ($this.hasClass('small')) { // HACK
                $this.toggleClass('small');
                $this.toggleClass('large');
              } else
              if ($this.hasClass('large')) { // HACK
                $this.toggleClass('large');
                $this.toggleClass('extralarge');
              } else
              if ($this.hasClass('extralarge')) { // HACK{
                $this.toggleClass('extralarge');
                $this.toggleClass('big');
              } else
              if ($this.hasClass('big')) { // HACK{
                $this.toggleClass('big');
                $this.toggleClass('extrabig');
              } else
              if ($this.hasClass('extrabig')) { // HACK{
                $this.toggleClass('extrabig');
                $this.toggleClass('masterbig');
              } else
              if ($this.hasClass('masterbig')) { // HACK{
                $this.toggleClass('masterbig');
                $this.toggleClass('small');
              }

              if ($this.hasClass('small')) {
                size = 140;
                proporcao = 1;
              } else
              if ($this.hasClass('large')) {
                size = 300;
                proporcao = 2;
              } else
              if ($this.hasClass('extralarge')) {
                size = 460;
                proporcao = 3;
              } else
              if ($this.hasClass('big')) {
                size = 620;
                proporcao = 4;
              } else
              if ($this.hasClass('extrabig')) {
                size = 780;
                proporcao = 5;
              } else
              if ($this.hasClass('masterbig')) {
                size = 940;
                proporcao = 6;
              }

              $this.data('width', size);
              $this.data('height', 200);
              const id = ($this.prop('id').split('-')[1]);
              const iPosicaoArray = arrGraficos.findIndex(obj => {
                return obj.id == id
              });
              arrGraficos[iPosicaoArray].proporcao = proporcao;
              return $('.gridly').gridly('layout');
            });


            $(document).on("click", ".gridly .delete", async function(event) {
              var r = confirm("Tem certeza que deseja excluir o gráfico?");
              if (r == true) {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
                let id_graf = $this.closest('div').attr('id').split('-')[1];
                let iPosicaoArray = arrGraficos.findIndex(obj => {
                  return obj.id == id_graf
                });
                const grafico = {
                  id: arrGraficos[iPosicaoArray].id_banco,
                  id_dash: id_dashboard
                }
                const deletouBanco = await deletaGrafico(grafico);
                if (deletouBanco) {
                  arrGraficos.splice(iPosicaoArray, 1);
                  $this.closest('.brick').remove();
                }
                return $('.gridly').gridly('layout');
              } else {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
                return $('.gridly').gridly('layout');
              }
            });

            $(document).on("click", ".quadrado .delete", async function(event) {
              var r = confirm("Tem certeza que deseja excluir o dataset?");
              if (r == true) {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
                let id_dataset = $this.closest('.quadrado').attr('data-id');
                //valida se já não está sendo usado em algum gráfico...
                var iPosicaoGraficos = arrGraficos.findIndex(obj => {
                  return obj.dataset.indexOf(id_dataset) != -1
                });
                if (iPosicaoGraficos != -1) {
                  msgAlerta(
                    `DataSet está sendo utilizado no gráfico: ${arrGraficos[iPosicaoGraficos].nome}, impossível excluir.`
                  );
                  return;
                }

                let iPosicaoArray = arrDataSets.findIndex(obj => {
                  return obj.id == id_dataset
                });

                const objetoDataSet = {
                  id: arrDataSets[iPosicaoArray].id_banco,
                  id_dash: id_dashboard
                }

                const deletadoBanco = await deletaDataSet(objetoDataSet);
                if (deletadoBanco) {
                  arrDataSets.splice(iPosicaoArray, 1);
                  $(`.quadrado[data-id="${id_dataset}"]`).remove();
                }
              } else {
                var $this;
                event.preventDefault();
                event.stopPropagation();
                $this = $(this);
              }
            });

            $(document).on("click", ".gridly .edit", async function(event) {
              var $this;
              event.preventDefault();
              event.stopPropagation();
              $this = $(this);
              let id_graf = $this.closest('div').attr('id').split('-')[1];
              let iPosicaoArray = arrGraficos.findIndex(obj => {
                return obj.id == id_graf
              });

              await carregaDataSetsSelect();
              if (iPosicaoArray != -1) {
                await carregaGrafico(iPosicaoArray);
              } else {
                await limpaGrafico();
              }
              $('#id-grafico').html(id_graf);
              $('#modal-edit').modal({
                backdrop: 'static',
                keyboard: false
              });
            });


            $(document).on("click", ".add", function(event) {
              event.preventDefault();
              event.stopPropagation();
              $('.gridly').append(brick);
              return $('.gridly').gridly();
            });
            return $('.gridly').gridly();
          });

        }).call(this);

        $('#btn-confirmar-edit').on('click', async function() {
          await rotinaConfirmarGrafico();
        });

        async function rotinaConfirmarGrafico() {
          if ($('#txtNomeGrafico').val() == '') {
            msgErro('Necessário informar o nome do Gráfico para continuar.');
            return;
          }

          if ($('#select_dataset').val().length == 0) {
            msgErro('Necessário informar o DataSet para continuar.');
            return;
          }

          if ($('#txtEixo').val() == '') {
            msgErro('Necessário informar o Eixo do Gráfico para continuar.');
            return;
          }

          if ($('#txtValor').val() == '') {
            msgErro('Necessário informar o Valor do Gráfico para continuar.');
            return;
          }

          if ($('#txtCampoOrdenacao').val() == '') {
            msgErro('Necessário informar o campo de Ordenacao do Gráfico para continuar.');
            return;
          }

          //validar se os campos do eixo e valor existem em cada dataset do array...
          const datasetValor = typeof($('#select_dataset').val()) === 'string' ? [$('#select_dataset').val()] : $('#select_dataset').val();
          let bErro = false;
          for (let i = 0; i < datasetValor.length; i++) {
            const id_dataset = datasetValor[i];
            const iPosicaoArrayDataSet = arrDataSets.findIndex(obj => {
              return obj.id_banco == id_dataset;
            });
            // if (!arrDataSets[iPosicaoArrayDataSet].dados[0]) {
            //   msgErro('Nenhum dado disponível no dataset: ' + arrDataSets[iPosicaoArrayDataSet].nome + ', impossível editar');
            //   bErro = true;
            //   break;
            // }
            const arrayColunas = Object.keys(arrDataSets[iPosicaoArrayDataSet].dados[0]);
            const iPosicaoArrayEixo = arrayColunas.findIndex(obj => {
              return obj == $('#txtEixo').val();
            });

            if ((iPosicaoArrayEixo == -1) && ($('#select_tipo').val() != '6')) {
              msgErro('Coluna informada no campo Eixo inválida, verifique.');
              bErro = true;
              return;
            }

            const iPosicaoArrayValor = arrayColunas.findIndex(obj => {
              return obj == $('#txtValor').val();
            });

            if (iPosicaoArrayValor == -1) {
              msgErro('Coluna informada no campo Valor inválida, verifique.');
              bErro = true;
              return;
            }
          }

          if (bErro) {
            return;
          }

          let id_graf = $('#id-grafico').html().trim();

          let iPosicaoArray = arrGraficos.findIndex(obj => {
            return obj.id == id_graf
          });
          let grafico = preencheGrafico();
          if (iPosicaoArray != -1) {
            await editaGrafico(iPosicaoArray);
          } else {
            await adicionaGrafico();
          }

          iPosicaoArray = arrGraficos.findIndex(obj => {
            return obj.id == id_graf
          });

          // $(`#graf-${id_graf}`).tooltip('hide')
          //   .attr('data-original-title', `Nome: ${arrGraficos[iPosicaoArray].nome}`)
          //   .tooltip('show');
          $(`#graf-nome-${id_graf}`).html(arrGraficos[iPosicaoArray].nome);

          await limpaGrafico();
          await $('#modal-edit').modal('hide');
        }

        $('#btn-confirmar-dataset').on('click', async function() {
          await rotinaConfirmarDataSet();
        });

        async function rotinaConfirmarDataSet() {
          if ($('#txtNomeDataSet').val() == '') {
            msgErro('Necessário informar o nome do DataSet para continuar.');
            return;
          }

          if ($('#txtSelect').val() == '') {
            msgErro('Necessário informar um select para continuar.');
            return;
          }
          
          await rotinaValidarSQL();

          // if ($('#tabela-resultados th').length == 0) {
          //   msgErro('Necessário executar o SQL através do botão Validar para continuar.');
          //   return;
          // }
          var id_dataset = -1;
          if ($('#id-dataset').html().trim() == 'Nova') {
            totalDataSets++;
            id_dataset = totalDataSets;
          } else {
            id_dataset = $('#id-dataset').html().trim();
          }
          let iPosicaoArray = arrDataSets.findIndex(obj => {
            return obj.id == id_dataset
          });
          let dataset = preencheDataSet();
          if (iPosicaoArray != -1) {
            await editaDataSet(iPosicaoArray);
          } else {
            await adicionaDataSet();
          }

          iPosicaoArray = arrDataSets.findIndex(obj => {
            return obj.id == id_dataset
          });

          if ($('#id-dataset').html().trim() == 'Nova') {
            $('.quadrados').append(
              `<div data-id="${id_dataset}" class="quadrado">${arrDataSets[iPosicaoArray].nome} <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a><div class='delete'>&times;</div></div>`
            );
          } else {
            $(`div[data-id="${id_dataset}"]`).html(
              `${arrDataSets[iPosicaoArray].nome} <a title="editar" class="edit" href="#"><i class="fas fa-edit"></i></a><div class='delete'>&times;</div></div>`
            );
          }

          $('.quadrado .edit').unbind('click');
          $('.quadrado .edit').on('click', async function() {
            $.LoadingOverlay("show");
            try {
              const id_dataset = $(this).closest('.quadrado').attr('data-id');
              event.preventDefault();
              event.stopPropagation();
              let iPosicaoArray = arrDataSets.findIndex(obj => {
                return obj.id == id_dataset
              });
              if (iPosicaoArray != -1) {
                await carregaDataSet(iPosicaoArray);
              } else {
                await limpaDataSet();
              }
              await $('#id-dataset').html(id_dataset);
              await $('#modal-dataset').modal({
                backdrop: 'static',
                keyboard: false
              });
            } finally {
              await $.LoadingOverlay("hide");
            }
          });

          await limpaDataSet();
          await $('#modal-dataset').modal('hide');
        };

      });
    </script>
</body>

</html>