$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta das ocorrências.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma ocorrência.",
          position: "right",
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description:
            "Clique aqui para imprimir os dados de ocorrências.",
          position: "right",
        },
      },
      {
        element: "#tabelaDados",
        popover: {
          title: "Tabela",
          description: "Aqui estão os dados das ocorrências.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ESCOCORRENCIA");

  componenteFiltro('banco', true);
  componenteFiltro('situacao', true);
  componenteFiltro('carteira', true);
  componenteFiltro('historico', true);
  componenteFiltro('classe', true);

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      // '    <button class="dropdown-item"" title="Anexos" id="btnAnexos">Anexos</button>     ' +
      '</div>';
    return retorno;
  };

  await consultaDados();

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtBanco').empty();
    $('#txtSituacao').empty();
    $('#txtCarteira').empty();
    $('#txtHistorico').empty();
    $('#txtClasse').empty();
    $('#txtCodigo').val('');
    $('#txtDescricao').val('');
  })

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");

      const filtros = await retornaFiltros();

      let where = `"1=1`;

      if (filtros.banco != '') {
        where += ` AND OCORRENCIA.BANCO IN (${filtros.banco})`;
      }

      if (filtros.situacao != '') {
        where += ` AND OCORRENCIA.SITUACAO IN (${filtros.situacao})`;
      }

      if (filtros.carteira != '') {
        where += ` AND OCORRENCIA.CARTEIRA IN (${filtros.carteira})`;
      }

      if (filtros.historico != '') {
        where += ` AND OCORRENCIA.HISTORICO IN (${filtros.historico})`;
      }

      if (filtros.classe != '') {
        where += ` AND OCORRENCIA.CLASSE IN (${filtros.classe})`;
      }

      if (filtros.tipo != '') {
        where += ` AND OCORRENCIA.TIPO = '${filtros.tipo}'`;
      }

      if (filtros.operacao == 'C') {
        where += ` AND OCORRENCIA.OPERACAO = 'C'`;
      } else {
        where += ` AND OCORRENCIA.OPERACAO <> 'C'`;
      }

      if (filtros.codigo != '') {
        where += ` AND OCORRENCIA.CODIGO LIKE '%${filtros.codigo}%'`;
      }

      if (filtros.descricao != '') {
        where += ` AND OCORRENCIA.DESCRICAO LIKE '%${filtros.descricao}%'`;
      }

      where += '"';

      $("#tabelaDados").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ordering: false,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: encodeURIComponent(JSON.stringify({
              "tabela": "ocorrencia",
              camposSelect: ["cadban.banco", "cadban.nome_banco", "ocorrencia.codigo ocorrencia", "ocorrencia.descricao desc_ocorrencia", "ocorrencia.situacao", "tabsit.descricao desc_situacao",
              "ocorrencia.carteira", "histcp.historico", "histcp.descricao desc_historico", "ocorrencia.classe", "classe_ger.descricao desc_classe",
                "ocorrencia.tipo", "ocorrencia.operacao", "ocorrencia.conta", "ocorrencia.alterar_banco", "ocorrencia.banco_alt", "ocorrencia.id"],
              leftjoin: [
                {
                  "tabela": "cadban", "condicao": "ocorrencia.banco = cadban.banco"
                },
                {
                  "tabela": "tabsit", "condicao": "ocorrencia.situacao = tabsit.codigo"
                },
                {
                  "tabela": "histcp", "condicao": "ocorrencia.historico = histcp.historico"
                },
                {
                  "tabela": "classe_ger", "condicao": "ocorrencia.classe = classe_ger.codigo"
                }
              ],
              where: [where],
              orderby: ["cadban.banco", "ocorrencia.codigo"],
              camposwhereserverside: ["ocorrencia.codigo",  "ocorrencia.descricao", "tabsit.descricao", "histcp.descricao", "classe_ger.descricao"]
            })),
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
        ],
      });
      $("input[type='search']").focus();
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível buscar os dados das ocorrências: ${error}`);
    }
  }

  $("#tabelaDados").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
      let chave = `${data[0]}-${data[2]}-${data[6]}-${data[16]}`;
      window.location.href = `escocorrencia/${chave}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaDados").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaDados").DataTable().row($(this)).data();
      let chave = `${data[0]}-${data[2]}-${data[6]}-${data[16]}`;
      window.location.href = `escocorrencia/${chave}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  async function retornaFiltros() {
    const filtros = {
      banco: await formataListas($('#txtBanco').val().toString()),
      situacao: await formataListas($('#txtSituacao').val().toString()),
      carteira: await formataListas($('#txtCarteira').val().toString()),
      historico: await formataListas($('#txtHistorico').val().toString()),
      classe: await formataListas($('#txtClasse').val().toString()),
      tipo: $($('#txtTipo')).val(),
      operacao: $('#txtOperacao').val(),
      codigo: $('#txtCodigo').val(),
      descricao: $('#txtDescricao').val()
    }

    return filtros;
  }

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = `${BASE_URI}/escocorrencia/create`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  })

  $('#tabelaDados').on('click', '#btn-excluir', function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Deseja excluir este registro?', async () => {
        let data = $("#tabelaDados").DataTable().row($(this).parents("tr")).data();
        await excluiRegistro(data);
      })
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  })

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay('show');
      try {

        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/escocorrencia?", `BANCO=${data[0]}&CODIGO=${data[2]}&CARTEIRA=${data[6]}&TIPO=${data[11]}&ID=${data[16]}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.reload();
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
      } catch (e) {
        console.log(e);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/escocorrencia?';
        const filtros = await retornaFiltros();

        const params = `
          &BANCO=${filtros.banco}
          &SITUACAO=${filtros.situacao}
          &CARTEIRA=${filtros.carteira}
          &HISTORICO=${filtros.historico}
          &CLASSE=${filtros.classe}
          &TIPO=${filtros.tipo}
          &OPERACAO=${filtros.operacao}
          &CODIGO=${filtros.codigo}
          &DESCRICAO=${filtros.descricao}`;

        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });
});
