function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {
    let contaFs = 1;

    $(".next").click(function () {
        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();

            $("#progressbar li").eq($(".abas").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate(
                {
                    opacity: 0,
                },
                {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            display: "none",
                            position: "relative",
                        });
                        nextFs.css({
                            opacity,
                        });
                    },
                    duration: 600,
                }
            );
        }
    });

    $(".previous").click(function () {
        contaFs -= 1;

        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();
        $("#progressbar li")
            .eq($(".abas").index(currentFs))
            .removeClass("active");
        previousFs.show();
        currentFs.animate(
            {
                opacity: 0,
            },
            {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    previousFs.css({
                        opacity,
                    });
                },
                duration: 600,
            }
        );
    });

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    $('#account').on('click', function () {
        if (contaFs == 2) {
            $('#voltar2').trigger('click');
        }
    });

    $('#confirm').on('click', function () {
        if (contaFs == 1) {
            $('#verBaixas').trigger('click');
        }
    });

    componenteFiltro('banco', false, false);
    componenteFiltro('carteira');
    componenteFiltro('historico', false, false);
    componenteFiltro('classeBaixa', false, false);
    componenteFiltro('classeJuros', false, false);
    componenteFiltro('classeDesconto', false, false);
    componenteFiltro('historico', false, false);
    componenteFiltro('conta', false, false);

    $('#txtBanco').on('blur', async function () {
        try {
            if ($('#txtBanco').val() == '') {
                return;
            }
            $.LoadingOverlay('show');

            let tabelaBanco = 'CADBAN';

            if (await Existe('CADBAN_CONF', ['BANCO', 'EMP_ID'], [pegaChave('#txtBanco'), getCookie('emp_id')])) {
                tabelaBanco = 'CADBAN_CONF';
            }

            await preencheCaminhos(tabelaBanco);
            await preencheHistorico();

            const result = await buscaValor(tabelaBanco, 'SOMA_TARIFA, INTEGRA_ENVIO', 'BANCO', pegaChave('#txtBanco'));

            if (result != '' && result != undefined && result != null) {
                $('#cbSomarTarifa').prop('checked', result.SOMA_TARIFA == 'S');
                $('#cbPossuiIntegracao').prop('checked', result.INTEGRA_ENVIO == 'S');
            }

        } finally {
            $.LoadingOverlay('hide');
        }
    })

    $('#cbAlterarBanco').on('change', function () {
        if ($('#cbAlterarBanco').prop('checked') == true) {
            $('#divAlterarBanco').removeClass('d-none');
        } else {
            $('#divAlterarBanco').addClass('d-none');
        }
    })

    async function preencheHistorico() {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"OCORRENCIA",
                        "camposSelect":["OCORRENCIA.HISTORICO", "HISTCP.DESCRICAO"],
                        "leftjoin": [{"tabela": "HISTCP", "condicao": "OCORRENCIA.HISTORICO = HISTCP.HISTORICO"}],
                        "where": ["OCORRENCIA.BANCO = '${pegaChave('#txtBanco')}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length == 0) {
                return;
            } else {
                insereValor('#txtHistorico', data[0].HISTORICO, data[0].DESCRICAO);
            }

        } catch (e) {
            console.log(e);
        }
    }

    async function preencheCaminhos(tabelaBanco) {
        try {

            let where = `BANCO = '${pegaChave('#txtBanco')}'`;

            if (tabelaBanco != 'CADBAN') {
                where += ` AND EMP_ID = ${getCookie('emp_id')}`;
            }

            let arrayWhere = ['BANCO'];
            let arrayValores = [pegaChave('#txtBanco')];

            if (tabelaBanco != 'CADBAN') {
                arrayWhere.push('EMP_ID');
                arrayValores.push(getCookie('emp_id'));
            };

            let caminho = await buscaCaminho(tabelaBanco, ['ENTRADA', 'ENTRADA_LIDO'], arrayWhere, arrayValores)

            $('#txtCaminho').val(caminho[0]);
            $('#txtCaminhoLido').val(caminho[1]);
        } catch (e) {
            console.log(e);
        }
    }

    $('#txtCarteira').on('blur', async function () {
        try {
            $.LoadingOverlay('show');

            if ($('#txtBanco').val() != '') {
                await preencheConta();
            } else {
                await buscaDadosCarteira();
            }

        } finally {
            $.LoadingOverlay('hide');
        }
    })

    async function preencheConta() {
        try {

            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CARTEIRA",
                        "camposSelect":["CARTEIRA.DESCRICAO", "CARTEIRA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA"],
                        "leftjoin": [{"tabela": "CADCONTA", "condicao": "CARTEIRA.CONTA = CADCONTA.CONTA"}],
                        "where": ["EXISTS (SELECT C.CONTA FROM [CADCONTA] C WHERE C.BANCO = '${pegaChave('#txtBanco')}' AND CARTEIRA.CONTA = C.CONTA)", "CARTEIRA.CARTEIRA = '${pegaChave('#txtCarteira')}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length > 0) {
                if (data[0].CONTA != '') {
                    insereValor('#txtConta', data[0].CONTA, data[0].DESC_CONTA);
                }
            } else {
                await buscaDadosCarteira();
            }



        } catch (e) {
            console.log(e);
        }
    }

    async function buscaDadosCarteira() {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CARTEIRA",
                        "camposSelect":["CARTEIRA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA"],
                        "leftjoin": [{"tabela": "CADCONTA", "condicao": "CARTEIRA.CONTA = CADCONTA.CONTA"}],
                        "where": ["CARTEIRA.CARTEIRA = '${pegaChave('#txtCarteira')}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length == 0) {
                return;
            }

            insereValor('#txtConta', data[0].CONTA, data[0].DESC_CONTA);
        } catch (e) {
            console.log(e);
        }
    }

    $(async function () {
        let idCampo = '';
        var modalUploadAnexos = $("#mdModalUpload");
        var Anexo = $('#txtCaminho');
        var BotaoAnexo = $("#btnCaminho");
        BotaoAnexo.click(function (e) {
            e.preventDefault();
            modalUploadAnexos.click();
        });

        modalUploadAnexos.change(async function () {
            var NomeAnexo = $(this).val().split('\\')[$(this).val().split('\\').length - 1];
            Anexo.val(NomeAnexo);

            let file = document.querySelector('input[type=file]').files[0];
            let reader = new FileReader();

            reader.onload = function (e) {
                $('#fileContent').text(e.target.result);
            }

            reader.readAsText(file);

        });
    });

    $('#voltar1').on('click', function () {
        msgAlerta('Tem certeza que deseja cancelar o procedimento?', () => {
            window.location.href = `${BASE_URI}/escocorrencia`
        })
    })

    $('#verBaixas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            if ($('#txtArquivo').val() == '') {
                throw msgErro('Arquivo não pode ser vazio, favor verificar.');
            }

            if (await Existe('RECEBER', ['NUMERO'], [''])) {
                throw msgErro('Existe uma duplicata sem número, impossível continuar.');
            }

            if (!$('#cbPossuiIntegracao').prop('checked')) {
                let arq = (($('#fileContent').text()).replaceAll(',', '')).split('\n');
                if (arq.length == 0) {
                    throw msgErro('Arquivo sem movimento, impossível continuar.');
                }

                await iniciaLeitura(arq);
            }

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function iniciaLeitura(arq) {
        try {
            if ($('#txtCarteira').val() != '' && await verificaCarteira240Pos(pegaChave('#txtCarteira'))) {
                for (let i = 0; i < arq.length - 2; i++) {

                    await leLinhaArquivo(arq, i);

                }
            }
        } catch (e) {
            console.log(e);
        }
    }

    async function retornaValoresCampos() {
        try {

            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"POSICAO",
                        "camposSelect":["*"]}`
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length == 0) {
                return;
            }

            return data;

        } catch (e) {
            console.log(e);
        }
    }

    async function leLinhaArquivo(arq, indice) {

        let nrBanco;

        function valorCampo(campo, linha, valores, carteira, ident_seguimento) {
            try {
                let reg;
                let result;

                const banco = pegaChave('#txtBanco');

                if ((carteira != '' && carteira != undefined && carteira != null) && (ident_seguimento != '' && ident_seguimento != undefined && ident_seguimento != null)) {
                    reg = valores.find(r => {
                        return r.BANCO == banco && r.CARTEIRA == carteira && r.CAMPO == campo && r.TIPO == 'ES' && r.IDENT_SEGUIMENTO == ident_seguimento;
                    })
                } else if ((carteira == '' || carteira == undefined || carteira == null) && (ident_seguimento == '' || ident_seguimento == undefined || ident_seguimento == null)) {
                    reg = valores.find(r => {
                        return r.BANCO == banco && r.CAMPO == campo && r.TIPO == 'ES';
                    })
                } else if (carteira != '' && carteira != undefined && carteira != null) {
                    reg = valores.find(r => {
                        return r.BANCO == banco && r.CARTEIRA == carteira && r.CAMPO == campo && r.TIPO == 'ES';
                    })
                } else {
                    reg = valores.find(r => {
                        return r.BANCO == banco && r.CAMPO == campo && r.TIPO == 'ES' && r.IDENT_SEGUIMENTO == ident_seguimento;
                    })
                }

                if ((reg == null || reg == '' || reg == undefined) && ($('#cbValidarCampos').prop('checked'))) {
                    throw msgErro(`Campo ${campo} não configurado para o banco.`, async () => { }, async () => { });
                }

                result = (linha.substr(reg.INICIO, reg.TAMANHO)).trim();
                if ((campo == 'NR_BANCO') && (reg.TAM_AUX > 0)) {
                    nrBanco = (result.substr(result.length - reg.TAM_AUX, result.length)).trim();
                }

                return result;

            } catch (e) {
                console.log(e);
            }
        }

        try {

            let linha = arq[indice];
            let ordem, conta, banco, acrescimo, juroDesc, valor, juroPago, despesa, tarifa, desconto, juro, iof,
            creditaCC, debitaCC, contaAnt, seguimento, contaCredita, dig, ocorrencia, carteira, comp_cart, numero,
            numero1, obs, sData, alteraVencto;

            const valoresCampos = await retornaValoresCampos();

            if (indice == 0) {
                ordem = valorCampo('ORDEM', linha, valoresCampos);
                conta = valorCampo('CONTA', linha, valoresCampos);

                if (conta == '') {
                    conta = pegaChave('#txtConta');
                }

                dig = valorCampo('DIG_CONTA', linha, valoresCampos);

                if (dig.trim() != '') {
                    conta += '-' + dig;
                }

                conta = await buscaContaCadastro(conta);

                contaCredita = await buscaValor('CADCONTA', 'CONTA_CREDITADA', 'CONTA', conta);
                banco = valorCampo('BANCO', linha, valoresCampos);
            } else if (indice > 1) {
                acrescimo, juroDesc, valor, juroPago, despesa, tarifa, desconto, juro, iof, creditaCC, debitaCC = 0;
                seguimento = valorCampo('SEGUIMENTO', linha, valoresCampos);

                if (seguimento == 'T') {
                    if (!await Existe('CADCONTA', ['CONTA'], [conta])) {
                        contaAnt = conta;

                        conta = valorCampo('CONTA', linha, valoresCampos);

                        if (conta == '') {
                            conta = pegaChave('#txtConta');
                        }
                        dig = valorCampo('DIG_CONTA', linha, valoresCampos);
                        if (dig.trim() != '') {
                            conta += '-' + dig;
                        }
                        conta = await buscaContaCadastro(conta);
                        if (conta == '') {
                            conta = contaAnt;
                        }
                        contaCredita = await buscaValor('CADCONTA', 'CONTA_CREDITADA', 'CONTA', conta);
                    }

                    ocorrencia = valorCampo('OCORRENCIA', linha, valoresCampos);

                    if ($('#cbCarteiraRegistro').prop('checked')) {
                        carteira = valorCampo('CARTEIRA', linha, valoresCampos);
                    }

                    comp_cart = valorCampo('COMP_CART', linha, valoresCampos);
                    if (comp_cart != '') {
                        carteira += valorCampo('COMP_CART', linha, valoresCampos);
                    }

                    nrBanco = valorCampo('NR_BANCO', linha, valoresCampos);
                    numero = valorCampo('NUMERO', linha, valoresCampos);
                    numero1 = numero;

                    obs = linha.substr(18, 20);

                    if (numero.indexOf('-') > 0) {
                        numero1 = numero.substr(1, numero.indexOf('-')-1);
                    }

                    valor = valorCampo('TARIFA', linha, valoresCampos);
                    valor = insert(',', valor, valor.length-1);
                    tarifa = parseFloat(valor);

                    sData = valorCampo('DATA_VENCTO', linha, valoresCampos);
                    if (sData.length >= 8) {
                        sData = insert('/', sData, 3);
                        sData = insert('/', sData, 6);
                        alteraVencto = !validaData(sData) ? '' : sData; 
                    }

                }
            }

        } catch (e) {
            console.log(e);
        }
    }

    function validaData(data) {
        try {
            let result = true;

            let dia = parseInt('0'+data.substr(0, 2).trim());
            let mes = parseInt('0'+data.substr(3, 2).trim());
            let ano = parseInt('0'+data.substr(6, 4).trim());
        } catch (e) {

        }
    }

    async function buscaContaCadastro(conta) {
        try {

            const response = await requisicao('GET', `/Sisplan/escretorno/v1/contacadastro?&CONTA=${conta}&TODAS_EMPRESAS=${$('#cbTodasEmpresas').prop('checked')}`, '')

            if (!response) {
                return;
            }
            return await response.text();

        } catch (e) {
            console.log(e);
        }
    }

    async function verificaCarteira240Pos(carteira) {
        try {
            const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"CARTEIRA",
                        "camposSelect":["CARTEIRA.POSICOES_240"],
                        "where": ["EXISTS (SELECT C.CONTA FROM [CADCONTA] C WHERE C.BANCO = '${pegaChave('#txtBanco')}' AND CARTEIRA.CONTA = C.CONTA)", "CARTEIRA.CARTEIRA = '${carteira}'"]}`,
            )

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = jsonStr.RESULT[0];

            if (data.length > 1) {
                if (data[0].POSICOES_240 == 'S') {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (e) {
            console.log(e);
        }
    }

    $("#tutorial").on("click", function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: "Sair",
                closeBtnText: "Fechar",
                nextBtnText: "Próximo",
                prevBtnText: "Anterior",
                allowClose: false,
                animate: true,
                onNext: (Element) => {
                    if ((Element.node.id == 'verBaixas')) {
                        $('#verBaixas').trigger('click');
                    };
                },
                onPrevious: (Element) => {
                    if (Element.node.id == 'fieldset2') {
                        $('#voltar2').trigger('click');
                    }
                }
            });

            driver.defineSteps([
                {
                    element: "#fieldset1",
                    popover: {
                        title: "Dados",
                        description:
                            "Aqui você informa os dados da ocorrência.",
                        position: "right",
                    },
                },
                {
                    element: "#voltar1",
                    popover: {
                        title: "Botão Voltar",
                        description:
                            "Clique neste botão para voltar para a tela de acesso.",
                        position: "right",
                    },
                },
                {
                    element: "#verBaixas",
                    popover: {
                        title: "Botão Gravar",
                        description: "Clique neste botão para avançar para a aba Configuração.",
                        position: "top",
                    },
                },
                {
                    element: "#fieldset2",
                    popover: {
                        title: "Configuração",
                        description: "Aqui você realiza a configuração da ocorrência.",
                        position: "top",
                    },
                },
                {
                    element: "#voltar2",
                    popover: {
                        title: "Configuração",
                        description: "Clique neste botão para voltar para a aba Geral.",
                        position: "top",
                    },
                },
                {
                    element: "#btnGravar",
                    popover: {
                        title: "Configuração",
                        description: "Clique neste botão para gravar os dados.",
                        position: "top",
                    },
                },
            ]);
            driver.start();
        });
    });

});