$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if (Element.node.id == "gravar") {
          $(".driver-next-btn").on("click", location.reload());
        }
      },
      onPrevious: (Element) => {
        if (Element.node.id == "formcard1") {
          $(".driver-close-btn").on("click", location.reload());
        }
      },
    });

    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#checkAtivo",
        popover: {
          title: "Ativo",
          description:
            "Aqui, definimos a etiqueta como ativa.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para a etiqueta.",
          position: "top",
        },
      },
      {
        element: "#txtOrdem",
        popover: {
          title: "Ordem",
          description:
            "Este campo, podemos adicionar um número da ordem, ou seguir com o número, que é gerado sequencialmente.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#gravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a etiqueta.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let etiqueta = parametros[parametros.length - 1];

  $("#txtCodigo").prop("disabled", true);

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("ETIQUETA", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/etiqueta`;
  });

  $(document).ready(function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#checkAtivo").prop("checked", true);

  try {
    let response = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"ETQ_PROD", 
                "camposSelect":["count(CODIGO) as CONTAGEM"], 
                "where": ["1 = 1"]}`,
      null
    );
    let jsonStr = await response.json();
    $("#txtOrdem").val(jsonStr.RESULT[0][0].CONTAGEM + 1);
  } catch (error) {
    console.error(error);
  }

  if (etiqueta != "" && etiqueta != "create") {
    if ((await liberarRegistro("ETIQUETA", etiqueta)) == false) {
      window.location.href = "../etiqueta";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let response1 = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"ETQ_PROD", 
                    "camposSelect":["codigo", "descricao", "ativo", "ordem"], 
                    "where": ["codigo = '${etiqueta}'"]}`,
            null
          );

          if (!response1) {
            return;
          }
          let jsonStr1 = await response1.json();
          if (response1.status != 200) {
            msgErro(jsonStr1.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").val(jsonStr1.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr1.RESULT[0][0].DESCRICAO);
          $("#txtOrdem").val(jsonStr1.RESULT[0][0].ORDEM);

          if (jsonStr1.RESULT[0][0].ATIVO == "S") {
            $("#checkAtivo").prop("checked", true);
          } else {
            $("#checkAtivo").prop("checked", false);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $("#gravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        $.LoadingOverlay("show");

        let etiquetaClasse = {};

        etiquetaClasse.CODIGO =
          $("#txtCodigo").val() == ""
            ? await RetornaProximo("ETQ_PROD", "ETQ_PROD", "CODIGO", 4)
            : $("#txtCodigo").val();
        etiquetaClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();
        etiquetaClasse.ORDEM = $("#txtOrdem").val();

        if ($("#checkAtivo").prop("checked")) {
          etiquetaClasse.ATIVO = "S";
        } else {
          etiquetaClasse.ATIVO = "N";
        }

        let responseGrava = await requisicao(
          "POST",
          "/Sisplan/Cadastros/v1/etiqueta?",
          `JSON=${encodeURIComponent(JSON.stringify(etiquetaClasse))}`,
          null
        );

        if (!responseGrava) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStrGrava = await responseGrava.json();
        if (responseGrava.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStrGrava.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(
            `Cadastro efetuado com sucesso!
                         Etiqueta: ${etiquetaClasse.CODIGO}`,
            "Confirmação",
            {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/etiqueta`;
              },
            }
          )
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });
});
