$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui você pode aplicar os filtros para gerar os resultados que deseja',
        position: 'bottom'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Impressão',
        description: 'Neste botão, você poderá imprimir um relatório sobre os dados gerados.',
        position: 'bottom'
      }
    },
    {
      element: '#tabelaComissao',
      popover: {
        title: 'Lista Representantes',
        description: 'Aqui é apresentado os representantes e seus valores de venda/comissão/meta.',
        position: 'top'
      }
    },
    {
      element: '#tabelaComissaoCoord',
      popover: {
        title: 'Lista Coordenadores',
        description: 'Aqui é apresentado os coordenadores e os valores gerados a partir das vendas de seus representantes.',
        position: 'top'
      }
    },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  $('#txtVendedor').pesquisa_variosServerside(1, '{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'CODREP', 'NOME');
  $('#txtCoordenador').pesquisa_variosServerside(1, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');

  $('#btnVendedor').pesquisa_serversideSel('#txtVendedor', `{ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}`, 'Pesquisa Vendedor');

  $('#btnCoordenador').pesquisa_serversideSel('#txtCoordenador', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa Coordenador');

  $("#btnLimpaVendedor").on("click", function () {
    $('#txtVendedor').empty().trigger('change');
  });

  $("#btnLimpaCoordenador").on("click", function () {
    $('#txtCoordenador').empty().trigger('change');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtVendedor').empty().trigger('change');
    $('#txtCoordenador').empty().trigger('change');
    $('#dtInicioDe').val('1200-01-01');
    $('#dtInicioAte').val('2500-12-31');
  });

  //Modais
  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const url = `/sisplan/impressao/v1/imprimirfechamentocomissao?`;
        const Filtros = await preencheFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelFechamentoComissao');
        const arquivo = await GeraRelatorio(`${url}${Filtros}`, "GET", 100000, false, 'RelFechamentoComissao');

        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function preencheFiltros() {
    try {
      const dtInicioDe = $('#dtInicioDe').val() != '1200-01-01' ? `&DATA_DE=${$('#dtInicioDe').val()}` : '';
      const dtInicioAte = $('#dtInicioAte').val() != '2500-12-31' ? `&DATA_ATE=${$('#dtInicioAte').val()}` : '';
      const vendedores = $('#txtVendedor').val().length > 0 ? `&VENDEDORES=${await formataListas($('#txtVendedor').val().toString())}` : '';
      const coordenadores = $('#txtCoordenador').val().length > 0 ? `&COORDENADORES=${await formataListas($('#txtCoordenador').val().toString())}`.trim() : '';

      const filtrosTela = `TESTE=1${vendedores}${coordenadores}${dtInicioDe}${dtInicioAte}`;
      return filtrosTela;

    } catch (error) {
      console.error(error);
    }
  }

  async function limpaTabela() {
    $('#tabelaComissao').DataTable().destroy().draw(false);
    $('#tabelaComissao').html('<thead></thead><tbody></tbody>');
  }

  async function montaTabelaCoordenadores(coordenadores) {

    if ($.fn.DataTable.isDataTable('#tabelaComissaoCoord')) {
      $('#tabelaComissaoCoord').DataTable().destroy();
      $('#tabelaComissaoCoord').empty();
    };


    if ((!coordenadores) || (coordenadores.length == 0)) {
      return;
    }

    dadosCoordenadores = coordenadores.map(coord => { return { ...coord, DETALHES: '' } });
    const dataSetCols = [];
    const keys = Object.keys(coordenadores[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $("#tabelaComissaoCoord").DataTable({
      paging: false,
      filter: true,
      info: false,
      order: false,
      destroy: true,
      scrollX: '250px',
      scrollY: '290px',
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      autoWidth: true,
      data: dadosCoordenadores,
      columns: dataSetCols,
      "columnDefs": [
        {
          targets: [6,7],
          visible: false
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          "targets": [3, 4, 8]
        },
        {
          render(data) {
            return parseFloat(data).toLocaleString("pt-BR", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }) + ' %';
          },
          targets: [5],
        },
      ],
    });


    // $('.btnDetalhesCoord').o\\n('click', async function () {
    //   try {
    //     $.LoadingOverlay('show');
    //     const tr = this.closest('tr');
    //     const dados = $('#tabelaComissao').DataTable().row($(tr)).data();
    //     const codRep = dados.CODREP;
    //     const nomeRep = dados.NOME_REP;
    //     $('#modal-vendas .modal-title').html(`Vendas Representante - ${nomeRep}`);
    //     await buscaTabelaVendasRep(codRep);
    //     $('#modal-vendas').modal('show');
    //     $(`#tabelaVendasRep`).DataTable().columns.adjust().draw(false);
    //   } finally {
    //     $.LoadingOverlay('hide');
    //   }
    // });
  }

  function copyAndTransformKeysToUppercase(obj) {
    return Object.keys(obj).reduce((acc, key) => {
      acc[key.toUpperCase()] = obj[key];
      return acc;
    }, {});
  }

  async function buscaTabelaVendasRep(codrep) {
    const dataSetCols = [];
    if ($.fn.DataTable.isDataTable('#tabelaVendasRep')) {
      $('#tabelaVendasRep').DataTable().destroy();
      $('#tabelaVendasRep').empty();
    };

    try {
      const dataIni = "'" + $('#dtInicioDe').val() + "'";
      const dataFim = "'" + $('#dtInicioAte').val() + "'";

      const pesquisaVendas = {
        camposSelect: [],
        tabela: "venda",
        leftjoin: [{
          tabela: "entidade",
          condicao: "entidade.codcli = venda.codcli"
        },
        {
          tabela: "itvenda",
          condicao: "itvenda.codven = venda.codven and itvenda.emp_id = venda.emp_id"
        }
        ],
        groupby: [],
        orderby: ["venda.codven desc"],
        where: []
      }

      const separador = "' - '";
      const iEmpID = getCookie('emp_id');

      pesquisaVendas.camposSelect = pesquisaVendas.camposSelect.concat([
        "VENDA.CODVEN VENDA",
        `VENDA.CODCLI|| ${separador}||ENTIDADE.NOME CLIENTE`,
        `CASE WHEN (VENDA.CANCELADA = 0 AND VENDA.FECHADA = 0 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO=0) THEN 'Pendente'` +
        `WHEN ((SELECT CANCELADA FROM VENDA_001 WHERE CODVEN = VENDA.CDAGRUPADA) = 1) THEN 'CANCELADA'` +
        `WHEN (VENDA.CANCELADA = 1 AND VENDA.CONSIG_FINALIZADO = 'S' AND VENDA.TIPO_VENDA = 1) THEN 'AGRUPADA'` +
        `WHEN ((VENDA.CANCELADA = 1) AND ((VENDA.CONSIG_FINALIZADO IS NULL OR VENDA.CONSIG_FINALIZADO <> 'S'))) THEN 'CANCELADA'` +
        `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 1 AND VENDA.TROCA = 0 AND VENDA.DEVOLUCAO = 0 AND VENDA.ORCAMENTO = 0 OR (VENDA.IMPRESSO = 1 AND VENDA.ORCAMENTO = 1) OR (VENDA.CONSIG_FINALIZADO = 'S')) THEN 'Fechada'` +
        `WHEN (VENDA.CANCELADA = 0  AND VENDA.FECHADA = 0 AND (VENDA.TROCA = 1 OR VENDA.DEVOLUCAO = 1 AND VENDA.ORCAMENTO = 0)) THEN 'Devolucao/Troca'` +
        `ELSE 'Orcamento' END STATUS`,
        "VENDA.NRCAIXA", 
        "VENDA.DATA",
        "VENDA.HR_VENDA", 
        "CASE WHEN VENDA.DEVOLUCAO = 1 THEN -VENDA.VALOR ELSE VENDA.VALOR END VALOR",
        "SUM(CASE WHEN VENDA.DEVOLUCAO = 1 THEN -ITVENDA.QUANTIDADE ELSE ITVENDA.QUANTIDADE END) QTDE_ITENS"
      ]);

      pesquisaVendas.groupby = pesquisaVendas.groupby.concat([
        "VENDA.CODVEN",
        "VENDA.TIPO_VENDA",
        "VENDA.EMP_ID",
        "VENDA.CODCLI",
        "ENTIDADE.NOME",
        "VENDA.FECHADA",
        "VENDA.CANCELADA",
        "VENDA.ORCAMENTO",
        "VENDA.TROCA",
        "VENDA.CONSIG_FINALIZADO",
        "VENDA.DEVOLUCAO",
        "VENDA.IMPRESSO",
        "VENDA.NRCAIXA",
        "VENDA.CDAGRUPADA",
        "VENDA.DATA",
        "VENDA.HR_VENDA",
        "VENDA.VALOR",
        "VENDA.CODREP"
      ]);

      pesquisaVendas.where.push(`VENDA.CODREP = '${codrep}' AND VENDA.EMP_ID = ${iEmpID} AND (VENDA.FECHADA = 1 OR VENDA.DEVOLUCAO = 1) AND VENDA.CANCELADA = 0 AND (VENDA.DATA >= ${dataIni} AND VENDA.DATA <= ${dataFim})`);
      const empresa = getCookie('empresa');
      const url = `/sisplan/funcoes/v1/pesquisa?empresa=${empresa}&JSON=${JSON.stringify(pesquisaVendas)}`;


      const response = await requisicao(
        "GET",
        '',
        url,
        null,
        60000
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let dataSet = [];

      if (!jsonStr['RESULT'][0]) {
        dataSet.push(jsonStr['RESULT'][0]);
      } else {
        dataSet = jsonStr['RESULT'][0];
      }

      const keys = Object.keys(dataSet[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k.toUpperCase(),
          data: k.toUpperCase(),
        });
      });

      dataSetCols[2].render = function (data, type, row) {
        if (row["STATUS"] == 'PENDENTE') {
          return '<div class="d-flex"><i class="fas fa-circle text-green mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'AGRUPADA') {
          return '<div class="d-flex"><i class="fas fa-circle text-purple mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'CANCELADA') {
          return '<div class="d-flex"><i class="fas fa-circle text-red mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'FECHADA') {
          return '<div class="d-flex"><i class="fas fa-circle text-blue mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else if (row["STATUS"].toUpperCase() == 'DEVOLUCAO/TROCA') {
          return '<div class="d-flex"><i class="fas fa-circle text-yellow mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        } else {
          return '<div class="d-flex"><i class="fas fa-circle text-grey mr-2"></i><p> ' + row["STATUS"] + '</p></div>';
        }
      }

      dataSetCols[4].type = 'date-br';
      dataSetCols[4].render = function (data, type, row) {
        var isIE = function () {
          if (/MSIE/i['test'](navigator['userAgent']) == true || /Edge/i['test'](navigator[
            'userAgent']) == true) {
            return true;
          } else {
            return false;
          }
        }
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return x[2] + "/" + x[1] + "/" + x[0] + row['HR_VENDA'].slice('10');
        } else {
          x = data.slice(0, 10).split('-');
          return x[2] + "/" + x[1] + "/" + x[0] + row['HR_VENDA'].slice('10');
        }
      }

      $("#tabelaVendasRep").DataTable({
        paging: false,
        filter: true,
        info: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '290px',
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: dataSet,
        columns: dataSetCols,
        "columnDefs": [
          {
            targets: [5],
            visible: false
          }
        ],
      });

    } catch (error) {
      console.log(error);
    }
    finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaTabelaComissao() {
    const dataSetCols = [];
    if ($('#tabelaComissao')[0].rows.length > 0) {
      await limpaTabela();
    }
    $('#divTabelaComissao').removeClass('d-none')
    if ($.fn.DataTable.isDataTable('#tabelaComissao')) {
      $('#tabelaComissao').DataTable().destroy();
      $('#tabelaComissao').empty();
    };

    try {

      const filtrosTela = await preencheFiltros();
      const url = `/sisplan/impressao/v1/consultafechamentocomissao?`;
      const response = await requisicao(
        "GET",
        url,
        filtrosTela,
        null,
        60000
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      const listaCoordenadores = jsonStr.comissaoCoordenador ? jsonStr.comissaoCoordenador.map(dado => copyAndTransformKeysToUppercase(dado))
                                                             : [];
      await montaTabelaCoordenadores(listaCoordenadores);

      if (jsonStr.comissaoRepresentante.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtVendedor").val();
        $("#txtCoordenador").val();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }


      const retornoTratado = jsonStr.comissaoRepresentante.map(comissao => copyAndTransformKeysToUppercase(comissao));
      
      const dados = retornoTratado.map(rep => { return { ...rep, DETALHES: '' } });
      const keys = Object.keys(retornoTratado[0]);


      dataSetCols.push({
        title: 'DETALHES',
        data: 'DETALHES',
      });

      keys.forEach((k) => {
        dataSetCols.push({
          title: k.toUpperCase(),
          data: k.toUpperCase(),
        });
      });


      $("#tabelaComissao").DataTable({
        paging: false,
        filter: true,
        info: false,
        order: false,
        destroy: true,
        scrollX: '250px',
        scrollY: '290px',
        // "pageLength": qtdeLinhasTabela,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: dados,
        columns: dataSetCols,
        "columnDefs": [
          {
            targets: [0],
            render: function (data, type, row) {
              return retornaBotaoDetalhesRep(data);
            }
          },
          {
            targets: [7, 8],
            visible: false
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            "targets": [4, 5, 9]
          },
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }) + ' %';
            },
            targets: [6],
          },
        ],
      });

      $('.btnDetalhesRep').on('click', async function () {
        try {
          $.LoadingOverlay('show');
          const tr = this.closest('tr');
          const dados = $('#tabelaComissao').DataTable().row($(tr)).data();
          const codRep = dados.CODREP;
          const nomeRep = dados.NOME_REP;
          $('#modal-vendas .modal-title').html(`Vendas Representante - ${nomeRep}`);
          await buscaTabelaVendasRep(codRep);
          $('#modal-vendas').modal('show');
          $(`#tabelaVendasRep`).DataTable().columns.adjust().draw(false);
        } finally {
          $.LoadingOverlay('hide');
        }
      });


    } catch (error) {
      console.log(error);
    }
    finally {
      $.LoadingOverlay('hide')
    }
  }

  function retornaBotaoDetalhesRep(data) {
    const retorno = '<div style="text-align:center;"> ' +
      '    <button title="Vendas Representante" class="btn btn-info btn-sm btnDetalhesRep" type="button"> ' +
      '    <i class="fas fa-chart-bar"></i>          ' +
      '    </button> ' +
      '</div>';
    return retorno;
  };


  $("#btnConsultar").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        await buscaTabelaComissao();

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay("hide");
      $("#modal-filtros").modal("hide");
    }
  });
  $("#btnFiltros").trigger('click');
});
