<div class="modal fade" id="modalMostraJsonPendente" data-backdrop="static" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h4 id="modalMostraJsonPendente-titulo" class="modal-title">Vendas não salvas</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col-12">
                <div class="card-body table-responsive">
                  <p><b>Tabela Vendas</b></p>
                  <table id="tabelaVendasGravadasPendentes" width="100%" class="table table-sm table-select table-hover">
                    <thead>
                      <tr>
                        <th>CODVEN</th>
                        <th>CLIENTE</th>
                        <th>CAIXA</th>
                        <th>USUARIO</th>
                        <th>TIPO VENDA </th>
                        <th>ID_ABA</th>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-sm-12">
            <button type="button" class="btn btn-danger btnConfimaVenda"> Abrir Venda Selecionada</button>
            <button type="button" class="btn btn-secondary btnAbrirVendaNova"> Iniciar Nova Venda</button>
            <button type="button" class="btn btn-secondary btnAbrirDevolucaoNova"> Iniciar Nova Devolução</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modalItensJsonPendente" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h4 id="modalItensJsonPendente-titulo" class="modal-title">Itens</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col-lg-6 col-sm-12 col-12">
                <div class="row">
                  <div class="col-sm-6 col-12">
                    <div class="form-group" style="text-align:center">
                      <label for="infoprodtam">Foto</label>
                      <div class="relative" style="display: flex;justify-content: center;align-items: center;">
                        <img class="pop img img-fluid" id="infoprodimagem" style="max-height:230px;max-width:230px;margin-left: auto;margin-right: auto;" src="<?php echo BASE_URI; ?>/dist/img/prod-1.png">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-6 col-12">
                    <div class="row">
                      <div class="col-sm-12 col-12">
                        <div class="form-group">
                          <label for="infoprodcodigo">Produto</label>
                          <div class="relative">
                            <input type="text" placeholder="Produto" class="input-default focus form-control" id="infoprodcodigo" name="infoprodcodigo" readonly>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12 col-12">
                        <div class="form-group">
                          <label for="infoprodcor">Cor</label>
                          <div class="relative">
                            <input type="text" placeholder="Cor" class="input-default focus form-control" id="infoprodcor" name="infoprodcor" readonly>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12 col-12">
                        <div class="form-group">
                          <label for="infoprodtam">Tamanho</label>
                          <div class="relative">
                            <input type="text" placeholder="Tamanho" class="input-default focus form-control" id="infoprodtam" name="infoprodtam" readonly>
                          </div>
                        </div>
                      </div>
                      <div class="col-sm-12 col-12">
                        <div class="form-group">
                          <label for="infoprodpreco">Preço</label>
                          <div class="relative">
                            <input type="text" placeholder="Preço" class="input-default focus form-control" id="infoprodpreco" name="infoprodpreco" readonly>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-6 col-12">
                <div class="card-body table-responsive">
                  <p><b>Tabela Itens</b></p>
                  <table id="tabelaItensVendaGravadasPendentes" width="100%" class="table table-sm table-select table-hover">
                    <thead>
                      <tr>
                        <td>CODIGO</td>
                        <td>DESCRICAO</td>
                        <td>COR</td>
                        <td>TAMANHO</td>
                        <td>BARRA</td>
                        <td>VALOR</td>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <div class="row">
          <div class="col-sm-12">
            <button type="button" class="btn btn-danger btnConfimaVenda"> Abrir Venda Selecionada</button>
            <button type="button" class="btn btn-secondary btnAbrirVendaNova d-none"> Iniciar Nova Venda</button>
            <button type="button" class="btn btn-secondary btnAbrirDevolucaoNova d-none"> Iniciar Nova Devolução</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  $(document).ready(async function() {

    criaDataTablePadrao('#tabelaVendasGravadasPendentes', false, false, false, false, true, false, false, null, null, []);
    criaDataTablePadrao('#tabelaItensVendaGravadasPendentes', false, false, false, false, true, false, false, null, null, [3]);

    async function carregaVendaNaoSalva(sNomeMaquina) {
      let myHeaders = new Headers();
      let response;
      myHeaders.append('pragma', 'no-cache');
      myHeaders.append('cache-control', 'no-cache');
      try {
        response = await fetch(`<?php echo BASE_URI; ?>/${sNomeMaquina}`, {
          headers: myHeaders,
          method: 'GET',
          body: null,
        }, );
      } catch (error) {
        return;
      }
      return response;
    }

    async function listaArquivosIdMaquina() {
      let response;
      try {
        response = await fetch(`lista_arquivos_venda.php?ID_MAQUINA=${getCookie('idMaquina')}`, {
          method: 'GET',
          body: null,
        }, );
        const listasArquivo = await response.text();

        return listasArquivo;

      } catch (error) {
        console.error(error);
      }
    }

    async function mostraVendasNaoSalvas() {
      $('#tabelaVendasGravadasPendentes').DataTable().clear().draw(false);
      const arquivos = JSON.parse(await listaArquivosIdMaquina());
      for (let i = 0; i < arquivos.length; i++) {
        const id = arquivos[i].split('-')[1];
        const response = await carregaVendaNaoSalva(arquivos[i]);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro('Erro ao carregar os arquivos da venda');
          return;
        }

        const dadosVenda = await response.json();

        $('#tabelaVendasGravadasPendentes').DataTable().row.add([
          dadosVenda.codVen ?? '',
          dadosVenda.nome_Consumidor,
          dadosVenda.nrCaixa,
          dadosVenda.usuario,
          dadosVenda.devolucao ? 'DEVOLUÇÃO' : 'VENDA',
          id,
        ]).draw(false);
      }

      if ($('#tabelaVendasGravadasPendentes').DataTable().rows().count() == 0) {
        return false;
      }

      return true;
      $('#tabelaVendasGravadasPendentes').DataTable().columns.adjust().draw(false);
    }

    $('#tabelaVendasGravadasPendentes tbody').on('dblclick', 'tr', async function() {
      $(this).addClass('selected');
      $('#tabelaItensVendaGravadasPendentes').DataTable().rows().remove().draw(false);
      const indice = this.closest('tr').rowIndex - 1;
      const data = $('#tabelaVendasGravadasPendentes').DataTable().rows(indice).data();
      const hostname = `JsonVenda-${data[0][5]}-${getCookie('idMaquina')}.txt`;

      const response = await carregaVendaNaoSalva(hostname);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro('Erro ao carregar os arquivos da venda');
        return;
      }

      const dadosVenda = await response.json();
      for (let i = 0; i < dadosVenda.itens.length; i++) {
        $('#tabelaItensVendaGravadasPendentes').DataTable().row.add([
          dadosVenda.itens[i].codigo ?? '',
          dadosVenda.itens[i].descricao,
          dadosVenda.itens[i].desc_Cor,
          dadosVenda.itens[i].tam,
          dadosVenda.itens[i].barra,
          dadosVenda.itens[i].valor
        ]).draw(false);

      }

      $('#modalItensJsonPendente').modal('show');

    });

    $('#tabelaItensVendaGravadasPendentes tbody').on('click', 'tr', async function() {
      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
        $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
        $("#infoprodcodigo").val('');
        $("#infoprodcor").val('');
        $("#infoprodtam").val('');
        $("#infoprodpreco").val('');
      } else {
        $('#tabelaItensVendaGravadasPendentes').DataTable().$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        if ($('#tabelaItensVendaGravadasPendentes').DataTable().rows().count() == 0) {
          $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
          $("#infoprodcodigo").val('');
          $("#infoprodcor").val('');
          $("#infoprodtam").val('');
          $("#infoprodpreco").val('');
        } else {
          var data = $('#tabelaItensVendaGravadasPendentes').DataTable().row(this.rowIndex - 1).data();
          var codigo = data[0];
          $("#infoprodcodigo").val(data[0] + ' - ' + data[1]);
          $("#infoprodpreco").val(data[5]);
          $("#infoprodcor").val(data[2]);
          $("#infoprodtam").val(data[3]);
          await buscaFoto(codigo);
        }
      }
    });

    async function buscaFoto(codigo) {
      try {
        var _url = '/Sisplan/Funcoes/v1/FotoItem?';
        var response = await requisicao('GET', _url, 'codigo=' + codigo, null);

        if (!response) {
          return;
        }

        var jsonStr = await response.json();
        if (response.status != 200) {
          $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
          return;
        }

        var sBase64 = jsonStr;
        if ($('#tabelaItensVendaGravadasPendentes').DataTable().rows().count() == 0) {
          $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
        } else {
          $("#infoprodimagem").attr('src', 'data:image/png;base64,' + sBase64.mensagem);
        }

      } catch (error) {
        console.error(error);
        $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
      }
    }

    $('#tabelaVendasGravadasPendentes tbody').on('click', 'tr', async function() {
      let table = $('#tabelaVendasGravadasPendentes').DataTable();

      if ($(this).hasClass('selected')) {
        $(this).removeClass('selected');
      } else {
        table.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
      }

      // if ($(this).hasClass('selected')) {
      //   $(this).removeClass('selected');
      // } else {
      //   $(this).addClass('selected');
      // }
    });

    async function alteraNomeArquivo(id, nomeAntigo) {
      let response;
      try {
        response = await fetch(`lista_arquivos_venda.php?ALTERAR_ARQUIVO=S&ID_MAQUINA=${getCookie('idMaquina')}&NOME_ANTIGO=${nomeAntigo+'.txt'}&ID=${sessionStorage.getItem('g_idAba')}`, {
          method: 'GET',
          body: null,
        }, );

        const novoNome = await response.text();

        return novoNome;

      } catch (error) {

      }
    }

    async function liberarVenda(iCodVen) {
      try {
        $.LoadingOverlay("show");
        var response = await requisicao('POST', '/sisplan/controleedicao/v1/controleedicao?', `valor=${iCodVen}&tela=LOJA`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return false;
        }

        var jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgAlerta(jsonStr.mensagem);
          return false;
        } else {
          $.LoadingOverlay("hide");
          return true;
        }
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro('Não foi possível alterar a venda: ' + error)
      }
    };

    $('.btnConfimaVenda').on('click', async function() {
      $.LoadingOverlay("show");
      try {
        if ($('#tabelaVendasGravadasPendentes tr.selected').length == 0) {
          msgErro('Selecione uma venda pendente para conseguir confirmar.');
          return;
        }

        const id = $('#tabelaVendasGravadasPendentes').DataTable().rows('.selected').data()[0][5];
        const nomeAntigo = `JsonVenda-${id}-${getCookie('idMaquina')}`;
        let novoNome;
        let dadosVenda;
        let response;

        response = await carregaVendaNaoSalva(nomeAntigo + '.txt');
        dadosVenda = await response.json();

        if (dadosVenda.codVen) {
          const vendaLiberada = await liberarVenda(dadosVenda.codVen);
          if (vendaLiberada) {
            novoNome = await alteraNomeArquivo(id, nomeAntigo);
            response = await carregaVendaNaoSalva(novoNome);
            dadosVenda = await response.json();
            window.location.href = "venda/" + dadosVenda.codVen;
          }
        } else {
          novoNome = await alteraNomeArquivo(id, nomeAntigo);
          if (dadosVenda.devolucao) {
            window.location.href = 'devolucao/vendapendente';
          } else {
            window.location.href = 'venda/vendapendente';
          }
        }

      } finally {
        $.LoadingOverlay("hide");
      }
    });

    $('.btnAbrirVendaNova').on('click', function() {
      window.location.href = 'venda/create';
    });

    $('.btnAbrirDevolucaoNova').on('click', function() {
      window.location.href = 'devolucao/create';
    });

    $('#modalItensJsonPendente').on('shown.bs.modal', function() {
      $("#infoprodimagem").attr('src', '<?php echo BASE_URI; ?>/dist/img/prod-1.png');
      $("#infoprodcodigo").val('');
      $("#infoprodcor").val('');
      $("#infoprodtam").val('');
      $("#infoprodpreco").val('');

      $('#tabelaVendasGravadasPendentes').DataTable().columns.adjust().draw(false);
      $('#tabelaItensVendaGravadasPendentes').DataTable().columns.adjust().draw(false);

    });

    $('#modalMostraJsonPendente').on('shown.bs.modal', function() {
      $('#tabelaVendasGravadasPendentes').DataTable().columns.adjust().draw(false);
      $('#tabelaItensVendaGravadasPendentes').DataTable().columns.adjust().draw(false);
    });

    $('#abrirVendasNaoSalvas').on('click', async function() {
      if (await mostraVendasNaoSalvas()) {
        $('#modalMostraJsonPendente').modal('show');
      } else {
        msgAlerta('Não existem vendas não salvas!');
      }
    });

  });
</script>