<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Material</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">

  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.239.11.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.239.11.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.239.11.1">

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    .form-control:disabled,
    .form-control[readonly] {
      background-color: #f7f7f7;
      opacity: 1;
    }

    #msform {
      text-align: start;
      position: relative;
    }

    .card {
      box-shadow: none !important;
      border-radius: 0 !important;
      margin-bottom: 0 !important;
    }

    .card-header {
      box-shadow: 0px 1px rgb(0 0 0 / 20%) !important;
    }

    .card-body {
      padding-left: 1.25rem !important;
      padding-top: 0px;
      padding-bottom: 0px;
      padding-right: 1.25rem !important;
    }

    .fa-angle-right,
    .fa-angle-down {
      color: #343a40;
    }

    .header-content-page .title-page,
    .title-content-page .title,
    .title-page {
      font-size: 20px;
      line-height: normal;
      font-weight: 500;
      color: var(--font-color);
      margin: 0;
      font-family: Roboto, Arial, sans-serif;
    }

    #bordaImagem {
      width: 100%;
      height: 250px;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
    }

    #infoprodimagem {
      max-width: 100%;
      max-height: 230px;
      width: auto;
      height: auto;

    }

    #divImg {
      margin-left: 3%;
    }
  </style>


</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title">Modal title</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText">Modal body text goes here.</p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary btn-sisp">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary btn-sisp" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 col-12">
            </div><!-- /.col -->
            <div class="col-sm-6 col-12">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="../index">Início</a></li>
                <li class="breadcrumb-item"><a href="../material">Material</a></li>
                <li class="breadcrumb-item active">Cadastro Material</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>

      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card" style="height:auto;min-height:715px">
                <div class="card-header bg-dark flex">
                  <h2 class="m-0 text-white">Cadastro de Material</h2>

                  <button title="Tutorial" class="mt-2 btn btn-info btn-sm ml-2" id="tutorial">
                    <i class="fas fa-question-circle"></i>
                  </button>
                </div>
                <fieldset>
                  <div class="card-body">
                    <form style="text-align:left!important;" id="msform" name="msform">
                      <div class="card card-header" role="tab" id="geral">
                        <a style="width:100%;" data-toggle="collapse" data-parent="#multiCollapseExample1" href="#multiCollapseExample1" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-down"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Geral
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse  show" id="multiCollapseExample1">
                        <div class="card card-body">
                          <div class=" tab-pane fade show active" role="tabpanel" aria-labelledby="geral-tab">
                            <div class="form-row pt-2 pl-1">
                              <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="checkAtivo">
                                <label class="form-check-label pr-4" for="checkAtivo">Ativo</label>
                              </div>
                              <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="checkLiberado">
                                <label class="form-check-label pr-4" for="checkLiberado">Controla Estoque</label>
                              </div>
                            </div>
                            <div class="form-row">
                              <div class="row col-lg-8  col-12">
                                <div class="col-lg-3  col-12 form-group" id="tourcodigo">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                                  <input type="text" class="input-default focus form-control" readonly id="txtCodigo" name="txtCodigo" placeholder="Gerado automaticamente">
                                </div>
                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigoMestre">Código Mestre</label>
                                  <input type="text" class="input-default focus form-control" id="txtCodigoMestre" name="txtCodigoMestre" placeholder="Código Mestre">
                                </div>
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupo">Grupo
                                    *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtGrupo" name="txtGrupo" placeholder="Grupo">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAGrupo" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>

                                <div class="col-lg-6  col-12 form-group" id="tourdesc">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Descrição *</label>
                                  <input type="text" maxlength="100" class="input-default focus form-control validate" id="txtDescricao" name="txtDescricao" placeholder="Descrição">
                                </div>
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtSubgrupo">SubGrupo *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtSubgrupo" name="txtSubgrupo" placeholder="SubGrupo">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnSubgrupo" name="btnSubgrupo" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnASubgrupo" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtComplemento">Complemento</label>
                                  <div class="input-group">
                                    <input type="text" maxlength="300" class="input-default focus form-control" id="txtComplemento" name="txtComplemento" placeholder="Complemento">
                                  </div>
                                </div>
                                <div class="col-lg-3  col-12 form-group" id="tourund">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidade">Unidade *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtUnidade" name="txtUnidade" placeholder="Unidade">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnUnidade" name="btnUnidade" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAUnidade" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-3  col-12 form-group" id="tourundvenda">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtUnidadeCompra">Und Compra *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtUnidadeCompra" name="txtUnidadeCompra" placeholder="Unidade Compra">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnUnidadeCompra" name="btnUnidadeCompra" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAUnidadeCompra" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtFaixaTam">Faixa</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtFaixaTam" name="txtFaixaTam" placeholder="Faixa">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnFaixaTam" name="btnFaixaTam" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAFaixaTam" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPeso">Peso</label>
                                  <input type="text" class="input-default focus form-control" id="txtPeso" name="txtPeso" placeholder="Peso">
                                </div>
                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtKgHora">Kg.
                                    p/ Hora</label>
                                  <input type="text" class="input-default focus form-control" id="txtKgHora" name="txtKgHora" placeholder="Quilos por hora">
                                </div>
                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoReposicao">Preço Repos</label>
                                  <input type="text" class="input-default focus form-control" id="txtPrecoReposicao" name="txtPrecoReposicao" placeholder="Preço reposição">
                                </div>

                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtLinha">Linha</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtLinha" name="txtLinha" placeholder="Linha">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnALinha" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>


                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtFatorConversao">Fator Conversão</label>
                                  <input type="text" class="input-default focus form-control" id="txtFatorConversao" name="txtFatorConversao" placeholder="Fator conversão">
                                </div>
                                <div class="col-lg-2  col-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrecoUltCompra">Preço Ult. Comp.</label>
                                  <input type="text" class="input-default focus form-control" id="txtPrecoUltCompra" name="txtPrecoUltCompra" placeholder="Preço última compra">
                                </div>
                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCiclo">Ciclo</label>
                                  <input type="text" class="input-default focus form-control" id="txtCiclo" name="txtCiclo" placeholder="Ciclo">
                                </div>

                                <div class="col-lg-6  col-12 form-group" id="tourstatus">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtStatus">Status</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtStatus" aria-describedby="statusError" name="txtStatus" placeholder="Status">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnStatus" name="btnStatus" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAStatus" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>

                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtGramatura">Gramatura</label>
                                  <input type="text" class="input-default focus form-control" id="txtGramatura" name="txtGramatura" placeholder="Gramatura">
                                </div>
                                <div class="col-lg-2  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtLargura">Largura</label>
                                  <input type="text" class="input-default focus form-control" id="txtLargura" name="txtLargura" placeholder="Largura">
                                </div>
                                <div class="col-lg-2  col-12">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtTara">Tara</label>
                                  <input type="text" class="input-default focus form-control" id="txtTara" name="txtTara" placeholder="Tara">
                                </div>

                              </div>
                              <div class="col-lg-4">
                                <div id="divImg">
                                  <label class="labelGeral" data-success="right" for="imgProd">Imagem do
                                    material</label>
                                  <div class="d-flex justify-content-center" id="bordaImagem">
                                    <label id="btnEscolherFoto" class="btnEnviarFoto" for="fileimagem" data-button="absolute" type="button">
                                      <img class="pop img img-fluid imagem" id="infoprodimagem" src="./dist/img/prod-1.png">
                                    </label>
                                  </div>
                                  <div class="input-group-append" class="upload-imagem" style="margin-left: 35%; margin-top: .5%">
                                    <input type="file" value="" class="upload" style="display: none;" name="fileimagem" id="fileimagem" />
                                  </div>
                                </div>
                                <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab" style="margin-left: 3%;">
                                  <label class="labelGeral" data-success="right" for="tourtabelacores">Cores</label>
                                  <div class="form-row" id="tourtabelacores">
                                    <div class="col-lg-12 form-card" id="datatables">
                                      <div id="tabelacorestour">
                                        <table id="tabelaFaixaCor" class="table table-sm table-select table-hover">
                                          <thead>
                                            <tr>
                                              <th class="th-sm">Cor</th>
                                              <th class="th-sm">Descrição</th>
                                              <th class="th-sm">Ações</th>
                                            </tr>
                                          </thead>
                                          <tbody>
                                          </tbody>
                                        </table>
                                      </div>
                                    </div>
                                    <div class="col-lg-2">
                                      <button id="btnAbrirCondicao" style="font-size: 14px" type="button" class="btn btn-lg btn-secondary">
                                        Adicionar
                                      </button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card card-header" role="tab">
                        <a style="width:100%;" id="documentoaba" data-toggle="collapse" data-parent="#multiCollapseExample2" href="#multiCollapseExample2" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Tributações
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>

                      <div class="collapse" id="multiCollapseExample2">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="documento-tab">
                            <div class="form-row pt-2">
                              <div class="col-lg-3  col-12 form-group" id="tourncm">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNcm">Código
                                  NCM *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtNcm" required aria-describedby="ncmError" name="txtNcm" class="form-control" placeholder="Código NCM">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnNcm" name="btnNcm" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnANcm" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-3  col-12 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtExtIpi">Código
                                  EXTIPI</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtExtIpi" name="txtExtIpi" class="form-control" placeholder="Código EXTIPI">
                                </div>
                              </div>
                              <div class="col-lg-3  col-12 form-group" id="touricms">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIcmsEntrada">CST ICMS Entrada *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtCstIcmsEntrada" name="txtCstIcmsEntrada" required aria-describedby="icmsError" class="form-control" placeholder="CST ICMS">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnCstIcmsEntrada" name="btnCstIcms" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnACstIcmsEntrada" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-3  col-12 form-group" id="touricms">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIcmsSaida">CST
                                  ICMS Saída *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtCstIcmsSaida" name="txtCstIcmsSaida" required aria-describedby="icmsError" class="form-control" placeholder="CST ICMS">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnCstIcmsSaida" name="btnCstIcms" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnACstIcmsSaida" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-3  col-12 form-group" id="toursped">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtSped">Código
                                  SPED *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtSped" name="txtSped" required aria-describedby="spedError" class="form-control" placeholder="Código SPED">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnSped" name="btnSped" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnASped" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-3  col-12 form-group" id="toureipi">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpiEntrada">CST IPI Entrada *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtCstIpiEntrada" name="txtCstIpiEntrada" required aria-describedby="ipiError" class="form-control" placeholder="CST IPI Entrada">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnCstIpiEntrada" name="btnCstIpiEntrada" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnACstIpiEntrada" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-3  col-12 form-group" id="toursipi">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpiSaida">CST IPI Saída *</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtCstIpiSaida" name="txtCstIpiSaida" required aria-describedby="ipiSError" class="form-control" placeholder="CST IPI Saída">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnCstIpiSaida" name="btnCstIpiSaida" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnACstIpiSaida" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-3  col-12">
                                <div class="row">
                                  <div class="col-lg-6  col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtIpi">%
                                      IPI</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtIpi" name="txtIpi" class="form-control" placeholder="% IPI">
                                    </div>
                                  </div>
                                  <div class="col-lg-6  col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtIcms">%
                                      ICMS</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtIcms" name="txtIcms" class="form-control" placeholder="% ICMS">
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-7  col-12 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtNatureza">Natureza</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtNatureza" name="txtNatureza" class="form-control" placeholder="Natureza">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnNatureza" name="btnNatureza" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnANatureza" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-5 col-12 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="selectTrib">Tributação</label>
                                <div class="input-group">
                                  <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectTrib" class="custom-select focus">
                                    <option value="">Não informado</option>
                                    <option value="0">Normal</option>
                                    <option value="1">Diferenciada</option>
                                    <option value="2">01-Produto Importado</option>
                                    <option value="3">02-Produto Importado Mercado Interno</option>
                                    <option value="4">03-Conteúdo de importação maior 40% e inferior ou igual 70%
                                    </option>
                                    <option value="5">04-Conformidade Processos básicos</option>
                                    <option value="6">05-Conteúdo de importação menor ou igual 40%</option>
                                    <option value="7">06-Prod. Importdado sem similar nacional</option>
                                    <option value="8">07-Adquirido merc. interno sem similar nacional</option>
                                    <option value="9">08-Conteúdo de importação superior 70%</option>
                                  </select>
                                </div>
                              </div>
                              <div class="col-lg-7  col-12 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="txtEnqIpi">Enquadramento IPI</label>
                                <div class="input-group">
                                  <input type="text" class="input-default focus form-control" id="txtEnqIpi" name="txtEnqIpi" class="form-control" placeholder="Enquadramento IPI">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnEnqIpi" name="btnEnqIpi" data-button="absolute" type="button">
                                      <i class="m-0 p-0 fas fa-search"></i>
                                    </button>
                                    <button class="btn bg-danger" id="btnAEnqIpi" type="button">
                                      <i class="m-0 p-0 fas fa-trash"></i>
                                    </button>
                                  </div>
                                </div>
                              </div>
                              <div class="col-lg-5 col-12 form-group">
                                <label data-error="wrong" class="labelGeral" data-success="right" for="selectPosse">Posse *</label>
                                <div class="input-group">
                                  <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectPosse" required aria-describedby="tipoError" class="custom-select focus">
                                    <option value="">Não informado</option>
                                    <option value="0">00-Mercadoria de propriedade do informante e em seu poder</option>
                                    <option value="1">01-Mercadoria de propriedade do informante em poder de terceiros
                                    </option>
                                    <option value="2">02-Mercadoria de propriedade de terceiros em poder do informante
                                    </option>
                                  </select>
                                </div>
                              </div>
                              <div class="form-row">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card card-header" role="tab">
                        <a style="width:100%;" id="compra" data-toggle="collapse" data-parent="#multiCollapseExample4" href="#multiCollapseExample4" aria-expanded="true" aria-controls="collapseOne1">
                          <div class="row">
                            <div style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                              <i class="fas fa-angle-right"></i>
                            </div>
                            <div class="col-11">
                              <h4 class="title-page">
                                Tipo de Venda/Regra
                              </h4>
                            </div>
                          </div>
                        </a>
                      </div>
                      <div class="collapse" id="multiCollapseExample4">
                        <div class="card card-body">
                          <div class="tab-pane fade show active" role="tabpanel" aria-labelledby="venda-tab">
                            <div class="pt-2 form-row" id="tourtabelavenda">
                              <div class="col-lg-11 form-card" id="datatables">
                                <div id="tabelatipotour">
                                  <table id="tabelaVendaRegra" class="table table-sm table-select table-hover">
                                    <thead>
                                      <tr>
                                        <th class="th-sm">Tipo de venda</th>
                                        <th class="th-sm">Empresa</th>
                                        <th class="th-sm">Regra</th>
                                        <th class="th-sm">Descrição Regra</th>
                                        <th class="th-sm">Ações</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                  </table>
                                </div>
                              </div>
                              <div class="col-lg-1">
                                <button id="btnAbrirVendaRegra" style="font-size: 15px;" type="button" class="btn btn-lg btn-secondary float-right focus">
                                  Adicionar
                                </button>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <input id="gravar" type="button" style="font-size:15px;" class="btn btn-danger btn-sisp btn-lg action-button float-right" value="Gravar">
                      <button type="button" id="btnVoltar" style="font-size:15px;" class="btn btn-success btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                    </form>
                </fieldset>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
    <div class="modal fade" id="modalCondicao" tabindex="-1" role="dialog" aria-labelledby="modalCondicao" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 id="modalCondicao-titulo" class="modal-title">Adicionar Cor</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-sm-12">
                <div class="row">
                  <div class="col-sm-12">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="CondPagto">Selecionar cor</label>
                    <div class="input-group">

                      <input type="text" class="input-default focus form-control" id="txtCondPagto" name="txtCondPagto" class="form-control" placeholder="Selecionar cor">

                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-CondPagto" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpa-CondPagto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12" style="margin-top:5px">
                    <button id="btnAdicionar" type="button" class="btn btn-primary btn-block">
                      Adicionar
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal fade" id="modalAdicionarVendaRegra" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 id="modalContas-titulo" class="modal-title">Adicionar tipo de venda/regra</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-sm-12">
                <div class="row">
                  <div class="col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtTipoVenda">Tipo de venda</label>
                    <div class="input-group">
                      <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtTipoVenda" required aria-describedby="tipoError" class="custom-select focus">
                        <option disabled selected value=""></option>
                        <option value="0">0 - Produção</option>
                        <option value="1">1 - Revenda</option>
                      </select>
                      <!-- <input type="text" class="input-default focus form-control" id="txtTipoVenda" name="txtTipoVenda" class="form-control" placeholder="Tipo de venda"> -->
                    </div>
                  </div>
                  <div class="col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtEmpresaRegra">Empresa</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtEmpresaRegra" name="txtEmpresaRegra" class="form-control" placeholder="Empresa">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnEmpresaRegra" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnAEmpresaRegra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-4">
                    <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtRegra">Regra</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtRegra" name="txtRegra" class="form-control" placeholder="Regra">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnRegra" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnARegra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12" style="margin-top:5px">
                    <button id="btnAdicionarTipoRegra" type="button" class="btn btn-primary btn-block">
                      Adicionar
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <?php
    include_once('../../../footer.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script>
    function formatar(mascara, documento) {
      var i = documento.value.length;
      var saida = mascara.substring(0, 1);
      var texto = mascara.substring(i);

      if (texto.substring(0, 1) != saida) {
        documento.value += texto.substring(0, 1);
      }

    }
  </script>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.239.11.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.239.11.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.239.11.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.239.11.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.239.11.1"></script>

  <script src="../dist/js/adminlte.min.js?versao=3.239.11.1"></script>

  <script src="../dist/js/requisicoes.js?versao=3.239.11.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.239.11.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.239.11.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.239.11.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.239.11.1"></script>
  <script src="../utils/funcoes.js?versao=3.239.11.1"></script>
  <script src="../utils/cookies.js?versao=3.239.11.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.239.11.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('MATERIAL');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("MATERIAL");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {window.location.href = `${BASE_URI}/material`});
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split("/");
      const material = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        e.preventDefault();
        deletaRegistro("MATERIAL", getCookie("usuario"), material);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/material/cadastro_material/material.js?versao=3.239.11.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>