// eslint-disable-next-line no-unused-vars
class Metas {
  constructor(tipo, descricao, dtInicio, dtFinal, id) {
    this.tipo = tipo;
    this.descricao = descricao;
    this.dt_Inicio = dtInicio;
    this.dt_Final = dtFinal;
    this.id = id;

    this.url = '/sisplan/metas/v1/metas?';
  }

  validar() {
    if (this.tipo == '') {
      msgAlerta('Campo tipo não informado! ');
      return false;
    }
    if (this.descricao == '') {
      msgAlerta('Campo descrição não informado! ');
      return false;
    }
    if (this.dt_Inicio == '') {
      msgAlerta('Campo Data Inicial não informada! ');
      return false;
    }
    if (this.dt_Final == '') {
      msgAlerta('Campo Data Final não informada! ');
      return false;
    }

    return true;
  }

  async carregaDias() {
    const selectDias = {
      tabela: 'ANO',
      camposSelect: ["DATA", "DIA_UTIL"],
      where: [`DATA >= '${this.dt_Inicio.substring(0, 10)}' AND DATA <= '${this.dt_Final.substring(0, 10)}'`]
    };
    const sDados = await retornaJsonPesquisaPadrao(JSON.stringify(selectDias));

    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);
    dataSetCols.push({
      'data': 'SEL',
      'width': '15px'
    });

    dataSetCols[0].render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" checked class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
    };

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaDiasMeta', false, false, false, false, true, false, '400px', sDados, dataSetCols, [], [1]);

    $('.campoSel').on('click', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });
  }

  async carregaValoresMeta() {
    $('#tabelaValoresMetas').DataTable().rows().clear().draw(false);

    const dadosSelect = {
      tabela: 'METAVALORES',
      camposSelect: ["ID", "OPERACAO", "VALOR"],
      where: [`ID_META = ${$('#txtIdMeta').val()}`],
      orderby: ['ID'],
    };
    const json = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

    if (!json) {
      return;
    }

    const opcoes =
      '<div class="">' +
      '    <button class="btnMostraOpcoes btn btn-secondary" type="button" title="Opções" style="font-size: 0.8rem;">Ver Meta</span></button>      ' +
      '    <button class="btnMostraDias btn btn-secondary" type="button" title="Dias" style="font-size: 0.8rem;">Ver Dias</span></button>      ' +
      '    <button class="btnDeletarOpcoes btn btn-danger" type="button" title="Excluir" style="font-size: 0.8rem;">Excluir Meta</span></button>  ' +
      '</div>';

    this.valores = json;

    this.valores.forEach((consulta) => {
      $('#tabelaValoresMetas').DataTable().row.add(Object.values({ ...consulta, tipo: this.tipo ?? $('#txtTipoDaMeta').val(), opcoes })).draw(false);
    });

    $('.btnMostraOpcoes').on('click', function () {
      try {
        const dados = $('#tabelaValoresMetas').DataTable().row($(this).parents('tr')).data();

        const OpcoesMeta = new OpcoesMetas(dados[2], dados[1], [], [], $('#txtIdMeta').val(), dados[0]);

        OpcoesMeta.criaModalOpcoesMetas();
      } catch (error) {
        console.error(error);
      }
    });
    $('.btnDeletarOpcoes').on('click', function () {
      try {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
          const dados = $('#tabelaValoresMetas').DataTable().row($(this).parents('tr')).data();
          const OpcoesMeta = new OpcoesMetas(dados[2], dados[1], [], [], $('#txtIdMeta').val(), dados[0]);
          OpcoesMeta.deletarOpcoes();
        });
      } catch (error) {
        console.error(error);
      }
    });
    $('.btnMostraDias').on('click', function () {
      const dados = $('#tabelaValoresMetas').DataTable().row($(this).parents('tr')).data();

      const OpcoesMeta = new OpcoesMetas(dados[2], dados[1], [], [], $('#txtIdMeta').val(), dados[0]);

      OpcoesMeta.buscaDiasMeta();
    });
  }

  async criaModalOpcoes() {
    $('#titleModalMeta').html(`Modal Metas ${this.tipo}`);
    $('.btnGravaMeta').addClass('d-none');
    $(`.opcoesMetas`).addClass('d-none');
    console.log(this.tipo);
    $(`#btnGravarMeta${this.tipo}`).removeClass('d-none');
    $(`#${this.tipo}Metas`).removeClass('d-none');

    await this.carregaValoresMeta();
    await this.carregaDias();

    this.abreModalOpcoes();
  }

  abreModalOpcoes() {
    $('#txtDescricaoMeta').val(this.descricao);
    $('#txtTipoDaMeta').val(this.tipo);
    $('#txtDtInicialOpcoes').val(this.dt_Inicio.substring(0, 10));
    $('#txtDtFinalOpcoes').val(this.dt_Final.substring(0, 10));

    $('#modal-Metas').modal('show');

    $("#tabelaValoresMetas").DataTable().columns.adjust().draw(false);
  }

  async atualizaValoresTabelas() {
    this.consulta.forEach((consulta) => {
      var opcoes = '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + consulta.ID + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item btnOpcoes" type="button" title="Editar">Editar</button>' +
        '    <button class="dropdown-item btnDeletarMeta" type="button" title="Excluir">Excluir</button>' +
        '</div>';

      consulta.ID = opcoes

      $('#tabelaMetas').DataTable().row.add(Object.values({ ...consulta })).draw(false);
    });
  };

  async buscar(sGrava = false) {
    $.LoadingOverlay('show');
    try {

      $('#tabelaMetas').DataTable().rows().clear().draw(false);
      const dadosSelect = {
        tabela: `METAVENDA`,
        camposSelect: ["ID", "DESCRICAO", "TIPO", "EMP_ID", "DT_INICIO", "DT_FINAL"],
        orderby: ["ID"],
        where: null,
      };
      const json = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));

      if (!json) {
        return;
      }

      this.consulta = json;

      this.atualizaValoresTabelas();

      $('.btnOpcoes').on('click', function () {
        try {
          const dados = $('#tabelaMetas').DataTable().row($(this).parents('tr')).data();
          const idMeta = dados[0];

          const regex = /<button[^>]*>\s*([^<\s]*)\s*<\/button>/;
          const match = idMeta.match(regex);
          const numero = match ? match[1] : null;

          const meta = new Metas(dados[2], dados[1], dados[4], dados[5]);

          $('#txtIdMeta').val(numero)

          meta.criaModalOpcoes(numero);
        } catch (error) {
          console.error(error);
        }
      });

      $('.btnDeletarMeta').on('click', function () {
        try {
          msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            // const dados = $('#tabelaMetas').DataTable().row($(this).parents('tr')).data();
            const dados = $('#tabelaMetas').DataTable().row($(this).parents('tr')).data();
            const idMeta = dados[0];

            const regex = /<button[^>]*>\s*([^<\s]*)\s*<\/button>/;
            const match = idMeta.match(regex);
            const numero = match ? match[1] : null;
            const Meta = new Metas('', '', '', '', numero);
            Meta.deletar();
          });
        } catch (error) {
          console.error(error);
        }
      });

      if (sGrava) {
        $($('.btnOpcoes')[$('.btnOpcoes').length - 1]).trigger('click');
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async gravar() {
    const response = await requisicao('POST', this.url, ``, JSON.stringify(this));

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgErro(jsonStr.mensagem);
      return;
    }
    this.buscar(true);
    criaMensagemSucesso('Meta cadastrada com sucesso!');
  }

  async deletar() {
    const response = await requisicao('DELETE', this.url, `ID=${this.id}`, '', 15000);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgErro(jsonStr.mensagem);
      return;
    }
    this.buscar();
    criaMensagemSucesso('Meta deletada com sucesso!');
  }


}