$(document).ready(async function () {

  criaDataTablePadrao('#tabelaValoresMetas', false, false, false, false, true, false, false, null, null, []);
  criaDataTablePadrao('#tabelaOpcoesMetas', false, false, false, false, true, false, false, null, null, [], [5, 6]);
  criaDataTablePadrao('#tabelaMetas', false, false, false, false, true, false, false, null, null, [], [4, 5]);
  if ($('#tabelaMetas').DataTable().rows().count() < 6) {
    $('#tabelaMetas').css('min-height', '80px');
  }

  $('#txtLoja').pesquisa_varios(`{ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_NOME"], "where": null }`, 'EMP_ID', 'EMP_NOME');
  $("#btn-limpa-Loja").on("click", function () {
    $("#txtLoja").val("");
  });

  $('#txtVendedor').pesquisa_varios('{"tabela": "REPRESEN", "camposSelect": ["CODREP", "NOME"], "where": null }', 'CODREP', 'NOME');
  $("#btn-limpa-Vendedor").on("click", function () {
    $("#txtVendedor").val("");
  });

  $('#txtProduto').pesquisa_varios(`{ "tabela":"PRODUTO", "camposSelect":["CODIGO, DESCRICAO"], "where": null }`, 'CODIGO', 'DESCRICAO');
  $("#btn-limpa-Produto").on("click", function () {
    $("#txtProduto").val("");
  });

  $('#txtColecao').pesquisa_varios(`{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null }`, 'CODIGO', 'DESCRICAO');
  $("#btn-limpa-Colecao").on("click", function () {
    $("#txtColecao").val("");
  });

  $('#txtGrupo').pesquisa_varios(`{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null }`, 'CODIGO', 'DESCRICAO');
  $("#btn-limpa-Grupo").on("click", function () {
    $("#txtGrupo").val("");
  });


  $("#txtValorMeta").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtPercentual").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $('#check_todos').on('change', function () {
    $('.campoSel').prop('checked', $('#check_todos').prop('checked'));
    if ($('#check_todos').prop('checked')) {
      $('.campoSel').addClass('selecionado');
    } else {
      $('.campoSel').removeClass('selecionado');
    }
  });

  $("#txtPercentual").on('blur', function () {
    if ($(this).val() > 100) {
      $(this).val("0.00");
    }
  })

  $('#btnGravarMeta').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const Meta = new Metas($('#txtSelectTipos').val(), $('#txtNomeMeta').val(), `${$('#txtDtInicial').val()}T00:00:00Z`, `${$('#txtDtFinal').val()}T00:00:00Z`);
      if (Meta.validar()) {
        Meta.gravar();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaLOJA').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtLoja').val(), $('#txtIdMeta').val());
      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaVENDEDOR').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtVendedor').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaPRODUTO').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtProduto').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaCOLECAO').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtColecao').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaGRUPO').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtGrupo').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#cbTodos').on('change', async function () {
    if (!isChecked('#cbTodos')) {
      $('#txtVendedor').val([]);
      $('#txtVendedor').select2();
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['CODREP', 'NOME'],
      where: []
    }

    $('#txtVendedor').val([]);
    $('#txtVendedor').find('option').remove().end();

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    let arrCodigos = [];
    jsonStr.map(item => {
      arrCodigos.push(item.CODREP);
      $('#txtVendedor').append(`<option value=${item.CODREP}>${item.NOME}</option`);
    });
    $('#txtVendedor').val(arrCodigos);
    $('#txtVendedor').select2();
  });

  $('#btnExplodir').on('click', function () {
    $('#modalDiasMeta').modal('show');
  });

  $('#btnConfirmarDias').on('click', function () {
    $('#modalDiasMeta').modal('hide');
  });

  $('#modalDiasMeta').on('shown.bs.modal', function () {
    $("#tabelaDiasMeta").DataTable().columns.adjust().draw(false);
  });

  $('#modalDiasValor').on('shown.bs.modal', function () {
    $("#tabelaDiasValor").DataTable().columns.adjust().draw(false);
  });

  $('#btnExplodir').on('click', function () {
    $("#tabelaDiasMeta").DataTable().rows().data().map((item, index) => {
      $($('.campoSel')[index]).prop('checked', item.DIA_UTIL == 'S');
    });
  });

  function limpaCampos() {
    $('#txtNomeMeta').val('');
    $('#txtSelectTipos').val('');
    $('#txtDtInicial').val('');
    $('#txtDtFinal').val('');
    $('#txtOperacaoMeta').val('');
    $('#txtPercentual').val('')
    $('#txtValorMeta').val('0');
    $('#txtLoja').val('');
    $('#txtLoja').trigger('change');
    $('#txtVendedor').val('');
    $('#txtVendedor').trigger('change');
    $('#txtProduto').val('');
    $('#txtProduto').trigger('change');
    $('#txtColecao').val('');
    $('#txtColecao').trigger('change');
    $('#txtGrupo').val('');
    $('#txtGrupo').trigger('change');

  }

  new Metas().buscar();

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });
    driver.defineSteps([{
      element: '#gravarCampos',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para gravar a capa da Meta!.',
        position: 'rigth'
      }
    },
    {
      element: '#txtNomeMeta',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtSelectTipos',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtDtInicial',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDtFinal',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnGravarMeta',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a meta!',
        position: 'left'
      }
    },
    {
      element: '#tabelaTour',
      popover: {
        title: 'Tabela de Metas',
        description: 'Aqui estarão todas as metas cadastradas!',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
}); 