<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Metas</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=2.1.7">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=2.1.7">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="dist/css/custom.css?versao=2.1.7">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=2.1.7">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=2.1.7" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=2.1.7">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=2.1.7" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=2.1.7">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=2.1.7">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=2.1.7">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.239.11.1">
  <style>
    #tabelaMetas td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaMetas td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php include_once('../../menu.php'); ?>
    <div class="content-wrapper" id="mainTour">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Metas</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item active">Metas</li>
              </ol>
            </div>
          </div>
        </div>
        <div class="container-fluid" style="margin-top: 15px">
          <div class="card">
            <div class="card-body">

              <div class="row">

                <div class="col-12" id="gravarCampos">
                  <div class="row">
                    <div class="col-6">
                      <label for="txtNomeMeta">Nome Meta *</label>
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtNomeMeta" name="" class="form-control" placeholder="Nome Meta">
                    </div>
                    <div class="col-6">
                      <label for="txtSelectTipos">Tipo de Meta *</label>
                      <select name="txtSelectTipos" class="input-default focus form-control" id="txtSelectTipos">
                        <option value="">Selecione o Tipo da Meta</option>
                        <option value="LOJA">LOJA</option>
                        <option value="VENDEDOR">VENDEDOR</option>
                        <option value="PRODUTO">PRODUTO</option>
                        <option value="COLECAO">COLEÇÃO</option>
                        <option value="GRUPO">GRUPO</option>
                      </select>
                    </div>
                    <div class="col-6">
                      <label for="txtDtInicial">Data Inicial *</label>
                      <input type="date" max="2500-12-31" data-selecionado="false" class="input-default focus form-control" id="txtDtInicial" name="" class="form-control">
                    </div>
                    <div class="col-6">
                      <label for="txtDtFinal">Data Final *</label>
                      <input type="date" max="2500-12-31" data-selecionado="false" class="input-default focus form-control" id="txtDtFinal" name="" class="form-control">
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12 d-flex justify-content-end" style="margin-top: 10px">
                      <button type='button' id="btnGravarMeta" class="btn btn-danger btn-sisp">Gravar Meta</button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-sm-12 table-responsive card-body" id="tabelaTour">
                  <h5>Lista das Metas da Loja</h5>
                  <table id="tabelaMetas" class="table table-sm table-select table-hover" width="100%">
                    <thead>
                      <tr>
                        <td>ID</td>
                        <td>DESCRICAO</td>
                        <td>TIPO</td>
                        <td>EMPRESA</td>
                        <td>DT_INICIO</td>
                        <td>DT_FINAL</td>
                      </tr>
                    </thead>
                    <tbody>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modal-Metas" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title" id="titleModalMeta"></h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="card">
            <div class="card-body">

              <input type="text" class="d-none" id="txtIdMeta">

              <div class="row">
                <div class="col-6">
                  <label for="txtDescricaoMeta">Nome Meta</label>
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtDescricaoMeta" name="" class="form-control" placeholder="Nome Meta" disabled>
                </div>
                <div class="col-6">
                  <label for="txtTipoDaMeta">Tipo Meta</label>
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTipoDaMeta" disabled name="" class="form-control">
                </div>
              </div>

              <div class="row">
                <div class="col-6">
                  <label for="txtDtInicialOpcoes">Data Inicial</label>
                  <input type="date" max="2500-12-31" data-selecionado="false" class="input-default focus form-control" id="txtDtInicialOpcoes" name="" class="form-control" disabled>
                </div>
                <div class="col-6">
                  <label for="txtDtFinalOpcoes">Data Final</label>
                  <input type="date" max="2500-12-31" data-selecionado="false" class="input-default focus form-control" id="txtDtFinalOpcoes" name="" class="form-control" disabled>
                </div>
              </div>
              <div class="row">
                <div class="col-4">
                  <label for="txtOperacaoMeta">Tipo de Operação</label>
                  <select name="txtOperacaoMeta" class="input-default focus form-control" id="txtOperacaoMeta">
                    <option value="">Selecione a Operação</option>
                    <option value=">">MAIOR QUE</option>
                    <option value="<">MENOR QUE</option>
                    <option value="==">IGUAL</option>
                  </select>
                </div>

                <div class="col-4">
                  <label for="txtValorMeta">Valor Meta</label>
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtValorMeta" value="0.00" min="0" name="" class="form-control" placeholder="Valor Meta">
                </div>

                <div class="col-4">
                  <label for="txtPercentual">Perc. Comissão</label>
                  <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtPercentual" value="0.00" min="0" max="99" name="" class="form-control" placeholder="Percentual de comissão">
                </div>

              </div>

              <div class="row d-flex justify-content-end">
                <div class="col-12 form-group d-none opcoesMetas" id="LOJAMetas">
                  <label data-error="wrong" data-success="right" for="txtLoja">Loja </label>
                  <div class="input-group">
                    <select class="js-example-basic-multiple js-states form-control" id="txtLoja" name="txtLoja" multiple="multiple">
                    </select>
                  </div>
                </div>

                <div class="col-12 form-group d-none opcoesMetas" id="VENDEDORMetas">
                  <label data-error="wrong" data-success="right" for="txtVendedor">Vendedor
                    <input style="margin-left: 15px;" type="checkbox" class="form-check-input" id="cbTodos">
                    <label style="margin-left: 30px;" class="form-check-label" for="cbTodos">Todos</label>
                  </label>
                  <div class="input-group">
                    <select class="js-example-basic-multiple js-states form-control" id="txtVendedor" name="txtVendedor" multiple="multiple">
                    </select>
                  </div>
                </div>

                <div class="col-12 form-group d-none opcoesMetas" id="PRODUTOMetas">
                  <label data-error="wrong" data-success="right" for="txtProduto">Produto </label>
                  <div class="input-group">
                    <select class="js-example-basic-multiple js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                    </select>
                  </div>
                </div>

                <div class="col-12 form-group d-none opcoesMetas" id="COLECAOMetas">
                  <label data-error="wrong" data-success="right" for="txtColecao">Coleção </label>
                  <div class="input-group">
                    <select class="js-example-basic-multiple js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple">
                    </select>
                  </div>

                </div>

                <div class="col-12 form-group d-none opcoesMetas" id="GRUPOMetas">
                  <label data-error="wrong" data-success="right" for="txtGrupo">Grupo </label>
                  <div class="input-group">
                    <select class="js-example-basic-multiple js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple">
                    </select>
                  </div>
                </div>

                <div class="col-2 form-group">
                  <button class="btn btn-danger btn-sisp" id="btnExplodir">Explodir Dias</button>
                </div>

              </div>
            </div>
          </div>

          <div class="col-sm-12 table-responsive card-body text-left">
            <h5>Lista Valores da Meta</h5>
            <table id="tabelaValoresMetas" class="table table-sm table-select table-hover" width="100%">
              <thead>
                <tr>
                  <td>ID</td>
                  <td>OPERACAO</td>
                  <td>VALOR</td>
                  <td>TIPO</td>
                  <td>Opções</td>

                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>

        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-primary btn-sisp d-none btnGravaMeta" id="btnGravarMetaLOJA">Gravar Meta</button>
            <button class="btn btn-primary btn-sisp d-none btnGravaMeta" id="btnGravarMetaVENDEDOR">Gravar Meta</button>
            <button class="btn btn-primary btn-sisp d-none btnGravaMeta" id="btnGravarMetaPRODUTO">Gravar Meta</button>
            <button class="btn btn-primary btn-sisp d-none btnGravaMeta" id="btnGravarMetaCOLECAO">Gravar Meta</button>
            <button class="btn btn-primary btn-sisp d-none btnGravaMeta" id="btnGravarMetaGRUPO">Gravar Meta</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalDiasMeta" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Dias da Meta</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="col-sm-12 table-responsive card-body">
            <div class="col-sm-12 icheck-primary d-inline pb-2 ml-2" style="margin-right: 15px;">
              <input class="form-check-input" type="checkbox" id="check_todos" value="option1">
              <label class="form-check-label" for="check_todos">Selecionar Todos</label>
            </div>
            <table id="tabelaDiasMeta" class="table table-sm table-select table-hover" width="100%">
              <thead>
                <tr>
                  <td>SEL</td>
                  <td>Dia</td>
                  <td>Útil</td>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <button class="btn btn-primary btn-sisp" id="btnConfirmarDias">Confirmar</button>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalDiasValor" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Dias</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="col-sm-12 table-responsive card-body">
            <table id="tabelaDiasValor" class="table table-sm table-select table-hover" width="100%">
              <thead>
                <tr>
                  <td>Dia</td>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modal-OpcoesMetas" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title" id="titleModalMeta">Opções da Meta</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="col-sm-12 table-responsive card-body">
            <h5>Lista Opções da Meta</h5>
            <table id="tabelaOpcoesMetas" class="table table-sm table-select table-hover" width="100%">
              <thead>
                <tr>
                  <td>CODIGO</td>
                  <td>NOME</td>
                  <td>OPERACAO</td>
                  <td>VALOR</td>
                  <td>TIPO</td>
                  <td>DT_INICIO</td>
                  <td>DT_FINAL</td>
                  <td>PERCENTUAL_COM</td>
                </tr>
              </thead>
              <tbody>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php include_once('../../footer.php'); ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  <script src="plugins/jquery/jquery.min.js?versao=2.1.7"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=2.1.7"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=2.1.7"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=2.1.7"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=2.1.7"></script>
  <script src="dist/js/adminlte.min.js?versao=2.1.7"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=2.1.7"></script>
  <script src="dist/js/sisplan.js?versao=2.1.7"></script>
  <script src="pages/metas/classes/meta.class.js?versao=2.1.7"></script>
  <script src="pages/metas/classes/opcoesMeta.class.js?versao=2.1.7"></script>
  <script src="utils/funcoes.js?versao=2.1.7"></script>
  <script src="utils/cookies.js?versao=2.1.7"></script>
  <script src="dist/js/requisicoes.js?versao=2.1.7"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=2.1.7"></script>
  <script src="dist/js/driver.min.js?versao=2.1.7"></script>
  <script src="plugins/toastr/toastr.min.js?versao=2.1.7"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=2.1.7"></script>
  <script type="text/javascript" src="config.js?versao=2.1.7"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('METAS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/metas/metas.js?versao=2.1.7`;
      insereJavaScriptPagina(sArquivo);
    });
  </script>
</body>

</html>