<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Moeda</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.239.11.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">
  <!--e1Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.239.11.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.239.11.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.239.11.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.239.11.1">

  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.239.11.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.239.11.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radioTipo {
      font-size: 120%;
    }

    .bTipo {
      position: absolute;
      margin-bottom: 50%;
      font-size: 120%;
      font-weight: bolder;
    }

    .pTipo {
      margin-top: 2%;
      margin-left: -1%;
      margin-bottom: 0%;
    }

    .pCartao {
      margin-left: -1%;
      margin-bottom: 0%;
      margin-top: 2%;
    }

    .valMin {
      margin-top: 2%;
    }

    .frete {
      margin-top: 2%;
      margin-left: 0.1%;
    }

    #contas-wrap {
      margin-top: 0%;
    }

    #labelcontas {
      margin-top: 2%;
    }

    .radioTop {
      margin-left: 2%;
      margin-top: 2%;
    }

    .labelFonte {
      font-size: 100%;
      margin-top: 20%;
    }

    .radiosStyle {
      margin-top: 2%;
      padding: 1%;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      margin-left: 0%;
    }

    .checkboxMoeda {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1.6%;
      padding-bottom: 0%;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="../index">Início</a></li>
                  <li class="breadcrumb-item"><a href="../moeda">Acesso Moeda</a></li>
                  <li class="breadcrumb-item active">Cadastro de Moeda</li>
                </ol>
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Moeda
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account" style="font-size: 100%;"><strong>Geral</strong></li>
                        <li id="payment" style="font-size: 100%;"><strong>Contas</strong></li>
                        <li id="personal" style="font-size: 100%;"><strong>Configuração</strong></li>
                        <li id="confirm" style="font-size: 100%;"><strong>Finalização</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro da moeda</p>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">
                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                              <input type="number" readonly class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                            </div>
                            <div class="col-lg-9  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMoeda">Descrição
                                da Moeda *</label>
                              <input type="text" class="input-default focus form-control" id="txtMoeda" required aria-describedby="descError" name="txtMoeda" class="form-control" placeholder="Moeda">
                            </div>
                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtOperadora">Operadora</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtOperadora" name="txtOperadora" class="form-control" placeholder="Operadora">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnOperadora" name="btnTOperadora" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiOperadora" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtClasse">Classe
                                Gerencial *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtClasse" required aria-describedby="classeError" name="txtClasse" class="form-control" placeholder="Classe Gerencial">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnClasseGerencial" name="btnTClasseGerencial" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiClasse" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtHistorico">Histórico *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtHistorico" required aria-describedby="histError" name="txtHistorico" class="form-control" placeholder="Histórico">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiHistorico" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSituacao">Situação</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Situacao" name="btnTSituacao" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnASituacao" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCond">Condição
                                de Pagamento</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCond" name="txtCond" class="form-control" placeholder="Condição de pagamento">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnCondPagamento" name="btnTCondPagamento" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnACondicaoPagamento" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-12 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtObservacao">Observação</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtObservacao" name="txtObservacao" class="form-control" placeholder="Observação    ">

                              </div>
                            </div>

                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMensagem">Mensagem</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMensagem" name="txtMensagem" class="form-control" placeholder="Mensagem">

                              </div>
                            </div>

                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Contas</h2>
                          <div class="row" id="contas">
                            <div class="col-lg-6  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaDebito1">Conta Débito</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaDebito1" name="txtContaDebito1" class="form-control" placeholder="Conta Débito">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaDebito" name="btnTContaDebito" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContaDebito" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-6  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaCredito1">Conta Crédito</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaCredito1" name="txtContaCredito1" class="form-control" placeholder="Conta Crédito">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaCredito" name="btn-representante" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContaCredito" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>

                            </div>
                            <div class="col-lg-6  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaJuros">Conta Juros</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaJuros" name="txtContaJuros" class="form-control" placeholder="Conta juros">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaJuros" name="btnTContaJuros" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContaJuros" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-6  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaDesc">Conta
                                Desconto</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaDesc" name="txtContaDesc" class="form-control" placeholder="Conta desconto">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaDesc" name="btnContaDesconto" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContaDesconto" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-6  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtBanco">Banco</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimparBanco" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>

                        </div>
                        <input type="button" name="avancar2" class="next action-button" value="Avançar" id="avancar2" />
                        <input type="button" name="voltar" class="previous action-button-previous" value="Voltar" id="voltar" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Configuração da moeda</h2>
                          <div class="row" id="configuracao">
                            <div class="radioTipo col-sm-6">
                              <div class="frete row">
                                <div class="col-sm-10">
                                  <label class="labelGeral" data-error="wrong" data-success="right" for="formaPagto">Forma de pagamento</label>
                                  <select style="height: 73%;" class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="formaPagto" class="custom-select focus">
                                    <option value="">Selecione uma forma</option>
                                    <option value="00">00-Nenhum</option>
                                    <option value="01">01-Dinheiro</option>
                                    <option value="02">02-Cheque</option>
                                    <option value="03">03-Cartão de Crédito</option>
                                    <option value="04">04-Cartão de Débito</option>
                                    <option value="05">05-Crédito Loja</option>
                                    <option value="10">10-Vale Alimentação</option>
                                    <option value="11">11-Vale Refeição</option>
                                    <option value="12">12-Vale Presente</option>
                                    <option value="13">13-Vale Combustível</option>
                                    <option value="14">14-Duplicata Mercantil</option>
                                    <option value="15">15-Boleto Bancário</option>
                                    <option value="16">16-Depósito Bancário</option>
                                    <option value="17">17-Pagamento Instantâneo (PIX)</option>
                                    <option value="18">18-Transferência Bancária, Carteira Digital</option>
                                    <option value="19">19-Programa de fidelidade, Cashback, Crédito Virtual</option>
                                    <option value="99">99-Outros</option>
                                  </select>
                                </div>
                                <div class="col-sm-10">
                                  <label class="labelGeral" style="margin-top: 8%;" data-error="wrong" data-success="right" for="bandCartao">Bandeira do cartão</label>
                                  <select style="height: 58%;" class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="bandCartao" class="custom-select focus">
                                    <option value="">Selecione uma bandeira</option>
                                    <option value="00">00-Nenhum</option>
                                    <option value="01">01-Visa</option>
                                    <option value="02">02-Mastercard</option>
                                    <option value="03">03-American Express</option>
                                    <option value="04">04-Sorocred</option>
                                    <option value="05">05-Diners Club</option>
                                    <option value="06">06-Elo</option>
                                    <option value="07">07-Hipercard</option>
                                    <option value="08">08-Aura</option>
                                    <option value="09">09-Cabal</option>
                                    <option value="10">99-Outros</option>
                                  </select>
                                </div>
                                <div class="col-sm-10">
                                  <label class="labelGeral" style="margin-top: 9%;" data-error="wrong" data-success="right" for="tipoInteg">Tipo de integração</label>
                                  <select style="height: 50%;" class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="tipoInteg" class="custom-select focus">
                                    <option value="">Selecione uma integração</option>
                                    <option value="0" id="selectNenhum">0-Nenhum</option>
                                    <option value="1">1-Pagamento integrado com o sistema de automação da empresa (Ex.:
                                      equipamento TEF, Comércio Eletrônico)</option>
                                    <option value="2">2-Pagamento não integrado com o sistema de automação da empresa
                                      (Ex.: equipamento POS)</option>
                                  </select>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" style="margin-top: 8%;" class="labelGeral" data-success="right" for="txtTaxaCartao">Valor da taxa</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtTaxaCartao" name="txtTaxaCartao" class="form-control" placeholder="Valor da taxa">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label class="labelGeral" data-error="wrong" data-success="right" for="selectTipo">Tipo</label>
                                  <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="selectTipo" class="custom-select focus">
                                    <option value="0" checked>Dinheiro</option>
                                    <option value="1">Cheque</option>
                                    <option value="2">Crediário</option>
                                    <option value="3">Cartão</option>
                                    <option value="5">Pix</option>
                                  </select>
                                  <div>
                                    <b>
                                      <p class="pCartao"> Tipo de Cartão</p>
                                    </b>
                                    <div class="radiosStyle radioTop">
                                      <label class="container">Débito
                                        <input type="radio" checked="checked" id="radioDebito" name="radio">
                                        <span class="checkmark"></span>
                                      </label>
                                      <label class="container">Crédito
                                        <input type="radio" id="radioCredito" name="radio">
                                        <span class="checkmark"></span>
                                      </label>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescAut">%
                                    Desconto automático</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtDescAut" name="txtDescAut" class="form-control" maxlength="5" placeholder="Percentual de desconto automático">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescMaximo">%
                                    Desconto máximo</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtDescMaximo" name="txtDescMaximo" class="form-control" maxlength="5" placeholder="Percentual de desconto máximo">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNrMaxParcelas">
                                    Número Máximo de Parcelas</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtNrMaxParcelas" name="txtNrMaxParcelas" class="form-control" maxlength="5" placeholder="Número Máximo de Parcelas">
                                  </div>
                                </div>
                              </div>

                            </div>
                            <div class="col-sm-6 table-wrap">
                              <label class="labelGeral" style="font-size: 116%; margin-top: 3.2%;" data-error="wrong" data-success="right">Opções</label>
                              <div class="checkboxMoeda">
                                <label class="labelCheck" for="baixaReceber">   <input type="checkbox" class="configCheck" id="baixaReceber">     Baixa receber</label> <br>
                                <label class="labelCheck" for="baixaReceberDtVenc">   <input type="checkbox" class="configCheck" id="baixaReceberDtVenc">     Baixa do receber com data de
                                  vencimento</label> <br>
                                <label class="labelCheck" for="modoRapido">   <input type="checkbox" class="configCheck" id="modoRapido">     Modo rápido</label> <br>
                                <label class="labelCheck" for="moedaTroco">   <input type="checkbox" class="configCheck" id="moedaTroco">     Moeda utilizada para dar troco</label> <br>
                                <label class="labelCheck" for="imprimeRel">   <input type="checkbox" class="configCheck" id="imprimeRel">     Imprime relatório gerencial</label> <br>
                                <label class="labelCheck" for="imprimeCarne">   <input type="checkbox" class="configCheck" id="imprimeCarne">     Imprime carnê após fechamento</label>
                                <br>
                                <label class="labelCheck" for="controlaLim">   <input type="checkbox" class="configCheck" id="controlaLim">     Controla limite de crédito na
                                  venda/faturamento</label> <br>
                                <label class="labelCheck" for="comunicTef">   <input type="checkbox" class="configCheck" id="comunicTef">     Comunicação TEF</label> <br>
                                <label class="labelCheck" for="utilAdm">   <input type="checkbox" class="configCheck" id="utilAdm">     Utiliza administrador do cartão para gerar duplicata</label> <br>
                                <label class="labelCheck" for="recriaDup">   <input type="checkbox" class="configCheck" id="recriaDup">     Recria duplicatas no faturamento</label> <br>
                                <label class="labelCheck" for="habBaixar">   <input type="checkbox" class="configCheck" id="habBaixar">     Habilita baixar antecipação</label> <br>
                                <label class="labelCheck" for="naoGeraContas">   <input type="checkbox" class="configCheck" id="naoGeraContas">     Não gera contas a receber</label> <br>
                                <label class="labelCheck" for="cartaoPres">   <input type="checkbox" class="configCheck" id="cartaoPres">     Cartão presente</label> <br>
                                <label class="labelCheck" for="obrigaDocFiscal">   <input type="checkbox" class="configCheck" id="obrigaDocFiscal">     Obriga documento Fiscal na finalização da venda</label> <br>
                                <label class="labelCheck" for="moedaAtivo">   <input type="checkbox" class="configCheck" id="moedaAtivo">     Moeda Ativa</label> <br>
                                <label class="labelCheck" for="itemBrinde">   <input type="checkbox" class="configCheck" id="itemBrinde">     Controla item brinde</label> <br>
                              </div>
                            </div>

                          </div>
                          <div class="frete row">

                          </div>
                        </div>
                        <input type="button" name="avancar3" class="next action-button" value="Avançar" id="avancar3" />
                        <input type="button" name="voltar3" class="previous action-button-previous" value="Voltar" id="voltar3" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card" id="datatables">
                          <h2 class="fs-title">Finalização do cadastro de moeda</h2>
                          <div class="row">
                            <div class="col-sm-12">
                              <div>
                                <label data-error="wrong" data-success="right" for="tabelaCondicoesDePagamento">Condição
                                  de pagamento</label>
                                <table id="tabelaCondicoesDePagamento" class="table table-select table-hover">
                                  <thead>
                                    <tr>
                                      <th class="th-sm">Cód Cond</th>
                                      <th class="th-sm">Descrição</th>
                                      <th class="th-sm">Taxa</th>
                                      <th class="th-sm">Valor Mínimo</th>
                                      <th class="th-sm">Ações</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                                <div>
                                  <button id="btnAbrirCondicao" style="font-size: 15px;" type="button" class="btn btn-lg btn-secondary float-right focus">
                                    Adicionar
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-sm-12">
                              <label data-error="wrong" data-success="right" for="tabelaContas">Contas da moeda</label>
                              <div class="table-responsive">
                                <table id="tabelaContas" class="table table-select table-hover">
                                  <thead>
                                    <tr>
                                      <th class="th-sm">Empresa</th>
                                      <th class="th-sm">Cód Conta</th>
                                      <th class="th-sm">Descrição</th>
                                      <th class="th-sm">Empresa Transferência</th>
                                      <th class="th-sm">Cód Conta Transferência</th>
                                      <th class="th-sm">Descrição Transferência</th>
                                      <th class="th-sm">Chave Pix</th>
                                      <th class="th-sm">Ações</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>
                              <button id="btnAbrirContas" style="font-size: 15px;" type="button" class="btn btn-lg btn-secondary float-right focus mt-2">
                                Adicionar
                              </button>
                            </div>

                            <div class="col-sm-12" id="addMoedaECF">
                              <label data-error="wrong" data-success="right" for="tabelaMoedaECF">Relação entre moeda do
                                loja e das ECF</label>
                              <div>
                                <table id="tabelaMoedaECF" class="table table-select table-hover">
                                  <thead>
                                    <tr>
                                      <th class="th-sm">Nr. Serie ECF</th>
                                      <th class="th-sm">Moeda</th>
                                      <th class="th-sm">Moeda ECF</th>
                                      <th class="th-sm">Ações</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                                <div>
                                  <button id="btnAbrirMoedasECF" style="font-size: 15px;" type="button" class="btn btn-lg btn-secondary float-right focus">
                                    Adicionar
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="gravar" class="action-button" value="Gravar" id="gravar">
                        <input type="button" name="voltar4" class="previous action-button-previous" value="Voltar" id="voltar4">
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
  <div class="modal fade" id="modalCondicao" tabindex="-1" role="dialog" aria-labelledby="modalCondicao" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalCondicao-titulo" class="modal-title">Adicionar condição de pagamentos</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body p-4">
          <div class="row">
            <div class="col-sm-12">
              <div class="row">
                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="CondPagto">Condição de pagamento</label>
                  <div class="input-group">

                    <input type="text" class="input-default focus form-control" id="txtCondPagto" name="txtCondPagto" class="form-control" placeholder="Condição de Pagamento">

                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-CondPagto" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-CondPagto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-sm-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtTaxaAdm">Taxa Adm.</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtTaxaAdm" name="txtTaxaAdm" class="form-control" value="0.00" placeholder="% Taxa">
                  </div>
                </div>

                <div class="col-sm-6">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtValMinimo">Valor Mínimo.</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtValMinimo" name="txtValMinimo" class="form-control" value="0.00" placeholder="Valor Mínimo">
                  </div>
                </div>

                <div class="col-sm-4">
                  <input type="text" class="input-default focus form-control d-none" id="txtTrIndex" name="txtTrIndex" class="form-control" value="" placeholder="index">
                </div>


                <div class="col-sm-12" style="margin-top:5px">
                  <button id="btnAdicionar" type="button" class="btn btn-primary btn-block mt-2">
                    Confirmar
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalContas" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalContas-titulo" class="modal-title">Adicionar contas da moeda</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-sm-12">
              <div class="row">
                <div class="col-sm-4">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtContasEmpresa">Empresa</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtContasEmpresa" name="txtContasEmpresa" class="form-control" placeholder="Empresa">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnContasEmpresa" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ContasEmpresa" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-sm-8">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtContas">Contas da moeda</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtContas" name="txtContas" class="form-control" placeholder="Contas da moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Contas" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Contas" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-sm-4">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtContasEmpresaTransferencia">Empresa Transferência</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtContasEmpresaTransferencia" name="txtContasEmpresaTransferencia" class="form-control" placeholder="Empresa Transferência">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnContasEmpresaTransferencia" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ContasEmpresaTransferencia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-sm-8">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtContasTransferencia">Contas Transferência da moeda</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtContasTransferencia" name="txtContasTransferencia" class="form-control" placeholder="Contas Transferência da moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-ContasTransferencia" name="btn-moeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-ContasTransferencia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-sm-12">
                  <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtChavePix">Chave Pix</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtChavePix" name="txtChavePix" class="form-control" placeholder="Chave Pix">
                  </div>
                </div>
                <div class="col-sm-12" style="margin-top:5px">
                  <button id="btnAdicionarContas" type="button" class="btn btn-primary btn-block">
                    Adicionar
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modalMoedaECF" tabindex="-1" role="dialog" aria-labelledby="modalMoedaECF" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalMoedaECF-titulo" class="modal-title">Relação entre moeda do loja e das ECF</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="card">
            <div class="card-body">
              <div class="row">
                <div class="col-sm-12">
                  <div class="row">
                    <div class="col-sm-4">
                      <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txtSerie">Nr. Série ECF:</label>
                      <input type="text" class="input-default focus form-control" id="txtSerie" name="txtSerie" class="form-control" placeholder="Nr. Série ECF:">
                    </div>
                    <div class="col-sm-4">
                      <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="CondPagto">Moedas</label>
                      <div class="input-group">
                        <input type="text" disabled class="input-default focus form-control" id="txtMoedas" name="txtMoedas" class="form-control" placeholder="Moeda">
                        <div class="input-group-append">
                          <button class="btn bg-danger" disabled id="btn-Moedas" name="btn-Moedas" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" disabled id="btn-limpa-Moedas" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                    <div class="col-sm-4">
                      <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="CondPagto">Moeda ECF</label>
                      <input type="text" class="input-default focus form-control" id="txtMoedaECF" name="txtMoedaECF" class="form-control" placeholder="Moeda ECF">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button id="btnAdicionarMoedaECF" type="button" class="btn btn-primary btn-sisp">Adicionar</button>
        </div>
      </div>
    </div>
  </div>
  </div>

  <?php
  include_once('../../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.239.11.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.239.11.1"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.239.11.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.239.11.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.239.11.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.239.11.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.239.11.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.239.11.1"></script>
  <script src="../utils/funcoes.js?versao=3.239.11.1"></script>
  <script src="../utils/cookies.js?versao=3.239.11.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.239.11.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('MOEDA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("MOEDA");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/moeda`
        });
        return;
      }

      //código para liberar registro ao sair da tela clicando no menu, breadcrumb
      const queryString = window.location.href;
      const parametros = queryString.split('/');
      const moeda = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        e.preventDefault();
        deletaRegistro('MOEDA', getCookie('usuario'), parametros[5]);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/moeda/cadastro_moeda/moeda.js?versao=3.239.11.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>