let idItens = [];
let atualizaSolicitacao = [];
let solicitacaoInclusa = [];

function validaItens() {
    if (($('#tabelaItensMaterial').DataTable().rows().count() == 0) &&
        ($('#tabelaItensProduto').DataTable().rows().count() == 0) &&
        ($('#tabelaItensServico').DataTable().rows().count() == 0)) {
        msgAlerta('Ordem de compra sem itens, impossível continuar');
        return false;
    } return true;
};

function limpaCamposModalSolicitacao() {
    $("#txtDataEmiDe").val("1200-01-01");
    $("#txtDataEmiAte").val("2500-12-01");
    $("#txtDataEntregaDe").val("1200-01-01");
    $("#txtDataEntregaAte").val("2500-12-01");
    $("#txtSolicitacaoConsulta").val('');
    $("#listaSolicitacaoConsulta").val('');
    $("#txtMaterialConsulta").val('');
    $("#listaMaterialConsulta").val('');
    $("#txtProdutoConsulta").val('');
    $("#listaProdutoConsulta").val('');
    $("#txtGrupoConsulta").val('');
    $("#listaGrupoConsulta").val('');
    $("#txtSubGrupoConsulta").val('');
    $("#listaSubGrupoConsulta").val('');
    $('#chkAprovado').prop('checked', false);
    limpaTabela();
};

function addSelected(add = true) {
    for (let i = 0; i < $('#tabelaSolicitacao').DataTable().rows().data().length; i++) {
        if (add) {
            $($("table#tabelaSolicitacao tr")[i + 1]).addClass("selected");
        } else {
            $($("table#tabelaSolicitacao tr")[i + 1]).removeClass("selected");
        }
    }
};

function botaoSelecionarGrid() {
    return (
        '<div class="form-check">' +
        '<input type="checkbox" class="align-self-center checkSolicitacao" value"" checked>' +
        '</div>'
    );
};

async function limpaTabela() {
    $('#tabelaSolicitacao').DataTable().clear().draw(false);
};

function importaSolicitacao() {
    let tabela = $("#tabelaSolicitacao").DataTable().rows(".selected").data();
    let ordem;
    let numero;
    for (let i = 0; i < tabela.length; i++) {
        numero = tabela[i].NUMERO;
        if (!atualizaSolicitacao.includes(numero)) {
            atualizaSolicitacao.push(numero);
        };

        if (!solicitacaoInclusa.includes(numero)) {
            solicitacaoInclusa.push(numero);
        };
        if (tabela[i].TP_ITEM == 'M') {

            const dados = $('#tabelaItensMaterial').DataTable().rows().data().toArray();
            const indice = dados.findIndex((item) => item[0] == tabela[i].CODIGO &&
                item[2] == tabela[i].COR &&
                item[26] == tabela[i].DT_ENTREGA_ITEN &&
                item[25] == tabela[i].NUMERO &&
                item[24] == tabela[i].ORDEM);

            if (indice == -1) {
                $('#tabelaItensMaterial').DataTable().row.add([
                    tabela[i].CODIGO,
                    tabela[i].DESCRICAO,
                    tabela[i].COR,
                    '',
                    retornaFotoProduto(tabela[i].CODIGO, ordem),
                    '',
                    tabela[i].C_CUSTO,
                    '',
                    tabela[i].ESPECIFICA,
                    tabela[i].UNIDADE,
                    tabela[i].UNI_COM,
                    0,
                    1,  //divisor por padrão tem que ser 1
                    0,
                    0,
                    tabela[i].QTDE,
                    0,
                    tabela[i].QTDE_CANC,
                    tabela[i].PRECO,
                    0,
                    0,
                    retornaMultiplicacao(tabela[i].QTDE, tabela[i].PRECO).toFixed(2),
                    0,
                    'A',
                    tabela[i].ORDEM,
                    tabela[i].NUMERO,
                    tabela[i].DT_ENTREGA_ITEN,
                    adicionaBotoes()
                ]).draw(false);
            } else {
                let data_old = $('#tabelaItensMaterial').DataTable().row(indice).data();
                data_old[4] = retornaFotoProduto(tabela[i].CODIGO, data_old[24]);
                data_old[15] += tabela[i].QTDE;
                data_old[17] += tabela[i].QTDE_CANC;
                data_old[21] = retornaMultiplicacao(data_old[15], data_old[18]).toFixed(2);
                $('#tabelaItensMaterial').DataTable().row(indice).data(data_old).draw(false);
            }
        } else if (tabela[i].TP_ITEM == 'P') {
            const dados = $('#tabelaItensProduto').DataTable().rows().data().toArray();
            const indice = dados.findIndex((item) =>
                item[0] == tabela[i].CODIGO &&
                item[2] == tabela[i].COR &&
                item[3] == tabela[i].TAM &&
                item[26] == tabela[i].DT_ENTREGA_ITEN &&
                item[25] == tabela[i].NUMERO &&
                item[24] == tabela[i].ORDEM
            );

            if (indice == -1) {
                $('#tabelaItensProduto').DataTable().row.add([
                    tabela[i].CODIGO,
                    tabela[i].DESCRICAO,
                    tabela[i].COR,
                    tabela[i].TAM,
                    '',
                    retornaFotoProduto(tabela[i].CODIGO, ordem),
                    tabela[i].C_CUSTO,
                    '',
                    tabela[i].ESPECIFICA,
                    '',
                    tabela[i].UNI_COM,
                    tabela[i].UNIDADE,
                    0,
                    0,
                    0,
                    tabela[i].QTDE,
                    0,
                    tabela[i].QTDE_CANC,
                    tabela[i].PRECO,
                    0,
                    retornaMultiplicacao(tabela[i].QTDE, tabela[i].PRECO).toFixed(2),
                    0,
                    0,
                    'A',
                    tabela[i].ORDEM,
                    tabela[i].NUMERO,
                    tabela[i].DT_ENTREGA_ITEN,
                    adicionaBotoes()
                ]).draw(false);
            } else {
                let data_old = $('#tabelaItensProduto').DataTable().row(indice).data();
                data_old[5] = retornaFotoProduto(tabela[i].CODIGO, data_old[24]);
                data_old[15] += tabela[i].QTDE;
                data_old[17] += tabela[i].QTDE_CANC;
                data_old[20] = retornaMultiplicacao(data_old[15], data_old[18]).toFixed(2);
                $('#tabelaItensProduto').DataTable().row(indice).data(data_old).draw(false);
            }
        } else if (tabela[i].TP_ITEM == 'S') {
            const dados = $('#tabelaItensServico').DataTable().rows().data().toArray();
            const indice = dados.findIndex((item) =>
                item[0] == tabela[i].CODIGO &&
                item[18] == tabela[i].DT_ENTREGA_ITEN &&
                item[17] == tabela[i].NUMERO &&
                item[16] == tabela[i].ORDEM
            );

            if (indice == -1) {
                $('#tabelaItensServico').DataTable().row.add([
                    tabela[i].CODIGO,
                    tabela[i].DESCRICAO,
                    0,
                    tabela[i].C_CUSTO,
                    '',
                    tabela[i].ESPECIFICA,
                    tabela[i].QTDE,
                    0,
                    tabela[i].QTDE_CANC,
                    tabela[i].PRECO,
                    0,
                    0,
                    0,
                    retornaMultiplicacao(tabela[i].QTDE, tabela[i].PRECO).toFixed(2),
                    0,
                    'A',
                    tabela[i].ORDEM,
                    tabela[i].NUMERO,
                    tabela[i].DT_ENTREGA_ITEN,
                    adicionaBotoes()
                ]).draw(false);
            } else {
                let data_old = $('#tabelaItensServico').DataTable().row(indice).data();
                data_old[6] += tabela[i].QTDE;
                data_old[8] += tabela[i].QTDE_CANC;
                data_old[13] = retornaMultiplicacao(data_old[6], data_old[9]).toFixed(2);
                $('#tabelaItensServico').DataTable().row(indice).data(data_old).draw(false);
            }
        };
    };
    insereValor('#txtSolicitacao', numero, '');
};

$("#tabelaSolicitacao").on("click", "td", function () {
    selecionarLinhaTabela("#tabelaSolicitacao", "checkSolicitacao", this);
});

function preencheComZero() {
    setTimeout(() => {
        $('.camposGrade').map((index) => {
            if ($($('.camposGrade')[index]).val() == '') {
                $($('.camposGrade')[index]).val('0');
            }
        });
    }, 100);
};

function insereItensSolicitacao(sDados) {
    sDados.forEach(function (item) {
        item.SEL = botaoSelecionarGrid();
    });
    const colunasItens = sDados.length > 0 ? Object.entries(sDados[0]).map(item => ({
        title: item[0],
        data: item[0]
    })) : [];

    if (sDados.length == 0) {
        limpaTabela();
    } else {
        criaDataTablePadrao('#tabelaSolicitacao', false, false, false, false, true, true, '400px', sDados, colunasItens, [], [], [], [17, 20]);
        addSelected();
    }
};

async function buscaSolicitacao(numero = '') {
    const itens = await retornaSolicitacao(numero);
    insereItensSolicitacao(itens);
};

async function retornaSolicitacao(numero = '') {
    let filtros
    if (numero == '') {
        let solicitacao = await formataListas($('#listaSolicitacaoConsulta').val());
        let material = await formataListas($('#listaMaterialConsulta').val());
        let produto = await formataListas($('#listaProdutoConsulta').val());
        let grupo = await formataListas($('#listaGrupoConsulta').val());
        let subGrupo = await formataListas($('#listaSubGrupoConsulta').val());
        filtros = ` SOL_COMPRA.LIBERADO <> 'B' `;
        filtros += ` AND (SOL_ITEN.QTDE - UDF_NVL(SOL_ITEN.QTDE_CANC) - UDF_NVL(SOL_ITEN.QTDE_B)) > 0`
        filtros += ` AND SOL_ITEN.SITUACAO <> 'B' `;
        filtros += ` AND SOL_ITEN.SITUACAO <> 'R' `;
        filtros += solicitacao != '' ? ` AND SOL_COMPRA.NUMERO IN (${solicitacao})` : '';
        filtros += material != '' ? ` AND SOL_ITEN.CODIGO IN (${material})` : '';
        filtros += produto != '' ? ` AND SOL_ITEN.CODIGO IN (${produto})` : '';
        filtros += grupo != '' ? ` AND MATERIAL.GRUPO IN (${grupo})` : '';
        filtros += subGrupo != '' ? ` AND MATERIAL.SUB_GRUPO IN (${subGrupo})` : '';
        filtros += pegaValor('#selectEmpresaSolicitacao') != '' ? ` AND SOL_COMPRA.EMPRESA = '${pegaValor('#selectEmpresaSolicitacao')}'` : '';
        filtros += $('#chkAprovado').prop('checked') ? ` AND SOL_ITEN.SITUACAO = 'L'` : '';

        if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
            filtros += ` AND SOL_COMPRA.DATA >= '${$("#txtDataEmiDe").val()}' AND SOL_COMPRA.DATA <= '${$("#txtDataEmiAte").val()}'`;
        }

        if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
            filtros += ` AND SOL_COMPRA.ENTREGA >= '${$("#txtDataEntregaDe").val()}' AND SOL_COMPRA.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
        }
    } else {
        filtros = ` SOL_COMPRA.NUMERO = '${numero}'`;
        filtros += ` AND SOL_COMPRA.LIBERADO <> 'B' `;
        filtros += ` AND (SOL_ITEN.QTDE - UDF_NVL(SOL_ITEN.QTDE_CANC) - UDF_NVL(SOL_ITEN.QTDE_B)) > 0`
        filtros += ` AND SOL_ITEN.SITUACAO <> 'B' `;
        filtros += ` AND SOL_ITEN.SITUACAO <> 'R' `;
    }
    const dadosSelect = {
        tabela: 'SOL_COMPRA',
        camposSelect: [
            `'S' SEL`,
            'SOL_COMPRA.NUMERO',
            'SOL_ITEN.CODIGO',
            'SOL_ITEN.DESCRICAO',
            'SOL_ITEN.COR',
            'SOL_ITEN.TAM',
            'SOL_ITEN.UNIDADE',
            'SOL_ITEN.UNI_COM',
            'SOL_ITEN.DT_ENTREGA_ITEN',
            'SOL_ITEN.QTDE QTDE_ORIG',
            'SOL_ITEN.QTDE',
            'SOL_ITEN.QTDE_CANC',
            'SOL_ITEN.SITUACAO',
            'SOL_ITEN.ESPECIFICA',
            'SOL_ITEN.ORDEM',
            'SOL_ITEN.QTDE_B',
            'SOL_ITEN.TP_ITEM',
            'UDF_NVL(SOL_ITEN.C_CUSTO) C_CUSTO',
            'SOL_ITEN.OBS',
            'SOL_COMPRA.PEDIDO',
            'UDF_NVL(SOL_ITEN.PRECO) PRECO',
            'SOL_COMPRA.PRAZO'
        ],
        innerJoin: [{ tabela: 'SOL_ITEN', condicao: 'SOL_ITEN.NUMERO = SOL_COMPRA.NUMERO' }],
        leftJoin: [{ tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = SOL_ITEN.CODIGO' }],
        where: [filtros]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
        msgAlerta('Não foi possível buscar os dados das solicitações.');
        return;
    }
    return retornoSelect;
};

function limpaCamposMaterial() {
    $('#txtMaterial').val('');
    $('#txtCorMaterial').val('');
    $('#txtDepositoMaterial').val('');
    $('#txtContaContMaterial').val('');
    $('#txtCentroCustoMaterial').val('');
    $('#txtCodFornecMaterial').val('');
    $('#txtUnidadeMaterial').val('');
    $('#txtEspecificacaoMaterial').val('');
    $('#txtUnidadeMaterial').val('');
    $('#txtUniCompraMaterial').val('');
    $('#txtICMSMaterial').val('');
    $('#txtDivisorMaterial').val('');
    $('#txtSTMaterial').val('');
    $('#txtIPIMaterial').val('');
    $('#txtQtdeMaterial').val('');
    $('#txtPrecoMaterial').val('');
    $('#txtDescontoMaterial').val('');
    $('#txtTotalIPIMaterial').val('');
    $('#txtTotalItemMaterial').val('');
    $('#txtIndexMat').val('');
};

function limpaCamposProduto() {
    $('#txtProduto').val('');
    $('#txtProduto').val('');
    $('#txtCorProduto').val('');
    $('#txtTamProduto').val('');
    $('#txtDepositoProduto').val('');
    $('#txtCentroCustoProduto').val('');
    $('#txtContaContProduto').val('');
    $('#txtEspecificacaoProduto').val('');
    $('#txtCodFornecProduto').val('');
    $('#txtUniCompraProduto').val('');
    $('#txtUniVendaProduto').val('');
    $('#txtICMSProduto').val('');
    $('#txtIPIProduto').val('');
    $('#txtSTProduto').val('');
    $('#txtQtdeProduto').val('');
    $('#txtPrecoProduto').val('');
    $('#txtDescontoProduto').val('');
    $('#txtTotalProduto').val('');
    $('#txtTotalIPIProduto').val('');
    $('#txtIndexProd').val('');
};

function limpaCamposServico() {
    $('#txtServico').val('');
    $('#txtServico').val('');
    $('#txtContaContServico').val('');
    $('#txtCentroCustoServico').val('');
    $('#txtCodFornecServico').val('');
    $('#txtEspecificacaoServico').val('');
    $('#txtQtdeServico').val('');
    $('#txtPrecoServico').val('');
    $('#txtDescontoServico').val('');
    $('#txtValIssServico').val('');
    $('#txtValorIrrfServico').val('');
    $('#txtTotalServico').val('');
    $('#txtIndexServ').val('');
};

$('#tabelaItensMaterial').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
});

$('#tabelaItensProduto').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
});

function confirmaItem() {
    try {
        if ($('#tabelaGradeProduto').DataTable().rows().count() == 0) {
            $('#modalItem').modal('hide');
            return;
        };

        if ($('#txtProdutoGrade').val() == '') {
            msgAlerta('Produto não informado, impossível continuar');
            return;
        };
        let ordem = retornaProximaOrdem();
        let grade = [];
        const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
        listaDados.forEach(dado => {
            const objeto = Object.entries(dado);
            let coluna;
            const colunas = objeto.map(prop => prop[0]);

            for (let i = 0; i < colunas.length; i++) {
                if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
                    coluna = RetornaIdTamFormatado(colunas[i], true);
                    const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
                    const idFormatado = idSemFormatacao.split("value=")[0];
                    const retorno = {
                        CODIGO: pegaChave('#txtProdutoGrade'),
                        DESCRICAO: pegaDescricao('#txtProdutoGrade'),
                        COR: dado.COR,
                        TAM: coluna,
                        DEPOSITO: pegaChave('#txtDepositoProduto'),
                        C_CUSTO: pegaChave('#txtCentroCustoProduto'),
                        CONTA_CONT: pegaChave('#txtContaContProduto'),
                        ESPECIFICA: pegaValor('#txtEspecificacaoProduto'),
                        CODIGO_FORN: pegaValor('#txtCodFornecProduto'),
                        UNI_COM: pegaValor('#txtUniCompraProduto'),
                        UNIDADE: pegaValor('#txtUniVendaProduto'),
                        ICMS: pegaValor('#txtICMSProduto'),
                        IPI: pegaValor('#txtIPIProduto'),
                        PERC_ST: pegaValor('#txtSTProduto'),
                        QTDE: $(`#${idFormatado}`).val(),
                        QTDE_B: 0,
                        QTDE_CANC: 0,
                        PRECO: pegaValor('#txtPrecoProduto'),
                        DESCONTO: (pegaValor('#txtDescontoProduto') == '') ? 0 : pegaValor('#txtDescontoProduto'),
                        TOTAL_ITEM: retornaMultiplicacao($(`#${idFormatado}`).val(), pegaValor('#txtPrecoProduto'), pegaValor('#txtDescontoProduto')),
                        TOTAL_IPI: (pegaValor('#txtIPIProduto') > 0) ? (retornaMultiplicacao(($(`#${idFormatado}`).val() * pegaValor('#txtPrecoProduto')), (pegaValor('#txtIPIProduto') / 100))) : 0,
                        ID_ITEN: 0,
                        SITUACAO: 'A',
                        ORDEM: ($(`#${idFormatado}`).val() > 0) && ordem++,
                        SOLICITACAO: '',
                        DT_ENTREGA: '1899-01-01',
                        TP_ITEM: 'P'
                    };
                    grade.push(retorno);
                }
            }
        });

        grade.map((item) => {
            if (parseFloat(item.QTDE) > 0) {
                addItem(item);
            }
        });

        $('#modalItem').modal('hide');
        limpaCamposProduto();

    } finally {

    }
};

async function buscaFotoProduto(codigo, ordem) {
    const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    try {
        const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
        const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

        if (!response) {
            return;
        }
        const jsonStr = await response.json();
        if (response.status != 200) {
            $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
            return;
        }

        const sBase64 = jsonStr;
        $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
        console.error(error);
        $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
};

function retornaFotoProduto(codigo, ordem) {
    buscaFotoProduto(codigo, ordem);
    const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    return `<img class="imagem" id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="" height="75" width="75"/>`
};

function criptografaCodigo(codigo) {
    return btoa(codigo).replaceAll('=', '');
};

function editaMaterial(item, index) {
    insereValor('#txtMaterial', item[0], item[1]);
    insereValor('#txtCorMaterial', item[2], '');
    insereValor('#txtDepositoMaterial', item[3], '');
    insereValor('#txtContaContMaterial', item[5], '');
    insereValor('#txtCentroCustoMaterial', item[6], '');
    insereValor('#txtCodFornecMaterial', item[7]);
    insereValor('#txtEspecificacaoMaterial', item[8]);
    insereValor('#txtUnidadeMaterial', item[9]);
    insereValor('#txtUniCompraMaterial', item[10]);
    insereValor('#txtICMSMaterial', item[11]);
    insereValor('#txtDivisorMaterial', item[12]);
    insereValor('#txtSTMaterial', item[13]);
    insereValor('#txtIPIMaterial', item[14]);
    insereValor('#txtQtdeMaterial', item[15]);
    insereValor('#txtPrecoMaterial', item[18]);
    insereValor('#txtDescontoMaterial', item[19]);
    insereValor('#txtTotalIPIMaterial', item[20]);
    insereValor('#txtTotalItemMaterial', item[21]);
    insereValor('#txtIndexMat', index);
};

function editaProduto(item, index) {
    insereValor('#txtProduto', item[0], item[1]);
    insereValor('#txtCorProduto', item[2], '');
    insereValor('#txtTamProduto', item[3], '');
    insereValor('#txtDepositoProduto', item[4], '');
    insereValor('#txtCentroCustoProduto', item[6], '');
    insereValor('#txtContaContProduto', item[7], '');
    insereValor('#txtEspecificacaoProduto', item[8]);
    insereValor('#txtCodFornecProduto', item[9]);
    insereValor('#txtUniCompraProduto', item[10]);
    insereValor('#txtUniVendaProduto', item[11]);
    insereValor('#txtICMSProduto', item[12]);
    insereValor('#txtIPIProduto', item[13]);
    insereValor('#txtSTProduto', item[14]);
    insereValor('#txtQtdeProduto', item[15]);
    insereValor('#txtPrecoProduto', item[18]);
    insereValor('#txtDescontoProduto', item[19]);
    insereValor('#txtTotalProduto', item[20]);
    insereValor('#txtTotalIPIProduto', item[21]);
    insereValor('#txtIndexProd', index);
};

function editaServico(item, index) {
    insereValor('#txtServico', item[0], item[1]);
    insereValor('#txtContaContServico', item[2], '');
    insereValor('#txtCentroCustoServico', item[3], '');
    insereValor('#txtCodFornecServico', item[4]);
    insereValor('#txtEspecificacaoServico', item[5]);
    insereValor('#txtQtdeServico', item[6]);
    insereValor('#txtPrecoServico', item[9]);
    insereValor('#txtDescontoServico', item[10]);
    insereValor('#txtValIssServico', item[11]);
    insereValor('#txtValorIrrfServico', item[12]);
    insereValor('#txtTotalServico', item[13]);
    insereValor('#txtIndexServ', index);
};

function retornaCondicoesPgto() {
    let sCondicoes = '';
    for (let i = 1; i <= 27;) {
        if ((sCondicoes.length % 3) != 0) {
            sCondicoes += ' ';
        } else {
            if ($('#txtCondPagto' + i).val()) {
                sCondicoes += $('#txtCondPagto' + i).val();
            };
            i++;
        }
    }
    return sCondicoes;
};

function adicionaIdExclusao(id_iten) {
    idItens.push({
        ID_ITEN: id_iten
    });
};

function totalizarItens() {
    document.querySelector("#labelMaterial").innerHTML = `Material (${$('#tabelaItensMaterial').DataTable().rows().count()})`;
    document.querySelector("#labelProduto").innerHTML = `Produto (${$('#tabelaItensProduto').DataTable().rows().count()})`;
    document.querySelector("#labelServico").innerHTML = `Serviço  (${$('#tabelaItensServico').DataTable().rows().count()})`;
};

function retornaProximaOrdem() {
    let ordem = 0;

    $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
        ordem = item[24] > ordem ? item[24] : ordem;
    });

    $('#tabelaItensProduto').DataTable().rows().data().map(item => {
        ordem = item[24] > ordem ? item[24] : ordem;
    });

    $('#tabelaItensServico').DataTable().rows().data().map(item => {
        ordem = item[16] > ordem ? item[16] : ordem;
    });

    return ++ordem;
};

function calculoMaterial() {
    $("#txtQtdeMaterial").on('blur', function () {
        insereValor('#txtTotalItemMaterial', retornaMultiplicacao(pegaValor('#txtQtdeMaterial'), pegaValor('#txtPrecoMaterial'), pegaValor('#txtDescontoMaterial')).toFixed(2));
        if (pegaValor('#txtIPIMaterial') > 0) {
            insereValor('#txtTotalIPIMaterial', retornaMultiplicacao((pegaValor('#txtQtdeMaterial') * pegaValor('#txtPrecoMaterial')), (pegaValor('#txtIPIMaterial') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIMaterial', 0);
        }
    });

    $("#txtPrecoMaterial").on('blur', function () {
        insereValor('#txtTotalItemMaterial', retornaMultiplicacao(pegaValor('#txtQtdeMaterial'), pegaValor('#txtPrecoMaterial'), pegaValor('#txtDescontoMaterial')).toFixed(2));
        if (pegaValor('#txtIPIMaterial') > 0) {
            insereValor('#txtTotalIPIMaterial', retornaMultiplicacao((pegaValor('#txtQtdeMaterial') * pegaValor('#txtPrecoMaterial')), (pegaValor('#txtIPIMaterial') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIMaterial', 0);
        }
    });

    $("#txtDescontoMaterial").on('blur', function () {
        insereValor('#txtTotalItemMaterial', retornaMultiplicacao(pegaValor('#txtQtdeMaterial'), pegaValor('#txtPrecoMaterial'), pegaValor('#txtDescontoMaterial')).toFixed(2));
        if (pegaValor('#txtIPIMaterial') > 0) {
            insereValor('#txtTotalIPIMaterial', retornaMultiplicacao((pegaValor('#txtQtdeMaterial') * pegaValor('#txtPrecoMaterial')), (pegaValor('#txtIPIMaterial') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIMaterial', 0);
        }
    });

    $("#txtIPIMaterial").on('blur', function () {
        if (pegaValor('#txtIPIMaterial') > 0) {
            insereValor('#txtTotalIPIMaterial', retornaMultiplicacao((pegaValor('#txtQtdeMaterial') * pegaValor('#txtPrecoMaterial')), (pegaValor('#txtIPIMaterial') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIMaterial', 0);
        }
    });
};

function calculoProduto() {
    $("#txtQtdeProduto").on('blur', function () {
        insereValor('#txtTotalProduto', retornaMultiplicacao(pegaValor('#txtQtdeProduto'), pegaValor('#txtPrecoProduto'), pegaValor('#txtDescontoProduto')).toFixed(2));
        if (pegaValor('#txtIPIProduto') > 0) {
            insereValor('#txtTotalIPIProduto', retornaMultiplicacao((pegaValor('#txtQtdeProduto') * pegaValor('#txtPrecoProduto')), (pegaValor('#txtIPIProduto') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIProduto', 0);
        }
    });

    $("#txtPrecoProduto").on('blur', function () {
        insereValor('#txtTotalProduto', retornaMultiplicacao(pegaValor('#txtQtdeProduto'), pegaValor('#txtPrecoProduto'), pegaValor('#txtDescontoProduto')).toFixed(2));
        if (pegaValor('#txtIPIProduto') > 0) {
            insereValor('#txtTotalIPIProduto', retornaMultiplicacao((pegaValor('#txtQtdeProduto') * pegaValor('#txtPrecoProduto')), (pegaValor('#txtIPIProduto') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIProduto', 0);
        }
    });

    $("#txtDescontoProduto").on('blur', function () {
        insereValor('#txtTotalProduto', retornaMultiplicacao(pegaValor('#txtQtdeProduto'), pegaValor('#txtPrecoProduto'), pegaValor('#txtDescontoProduto')).toFixed(2));
        if (pegaValor('#txtIPIProduto') > 0) {
            insereValor('#txtTotalIPIProduto', retornaMultiplicacao((pegaValor('#txtQtdeProduto') * pegaValor('#txtPrecoProduto')), (pegaValor('#txtIPIProduto') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIProduto', 0);
        }
    });

    $("#txtIPIProduto").on('blur', function () {
        if (pegaValor('#txtIPIProduto') > 0) {
            insereValor('#txtTotalIPIProduto', retornaMultiplicacao((pegaValor('#txtQtdeProduto') * pegaValor('#txtPrecoProduto')), (pegaValor('#txtIPIProduto') / 100)).toFixed(2));
        } else {
            insereValor('#txtTotalIPIProduto', 0);
        }
    });
};

function calculoServico() {
    $("#txtQtdeServico").on('blur', function () {
        insereValor('#txtTotalServico', retornaMultiplicacao(pegaValor('#txtQtdeServico'), pegaValor('#txtPrecoServico'), pegaValor('#txtDescontoServico')).toFixed(2));
    });

    $("#txtPrecoServico").on('blur', function () {
        insereValor('#txtTotalServico', retornaMultiplicacao(pegaValor('#txtQtdeServico'), pegaValor('#txtPrecoServico'), pegaValor('#txtDescontoServico')).toFixed(2));
    });

    $("#txtDescontoServico").on('blur', function () {
        insereValor('#txtTotalServico', retornaMultiplicacao(pegaValor('#txtQtdeServico'), pegaValor('#txtPrecoServico'), pegaValor('#txtDescontoServico')).toFixed(2));
    });
};

function insereCondicoesPgto(sPagto) {
    for (let i = 0; i < 27; i += 3) {
        const id = '#txtCondPagto' + (i == 0 ? 1 : ((i / 3) + 1));
        $(id).val(((sPagto.substring(i, 3 + i)).replace(/^(0+)(\d)/g, "$2")).trim());
    }
};

function retornaValorFloat(valor) {
    return isNaN(parseFloat(valor)) ? 0 : parseFloat(valor)
};

function geraTotais() {
    let valFrete = 0;
    let valTotAcrescimo = 0;
    let valTotDesconto = 0;
    let valorST = 0;
    let total = 0;
    let valorBruto = 0;
    let valorLiq = 0;
    let valorMat = 0;
    let valorLiqMat = 0;
    let valTotItens = 0;
    let qtdeMat = 0;
    let qtdeMatLiq = 0;
    let valorProd = 0;
    let valorLiqProd = 0;
    let qtdeProd = 0;
    let qtdeProdLiq = 0;
    let valorServ = 0;
    let valorLiqServ = 0;
    let qtdeServ = 0;
    let qtdeServLiq = 0;
    let valorTotIPI = 0;


    if ((retornaValorFloat($('#txtDesconto').val()) > 0) || (retornaValorFloat($('#txtAcrescimo').val()) > 0)) {
        $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
            valTotItens += retornaValorFloat(item[22]);  //total item  
        });

        $('#tabelaItensProduto').DataTable().rows().data().map(item => {
            valTotItens += retornaValorFloat(item[20]);   //total item  
        });

        $('#tabelaItensServico').DataTable().rows().data().map(item => {
            valTotItens += retornaValorFloat(item[11]);   //total item  
        });
    }

    $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
        // 21 = total item, 13 = ST, 14 = IPI, 15 QTDE, 16 QTDE_B, 17 QTDE_CANC, 20 total IPI, 19 desconto
        valorLiq = retornaValorFloat(item[21]) - ((retornaValorFloat(item[21]) * retornaValorFloat(item[19])) / 100);
        valorMat += valorLiq + ((valorLiq * retornaValorFloat(item[13])) / 100) + ((valorLiq * retornaValorFloat(item[14])) / 100);
        if (retornaValorFloat($('#txtDesconto').val()) > 0) {
            valorLiqMat += retornaValorFloat($('#txtDesconto').val()) > 0 ? (retornaValorFloat(item[21]) - (retornaValorFloat(item[21]) * (retornaValorFloat($('#txtDesconto').val()) / valTotItens))) : retornaValorFloat(item[21]);
            valTotDesconto += ((retornaValorFloat(item[21]) * retornaValorFloat(item[19])) / 100) +
                (retornaValorFloat($('#txtDesconto').val()) > 0 ? (retornaValorFloat(item[21]) * (retornaValorFloat($('#txtDesconto').val()) / valTotItens)) : 0);
        } else {
            valorLiqMat += retornaValorFloat($('#txtPercDescontos').val()) > 0 ? (retornaValorFloat(item[21]) - (retornaValorFloat(item[21]) * (retornaValorFloat($('#txtPercDescontos').val()) / 100))) : retornaValorFloat(item[21]);
            valTotDesconto += ((retornaValorFloat(item[21]) * retornaValorFloat(item[19])) / 100) +
                (retornaValorFloat($('#txtPercDescontos').val()) > 0 ? (retornaValorFloat(item[21]) * (retornaValorFloat($('#txtPercDescontos').val()) / 100)) : 0);
        };

        qtdeMat += retornaValorFloat(item[15]) - (isNaN(retornaValorFloat(item[17])) ? 0 : retornaValorFloat(item[17])); //qtde e qtde_canc material
        qtdeMatLiq += retornaValorFloat(item[15]) - retornaValorFloat(item[16]) - retornaValorFloat(item[17]); //qtde, qtde_b e qtde_canc material
        valorBruto = retornaValorFloat(item[21]) - valTotDesconto;
        if (retornaValorFloat($('#txtAcrescimo').val())) {
            valTotAcrescimo += (retornaValorFloat($('#txtAcrescimo').val()) > 0 ? ((valorBruto * (retornaValorFloat($('#txtAcrescimo').val()) / valTotItens))) : 0);
        } else {
            valTotAcrescimo += (retornaValorFloat($('#txtPercAcrescimo').val()) > 0 ? ((valorBruto * (retornaValorFloat($('#txtPercAcrescimo').val()) / 100))) : 0);
        };
        valFrete = (retornaValorFloat($('#txtFrete').val()) > 0 ? ((retornaValorFloat(item[21]) * (retornaValorFloat($('#txtFrete').val()) / valTotItens))) : 0);
        valorST += (valorLiqMat + valFrete) * (retornaValorFloat(item[13]) / 100);
        valorTotIPI += ((valorLiq + valFrete) * retornaValorFloat(item[14])) / 100;
    });

    $('#tabelaItensProduto').DataTable().rows().data().map(item => {
        // 20 = total item, 14 = ST, 13 = IPI, 15 QTDE, 16 QTDE_B, 17 QTDE_CANC, 21 total IPI, 19 desconto
        valorLiq = retornaValorFloat(item[20]) - ((retornaValorFloat(item[20]) * retornaValorFloat(item[19])) / 100);
        valorProd += valorLiq + ((valorLiq * retornaValorFloat(item[14])) / 100) + ((valorLiq * retornaValorFloat(item[13])) / 100);
        if (retornaValorFloat($('#txtDesconto').val()) > 0) {
            valorLiqProd += retornaValorFloat($('#txtDesconto').val()) > 0 ? (valorLiq - (valorLiq * (retornaValorFloat($('#txtDesconto').val()) / valTotItens))) : retornaValorFloat(item[20]);
            valTotDesconto += ((retornaValorFloat(item[20]) * retornaValorFloat(item[19])) / 100) +
                (retornaValorFloat($('#txtDesconto').val()) > 0 ? (retornaValorFloat(item[20]) * (retornaValorFloat($('#txtDesconto').val()) / valTotItens)) : 0);
        } else {
            valorLiqProd += retornaValorFloat($('#txtPercDescontos').val()) > 0 ? (valorLiq - (valorLiq * (retornaValorFloat($('#txtPercDescontos').val()) / 100))) : retornaValorFloat(item[20]);
            valTotDesconto += ((retornaValorFloat(item[20]) * retornaValorFloat(item[19])) / 100) +
                (retornaValorFloat($('#txtPercDescontos').val()) > 0 ? (retornaValorFloat(item[20]) * (retornaValorFloat($('#txtPercDescontos').val()) / 100)) : 0);
        };
        qtdeProd += retornaValorFloat(item[15]) - (isNaN(retornaValorFloat(item[17])) ? 0 : retornaValorFloat(item[17])); //qtde e qtde_canc
        qtdeProdLiq += retornaValorFloat(item[15]) - retornaValorFloat(item[16]) - retornaValorFloat(item[17]); //qtde, qtde_b e qtde_canc
        valorBruto = retornaValorFloat(item[20]) - valTotDesconto;
        if (retornaValorFloat($('#txtAcrescimo').val())) {
            valTotAcrescimo += (retornaValorFloat($('#txtAcrescimo').val()) > 0 ? ((valorBruto * (retornaValorFloat($('#txtAcrescimo').val()) / valTotItens))) : 0);
        } else {
            valTotAcrescimo += (retornaValorFloat($('#txtPercAcrescimo').val()) > 0 ? ((valorBruto * (retornaValorFloat($('#txtPercAcrescimo').val()) / 100))) : 0);
        };
        valFrete = (retornaValorFloat($('#txtFrete').val()) > 0 ? ((retornaValorFloat(item[20]) * (retornaValorFloat($('#txtFrete').val()) / valTotItens))) : 0);
        valorST += (valorLiqProd + valFrete) * (retornaValorFloat(item[14]) / 100);
        valorTotIPI += ((valorLiq + valFrete) * retornaValorFloat(item[13])) / 100;
    });

    $('#tabelaItensServico').DataTable().rows().data().map(item => {
        // 13 = total item, 6 QTDE, 7 QTDE_B, 8 QTDE_CANC, 10 desconto
        valorLiq = retornaValorFloat(item[13]) - ((retornaValorFloat(item[13]) * retornaValorFloat(item[10])) / 100);
        valorServ += valorLiq;
        valorLiqServ += retornaValorFloat($('#txtDesconto').val()) > 0 ? (valorLiq - (valorLiq * (retornaValorFloat($('#txtDesconto').val()) / valTotItens))) : retornaValorFloat(item[13]);
        qtdeServ += retornaValorFloat(item[6]) - (isNaN(retornaValorFloat(item[8])) ? 0 : retornaValorFloat(item[8])); //qtde e qtde_canc
        qtdeServLiq += retornaValorFloat(item[6]) - retornaValorFloat(item[7]) - retornaValorFloat(item[8]); //qtde, qtde_b e qtde_canc
        if (retornaValorFloat($('#txtDesconto').val()) > 0) {
            valTotDesconto += ((retornaValorFloat(item[13]) * retornaValorFloat(item[10])) / 100) +
                (retornaValorFloat($('#txtDesconto').val()) > 0 ? (retornaValorFloat(item[13]) * (retornaValorFloat($('#txtDesconto').val()) / valTotItens)) : 0)
        } else {
            valTotDesconto += ((retornaValorFloat(item[13]) * retornaValorFloat(item[10])) / 100) +
                (retornaValorFloat($('#txtPercDescontos').val()) > 0 ? (retornaValorFloat(item[13]) * (retornaValorFloat($('#txtPercDescontos').val()) / 100)) : 0);
        };
        valorBruto = retornaValorFloat(item[13]) - valTotDesconto;
        if (retornaValorFloat($('#txtAcrescimo').val())) {
            valTotAcrescimo += (retornaValorFloat($('#txtAcrescimo').val()) > 0 ? ((valorBruto * (retornaValorFloat($('#txtAcrescimo').val()) / valTotItens))) : 0);
        } else {
            valTotAcrescimo += (retornaValorFloat($('#txtPercAcrescimo').val()) > 0 ? ((valorBruto * (retornaValorFloat($('#txtPercAcrescimo').val()) / 100))) : 0);
        };
    });
    insereValor('#txtVlTotMaterial', parseFloat(valorMat).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtVlTotLiqMaterial', parseFloat(valorLiqMat).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtQtdeTotMaterial', qtdeMat);
    insereValor('#txtSaldoMaterial', qtdeMatLiq);
    insereValor('#txtVlTotProduto', parseFloat(valorProd).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtVlTotLiqProduto', parseFloat(valorLiqProd).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtQtdeTotProduto', qtdeProd);
    insereValor('#txtSaldoProduto', qtdeProdLiq);
    insereValor('#txtVlTotServico', parseFloat(valorServ).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtVlTotLiqServico', parseFloat(valorLiqServ).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtQtdeTotServico', qtdeServ);
    insereValor('#txtSaldoServico', qtdeServLiq);
    total = valorServ + valorMat + valorProd + (retornaValorFloat($('#txtFrete').val()) > 0 ? retornaValorFloat($('#txtFrete').val()) : 0) + valorST - valTotDesconto + valTotAcrescimo;
    insereValor('#txtVlTotal', parseFloat(total).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    total = valorLiqServ + valorLiqProd + valorLiqMat + valorTotIPI + (retornaValorFloat($('#txtFrete').val()) > 0 ? retornaValorFloat($('#txtFrete').val()) : 0) + valorST + valTotAcrescimo;
    insereValor('#txtVlTotLiq', parseFloat(total).toLocaleString("pt-BR", { style: "currency", currency: "BRL", }));
    insereValor('#txtQtdeTot', qtdeServ + qtdeProd + qtdeMat);
    insereValor('#txtSaldo', qtdeServLiq + qtdeProdLiq + qtdeMatLiq);
};

function retornaItens() {
    let arrItens = [];
    $('#tabelaItensMaterial').DataTable().rows().data().map(item => {
        arrItens.push({
            CODIGO: item[0],
            DESCRICAO: item[1],
            COR: item[2],
            DEPOSITO: item[3],
            CONTA_CONT: item[5],
            C_CUSTO: item[6],
            CODIGO_FORN: item[7],
            ESPECIFICA: item[8],
            UNIDADE: item[9],
            UNI_COM: item[10],
            ICMS: item[11],
            DIVISOR: item[12],
            PERC_ST: item[13],
            IPI: item[14],
            QTDE: item[15],
            PRECO: item[18],
            DESCONTO: item[19],
            ID_ITEN: item[22],
            SITUACAO: item[23],
            ORDEM: item[24],
            SOLICITACAO: item[25],
            DT_ENTREGA: item[26],
            TP_ITEM: 'M'
        })
    });

    $('#tabelaItensProduto').DataTable().rows().data().map(item => {
        arrItens.push({
            CODIGO: item[0],
            DESCRICAO: item[1],
            COR: item[2],
            TAM: item[3],
            DEPOSITO: item[4],
            C_CUSTO: item[6],
            CONTA_CONT: item[7],
            ESPECIFICA: item[8],
            CODIGO_FORN: item[9],
            UNI_COM: item[10],
            UNIDADE: item[11],
            ICMS: item[12],
            IPI: item[13],
            PERC_ST: item[14],
            QTDE: item[15],
            PRECO: item[18],
            DESCONTO: item[19],
            ID_ITEN: item[22],
            SITUACAO: item[23],
            ORDEM: item[24],
            SOLICITACAO: item[25],
            DT_ENTREGA: item[26],
            TP_ITEM: 'P'
        })
    });

    $('#tabelaItensServico').DataTable().rows().data().map(item => {
        arrItens.push({
            CODIGO: item[0],
            DESCRICAO: item[1],
            CONTA_CONT: item[2],
            C_CUSTO: item[3],
            CODIGO_FORN: item[4],
            ESPECIFICA: item[5],
            QTDE: item[6],
            PRECO: item[9],
            DESCONTO: item[10],
            VALOR_ISS: item[11],
            VALOR_IRRF: item[12],
            ID_ITEN: item[14],
            SITUACAO: item[15],
            ORDEM: item[16],
            SOLICITACAO: item[17],
            DT_ENTREGA: item[18],
            TP_ITEM: 'S'
        })
    });
    return arrItens;
};

function adicionaBotoes() {
    return '<div class="divBtnOpcoes"> ' +
        '       <button class="botaoOpcoes btn-editar" type="button" title="Editar"><span class="fas fa-edit" style="color:green"></span></button>     ' +
        '       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
        '     </div>';
};

function addItem(sItem) {
    if (!solicitacaoInclusa.includes(sItem.SOLICITACAO)) {
        solicitacaoInclusa.push(sItem.SOLICITACAO);
    };

    if (sItem.TP_ITEM == 'P') {
        $('#tabelaItensProduto').DataTable().row.add(
            [
                sItem.CODIGO,
                sItem.DESCRICAO,
                sItem.COR,
                sItem.TAM,
                sItem.DEPOSITO,
                retornaFotoProduto(sItem.CODIGO, sItem.ORDEM),
                sItem.C_CUSTO,
                sItem.CONTA_CONT,
                sItem.ESPECIFICA,
                sItem.CODIGO_FORN,
                sItem.UNI_COM,
                sItem.UNIDADE,
                sItem.ICMS,
                sItem.IPI,
                sItem.PERC_ST,
                sItem.QTDE,
                sItem.QTDE_B,
                sItem.QTDE_CANC,
                sItem.PRECO,
                sItem.DESCONTO,
                sItem.TOTAL_ITEM.toFixed(2),
                sItem.TOTAL_IPI.toFixed(2),
                sItem.ID_ITEN,
                sItem.SITUACAO,
                sItem.ORDEM,
                sItem.SOLICITACAO,
                sItem.DT_ENTREGA,
                adicionaBotoes()
            ]).draw(false);
    } else if (sItem.TP_ITEM == 'M') {
        $('#tabelaItensMaterial').DataTable().row.add(
            [
                sItem.CODIGO,
                sItem.DESCRICAO,
                sItem.COR,
                sItem.DEPOSITO,
                retornaFotoProduto(sItem.CODIGO, sItem.ORDEM),
                sItem.CONTA_CONT,
                sItem.C_CUSTO,
                sItem.CODIGO_FORN,
                sItem.ESPECIFICA,
                sItem.UNIDADE,
                sItem.UNI_COM,
                sItem.ICMS,
                sItem.DIVISOR,
                sItem.PERC_ST,
                sItem.IPI,
                sItem.QTDE,
                sItem.QTDE_B,
                sItem.QTDE_CANC,
                sItem.PRECO,
                sItem.DESCONTO,
                sItem.TOTAL_IPI.toFixed(2),
                sItem.TOTAL_ITEM.toFixed(2),
                sItem.ID_ITEN,
                sItem.SITUACAO,
                sItem.ORDEM,
                sItem.SOLICITACAO,
                sItem.DT_ENTREGA,
                adicionaBotoes()
            ]).draw(false);
    } else if (sItem.TP_ITEM == 'S') {
        $('#tabelaItensServico').DataTable().row.add(
            [
                sItem.CODIGO,
                sItem.DESCRICAO,
                sItem.CONTA_CONT,
                sItem.C_CUSTO,
                sItem.CODIGO_FORN,
                sItem.ESPECIFICA,
                sItem.QTDE,
                sItem.QTDE_B,
                sItem.QTDE_CANC,
                sItem.PRECO,
                sItem.DESCONTO,
                sItem.VALOR_ISS,
                sItem.VALOR_IRRF,
                sItem.TOTAL_ITEM.toFixed(2),
                sItem.ID_ITEN,
                sItem.SITUACAO,
                sItem.ORDEM,
                sItem.SOLICITACAO,
                sItem.DT_ENTREGA,
                adicionaBotoes()
            ]).draw(false);
    }
};

async function gravaDados() {
    $.LoadingOverlay('show');
    try {
        if (idItens.length > 0) {
            const itensExcluir = {
                NUMERO: pegaValor('#txtNumero'),
                ITENS: idItens
            };
            await requisicao('POST', '/sisplan/ordem_compra/v1/itens_ordem_compra?', '', JSON.stringify(itensExcluir), 90000); //Necessário fazer no post pois o delete não envia o body
        };

        const ordemCompra = {
            NUMERO: pegaValor('#txtNumero'),
            EMPRESA: pegaValor('#selectEmpresa'),
            DT_EMISSAO: pegaValor('#txtDtEmissao'),
            USUARIO: pegaValor('#txtUsuario'),
            CODFOR: pegaChave('#txtFornecedor'),
            SOLICITACAO: pegaChave('#txtSolicitacao'),
            DT_ENTREGA: pegaValor('#txtDataEntrega'),
            COLECAO: pegaChave('#txtColecao'),
            DEPOSITO: pegaChave('#txtDeposito'),
            MOTIVO: pegaChave('#txtMotivo'),
            OBRA: pegaChave('#txtObra'),
            HISTORICO: pegaChave('#txtHistorico'),
            OPERACAO: pegaChave('#txtOperacao'),
            FRETE: pegaValor('#rgTransportador'),
            OBS: pegaValor('#txtObs'),
            OBS_COTACAO: pegaValor('#txtObsCotacao'),
            CODTRAN: pegaChave('#txtTransporte'),
            REDESPACHO: pegaChave('#txtRedespacho'),
            ENTREGA: pegaChave('#txtLocalEntrega'),
            REFERENCIA: pegaValor('#txtReferencia'),
            NUM_CONTATO: pegaChave('#txtContato'),
            VAL_FRETE: pegaValor('#txtFrete'),
            VALDESCONTO: pegaValor('#txtDesconto'),
            VAL_ACRESCIMO: pegaValor('#txtAcrescimo'),
            VLR_ANTEC: pegaValor('#txtAntecipacao'),
            DESCONTO: pegaValor('#txtPercDescontos'),
            PERC_ACRESCIMO: pegaValor('#txtPercAcrescimo'),
            PERC_ANTEC: pegaValor('#txtPercAntecipacao'),
            MOEDA: pegaChave('#txtMoeda') == '' ? 0 : pegaChave('#txtMoeda'),
            CONDICAO: retornaCondicoesPgto(),
            EMP_ID: getCookie('emp_id'),
            ATUALIZASOLICITACAO: atualizaSolicitacao.toString().replace(',', `','`),
            ITENS: retornaItens()
        };

        const response = await requisicao('POST', '/sisplan/ordem_compra/v1/ordem_compra?', '', JSON.stringify(ordemCompra), 90000);

        if (!response) {
            $.LoadingOverlay('hide');
            return;
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay('hide');
            msgAlerta(jsonStr.mensagem);
            return;
        }

        $.LoadingOverlay('hide');
        criaMensagemSucesso(`Ordem de compra ${pegaValor('#txtNumero')} gravada com sucesso!`, () => { window.location.href = `${BASE_URI}/ordem_compra`; });
    } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgAlerta(`Não foi possível gravar os dados da ordem de compra: ${error}`);
    }
};

function retornaMultiplicacao(value1, value2, value3) {
    let valor = (value1 * value2);
    valor = valor - (value3 > 0 ? (valor * (value3 / 100)) : 0);
    return valor;
};

function adicionaPaginacao() {
    $(".next").click(async function () {
        let validator = $("#msform").validate();
        let liberado = true;

        if ($(this).attr("id") == "avancar1") {
            validator.element("#txtFornecedor");
            validator.element("#txtDataEntrega");
            if (!(validator.element("#txtFornecedor") && validator.element("#txtDataEntrega"))) {
                liberado = false;
            }
        }

        if ($(this).attr("id") == "avancarItens") {
            liberado = validaItens();
        }

        if (liberado) {
            currentFs = $(this).parent();
            nextFs = $(this).parent().next();
            $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
            nextFs.show();
            currentFs.animate({
                opacity: 0,
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        display: "none",
                        position: "relative",
                    });
                    nextFs.css({
                        opacity,
                    });
                },
                duration: 600,
            });
            $("#tabelaItensMaterial").DataTable().columns.adjust().draw(false);
            $("#tabelaItensProduto").DataTable().columns.adjust().draw(false);
            $("#tabelaItensServico").DataTable().columns.adjust().draw(false);
        }
    });

    $(".previous").click(async function () {
        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();

        $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");

        previousFs.show();

        currentFs.animate({
            opacity: 0,
        }, {
            step(now) {
                opacity = 1 - now;

                currentFs.css({
                    display: "none",
                    position: "relative",
                });
                previousFs.css({
                    opacity,
                });
            },
            duration: 600,
        });
    });
};

$(document).ready(async function () {

    async function setaDatas() {
        await setarDataAtual('txtDataEntrega');
        await setarDataAtual('txtDtEmissao');
    };

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    adicionaPaginacao();
    adicionaMascaraCampos();
    adicionaValidacoes();
    await setaDatas();

    function bloqueiaCampoNumero() {
        $('#txtNumero').prop('disabled', true);
        $('#txtNumero').prop('readonly', true);
    };

    function adicionaValidacoes() {
        $("#msform").validate({
            debug: false,
            ignore: "",
            rules: {
                txtFornecedor: {
                    required: true,
                },
                txtDataEntrega: {
                    required: true,
                },
                txtMoeda: {
                    required: true,
                },
                txtCondPagto1: {
                    required: true,
                },
                tabelaItensMaterial: {
                    required: true,
                },
                tabelaItensProduto: {
                    required: true,
                },
                tabelaItensServico: {
                    required: true,
                }
            },
            messages: {
                txtFornecedor: {
                    required: "Informe um fornecedor.",
                },
                txtDataEntrega: {
                    required: "Informe uma data.",
                },
                txtMoeda: {
                    required: "Informe uma moeda.",
                },
                txtCondPagto1: {
                    required: "Informe a condição de pagamento",
                },
                tabelaItensMaterial: {
                    required: "Necessário conter algum item cadastrado",
                },
                tabelaItensProduto: {
                    required: "Necessário conter algum item cadastrado",
                },
                tabelaItensServico: {
                    required: "Necessário conter algum item cadastrado",
                }
            },
            errorElement: "span",
            errorPlacement(error, element) {
                error.addClass("invalid-feedback");
                element.closest(".form-group").append(error);
            },
            highlight(element) {
                $(element).addClass("is-invalid");
            },
            unhighlight(element) {
                $(element).removeClass("is-invalid");
            },
        });
    };

    $('#txtSolicitacao').on('keydown', (event) => {
        const keyName = event.key;

        if (keyName === 'F8') {
            event.preventDefault();
            $('#modal-Solicitacao').modal('show');
        };
    });

    await adicionaEmpresas();
    criaDataTablePadrao('#tabelaItensMaterial', false, false, false, false, true, true, '400px', null, null, [], [], [], [18, 19, 20, 21]);
    criaDataTablePadrao('#tabelaItensProduto', false, false, false, false, true, true, '400px', null, null, [], [], [], [18, 19, 20, 21]);
    criaDataTablePadrao('#tabelaItensServico', false, false, false, false, true, true, '400px', null, null, [], [], [], [9, 10, 11, 12, 13]);

    await validaEdicao();

    if ($('#txtNumero').val() == '') {
        $('#txtNumero').val(await RetornaProximo('COMPRA', 'COMPRA', 'NUMERO', 6));
        $('#txtUsuario').val(getCookie("usuario"));
        bloqueiaCampoNumero();
    }

    async function validaEdicao() {
        const sOrdemCompra = $(window.location.href.split('/')).get(-1);

        if (sOrdemCompra == 'create') {
            return;
        };

        $.LoadingOverlay('show');
        try {
            const dados = await retornaDadosOrdemCompra(atob(sOrdemCompra));
            const itens = await retornaDadosItens(atob(sOrdemCompra));

            insereValor('#txtNumero', dados.NUMERO);
            $('#selectEmpresa').val(dados.EMPRESA).change();
            insereValor('#txtDtEmissao', dados.DT_EMISSAO.slice(0, 10));
            insereValor('#txtUsuario', dados.USUARIO);
            insereValor('#txtFornecedor', dados.CODFOR, dados.NOME);
            insereValor('#txtSolicitacao', dados.SOLICITACAO, dados.SOLICITACAO);
            insereValor('#txtDataEntrega', dados.DT_ENTREGA.slice(0, 10));
            insereValor('#txtColecao', dados.COLECAO, dados.DESC_COLECAO);
            insereValor('#txtDeposito', dados.DEPOSITO, dados.DESC_DEPOSITO);
            insereValor('#txtMotivo', dados.MOTIVO, dados.DESC_MOTIVO);
            insereValor('#txtObra', dados.OBRA, dados.DESC_OBRA);
            insereValor('#txtHistorico', dados.HISTORICO, dados.DESC_HISTORICO);
            insereValor('#txtOperacao', dados.OPERACAO, dados.DESC_OPERACAO);
            $('#rgTransportador').val(dados.FRETE).change();
            insereValor('#txtObs', dados.OBS);
            insereValor('#txtObsCotacao', dados.OBS_COTACAO);
            insereValor('#txtTransporte', dados.CODTRAN, dados.DESC_CODTRAN);
            insereValor('#txtRedespacho', dados.REDESPACHO, dados.DESC_REDESPACHO);
            insereValor('#txtLocalEntrega', dados.ENTREGA, dados.DESC_ENTREGA);
            insereValor('#txtReferencia', dados.REFERENCIA);
            insereValor('#txtContato', dados.NUM_CONTATO, dados.DESC_NUM_CONTATO);
            insereValor('#txtFrete', dados.VAL_FRETE);
            insereValor('#txtFretePagamento', dados.VAL_FRETE);
            insereValor('#txtDesconto', parseFloat(dados.VALDESCONTO));
            insereValor('#txtAcrescimo', parseFloat(dados.VAL_ACRESCIMO));
            insereValor('#txtAntecipacao', parseFloat(dados.VLR_ANTEC));
            insereValor('#txtPercDescontos', parseFloat(dados.DESCONTO));
            insereValor('#txtPercAcrescimo', parseFloat(dados.PERC_ACRESCIMO));
            insereValor('#txtPercAntecipacao', parseFloat(dados.PERC_ANTEC));
            insereValor('#txtMoeda', dados.MOEDA, dados.DESC_MOEDA);
            insereCondicoesPgto(dados.CONDICAO);
            itens.map(item => { addItem(item) });

            $("#tabelaItensMaterial").DataTable().columns.adjust().draw(false);
            $("#tabelaItensProduto").DataTable().columns.adjust().draw(false);
            $("#tabelaItensServico").DataTable().columns.adjust().draw(false);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function retornaDadosOrdemCompra(sNumero) {
        const dadosSelect = {
            tabela: 'COMPRA',
            camposSelect: [
                'COMPRA.NUMERO', 'COMPRA.EMPRESA', 'COMPRA.DT_EMISSAO', 'COMPRA.USUARIO', 'COMPRA.CODFOR', 'ENTIDADE.NOME', 'COMPRA.SOLICITACAO', 'COMPRA.DT_ENTREGA',
                'COMPRA.MOTIVO', 'MENSAGEM.DESCRICAO DESC_MOTIVO', 'COMPRA.OBRA', 'OBRA.DESCRICAO DESC_OBRA', 'COMPRA.COLECAO', 'COLECAO.DESCRICAO DESC_COLECAO',
                'COMPRA.DEPOSITO', 'DEPOSITO.DESCRICAO DESC_DEPOSITO', 'COMPRA.HISTORICO', 'HISTCP.DESCRICAO  DESC_HISTORICO', 'COMPRA.OPERACAO', 'OPER_FISCAL.DESCRICAO DESC_OPERACAO',
                'COMPRA.OBS', 'COMPRA.OBS_COTACAO', 'COMPRA.CODTRAN', 'TABTRAN.NOME DESC_CODTRAN', 'COMPRA.REDESPACHO', 'COMPRA.FRETE', 'COMPRA.ENTREGA',
                '(SELECT TABTRAN.NOME FROM [TABTRAN] TABTRAN WHERE TABTRAN.CODIGO = COMPRA.REDESPACHO) DESC_REDESPACHO',
                '(SELECT ENTIDADE.NOME FROM [ENTIDADE] ENTIDADE WHERE ENTIDADE.CODCLI = COMPRA.ENTREGA) DESC_ENTREGA', 'COMPRA.REFERENCIA', 'COMPRA.NUM_CONTATO', 'CONTATO.NOME DESC_NUM_CONTATO',
                'COMPRA.VAL_FRETE', 'COMPRA.VALDESCONTO', 'COMPRA.VAL_ACRESCIMO', 'COMPRA.VLR_ANTEC', 'COMPRA.CONDICAO', 'COMPRA.MOEDA', 'MOEDA.DESCRICAO DESC_MOEDA', 'COMPRA.DESCONTO',
                'COMPRA.PERC_ACRESCIMO', 'COMPRA.PERC_ANTEC'
            ],
            leftJoin: [
                { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI         = COMPRA.CODFOR' },
                { tabela: 'COLECAO', condicao: 'COLECAO.CODIGO           = COMPRA.COLECAO' },
                { tabela: 'MENSAGEM', condicao: 'MENSAGEM.CODMEN         = COMPRA.MOTIVO' },
                { tabela: 'OBRA', condicao: 'OBRA.CODIGO                 = COMPRA.OBRA' },
                { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO         = COMPRA.DEPOSITO' },
                { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO          = COMPRA.HISTORICO' },
                { tabela: 'OPER_FISCAL', condicao: 'OPER_FISCAL.CODIGO   = COMPRA.OPERACAO' },
                { tabela: 'TABTRAN', condicao: 'TABTRAN.CODIGO           = COMPRA.CODTRAN' },
                { tabela: 'MOEDA', condicao: 'CAST(MOEDA.CODMOE AS VARCHAR(10)) = COMPRA.MOEDA' },
                { tabela: 'CONTATO', condicao: 'CONTATO.CODCLI           = COMPRA.NUM_CONTATO' }
            ],
            where: [`COMPRA.NUMERO = '${sNumero}' AND COMPRA.EMP_ID = ${getCookie('emp_id')}`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            msgAlerta('Não foi possível buscar os dados da ordem de compra.');
            return;
        }
        return retornoSelect[0];
    };

    async function retornaDadosItens(sNumero) {
        const dadosSelect = {
            tabela: 'CO_ITEN',
            camposSelect: [
                'CO_ITEN.CODIGO',
                'CO_ITEN.COR',
                'CO_ITEN.TAM',
                'CO_ITEN.TP_ITEM',
                'CO_ITEN.DEPOSITO',
                'CO_ITEN.C_CUSTO',
                'CO_ITEN.CONTA_CONT',
                'CO_ITEN.CODIGO_FORN',
                'CO_ITEN.ESPECIFICA',
                'CO_ITEN.UNIDADE',
                'CO_ITEN.UNI_COM',
                'CO_ITEN.ICMS',
                'CO_ITEN.DIVISOR',
                'CO_ITEN.PERC_ST',
                'CO_ITEN.IPI',
                'CO_ITEN.QTDE',
                'CO_ITEN.PRECO',
                'CO_ITEN.DESCONTO',
                'CO_ITEN.VALOR_ISS',
                'CO_ITEN.VALOR_IRRF',
                `CASE CO_ITEN.TP_ITEM WHEN 'M' THEN MATERIAL.DESCRICAO WHEN 'P' THEN PRODUTO.DESCRICAO WHEN 'S' THEN SERVICO.DESCRICAO END DESCRICAO`,
                '(CO_ITEN.QTDE * CO_ITEN.PRECO) - ((CO_ITEN.QTDE * CO_ITEN.PRECO) * (UDF_NVL(CO_ITEN.DESCONTO) / 100)) TOTAL_ITEM',
                '((CO_ITEN.QTDE * CO_ITEN.PRECO) * (UDF_NVL(CO_ITEN.IPI)/100)) TOTAL_IPI',
                'CO_ITEN.QTDE_B',
                'CO_ITEN.QTDE_CANC',
                'CO_ITEN.ID_ITEN',
                'CO_ITEN.SITUACAO',
                'CO_ITEN.ORDEM',
                'CO_ITEN.SOLICITACAO',
                'CO_ITEN.DT_ENTREGA'
            ],
            innerJoin: [{ tabela: 'COMPRA', condicao: 'COMPRA.NUMERO = CO_ITEN.NUMERO' }],
            leftJoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO   = CO_ITEN.CODIGO' },
            { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = CO_ITEN.CODIGO' },
            { tabela: 'SERVICO', condicao: 'SERVICO.CODIGO   = CO_ITEN.CODIGO' }],
            where: [`CO_ITEN.NUMERO = '${sNumero}' AND COMPRA.EMP_ID = ${getCookie('emp_id')}`]
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            msgAlerta('Não foi possível buscar os dados dos itens.');
            return;
        }
        return retornoSelect;
    };

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
    $('#txtFornecedor').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtSolicitacao').autocompleta(1, `JSON={ "tabela":"SOL_COMPRA", "camposSelect":[ "numero chave", "solicitante descricao"], "where": null}`);
    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtTransporte').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
    $('#txtContato').autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtRedespacho').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
    $('#txtLocalEntrega').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtOperacao').autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCentroCusto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":[ "codmen chave", "descricao descricao"], "where": null}`);
    $('#txtObra').autocompleta(1, `JSON={ "tabela":"OBRA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtServico').autocompleta(1, `JSON={ "tabela":"SERVICO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContaContMaterial').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContaContProduto').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtContaContServico').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').on('blur', function () {
        $('#txtCorMaterial').unbind('autocompleta');
        $('#txtCorMaterial').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btn-CorMaterial').off();
        $('#btn-CorMaterial').unbind('pesquisa');
        $('#btn-CorMaterial').pesquisa_array(['#txtCorMaterial'], ['COR'], ['DESCRICAO'],
            `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN", 
                                      "camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],
                                      "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                                      "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                                      "where": ["MAT_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
    });
    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtProduto').on('blur', function () {
        $('#txtCorProduto').unbind('autocompleta');
        $('#txtCorProduto').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btn-CorProduto').off();
        $('#btn-CorProduto').unbind('pesquisa');
        $('#btn-CorProduto').pesquisa_array(['#txtCorProduto'], ['COR'], ['DESCRICAO'],
            `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", 
                                      "camposSelect":[ "PA_ITEN.COR", "CADCOR.DESCRICAO" ],
                                      "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], 
                                      "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], 
                                      "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'CADCOR');
    });
    $('#txtProduto').on('blur', function () {
        $('#txtTamProduto').unbind('autocompleta');
        $('#txtTamProduto').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, TAM DESCRICAO"], "where": [] }`, [], [], []);
        $('#btn-TamProduto').off();
        $('#btn-TamProduto').unbind('pesquisa');
        $('#btn-TamProduto').pesquisa_array(['#txtTamProduto'], ['TAM'], ['TAM'],
            `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PA_ITEN", 
                                      "camposSelect":[ "PA_ITEN.TAM" ],
                                      "groupBy": ["PA_ITEN.TAM"], 
                                      "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Tamanho', 'PA_ITEN');
    });
    $('#txtDepositoMaterial').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtDepositoProduto').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCentroCustoMaterial').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCentroCustoProduto').autocompleta(1, `JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#btn-fornecedor').pesquisa_serverside(['#txtFornecedor'], ['CODCLI', 'NOME'], ['CODCLI', 'NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
    $("#btn-solicitacao").pesquisa("#txtSolicitacao", "NUMERO", "SOLICITANTE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SOL_COMPRA", "camposSelect":[ "NUMERO", "SOLICITANTE"]}`, "Pesquisa Solicitação", "SOL_COMPRA");
    $("#btn-Colecao").pesquisa("#txtColecao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COLECAO", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Coleção", "COLECAO");
    $("#btn-Deposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Depósito", "DEPOSITO");
    $("#btn-Transporte").pesquisa("#txtTransporte", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "codigo", "nome"]}`, "Pesquisa Transportadora", "TABTRAN");
    $("#btn-Contato").pesquisa("#txtContato", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTATO", "camposSelect":[ "codcli", "nome"]}`, "Pesquisa Contato", "CONTATO");
    $("#btn-Redespacho").pesquisa("#txtRedespacho", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "codigo", "nome"]}`, "Pesquisa Transportadora", "TABTRAN");
    $("#btn-LocalEntrega").pesquisa("#txtLocalEntrega", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "codcli", "nome"]}`, "Pesquisa Entidade", "ENTIDADE");
    $("#btn-Operacao").pesquisa("#txtOperacao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Operação", "OPER_FISCAL");
    $("#btn-Motivo").pesquisa("#txtMotivo", "CODMEN", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, "Pesquisa Mensagem", "mensagem");
    $("#btn-Obra").pesquisa("#txtObra", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OBRA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Mensagem", "obra");
    $("#btn-Historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"]}`, "Pesquisa Histórico", "histórico");
    $("#btn-Material").pesquisa("#txtMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Material", "material");
    $("#btn-Servico").pesquisa("#txtServico", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SERVICO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Serviço", "servico");
    $("#btn-Produto").pesquisa("#txtProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Material", "produto");
    $("#btn-DepositoMaterial").pesquisa("#txtDepositoMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "deposito");
    $("#btn-DepositoProduto").pesquisa("#txtDepositoProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "deposito");
    $("#btn-CentroCustoMaterial").pesquisa("#txtCentroCustoMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Centro Custo", "centroCusto");
    $("#btn-CentroCustoProduto").pesquisa("#txtCentroCustoProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Centro Custo", "centroCusto");
    $("#btn-CentroCustoServico").pesquisa("#txtCentroCustoServico", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CENTROCUSTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Centro Custo", "CentroCusto");
    $("#btn-ContaContMaterial").pesquisa("#txtContaContMaterial", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Material", "conta_cont");
    $("#btn-ContaContProduto").pesquisa("#txtContaContProduto", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa C. Contábil", "conta_cont");
    $("#btn-ContaContServico").pesquisa("#txtContaContServico", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa C. Contábil", "conta_cont");
    $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Moeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'Pesquisa Moeda', 'moeda');
    $('#btn-limpa-Moeda').on('click', function () { $('#txtMoeda').val('') });
    $('#btn-limpar-fornecedor').on('click', function () {
        $('#txtFornecedor').val('');
    });

    $('#txtProdutoGrade').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-ProdutoGrade').pesquisa('#txtProdutoGrade', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Produto', 'PRODUTO');
    $('#btn-limpa-ProdutoGrade').on('click', function () { $('#txtProdutoGrade').val('') });

    $('#txtSolicitacaoConsulta').autocompleta(1, `JSON={ "tabela":"SOL_COMPRA", "camposSelect":[ "NUMERO CHAVE", "SOLICITANTE DESCRICAO"], "where": null}`);
    $('#btn-SolicitacaoConsulta').pesquisa('#txtSolicitacaoConsulta', 'NUMERO', 'SOLICITANTE', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SOL_COMPRA", "camposSelect":[ "NUMERO", "SOLICITANTE"]}`, 'Pesquisa Solicitacao', 'SOL_COMPRA');
    $('#txtSolicitacaoConsulta').listaFiltros();
    $('#btn-limpa-SolicitacaoConsulta').on('click', function () {
        if ($('#txtSolicitacaoConsulta').val() == '') {
            $('#listaSolicitacaoConsulta').val('');
        }
        $('#txtSolicitacaoConsulta').val('');
        $('#txtSolicitacaoConsulta').focus();
    });

    $('#txtMaterialConsulta').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-MaterialConsulta').pesquisa('#txtMaterialConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'MATERIAL');
    $('#txtMaterialConsulta').listaFiltros();
    $('#btn-limpa-MaterialConsulta').on('click', function () {
        if ($('#txtMaterialConsulta').val() == '') {
            $('#listaMaterialConsulta').val('');
        }
        $('#txtMaterialConsulta').val('');
        $('#txtMaterialConsulta').focus();
    });

    $('#txtProdutoConsulta').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-ProdutoConsulta').pesquisa('#txtProdutoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'PRODUTO');
    $('#txtProdutoConsulta').listaFiltros();
    $('#btn-limpa-ProdutoConsulta').on('click', function () {
        if ($('#txtProdutoConsulta').val() == '') {
            $('#listaProdutoConsulta').val('');
        }
        $('#txtProdutoConsulta').val('');
        $('#txtProdutoConsulta').focus();
    });

    $('#txtGrupoConsulta').autocompleta(1, `JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-GrupoConsulta').pesquisa('#txtGrupoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo', 'GRUPO_MA');
    $('#txtGrupoConsulta').listaFiltros();
    $('#btn-limpa-GrupoConsulta').on('click', function () {
        if ($('#txtGrupoConsulta').val() == '') {
            $('#listaGrupoConsulta').val('');
        }
        $('#txtGrupoConsulta').val('');
        $('#txtGrupoConsulta').focus();
    });

    $('#txtSubGrupoConsulta').autocompleta(1, `JSON={ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-SubGrupoConsulta').pesquisa('#txtSubGrupoConsulta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa SubGrupo', 'SUBGRUPO_MA');
    $('#txtSubGrupoConsulta').listaFiltros();
    $('#btn-limpa-SubGrupoConsulta').on('click', function () {
        if ($('#txtSubGrupoConsulta').val() == '') {
            $('#listaSubGrupoConsulta').val('');
        }
        $('#txtSubGrupoConsulta').val('');
        $('#txtSubGrupoConsulta').focus();
    });

    $('#btn-limpar-solicitacao').on('click', function () {
        $('#txtSolicitacao').val('');
    });

    $('#btn-limpar-Colecao').on('click', function () {
        $('#txtColecao').val('');
    });

    $('#btn-limpar-Deposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    $('#btn-limpar-Transporte').on('click', function () {
        $('#txtTransporte').val('');
    });

    $('#btn-limpar-Contato').on('click', function () {
        $('#txtContato').val('');
    });

    $('#btn-limpar-Redespacho').on('click', function () {
        $('#txtRedespacho').val('');
    });

    $('#btn-limpar-LocalEntrega').on('click', function () {
        $('#txtLocalEntrega').val('');
    });

    $("#btn-limpar-Operacao").on('click', function () {
        $('#txtOperacao').val('');
    });

    $("#btn-limpar-Motivo").on('click', function () {
        $('#txtMotivo').val('');
    });

    $("#btn-limpar-Obra").on('click', function () {
        $('#txtObra').val('');
    });

    $("#btn-limpar-Historico").on('click', function () {
        $('#txtHistorico').val('');
    });

    $("#btn-limpar-Material").on('click', function () {
        $('#txtMaterial').val('');
    });

    $("#btn-limpar-Servico").on('click', function () {
        $('#txtServico').val('');
    });

    $("#btn-limpar-Produto").on('click', function () {
        $('#txtProduto').val('');
    });

    $("#btn-limpar-CorMaterial").on('click', function () {
        $('#txtCorMaterial').val('');
    });

    $("#btn-limpar-CorProduto").on('click', function () {
        $('#txtCorProduto').val('');
    });

    $("#btn-limpar-TamProduto").on('click', function () {
        $('#txtTamProduto').val('');
    });

    $("#btn-limpar-DepositoMaterial").on('click', function () {
        $('#txtDepositoMaterial').val('');
    });

    $("#btn-limpar-DepositoProduto").on('click', function () {
        $('#txtDepositoProduto').val('');
    });

    $("#btn-limpar-CentroCustoMaterial").on('click', function () {
        $('#txtCentroCustoMaterial').val('');
    });

    $("#btn-limpar-CentroCustoProduto").on('click', function () {
        $('#txtCentroCustoProduto').val('');
    });

    $("#btn-limpar-CentroCustoServico").on('click', function () {
        $('#txtCentroCustoServico').val('');
    });

    $("#btn-limpar-ContaContMaterial").on('click', function () {
        $('#txtContaContMaterial').val('');
    });

    $("#btn-limpar-ContaContProduto").on('click', function () {
        $('#txtContaContProduto').val('');
    });

    $("#btn-limpar-ContaContServico").on('click', function () {
        $('#txtContaContServico').val('');
    });

    $('#btnGravar').click(async function () {
        await gravaDados();
    });

    $("#Totais").on('click', function () {
        if (!$('#multiCollapseExample4').hasClass('show')) {
            geraTotais();
        }
    });

    $('#txtFrete').on('blur', function () {
        insereValor('#txtFretePagamento', pegaValor('#txtFrete'))
    });

    // $('.camposGrade').on('blur', function () {
    //     $("#tabelaGradeProduto").DataTable().columns.adjust().draw(false);   
    // });

    $('#avancar1').on('click', function () {
        totalizarItens();
    });

    $('#modalItem').on('hidden.bs.modal', function (_) {
        $('#txtProdutoGrade').val('');
        if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
            $('#tabelaGradeProduto').DataTable().destroy();
            $('#tabelaGradeProduto').empty();
        };
    });

    $('#txtProdutoGrade').on('blur', async function () {
        const codigo = pegaChave('#txtProdutoGrade');
        if (codigo == '') {
            return;
        };
        await explodeGradeProduto(codigo);
    });

    async function explodeGradeProduto(codigo) {
        $.LoadingOverlay('show');
        try {
            let tam;
            if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
                $('#tabelaGradeProduto').DataTable().destroy();
                $('#tabelaGradeProduto').empty();
            };

            const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
            const jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.RESULT[0].mensagem);
            }

            for (let i = 0; i < parseInt(jsonStr.length); i++) {
                const colunas = Object.keys(jsonStr[i]);
                const tamanhos = [];
                colunas.forEach((coluna) => {
                    if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
                        tamanhos.push(coluna);
                    }
                });

                const jsonObject = jsonStr.map(obj => {
                    const newObject = { ...obj };
                    delete newObject.CODIGO;
                    delete newObject.POSICAO;
                    Object.keys(obj).forEach(key => {
                        tam = RetornaIdTamFormatado(key);
                        if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
                            newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="${jsonStr[i][tam]}">`;
                            newObject[tam.split('HIFEN')[1]] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR + tam}" value="0">`;
                            delete newObject[tam];
                        }
                    });
                    return { ...newObject };
                });

                if (i == 0) {
                    const titulosFixos = ['COR', 'DESC_COR'];
                    const titulosGeral = [...titulosFixos, ...tamanhos];
                    const titulos = titulosGeral.map(titulo => {
                        const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
                        const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
                        return objeto;
                    });
                    criaDataTablePadrao('#tabelaGradeProduto', false, false, false, false, true, false, '250px', jsonObject, titulos);
                }
            }

        } finally {
            $.LoadingOverlay('hide');

            $('.camposGrade').on('blur', function () {
                preencheComZero();
            });

            $('.camposGrade').maskMoney({
                decimal: ".",
                thousands: "",
                precision: 0,
            });
            preencheComZero();
        }
    };

    async function adicionaEmpresas() {
        const pesquisaParam = {
            tabela: 'EMPRESA',
            camposSelect: ['EMP_PAT', 'EMP_NOME'],
            where: ['1 = 1'],
            orderBy: ['EMP_PAT'],
        }
        $("#selectEmpresaSolicitacao").append(new Option('', ''));
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        jsonStr.map(emp => {
            $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
            $("#selectEmpresaSolicitacao").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
        });
    };

    $("#voltarAcesso").on("click", async function () {
        window.location.href = `${BASE_URI}/ordem_compra`;
    });

    function adicionaMascaraCampos() {
        $('.maskDecimais').maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        $('.maskDecimais').on('blur', function () {
            if ($(this).val() == '') {
                $(this).val('0.00');
            }
        });
    };

    $('#tabelaItensMaterial').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensMaterial').DataTable().row($(this).parents('tr')).data();
        if (itens[23] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaMaterial(itens, index);
    });

    $('#tabelaItensProduto').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensProduto').DataTable().row($(this).parents('tr')).data();
        if (itens[23] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaProduto(itens, index);
    });

    $('#tabelaItensServico').on('click', '.btn-editar', async function () {
        let index = $(this).closest('tr')[0].rowIndex - 1;
        let itens = $('#tabelaItensServico').DataTable().row($(this).parents('tr')).data();
        if (itens[15] == 'B') {
            msgAlertaSemConfirmacao("Item já baixado. Não é permitido Alterar!");
            return;
        }
        editaServico(itens, index);
    });

    $('#tabelaItensMaterial').on('click', '.btn-excluir', async function () {
        adicionaIdExclusao($('#tabelaItensMaterial').DataTable().row($(this).parents('tr')).data()[22]);
        $('#tabelaItensMaterial').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalizarItens();
    });

    $('#tabelaItensProduto').on('click', '.btn-excluir', async function () {
        adicionaIdExclusao($('#tabelaItensProduto').DataTable().row($(this).parents('tr')).data()[22]);
        $('#tabelaItensProduto').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalizarItens();
    });

    $('#tabelaItensServico').on('click', '.btn-excluir', async function () {
        adicionaIdExclusao($('#tabelaItensServico').DataTable().row($(this).parents('tr')).data()[14]);
        $('#tabelaItensServico').DataTable().row($(this).parents('tr')).remove().draw(false);
        totalizarItens();
    });

    function AdicionarMaterial() {
        const codigo = pegaChave('#txtMaterial');
        const descricao = pegaDescricao('#txtMaterial');
        const cor = pegaChave('#txtCorMaterial');
        const deposito = pegaChave('#txtDepositoMaterial');
        const contaContabil = pegaChave('#txtContaContMaterial');
        const centroCusto = pegaChave('#txtCentroCustoMaterial');
        const codFornecec = pegaValor('#txtCodFornecMaterial');
        const especificacao = $('#txtEspecificacaoMaterial').val();
        const unidade = $('#txtUnidadeMaterial').val();
        const uni_compra = $('#txtUniCompraMaterial').val();
        const icms = $('#txtICMSMaterial').val();
        const divisor = $('#txtDivisorMaterial').val();
        const st = $('#txtSTMaterial').val();
        const ipi = $('#txtIPIMaterial').val();
        const qtde = $('#txtQtdeMaterial').val();
        const preco = $('#txtPrecoMaterial').val();
        const desconto = ($('#txtDescontoMaterial').val() == '') ? 0 : $('#txtDescontoMaterial').val();
        const totalIPI = $('#txtTotalIPIMaterial').val();
        const totalItem = $('#txtTotalItemMaterial').val();
        const indice = pegaValor('#txtIndexMat');
        const ordem = retornaProximaOrdem();

        if (codigo == '') {
            msgAlerta('Material não informado, impossível continuar');
            return;
        };

        if (cor == '') {
            msgAlerta('Cor não informada, impossível continuar');
            return;
        };

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        };

        if ((preco == '') || (preco == 0)) {
            msgAlerta('Preço não informado, impossível continuar.');
            return;
        }

        try {
            if (indice == '') {
                $('#tabelaItensMaterial').DataTable().row.add(
                    [
                        codigo,
                        descricao,
                        cor,
                        deposito,
                        retornaFotoProduto(codigo, ordem),
                        contaContabil,
                        centroCusto,
                        codFornecec,
                        especificacao,
                        unidade,
                        uni_compra,
                        icms,
                        divisor,
                        st,
                        ipi,
                        qtde,
                        0,
                        0,
                        preco,
                        desconto,
                        totalIPI,
                        totalItem,
                        0,
                        'A',
                        ordem,
                        '',
                        '1899-01-01',
                        adicionaBotoes()
                    ]).draw(false);
            } else {
                let data_old = $('#tabelaItensMaterial').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = cor;
                data_old[3] = deposito;
                data_old[4] = retornaFotoProduto(codigo, data_old[24]);
                data_old[5] = contaContabil;
                data_old[6] = centroCusto;
                data_old[7] = codFornecec;
                data_old[8] = especificacao;
                data_old[9] = unidade;
                data_old[10] = uni_compra;
                data_old[11] = icms;
                data_old[12] = divisor;
                data_old[13] = st;
                data_old[14] = ipi;
                data_old[15] = qtde;
                data_old[18] = preco;
                data_old[19] = desconto;
                data_old[20] = totalIPI;
                data_old[21] = totalItem;
                $('#tabelaItensMaterial').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposMaterial();
        }
    };

    function AdicionarProduto() {
        const codigo = pegaChave('#txtProduto');
        const descricao = pegaDescricao('#txtProduto');
        const cor = pegaChave('#txtCorProduto');
        const tam = pegaChave('#txtTamProduto');
        const deposito = pegaChave('#txtDepositoProduto');
        const centroCusto = pegaChave('#txtCentroCustoProduto');
        const contaCont = pegaChave('#txtContaContProduto');
        const especificacao = $('#txtEspecificacaoProduto').val();
        const codFornec = $('#txtCodFornecProduto').val();
        const uni_compra = $('#txtUniCompraProduto').val();
        const unidade = $('#txtUniVendaProduto').val();
        const icms = $('#txtICMSProduto').val();
        const ipi = $('#txtIPIProduto').val();
        const st = $('#txtSTProduto').val();
        const qtde = $('#txtQtdeProduto').val();
        const preco = $('#txtPrecoProduto').val();
        const desconto = ($('#txtDescontoProduto').val() == '') ? 0 : $('#txtDescontoProduto').val();
        const totalItem = $('#txtTotalProduto').val();
        const totalIPI = $('#txtTotalIPIProduto').val();
        const indice = pegaValor('#txtIndexProd');
        const ordem = retornaProximaOrdem();

        if (codigo == '') {
            msgAlerta('Produto não informado, impossível continuar');
            return;
        }

        if (cor == '') {
            msgAlerta('Cor não informada, impossível continuar');
            return;
        }

        if (tam == '') {
            msgAlerta('Tamanho não informado, impossível continuar');
            return;
        }

        if (deposito == '') {
            msgAlerta('Depósito não informado, impossível continuar');
            return;
        }

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        }

        if ((preco == '') || (preco == 0)) {
            msgAlerta('Preço não informado, impossível continuar.');
            return;
        }

        try {
            if (indice == '') {
                $('#tabelaItensProduto').DataTable().row.add(
                    [
                        codigo,
                        descricao,
                        cor,
                        tam,
                        deposito,
                        retornaFotoProduto(codigo, ordem),
                        centroCusto,
                        contaCont,
                        especificacao,
                        codFornec,
                        uni_compra,
                        unidade,
                        icms,
                        ipi,
                        st,
                        qtde,
                        0,
                        0,
                        preco,
                        desconto,
                        totalItem,
                        totalIPI,
                        0,
                        'A',
                        ordem,
                        '',
                        '1899-01-01',
                        adicionaBotoes()
                    ]).draw(false);
            } else {
                let data_old = $('#tabelaItensProduto').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = cor;
                data_old[3] = tam;
                data_old[4] = deposito;
                data_old[5] = retornaFotoProduto(codigo, data_old[24]);
                data_old[6] = centroCusto;
                data_old[7] = contaCont;
                data_old[8] = especificacao;
                data_old[9] = codFornec;
                data_old[10] = uni_compra;
                data_old[11] = unidade;
                data_old[12] = icms;
                data_old[13] = ipi;
                data_old[14] = st;
                data_old[15] = qtde;
                data_old[18] = preco;
                data_old[19] = desconto;
                data_old[20] = totalItem;
                data_old[21] = totalIPI;
                $('#tabelaItensProduto').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposProduto();
        }
    };

    function AdicionarServico() {
        const codigo = pegaChave('#txtServico');
        const descricao = pegaDescricao('#txtServico');
        const cContabil = pegaChave('#txtContaContServico');
        const centroCusto = pegaChave('#txtCentroCustoServico');
        const codFornec = $('#txtCodFornecServico').val();
        const especificacao = $('#txtEspecificacaoServico').val();
        const qtde = $('#txtQtdeServico').val();
        const preco = $('#txtPrecoServico').val();
        const desconto = ($('#txtDescontoServico').val() == '') ? 0 : $('#txtDescontoServico').val();
        const valorISS = ($('#txtValIssServico').val() == '') ? 0 : $('#txtValIssServico').val();
        const valorIRRF = ($('#txtValorIrrfServico').val() == '') ? 0 : $('#txtValorIrrfServico').val();
        const totalItem = $('#txtTotalServico').val();
        const indice = pegaValor('#txtIndexServ');

        if (codigo == '') {
            msgAlerta('Serviço não informado, impossível continuar');
            return;
        }

        if ((qtde == '') || (qtde == 0)) {
            msgAlerta('Quantidade não informado, impossível continuar.');
            return;
        }

        if ((preco == '') || (preco == 0)) {
            msgAlerta('Preço não informado, impossível continuar.');
            return;
        }

        try {
            if (indice == '') {
                $('#tabelaItensServico').DataTable().row.add(
                    [
                        codigo,
                        descricao,
                        cContabil,
                        centroCusto,
                        codFornec,
                        especificacao,
                        qtde,
                        0,
                        0,
                        preco,
                        desconto,
                        valorISS,
                        valorIRRF,
                        totalItem,
                        0,
                        'A',
                        retornaProximaOrdem(),
                        '',
                        '1899-01-01',
                        adicionaBotoes()
                    ]).draw(false);
            } else {
                let data_old = $('#tabelaItensServico').DataTable().row(indice).data();

                data_old[0] = codigo;
                data_old[1] = descricao;
                data_old[2] = cContabil;
                data_old[3] = centroCusto;
                data_old[4] = codFornec;
                data_old[5] = especificacao;
                data_old[6] = qtde;
                data_old[9] = preco;
                data_old[10] = desconto;
                data_old[11] = valorISS;
                data_old[12] = valorIRRF;
                data_old[13] = totalItem;
                $('#tabelaItensServico').DataTable().row(indice).data(data_old).draw(false);
            }
        } finally {
            limpaCamposServico();
        }
    };

    $('#btnAdicionarMaterial').on('click', async function () {
        AdicionarMaterial();
        totalizarItens();
    });

    $('#btnGradeProduto').on('click', async function () {
        if (pegaValor('#txtDepositoProduto') == '') {
            msgAlertaSemConfirmacao('Necessário informar um depósito!');
            return;
        }

        if ((pegaValor('#txtPrecoProduto') <= 0) || (pegaValor('#txtPrecoProduto') == '')) {
            msgAlertaSemConfirmacao('Necessário informar o preço!');
            return;
        }
        $('#modalItem').modal('show');
    });

    $('#btnAdicionarProduto').on('click', async function () {
        AdicionarProduto();
        totalizarItens();
    });

    $('#btnAdicionarServico').on('click', async function () {
        AdicionarServico();
        totalizarItens();
    });

    $('#btnConfirmarItem').on('click', async function () {
        confirmaItem();
        totalizarItens();
    });

    $('#btnConfirmarSolicitacao').on('click', async function () {
        importaSolicitacao();
        limpaCamposModalSolicitacao();
        $('#modal-Solicitacao').modal('hide');
    });

    $('#btnConsultarSolicitacao').on('click', async function () {
        await buscaSolicitacao();
        $('#check_todos').prop('checked', true);
    });

    $('#check_todos').on('click', async function () {
        $('.checkSolicitacao').prop('checked', $('#check_todos').prop('checked'));
        addSelected($('#check_todos').prop('checked'));
    });

    $("#txtSolicitacao").on('blur', async function () {
        const solicitacao = pegaChave('#txtSolicitacao');
        if (solicitacao != '') {
            if (!solicitacaoInclusa.includes(solicitacao)) {
                let filtros = ` SOL_ITEN.NUMERO = '${solicitacao}'`;
                filtros += ` AND SOL_COMPRA.LIBERADO <> 'B' `;
                filtros += ` AND (SOL_ITEN.QTDE - UDF_NVL(SOL_ITEN.QTDE_CANC) - UDF_NVL(SOL_ITEN.QTDE_B)) > 0`
                filtros += ` AND SOL_ITEN.SITUACAO <> 'B' `;
                filtros += ` AND SOL_ITEN.SITUACAO <> 'R' `;
                const pesquisaParam = {
                    tabela: 'SOL_ITEN',
                    camposSelect: ['CODIGO'],
                    innerJoin: [{ tabela: 'SOL_COMPRA', condicao: 'SOL_ITEN.NUMERO = SOL_COMPRA.NUMERO' }],
                    where: [filtros],
                };
                const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
                if (jsonStr.length > 0) {
                    atualizaSolicitacao.push(solicitacao);
                    solicitacaoInclusa.push(solicitacao);
                } else {
                    msgAlerta('Solicitação sem quantidade pendente, impossível importar!');
                    $('#txtSolicitacao').val('');
                    return;
                }
            } else {
                msgAlerta('Solicitação já inclusa, impossível importar novamente!');
                return;
            }
            await buscaSolicitacao(solicitacao);
            importaSolicitacao();
        }
    });

    calculoMaterial();
    calculoProduto();
    calculoServico();

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");

            $("#tabelaItensMaterial").DataTable().columns.adjust().draw(false);
            $("#tabelaItensProduto").DataTable().columns.adjust().draw(false);
            $("#tabelaItensServico").DataTable().columns.adjust().draw(false);
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "geral") {
                    if (!$("#multiCollapseExample1").hasClass("show"));
                    $("#multiCollapseExample1").collapse("show");
                } else if (Element.node.id == "DadosEntregaAba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Observacoes").collapse("show");
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "ObservacoesAba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "Totais") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                } else if (Element.node.id == "Itens") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Material").collapse("show");
                        $("#ItensMaterial").collapse("show");
                    }
                } else if (Element.node.id == "produto") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Produto").collapse("show");
                        $("#itensProduto").collapse("show");
                    }
                } else if (Element.node.id == "servico") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#Servico").collapse("show");
                        $("#itensServico").collapse("show");
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "documento-tab" ||
                    Element.node.id == "documentoaba"
                ) {
                    if (!$("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == 'VoltarGeral') {
                    $('#VoltarGeral').trigger('click');
                } else if (Element.node.id == "voltarItens") {
                    $('#voltarItens').trigger('click');
                }
            },
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    if (pegaChave('#txtFornecedor') == '') {
                        insereValor('#txtFornecedor', ' ', ' ')
                    };

                    $('#avancar1').trigger('click');
                } else if ((Element.node.id == 'avancarItens')) {
                    if (($('#tabelaItensMaterial').DataTable().rows().count() == 0) &&
                        ($('#tabelaItensProduto').DataTable().rows().count() == 0) &&
                        ($('#tabelaItensServico').DataTable().rows().count() == 0)) {
                        insereValor('#txtServico', ' ', ' ');
                        insereValor('#txtQtdeServico', '1');
                        insereValor('#txtPrecoServico', '1');
                        $('#btnAdicionarServico').trigger('click');
                    };
                    $('#avancarItens').trigger('click');
                }

            },
        });

        driver.defineSteps([{
            element: "#geral-tab",
            popover: {
                title: "Aba Geral",
                description: "Clique aqui para abrir a aba geral.",
                position: "top",
            },
        },
        {
            element: "#geral",
            popover: {
                title: "Cadastro Geral",
                description: "Aqui você pode informar os dados gerais de cadastro da ordem de compra.",
                position: "bottom",
            },
        },
        {
            element: "#multiCollapseExample1",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados gerais de cadastro.",
                position: "top",
            },
        },
        {
            element: "#txtFornecedor",
            popover: {
                title: "Campo Fornecedor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDataEntrega",
            popover: {
                title: "Campo Entrega",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtSolicitacao",
            popover: {
                title: "Campo Solicitação",
                description: "Informando uma solicitação, ao sair do campo irá importar os dados da solicitação. Contém a opção da tecla F8 para abrir modal e buscar os dados da solicitação para ser importado.",
                position: "top",
            },
        },
        {
            element: "#DadosEntregaAba",
            popover: {
                title: "Dados de Entrega",
                description: "Aqui ficam os dados de entrega.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample2",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados de entrega.",
                position: "top",
            },
        },
        {
            element: "#ObservacoesAba",
            popover: {
                title: "Observações",
                description: "Aqui ficam as observações.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample3",
            popover: {
                title: "Observações",
                description: "Esses são os campos que você informará as observações.",
                position: "top",
            },
        },
        {
            element: "#Totais",
            popover: {
                title: "Totalizadores",
                description: "Aqui fica os totalizadores.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample4",
            popover: {
                title: "Totalizadores",
                description: "Esses são os Totais.",
                position: "top",
            },
        },
        {
            element: "#voltarAcesso",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Acesso.",
                position: "top",
            },
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para avançar para a aba Itens.',
                position: 'left'
            }
        },
        {
            element: "#VoltarGeral",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Geral.",
                position: "top",
            },
        },
        {
            element: "#Itens",
            popover: {
                title: "Itens",
                description: "Clique aqui para abrir os itens.",
                position: "top",
            },
        },
        {
            element: "#MaterialAba",
            popover: {
                title: "Material (Quantidade de registros)",
                description: "Clique aqui para abrir os materiais.",
                position: "top",
            },
        },
        {
            element: "#ItensMaterial",
            popover: {
                title: "Campos Material",
                description: "Aqui você pode informar os dados dos materiais.",
                position: "top",
            },
        },
        {
            element: "#txtMaterial",
            popover: {
                title: "Campo Material",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDepositoMaterial",
            popover: {
                title: "Campo Depósito",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtCorMaterial",
            popover: {
                title: "Campo Cor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeMaterial",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtPrecoMaterial",
            popover: {
                title: "Campo Preço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarMaterial",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensMaterial_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os materiais da ordem de compra.',
                position: 'top'
            }
        },
        {
            element: "#produto",
            popover: {
                title: "Produto (Quantidade de registros)",
                description: "Clique aqui para abrir os produtos.",
                position: "top",
            },
        },
        {
            element: "#itensProduto",
            popover: {
                title: "Campos Produto",
                description: "Aqui você pode informar os dados dos produtos.",
                position: "top",
            },
        },
        {
            element: "#txtProduto",
            popover: {
                title: "Campo Produto",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtDepositoProduto",
            popover: {
                title: "Campo Depósito",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtCorProduto",
            popover: {
                title: "Campo Cor",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtTamProduto",
            popover: {
                title: "Campo Tamanho",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeProduto",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtPrecoProduto",
            popover: {
                title: "Campo Preço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnGradeProduto",
            popover: {
                title: "Botão Grade",
                description: "Clique aqui para adicionar o produto pela grade. Necessário informar o campo depósito.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarProduto",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensProduto_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os produtos da ordem de compra.',
                position: 'top'
            }
        },
        {
            element: "#servico",
            popover: {
                title: "Serviço (Quantidade de registros)",
                description: "Clique aqui para abrir os serviços.",
                position: "top",
            },
        },
        {
            element: "#itensServico",
            popover: {
                title: "Campos Serviço",
                description: "Aqui você pode informar os dados dos serviços.",
                position: "top",
            },
        },
        {
            element: "#txtServico",
            popover: {
                title: "Campo Serviço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtQtdeServico",
            popover: {
                title: "Campo Qtde",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtPrecoServico",
            popover: {
                title: "Campo Preço",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#btnAdicionarServico",
            popover: {
                title: "Botão Adicionar",
                description: "Clique aqui para para adicionar.",
                position: "top",
            },
        },
        {
            element: '#tabelaItensServico_wrapper',
            popover: {
                title: 'Itens',
                description: 'Aqui estão os serviços da ordem de compra.',
                position: 'top'
            }
        },
        {
            element: "#avancarItens",
            popover: {
                title: "Botão Avançar",
                description: "Clique aqui para avançar para a aba Pagamento.",
                position: "left",
            },
        },
        {
            element: "#voltarItens",
            popover: {
                title: "Botão Voltar",
                description: "Clique aqui para voltar para a aba Itens.",
                position: "top",
            },
        },
        {
            element: '#tourFinanceiro',
            popover: {
                title: 'Pagamento',
                description: 'Aqui estão os dados de pagamento.',
                position: 'top'
            }
        },
        {
            element: "#btnGravar",
            popover: {
                title: "Botão Gravar",
                description: "Ao clicar nesse botão você grava os dados inseridos.",
                position: "left",
            },
        },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });
});