$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          $('#avancar1').trigger('click');
        };
        if ((Element.node.id == 'avancar2')) {
          $('#avancar2').trigger('click');
        };
        if ((Element.node.id == 'avancar3')) {
          $('#avancar3').trigger('click');
        };
      }
    });

    driver.defineSteps([{
      element: '#formcard1',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtPeriodo',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtNumeroOrdem',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtCliente',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtFaccao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#formcard2',
      popover: {
        title: 'Itens da OF',
        description: 'Aqui estão os itens e baixas da OF.',
        position: 'top'
      }
    },
    {
      element: '#txtProduto',
      popover: {
        title: 'Campo Produto',
        description: 'Ao sair deste campo monta a grade do Produto.',
        position: 'top'
      }
    },
    {
      element: '#voltar2',
      popover: {
        title: 'Botão para Voltar',
        description: 'Clique aqui para voltar a página anterior.',
        position: 'top'
      }
    },
    {
      element: '#btnBaixar',
      popover: {
        title: 'Botão Baixar',
        description: 'Clique aqui para para baixar os Itens da OF.',
        position: 'top'
      }
    },
    {
      element: '#btnCancBaixas',
      popover: {
        title: 'Cancelar Baixas',
        description: 'Clique aqui para cancelar as baixas da OF.',
        position: 'top'
      }
    },
    {
      element: '#btnFinalizar',
      popover: {
        title: 'Botão Finalizar',
        description: 'Clique aqui para finalizar a OF.',
        position: 'left'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar os dados da OF.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtNumeroOrdem: {
        required: true,
      },
      txtPeriodo: {
        required: true,
      },
      txtCliente: {
        required: true,
      },
      txtFaccao: {
        required: true,
      }
    },
    messages: {
      txtNumeroOrdem: {
        required: "Informe um numero para prosseguir."
      },
      txtPeriodo: {
        required: "Informe uma período válido."
      },
      txtCliente: {
        required: "Informe um cliente válido."
      },
      txtFaccao: {
        required: "Informe uma facção válida."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }
  });

  $('#account').css('cursor', 'pointer');
  $('#payment').css('cursor', 'pointer');

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let ordemproducao = parametros[parametros.length - 1];

  CriaPesquisasTela();

  $('#account').on('click', function () {
    if (ordemproducao != 'create') {
      if (contaFs == 2) {
        $('#voltar').trigger('click');
      } else
        if (contaFs == 2) {
          $('#voltar2').trigger('click');
        }
    }
  });

  $('#payment').on('click', function () {
    if (ordemproducao != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      } else
        if (contaFs == 2) {
          $('#voltar2').trigger('click');
        }
    }
  });

  $("#txtSituacao").change(function () {
    HabilitarDesabilitarCampo();
  });

  $('#btn-limpa-Periodo').on('click', function () {
    $('#txtPeriodo').val('');
  });

  $('#btn-limpa-Produto').on('click', function () {
    $('#txtProduto').val('');
  });

  $('#btn-limpa-Cliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btn-limpa-Faccao').on('click', function () {
    $('#txtFaccao').val('');
  });

  $('#btn-limpa-Setor').on('click', function () {
    $('#txtSetor').val('');
  });

  $('#btn-limpa-Parte').on('click', function () {
    $('#txtParte').val('');
  });

  $('#btn-limpa-Ordem').on('click', function () {
    $('#txtNumeroOrdem').val('');
  });

  $('#btn-limpa-Funcionario').on('click', function () {
    $('#txtFuncionarioBaixa').val('');
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro("ORDEMPRODUCAO", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/ordemproducao`;
  });

  $('#txtNumeroOrdem').blur(async function () {
    if ((ordemproducao == 'create') && ($('#txtNumeroOrdem').val() == '')) {
      const tabela = $('#txtSituacao').val() == 'Normal' ? 'FACCAO' : 'FACCAOR';
      const proximoNumero = await RetornaProximo(tabela, tabela, 'NUMERO', 6);
      insereValor("#txtNumeroOrdem", proximoNumero, proximoNumero);
      AjustaBotoesInclusao(true);
    } else if ($('#txtNumeroOrdem').val() != '') {
      await ReabrirFinalizarOF(pegaChave('#txtNumeroOrdem'));
    };
  });

  $("#txtProduto").blur(async function () {
    if ($("#txtProduto").val() != '') {
      try {
        $.LoadingOverlay('show');
        await ExplodeGradeProduto();
        await BuscaQuantidadeProdutoBaixado();
        await buscaQuantidadeProduto();
        await buscaQuantidadesBaixadas();
      }
      finally {
        $.LoadingOverlay('hide');
      }
    };
  });

  $("#txtProduto").on("keydown", async function (event) {
    if ((event.key == "Enter")) {
      $('#txtProduto').trigger('blur');
    }
  });

  let contaFs = 1;
  $("#account").on("click", function () {
    if (ordemproducao != "create") {
      if (contaFs == 2) {
        $("#voltar").trigger("click");
      }
      if (contaFs == 3) {
        $("#voltar2").trigger("click");
      }
    }
  });

  $("#payment").on("click", function () {
    if (ordemproducao != "create") {
      if (contaFs == 2) {
        $("#avancar1").trigger("click");
      }
      if (contaFs == 3) {
        $("#voltar2").trigger("click");
      }
    }
  });

  $('#confirm').on('click', function () {
    if (ordemproducao != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancar2').trigger('click');
        $('#avancar3').trigger('click');
      }
      if (contaFs == 2) {
        $('#avancar2').trigger('click');
        $('#avancar3').trigger('click');
      }
      if (contaFs == 3) {
        $('#avancar3').trigger('click');
      }
    }
  });

  $(".next").click(function () {
    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    }
  });

  $(".previous").click(function () {
    contaFs -= 1;

    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  $("#btnGravar").click(async function () {
    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      try {
        await GravaDadosOF();
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
      }
    }
  });

  $('#avancar1').on('click', async function () {
    await buscaQuantidadeProduto();
  })

  if (ordemproducao != 'create') {
    await BuscaDadosOF(ordemproducao);
    await ReabrirFinalizarOF(ordemproducao);
  } else {
    $("#txtPrioridade").val('999');
    await setarDataAtual('txtDataSaida');
    await setarDataAtual('txtDataRetornoFim');
    await ReabrirFinalizarOF();
  };

  async function BuscaDadosOF(Numero) {
    try {
      $.LoadingOverlay('show');
      try {

        const params = {
          tabela: 'FACCAO',
          camposSelect: ["CODCLI,CLIENTE,NUMERO,CODIGO,DESCRICAO,COR,TAM,PARTE,OP,FLUXO,DT_S,DT_R,QT_ORIG,PRECO,PESOL,OBS,PERIODO,MOV,PEDIDO"],
          where: [`FACCAO.NUMERO = '${Numero}'`]
        };

        const response = await retornaJsonPesquisaPadrao(JSON.stringify(params));

        if (!response) {
          return;
        }

        let jsonStr = response[0];
        insereValor("#txtNumeroOrdem", Numero, Numero);
        if (jsonStr.CODCLI != '') {
          const DescricaoFaccao = await BuscaDescricao("entidade", "nome", "codcli", jsonStr.CODCLI);
          insereValor("#txtFaccao", jsonStr.CODCLI, DescricaoFaccao.NOME);
        }
        if (jsonStr.CODIGO != '') {
          const DescricaoProduto = await BuscaDescricao("produto", "descricao", "codigo", jsonStr.CODIGO);
          insereValor("#txtProduto", jsonStr.CODIGO, DescricaoProduto.DESCRICAO);
          if ($('#txtProduto').val() != '') {
            $('#txtProduto').trigger('blur');
          }
        }

        if (jsonStr.CLIENTE != '') {
          const DescricaoCliente = await BuscaDescricao("entidade", "nome", "codcli", jsonStr.CLIENTE);
          insereValor("#txtCliente", jsonStr.CLIENTE, DescricaoCliente.NOME);
        }

        if (jsonStr.PERIODO != '') {
          const DescricaoPeriodo = await BuscaDescricao("tabprz", "descricao", "prazo", jsonStr.PERIODO);
          insereValor("#txtPeriodo", jsonStr.PERIODO, DescricaoPeriodo.DESCRICAO);
        }

        if (jsonStr.PARTE != '') {
          const DescricaoParte = await BuscaDescricao("tipo_apl", "descricao", "codigo", jsonStr.PARTE);
          insereValor("#txtParte", jsonStr.PARTE, DescricaoParte.DESCRICAO);
        }

        if (jsonStr.OP != '') {
          const DescricaoOP = await BuscaDescricao("cadfluxo", "descricao", "codigo", jsonStr.OP);
          insereValor("#txtSetor", jsonStr.OP, DescricaoOP.DESCRICAO);
        }
        $("#txtObs").val(jsonStr.OBS);
        $("#txtDataSaida").val(jsonStr.DT_S.split(' ')[0]);
        $("#txtDataRetornoFim").val(jsonStr.DT_R.split(' ')[0]);
        $("#txtPrioridade").val(jsonStr.MOV);
        $('#txtPedido').val(jsonStr.PEDIDO);
        parseFloat($('#txtPreco').val(jsonStr.PRECO));
        parseFloat($('#txtPeso').val(jsonStr.PESOL));

        if (await VerificaQuantidadeBaixada(Numero) > 0) {
          BloqueiaCamposParaAlteracao();
          await AjustaBotoesInclusao(false);
        };

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados`);
      }
    } finally {
      $.LoadingOverlay('hide');
    };
  }

  async function BuscaDescricao(Tabela, CampoBusca, CampoWhere, Codigo) {
    const dadosSelect = {
      tabela: `${Tabela}`,
      camposSelect: [`${CampoBusca}`],
      where: [`${CampoWhere} = '${Codigo}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    let Descricao = retornoSelect[0];
    return Descricao;
  };

  function HabilitarDesabilitarCampo() {
    if ($("#txtSituacao").val() == 'Normal') {
      $("#txtReprocesso").prop("disabled", true);
      // $("#ColunaOrdem").removeClass("col-5");
      // $("#ColunaOrdem").addClass("col-10");
    } else {
      $("#txtReprocesso").prop("disabled", false);
    }
  };

  function CriaPesquisasTela() {
    $('#txtPeriodo').autocompleta(1, `JSON={ "tabela": "tabprz", "camposSelect": ["prazo chave", "descricao descricao"], "where": null }`);
    $('#txtProduto').autocompleta(1, `JSON={ "tabela": "produto", "camposSelect": ["codigo chave", "descricao descricao"], "where": null }`);
    $('#txtCliente').autocompleta(1, `JSON={ "tabela": "entidade", "camposSelect": ["codcli chave", "nome descricao"], "where": null }`);
    $('#txtFaccao').autocompleta(1, `JSON={ "tabela": "entidade", "camposSelect": ["codcli chave", "nome descricao"], "where": null }`);
    $('#txtSetor').autocompleta(1, `JSON={ "tabela": "cadfluxo", "camposSelect": ["codigo chave", "descricao descricao"], "where": null }`);
    $('#txtParte').autocompleta(1, `JSON={ "tabela": "tipo_apl", "camposSelect": ["codigo chave", "descricao descricao"], "where": null }`);
    $('#txtFuncionarioBaixa').autocompleta(1, `JSON={ "tabela": "pessoal", "camposSelect": ["codigo chave", "nome descricao"], "where": null }`);
    // $('#btn-Periodo').pesquisa('#txtPeriodo', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "tabprz", "camposSelect": ["prazo", "descricao"] }`, 'Pesquisa Prazo', 'tabprz');
    // $('#btn-Produto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "produto", "camposSelect": ["codigo", "descricao"] }`, 'Pesquisa Produto', 'produto');
    // $('#btn-Cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "entidade", "camposSelect": ["codcli", "nome"] }`, 'Pesquisa Entidade', 'entidade');
    // $('#btn-Faccao').pesquisa('#txtFaccao', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "entidade", "camposSelect": ["codcli", "nome"] }`, 'Pesquisa Entidade', 'entidade');
    // $('#btn-Setor').pesquisa('#txtSetor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "cadfluxo", "camposSelect": ["codigo", "descricao"] }`, 'Pesquisa Fluxo', 'cadfluxo');
    // $('#btn-Parte').pesquisa('#txtParte', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "tipo_apl", "camposSelect": ["codigo", "descricao"] }`, 'Pesquisa Parte', 'tipo_apl');
    // $('#btn-Funcionario').pesquisa('#txtFuncionarioBaixa', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "pessoal", "camposSelect": ["codigo", "nome"] }`, 'Pesquisa Funcionario', 'funcionario');
    $('#btn-Periodo').pesquisa_serverside(['#txtPeriodo'], ['PRAZO'], ['DESCRICAO'], '{"tabela":"tabprz", "camposSelect":[ "PRAZO", "DESCRICAO"], "where": null}', 'Pesquisa Prazo');
    $('#btn-Produto').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO', 'CODIGO2'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Produto');
    $('#btn-Cliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Entidade');
    $('#btn-Faccao').pesquisa_serverside(['#txtFaccao'], ['CODCLI'], ['NOME'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Entidade');
    $('#btn-Setor').pesquisa_serverside(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"cadfluxo", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Setor');
    $('#btn-Parte').pesquisa_serverside(['#txtParte'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"tipo_apl", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Parte');
    $('#btn-Funcionario').pesquisa_serverside(['#txtFuncionarioBaixa'], ['CODIGO'], ['NOME'], '{"tabela":"pessoal", "camposSelect":[ "CODIGO", "NOME"], "where": null}', 'Pesquisa Funcionário');
  }

  async function ExplodeGradeProduto() {
    const codigo = pegaChave('#txtProduto');

    if (codigo == '') {
      return;
    };

    if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
      $('#tabelaGradeProduto').DataTable().destroy();
      $('#tabelaGradeProduto').empty();
    };

    let codigoGravado = await buscaValor('FACCAO', 'CODIGO', 'NUMERO', ordemproducao);

    if (codigoGravado != undefined) {
      codigoGravado = codigoGravado.CODIGO;
    }

    const SQLAuxiliar = {
      tabela: "FACCAO",
      camposSelect: ["CODIGO", "COR", "TAM", "QT_ORIG QUANTIDADE"],
      where: [`NUMERO= '${pegaChave("#txtNumeroOrdem")}'`]
    };

    const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}&SQLAUXILIAR=${JSON.stringify(SQLAuxiliar)}`, null);
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
    }

    for (let i = 0; i < parseInt(jsonStr.length); i++) {
      const colunas = Object.keys(jsonStr[i]);
      const tamanhos = [];
      colunas.forEach((coluna) => {
        if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
          tamanhos.push(coluna);
        }
      });

      const jsonObject = jsonStr.map(obj => {
        const newObject = { ...obj };
        delete newObject.CODIGO;
        delete newObject.POSICAO;
        Object.keys(obj).forEach(key => {
          if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(key)) {
            newObject[key] = `<input type="number" class="input-default focus form-control camposGrade" id="${newObject.COR + key}" value="${codigoGravado == obj['CODIGO'] ? obj[key] : ''}">`;
            newObject[key.split('HIFEN')[1]] = `<input type="number" class="input-default focus form-control camposGrade" style="min-width: 70px" id="${newObject.COR + key}" value="${codigoGravado == obj['CODIGO'] ? obj[key] : ''}">`;
            delete newObject[key];
          }
        });
        return { ...newObject };
      });

      if (i == 0) {
        const titulosFixos = ['COR', 'DESC_COR'];
        const titulosGeral = [...titulosFixos, ...tamanhos];
        const titulos = titulosGeral.map(titulo => {
          const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
          const objeto = { title: coluna, data: coluna };
          return objeto;
        });

        $("#tabelaGradeProduto").DataTable({
          destroy: true,
          filter: false,
          paging: false,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          columns: titulos,
          data: jsonObject
        });
      }
    }
  };

  async function buscaQuantidadeProduto() {

    const PesquisaQtdeProduto = {
      tabela: "FACCAO",
      camposSelect: ["DISTINCT FACCAO.NUMERO", "FACCAO.CODIGO", "FACCAO.COR", "FACCAO.TAM", "FACCAO.QT_ORIG QUANTIDADE", "FAIXA_ITEN.POSICAO", "PRODUTO.FAIXA"],
      innerJoin: [
        { "tabela": "PRODUTO", "condicao": "FACCAO.CODIGO = PRODUTO.CODIGO" },
        { "tabela": "FAIXA_ITEN", "condicao": "FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND FACCAO.TAM = FAIXA_ITEN.TAMANHO" }
      ],
      where: [`FACCAO.NUMERO= '${pegaChave("#txtNumeroOrdem")}'`]
    };

    const jsonStrPesquisaQtde = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaQtdeProduto));

    if (!jsonStrPesquisaQtde) {
      msgErro('Erro ao trazer as quantidades!');
      return;
    }

    for (i = 0; i < jsonStrPesquisaQtde.length; i++) {
      const id = jsonStrPesquisaQtde[i].COR + jsonStrPesquisaQtde[i].POSICAO + 'HIFEN' + jsonStrPesquisaQtde[i].TAM;
      $(`#${id}`).val(`${jsonStrPesquisaQtde[i].QUANTIDADE}`);
    };
  };

  async function BuscaQuantidadeProdutoBaixado() {
    const codigo = pegaChave('#txtProduto');

    if (codigo == '') {
      return;
    };

    if ($.fn.DataTable.isDataTable('#tabelaQuantidadeBaixada')) {
      $('#tabelaQuantidadeBaixada').DataTable().destroy();
      $('#tabelaQuantidadeBaixada').empty();
    };

    const SQLAuxiliar = {
      tabela: "FACCAO3",
      camposSelect: ["CODIGO", "COR", "TAM", "SUM(QUANT + QUANT_2 + QUANT_I) QUANTIDADE"],
      where: [`NUMERO= '${pegaChave("#txtNumeroOrdem")}'`],
      GroupBy: ['codigo, cor, tam']
    };

    const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}&SQLAUXILIAR=${encodeURIComponent(JSON.stringify(SQLAuxiliar))}`, null);

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
    }

    for (let i = 0; i < parseInt(jsonStr.length); i++) {
      const colunas = Object.keys(jsonStr[i]);
      const tamanhos = [];
      colunas.forEach((coluna) => {
        if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
          tamanhos.push(coluna);
        }
      });

      const jsonObject = jsonStr.map(obj => {
        const newObject = { ...obj };
        delete newObject.CODIGO;
        delete newObject.POSICAO;
        Object.keys(obj).forEach(key => {
          if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(key)) {
            newObject[key] = jsonStr[i][key];
            if (jsonStr[i][key] != null) {
              newObject[key.split('HIFEN')[1]] = `<input type="number" id="${key.split('HIFEN')[1]}tam-baixado" class="input-default focus form-control camposGradeBaixada" style="min-width: 70px" value="${obj[key]}">`;
            } else {
              newObject[key.split('HIFEN')[1]] = `<input type="number" id="${key.split('HIFEN')[1]}tam-baixado"class="input-default focus form-control camposGradeBaixada" style="min-width: 70px" value="0">`;
            }
            delete newObject[key];
          }
        });
        return { ...newObject };
      });

      if (i == 0) {
        const titulosFixos = ['COR', 'DESC_COR'];
        const titulosGeral = [...titulosFixos, ...tamanhos];
        const titulos = titulosGeral.map(titulo => {
          const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
          const objeto = { title: coluna, data: coluna };
          return objeto;
        });

        $("#tabelaQuantidadeBaixada").DataTable({
          bPaginate: false,
          order: false,
          sort: false,
          autoWidth: true,
          searching: false,
          destroy: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          columns: titulos,
          data: jsonObject
        });
      }
    }
  }

  async function buscaQuantidadesBaixadas() {
    try {
      $.LoadingOverlay('show');
      const PesquisaQtdeBaixada = {
        tabela: "FACCAO3",
        camposSelect: ["CODIGO", "COR", "TAM", "SUM(QT_ORIG - (QUANT + QUANT_2 + QUANT_I)) AS QTDE_BAIXADA"],
        where: [`NUMERO= '${pegaChave("#txtNumeroOrdem")}'`],
        GroupBy: ['CODIGO, COR, TAM']
      };
      const jsonStr = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(PesquisaQtdeBaixada)));
      const inputsQtdeBaixada = $('.camposGradeBaixada');
      for (i = 0; i < inputsQtdeBaixada.length; i++) {
        const id = inputsQtdeBaixada[i].id;
        const registro = jsonStr.findIndex(index => index.TAM == id.replace('tam-baixado', ''));
        $(`#${id}`).val(jsonStr[registro].QTDE_BAIXADA)
      }
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as quantidades baixadas! Por favor, tente novamente.')
      return;
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function GravaDadosOF() {
    let grade = [];
    const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
    listaDados.forEach(dado => {
      const objeto = Object.entries(dado);
      const colunas = objeto.map(prop => prop[0]);

      for (let i = 0; i < colunas.length; i++) {
        if (!['COR', 'DESC_COR'].includes(colunas[i])) {
          const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
          const idFormatado = idSemFormatacao.split("value=")[0];
          const retorno = {
            COR: dado.COR,
            TAMANHO: colunas[i],
            QUANTIDADE: parseFloat($(`#${idFormatado}`).val())
          };
          grade.push(retorno);
        }
      }
    });

    $.LoadingOverlay("show");
    const tabelaGravaDados = $("#txtSituacao").val() == 'Normal' ? 'FACCAO' : 'FACCAOR';
    const dadosParaGravacao = {
      CODCLI: pegaChave("#txtFaccao"),
      CLIENTE: pegaChave("#txtCliente"),
      NUMERO: pegaChave("#txtNumeroOrdem"),
      CODIGO: pegaChave("#txtProduto"),
      DESCRICAO: pegaDescricao("#txtProduto"),
      PARTE: pegaChave("#txtParte"),
      OP: pegaChave("#txtSetor"),
      FLUXO: pegaChave("#txtSetor"),
      DT_S: `${$("#txtDataSaida").val()}T00:00:00Z`,
      DT_R: `${$("#txtDataRetornoFim").val()}T00:00:00Z`,
      QUANT: 0,
      QUANT_I: 0,
      QUANT_F: 0,
      PRECO: parseFloat($("#txtPreco").val().replaceAll(',', '.')),
      PESOL: $("#txtPeso").val(),
      OBS: $("#txtObs").val(),
      TELA: 'F',
      PERIODO: pegaChave("#txtPeriodo"),
      MOV: $("#txtPrioridade").val(),
      PEDIDO: $('#txtPedido').val(),
      ITENS: grade
    };

    let response = await requisicao(
      "POST",
      "/sisplan/cadastros/v1/cadordemproducao?",
      `tabela=${tabelaGravaDados}`,
      `${JSON.stringify(dadosParaGravacao)}`,
      null
    );

    if (!response) {
      $.LoadingOverlay("hide");
      return;
    }

    $.LoadingOverlay("hide");
    toastr
      .success(
        `Cadastro efetuado com sucesso!`,
        "Confirmação",
        {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/ordemproducao`;
          },
        }
      )
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  async function VerificaQuantidadeBaixada(Numero) {
    const dadosSelect = {
      tabela: 'FACCAO3',
      camposSelect: ['SUM(QUANT) QUANT'],
      where: [`NUMERO = '${Numero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    let quantidade = retornoSelect[0].QUANT;
    return quantidade;
  };

  async function BloqueiaCamposParaAlteracao() {
    $("#txtNumeroOrdem").attr("readonly", true);
    $("#txtPeriodo").attr("readonly", true);
    $("#txtPrioridade").attr("readonly", true);
    $("#txtSituacao").attr("disabled", true);
    $("#txtCliente").attr("readonly", true);
    $("#txtFaccao").attr("readonly", true);
    $("#txtSetor").attr("readonly", true);
    $("#txtParte").attr("readonly", true);
    $("#txtPreco").attr("readonly", true);
    $("#txtDataSaida").attr("readonly", true);
    $("#txtPeso").attr("readonly", true);
    $("#txtDataRetornoFim").attr("readonly", true);
    $("#txtObs").attr("readonly", true);
    $("#txtPerda").attr("readonly", true);
    $("#txtProduto").attr("readonly", true);
    $("#btn-limpa-Periodo").attr("disabled", true);
    $('#btn-limpa-Produto').attr("disabled", true);
    $('#btn-limpa-Cliente').attr("disabled", true);
    $('#btn-limpa-Faccao').attr("disabled", true);
    $('#btn-limpa-Setor').attr("disabled", true);
    $('#btn-limpa-Parte').attr("disabled", true);
    $('#btn-limpa-Ordem').attr("disabled", true);
    $('#txtPeriodo').attr("disabled", true);
    $('#txtProduto').attr("disabled", true);
    $('#txtCliente').attr("disabled", true);
    $('#txtFaccao').attr("disabled", true);
    $('#txtSetor').attr("disabled", true);
    $('#txtParte').attr("disabled", true);
    $('#btn-Periodo').attr("disabled", true);
    $('#btn-Produto').attr("disabled", true);
    $('#btn-Cliente').attr("disabled", true);
    $('#btn-Faccao').attr("disabled", true);
    $('#btn-Setor').attr("disabled", true);
    $('#btn-Parte').attr("disabled", true);
    // $('#btn-Ordem').attr("disabled", true);
    $('#ItensOF').attr("disabled", true);
    $(`.camposGrade`).attr("readonly", true);
    $(`.camposGradeBaixada`).attr("readonly", true);
    $('#txtPedido').attr('disabled', true);
  };

  async function AjustaBotoesInclusao(Incluindo) {
    if (Incluindo) {
      $("#btnBaixar").addClass("d-none");
      $("#btnCancBaixas").addClass("d-none");
      $("#btnFinalizar").addClass("d-none");
    } else {
      $("#btnGravar").addClass("d-none");
    }
  }

  $("#btnFinalizar").on('click', async function () {
    await FinalizarReabrirOF('N');
  });

  $("#btnReabrir").on('click', async function () {
    await FinalizarReabrirOF('S');
  });

  async function FinalizarReabrirOF(Reabrir) {
    $.LoadingOverlay("show");
    const tabelaGravaDados = $("#txtSituacao").val() == 'Normal' ? 'FACCAO' : 'FACCAOR';
    const numeroOF = pegaChave('#txtNumeroOrdem');

    let response = await requisicao(
      "PUT",
      "/sisplan/cadastros/v1/cadordemproducao?",
      `tabela=${tabelaGravaDados}&numero=${numeroOF}&reabrir=${Reabrir}`,
      '',
      null
    );

    if (!response) {
      $.LoadingOverlay("hide");
      return;
    }

    $.LoadingOverlay("hide");
    toastr
      .success(
        `OF atualizada com sucesso!`,
        "Confirmação",
        {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/ordemproducao`;
          },
        }
      )
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });

  }

  async function QuantidadeFaturadaOF(Numero) {
    const dadosSelect = {
      tabela: 'FACCAO',
      camposSelect: ['SUM(QUANT_F) QUANT'],
      where: [`NUMERO = '${Numero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return 0;
    }
    let quantidade = retornoSelect[0].QUANT;
    return quantidade;
  };

  async function ReabrirFinalizarOF(Numero) {
    if ((Numero != '') && Numero != undefined) {
      const QtdeFaturada = await QuantidadeFaturadaOF(Numero);
      if (parseFloat(QtdeFaturada) > 0) {
        $("#btnFinalizar").addClass("d-none");
        $("#btnReabrir").removeClass("d-none");
        $("#btnBaixar").addClass("d-none");
        $("#btnCancBaixas").addClass("d-none");
      } else {
        $("#btnReabrir").addClass("d-none");
        $("#btnFinalizar").removeClass("d-none");
        $("#btnBaixar").removeClass("d-none");
        $("#btnCancBaixas").removeClass("d-none");
      };
    } else {
      $("#btnReabrir").addClass("d-none");
      $("#btnFinalizar").removeClass("d-none");
      $("#btnBaixar").addClass("d-none");
      $("#btnCancBaixas").addClass("d-none");
    }
  }

  // INICIO ROTINA DE BAIXAR

  $('#btnBaixar').on('click', async function () {
    await BuscaDadosParaBaixa(pegaChave('#txtNumeroOrdem'));
    await setarDataAtual('txtDataBaixa');
    $('#modal-filtros').modal('show');
  });

  async function BuscaDadosParaBaixa(numero) {
    try {
      $.LoadingOverlay('show');

      if ($.fn.DataTable.isDataTable('#tabelaBaixaProdutos')) {
        $('#tabelaBaixaProdutos').DataTable().clear().draw();
      };

      $('#tabelaBaixaProdutos').DataTable({
        destroy: true,
        filter: false,
        paging: false,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "autoWidth": true
      });

      const dadosSelect = {
        Tabela: 'faccao',
        CamposSelect: ["faccao.cor, cadcor.descricao desc_cor,faccao.tam, faccao.qt_orig, faccao.quant_2, faccao.quant_i, faccao.identificador, sum(faccao.qt_orig - (faccao.quant + faccao.quant_2 + faccao.quant_i)) qtde_baixa, sum(faccao.quant + faccao.quant_2 + faccao.quant_i) baixado, faixa_iten.posicao"],
        Where: [`faccao.numero = '${numero}'`],
        LeftJoin: [{ "tabela": "produto", "condicao": "produto.codigo = faccao.codigo" },
        { "tabela": "faixa_iten", "condicao": "faixa_iten.faixa = produto.faixa and faccao.tam = faixa_iten.tamanho" },
        { "tabela": "cadcor", "condicao": "cadcor.cor = faccao.cor" }],
        GroupBy: ['faccao.cor, faccao.tam, faccao.qt_orig, faccao.quant_2, faccao.quant_i, faccao.identificador, cadcor.descricao, faixa_iten.posicao ']
      };

      const response = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(dadosSelect)));

      if (!response) {
        return;
      }
      let jsonStr = response;
      await preencherTabelaBaixas($('#tabelaBaixaProdutos'), jsonStr);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnDesistirBaixa').on('click', async function () {
    $('#modal-filtros').modal('hide');
  });


  $('#btnBaixarQuantidadesOF').on('click', async function () {
    if ($('#txtFuncionarioBaixa').val() != '') {
      await GravaDadosFaccao3($('#tabelaBaixaProdutos').DataTable().rows().data().toArray());
    } else {
      msgAlerta('Informe um funcionário para prosseguir');
    }
  });

  // FIM ROTINA DE BAIXAR

  async function preencherTabelaBaixas(tabela, data) {
    data.map(element => {
      $(tabela).DataTable().row.add([
        element.COR,
        element.DESC_COR,
        element.TAM,
        `<input type="number" class="input-default focus form-control qt_orig" value="${element.QT_ORIG}">`,
        `<input type="number" class="input-default focus form-control qtdebaixa" value="${element.QTDE_BAIXA}">`,
        `<input type="number" class="input-default focus form-control quant2" value="${element.QUANT_2}">`,
        `<input type="number" class="input-default focus form-control quant_i" value="${element.QUANT_I}">`,
        `<input type="number" class="input-default focus form-control baixado" value="${element.BAIXADO}">`,
        `<input type="number" class="input-default focus form-control peso" value="${0}">`,
        `<input type="number" class="input-default focus form-control talhado" value="${0}">`,
        `<input type="number" class="input-default focus form-control pesoEstoque" value="${0}">`,]).draw(false);
      return 'ok';
    });
    $(".tam").attr("readonly", true);
    $(".qt_orig").attr("readonly", true);
    $(".baixado").attr("readonly", true);
  }

  async function GravaDadosFaccao3(tabela) {
    const grade = tabela.map((dados, index) => {
      const retorno = {
        COR: dados[0],
        TAM: dados[2],
        QT_ORIG: +($($('.qt_orig')[index]).val()),
        QUANT: +($($('.qtdebaixa')[index]).val()),
        QUANT_I: +($($('.quant_i')[index]).val()),
        QUANT_F: +(0),
        QUANT2: +($($('.quant2')[index]).val()),
        PESO: +($($('.peso')[index]).val()),
        PESO_EST: +($($('.pesoEstoque')[index]).val()),
        TALHADO: +($($('.talhado')[index]).val()),
      };
      return retorno;
    });

    $.LoadingOverlay("show");
    const tabelaGravaDados = 'FACCAO3';
    const dadosParaGravacao = {
      CODCLI: pegaChave("#txtFaccao"),
      DT_LAN: `${$("#txtDataBaixa").val()}T00:00:00Z`,
      NUMERO: pegaChave("#txtNumeroOrdem"),
      OP: pegaChave("#txtSetor"),
      PAGO: 'N',
      CODIGO: pegaChave("#txtProduto"),
      PARTE: pegaChave("#txtParte"),
      NOTA: '',
      ESTOQUE: 'N',
      QUAL: '',
      DEPOSITO: '',
      ATIVA_DESC: 'N',
      VALOR: 0,
      UNITARIO: 0,
      CODCLI_ANT: pegaChave('#txtFuncionarioBaixa'),
      ITENS: grade
    };

    let response = await requisicao(
      "POST",
      "/sisplan/cadastros/v1/cadordemproducaofaccao3?",
      `tabela=${tabelaGravaDados}`,
      `${JSON.stringify(dadosParaGravacao)}`,
      null
    );

    if (!response) {
      $.LoadingOverlay("hide");
      return;
    }

    $.LoadingOverlay("hide");
    toastr
      .success(
        `Cadastro efetuado com sucesso!`,
        "Confirmação",
        {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/ordemproducao`;
          },
        }
      )
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  $('#btnCancBaixas').on('click', async function () {
    msgAlerta('Deseja realmente cancelar todas as baixas?', cancelarFaccao);
  });

  async function cancelarFaccao() {
    try {
      $.LoadingOverlay('show');
      const numero = pegaChave('#txtNumeroOrdem');
      let response = await requisicao(
        "DELETE",
        "/sisplan/cadastros/v1/cadordemproducaofaccao3?",
        `numero=${numero}`,
        null
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      location.reload();

    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnZeraQtdeBaixa').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const inputs = $('.qtdebaixa');
      for (let i = 0; i < inputs.length; i++) {
        const input = inputs[i];
        input.value = '0';
      };
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível zerar as quantidades do campo "Qtde Baixa"! Por favor, tente novamente.');
      return;
    } finally {
      $.LoadingOverlay('hide');
    }
  });

});