$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaOrdemProducao",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir uma nova ordem de produção.",
          position: "right",
        },
      },
      {
        element: "#tabelaOs",
        popover: {
          title: "Tabela Ordem de Produção Simples",
          description: "Aqui estão os dados das ordens de produção cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("ORDEM_SERVICO");

  $('#txtOs').autocompleta(1, `JSON={ "tabela":"OS", "camposSelect":[ "OS.NUMERO chave", "ENTIDADE.NOME descricao"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}], "where": null}`);
  $('#btn-Os').pesquisa('#txtOs', 'NUMERO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OS", "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}]}`, 'Pesquisa OS', 'OS');

  $('#btn-limpa-Os').on('click', function () {
    $('#txtOs').val('');
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtOs').val('');
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnNovaOrdemProducao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "ordemservico/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  await consultaOs();

  async function consultaOs() {
    try {
      $.LoadingOverlay("show");
      let sWhere = ' ';
      sWhere += (pegaChave('#txtOs') == '' ? '' : ` AND OS.NUMERO = '${pegaChave('#txtOs')}'`);
      const params = `{"tabela":"OS", "camposSelect":[ "OS.NUMERO", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = OS.CLIENTE"}],"where": ["1=1 ${sWhere}"], "orderBy": ["OS.NUMERO DESC"]}`;

      const jsonStr = await retornaJsonPesquisaPadrao(params);

      $('#tabelaOs').DataTable({
        destroy: true,
        ordering: false,
        lengthChange: false,
        serverside: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "autoWidth": true,
        "data": jsonStr,
        "columns": [{ "data": "NUMERO" }, { "data": "NOME" }],
        "columnDefs": [{
          targets: [0], render: function (data, type, row) {
            return retornaBotaoOpcoes(data);
          }
        }]
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }

  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '</div>';
    return retorno;
  };

  $('#tabelaOs').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOs').DataTable().row($(this).parents('tr')).data();
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `ordemservico/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaOs').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaOs').DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro('NUMERO', data.NUMERO);
      if (registroLiberado) {
        window.location.href = `ordemservico/${data.NUMERO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaOs();
  });

});