$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'DadosGerais') {
          if (!$('#CollapseDados').hasClass('show')) {
            $('#DadosGerais').collapse('show');
          }
        }
        if (Element.node.id == 'observacao') {
          if (!$('#CollapseDados').hasClass('show')) {
            $('#observacao').collapse('show');
          }
        }
      }
    });
    driver.defineSteps([
      {
        element: '#DadosGerais',
        popover: {
          title: 'Informar dados gerais',
          description: 'Aqui estão os campos disponíveis para o cadastro.',
          position: 'top'
        }
      },
      {
        element: '#NotaFiscalInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'bottom'
        }
      },
      {
        element: '#FornecedorInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#ValorInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtClasse',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#BancoInfoTour',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtConta',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#txtSituacao',
        popover: {
          title: 'Campos Obrigatórios',
          description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
          position: 'top'
        }
      },
      {
        element: '#observacao',
        popover: {
          title: 'Aba de Observação',
          description: 'Aqui é informado a observação da Conta a Pagar.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  // autocompleta

  $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
  $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
  $('#txtConta').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

  $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
  $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
  $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
  $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
  $('#btn-Conta').pesquisa('#txtConta', 'CONTA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CONTA", "DESCRICAO"]}`, 'Pesquisa Conta', 'CADCONTA');

  $('#btn-limpa-Classe').on('click', function () {
    $('#txtClasse').val('');
  });
  $('#btn-limpa-Fornecedor').on('click', function () {
    $('#txtFornecedor').val('');
  });
  $('#btn-limpa-Situacao').on('click', function () {
    $('#txtSituacao').val('');
  });
  $('#btn-limpa-Banco').on('click', function () {
    $('#txtBanco').val('');
  });
  $('#btn-limpa-Conta').on('click', function () {
    $('#txtConta').val('');
  });

  let queryString = window.location.href;
  let achaPagar = queryString.indexOf('pagar/') + 6; // + 6 porque é a soma do "pagar/""
  let pagar = queryString.substr(achaPagar, queryString.length);

  $('#txtNotaFiscal').on('blur', async function () {
    if ($(this).val() == '') {
      $(this).val(await RetornaProximo('PAGTO', 'PAGTO', 'DOCTO', 6));
    }
  });

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('PAGAR', getCookie('usuario'), pagar);
    window.location.href = `${BASE_URI}/pagar`;
  });

  if (pagar != 'create') {
    pagar = atob(pagar);
  }

  $('#txtFornecedor').on('blur', async function () {
    if ($(this).val() != '') {
      let sCodCli = pegaChave('#txtFornecedor');
      await verificaCliente(sCodCli);
    }
  });

  async function verificaCliente(codcli) {
    if (codcli == '') {
      return;
    }
    try {
      let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["ativo", "bloqueio"],"where": ["codcli = '${codcli}'"]}`, null);

      if (!response) {
        return;
      }

      let jsonEntidade = await response.json();
      if (response.status != 200) {
        msgErro(jsonEntidade.RESULT[0].mensagem);
        return;
      }
      if (jsonEntidade.RESULT[0][0].BLOQUEIO == 'S') {
        msgAlerta('Fornecedor bloqueado, impossível continuar.');
        $('#txtFornecedor').val('');
      } else if (jsonEntidade.RESULT[0][0].ATIVO == 'N') {
        msgAlerta('Fornecedor inativo, impossível continuar.');
        $('#txtFornecedor').val('');
      }
    } catch (error) {
      console.error(error);
    }
  };

  function retornaListaPagar() {
    let arrayPagar = [];
    const fornecedor = pegaChave('#txtFornecedor');

    $('#tabelaParcelas').DataTable().rows().data().map(item => {
      let dtVencimento = item.VENCIMENTO.split('/');
      dtVencimento = dtVencimento[2] + '-' + dtVencimento[1] + '-' + dtVencimento[0];
      let dtEmissao = item.EMISSAO.split('/');
      dtEmissao = dtEmissao[2] + '-' + dtEmissao[1] + '-' + dtEmissao[0];
      arrayPagar.push({
        DOCTO: $('#txtNotaFiscal').val(),
        DUPLI: item.DUPLICATANUMERO,
        LANCAMENTO: $('#txtLancamento').val(),
        VALOR: parseFloat(item.VALOR),
        VALOR_ORIG: parseFloat(item.VALOR),
        DT_VEN: `${dtVencimento}T00:00:00Z`,
        DATA_ORIG: `${dtVencimento}T00:00:00Z`,
        DT_EMI: `${dtEmissao}T00:00:00Z`,
        STATUS: $('#txtStatus').val(),
        OBS: item.OBSERVACAO,
        EMP_ID: $('#txtEmpId').val(),
        CODCRE: fornecedor,
        SITUACAO: item.SITUACAO,
        NUM_OS: item.CLASSE,
        BANCO: item.BANCO,
        CONTA: item.CONTA,
      });
    });

    return { ListaPagar: arrayPagar };
  }

  $('#btnGerarAp').on('click', async function () {
    await geraParcelas();
  })


  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtMoeda: {
        required: true,
      },
      txtBanco: {
        required: true,
      },
      txtConta: {
        required: true,
      },
      txtSituacao: {
        required: true,
      },
      txtValor: {
        required: true,
      },
      txtFornecedor: {
        required: true,
      },
      txtNotaFiscal: {
        required: true,
      },
      txtDTemissao: {
        max: "2500-12-31",
      },
      txtDTvencimento: {
        max: "2500-12-31",
      }
    },
    messages: {
      txtMoeda: {
        required: "Informe uma Moeda."
      },
      txtBanco: {
        required: "Informe um Banco válido."
      },
      txtConta: {
        required: "Informe uma Conta."
      },
      txtValor: {
        required: "Informe o Valor do Pagamento."
      },
      txtSituacao: {
        required: "Informe alguma Situação."
      },
      txtFornecedor: {
        required: "Informe um Fornecedor."
      },
      txtNotaFiscal: {
        required: "Informe uma Nota Fiscal."
      },
      txtDTemissao: {
        max: "Data Inválida"
      },
      txtDTvencimento: {
        max: "Data Inválida"
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    },
    async submitHandler(form, event) {
      try {
        event.preventDefault();
        $.LoadingOverlay("show");
        try {
          if ((parseFloat($('#txtValor').val()) <= 0) || ($('#txtValor').val() == "0,00")) {
            msgAlerta('Valor não pode ser 0!');
            return;
          }

          if (!$('.divParcela').hasClass('d-none')) {
            await geraParcelas();
          }

          if (!$('.divParcela').hasClass('d-none')) {
            const objeto = retornaListaPagar();

            let response = await requisicao(pagar = 'POST', '/Sisplan/pagar/V1/pagarvarios?', '', `JSON=${encodeURIComponent(JSON.stringify(objeto))}`, 50000);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
              'Cadastro efetuado com sucesso!',
              'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/pagar`;
              }
            }
            ).css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px"
            });
          } else {
            let classe = $('#txtClasse').val().substring(1, $('#txtClasse').val().indexOf('] - '));
            let situacao = $('#txtSituacao').val().substring(1, $('#txtSituacao').val().indexOf('] - '));
            let fornecedor = $('#txtFornecedor').val().substring(1, $('#txtFornecedor').val().indexOf('] - '));
            let banco = $('#txtBanco').val().substring(1, $('#txtBanco').val().indexOf('] - '));
            let conta = $('#txtConta').val().substring(1, $('#txtConta').val().indexOf('] - '));

            let PagarC = {};

            PagarC.NUM_AP = $('#txtNum_ap').val();
            PagarC.DOCTO = $('#txtNotaFiscal').val();
            PagarC.DUPLI = $('#txtDupli').val();
            PagarC.LANCAMENTO = $('#txtLancamento').val();
            PagarC.VALOR = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
            PagarC.VAL_PAG = parseFloat($('#txtValorPago').val().replace('.', '').replace(',', '.'));
            PagarC.VALOR_ORIG = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
            PagarC.DT_VEN = `${$('#txtDTvencimento').val()}T00:00:00Z`;
            PagarC.DATA_ORIG = `${$('#txtDTvencimento').val()}T00:00:00Z`;
            PagarC.DT_EMI = `${$('#txtDTemissao').val()}T00:00:00Z`;
            PagarC.STATUS = $('#txtStatus').val();
            PagarC.OBS = $('#txtObs').val();
            PagarC.EMP_ID = $('#txtEmpId').val();
            PagarC.CODCRE = fornecedor;
            PagarC.SITUACAO = situacao;
            PagarC.NUM_OS = classe;
            PagarC.BANCO = banco;
            PagarC.CONTA = conta;

            let response = await requisicao(pagar = 'POST', '/Sisplan/pagar/V1/Pagar?', '', `JSON=${encodeURIComponent(JSON.stringify(PagarC))}`);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status != 200) {
              msgErro(jsonStr.RESULT[0].mensagem);
              return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
              'Cadastro efetuado com sucesso!',
              'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                deletaRegistro('PAGAR', getCookie('usuario'), PagarC.NUM_AP);
                window.location.href = `${BASE_URI}/pagar`;
              }
            }
            ).css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px"
            });
          }
        } catch (error) {
          console.error(error);
          msgErro('Não foi possível gravar os dados do Pagamento: ');
        }
      } finally {
        $.LoadingOverlay('hide');
      }
    }
  });
  if (pagar != '' && pagar != 'create') {
    $('.divParcela').addClass('d-none');
    $('#DupliInfoTour').removeClass('d-none');
    $('#divStatus').removeClass('col-md-2 col-12');
    $('#divStatus').addClass('col-md-3 col-12');

    if (await liberarRegistro('PAGAR', pagar) == false) {
      window.location.href = '../pagar';
    } else {
      try {
        let response = '';
        let jsonStr = [];
        let fornecedor = '';
        let classe = '';
        let situacao = '';
        let banco = '';
        let conta = '';

        $.LoadingOverlay("show");
        response = await requisicao('GET', '/Sisplan/pagar/V1/Pagar?', `num_ap=${pagar}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        if (jsonStr.length <= 0) {
          window.location.href = '../pagar';
        }

        let pagarJson = jsonStr;

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.CODCRE", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PAGTO.CODCRE"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            fornecedor = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          fornecedor = `[${jsonStr.RESULT[0][0].CODCRE}] - ${jsonStr.RESULT[0][0].NOME}`;
        } catch (error) {
          console.error(error);
          fornecedor = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["CLASSE_GER.CODIGO", "CLASSE_GER.DESCRICAO"], "leftJoin": [{"tabela": "CLASSE_GER", "condicao": "PAGTO.NUM_OS = CLASSE_GER.CODIGO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            classe = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          classe = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          classe = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["TABSIT.CODIGO", "TABSIT.DESCRICAO"], "leftJoin": [{"tabela": "TABSIT", "condicao": "PAGTO.SITUACAO = TABSIT.CODIGO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);

          if (!response) {
            situacao = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          situacao = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          situacao = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["CADBAN.BANCO", "CADBAN.NOME_BANCO"], "leftJoin": [{"tabela": "CADBAN", "condicao": "PAGTO.BANCO = CADBAN.BANCO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            banco = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          banco = `[${jsonStr.RESULT[0][0].BANCO}] - ${jsonStr.RESULT[0][0].NOME_BANCO}`;
        } catch (error) {
          console.error(error);
          banco = '';
        }

        try {
          response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["CADCONTA.CODIGO", "CADCONTA.DESCRICAO"], "leftJoin": [{"tabela": "CADCONTA", "condicao": "PAGTO.CONTA = CADCONTA.CODIGO"}], "where": ["PAGTO.NUM_AP = '${pagar}'"]}`, null);
          if (!response) {
            conta = '';
            return;
          }
          jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          conta = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
        } catch (error) {
          console.error(error);
          conta = '';
        }

        // desabilita os campos q nao podem ser editados
        if (pagarJson[0].VALOR === pagarJson[0].VAL_PAG) {
          $('#btn-Fornecedor').attr('disabled', 'disabled');
          $('#btn-limpa-Fornecedor').attr('disabled', 'disabled');
          $('#txtFornecedor').attr('disabled', 'disabled');
          $('#txtValor').attr('disabled', 'disabled');
          $('#txtNotaFiscal').attr('disabled', 'disabled');
          $('#txtSituacao').attr('disabled', 'disabled');
          $('#txtBanco').attr('disabled', 'disabled');
          $('#txtDTvencimento').attr('disabled', 'disabled');
          $('#txtDTemissao').attr('disabled', 'disabled');
          $('#txtConta').attr('disabled', 'disabled');
        }

        $('#txtNum_ap').val(pagarJson[0].NUM_AP);
        $('#txtLancamento').val(pagarJson[0].LANCAMENTO);
        $('#txtNotaFiscal').val(pagarJson[0].DOCTO);
        $('#txtDupli').val(pagarJson[0].DUPLI);
        $('#txtValor').val(pagarJson[0].VALOR.toLocaleString('pt-BR', { maximumFractionDigits: 2, minimumFractionDigits: 2 }));
        $('#txtValorPago').val(pagarJson[0].VAL_PAG.toLocaleString('pt-BR', { maximumFractionDigits: 2, minimumFractionDigits: 2 }));
        $('#txtDTvencimento').val(pagarJson[0].DT_VEN);
        $('#txtDTemissao').val(pagarJson[0].DT_EMI);
        $('#txtObs').val(pagarJson[0].OBS);
        $('#txtStatus').val(pagarJson[0].STATUS);
        $('#txtEmpId').val(pagarJson[0].EMP_ID);
        $('#txtFornecedor').val(fornecedor);
        $('#txtSituacao').val(situacao);
        $('#txtClasse').val(classe);
        $('#txtBanco').val(banco);
        $('#txtConta').val(conta);
        const parcela = pagarJson[0].DUPLI.split('-');
        if ((parcela) && (parcela[1] != '')) {
          $('#labelParcela').removeClass('d-none');
          let label = $("#labelParcela label");
          const qtdeParcela = await buscaQtdeParcela(pagarJson[0].DOCTO, getCookie('emp_id'));
          let sParcela = parcela[1];
          if (!sParcela) {
            sParcela = 1;
          }
          label.text(`Parcela ${sParcela} de ${qtdeParcela}`);
        }
        $.LoadingOverlay("hide");
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro('Não foi possível buscar os dados do pagar: ');
      }
    }
  } else {
    $('#txtDTemissao').val(new Date().toISOString().slice(0, 10));
    $('#txtDTvencimento').val(new Date().toISOString().slice(0, 10));
    $('#txtEmpId').val(getCookie('emp_id'));
    $('.divParcela').removeClass('d-none');
  }

  $(function () {
    $('#txtValor, #txtValorParcela').maskMoney({
      decimal: ',',
      thousands: '.',
      precision: 2,
      allowZero: true,
      defaultZero: true,
      min: 0,
      max: 99
    });

    $('#txtIntervaloDias, #txtParcela').on('input', function (event) {
      $(this).val($(this).val().replace(/[^0-9.]/g, ''));
    });
  });

  $('#txtParcela').on('blur', function () {
    if ((parseFloat($('#txtValor').val()) == 0) && (parseFloat($('#txtValorParcela').val()) > 0) && (parseFloat($(this).val()) > 0)) {
      const valor = (parseFloat($('#txtValorParcela').val().replace(',', '.')) * parseFloat($(this).val())).toFixed(2);
      $('#txtValor').val(valor.replace('.', ','));
    }
  });

  $('#txtValorParcela').on('blur', function () {
    if ((parseFloat($('#txtValor').val()) > 0) && (parseFloat($(this).val()) > 0)) {
      const qtdeParcela = (parseFloat($('#txtValor').val()) / parseFloat($(this).val())).toFixed(0);
      $('#txtParcela').val(qtdeParcela);
    }
  });

  async function buscaQtdeParcela(docto, emp_id) {
    try {
      response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?',
        `JSON={ "tabela":"PAGTO", "camposSelect":["COUNT(*) QTDE"], "where": ["PAGTO.DOCTO = '${docto}'", "PAGTO.EMP_ID = ${emp_id}"]}`,
        null
      );
      if (!response) {
        return 1;
      }
      jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr.RESULT[0][0].QTDE;
    } catch (error) {
      console.error(error);
    }
  }

  function ultimoDiaDoMes(data, ultimoDia) {
    let dataRetorno = new Date(data.getFullYear(), data.getMonth(), 0);
    if (dataRetorno.getDate() > ultimoDia) {
      dataRetorno.setDate(ultimoDia);
    }
    return dataRetorno;
  }

  async function geraParcelas() {
    $.LoadingOverlay("show");
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        const colunas = [
          { title: 'Duplicata/Número', data: 'DUPLICATANUMERO' },
          { title: 'Valor', data: 'VALOR' },
          { title: 'Vecimento', data: 'VENCIMENTO' },
          { title: 'Emissão', data: 'EMISSAO' },
          { title: 'Classe', data: 'CLASSE' },
          { title: 'Banco', data: 'BANCO' },
          { title: 'Conta', data: 'CONTA' },
          { title: 'Situação', data: 'SITUACAO' },
          { title: 'Observação', data: 'OBSERVACAO' }
        ];
        criaDataTablePadrao('#tabelaParcelas', false, false, false, false, true, true, '400px', null, colunas, [], [], [], [1]);
        if ($.fn.dataTable.isDataTable('#tabelaParcelas')) {
          let tabelaParcelas = $('#tabelaParcelas').DataTable();
          tabelaParcelas.clear().draw();
        }

        const parcelas = parseInt($('#txtParcela').val()) > 0 ? parseInt($('#txtParcela').val()) : 1;
        const valorTotal = parseFloat($('#txtValor').val().replace('.', '').replace(',', '.'));
        let valorParcela = (valorTotal / parcelas).toFixed(2);
        const dtVencto = pegaValor('#txtDTvencimento').split('-');
        const vencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
        const primeiroVencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
        let dtVencimento;
        let novoVenctoTabela = new Date();
        const intervalo = pegaValor('#txtIntervaloDias') == '' ? 0 : pegaValor('#txtIntervaloDias');
        const valorDiferenca = (valorTotal - (valorParcela * parcelas)).toFixed(2);

        for (let i = 0; i < parcelas; i++) {
          if (((i + 1) == parcelas) && (valorDiferenca != 0)) {
            valorParcela = (parseFloat(valorParcela) + parseFloat(valorDiferenca)).toFixed(2);
          }

          // const numAP = await RetornaProximo('PAGTO', 'PAGTO', 'NUM_AP', 6);
          if (i == 0) {
            dtVencimento = vencto;
            novoVenctoTabela = dtVencimento;
          } else {
            if ($('#cbVenctoMesmoDia').prop('checked')) {
              dtVencimento = novoVenctoTabela;
              dtVencimento.setMonth(dtVencimento.getMonth() + 1);
              if (primeiroVencto.getDate() != dtVencimento.getDate()) {
                dtVencimento = ultimoDiaDoMes(dtVencimento, primeiroVencto.getDate());
              }
            } else {
              novoVenctoTabela.setDate(novoVenctoTabela.getDate() + parseInt(intervalo));
              dtVencimento = novoVenctoTabela;
            }
          }
          dtVencimento = formataData(dtVencimento);
          dtVencimento = formataDataBonita(dtVencimento);
          const concatDupli = ((i + 1) >= 10) ? '-' : '-0';
          const objeto = {
            DUPLICATANUMERO: $('#txtNotaFiscal').val() + concatDupli + (i + 1),
            VALOR: valorParcela,
            VENCIMENTO: dtVencimento,
            EMISSAO: formataDataBonita($('#txtDTemissao').val()),
            CLASSE: pegaChave('#txtClasse'),
            BANCO: pegaChave('#txtBanco'),
            CONTA: pegaChave('#txtConta'),
            SITUACAO: pegaChave('#txtSituacao'),
            OBSERVACAO: $('#txtObs').val(),
          }

          $('#tabelaParcelas').DataTable().row.add(objeto).draw(false);
        }
      }
    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('.collapse').on('shown.bs.collapse', function (e) {
    let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

    clicked
      .parent()
      .find(".fa-angle-right")
      .removeClass("fa-angle-right")
      .addClass("fa-angle-down");
  })
    .on('hidden.bs.collapse', function (e) {
      let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

      clicked
        .parent()
        .find(".fa-angle-down")
        .removeClass("fa-angle-down")
        .addClass("fa-angle-right");
    });
});
