<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Pedido</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.239.11.1" />
  <link href='dist/css/bootstrap.min.css?versao=3.239.11.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.239.11.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.239.11.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.239.11.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.239.11.1">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.239.11.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 20%;
      float: left;
      position: relative
    }

    .card-totais {
      margin-top: 2%;
    }

    #txtDados {
      padding-top: .7%;
      padding-left: .85%;
    }

    .input-group-append>a>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .grupo_botao>button>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .bg-light {
      background-color: #f8f9fa08 !important;
    }

    .focus:read-only:focus {
      border-color: #aa1212 !important;
    }

    .labelCheck {
      font-size: 110%;
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radiosStyle {
      font-size: 120%;
      margin-top: 1%;
      margin-bottom: 1%;
    }

    .checkboxMoeda {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding: .8%;
    }

    .bordaTab {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      margin-top: 9.6%;
    }

    .configTabPreco {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
    }

    .bordaRadio {
      border: 2px solid #e0e4e6;
      border-radius: 4px;
      height: 38px;
      padding-right: 50px;
    }

    #checkPrecoManual {
      margin-left: 10px;
    }
  </style>

</head>

<body class="sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="../index">Início</a></li>
                  <li class="breadcrumb-item"><a href="../pedido">Acesso Pedido</a></li>
                  <li class="breadcrumb-item active">Pedido</li>
                </ol>
              </div><!-- /.col -->
              <div class="container-fluid" id="grad1">
                <div class="row justify-content-center mt-0">
                  <div class="col-10 text-center">
                    <div class="card mb-0">
                      <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                        <h2 class="m-0">Pedido
                          <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                            <i class="fas fa-question-circle"></i>
                          </button>
                        </h2>
                      </div>
                      <div class="row">
                        <div class="col-md-12 mx-0">
                          <form id="msform">
                            <ul id="progressbar">
                              <li class="active" id="account"><strong>Geral</strong></li>
                              <li id="payment"><strong>Comercial</strong></li>
                              <li id="payment"><strong>Informações</strong></li>
                              <li id="payment"><strong>Itens</strong></li>
                              <li id="confirm"><strong>Pagamento</strong></li>
                            </ul>
                            <p>Preencha os dados e clique em avançar até a conclusão do pedido</p>
                            <fieldset>
                              <div class="form-card" id="tourGeral">
                                <h2 class="fs-title">Dados Gerais</h2>
                                <div class="row">

                                  <div class="col-lg-3  col-12 form-group">
                                    <label data-error="wrong" data-success="right" for="txtNumero">Número *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtNumero" name="txtNumero" placeholder="Número">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-12 form-group">
                                    <label data-error="wrong" data-success="right" for="dtDigita">Digita</label>
                                    <div class="input-group">
                                      <input type="date" readonly disabled class="input-default focus form-control" id="dtDigita" name="dtDigita">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-12 form-group">
                                    <label data-error="wrong" data-success="right" for="txtPedCliente">Ped. Cliente</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtPedCliente" name="txtPedCliente" placeholder="Ped. Cliente">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-12 form-group">
                                    <label>Empresa</label>
                                    <div class="input-group">
                                      <select class="form-control select2 select2-danger focus" id="selectEmpresa" name="selectEmpresa" data-dropdown-css-class="select2-danger">
                                      </select>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtCliente">Cliente *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                      <input type="text" id="txtCNPJ" class="d-none">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6 col-12 m-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtTransportador">Transportador</label>
                                    <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgTransportador" class="custom-select focus">
                                      <option value="">Selecione um transportador</option>
                                      <option value="0">0 - Contratação do Frete por conta do
                                        Remetente
                                        (CIF)</option>
                                      <option value="1">1 - Contratação do Frete por conta do
                                        Destinatário
                                        (FOB)</option>
                                      <option value="2">2 - Contratação do Frete por conta de
                                        Terceiros
                                      </option>
                                      <option value="3">3 - Transporte Próprio por conta do Remetente
                                      </option>
                                      <option value="4">4 - Transporte Próprio por conta do
                                        Destinatário
                                      </option>
                                      <option selected value="9">9 - Sem Ocorrência de Transporte</option>
                                    </select>
                                  </div>

                                  <div class="col-lg-6 col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtRepresentante">Representante *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" placeholder="Representante">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-representante" name="btn-representante" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-representante" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>


                                  <div class="col-lg-3  col-12 form-group">
                                    <label data-error="wrong" data-success="right" for="txtComFat">Com. Fat.</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtComFat" name="txtComFat" placeholder="Com. Fat.">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-12 form-group">
                                    <label data-error="wrong" data-success="right" for="txtComRec">Com. Rec.</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtComRec" name="txtComRec" placeholder="Com. Rec.">
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtTransportadora">Transportadora</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtTransportadora" name="txtTransportadora" class="form-control" placeholder="Transportadora">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-transportadora" name="btn-transportadora" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-transportadora" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtRedesp">Pagamento do Redesp</label>
                                    <div class="input-group bordaRadio p-0">
                                      <label class="container ml-2 mr-0 pl-0" for="radioCIF">CIF</label>
                                      <input type="radio" checked="checked" id="radioCIF" name="radiopagto">
                                      <label class="container ml-2 mr-0 pl-0" for="radioFOB">FOB</label>
                                      <input type="radio" id="radioFOB" name="radiopagto">
                                    </div>
                                  </div>

                                  <div class="col-lg-3" style="padding-top: 38px; padding-left: 30px;">
                                    <input type="checkbox" id="checkBonificacao"> <label for="checkBonificacao">Bonificação</label>        
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtRedesp">Redesp</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtRedesp" name="txtRedesp" class="form-control" placeholder="Redesp">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Redesp" name="btn-Redesp" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Redesp" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtCfop">CFOP</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCfop" name="txtCfop" placeholder="CFOP">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Cfop" name="btn-Cfop" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Cfop" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtResponsavel">Responsável</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtResponsavel" name="txtResponsavel" placeholder="Responsável">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Responsavel" name="btn-Responsavel" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Responsavel" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtPrazoEnt">Prazo Entrega</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtPrazoEnt" name="txtPrazoEnt" placeholder="Prazo Entrega">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-PrazoEnt" name="btn-PrazoEnt" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-PrazoEnt" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtColecao">Coleção</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtColecao" name="txtColecao" placeholder="Coleção">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Colecao" name="btn-Colecao" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Colecao" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtPrazoProd">Prazo Produção</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtPrazoProd" name="txtPrazoProd" placeholder="Prazo Produção">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-PrazoProd" name="btn-PrazoProd" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-PrazoProd" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                </div>
                              </div>
                              <input type="button" id="avancar1" name="next" class="next action-button" value="Avançar" />
                              <input type="button" id="voltarAcesso" class="action-button-previous" value="Voltar" />

                            </fieldset>
                            <fieldset>
                              <div class="form-card" id="tourComercial">
                                <h2 class="fs-title">Comercial</h2>
                                <div class="row">
                                  <div class="form-group col-lg-3  col-3 ">
                                    <label data-error="wrong" data-success="right" for="dtEmissao">Emissão</label>
                                    <div class="input-group">
                                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissao" name="dtEmissao">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="dtFatura">Fatura</label>
                                    <div class="input-group">
                                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtFatura" name="dtFatura">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="dtEntrega">Entrega</label>
                                    <div class="input-group">
                                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEntrega" name="dtEntrega">
                                    </div>
                                  </div>

                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="dtSaida">Saída</label>
                                    <div class="input-group">
                                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtSaida" name="dtSaida">
                                    </div>
                                  </div>

                                  <div class="col-lg-9  col-9 form-group">
                                    <label data-error="wrong" data-success="right" for="txtTabelaPreco">Tabela de Preço *</label>
                                    <input type="checkbox" id="checkPrecoManual"> <label for="checkPrecoManual">Preço Manual</label> 
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtTabelaPreco" name="txtTabelaPreco" placeholder="Tabela de Preço">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-TabelaPreco" name="btn-TabelaPreco" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-TabelaPreco" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-3 form-group">
                                    <label>Prazo</label>
                                    <select class="form-control focus select2 select2-danger" id="rgPrazo" name="rgPrazo" data-dropdown-css-class="select2-danger" style="width: 100%;">
                                      <option selected="selected" value="00">00</option>
                                      <option value="07">07</option>
                                      <option value="14">14</option>
                                      <option value="21">21</option>
                                      <option value="28">28</option>
                                      <option value="35">35</option>
                                      <option value="42">42</option>
                                      <option value="49">49</option>
                                      <option value="56">56</option>
                                      <option value="63">63</option>
                                      <option value="70">70</option>
                                      <option value="77">77</option>
                                      <option value="84">84</option>
                                      <option value="91">91</option>
                                    </select>
                                  </div>

                                  <div class="col-lg-6 form-group">
                                    <label for="txtClasseGer">Classe Gerencial</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" placeholder="Classe Gerencial">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-ClasseGer" name="btn-ClasseGer" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-ClasseGer" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6 form-group">
                                    <label for="txtHistorico">Histórico</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" placeholder="Histórico">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Historico" name="btn-Historico" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Historico" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                              </div>
                              <input type="button" id="avancarComercial" name="next" class="next action-button" value="Avançar" />
                              <input type="button" name="previous" id="VoltarGeral" class="previous action-button-previous" value="Voltar" />
                            </fieldset>
                            <fieldset id="financeiroFs">
                              <div class="form-card">
                                <h2 class="fs-title">Informações</h2>

                                <div class="row">

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtDeposito">Depósito *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" placeholder="Depósito">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Deposito" name="btn-Deposito" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Deposito" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label data-error="wrong" data-success="right" for="txtComprador">Comprador</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtComprador" name="txtComprador" placeholder="Comprador">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Comprador" name="btn-Comprador" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Comprador" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label for="txtGrupoPed">Grupo Ped</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtGrupoPed" name="txtGrupoPed" placeholder="Grupo Ped">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-GrupoPed" name="btn-GrupoPed" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-GrupoPed" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label for="txtStatus">Status *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtStatus" name="txtStatus" placeholder="Status">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Status" name="btn-Status" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Status" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label for="txtEspecie">Espécie</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtEspecie" name="txtEspecie" placeholder="Espécie">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Especie" name="btn-Especie" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Especie" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-6  col-6 form-group">
                                    <label for="txtOperacao">Operação</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtOperacao" name="txtOperacao" placeholder="Operação">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Operacao" name="btn-Operacao" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Operacao" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-4  col-4 form-group">
                                    <label for="txtTpVenda">Tipo Venda</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtTpVenda" name="txtTpVenda" placeholder="Tipo Venda">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-TpVenda" name="btn-TpVenda" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-TpVenda" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="txtDescontoEmprenho">Desconto R$</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtDescontoEmprenho" name="txtDescontoEmprenho" placeholder="0">
                                    </div>
                                  </div>

                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="txtDepto">Depto:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtDepto" name="txtDepto" placeholder="Depto">
                                    </div>
                                  </div>

                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="txtPrzAdicional">Prazo Adicional:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtPrzAdicional" name="txtPrzAdicional" placeholder="Prazo Adicional">
                                    </div>
                                  </div>

                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="txtOrcamento">Orçamento:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtOrcamento" name="txtOrcamento" placeholder="Orçamento">
                                    </div>
                                  </div>

                                  <div class="col-12">
                                    <div class="form-group" id="ObservacaoInfoTour">
                                      <label data-error="wrong" data-success="right" for="txtObservacao">Observação</label>
                                      <div class="input-group">
                                        <textarea style="resize: none" id="txtObservacao" maxlength="787" placeholder="Observação" class="input-default focus form-control" rows="5"></textarea>
                                      </div>
                                    </div>
                                  </div>

                                </div>
                              </div>
                              <input type="button" id="avancarItens" name="next" class="next action-button" value="Avançar" />
                              <input type="button" name="previous" id="voltarComercial" class="previous action-button-previous" value="Voltar" />
                            </fieldset>
                            <fieldset>
                              <div class="form-card">
                                <h2 class="fs-title">Itens</h2>
                                <div class="row justify-content-end">

                                  <div class="col-sm-2" style="margin-right: 14px;">
                                    <button type="button" id="btnAdicionar" class="btn btn-success btn-sisp">Adicionar</button>
                                  </div>

                                  <div class="col-12" style="margin-top: 10px;">
                                    <table id="tabelaItens" class="table table-responsive-sm table-select table-hover" width="100%">
                                      <thead>
                                        <tr>
                                          <th class="th-sm">Código</th>
                                          <th class="th-sm">Descrição</th>
                                          <th class="th-sm">Cor</th>
                                          <th class="th-sm">Tam</th>
                                          <th class="th-sm">Qtde</th>
                                          <th class="th-sm">Preço</th>
                                          <th class="th-sm">Tipo</th>
                                          <th class="th-sm">Foto</th>
                                          <th class="th-sm">×</th>
                                        </tr>
                                      </thead>
                                      <tbody>
                                      </tbody>
                                    </table>
                                  </div>
                                </div>

                              </div>
                              <input type="button" id="avancarPagamento" name="next" class="next action-button" value="Avançar" />
                              <input type="button" name="previous" id="ultimoVoltar" class="previous action-button-previous" value="Voltar" />
                            </fieldset>
                            <fieldset>
                              <div class="form-card" id="tourFinanceiro">
                                <h2 class="fs-title">Pagamento</h2>

                                <div class="row card-totais">
                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtValorLiq">Valor Líquido:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtValorLiq" name="txtValorLiq" disabled>
                                    </div>
                                  </div>
                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtTaxa">Taxa:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtTaxa" name="txtTaxa" placeholder="Taxa">
                                    </div>
                                  </div>
                                  <div class="col-lg-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtFrete">Frete:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtFrete" name="txtFrete" placeholder="Frete">
                                    </div>
                                  </div>
                                  <div class="col-lg-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtBonif">Bonif:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control maskDecimais" id="txtBonif" name="txtBonif" placeholder="Bonif">
                                    </div>
                                  </div>

                                  <div class="col-lg-12  col-12 form-group" style="margin-bottom: 0px;">
                                    <label data-error="wrong" data-success="right">Desconto:</label>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0.00" class="input-default focus form-control maskDecimais" id="txtDesconto1" name="txtDesconto1" placeholder="1">
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0.00" class="input-default focus form-control maskDecimais" id="txtDesconto2" name="txtDesconto2" placeholder="2">
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0.00" class="input-default focus form-control maskDecimais" id="txtDesconto3" name="txtDesconto3" placeholder="3">
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0.00" class="input-default focus form-control maskDecimais" id="txtDesconto4" name="txtDesconto4" placeholder="4">
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0.00" class="input-default focus form-control maskDecimais" id="txtDesconto5" name="txtDesconto5" placeholder="5">
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0.00" class="input-default focus form-control maskDecimais" id="txtDesconto6" name="txtDesconto6" placeholder="6">
                                    </div>
                                  </div>
                                  <div class="col-lg-12  col-12 form-group" style="margin-bottom: 0px;">
                                    <label data-error="wrong" data-success="right">Condição de pagamento: *</label>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" value="0" class="input-default focus form-control" id="txtCondPagto1" name="txtCondPagto1" placeholder="1">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto2" name="txtCondPagto2" placeholder="2">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto3" name="txtCondPagto3" placeholder="3">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto4" name="txtCondPagto4" placeholder="4">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto5" name="txtCondPagto5" placeholder="5">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto6" name="txtCondPagto6" placeholder="6">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto7" name="txtCondPagto7" placeholder="7">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto8" name="txtCondPagto8" placeholder="8">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto9" name="txtCondPagto9" placeholder="9">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto10" name="txtCondPagto10" placeholder="10">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto11" name="txtCondPagto11" placeholder="11">
                                    </div>
                                  </div>
                                  <div class="col-lg-1  col-1 form-group">
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondPagto12" name="txtCondPagto12" placeholder="12">
                                    </div>
                                  </div>
                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: *</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" placeholder="Moeda">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Moeda" name="btn-Moeda" data-button="absolute" type="button">
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Moeda" type="button">
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-lg-3  col-3 form-group">
                                    <label data-error="wrong" data-success="right" for="txtCondicao">Condição:</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCondicao" name="txtCondicao" placeholder="Condicao" disabled>
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-Condicao" name="btn-Condicao" data-button="absolute" type="button" disabled>
                                          <i class="m-0 p-0 fas fa-search"></i>
                                        </button>
                                        <button class="btn bg-danger" id="btn-limpa-Condicao" type="button" disabled>
                                          <i class="m-0 p-0 fas fa-trash"></i>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="txtNrParcelas">Nr. Parcelas:</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtNrParcelas" name="txtNrParcelas" value="0" disabled>
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="txtIntervaloDias">Intervalo de Dias</label>
                                    <div class="input-group">
                                      <input type="number" class="input-default focus form-control" id="txtIntervaloDias" name="txtIntervaloDias" value="1" disabled>
                                    </div>
                                  </div>
                                  <div class="col-lg-2  col-2 form-group">
                                    <label data-error="wrong" data-success="right" for="dtPrimeiroVencto">1º Vencimento:</label>
                                    <div class="input-group">
                                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtPrimeiroVencto" name="dtPrimeiroVencto" disabled>
                                    </div>
                                  </div>
                                </div>
                                <div class="form_group">
                                  <div class="div">
                                    <input type="button" class="btn float-right btn-danger btn-sisp" id="btnAtualizar" name="make_payment" value="Atualizar" style="margin: 1px" />
                                    <input type="button" class="btn float-right  btn-primary btn-sisp" id="btnLimpar" name="make_payment" value="Limpar" style="margin: 1px" />
                                  </div>
                                </div>
                                <div class="col-sm-12 table-responsive card-body">
                                  <table id="tabelaCondicao" class="table table-responsive-sm table-select table-hover" width="100%">
                                    <thead>
                                      <tr>
                                        <th class="th-sm">Dias</th>
                                        <th class="th-sm">Vencimento</th>
                                        <th class="th-sm">Moeda</th>
                                        <th class="th-sm">Condição</th>
                                        <th class="th-sm">Valor</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                  </table>
                                </div>
                              </div>
                              <input type="button" id="gravar" name="make_payment" class="action-button" value="Gravar" />
                              <input type="button" id="voltarItens" name="previous" class="previous action-button-previous" value="Voltar" />

                            </fieldset>
                          </form>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
  <div class="modal fade" id="modalItem" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modalItem-titulo" class="modal-title">Adicionar Item
            <label class="container" style="font-size: 70%;">
              <input type="radio" checked="checked" id="radioProduto" name="liberarBloq">
              <span class="checkmark"></span> Produto
            </label>
            <label class="container" style="font-size: 70%;">
              <input type="radio" id="radioMaterial" name="liberarBloq">
              <span class="checkmark"></span> Material
            </label>
          </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body" id="dadosItem">

          <div id="dadosProduto">
            <div class="row d-flex justify-content-center">
              <div class="col-lg-6  col-6 form-group">
                <label data-error="wrong" data-success="right" for="txtProduto">Produto:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-Produto" name="btn-Produto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-Produto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-2 form-group">
                <label data-error="wrong" data-success="right" for="txtValor">Qtde Est:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" disabled id="txtQuantidadeEstoque" name="txtQuantidadeEstoque" title="Quantidade em estoque relacionada ao produto e depósito informados" class="form-control" placeholder="Qtde Est">
                </div>
              </div>
              <div class="col-lg-3  col-6 form-group">
                <label data-error="wrong" data-success="right" for="txtValor">Valor Unitário:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control maskDecimaisParametro" id="txtValor" name="txtValor" class="form-control" placeholder="Valor">
                </div>
              </div>
              <div class="col-sm-12 table-responsive card-body">
                <table id="tabelaGradeProduto" class="table table-responsive-sm table-select table-hover" width="100%">
                  <thead>
                    <tr id="colunas">
                    </tr>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>

          <div class="d-none" id="dadosMaterial">
            <div class="row d-flex justify-content-center">
              <div class="col-lg-2  col-6 form-group">
                <label data-error="wrong" data-success="right" for="txtQtde">Quantidade:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control maskDecimais" id="txtQtde" value="1" name="txtQtde" class="form-control" placeholder="Quantidade">
                </div>
              </div>
              <div class="col-lg-3  col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtMaterial">Material:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtMaterial" name="txtMaterial" class="form-control" placeholder="Material">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-Material" name="btn-Material" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-Material" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-lg-3  col-3 form-group">
                <label data-error="wrong" data-success="right" for="txtCor">Cor:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" class="form-control" placeholder="Cor">
                  <div class="input-group-append">
                    <button class="btn bg-danger" id="btn-Cor" name="btn-Cor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <button class="btn bg-danger" id="btn-limpa-Cor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-lg-2  col-2 form-group">
                <label data-error="wrong" data-success="right" for="txtQuantidadeEstoqueMat">Qtde Est:</label>
                <div class="input-group">
                  <input type="text" disabled class="input-default focus form-control" id="txtQuantidadeEstoqueMat" name="txtQuantidadeEstoqueMat" class="form-control" placeholder="Qtde Est">
                </div>
              </div>
              <div class="col-lg-2  col-6 form-group">
                <label data-error="wrong" data-success="right" for="txtValorMat">Valor Unitário:</label>
                <div class="input-group">
                  <input type="text" class="input-default focus form-control maskDecimaisParametro" id="txtValorMat" name="txtValorMat" class="form-control" placeholder="Valor">
                </div>
              </div>
            </div>
          </div>

        </div>
        <div class="modal-footer">
          <div class="row" id="trocaClasse">
            <div class="col-sm-2 itemSelecionado d-none">
              <label data-error="wrong" data-success="right" for="txtCorSelecionado">Cor:</label>
              <div class="input-group">
                <input type="text" disabled class="input-default focus form-control" id="txtCorSelecionado" name="txtCorSelecionado" class="form-control">
              </div>
            </div>
            <div class="col-sm-2 itemSelecionado d-none">
              <label data-error="wrong" data-success="right" for="txtTamSelecionado">Tamanho</label>
              <div class="input-group">
                <input type="text" disabled class="input-default focus form-control" id="txtTamSelecionado" name="txtTamSelecionado" class="form-control">
              </div>
            </div>
            <div class="col-sm-2 itemSelecionado d-none">
              <label data-error="wrong" data-success="right" for="txtQtdeSelecionado">Qtde est.:</label>
              <div class="input-group">
                <input type="text" disabled class="input-default focus form-control" id="txtQtdeSelecionado" name="txtQtdeSelecionado" class="form-control">
              </div>
            </div>
            <div class="col-sm-3">
              <button id="btnConfirmarItem" style="margin-top: 27px" class="btn btn-danger">Confirmar</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="imagemodal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-body">
          <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
          <img src="" class="imagepreview" style="width: 100%;">
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.239.11.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.239.11.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.239.11.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.239.11.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.239.11.1"></script>

  <script src="../dist/js/adminlte.min.js?versao=3.239.11.1"></script>

  <script src="../dist/js/requisicoes.js?versao=3.239.11.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.239.11.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.239.11.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.239.11.1"></script>
  <script src="../dist/js/popper.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/tippy-bundle.umd.js?versao=3.239.11.1"></script>
  <script src="../utils/funcoes.js?versao=3.239.11.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.239.11.1"></script>
  <script src="../utils/cookies.js?versao=3.239.11.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.239.11.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.239.11.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.239.11.1"></script>
  <!-- Production -->
  <script type="text/javascript">
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('PEDIDO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("PEDIDO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/pedido`
        });
        return;
      }

      sArquivo = `${BASE_URI}/pages/pedido/pedido/pedido.js?versao=3.239.11.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>