<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Preço</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=1.7.9">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=1.7.9">

    <!-- Google Font: Source Sans Pro -->
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">


    <link rel="stylesheet" href="dist/css/custom.css?versao=1.7.9">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=1.7.9">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=1.7.9" />
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=1.7.9">
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=1.7.9" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=1.7.9">
    <style>
        #tabelaPreco td div button {
            padding: .0rem .5rem;
            margin-top: .1rem;
            margin-bottom: .2rem;
        }

        #tabelaPreco td {
            padding: 0 !important;
            padding-left: 10px !important;
        }

        #progressbar li {
            list-style-type: none;
            font-size: 12px;
            width: 400px;
            float: left;
            position: relative
        }

        #progressbar #account:before {
            font-family: "Font Awesome 5 Free";
            content: "\f15c";
            font-weight: 900;
        }

        #progressbar #payment:before {
            font-family: "Font Awesome 5 Free";
            content: "\f0cb";
            font-weight: 900;
        }

        #progressbar li:after {
            content: "";
            width: 100%;
            height: 3px;
            background: lightgray;
            position: absolute;
            left: 0;
            top: 25px;
            z-index: -1;
        }

        #progressbar li:before {
            width: 50px;
            line-height: 16px;
            display: block;
            font-size: 20px;
            color: #ffffff;
            background: lightgray;
            border-radius: 50%;
            margin: 0 auto 17px auto;
            padding: 16px;
        }

        td.ajustePrazo {
            padding-left: 36px;
        }

        td.ajusteQtdeEstoque {
            padding-left: 38px;
        }

        td.ajustePrecoAtual {
            padding-left: 34px;
        }

        td.ajustePrecoPromocional {
            padding-left: 65px;
        }

        .campoDesconto {
            width: 93%;
            margin-left: 21px;
        }

        .campoValorDesconto {
            width: 85%;
            margin-left: 15px;
        }

        .campoPrecoFinal {
            width: 80%;
        }

        .campoDtIni,
        .campoDtFim {
            width: 90%;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        include_once('../../../menu.php');
        ?>
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Preço</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                                <li class="breadcrumb-item active">Acesso Preço</li>
                            </ol>
                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid" id="tabelaPrecoForne">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp" id="btnNovoPreco"><span class="fas fa-plus"></span> Incluir</button>
                            <button class="btn btn-danger btn-sisp" id="btnAlterarPreco"></span> Alterar Preço</button>
                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <h5>Lista de Preços </h5>
                            <table id="tabelaPreco" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                    <tr>
                                        <th class="th-sm">Código Produto
                                        </th>
                                        <th class="th-sm">Descrição Produto
                                        </th>
                                        <th class="th-sm">Tabela de Preço
                                        </th>
                                        <th class="th-sm">Descrição tabela
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content" id="modalBody">
                        <div class="modal-header">
                            <h4 class="modal-title">Filtros</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-12  col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtTabPreco">Tabela de Preço</label>
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control validate" required aria-describedby="tabPrecoError" id="txtTabPreco" name="txtTabPreco" class="form-control" placeholder="Tabela de Preço">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnTabPreco" name="btnTabPreco" data-button="absolute" type="button">
                                                <i class="m-0 p-0 fas fa-search"></i>
                                            </button>
                                            <button class="btn bg-danger" id="btnExcluiTabPreco" type="button">
                                                <i class="m-0 p-0 fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12  col-12 form-group" id="produtotuto">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtProduto">Produto</label>
                                    <div class="input-group">
                                        <input type="text" class="input-default focus form-control" required aria-describedby="produtoError" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                                        <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button">
                                                <i class="m-0 p-0 fas fa-search"></i>
                                            </button>
                                            <button class="btn bg-danger" id="btnExcluiProduto" type="button">
                                                <i class="m-0 p-0 fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <div class="row">
                                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="modal-alterarpreco" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
                <div class="modal-header">
                    <h4 class="modal-title">Alterar Preço Promocional</h4>
                    <button class="btn btn-success btn-sisp ml-2" id="btnFiltrosPreco"><span class="fas fa-filter"></span> Filtros</button>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" id="bodyPrincipal">
                    <ul id="progressbar" style="margin-left: 3px;">
                        <li class="active" id="account" style="font-size: 100%; width: 540px;"><strong style="padding-left: 252px;">Geral</strong></li>
                        <li id="payment" style="font-size: 100%; width: 540px;"><strong style="padding-left: 214px;">Tabelas de Preço</strong></li>
                    </ul>
                    <div class="row">

                        <div class="col-lg-4" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtDataIni">Data Inicial *</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataIni" name="txtDataIni">
                            </div>
                        </div>

                        <div class="col-lg-4" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtDataFim">Data Final *</label>
                            <div class="input-group">
                                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDataFim" name="txtDataFim">
                            </div>
                        </div>

                        <div class="col-lg-2" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtDescontoPreco">Desconto %</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtDescontoPreco" name="txtDescontoPreco" style="margin-right: -50px;" placeholder="Desconto %">
                            </div>
                        </div>

                        <div class="col-lg-2" style="margin-top: 1%;">
                            <button class="btn btn-primary btn-sisp ml-5" style="margin-top: 27px;" id="btnConfimarPreco"> Confirmar</button>
                        </div>

                        <div class="col-lg-12  col-12" style="margin-top: 1%;" id="tabelatuto">
                            <label data-error="wrong" data-success="right" for="tabelaAlterarPreco" required="required" style="margin-right: 963px;">Preços cadastrados</label>
                            <table id="tabelaAlterarPreco" class="table table-sm table-select table-hover">
                                <thead>
                                    <tr>
                                        <th>Tabela</th>
                                        <th class="d-none">CDProduto</th>
                                        <th class="d-none">DescProduto</th>
                                        <th>Item</th>
                                        <th>Coleção</th>
                                        <th>Data Inicial *</th>
                                        <th>Data Final *</th>
                                        <th>Prazo</th>
                                        <th>Estoque</th>
                                        <th>Preço Atual</th>
                                        <th>Preço Promocional</th>
                                        <th>Desconto %</th>
                                        <th>Valor Desconto</th>
                                        <th>Preço Final</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
                <div class="modal-body d-none" id="bodyTabelasPreco">
                    <ul id="progressbar" style="margin-left: 3px;">
                        <li class="active" id="account" style="font-size: 100%; width: 540px;"><strong style="padding-left: 252px;">Geral</strong></li>
                        <li class="active" id="payment" style="font-size: 100%; width: 540px;"><strong style="padding-left: 214px;">Tabelas de Preço</strong></li>
                    </ul>
                    <div class="row">
                        <div class="col-lg-12  col-12" style="margin-top: 1%;" id="tabelatuto">
                            <label data-error="wrong" data-success="right" for="tabelaTabelasPreco" required="required">Tabelas de Preço</label>
                            <table id="tabelaTabelasPreco" class="table table-sm table-select table-hover">
                                <thead>
                                    <tr>
                                        <th>SEL</th>
                                        <th>Tabela de Preço</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="row">
                        <button class="btn btn-danger btn-sisp" id="btnLimparCamposAlterarPreco"><span class="fas fa-trash"></span> Limpar Campos</button>    
                        <button class="btn btn-danger btn-sisp" id="btnAvancar"> Avançar</button>
                        <button class="btn btn-danger btn-sisp d-none" style="background: #616161;border-color: #616161; margin-right: 10px;" id="btnVoltar"> Voltar</button>
                        <button class="btn btn-danger btn-sisp d-none" id="btnGravarPreco"> Gravar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modal-filtrosAlterarPreco" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
                <div class="modal-header">
                    <h4 class="modal-title">Filtros</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-lg-12" style="margin-top: 1%; border-bottom: 1px solid #e9ecef; padding-bottom: 10px">
                            <label data-error="wrong" data-success="right" for="txtTabelaPrecoAltera">Tabela de Preço *</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtTabelaPrecoAltera" name="txtTabelaPrecoAltera" placeholder="Tabela de Preço">
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnTabelaPreco" name="btnTabelaPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaTabelaPreco"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtTipoItemPreco">Tipo</label>
                            <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgTipoItemPreco" class="custom-select focus">
                                <option value="0">0 - Produto</option>
                                <option value="1">1 - Material</option>
                            </select>
                        </div>
                        <div class="col-lg-10" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" id="labelProdutoMaterial" for="txtProdutoMaterial">Produto</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtProdutoMaterial" name="txtProdutoMaterial" placeholder="Produto">
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnProdutoMaterial" name="btnProdutoMaterial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaProdutoMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtGrupoPreco">Grupo</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtGrupoPreco" name="txtGrupoPreco" placeholder="Grupo">
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnGrupoPreco" name="btnGrupoPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaGrupoPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtColecaoPreco">Coleção</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtColecaoPreco" name="txtColecaoPreco" placeholder="Coleção">
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnColecaoPreco" name="btnColecaoPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaColecaoPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtMarcaPreco">Marca</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMarcaPreco" name="txtMarcaPreco" placeholder="Marca">
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnMarcaPreco" name="btnMarcaPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaMarcaPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3" style="margin-top: 1%;">
                            <label data-error="wrong" data-success="right" for="txtPrazoPreco">Prazo</label>
                            <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtPrazoPreco" name="txtPrazoPreco" placeholder="Prazo">
                                <div class="input-group-append">
                                    <button class="btn bg-danger" id="btnPrazoPreco" name="btnPrazoPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btnLimpaPrazoPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="row">     
                        <button class="btn btn-primary btn-sisp" id="btnConsultarPreco"><span class="fas fa-search"></span> Consultar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php
    include_once('../../../footer.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=1.7.9"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=1.7.9"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=1.7.9"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=1.7.9"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=1.7.9"></script>
    <script src="dist/js/adminlte.min.js?versao=1.7.9"></script>
    <script src="plugins/jquery-validation/jquery.validate.min.js?versao=2.2.2"></script>
    <script src="dist/js/sisplan.js?versao=1.7.9"></script>
    <script src="utils/funcoes.js?versao=1.7.9"></script>
    <script src="utils/cookies.js?versao=1.7.9"></script>
    <script src="dist/js/requisicoes.js?versao=1.7.9"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=1.7.9"></script>
    <script src="dist/js/driver.min.js?versao=1.7.9"></script>
    <script src="plugins/toastr/toastr.min.js?versao=1.7.9"></script>
    <script type="text/javascript" src="dist/js/sum().js?versao=1.7.9"></script>
    <script type="text/javascript" src="config.js?versao=1.7.9"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('TABELAPRECO');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/preco/acesso_preco/acesso_preco.js?versao=1.7.9`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>