$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });
        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
                position: 'top'
            }
        },
        {
            element: '#txtDocumento',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtTipoSaida',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtQualidade',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDeposito',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtBarra',
            popover: {
                title: 'Campo Barra',
                description: 'Aqui você irá bipar o produto que será dado entrada.',
                position: 'top'
            }
        },
        {
            element: '#tabela-movimentados',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui ficam os produtos bipados.',
                position: 'top'
            }
        },
        {
            element: '#confirmar_mov',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a movimentação.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let listaBarrasBipadas = [];
    const parametrosSistema = await BuscaParametrosSistema();
    const utilizaBarraLog = parametrosSistema[0].VALOR == 1;

    await buscaValoresPadroes();

    $("#txtPrecoSped").maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
    });

    let tabelaGrade = $('#tabela-grade').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    await setarDataAtual('txtDataDe');
    await setarDataAtual('txtDataAte');
    $('#txtQuantidadeBipada').val(0);

    async function filtraGrade() {
        if (($('#txtProduto').val() != '') && ($('#txtCor').val() != '') && ($('#txtCor').val().substr(0, 1) == '[')) {
            let dataSet = await RetornaGradeProd();
            $('#tabela-grade').DataTable().rows().remove().draw(false);
            for (let i = 0; i < dataSet.length; i++) {
                const grade = dataSet[i];
                tabelaGrade.row.add([grade.TAM, grade.QUANTIDADE, `<input class="input-default" style="width:150px;" type="number" min="0" max="${grade.QUANTIDADE > 0 ? grade.QUANTIDADE : 0}"/>`, grade.ID_PA_ITEN]).draw(false);
            }

            $('#modal-grade').modal('show');
        }
        ajustaCusto();
    };

    function ajustaCusto() {
        const custo = $('#txtPrecoSped').val();
        if (custo.split('').includes(',')) {
            $('#txtPrecoSped').val((parseFloat((custo).replace(',', '.'))).toFixed(2));
        }
    }

    $('#modal-grade').on('hidden.bs.modal', function () {
        limpaCampos();
    });

    async function RetornaGradeProd() {
        let sCodigo = pegaChave('#txtProduto');
        let sDeposito = pegaChave('#txtDeposito');
        let sCor = pegaChave('#txtCor');
        let sQualidade = pegaChave('#txtQualidade');
        const tipo = sQualidade == '' ? sQualidade : ` and pa_iten.tipo = '${sQualidade}'`;
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = `JSON={"tabela":"pa_iten", "camposSelect":[ "pa_iten.tam", "(SELECT UDF_NVL(SUM(QUANTIDADE)) QTDE FROM [PA_ITEN] PA_ITEN_QTDE WHERE PA_ITEN_QTDE.CODIGO = PA_ITEN.CODIGO AND PA_ITEN_QTDE.COR = PA_ITEN.COR AND PA_ITEN_QTDE.TAM = PA_ITEN.TAM AND PA_ITEN_QTDE.DEPOSITO='${sDeposito}' AND PA_ITEN_QTDE.TIPO='${sQualidade}') as QUANTIDADE, PA_ITEN.ID_PA_ITEN"],
        "leftjoin": [{ "tabela" : "produto", "condicao" : "pa_iten.codigo = produto.codigo" }, { "tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam" }], "groupby": ["pa_iten.codigo", "pa_iten.cor", "pa_iten.tam",  "faixa_iten.posicao", "pa_iten.id_pa_iten"],
        "where": ["pa_iten.codigo = '${sCodigo}' and pa_iten.cor='${sCor}' and pa_iten.deposito = '${sDeposito}' ${tipo}"], "orderby": ["faixa_iten.posicao"]}`;

        try {
            let response = await requisicao('GET', url, params, null);

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados da venda.');
            return '';
        }
    }

    $('#txtTipoSaida').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnTipoSaida').pesquisa_array(['#txtTipoSaida'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabbai", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Tipo Entrada', 'tabbai');
    $('#btnLimpaTipoSaida').on('click', function () {
        $('#txtTipoSaida').val('');
    });

    $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"tabqul", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabqul", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Qualidade', 'tabqul');
    $('#btnLimpaQualidade').on('click', function () {
        $('#txtQualidade').val('');
    });

    const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const json = await retornaJsonPesquisaPadrao(`{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA <> ''"] }`);
    const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

    if (depositoUsuario != 'null') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ${depositoUsuario}}`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else if (depositosEmpresaLogada != '') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else if (json.length == 0) {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": []}`, 'Pesquisa Depósito', 'DEPOSITO');
    } else {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
    }

    $('#btnLimpaDeposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO, CUSTO"], "where": [] }`, ['#txtPrecoSped'], ['CUSTO'], ['CUSTO'], filtraGrade, [true]);
    // $('#btnProduto').pesquisa_array(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO'], ['DESCRICAO', 'CUSTO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"produto", "camposSelect":[ "codigo", "descricao", "custo" ], "where": null}', 'Pesquisa Produto', 'produto', filtraGrade, [false, true]);
    // $('#btnProduto').pesquisa_serverside(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO'], ['DESCRICAO', 'CUSTO'], `{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CUSTO" ], "where": null}`, 'Pesquisa Produto', filtraGrade, [false, true]);
    $('#btnProduto').pesquisa_serverside(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO', 'CODIGO2'], ['DESCRICAO', 'CUSTO', 'CODIGO2'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CUSTO", "CODIGO2" ], "camposWhereServerSide":["CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Produto', filtraGrade, [false, true]);
    $('#btnLimpaProduto').on('click', function () {
        $('#txtProduto').val('');
    });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], [], filtraGrade);
    $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":[ "cor", "descricao" ], "where": null}', 'Pesquisa Cor', 'cadcor', filtraGrade);
    $('#btnLimpaCor').on('click', function () {
        $('#txtCor').val('');
    });

    $('#txtProduto').on('blur', function () {
        // $('#txtCor').off();
        $('#txtCor').unbind('autocompleta');
        $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], [], filtraGrade);
        $('#btnCor').off();
        $('#btnCor').unbind('pesquisa_array');
        $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "pa_iten.cor", "cadcor.descricao" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'cadcor', filtraGrade);
    });

    $('#tabela-movimentados').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
        scrollY: "300px",
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    $('#tabela-movimentados').on('click', '.btn-excluir', async function () {
        const itemPosicionado = $('#tabela-movimentados').DataTable().row($(this).parents('tr')).data();
        $('#tabela-movimentados').DataTable().row($(this).parents('tr')).remove().draw(false);
        validaEBloqueiaCampos();
        VerificaQuantidadeBipada();
        removeItemListaBarra(itemPosicionado[0], itemPosicionado[2], itemPosicionado[3]);

        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonSaidaManualProduto', jsonarquivo);
    });

    async function documentoEhValido() {
        try {
            const pesquisa = {
                camposSelect: ['CODIGO'],
                tabela: 'PA_MOV',
                where: [`NUM_DOCTO = '${$('#txtDocumento').val()}'`]
            };

            const url = `/sisplan/funcoes/v1/pesquisa?`;
            const params = `JSON=${JSON.stringify(pesquisa)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                return false;
            }
            return jsonStr.RESULT[0].length > 0;
        } catch (error) {
            return false;
        }
    }

    $('#txtDocumento').on('blur', async function () {
        try {
            $.LoadingOverlay("show");
            let lancto;
            if ($(this).val() == '') {
                let docto = await RetornaDoctoELancto('DOCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                lancto = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                insereValor('#txtDocumento', docto);
                insereValor('#txtLancamento', lancto);
                $(this).attr('disabled', $(this).val() != '');
            } else {
                if (!await documentoEhValido()) {
                    msgAlerta('Documento inválido, verifique', null, null, () => {
                        $('#txtDocumento').focus();
                    });
                    $('#txtDocumento').val('');
                    return;
                }
                lancto = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                insereValor('#txtLancamento', lancto);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnConfirmar').on('click', async function () {
        if ($('#txtProduto').val() == '') {
            msgErro('Informe um produto para continuar.');
            return;
        }

        if ($('#txtDocumento').val() == '') {
            msgErro('Necessário um número de documento para continuar.');
            return;
        }

        if ($('#txtTipoSaida').val() == '') {
            msgErro('Informe um tipo de saída para continuar.');
            return;
        }

        if ($('#txtQualidade').val() == '') {
            msgErro('Informe uma qualidade para continuar.');
            return;
        }

        if ($('#txtDeposito').val() == '') {
            msgErro('Informe um deposito para continuar.');
            return;
        }

        if ($('#txtCor').val() == '') {
            msgErro('Informe uma cor para continuar.');
            return;
        }

        if ($('#txtPrecoSped').val() <= 0) {
            msgErro('Informe um preço válido para continuar.');
            return;
        }

        // valida grade
        if ($('td>input').length <= 0) {
            msgErro('Não há grade para o produto/cor informado, verifique.');
            return;
        }
        let bTemQtde = false;
        for (let index = 0; index < $('td>input').length; index++) {
            let qtde = $($('td>input')[index]).val();
            if (qtde > 0) {
                bTemQtde = true;
            }
        }
        if (!bTemQtde) {
            msgErro('Grade sem quantidade, impossível continuar.');
            return;
        }

        let sProduto = pegaChave('#txtProduto');
        let sDescricao = pegaDescricao('#txtProduto');
        let sCor = pegaChave('#txtCor');
        let sQualidade = pegaChave('#txtQualidade')
        let arrEstoque = [];
        // valida estoque
        for (let i = 0; i < $('#tabela-grade').DataTable().rows().count(); i++) {
            const element = $('#tabela-grade').DataTable().row(i).data();
            let sTam = element[0];
            let vQtde = $($('td>input')[i]).val();
            let vEstoque = element[1];
            if ((vQtde > 0) && (vEstoque < vQtde)) {
                await msgErro(`Quantidade insuficiente para movimentar no tamanho: ${sTam}`);
                return;
            }
        }

        await $('#tabela-grade').DataTable()
            .rows()
            .data()
            .each(async function (value, index) {
                let sTam = value[0];
                let vQtde = $($('td>input')[index]).val();
                let vEstoque = value[1];
                let id_pa_iten = value[3]
                if ((vQtde > 0) && (vEstoque >= vQtde)) {
                    arrEstoque.push(await montaJsonEstoque(sProduto, sCor, sTam, vQtde, $('#txtPrecoSped').val(), $('#txtLote').val(), id_pa_iten));
                }
            });

        try {
            await $.LoadingOverlay("show");
            for (let index = 0; index < arrEstoque.length; index++) {
                const element = arrEstoque[index];
                await $('#tabela-movimentados').DataTable().row.add([
                    sProduto,
                    sDescricao,
                    sCor,
                    element.tamanho,
                    element.quantidade,
                    $('#txtPrecoSped').val(),
                    $('#txtLote').val(),
                    element.id_pa_iten,
                    sQualidade,
                    retornaBotaoOpcoes()
                ]).draw(false);
            }
            VerificaQuantidadeBipada();
        } finally {
            $.LoadingOverlay("hide");
            $('#modal-grade').modal('hide');
        }

        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonSaidaManualProduto', jsonarquivo);
    });

    $('#btnMenosOuMais').on('click', function () {
        const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
        $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
        $('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
        $('#txtBarra').focus();
        $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
        if (estaComoEstorno) {
            $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
        } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
    });
    async function retornaQuantidadeGrid() {
        try {

            listaBarrasBipadas.find(item => item.barra == sBarra);

        } catch (e) {
            console.error(e);
        }
    }

    $('#txtBarra').on('blur', async function () {
        let qtde = +$('#txtQuantidade').val();
        const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
        const ehPrimeiroRegistro = $('#tabela-movimentados').DataTable().rows().data().toArray().length === 0;
        const ehbarralog = await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";

        if ($('#txtBarra').val() == '') {
            return;
        }

        if (ehPrimeiroRegistro && estornaQuantidade == 'true') {
            SomAlerta(BASE_URI, true);
            return msgAlerta("Nenhuma barra encontrada para estornar!");
        }

        try {
            $.LoadingOverlay("show");
            bloqueiaCampos('card-body', true);

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();
            if (erros != 0) {
                $('#txtBarra').val('');
                $('#txtBarra').focus();
                return;
            }

            if (!($('#txtQuantidade').val() > 0)) {
                msgAlerta('Quantidade inválida, favor verificar!');
                SomAlerta(BASE_URI, true);
                return;
            }
            if ($('#txtLote').val() == '') {
                msgAlerta('Lote inválido, favor verificar!');
                SomAlerta(BASE_URI, true);
                return;
            }

            let dadosBarra = await retornaDadosBarra($(this).val());

            let dadosProd = dadosBarra.length == 0 ? null : dadosBarra[0];
            if (dadosProd == null) {
                SomAlerta(BASE_URI, true);
                msgAlerta('Nenhum dado para esta barra!');
                $('#txtBarra').val('');
                $('#txtBarra').focus();
                return;
            }

            if (utilizaBarraLog && ehbarralog && $("#txtQuantidade").val() > 1) {
                SomAlerta(BASE_URI, true);
                msgAlerta("Quantidade inválida. Permitido bipar somente uma quantidade na barra log.");
                return;
            }

            const barraEstornada = utilizaBarraLog ? await barraJaEstornada($('#txtBarra').val()) : false;

            if (barraEstornada && estornaQuantidade == 'true' && ehbarralog) {
                SomAlerta(BASE_URI, true);
                msgErro(`Barra ${$('#txtBarra').val()} já estornada, verifique.`);
                return;
            }

            if (utilizaBarraLog) {
                if (estornaQuantidade == 'true') {
                    await estornaBarraBipada($('#txtBarra').val());
                }
            }

            const barraBipada = utilizaBarraLog ? await barraJaEstaBipada($('#txtBarra').val()) : false;
            if (utilizaBarraLog) {
                if (estornaQuantidade == 'false') {
                    await adicionaBarraBipada(
                        {
                            codigo: dadosProd.CODIGO,
                            cor: dadosProd.COR,
                            tam: dadosProd.TAM,
                            barra: $('#txtBarra').val(),
                        }
                    );
                }
            }

            let existeRegistroEstorno = false;

            if (!barraBipada) {

                //     $('#tabela-movimentados').DataTable().rows().data().map((item, index) => {
                //         if ((dadosProd.CODIGO == item[0]) && (dadosProd.COR == item[2]) && (dadosProd.TAM == item[3]) && ($('#txtLote').val() == item[6])) {
                //             if (estornaQuantidade == 'false') {
                //                 qtde = parseFloat(item[4]) + parseFloat($('#txtQuantidade').val());
                //             } else {
                //                 qtde = parseFloat(item[4]) - parseFloat($('#txtQuantidade').val());
                //             }

                //             $('#txtQuantidade').val(qtde);
                //             $('#tabela-movimentados').DataTable().rows(index).remove().draw();
                //         }
                //         return 'ok';
                //     });
                //     const paramEstoque = await CopiaParametro('VENDA', 4) == 0;

                $('#tabela-movimentados').DataTable().rows().data().map((item, index) => {
                    if ((dadosProd.CODIGO == item[0]) && (dadosProd.COR == item[2]) && (dadosProd.TAM == item[3]) && ($('#txtLote').val() == item[6]) && (dadosProd.TIPO == item[8])) {
                        if (estornaQuantidade == 'false') {
                            qtde = parseFloat(item[4]);
                        } else {
                            qtde = parseFloat(item[4]) - parseFloat($('#txtQuantidade').val());
                            $('#txtQuantidade').val(qtde);
                        }

                        existeRegistroEstorno = true;
                        $('#tabela-movimentados').DataTable().rows(index).remove().draw();
                    }
                    return 'ok';
                });

                const paramEstoque = await CopiaParametro('VENDA', 4) == 0;

                let qtdeTotal = 0;

                if (estornaQuantidade == 'false') {
                    if (!existeRegistroEstorno) {
                        qtdeTotal = parseFloat($('#txtQuantidade').val());
                    } else {
                        qtdeTotal = parseFloat($('#txtQuantidade').val()) + qtde;
                    }
                }

                //     if (paramEstoque) {
                //         if (dadosProd.QUANTIDADE < qtde) {
                //             msgAlerta('Quantidade insuficiente no estoque para essa barra!');
                //             if (estornaQuantidade == 'false') {
                //                 qtde = dadosProd.QUANTIDADE;
                //                 $('#txtQuantidade').val(dadosProd.QUANTIDADE);
                //             }
                //         }
                //     }

                if (paramEstoque) {

                    if (estornaQuantidade == 'false') {
                        if (dadosProd.QUANTIDADE < qtdeTotal) {
                            msgAlerta('Quantidade insuficiente no estoque para essa barra!');
                            if (!existeRegistroEstorno) {
                                qtde = 0;
                            }
                        } else {
                            if (existeRegistroEstorno) {
                                qtde = qtdeTotal;
                            }
                        }
                    } else {
                        if (!existeRegistroEstorno) {
                            msgAlerta('Barra não foi bipada para realizar o estorno!');
                            qtde = 0;
                        }
                    }
                } else {
                    if (estornaQuantidade == 'false') {
                        qtde = qtdeTotal;
                    }
                }

                //     if (ehPrimeiroRegistro || qtde > 0) {
                if (qtde > 0) {
                    $('#tabela-movimentados').DataTable().row.add([
                        dadosProd.CODIGO,
                        dadosProd.DESCRICAO,
                        dadosProd.COR,
                        dadosProd.TAM,
                        qtde,
                        dadosProd.CUSTO,
                        $('#txtLote').val(),
                        dadosProd.ID_PA_ITEN,
                        dadosProd.TIPO,
                        retornaBotaoOpcoes()
                    ]).draw(false);
                    SomAlerta();
                    VerificaQuantidadeBipada();
                }
            }

            $('#tabela-movimentados tbody tr:last-child').trigger('click');
            let $scrollBody = $($('#tabela-movimentados').DataTable().table().node()).parent();
            $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);

            validaEBloqueiaCampos();
            await VerificaQuantidadeBipada();

            const jsonarquivo = montaJsonArquivo();
            await salvaArquivo('JsonSaidaManualProduto', jsonarquivo);

        } finally {
            bloqueiaCampos('card-body', false);
            $.LoadingOverlay("hide");
            $('#txtBarra').val('');
            $('#txtQuantidade').val('1');
            $('#txtBarra').focus();
        }

    });

    $("#btnCancelarSaidaManual").on("click", async function () {
        msgAlerta("Deseja realmente cancelar a movimentação?", () => { deletaArquivo('JsonSaidaManualProduto'), window.location.reload(); });

    });

    $('#tabela-movimentados tbody').on('click', 'tr', function () {
        const tabelamovimentados = $('#tabela-movimentados').DataTable();
        tabelamovimentados.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });

    $('#confirmar_mov').on('click', async function () {
        try {
            $('#confirmar_mov').prop('disabled', true);
            $.LoadingOverlay("show");
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros != 0) {
                $('#confirmar_mov').prop('disabled', false);
                return;
            }
            if ($('#tabela-movimentados').DataTable().rows().count() == 0) {
                $('#confirmar_mov').prop('disabled', false);
                msgAlerta('Nenhum produto bipado, favor verificar.');
                return;
            }
            await gravarMovimentacao();
        } catch (error) {
            console.error(error);
            $('#confirmar_mov').prop('disabled', false);
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function VerificaQuantidadeBipada() {
        const quantidade = $("#tabela-movimentados")
            .DataTable()
            .column(4, {})
            .data()
            .sum();
        $('#txtQuantidadeBipada').val(+quantidade);
    }

    $('#msform').validate({
        ignore: "",
        rules: {
            txtDocumento: {
                required: true,
            },
            txtTipoSaida: {
                required: true,
            },
            txtQualidade: {
                required: true,
            },
            txtDeposito: {
                required: true,
            }
        },
        messages: {
            txtDocumento: {
                required: "Gere um documento para continuar."
            },
            txtTipoSaida: {
                required: "Informe um tipo de entrada."
            },
            txtQualidade: {
                required: "Informe uma qualidade."
            },
            txtDeposito: {
                required: "Informe um depósito."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    function validaEBloqueiaCampos() {
        let bTabela = $('#tabela-movimentados').DataTable().rows().count() > 0;
        $('#txtDocumento').prop('disabled', bTabela);
        $('#txtTipoSaida').prop('disabled', bTabela);
        $('#txtQualidade').prop('disabled', bTabela);
        $('#txtDeposito').prop('disabled', bTabela);
        $('#btnTipoSaida').prop('disabled', bTabela);
        $('#btnLimpaTipoSaida').prop('disabled', bTabela);
        $('#btnQualidade').prop('disabled', bTabela);
        $('#btnLimpaQualidade').prop('disabled', bTabela);
        $('#btnDeposito').prop('disabled', bTabela);
        $('#btnLimpaDeposito').prop('disabled', bTabela);
    }

    $('.somAtivo').on('click', function () {
        $(this).addClass('d-none');
        localStorage.setItem("@prodSaida.somAtivo", false);
        $('.somInativo').removeClass('d-none');
    });

    $('.somInativo').on('click', function () {
        $(this).addClass('d-none');
        localStorage.setItem("@prodSaida.somAtivo", true);
        $('.somAtivo').removeClass('d-none');
    });

    const somAtivo = localStorage.getItem('@prodSaida.somAtivo') ?? 'false';
    if (somAtivo == 'true') {
        $($('.somInativo')[0]).trigger('click');
    }

    function montaJsonEstoque(codigo, cor, tam, qtde, custo, lote, id_pa_iten) {
        let EstProd = {
            codigo,
            cor,
            tamanho: tam,
            deposito: pegaChave('#txtDeposito'),
            quantidade: qtde,
            documento: $('#txtDocumento').val(),
            custo,
            qualidade: pegaChave('#txtQualidade'),
            lote,
            unidade: '',
            cliente: '',
            descricao: '',
            tipobaixa: pegaChave('#txtTipoSaida'),
            tipo: 'MN',
            observacao: '',
            id_pa_iten: id_pa_iten
        };
        return EstProd;
    }

    async function gravarMovimentacao() {
        try {
            const listaEstProd = {
                produtos: []
            };
            $('#tabela-movimentados').DataTable().rows().data().each(async function (value) {
                listaEstProd.produtos.push(montaJsonEstoque(value[0], value[2], value[3], value[4], value[5], value[6], value[7]));
            });
            let sLancto = $('#txtLancamento').val();

            const barraslog = {
                barras: utilizaBarraLog ? listaBarrasBipadas : []
            };

            let response = await requisicao(pagar = 'POST', '/Sisplan/Estoque/V1/MovimentaEstoque?', '', `JSON=${encodeURIComponent(JSON.stringify(listaEstProd))}&LANCTO=${sLancto}&TIPO=SAIDA&JSONBARRAS=${encodeURIComponent(JSON.stringify(barraslog))}`, 300000);

            if (!response) {
                $('#confirmar_mov').prop('disabled', false);
                return;
            }

            if (response.status != 200) {
                $('#confirmar_mov').prop('disabled', false);
                msgErro(`Erro API:${jsonStr.RESULT[0].mensagem}`);
                return;
            }

            msgAlerta('Deseja imprimir a movimentação?',
                () => { },
                () => { callBack(); },
                async () => {
                    await ImprimirRelatorio();
                    callBack();
                },
                () => { callBack(); });

            function callBack() {

                toastr.success("Movimentação realizada com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px",
                });

            }

            await deletaArquivo('JsonSaidaManualProduto');
        } catch (error) {
            console.error(error);
            $('#confirmar_mov').prop('disabled', false);
            msgErro(`Não foi possível gravar os dados do Estoque: ${error}`);
        }
    }

    async function adicionaBarraBipada(objItem) {
        try {
            const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
            if (['barra_log'].includes(retornoBarraLog)) {
                listaBarrasBipadas.push(objItem);
                return true;
            }
            return false;

        } catch (error) {
            console.error(error);
        }
    }

    async function retornaDadosBarra(sBarra) {

        const barralog = sBarra.substr(0, 6);
        const deposito = pegaChave('#txtDeposito');
        const qualidade = pegaChave('#txtQualidade');

        if (deposito == '') {
            msgAlerta('Depósito não informado, impossível continuar!');
            SomAlerta(BASE_URI, true);
            return;
        }

        if (qualidade == '') {
            msgAlerta('Qualidade não informada, impossível continuar!');
            SomAlerta(BASE_URI, true);
            return;
        }

        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = encodeURIComponent(`JSON={"tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "PA_ITEN.TAM", "PRODUTO.CUSTO", "PA_ITEN.QUANTIDADE", "PA_ITEN.ID_PA_ITEN", "PA_ITEN.TIPO"],
        "innerjoin": [{ "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO" }],
        "where": ["PA_ITEN.TIPO = '${qualidade}' AND PA_ITEN.DEPOSITO = '${deposito}' AND (PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRA28 = '${barralog}' OR PA_ITEN.BARRACLI = '${sBarra}')"]}`);

        try {
            let response = await requisicao('GET', url, params, null);
            if (!response) {
                return '';
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                SomAlerta(BASE_URI, true);
                return '';
            }

            return jsonStr.RESULT[0];

        } catch (error) {
            console.error(error);
            SomAlerta(BASE_URI, true);
            msgErro('Não foi possível buscar os dados da barra.');
            return '';
        }
    }

    async function retornaBarraLogLida(sBarra) {
        try {
            const url = `/sisplan/barralog/v1/validarbarra?`;
            const params = `barra=${encodeURIComponent(sBarra)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            jsonStr = await response.json();
            if (response.status != 200) {
                return jsonStr.mensagem;
            }

            return jsonStr.mensagem;
        } catch (error) {
            console.error(error);
        }
    }

    async function barraJaEstaBipada(sBarra) {
        try {
            if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
                msgErro(`Barra ${sBarra} já lida, verifique.`);
                return true;
            }
            return false;
        } catch (error) {
            console.error('barra_log', error);
            msgErro('Erro ao processar barra log.');
            return false;
        }
    }

    async function barraJaEstornada(sBarra) {
        try {
            if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
                return false;
            }
            return true;
        } catch (error) {
            console.error('barra_log', error);
            msgErro('Erro ao processar barra log.');
            return false;
        }
    }

    async function removeItemListaBarra(sCodigo, sCor, sTam) {
        try {
            listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.codigo !== sCodigo && item.cor !== sCor && item.tam !== sTam)];
        } catch (error) {
            console.error(error);
        }
    }

    async function estornaBarraBipada(sBarra) {
        try {
            listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
        } catch (error) {
            console.error(error);
        }
    }

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    $("#btnImprimir").on("click", async function () {
        ImprimirRelatorio();
    });

    async function ImprimirRelatorio() {
        let dadosBackEnd = {};
        let arrayTransferencia = [];
        const Dados = $('#tabela-movimentados').DataTable().rows().data();
        Dados.each((campo => {
            dadosBackEnd = {
                CODIGO: campo[0],
                DESCRICAO: campo[1],
                COR: campo[2],
                TAM: campo[3],
                QTDE: parseFloat(campo[4]),
                PRECOSPED: parseFloat(campo[5]),
                LOTE: campo[6]
            };
            arrayTransferencia.push(dadosBackEnd);
        }));
        console.log(arrayTransferencia);
        const url = `/sisplan/impressao/v1/imprimirsaidaporbarra?`;
        const documento = $('#txtDocumento').val();
        const params = `JSON=${JSON.stringify(arrayTransferencia)}&DOCUMENTO=${documento}`;
        const response = await requisicao('GET', url, params, null);
        const arquivo = await response.text();

        if (arquivo != undefined) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            await limparRelatorios();
        }
    };

    function limpaCampos() {
        limpaValor('#txtPrecoSped');
        limpaValor('#txtProduto');
        limpaValor('#txtCor');
        limpaValor('#txtQuantidade');
        limpaValor('#txtBarra');
        limpaValor('#txtObs');
        $('#tabela-grade').DataTable().rows().remove().draw(false);
    }

    try {
        const response = await carregaArquivo('JsonSaidaManualProduto');
        if (response.status === 200) {
            const jsonStr = await response.json();
            insereValor("#txtDocumento", jsonStr.documento);
            insereValor("#txtLancamento", jsonStr.lancamento);
            insereValor("#txtTipoSaida", jsonStr.tiposaida.split("] - ")[0].substr(1), jsonStr.tiposaida.split("] - ")[1]);
            insereValor("#txtQualidade", jsonStr.qualidade.split("] - ")[0].substr(1), jsonStr.qualidade.split("] - ")[1]);
            insereValor("#txtDeposito", jsonStr.deposito.split("] - ")[0].substr(1), jsonStr.deposito.split("] - ")[1]);
            jsonStr.itens.forEach((item) => {
                $("#tabela-movimentados")
                    .DataTable()
                    .row.add([
                        item.codigo,
                        item.descricao,
                        item.cor,
                        item.tam,
                        item.qtde,
                        item.precosped,
                        item.lote,
                        item.id_pa_iten,
                        item.tipo,
                        retornaBotaoOpcoes(),
                    ])
                    .draw(false);
            });
            listaBarrasBipadas = jsonStr.barrasbipadas;
            VerificaQuantidadeBipada();
            msgAlerta("Carregado dados não salvos, verifique.");
        }
    } catch (error) {
        console.log(error);
    }

    function montaJsonItens() {
        const itensDataTable = $("#tabela-movimentados").DataTable().data().toArray();
        const itens = itensDataTable.map((itemDT) => {
            const item = {
                codigo: itemDT[0],
                descricao: itemDT[1],
                cor: itemDT[2],
                tam: itemDT[3],
                qtde: itemDT[4],
                precosped: itemDT[5],
                lote: itemDT[6],
                id_pa_iten: itemDT[7],
                tipo: itemDT[8]
            };
            return item;
        });
        return itens;
    }

    function montaJsonArquivo() {
        const importacao = {
            documento: $("#txtDocumento").val(),
            lancamento: $("#txtLancamento").val(),
            tiposaida: $("#txtTipoSaida").val(),
            qualidade: $("#txtQualidade").val(),
            deposito: $("#txtDeposito").val(),
            itens: montaJsonItens(),
            barrasbipadas: listaBarrasBipadas,
        };
        return importacao;
    }

    async function buscaValoresPadroes() {
        $.LoadingOverlay('show');
        try {

            const classValores = { POSICAO: '9' };
            const response = await requisicao('POST', '/sisplan/valorespadroes/v1/buscar?', '', JSON.stringify(classValores), null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            insereValor('#txtTipoSaida', jsonStr.tipoSaida);
            insereValor('#txtQualidade', jsonStr.qualidade);
            insereValor('#txtDeposito', jsonStr.deposito);

            const pesquisa = {
                camposSelect: ['TABPADRAO.CAMPO', 'TABPADRAO.VALOR', 'CADCOR.DESCRICAO'],
                tabela: 'TABPADRAO',
                leftJoin: [{ "tabela": "CADCOR", "condicao": "TABPADRAO.VALOR = CADCOR.COR" }],
                where: [`TABPADRAO.TABELA = 'PRODUTO'`]
            }
            const jsonStrPad = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            jsonStrPad.map(item => {
                switch (item.CAMPO) {
                    case 'COR_SAI_MANUAL': {
                        if (item.DESCRICAO) {
                            insereValor('#txtCor', item.VALOR, item.DESCRICAO);
                        }
                        break;
                    }
                }
            });

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

});