$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um ramo de atuação.",
          position: "right",
        },
      },
      {
        element: "#tabelaRamoAtuacao",
        popover: {
          title: "Tabela de Dados",
          description: "Aqui estão os dados dos ramos de atuação cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await consultaDados();
  const permissaoUsuarioLogado = await permissaoAcessos("RAMOATUACAO");

  $('#txtRamoAtuacao').autocompleta(1, `JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnRamoAtuacao').pesquisa('#txtRamoAtuacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Ramo Atuação', '');

  $('#btnARamoAtuacao').on('click', async function () {
    $('#txtRamoAtuacao').val('');
  })

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtRamoAtuacao').val('');
    $('#selectTipo').val('');
  });

  $("#btnIncluir").on("click", async function () {

    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const proximo = await RetornaProximo('RAMO_ATUACAO', 'RAMO_ATUACAO', 'CODIGO', 0);

      window.location.href = `ramoatuacao/${proximo}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };


  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");

      const codigo = pegaChave('#txtRamoAtuacao');
      const tipo = $('#selectTipo').val();

      let url = `/sisplan/impressao/v1/relramoatuacao?codigo=${codigo}&tipo=${tipo}`;
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RamoAtuacao');
      if (arquivo != undefined) {
        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");
      try {

        let params = '[ " 1=1 ';

        if ($('#txtRamoAtuacao').val() != '') {
          params += ` AND CODIGO = '${pegaChave('#txtRamoAtuacao')}'`
        }

        if ($('#selectTipo').val() != '') {
          params += ` AND TIPO = '${$('#selectTipo').val()}'`
        }

        params += ' " ]'

        $("#tabelaRamoAtuacao").DataTable({
          destroy: true,
          lengthChange: false,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "GET",
            headers: { Authorization: BASIC_AUTH },
            data: {
              EMPRESA: getCookie("empresa"),
              JSON: `{"tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO"], "where": ${params}}`,
            },
          },
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          columnDefs: [
            {
              targets: [0], render: function (data) {
                return retornaBotaoOpcoes(data);
              },
            },
          ],
        });
        $("input[type='search']").focus();
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function excluiLinha(codigo) {

    let response = await requisicao("DELETE", `/Sisplan/Cadastros/V1/ramoatuacao?`, `CODIGO=${codigo}`, 15000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr[0].mensagem);
      return;
    }

    toastr
      .success("Exclusão realizada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/ramoatuacao`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  $("#tabelaRamoAtuacao").on("click", "#btn-excluir", async function () {
    msgAlerta('Deseja excluir este registro?', async () => {
      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        let data = $("#tabelaRamoAtuacao").DataTable().row($(this).parents("tr")).data();
        await excluiLinha(data[0]);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    })
  });

  $("#tabelaRamoAtuacao").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaRamoAtuacao").DataTable().row($(this).parents("tr")).data();
      let clienteLiberado = await liberarRegistro("RAMOATUACAO", data[0]);
      if (clienteLiberado) {
        window.location.href = `ramoatuacao/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaRamoAtuacao").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaRamoAtuacao").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("RAMOATUACAO", data[0]);
      if (clienteLiberado) {
        window.location.href = `ramoatuacao/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("input[type='search']").on("keydown", function () {
    if (window.event.which === 13) {
      $("#btn-editar").trigger("click");
    }
  });
});
