$("#tutorial").on("click", function () {
  $(document).ready(function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#valortotal",
        popover: {
          title: "Total a Receber",
          description:
            "Aqui você poderá ver o total que recebeu e ainda receberá.",
          position: "right",
        },
      },
      {
        element: "#valorpago",
        popover: {
          title: "Total Pago",
          description: "Aqui você poderá ver o valor que foi recebido.",
          position: "right",
        },
      },
      {
        element: "#valorsaldo",
        popover: {
          title: "Total Saldo",
          description: "Aqui você poderá o valor que está pendente.",
          position: "left",
        },
      },
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Você pode clicar aqui para filtrar sua consulta.",
          position: "right",
        },
      },
      {
        element: "#btn-novoReceber",
        popover: {
          title: "Botão Novo",
          description:
            "Você pode clicar aqui para adicionar um contas a receber.",
          position: "right",
        },
      },
      {
        element: "#tabelaTour",
        popover: {
          title: "Duplicatas",
          description:
            "Aqui você verá todos os contas a receber que você possui.",
          position: "top",
        },
      },
    ]);
    // inicio tour
    driver.start();
  });
});

$(document).ready(async function () {
  let tempoSegundosPix = 300;
  const parametrosVenda = await BuscaParametrosVenda();
  const parametrosReceber = await BuscaParametrosReceber();

  let validouSenhaSupervisorBaixa = false;

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.acessoReceber == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoReceber: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, acessoReceber: novasColunas }))

      $('#tabelaReceber').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaReceber').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  const permissaoUsuarioLogado = await permissaoAcessos("RECEBER");
  await setarDataAtual("txtDTPagamento");
  await setarDataAtual("txtDTContabilizacao");
  await setarDataAtual("txtDTPagamentoAnt");
  await setarDataAtual("txtDTContabilizacaoAnt");
  if (!await verificaCadPadrao()) {
    await setarDataAtual("txtVenctoI");
    await setarDataAtual("txtVenctoF");
  };

  const configuracoes = {
    '1': { checked: true, disabled: true, readonly: true },
    '2': { checked: true, disabled: false, readonly: false },
    '3': { checked: false, disabled: true, readonly: true }
  };

  (async function () {
    const { VALOR } = (parametrosReceber[6]);
    $('#cbNaoLancaCc').prop(configuracoes[VALOR]);
  })();

  await addBandeira();
  adicionaMascaraCampos();
  preencheOrdenacaoTela('Receber');
  if (await apenasClientesVinculadosAoRepresentante()) {
    bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentanteConsulta', '#btn-RepresentanteConsulta', '#btn-limpa-RepresentanteConsulta');
  }

  const lancaCaixa = (await CopiaParametro("RECEBER", 0)) == "1";

  let response = await requisicao(
    "GET",
    "/Sisplan/Funcoes/v1/pesquisa?",
    `JSON={ "tabela":"PERMISSOES_TELA",
            "camposSelect":["PERMISSAO"],
            "where": ["USUARIO = '${getCookie(
      "cod_usuario"
    )}' AND EMP_ID = ${getCookie(
      "emp_id"
    )} AND TELA = 'RECEBER' AND ACAO = 'ALTERAR_CHECK_CAIXA'"]}`,
    null
  );
  if (!response || response.status != 200) {
    return;
  }
  let jsonStr = await response.json();

  let podeAlterarCheck;
  if (jsonStr.RESULT[0].length > 0) {
    podeAlterarCheck = jsonStr.RESULT[0][0].PERMISSAO == "S";
  } else {
    podeAlterarCheck = false;
  }

  const FormatoDtNovo = "DD/MM/YYYY";

  function primeiroDia() {
    let agora = new Date();
    let primeiroDia = new Date(agora.getFullYear(), agora.getMonth(), 1);
    return primeiroDia;
  }

  var primeiroDia = primeiroDia();
  var dataISO = primeiroDia.toISOString();
  var dataString = dataISO.substr(0, 10);


  $("#txtClasse").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtClasseAnt").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );

  $('#txtClienteConsulta').pesquisa_variosServerside(3, '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'CODCLI', 'NOME');
  $("#txtRepresentanteConsulta").autocompleta(
    3,
    `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where":["ativo = 'S'"]}`
  );
  $("#txtMoeda").autocompleta(
    1,
    `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": null}`,
    ["#txtTipoMoeda"],
    ["TIPO"],
    ["TIPO"]
  );

  $("#txtConta").autocompleta(
    1,
    `JSON={ "tabela":"cadconta", "camposSelect":[ "conta chave", "descricao descricao"], "where": null}`
  );

  $("#txtHistorico").autocompleta(
    1,
    `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`
  );

  $("#txtHistoricoAnt").autocompleta(
    1,
    `JSON={ "tabela":"histcp", "camposSelect":[ "historico chave", "descricao descricao"], "where": null}`
  );

  $("#txtMoedaConsulta").autocompleta(
    1,
    `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": null}`
  );

  $("#txtClasseGerConsulta").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao descricao", "tipo"], "where": null}`
  );

  $("#txtChequeSituacao").autocompleta(
    1,
    `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtChequeClasse").autocompleta(
    1,
    `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`
  );
  $("#txtChequeRepresentante").autocompleta(
    3,
    `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"]}`
  );
  $("#txtChequeCliente").autocompleta(
    3,
    `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`
  );
  $("#txtChequeHistorico").autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $('#txtNumeroCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);

  $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
  $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
  $('#btn-limpa-condicao').on('click', function () {
    limpaValor('#txtCondicaoDePagamento');
    limpaValor('#txtNrParcelas');
  });

  $("#btn-ChequeClasse").pesquisa(
    "#txtChequeClasse",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );
  $("#btn-ChequeCliente").pesquisa(
    "#txtChequeCliente",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`,
    "Pesquisa Cliente",
    "entidade"
  );
  $("#btn-ChequeRepresentante").pesquisa(
    "#txtChequeRepresentante",
    "CODREP",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`,
    "Pesquisa Representante",
    "represen"
  );
  $("#btn-ChequeSituacao").pesquisa(
    "#txtChequeSituacao",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Situação",
    "tabsit"
  );
  $("#btnChequeHistorico").pesquisa("#txtChequeHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"]}`, "Pesquisa Histórico", "HISTCP");

  $("#btn-limpa-ChequeClasse").on("click", function () {
    $("#txtChequeClasse").val("");
  });

  $("#btn-limpa-ChequeCliente").on("click", function () {
    $("#txtChequeCliente").val("");
  });

  $("#btn-limpa-ChequeRepresentante").on("click", function () {
    $("#txtChequeRepresentante").val("");
  });

  $("#btn-limpa-ChequeSituacao").on("click", function () {
    $("#txtChequeSituacao").val("");
  });

  $("#btnLimpaChequeHistorico").on("click", function () {
    $("#txtChequeHistorico").val("");
  });


  $("#btn-Classe").pesquisa(
    "#txtClasse",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );
  $("#btn-ClasseAnt").pesquisa(
    "#txtClasseAnt",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Classe",
    "classe_ger"
  );

  $('#btn-ClienteConsulta').pesquisa_serversideSel('#txtClienteConsulta', `{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ"], "where": null}`, 'Pesquisa de Cliente');
  $("#btn-RepresentanteConsulta").pesquisa_array(
    ["#txtRepresentanteConsulta"],
    ["CODREP"],
    ["NOME"],
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"], "where": ["ativo = 'S'"]}`,
    "Pesquisa Representante",
    "represen"
  );
  $("#btnMoeda").pesquisa_array(
    ["#txtMoeda", "#txtTipoMoeda"],
    ["CODMOE", "TIPO"],
    ["DESCRICAO", "TIPO"],
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao", "TIPO"]}',
    "Pesquisa Moeda",
    "MOEDA"
  );
  $("#btnConta").pesquisa(
    "#txtConta",
    "CONTA",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "conta", "descricao"]}`,
    "Pesquisa Conta",
    "cadconta"
  );
  if (!lancaCaixa) {
    $("#btnCaixa").pesquisa(
      "#txtCaixa",
      "CODIGO",
      "DESCRICAO",
      '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
      "Pesquisa Tabela",
      "CAIXA_LOJA"
    );

    $("#txtCaixa").autocompleta(
      1,
      `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`
    );
  }
  $("#btn-Historico").pesquisa(
    "#txtHistorico",
    "HISTORICO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}`,
    "Pesquisa Histórico",
    "histcp"
  );
  // $("#btn-SituacaoBaixa").pesquisa(
  //   "#txtSituacaoBaixa",
  //   "CODIGO",
  //   "DESCRICAO",
  //   `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`,
  //   "Pesquisa Situação",
  //   "tabsit"
  // );
  $("#btn-HistoricoAnt").pesquisa(
    "#txtHistoricoAnt",
    "HISTORICO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao"]}`,
    "Pesquisa Histórico",
    "histcp"
  );
  $("#btnClasseGerConsulta").pesquisa(
    "#txtClasseGerConsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "CODIGO", "descricao"]}`,
    "Pesquisa Classe Gerencial",
    "classe_ger"
  );

  $("#btnMoedaConsulta").pesquisa_array(
    ["#txtMoedaConsulta", "#txtTipoMoeda"],
    ["CODMOE", "TIPO"],
    ["DESCRICAO", "TIPO"],
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao", "TIPO"]}',
    "Pesquisa Moeda",
    "MOEDA"
  );

  $('#btnNumeroCaixa').pesquisa('#txtNumeroCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');

  $("#btnLimpaMoedaConsulta").on("click", function () {
    $("#txtMoedaConsulta").val("");
  });

  $("#btnLimpaClasseGer").on("click", function () {
    $("#txtClasseGerConsulta").val("");
  });

  $("#btn-limpa-Historico").on("click", function () {
    $("#txtHistorico").val("");
  });

  // $("#btn-limpa-SituacaoBaixa").on("click", function () {
  //   $("#txtSituacaoBaixa").val("");
  // });

  $("#btn-limpa-HistoricoAnt").on("click", function () {
    $("#txtHistoricoAnt").val("");
  });

  $("#btn-limpa-Classe").on("click", function () {
    $("#txtClasse").val("");
  });

  $("#btn-limpa-ClasseAnt").on("click", function () {
    $("#txtClasseAnt").val("");
  });

  $("#btn-limpa-Caixa").on("click", function () {
    $("#txtCaixa").val("");
  });

  $('#btnANumeroCaixa').on('click', function () {
    $('#txtNumeroCaixa').val('');
  });

  $("#btn-limpa-ClienteConsulta").on("click", function () {
    $('#txtClienteConsulta').empty().trigger('change');
  });
  $("#btn-limpa-Conta").on("click", function () {
    $('#txtConta').val('');
  });

  $("#btn-limpa-RepresentanteConsulta").on("click", function () {
    $("#txtRepresentanteConsulta").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btn-novoReceber").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "receber/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#checkCaixa").on("click", async function () {
    if ($("#checkCaixa").prop("checked") == true) {
      $("#checkCaixa").prop("checked", true);
      $("#lancaCaixa").removeClass("d-none");
      $("#divMoeda").removeClass("col-lg-9");
      await VinculaCaixaComUsuario();
      $("#txtCaixa").val(sessionStorage.getItem("g_caixa_logado"));
      if (
        sessionStorage.getItem("g_caixa_logado") == null ||
        sessionStorage.getItem("g_caixa_logado") == "undefined" ||
        sessionStorage.getItem("g_caixa_logado") == undefined
      ) {
        $("#txtCaixa").val("");
      }
    } else {
      $("#checkCaixa").prop("checked", false);
      $("#lancaCaixa").addClass("d-none");
      $("#divMoeda").removeClass("col-lg-6");
      $("#divMoeda").addClass("col-lg-9");
    }
  });

  $("#btnLimparFiltros").on("click", function () {
    $("#txtNumero").val("");
    $("#txtFatura").val("");
    if (!$('#txtRepresentanteConsulta').attr('disabled')) {
      $("#txtRepresentanteConsulta").val("");
    }
    $("#txtMoedaConsulta").val("");
    $("#txtDataEmiI").val("1200-01-01");
    $("#txtDataEmiF").val("2500-12-31");
    $("#txtVenctoI").val("1200-01-01");
    $("#txtVenctoF").val("2500-12-31");
    $("#Status").val("TODOS").trigger('change');
    $("#txtSituacao").val("Todos").trigger('change');
    $("#txtCartaoPresente").val("");
    $("#txtPagamentoI").val("1200-01-01");
    $("#txtPagamentoF").val("2500-12-31");
    $("#txtClasseGerConsulta").val("");
    $('#txtNumeroCaixa').val('');
  });



  async function verificaMoedaTef(codMoeda) {

    const pesquisa = {
      tabela: 'MOEDA',
      camposSelect: ['TEF'],
      where: [`CODMOE = ${codMoeda}`]
    }
    //adicionar where dos filtros
    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return json[0].TEF == 'S';
  }

  async function verificaMoedaPix(codMoeda) {

    const pesquisa = {
      tabela: 'MOEDA',
      camposSelect: ['TIPO'],
      where: [`CODMOE = ${codMoeda}`]
    }

    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    return json[0].TIPO == '5';
  }

  $("#txtMoeda").on("focusout", async function () {

    if ($("#txtMoeda").val() == "") {
      $("#divNSU").addClass("d-none");
      $("#divCondicoesDePagamento").addClass("d-none");
      return;
    }
    await verificaMoeda();

    if ($('#txtMoeda').val() != '') {
      atualizaValorPago();
      atualizaValorTotal();
      atualizaTotalDesconto();
      atualizaTotalJuros();
      calculaTroco();

      const usaTef = await verificaMoedaTef(pegaChave('#txtMoeda'));
      const possuiTroco = await moedaPossuiTroco(pegaChave('#txtMoeda'));
      if (usaTef) {
        $("#divNSU").addClass("d-none");
      }
      if (!$("#divCondicoesDePagamento").hasClass('d-none')) {
        $('#txtCondicaoDePagamento').focus();
      } else if (!usaTef) {
        if (!$('#divNSU').hasClass('d-none')) {
          $('#txtNsu').focus();
        }
      }
      habilitaTroco(possuiTroco);
      buscaCondicoes(pegaChave(this));
      if (pegaChave(this) != '') {
        try {
          $('#txtConta').val('');
          const conta = await buscaValor('MOEDA_CONTA', 'CONTA', 'MOEDA', `${pegaChave(this)}' AND EMPRESA = '${getCookie('empresa').substring(1)}`);
          if (conta != undefined && conta.CONTA) {
            insereValor('#txtConta', conta.CONTA, conta.CONTA);
          }

          if ($('#txtConta').val() == '') {

            let respostaConta = await requisicao(
              "GET",
              "/Sisplan/Funcoes/v1/pesquisa?",
              `JSON={ "tabela":"TABPADRAO", 
                    "camposSelect":["VALOR"], 
                    "where": ["TABELA = 'RECEBER'", "CAMPO = 'CONTA'"]}`,
              null
            );

            let jsonConta = await respostaConta.json();

            if (jsonConta.RESULT[0].length > 0) {
              insereValor('#txtConta', jsonConta.RESULT[0][0].VALOR, jsonConta.RESULT[0][0].VALOR);
            }
          }

          if (parametrosReceber[7].VALOR == 1) {

            if ($('#txtConta').val() != '') {
              $('#txtConta').prop('disabled', true);
              $('#btnConta').prop('disabled', true);
              $('#btn-limpa-Conta').prop('disabled', true);
            } else {
              $('#txtConta').prop('disabled', false);
              $('#btnConta').prop('disabled', false);
              $('#btn-limpa-Conta').prop('disabled', false);
            }
          }

        } catch (error) {
          console.log(error)
        }
      }
    } else {
      $('#txtClasse').val('')
      $('#txtConta').val('')
      $('#txtHistorico').val('')
    }
  });

  function habilitaTroco(possuiTroco = false) {
    if (possuiTroco) {
      $("#divTroco").removeClass("d-none");
      $("#divValorRecebido").removeClass("d-none");
    } else {
      $("#divTroco").addClass("d-none");
      $("#divValorRecebido").addClass("d-none");
    }
  };

  function calculaTroco() {
    const valorPago = parseFloat($("#txtTotalPago").val()).toFixed(2);
    let valorRecebido = parseFloat($('#txtValorRecebido').val())
    if (isNaN(valorRecebido)) {
      valorRecebido = 0;
    }
    const troco = (valorRecebido - valorPago) > 0 ? (valorRecebido - valorPago) : 0;
    if (isNaN(troco)) {
      troco = 0;
    }
    $("#txtTroco").val(
      parseFloat(troco).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  };

  $('#txtValorRecebido').on('blur', function () {
    calculaTroco();
    $("#txtValorRecebido").val(
      parseFloat($(this).val()).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  });

  async function moedaPossuiTroco(moeda) {
    try {
      $.LoadingOverlay('show');
      try {
        let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"MOEDA", "camposSelect":["GERA_TROCO"],"where": ["CODMOE = '${moeda}'"]}`, null);

        if (!response) {
          return;
        }

        let jsonMoeda = await response.json();
        if (response.status != 200) {
          jsonMoeda['RESULT'][0].mensagem;
          return;
        }
        if (jsonMoeda['RESULT'][0][0]['GERA_TROCO'] == 'S') {
          return true;
        } else {
          return false;
        }

      } catch (error) {
        console.error(error);
        msgErro('Erro ao buscar os dados da moeda!' + error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function montaJsonTef(codMoeda) {
    try {
      const pesquisa = {
        tabela: 'MOEDA',
        camposSelect: ['TEF', 'TIPO_CARTAO'],
        where: [`CODMOE = ${codMoeda}`]
      }
      //adicionar where dos filtros
      const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      const dados = {
        formaPagamento: [{
          Tipo_Cartao: json[0].TIPO_CARTAO,
          Qtde_Parcela: pegaChave('#txtNrParcelas'),
          UsaTEF: json[0].TEF == 'S',
          ImprimeGR: false,
          Valor: parseFloat($("#txtTotalPago").val()).toFixed(2),
          DescricaoMoeda: pegaDescricao('#txtMoeda'),
          CodCondivenda: '',
          CodMoedaECF: '',
        }]
      }

      return dados;

    } catch (error) {
      console.error(error);
    }
  }

  async function verificaChamaTef() {
    try {
      const json = await montaJsonTef(pegaChave('#txtMoeda'));
      const url = '/tef/vendamanualtef?';
      const response = await requisicao_ecf('POST', url, '', JSON.stringify(json), 90000);

      if (!response) {
        return false;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return false;
      }

      return true;

    } catch (error) {
      console.error(error);
    }
  }

  async function verificaMoeda() {
    const moeda = pegaChave("#txtMoeda");
    const _url = "/sisplan/funcoes/v1/pesquisa?";
    const _json = `JSON={"tabela": "MOEDA", "camposSelect": ["TIPO", "TEF", "CLASSE", "HISTORICO", "DESC_AUTO"], "where": ["CODMOE = ${moeda}"]}`;
    try {
      const response = await requisicao("GET", _url, _json, null);
      if (!response) {
        $("#divNSU").addClass("d-none");
        $("#divCondicoesDePagamento").addClass("d-none");
        return;
      }
      if (response.status != 200) {
        $("#divNSU").addClass("d-none");
        $("#divCondicoesDePagamento").addClass("d-none");
        return;
      }
      let jsonStr = await response.json();

      if (parametrosReceber[9].VALOR == 1) {
        aplicaDescAuto(jsonStr.RESULT[0][0].DESC_AUTO);
      }

      $('#txtClasse').val('');
      $('#txtHistorico').val('');

      try {
        let respostaHist = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"histcp", 
                "camposSelect":["descricao"], 
                "where": ["historico = '${jsonStr.RESULT[0][0].HISTORICO}'"]}`,
          null
        );

        let jsonHist = await respostaHist.json();

        insereValor(
          $("#txtHistorico"),
          jsonStr.RESULT[0][0].HISTORICO,
          jsonHist.RESULT[0][0].DESCRICAO
        );
        // insereValor(
        //   $("#txtHistoricoBaixa"),
        //   jsonStr.RESULT[0][0].HISTORICO,
        //   jsonHist.RESULT[0][0].DESCRICAO
        // );
      } catch (error) {
        console.error(error);
      }

      try {
        let respostaClasse = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"classe_ger", 
                "camposSelect":["descricao"], 
                "where": ["codigo = '${jsonStr.RESULT[0][0].CLASSE}'"]}`,
          null
        );

        let jsonClasse = await respostaClasse.json();

        insereValor(
          $("#txtClasse"),
          jsonStr.RESULT[0][0].CLASSE,
          jsonClasse.RESULT[0][0].DESCRICAO
        );
        insereValor(
          $("#txtClasseBaixa"),
          jsonStr.RESULT[0][0].CLASSE,
          jsonClasse.RESULT[0][0].DESCRICAO
        );
      } catch (error) {
        console.error(error);
      }

      // if (parametrosReceber[7].VALOR == 1) {

      //   if ($('#txtMoeda').val() != '') {
      //     $('#txtClasse').prop('disabled', true);
      //     $('#btn-Classe').prop('disabled', true);
      //     $('#btn-limpa-Classe').prop('disabled', true);
      //   } else {
      //     $('#txtClasse').prop('disabled', false);
      //     $('#btn-Classe').prop('disabled', false);
      //     $('#btn-limpa-Classe').prop('disabled', false);
      //   }

      //   if ($('#txtMoeda').val() != '') {
      //     $('#txtHistorico').prop('disabled', true);
      //     $('#btn-Historico').prop('disabled', true);
      //     $('#btn-limpa-Historico').prop('disabled', true);
      //   } else {
      //     $('#txtHistorico').prop('disabled', false);
      //     $('#btn-Historico').prop('disabled', false);
      //     $('#btn-limpa-Historico').prop('disabled', false);
      //   }
      // }

      // if (jsonStr.RESULT[0][0].TIPO == "3" && jsonStr.RESULT[0][0].TEF != "S") {
      if (jsonStr.RESULT[0][0].TIPO == "3") {
        $("#divNSU").removeClass("d-none");
        $("#divCondicoesDePagamento").removeClass("d-none");
        $('#cbNaoLancaCc').prop('checked', true);
        $('#cbNaoLancaCc').prop('disabled', true);
      } else {
        $("#divNSU").addClass("d-none");
        $("#divCondicoesDePagamento").addClass("d-none");
        $('#cbNaoLancaCc').prop('checked', false);
        $('#cbNaoLancaCc').prop('disabled', false);
      }
    } catch (error) {
      console.error(error);
    }

  }

  async function VinculaCaixaComUsuario() {
    const _url = "/sisplan/funcoes/v1/pesquisa?";
    const nomeUsuario =
      getCookie("cod_usuario") == "0000" ? "SISPLAN" : getCookie("usuario");
    const _usuarioCaixa = `JSON={"tabela": "VENDA_CAIXA", 
          "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO"], 
          "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"],
          "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}]}`;
    try {
      const response = await requisicao("GET", _url, _usuarioCaixa, null);
      if (!response) {
        msgErro("Erro ao buscar caixas vinculados ao usuário.");
        return;
      }

      if (response.status == 200) {
        let jsonStr = await response.json();
        if (jsonStr.RESULT[0].length >= 1) {
          const sCaixa = `[${jsonStr.RESULT[0][0].NRCAIXA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
          sessionStorage.setItem("g_caixa_logado", sCaixa);
          // $("#txtCaixa").attr("disabled", true);
          // $("#btn-limpa-Caixa").addClass("d-none");
          // $("#btn-impostor").removeClass("d-none");
          // $("#btnCaixa").addClass("d-none");
          $("#btnCaixa").pesquisa(
            "#txtCaixa",
            "CODIGO",
            "DESCRICAO",
            `/sisplan/funcoes/v1/pesquisa?JSON={ 
              "tabela":"caixa_loja", 
              "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
              "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
              "where": ["VENDA_CAIXA.USUARIO = '${getCookie('usuario')}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
            }`,
            "Pesquisa Tabela",
            "CAIXA_LOJA"
          );

          $("#txtCaixa").autocompleta(
            1,
            `JSON={ 
              "tabela":"caixa_loja", 
              "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
              "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
              "where": ["VENDA_CAIXA.USUARIO = '${getCookie('usuario')}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
            }`
          );
        } else {
          $("#btnCaixa").pesquisa(
            "#txtCaixa",
            "CODIGO",
            "DESCRICAO",
            '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
            "Pesquisa Tabela",
            "CAIXA_LOJA"
          );

          $("#txtCaixa").autocompleta(
            1,
            `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`
          );
        }
      } else {
        msgErro("Erro ao buscar caixas vinculados ao usuário.");
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro("Erro ao buscar caixas vinculados ao usuário.");
    }
  }

  $("#btn-impostor").on("click", async function () {
    function abrePesquisaCaixa() {
      $("#btnCaixa").trigger("click");
    }
    await senhaSupervisor(`Usuário com caixa vinculado.`, abrePesquisaCaixa);
  });

  function atualizaTotais() {
    $("#txt_val_total").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(7).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_val").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(8).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_val_pago").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(9).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

    $("#txt_val_saldo").html(
      parseFloat(
        $("#tabelaReceber").DataTable().column(12).data().sum()
      ).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

  }

  // botoes do grid
  function botaoSelecionarGrid() {
    return (
      '<div class="form-check">' +
      '<input type="checkbox" class="align-self-center checkReceber" value"">' +
      "</div>"
    );
  }

  function retornaBotaoOpcoes(sNumero) {
    return (
      '   <div class="dropdown" width="200px!important"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      "      " + sNumero + " " +
      "    </button> " +
      '    <div class="dropdown-menu" style="min-width: 2rem; width:200px; text-align:left"> ' +
      '    <a id="btnEdit" class="dropdown-item" href="#"><i class="fas fa-edit"></i> Editar</a>' +
      '    <a id="btnVisualizar" class="dropdown-item" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg"><i class="far fa-eye"></i> Visualizar Baixas</a>' +
      '    <a id="btnItensVenda" class="dropdown-item" href="#" data-toggle="modal" data-target=".bd-itens-venda-modal-lg"><i class="far fa-list-alt"></i> Itens da Venda</a>' +
      '    <a id="btnExcluir" class="dropdown-item" href="#"> <i class="fas fa-trash"></i> Excluir</a>' +
      "    </div>" +
      "</div>"
    );

    //     '<div class="btnGridPrincipal"> ' +
    //     '  </div>' +
    // ' <div class="btnGrid btnEdit"> <i class="fas fa-edit" style="margin-left: 4px!important;"></i></div>' +
    // ' <div class="btnGrid btnVisualizar" data-toggle="modal" data-target=".bd-visualizar-modal-lg"> <i class="far fa-eye"></i></div>' +
    // ' <div class="btnGrid btnExcluir"> <i class="fas fa-trash"></i></div>' +
  }

  function retornaBotaoEstornar(data) {
    return (
      '<div style="text-align:center;"> ' +
      '   <div class="dropdown" width="150px!important"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      `      ${data}` +
      "    </button> " +
      '    <div class="dropdown-menu" style="min-width: 2rem; width:150px; text-align:left"> ' +
      '    <a id="btnEstornar" class="dropdown-item"  >Estornar</a>' +
      '    <a id="btnImprimirBaixaUnica" class="dropdown-item"  >Imprimir Baixa</a>' +
      "    </div>" +
      "  </div>" +
      "</div>"
    );
  }

  async function pegaValoresModalBaixa() {
    try {
      let table = $("#tabelaBaixar").DataTable();
      let rows = table.rows();
      let valores = [];
      let objeto = {};
      // pegar valor pago
      for (let i = 0; i < rows[0].length; i++) {
        objeto = {
          CODCLI: pegaChave("#txtClienteVisual"),
          NSU: $('#txtNsuVisual').val(),
          SALDO: $("#txtSaldoVisual", objeto.SALDO).val(),
          VALOR: $("#txtValorPagoVisual", objeto.VALOR).val(),
          DT_EMISSAO: `${$("#txtDTEmissaoVisual").val()}`,
          NOTAFISCAL: `${$("#txtNotaFiscalVisual").val()}`,
          NUMERO: rows.data()[i].NUMERO,
          LANCAMENTO: rows.data()[i].LANCAMENTO,
          DT_PAGTO: rows.data()[i].DT_PAGTO,
          VALOR_PAGO: rows.data()[i].VALOR_PAGO,
          MOEDA: rows.data()[i].MOEDA,
          DESC_MOEDA: rows.data()[i].DESC_MOEDA,
          DESCONTO: 0,
          JUROS: rows.data()[i].NUMERO,
        };

        valores.push(objeto);
        objeto = {};
      }

      return valores;

    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  $('#btnImprimirBaixasVisual').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      const nBaixas = await pegaValoresModalBaixa();
      let numeros = [];
      for (let i = 0; i < nBaixas.length; i++) {
        numeros.push(nBaixas[i].NUMERO);
      }

      const listaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
      $('#ModalVisualizarBaixa').modal('hide');
    }

  });

  $('#btnImprimirBaixas').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      let arrNumeros = [];
      const data = $("#tabelaReceber").DataTable().rows(".selected").data();

      data.map(item => { arrNumeros.push(item.NUMERO); });

      const listaNumeros = `'${arrNumeros.toString().replaceAll(",", "','")}'`;

      url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }

  });

  async function pegaValoresBaixaUnica(table) {
    try {
      lancamento = table.LANCAMENTO
      let valores = [];
      let objeto = {};
      // pegar valor pago
      objeto = {
        LANCAMENTO: lancamento,
      };

      valores.push(objeto);
      objeto = {};

      return valores;

    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  $("#tabelaBaixar").on("click", "#btnImprimirBaixaUnica", async function () {
    $.LoadingOverlay('show');
    try {
      const table = $('#tabelaBaixar').DataTable().row($(this).parents("tr")).data();

      const nBaixas = await pegaValoresBaixaUnica(table);

      let lancamento = [];
      for (let i = 0; i < nBaixas.length; i++) {
        lancamento.push(nBaixas[i].LANCAMENTO);
      }

      url = `/sisplan/impressao/v1/receber?LANCAMENTO=${lancamento}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
      arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
      if (arquivo != undefined && arquivo != "") {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
      $('#ModalVisualizarBaixa').modal('hide');
    }

  });

  async function buscaBaixas(numeroReceber) {
    let url = `/sisplan/Receber/v1/BaixaReceber?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `numero=${numeroReceber}`,
        null
      );

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
      let jsonStr = await response.json();
      jsonStr = jsonStr.map((retorno) => ({
        ...retorno,
        DT_PAGTO: retorno.DT_PAGTO.slice(0, 10),
      }));
      return jsonStr;
    } catch (error) {
      console.error(error);
      msgAlerta("Não Existem Baixas Cadastradas");
    }
  }

  async function rotinaDeletarReceber(data, pEstornar = "") {
    try {
      const estornar = pEstornar === "" ? "" : "&ESTORNAR=S";
      const response = await requisicao(
        "DELETE",
        "/Sisplan/receber/v1/receber?",
        `NUMERO=${data.NUMERO}&LANCAMENTO=${data.LANCAMENTO}&STATUS=${data.STATUS}&NOTAFATURA=${data.FATURA}${estornar}`,
        null
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      toastr
        .success("Duplicata Excluída com Sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            window.location.href = `${BASE_URI}/receber`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } catch (error) {
      console.error(error);
      msgErro("Erro ao excluir o registro.");
    }
  }

  $("#tabelaReceber").on("click", "#btnExcluir", async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      try {
        $.LoadingOverlay("show");
        const table = $("#tabelaReceber").DataTable();
        const data = table.row($(this).parents("tr")).data();
        const iLancamento = data.LANCAMENTO;

        try {
          const json = await retornaJsonPesquisaPadrao(
            `{ "tabela":"receberb", "camposSelect":["numero"], "where": ["lancamento = ${iLancamento}"] }`
          );
          const titulos = json.map((data) => data.NUMERO);

          if (json) {
            if (json.length > 0) {
              msgAlerta(
                `Existem baixas atreladas a esse título, ao excluir, será estornado as baixas dos títulos: ${titulos.toLocaleString()}. Deseja continuar?`,
                () => { },
                () => { },
                () => rotinaDeletarReceber(data, "S")
              );
              return;
            }
          }

          msgAlerta("Deseja realmente deletar esse Registro?", () =>
            rotinaDeletarReceber(data, "S")
          );
        } catch (error) {
          msgErro("Erro ao excluir título.");
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
        $("#btnConsultar").trigger("click");
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });



  async function buscaReceber() {
    const url = `/Sisplan/Receber/V1/Receber?`;
    const sNumero = $("#txtNumero").val();
    const sFatura = $("#txtFatura").val();
    const sDataEmiI = moment($("#txtDataEmiI").val()).format("DD/MM/YYYY");
    const sDataEmiF = moment($("#txtDataEmiF").val()).format("DD/MM/YYYY");
    const sDataVenctoI = moment($("#txtVenctoI").val()).format("DD/MM/YYYY");
    const sDataVenctoF = moment($("#txtVenctoF").val()).format("DD/MM/YYYY");
    const sDataPagamentoI = moment($("#txtPagamentoI").val()).format("DD/MM/YYYY");
    const sDataPagamentoF = moment($("#txtPagamentoF").val()).format("DD/MM/YYYY");
    const sCliente = await formataListas($('#txtClienteConsulta').val().toString());
    const sRepresentante = $("#txtRepresentanteConsulta")
      .val()
      .substring(1, $("#txtRepresentanteConsulta").val().indexOf("] - "));
    const sMoeda = pegaChave("#txtMoedaConsulta");
    const sCartaoPresente = pegaValor("#txtCartaoPresente");
    const sStatus = $("#Status").val() === 'TODOS' ? '' : $("#Status").val();
    const sSituacao = $("#txtSituacao").val();
    const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const sClasseGer = pegaChave("#txtClasseGerConsulta");
    const sNumeroCaixa = pegaChave('#txtNumeroCaixa');
    let sParams = `NUMERO=${sNumero}&FATURA=${sFatura}&DTEMISSAOI=${sDataEmiI}&DTEMISSAOF=${sDataEmiF}&DTVENCIMENTOI=${sDataVenctoI}&DTVENCIMENTOF=${sDataVenctoF}` +
      `&STATUS=${sStatus}&CLIENTE=${sCliente}&REPRESENTANTE=${sRepresentante}&SITUACAO=${sSituacao}&MOEDA=${sMoeda}&CARTAO_PRESENTE=${sCartaoPresente}` +
      `&EMP_ID=${sEmpID}&DTPAGAMENTOI=${sDataPagamentoI}&DTPAGAMENTOF=${sDataPagamentoF}&CLASSEGER=${sClasseGer}&NRCAIXA=${sNumeroCaixa}`;

    try {
      let response = await requisicao("GET", url, sParams, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }

      let jsonStr = await response.json();

      for (let i = 0; i < jsonStr.length; i++) {
        const taxa = parseFloat(jsonStr[i].TAXA);
        if (taxa > 0) {
          const dias = jsonStr[i].DIAS;
          const dataVencto = new Date(`${jsonStr[i].DT_VENCTO} 00:00:00`);
          const date = new Date();
          let diasVencto =
            (date.getTime() - dataVencto.getTime()) / (1000 * 3600 * 24);
          if (diasVencto < 0) {
            diasVencto = 0;
          }
          diasVencto = Math.trunc(diasVencto);

          let juros = 0;
          if (diasVencto > dias) {
            juros = (jsonStr[i].SALDO / 100) * ((taxa / 30) * diasVencto);
            if (isNaN(juros)) {
              juros = 0;
            }

            if (jsonStr[i].EMP_MULTA > 0) {
              juros = ((jsonStr[i].SALDO / 100) * jsonStr[i].EMP_MULTA) + juros;
            }
          }
          jsonStr[i].JUROS = juros > 0 ? juros.toFixed(2) : juros;
        }
      }

      jsonStr.map((item) => {
        item.SALDOTOTAL = item.JUROS != '' ? (parseFloat(item.JUROS) + item.SALDO) : item.SALDO;
      });

      return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados.");
    }
  }

  // selecionar grid
  $("#tabelaReceber").on("click", "td", function () {
    selecionarLinhaTabela("#tabelaReceber", "checkReceber", this);
    atualizaTotalSelecionadas();

    if ($("#tabelaReceber").DataTable().rows(".selected").data().length <= 0) {
      $("#btnBaixar").prop("disabled", true);
      $("#btnBaixarComAntecipacao").prop("disabled", true);
    }
  });

  function dataMesAtual(dateString) {
    const dateParts = dateString.split("/");
    const day = parseInt(dateParts[0], 10);
    const month = parseInt(dateParts[1], 10) - 1;
    const year = parseInt(dateParts[2], 10);
    const dateToCheck = new Date(year, month, day);

    const currentDate = new Date();
    return (
      dateToCheck.getMonth() === currentDate.getMonth() &&
      dateToCheck.getFullYear() === currentDate.getFullYear()
    );
  }

  function removeColunasExcel() {
    let retorno;
    retorno = `
    for (let i = 0; i < dados.length; i++) {
      delete dados[i]['CODREP'];
      delete dados[i]['LANCAMENTO'];
      delete dados[i]['EMP_ID'];
      delete dados[i]['EMP_ID_1'];
      delete dados[i]['CLASSE'];
      delete dados[i]['OBS'];
      delete dados[i]['NRO_CUPOM'];
      delete dados[i]['DIAS'];
      delete dados[i]['TAXA'];
  }
    `;

    return retorno
  }

  $("#btnConsultar").on("click", async function () {
    try {
      $.LoadingOverlay("Show");
      try {
        let jsonStr = await buscaReceber();

        let dataCols = [{
          title: 'Sel',
          data: 'SEL'
        },
        {
          title: 'Número',
          data: 'NUMERO'
        },
        {
          title: 'Fatura',
          data: 'FATURA'
        },
        {
          title: 'Cod Cli.',
          data: 'CODCLI'
        },
        {
          title: 'Cliente',
          data: 'CLIENTE'
        },
        {
          title: 'Data Emissão',
          data: "DT_EMISSAO",
        },
        {
          title: 'Data Vencimento',
          data: "DT_VENCTO",
        },
        {
          title: 'Valor Total',
          data: "VALOR",
        },
        {
          title: 'Valor',
          data: "VALOR2",
        },
        {
          title: 'Valor Pago',
          data: "VALOR_PAGO",
        },
        {
          title: 'Desconto',
          data: "DESCONTO",
        },
        {
          title: 'Juros',
          data: "JUROS",
        },
        {
          title: 'Saldo',
          data: "SALDO",
        },
        {
          title: 'Status',
          data: "STATUS",
        },
        {
          title: 'NSU',
          data: "CARTAO_NSU",
        },
        {
          title: 'Empresa',
          data: "EMP_PAT",
        },
        {
          title: 'Emp_Multa',
          data: "EMP_MULTA",
        },
        {
          title: 'Caixa',
          data: "CAIXA",
        },
        {
          title: 'Moeda',
          data: "MOEDA",
        },
        {
          title: 'Desc_moeda',
          data: "DESC_MOEDA"
        },
        ]

        let table = $("#tabelaReceber").DataTable({
          destroy: true,
          sort: true,
          colReorder: {
            fixedColumnsLeft: 2
          },
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            language: {
              decimal: ",",
              thousands: ".",
            },
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          order: [[6, "asc"]],
          data: jsonStr,
          columns: dataCols,
          columnDefs: [
            {
              type: "date-br",
              render(data) {
                return new Intl.DateTimeFormat("pt-BR").format(
                  new Date(`${data.split(" ")[0]} 23:59:59`)
                );
              },
              targets: 5,
            },
            {
              type: "date-br",
              render(data, type, row) {
                x = data.slice(0, 10).split("-");
                let icone = "";
                const dataVencimento = new Date(`${row.DT_VENCTO} 23:59:59`);
                if (dataVencimento < new Date()) {
                  icone =
                    '<i class="fas fa-history iconeVencido" style="color: red" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
                } else {
                  icone =
                    '<i class="fas fa-history" style="display: none" data-toggle="tooltip" data-placement="top" title="Título vencido"></i>';
                }
                const retornaData = new Intl.DateTimeFormat("pt-BR").format(
                  new Date(`${data.split(" ")[0]} 23:59:59`)
                );
                return (dataMesAtual(retornaData)) ? `<span title="Vencimento dentro do mês atual" style="color: red">${retornaData}</span> ${icone}`
                  : `<span>${retornaData}</span> ${icone}`;
              },
              targets: 6,
            },
            {
              className: "ColunaVermelha",
              targets: 12,
              render(data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  minimumFractionDigits: 2,
                });
              },
            },
            {
              render(data) {
                return parseFloat(data).toLocaleString("pt-br", {
                  minimumFractionDigits: 2,
                });
              },
              targets: [7, 8, 9, 10, 11],
            },
            {
              render(data, type, row) {
                return retornaBotaoOpcoes(row.NUMERO);
              },
              targets: 1,
            },
            {
              targets: 0,
              data: null,
              defaultContent: botaoSelecionarGrid(),
            },

          ],
        });

        $('#tabelaReceber tbody tr td [data-toggle="tooltip"]').tooltip();

        $(document).on("click", ".paginate_button", function () {
          $('#tabelaReceber tbody tr td [data-toggle="tooltip"]').tooltip();
        });

        atualizaTotais();
        atualizaTotalSelecionadas();

        $("#tabelaReceber").on("click", "#btnEdit", async function () {
          if ((permissaoUsuarioLogado.ALTERA == "S")) {
            const data = table.row($(this).parents("tr")).data();
            const receberLiberado = await verificarRegistro(
              "RECEBER",
              data.NUMERO
            );
            if (receberLiberado) {
              // if (data.VALOR_PAGO > 0) {
              //   msgAlerta('Duplicata já possui baixa, impossível alterar.');
              //   return;
              // }

              const novoNumero = btoa(data.NUMERO);
              window.location.href = `receber/${novoNumero}`;
            }
          } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
          }
        });
        $("#tabelaReceber").on("click", ".btnOpcao", async function () {
          $(".checkReceber").prop("checked", false);
          $("tr").removeClass("selected");
        });
        $("#modal-filtros").modal("hide");
        $("#btnBaixar").prop("disabled", true);
        $("#btnBaixarComAntecipacao").prop("disabled", true);

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaReceber_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaReceber_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = `/Sisplan/Receber/V1/Receber?`;
          const filtros = await retornaFiltros();
          const removeColunas = removeColunasExcel();
          await exportaCSV(url, filtros, false, null, 'Relatório de Receber', '#tabelaReceber', removeColunas);
        })

        $('#tabelaReceber').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.acessoReceber).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )
      } catch (error) {
        console.error(error);
        msgErro("Erro ao buscar as Baixas");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaReceber').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    const colunasVisiveis = cols.slice(2)
    adicionaColunas(colunasVisiveis, colunasInvisiveis.acessoReceber ?? [''])
  })

  async function retornaFiltros() {
    const sNumero = $("#txtNumero").val();
    const sFatura = $("#txtFatura").val();
    const sDataEmiI = moment($("#txtDataEmiI").val()).format("DD/MM/YYYY");
    const sDataEmiF = moment($("#txtDataEmiF").val()).format("DD/MM/YYYY");
    const sDataVenctoI = moment($("#txtVenctoI").val()).format("DD/MM/YYYY");
    const sDataVenctoF = moment($("#txtVenctoF").val()).format("DD/MM/YYYY");
    const sDataPagamentoI = moment($("#txtPagamentoI").val()).format("DD/MM/YYYY");
    const sDataPagamentoF = moment($("#txtPagamentoF").val()).format("DD/MM/YYYY");
    const sCliente = await formataListas($('#txtClienteConsulta').val().toString());
    const sRepresentante = $("#txtRepresentanteConsulta")
      .val()
      .substring(1, $("#txtRepresentanteConsulta").val().indexOf("] - "));
    const sMoeda = pegaChave("#txtMoedaConsulta");
    const sCartaoPresente = pegaValor("#txtCartaoPresente");
    const sStatus = $("#Status").val() === 'TODOS' ? '' : $("#Status").val();
    const sSituacao = $("#txtSituacao").val();
    const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const sClasseGer = pegaChave("#txtClasseGerConsulta");
    const sNumeroCaixa = pegaChave('#txtNumeroCaixa');

    const filtros = `NUMERO=${sNumero}&FATURA=${sFatura}&DTEMISSAOI=${sDataEmiI}&DTEMISSAOF=${sDataEmiF}&DTVENCIMENTOI=${sDataVenctoI}&DTVENCIMENTOF=${sDataVenctoF}` +
      `&STATUS=${sStatus}&CLIENTE=${sCliente}&REPRESENTANTE=${sRepresentante}&SITUACAO=${sSituacao}&MOEDA=${sMoeda}&CARTAO_PRESENTE=${sCartaoPresente}` +
      `&EMP_ID=${sEmpID}&DTPAGAMENTOI=${sDataPagamentoI}&DTPAGAMENTOF=${sDataPagamentoF}&CLASSEGER=${sClasseGer}&NRCAIXA=${sNumeroCaixa}`;

    return filtros;
  };

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABPADRAO.TABELA = 'RECEBER'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(async item => {
      switch (item.CAMPO) {
        case 'CLASSE': {
          insereValor('#txtClasseGerConsulta', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'MOEDA': {
          insereValor('#txtMoedaConsulta', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'STATUS': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#Status').val(item.VALOR).change();
          } else {
            $('#Status').val('DUPL').change();
          }

          break;
        }
        case 'SITUACAO': {
          if (item.VALOR !== '' && item.VALOR !== null) {
            $('#txtSituacao').val(item.VALOR).change();
          } else {
            $('#txtSituacao').val('Em Aberto').change();
          }

          break;
        }
        case 'EMISSAO_DE': {
          if (item.VALOR == 'S') {
            $('#txtDataEmiI').val(dataString);
          } else {
            $('#txtDataEmiI').val();
          }

          break;
        }

        case 'VENCIMENTO_DE': {
          if (item.VALOR == 'S') {
            $('#txtVenctoI').val(dataString);
          } else {
            $('#txtVenctoI').val();
            $("#btnFiltros").one("click", function (e) {
              $("#txtVenctoI").val("1200-01-01");
              $("#txtVenctoF").val("2500-12-01");
            });
          }

          break;
        }

        case 'PAGAMENTO_DE': {
          if (item.VALOR == 'S') {
            $('#txtPagamentoI').val(dataString);
          } else {
            $('#txtPagamentoI').val();
          }

          break;
        }
      }
    });
  }

  $("#tabelaReceber").on("click", "#btnVisualizar", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let table = $("#tabelaReceber").DataTable();
        let nsu;
        let data = table.row($(this).parents("tr")).data();

        let jsonStr = await buscaBaixas(data.NUMERO);

        $("#tabelaBaixar").DataTable({
          destroy: true,

          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: [
            {
              data: "NUMERO",
            },
            {
              data: "LANCAMENTO",
            },
            {
              data: "DT_PAGTO",
            },
            {
              data: "VALOR2",
            },
            {
              data: "VALOR_PAGO",
            },
            {
              data: "MOEDA",
            },
            {
              data: "DESC_MOEDA",
            },
            {
              data: "DESCONTO",
            },
            {
              data: "JUROS",
            },
            {
              data: "VAL_DEV",
            },
          ],
          columnDefs: [
            {
              targets: [0], render: function (data, type, row) {
                return retornaBotaoEstornar(data);
              }
            },
            {
              render: $.fn.dataTable.render.moment(FormatoDtNovo),
              targets: 2,
            },
            {
              targets: 3,
              visible: false,
            },
          ],
        });

        try {
          let response;
          response = await requisicao(
            "GET",
            "/sisplan/funcoes/v1/pesquisa?",
            `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.CODCLI", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = RECEBER.CODCLI"}], "where": ["RECEBER.NUMERO = '${data.NUMERO}'"]}`,
            null
          );

          if (!response) {
            cliente = "";
            return;
          }

          jsonStr = await response.json();
          if (response.status != 200) {
            return;
          }

          cliente = `[${jsonStr.RESULT[0][0].CODCLI}] - ${jsonStr.RESULT[0][0].NOME}`;
        } catch (error) {
          console.error(error);
          cliente = "";
        }

        try {
          let response;
          response = await requisicao(
            "GET",
            "/sisplan/funcoes/v1/pesquisa?",
            `JSON={ "tabela":"RECEBER", "camposSelect":["CARTAO_NSU"], "where": ["NUMERO = '${data.NUMERO}'"]}`,
            null
          );

          if (!response) {
            nsu = "";
            return;
          }

          jsonStr = await response.json();
          if (response.status != 200) {
            return;
          }

          nsu = `${jsonStr.RESULT[0][0].CARTAO_NSU}`;
        } catch (error) {
          console.error(error);
          nsu = "";
        }

        $("#txtClienteVisual").val(cliente);
        $("#txtDTemissaoVisual").val(data.DT_EMISSAO.slice(0, 10));
        $("#txtNotaFiscalVisual").val(data.FATURA);
        $("#txtSaldoVisual").val(data.SALDO);
        $("#txtValorPagoVisual").val(data.VALOR);
        $("#txtNsuVisual").val(nsu);
      } catch (error) {
        console.error(error);
        msgErro(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#tabelaReceber").on("click", "#btnItensVenda", async function () {
    $.LoadingOverlay("show");
    try {

      const data = $("#tabelaReceber").DataTable().row($(this).parents("tr")).data();

      const pesquisaParam = {
        tabela: 'ITVENDA',
        camposSelect: [
          'ITVENDA.CODIGO', `CASE ITVENDA.TIPO WHEN 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`,
          'ITVENDA.COR', 'CADCOR.DESCRICAO DESC_COR', 'ITVENDA.TAM', 'ITVENDA.VALOR'
        ],
        leftJoin: [
          { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = ITVENDA.CODIGO' },
          { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = ITVENDA.CODIGO' },
          { tabela: 'CADCOR', condicao: 'CADCOR.COR = ITVENDA.COR' }
        ],
        where: [`ITVENDA.CODVEN = ${data.NRO_CUPOM}`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if ((jsonStr.length == 0) || (data.NRO_CUPOM == 0)) {
        msgAlerta('Duplicata não originada de uma venda.', null, null, () => { $('#modalItensVenda').modal('hide'); }, () => { $('#modalItensVenda').modal('hide'); });
        return;
      }

      let dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      criaDataTablePadrao('#tabelaItensVenda', false, false, false, false, true, true, '300px', jsonStr, dataSetCols, [], [], [5]);

      insereValor('#txtNumeroItens', data.NUMERO);
      insereValor('#txtVenda', data.NRO_CUPOM);

    } catch (error) {
      console.error(error);
      msgErro(error);
    }
    finally {
      $.LoadingOverlay("hide");
      setTimeout(() => {
        $("#tabelaItensVenda").DataTable().columns.adjust().draw(false);
      }, 200);
    }
  });

  $('#btnImprimirItens').on('click', async function () {
    event.preventDefault();
    await imprimirRomaneio(pegaValor('#txtVenda'), BASE_URI);
  });

  $("#tabelaBaixar").on("click", "#btnEstornar", async function () {
    try {
      $.LoadingOverlay("show");
      let table = $("#tabelaBaixar").DataTable();
      let data = table.row($(this).parents("tr")).data();
      try {
        pNumero = data.NUMERO;
        pLancamento = data.LANCAMENTO;
        let response = await requisicao(
          "POST",
          "/Sisplan/receber/V1/Estornar?",
          `LANCAMENTO=${pLancamento}&NUMERO=${pNumero}`
        );

        if (!response) {
          return;
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        $("#txtSaldoVisual").val(
          parseFloat($("#txtSaldoVisual").val()) + parseFloat(data.VALOR_PAGO)
        );

        // table.rows().remove().draw(false);
        table.row($(this).parents("tr")).remove().draw(false);

        toastr
          .success("Baixa estornada com Sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#btnConsultar").trigger("click");
    }
  });

  $("#modalBaixarComAntecipacao").on("hidden.bs.modal", function () {
    $("#txtClasseAnt").val("");
    $("#txtHistoricoAnt").val("");
  });

  // $('#modalBaixar').on('show.bs.modal', function () {
  //   $('#txtClasse').prop('disabled', false);
  //   $('#txtConta').prop('disabled', false);
  //   $('#txtHistorico').prop('disabled', false);
  // })

  $("#modalBaixar").on("hidden.bs.modal", function () {
    $("#divNSU").addClass("d-none");
    $("#divCondicoesDePagamento").addClass("d-none");
    $("#txtNsu").val("");
    $("#select_bandeira").val("").change();
    $("#txtMoeda").val("");
    $("#txtConta").val("");
    $("#checkCaixa").prop("checked", lancaCaixa);
    $("#txtClasse").val("");
    // $("#txtClasseBaixa").val("");
    $("#txtHistorico").val("");
    // $("#txtHistoricoBaixa").val("");
    $("#btnConsultar").trigger("click");
    $("#checkCaixa").prop("disabled", false);
    $("#checkCaixa").prop("checked", false);
    $("#lancaCaixa").addClass("d-none");
    // $("#divMoeda").removeClass("col-lg-6");
    // $("#divMoeda").addClass("col-lg-9");
    $("#txtTotalDesconto").val("");
    $("#txtTotalJuros").val("");
    $("#txtValorRecebido").val("");
    $("#txtTroco").val("");
    habilitaTroco();
  });

  async function addBandeira() {
    var dados = await RetornaBandeiras();
    for (const bandeira of dados) {
      var optionText = bandeira.DESCRICAO;
      var optionValue = bandeira.DESCRICAO;
      $('#select_bandeira').append(`<option value="${optionValue}">
                                                 ${optionText}
                                              </option>`);

    }
  };

  async function RetornaBandeiras() {
    var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
    var _params = `JSON={ "tabela":"bandeira", "camposSelect":["id_bandeira", "descricao"], "where": ["ativo = 'S'"], "orderby": ["ordem","descricao"]}`;

    try {
      var response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem)
        return;
      }
      return jsonStr['RESULT'][0];
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as bandeiras de cartões');
    }
  };

  async function carregaBaixas(numeros) {
    try {
      let response;
      let jsonStr;
      const sEmpID = $('#checkTodasEmpresas').prop('checked') == false ? getCookie('emp_id') : $('.empresa_selecionada:checked').toArray().length > 0
        ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : getCookie('emp_id');

      response = await requisicao(
        "GET",
        "/Sisplan/Receber/v1/Receber?",
        `LISTANUMERO=${numeros}&EMP_ID=${sEmpID}`
      );

      if (!response) {
        return;
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        console.error(error);
        msgErro("Erro ao buscar as duplicatas!");
        return;
      }
      $("#txtCaixa").val("");
      $("#txtMoeda").val("");
      if ($("#checkCaixa").prop("checked") == true) {
        $("#checkCaixa").trigger("click");
      }
      if (lancaCaixa) {
        $("#checkCaixa").trigger("click");
      }
      if (!podeAlterarCheck) {
        $("#checkCaixa").prop("disabled", true);
      }

      await $("#tabelaBaixarContas").DataTable({
        order: false,
        paging: false,
        filter: false,
        destroy: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        data: jsonStr,
        columns: [
          {
            data: "NUMERO",
          },
          {
            data: "CODCLI",
          },
          {
            data: "CLIENTE",
          },
          {
            data: null,
          },
          {
            data: null,
          },
          {
            data: null,
          },
          {
            data: "VALOR2",
          },
          {
            data: null,
          },
          {
            data: "SALDO",
          },
          {
            data: "DT_VENCTO",
          },
          {
            data: null,
          },
        ],
        columnDefs: [
          {
            render(data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });
            },
            targets: [6, 8],
          },
          {
            targets: 3,
            data: null,
            defaultContent: retornaInputs(true, false, false, false),
          },
          {
            targets: 4,
            data: null,
            defaultContent: retornaInputs(false, false, false, true),
          },
          {
            targets: 5,
            data: null,
            defaultContent: retornaInputs(false, true, false, false),
          },
          {
            targets: 7,
            data: null,
            defaultContent: retornaInputs(false, false, true, false),
          },
          {
            type: "date-br",
            render(data) {
              return new Intl.DateTimeFormat("pt-BR").format(
                new Date(`${data.split(" ")[0]} 23:59:59`)
              );
            },
            targets: 9,
          },
          {
            targets: 10,
            data: null,
            defaultContent: retornaInputs(false, false, false, false, true),
          }
        ],
      });

      // executa isso depois de carregar o datatable
      let countRow = $("#tabelaBaixarContas").DataTable().rows().count();
      let tableBaixar = $("#tabelaBaixarContas").DataTable().rows().data();
      for (let i = 0; i < countRow; i++) {
        const taxa = parseFloat(jsonStr[i].TAXA);
        if (taxa > 0) {
          const dias = jsonStr[i].DIAS;
          const dataVencto = new Date(`${tableBaixar[i].DT_VENCTO} 00:00:00`);
          const date = new Date();
          let diasVencto =
            (date.getTime() - dataVencto.getTime()) / (1000 * 3600 * 24);
          if (diasVencto < 0) {
            diasVencto = 0;
          }
          diasVencto = Math.trunc(diasVencto);

          let juros = 0;
          if (diasVencto > dias) {
            juros = (jsonStr[i].SALDO / 100) * ((taxa / 30) * diasVencto);
            if (isNaN(juros)) {
              juros = 0;
            }

            if (jsonStr[i].EMP_MULTA > 0) {
              juros = ((jsonStr[i].SALDO / 100) * jsonStr[i].EMP_MULTA) + juros;
            }
          }
          $($(".txtJuros")[i]).val(juros.toFixed(2));
        }

        $($(".txtvalorPago")[i]).val(tableBaixar[i].SALDO);
        $($(".txtvalorPago")[i]).attr("data-valor-old", tableBaixar[i].SALDO);
      }

      const listaMoedasCliente = await verificaMoedasCliente(jsonStr[0].CODCLI);

      if (listaMoedasCliente.length > 0) {
        $("#txtMoeda").autocompleta(
          1,
          `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": ["CODMOE IN (${listaMoedasCliente})"]}`,
          ["#txtTipoMoeda"],
          ["TIPO"],
          ["TIPO"]
        );

        $("#btnMoeda").pesquisa_array(
          ["#txtMoeda", "#txtTipoMoeda"],
          ["CODMOE", "TIPO"],
          ["DESCRICAO", "TIPO"],
          `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO", "TIPO"], "where": ["CODMOE IN (${listaMoedasCliente})"]}`,
          "Pesquisa Moeda",
          "MOEDA"
        );
      } else {
        $("#txtMoeda").autocompleta(
          1,
          `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao descricao", "tipo"], "where": null}`,
          ["#txtTipoMoeda"],
          ["TIPO"],
          ["TIPO"]
        );

        $("#btnMoeda").pesquisa_array(
          ["#txtMoeda", "#txtTipoMoeda"],
          ["CODMOE", "TIPO"],
          ["DESCRICAO", "TIPO"],
          '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "descricao", "TIPO"]}',
          "Pesquisa Moeda",
          "MOEDA"
        );

      }

      $("#txtMoeda").on("blur", async function () {

        if ($("#txtMoeda").val() == "") {
          $("#divNSU").addClass("d-none");
          $("#divCondicoesDePagamento").addClass("d-none");
          return;
        }
        await verificaMoeda();
        atualizaValorPago();
        atualizaValorTotal();
        atualizaTotalDesconto();
        atualizaTotalJuros();
        calculaTroco();

        const usaTef = await verificaMoedaTef(pegaChave('#txtMoeda'));
        const possuiTroco = await moedaPossuiTroco(pegaChave('#txtMoeda'));
        if (usaTef) {
          $("#divNSU").addClass("d-none");
        }
        if (!$("#divCondicoesDePagamento").hasClass('d-none')) {
          $('#txtCondicaoDePagamento').focus();
        } else if (!usaTef) {
          if (!$('#divNSU').hasClass('d-none')) {
            $('#txtNsu').focus();
          }
        }
        habilitaTroco(possuiTroco);
      });

      $(".valoresInput")
        .inputmask("numeric", {
          min: 0,
          positionCaretOnClick: "select",
          digits: 2,
        })
        .on("focus", function () {
          let that = $(this);
          setTimeout(function () {
            that.select();
          }, 1);
        });
    } catch (error) {
      console.error(error);
    }
  }

  async function validaDadosABaixar(dados) {
    let dadosValidados = [];
    const validaJaBaixado = async (dado) => {
      if (dado.VALOR2 == dado.VALOR_PAGO) {
        msgAlertaSemConfirmacao(`Numero: ${dado.NUMERO} já está baixada!`);
        return false;
      }
      return true;
    };
    const validaDesdobradoOuAgrupado = async (dado) => {
      if (dado.STATUS === "DESD" || dado.STATUS === "AGRU") {
        await msgAlertaSemConfirmacao(
          `Numero: ' ${dado.NUMERO} ' é um documento que foi Desdobrado/Agrupado para outro documento, impossível Continuar. `,
          "modalBaixar"
        );
        return false;
      }
      return true;
    };
    const validaTipoCheque = async (dado) => {
      if (dado.STATUS === "CHCA") {
        await msgAlertaSemConfirmacao(
          `Numero: ${dado.NUMERO} é um título de Cheque. Impossível Baixar.`,
          "modalBaixar"
        );
        return false;
      }
      return true;
    };
    const validaTipoAntecipacao = async (dado) => {
      if (dado.STATUS === "ANTE") {
        await msgAlertaSemConfirmacao(
          `Numero: ${dado.NUMERO} é um título de Antecipação. Impossível Baixar. `,
          "modalBaixar"
        );
        return false;
      }
      return true;
    };

    if (dados.filter(dado => dado.CODCLI != dados[0].CODCLI).length > 0) {
      await msgAlertaSemConfirmacao(
        `Não é possível realizar baixa com antecipação para clientes diferentes, verifique.`,
        "modalBaixar"
      );
      return false;
    }

    dadosValidados = false;
    for (let i in dados) {
      if ((await validaJaBaixado(dados[i]))
        && (await validaDesdobradoOuAgrupado(dados[i]))
        && (await validaTipoCheque(dados[i]))
        && (await validaTipoAntecipacao(dados[i]))) {
        dadosValidados = true;
      } else {
        return false;
      }
    };
    return dadosValidados;
  }

  async function carregaTabelaAntecipacaoSelecaoManual(dataSet, dataSetCols) {
    if (!$.isEmptyObject(dataSet[0])) {
      const keys = Object.keys(dataSet[0]);
      for (let k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }
      const array_colunas_invisiveis = [6, 7];

      dataSetCols[0].render = function (data, type, row, meta) {
        $('.campoCheckManual').unbind('change');
        const sProp = (row.VALOR_PAGO > 0) ? 'checked' : '';

        return `${'<div class="group-default form-group">' +
          '<div class="relative">' +
          '<input '}${sProp}  style="height:15px" type="checkbox" id="check_col_${[meta.row]}_row_${[meta.col]
          }" class="input-default focus form-control validate campoCheckManual"> ` +
          `</div>` +
          `</div>`;
      };

      dataSetCols[2].type = 'date-br';
      dataSetCols[2].render = function (data, type, row) {
        // alert(navigator['userAgent'])
        let isIE = function () {
          if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
            return true;
          }
          return false;

        };
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return `${x[2]}/${x[1]}/${x[0]}`;
        }
        x = data.slice(0, 10).split('-');
        return `${x[2]}/${x[1]}/${x[0]}`;
        return $.datepicker.formatDate("dd/mm/Y", new Date(data));

      };
      dataSetCols[3].type = 'date-br';
      dataSetCols[3].render = function (data, type, row) {
        // alert(navigator['userAgent'])
        let isIE = function () {
          if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
            return true;
          }
          return false;

        };
        if (isIE()) {
          x = data.slice(0, 10).split('-');
          return `${x[2]}/${x[1]}/${x[0]}`;
        }
        x = data.slice(0, 10).split('-');
        return `${x[2]}/${x[1]}/${x[0]}`;
        return $.datepicker.formatDate("dd/mm/Y", new Date(data));

      };

      $('#tabelaAntecipacoesABaixar').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "columns": dataSetCols,
        "data": dataSet,
        columnDefs: [{
          targets: array_colunas_invisiveis,
          visible: true,
        },
        {
          "render": function (data) {
            return parseFloat(data).toLocaleString('pt-BR', {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
          },
          "targets": [4, 5]
        }
        ],
      });
      // const tot_antecipacao = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(4, {}).data().sum()).toFixed(2));
      // const tot_antecipacao_pago = parseFloat(parseFloat($('#tabelaAntecipacoesSelecionadas').DataTable().column(5, {}).data().sum()).toFixed(2));
      // const val_total_itens = $('#tabelaItens').DataTable().column(7, {}).data().sum();
      // const saldo_antecipacao = tot_antecipacao - tot_antecipacao_pago;
      // let saldo_geral = val_total_itens - saldo_antecipacao;
      // if (saldo_geral < 0) {
      //   saldo_geral = 0;
      // }
    }
  }

  async function carregaAntecipacoes(sCodCli) {
    const bParametroAntecipacaoOutrasEmpresas = parametrosVenda[62] == 1 ?? false;
    const url = `/Sisplan/Vendas/v1/Antecipacao?`;
    const dataCols = [];
    let data = [];
    try {

      if (bParametroAntecipacaoOutrasEmpresas) {
        $('.emp_ID').removeClass('d-none');
      }

      const response = await requisicao('GET', url, `CLIENTE=${sCodCli}`, null);

      if (!response) {
        return;
      }

      data = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      await carregaTabelaAntecipacaoSelecaoManual(data, dataCols);

    } catch (error) {
      console.error(error);
      msgAlerta('Não foi possível buscar as antecipações.');
    }
  }

  $('#btnBaixarComAntecipacao').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const dados = $("#tabelaReceber").DataTable().rows(".selected").data().toArray();
        const listaDuplicatas = [];
        if (await validaDadosABaixar(dados)) {
          dados.forEach(dado => listaDuplicatas.push(dado.NUMERO));
          const listaNumeros = `'${listaDuplicatas.toString().replaceAll(",", "','")}'`;
          await carregaAntecipacoes(dados[0].CODCLI);

          const totalSelecionado = $("#tabelaReceber").DataTable().rows(".selected")
            .data()
            .toArray()
            .reduce((total, reg) => total += reg.VALOR2, 0);

          $("#txtSaldoAPagarAnt").html(
            parseFloat(totalSelecionado).toLocaleString("pt-BR", {
              minimumFractionDigits: 2,
            })
          );
          $("#modalBaixarComAntecipacao").modal("show");
        }
      } catch (error) {
        console.error(error);
        $("#modalBaixarComAntecipacao").modal("hide");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnBaixar").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let sNumero = [];
        let data = $("#tabelaReceber").DataTable().rows(".selected").data();

        for (let i = 0; i < data.length; i++) {
          if (data[0].VALOR2 == data[0].VALOR_PAGO) {
            msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} já está baixada!`
            );
            return;
          }

          if (data[i].STATUS === "DESD" || data[i].STATUS === "AGRU") {
            await msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} é um documento que foi Desdobrado/Agrupado para outro documento, impossível Continuar. `,
              "modalBaixar"
            );
            return;
          }

          if (data[i].STATUS === "CHCA") {
            await msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} é um título de Cheque. Impossível Baixar.`,
              "modalBaixar"
            );
            return;
          }

          if (data[i].STATUS === "ANTE") {
            await msgAlertaSemConfirmacao(
              `Numero: ${data[i].NUMERO} é um título de Antecipação. Impossível Baixar. `,
              "modalBaixar"
            );
            return;
          }
          sNumero.push(data[i].NUMERO);
        }

        const ListaNumeros = `'${sNumero.toString().replaceAll(",", "','")}'`;

        await carregaBaixas(ListaNumeros);

        if (parametrosReceber[7].VALOR == 1) {
          $('#txtClasse').prop('disabled', true);
          $('#btn-Classe').prop('disabled', true);
          $('#btn-limpa-Classe').prop('disabled', true);
          $('#txtConta').prop('disabled', true);
          $('#btnConta').prop('disabled', true);
          $('#btn-limpa-Conta').prop('disabled', true);
          $('#txtHistorico').prop('disabled', true);
          $('#btn-Historico').prop('disabled', true);
          $('#btn-limpa-Historico').prop('disabled', true);
        }

        // $("#txtTotalValor").val(parseFloat($('#tabelaBaixarContas').DataTable().column(5).data().sum()).toLocaleString('pt-BR', {
        //     style: 'currency',
        //     currency: 'BRL'
        // }));

        atualizaValorPago();
        atualizaValorTotal();
        atualizaTotalDesconto();
        atualizaTotalJuros();
        calculaTroco();

        $("#modalBaixar").modal("show");
      } catch (error) {
        console.error(error);
        $("#modalBaixar").modal("hide");
        msgErro("Erro ao Realizar baixa");
      }
    } finally {
      $('.txtDesconto').prop('disabled', parametrosReceber[8].VALOR == '1');
      $('.txtPercDesconto').prop('disabled', parametrosReceber[8].VALOR == '1');

      $(".txtJuros").trigger("blur");
      $.LoadingOverlay("hide");
    }
  });

  function atualizaValorPago() {
    let total = 0;
    for (let i = 0; i < $(".txtvalorPago").length; i++) {
      total += parseFloat($($(".txtvalorPago")[i]).val());
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalPago").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function atualizaValorTotal() {
    let total = parseFloat(
      $("#tabelaBaixarContas").DataTable().column(6).data().sum()
    );
    for (let i = 0; i < $(".txtJuros").length; i++) {
      total += parseFloat(
        $($(".txtJuros")[i]).val() != undefined
          ? $($(".txtJuros")[i]).val()
          : "0"
      );
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalValor").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function atualizaTotalDesconto() {
    let total = 0;
    for (let i = 0; i < $(".txtDesconto").length; i++) {
      total += parseFloat($($(".txtDesconto")[i]).val());
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalDesconto").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function atualizaTotalJuros() {
    let total = 0;
    for (let i = 0; i < $(".txtJuros").length; i++) {
      total += parseFloat($($(".txtJuros")[i]).val());
    }
    if (isNaN(total)) {
      total = 0;
    }
    $("#txtTotalJuros").val(
      parseFloat(total).toFixed(2)
      // .toLocaleString("pt-BR", {
      //   style: "currency",
      //   currency: "BRL",
      // })
    );
  }

  function retornaInputs(bDesconto = false, bJuros = false, bValor = false, bPercDesc = false, bObs = false) {
    if (bDesconto) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtDesconto">`;
    }
    if (bJuros) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtJuros">`;
    }
    if (bValor) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtvalorPago">`;
    }
    if (bPercDesc) {
      return `<input min="0" type="number" min="0" value="0" style="max-width: 100px; background-color: transparent!important;" class="input-default focus form-control validate valoresInput txtPercDesconto">`;
    }
    if (bObs) {
      return `<input type="text" style="background-color: transparent!important; width: 200px" class="input-default focus form-control txtObsBaixa">`;
    }
  }

  async function pegaValoresCartoes() {
    const cartoes = $("#tabelaParcelas").DataTable().data().toArray();
    const classe = pegaChave("#txtClasse");
    const historico = pegaChave('#txtHistorico');
    const codcli = pegaChave("#txtChequeCliente");
    const nome = pegaDescricao("#txtChequeCliente");
    const moeda = pegaChave('#txtMoeda');
    const valorTotal = +$('#txt_cred_valor_total').val();
    const nsu = $('#txtNsu').val();
    const bandeira = $('#select_bandeira').val();
    const codCond = pegaChave('#txtCondicaoDePagamento');

    const dados = cartoes.map((cheque, index) => {
      const dataVencimento = $($(".campoVencimento")[index]).val();
      const valorCredito = parseFloat(parseFloat($($(".campoValor")[index]).val()).toFixed(2));

      return {
        NUMERO: "",
        LANCAMENTO: "",
        FATURA: "",
        CODCLI: codcli,
        CPF_CNPJ: cheque.CPF_CNPJ,
        NOME: nome,
        VALOR: valorTotal,
        VAL_ORIGIN: valorTotal,
        VALOR2: valorCredito,
        VALOR_PAGO: 0,
        VAL_DEV: 0,
        DESCONTO: 0,
        DT_VENCTO: `${dataVencimento}T00:00:00Z`,
        DT_EMISSAO: `${new Date().toISOString().slice(0, 10)}T00:00:00Z`,
        DT_COMREC: `${new Date().toISOString().slice(0, 10)}T00:00:00Z`,
        STATUS: "DUPL",
        HISTORICO: historico,
        CLASSE: classe,
        EMP_ID: getCookie('emp_id'),
        EMPRESA: getCookie('empresa'),
        MOEDA: moeda,
        PARCELA: index,
        CARTAO_NSU: nsu,
        BANDEIRA: bandeira,
        CONDICAO: codCond
      };
    });
    return dados;
  }

  async function pegaValoresCheques() {
    const cheques = $("#tabelaParcelas").DataTable().data().toArray();
    const classe = pegaChave("#txtChequeClasse");
    const situacao = pegaChave("#txtChequeSituacao");
    const representante = pegaChave("#txtChequeRepresentante");
    const codcli = pegaChave("#txtChequeCliente");
    const nome = pegaDescricao("#txtChequeCliente");
    const historico = pegaChave('#txtChequeHistorico');

    const dados = cheques.map((cheque, index) => {
      const dataVencimento = $($(".campoVencimento")[index]).val();
      const banco =
        $($(".campoBanco")[index]).val() != undefined
          ? pegaChave($($(".campoBanco")[index]).val())
          : "";
      const agencia =
        $($(".campoAgencia")[index]).val() != undefined
          ? $($(".campoAgencia")[index]).val()
          : "";
      const conta =
        $($(".campoConta")[index]).val() != undefined
          ? $($(".campoConta")[index]).val()
          : "";
      const numero =
        $($(".campoNumero")[index]).val() != undefined
          ? $($(".campoNumero")[index]).val()
          : "";
      const valorCheque = parseFloat(
        parseFloat($($(".campoValor")[index]).val()).toFixed(2)
      );

      return {
        NUMERO: "",
        LANCAMENTO: "",
        FATURA: "",
        AGENCIA: agencia,
        BANCO: banco,
        CODCLI: codcli,
        CPF_CNPJ: cheque.CPF_CNPJ,
        CONTA: conta,
        NOME: nome,
        VALOR: valorCheque,
        VALOR2: valorCheque,
        DT_VENCTO: `${dataVencimento}T00:00:00Z`,
        DT_EMISSAO: `${new Date().toISOString().slice(0, 10)}T00:00:00Z`,
        STATUS: "CHEQ",
        CODREP: representante,
        SITUACAO: situacao,
        CLASSE: classe,
        NUMERO_CH: numero,
        AGENCIA_CH: agencia,
        BANCO_CH: banco,
        CNPJ_CH: cheque.CPF_CNPJ,
        CONTA_CH: conta,
        CONTA_CHEQUE: conta,
        EMISSOR_CH: nome,
        HISTORICO: historico,
      };
    });
    return dados;
  }

  async function pegaValoresReceber(bImprimir = false) {
    try {
      let classe = '.checkReceber:checked'
      let receberSelecionado = $(classe).toArray();

      if ((!receberSelecionado.length > 0) && (bImprimir)) {
        classe = '.checkReceber';
        receberSelecionado = $('#tabelaReceber').DataTable().data().toArray();
      }

      const lista = receberSelecionado.map((item, i) => {
        let receber;
        if ((classe == '.checkReceber:checked') || (!bImprimir)) {
          receber = $('#tabelaReceber')
            .DataTable()
            .row($($(classe)[i])
              .closest('tr'))
            .data();
        } else {
          receber = $('#tabelaReceber').DataTable().row(i).data()
        }

        return {
          VALOR_PAGO: parseFloat(receber.SALDO),
          DESCONTO: 0,
          JUROS: 0,
          CODCLI: receber.CODCLI,
          CODREP: receber.CODREP,
          DT_EMISSAO: receber.DT_EMISSAO,
          DT_VENCTO: receber.DT_VENCTO,
          EMP_ID: receber.EMP_ID,
          EMP_ID_1: receber.EMP_ID_1,
          FATURA: receber.FATURA,
          LANCAMENTO: 0,
          NUMERO: receber.NUMERO,
          OBS: receber.OBS,
          SALDO: parseFloat(receber.SALDO),
          STATUS: receber.STATUS,
          VALOR: receber.VALOR,
          VALOR2: receber.VALOR2,
          CLASSE: pegaChave("#txtClasseAnt"),
          HISTORICO: pegaChave("#txtHistoricoAnt"),
          DT_PAGTO: `${$("#txtDTPagamentoAnt").val()}`,
          DT_CONT: `${$("#txtDTContabilizacaoAnt").val()}`,
        };
      });
      return lista;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }

  async function pegaValoresAntecipacao() {
    try {
      const antecipacoesSelecionadas = $('.campoCheckManual:checked').toArray();
      const objeto = antecipacoesSelecionadas.map((item, i) => {
        const antecipacao = $('#tabelaAntecipacoesABaixar')
          .DataTable()
          .row($($('.campoCheckManual:checked')[i])
            .closest('tr'))
          .data();
        return {
          VALOR_PAGO: antecipacao.VALOR,
          VALOR2: antecipacao.VALOR,
          EMPRESA: getCookie('empresa'),
          LANCAMENTO: 0,
          NUMERO: antecipacao.DUPLICATA,
          CLASSE: pegaChave("#txtClasseAnt"),
          HISTORICO: pegaChave("#txtHistoricoAnt"),
          DT_PAGTO: `${$("#txtDTPagamentoAnt").val()}`,
          DT_CONT: `${$("#txtDTContabilizacaoAnt").val()}`,
          JUROS: 0,
          VALOR_DEV: 0,
          QT_DEV: 0,
          DESCONTO: 0,
          SALDO_ANTECIPACAO: antecipacao.VALOR
        };
      });
      return objeto;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores das antecipações");
    }
  }

  async function pegaValoresBaixa() {
    try {
      let table = $("#tabelaBaixarContas").DataTable();
      let rows = table.rows();
      let valores = [];
      let objeto = {};
      // pegar valor pago
      for (let i = 0; i < rows[0].length; i++) {
        objeto = {
          VALOR_PAGO: parseFloat(
            $($("#tabelaBaixarContas").find(".txtvalorPago")[i]).val()
          ),
          DESCONTO: $($("#tabelaBaixarContas").find(".txtDesconto")[i]).val(),
          JUROS: $($("#tabelaBaixarContas").find(".txtJuros")[i]).val(),
          CODCLI: rows.data()[i].CODCLI,
          CODREP: rows.data()[i].CODREP,
          DT_EMISSAO: rows.data()[i].DT_EMISSAO,
          DT_VENCTO: rows.data()[i].DT_VENCTO,
          EMP_ID: rows.data()[i].EMP_ID,
          EMP_ID_1: rows.data()[i].EMP_ID_1,
          FATURA: rows.data()[i].FATURA,
          LANCAMENTO: 0,
          NUMERO: rows.data()[i].NUMERO,
          OBS: $($("#tabelaBaixarContas").find(".txtObsBaixa")[i]).val(),
          SALDO: parseFloat(parseFloat(rows.data()[i].SALDO).toFixed(2) - (parseFloat($($("#tabelaBaixarContas").find(".txtvalorPago")[i]).val()).toFixed(2) - parseFloat($($("#tabelaBaixarContas").find(".txtJuros")[i]).val()).toFixed(2))).toFixed(2),
          SALDO_A_PAGAR: parseFloat(parseFloat(rows.data()[i].SALDO).toFixed(2)),
          STATUS: rows.data()[i].STATUS,
          VALOR: rows.data()[i].VALOR,
          VALOR2: rows.data()[i].VALOR2,
          CLASSE: pegaChave("#txtClasse", objeto.CLASSE),
          HISTORICO: pegaChave("#txtHistorico", objeto.HISTORICO),
          DT_PAGTO: `${$("#txtDTPagamento").val()}`,
          DT_CONT: `${$("#txtDTContabilizacao").val()}`,
          MOEDA: pegaChave("#txtMoeda", objeto.MOEDA),
          NAO_LANCA_CC: isChecked('#cbNaoLancaCc'),
          CONTA: pegaChave('#txtConta'),
          LOG: getCookie('emp_id') != rows.data()[i].EMP_ID ? `BAIXA NA EMPRESA ${getCookie('empresa')}, DUPLICATA: ` : `BAIXA DUPLICATA: `,
          CONCATENAOBS: 'S'
        };

        if (isChecked('#cbNaoLancaCc')) {
          objeto.LOG += ' - Usuário optou por não lançar no Conta Corrente'
        }

        if (podeAlterarCheck) {
          if ($("#checkCaixa").prop("checked") == true) {
            objeto.LOG += ` - Usuário optou por lançar o valor no caixa `;
          } else {
            objeto.LOG += ` - Usuário optou por não lançar o valor no caixa `;
          }
        }

        if (!$("#divNSU").hasClass("d-none")) {
          objeto.NSU = $("#txtNsu").val();
          objeto.BANDEIRA = $('#select_bandeira').val();
        }

        if ($("#checkCaixa").prop("checked") == true) {
          objeto.NRCAIXA = pegaChave("#txtCaixa", objeto.NRCAIXA);
          objeto.LANCAMANUAL = 1;
        } else {
          objeto.LANCAMANUAL = 0;
        }

        valores.push(objeto);
        objeto = {};
      }
      return valores;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os valores da tabela");
    }
  }



  async function retornaDadosGerenciaisImpressao(params) {
    try {
      const response = await requisicao(
        "GET",
        "/sisplan/cupom/v1/cupomgerencialbaixareceber?",
        params
      );
      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro("Erro ao buscar dados de cupom gerencial.");
        return;
      }

      const jsonStr = await response.json();
      return jsonStr;
    } catch (error) {
      msgErro("Erro ao buscar dados de cupom gerencial.");
      console.error(error);
    }
  }
  async function imprimirCupomGerencialBaixa(baixas) {
    const paramRelGerencial = (await CopiaParametro("RECEBER", 1)) ?? "0";
    if (paramRelGerencial == 0) {
      return;
    }

    const url = `/cupom/imprimircupombaixa?`;
    for (let i = 0; i < baixas.length; i++) {
      const baixa = baixas[i];
      const objeto = {
        numero: baixa.NUMERO,
        codven: "",
        nrCupom: "",
        moeda: baixa.MOEDA,
        codcli: baixa.CODCLI,
        cnpj: "",
        valDesconto: baixa.DESCONTO,
        valor: baixa.VALOR2,
        valPago: baixa.VALOR_PAGO,
        valJuros: baixa.JUROS,
        lista: [],
      };
      const nrVias = paramRelGerencial;
      const params = `JSON=${JSON.stringify(objeto)}&NR_VIAS=${nrVias}`;

      try {
        const dadosImpressao = await retornaDadosGerenciaisImpressao(
          params,
          paramRelGerencial
        );
        const response = await requisicao_ecf(
          "POST",
          url,
          `JSON=${encodeURIComponent(JSON.stringify(dadosImpressao))}`,
          "",
          30000
        );

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro("Erro ao imprimir cupom gerencial.");
          return;
        }
      } catch (error) {
        console.error(error);
        msgErro("Erro ao imprimir cupom gerencial.");
      }
    }
  }

  async function RetornaCNPJ(sCodCli) {
    try {
      let url = `/sisplan/funcoes/v1/pesquisa?`;
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"entidade", "camposSelect":["cnpj"], "where": ["codcli = '${sCodCli}'"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      let cnpj = jsonStr.RESULT[0][0].CNPJ;
      return cnpj;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados do cliente.");
    }
  }

  $("#txtChequeCliente").on("blur", async function () {
    const sCodCli = pegaChave("#txtChequeCliente");
    const sNome = pegaDescricao("#txtChequeCliente");
    const sCnpj = await RetornaCNPJ(pegaChave("#txtChequeCliente"));
    $("#tabelaParcelas")
      .DataTable()
      .data()
      .toArray()
      .forEach((cheque, index) => {
        const data = cheque;
        data.CPF_CNPJ = sCnpj;
        data.Nome = sNome;
        data.CodCli = sCodCli;
        $("#tabelaParcelas").DataTable().row(index).data(data);
      });
    adicionaEventosCamposTabela();
  });

  async function RetornaVencimentos(iCodCondicao) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let arrVencimentos = [];
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let nrParcelas = jsonStr.RESULT[0].length;
      let dataAtual = new Date();
      for (let index = 0; index < nrParcelas; index++) {
        let novoPrazo = new Date();
        let nrDia = jsonStr.RESULT[0][index].PRAZO;
        novoPrazo.setDate(dataAtual.getDate() + nrDia);
        arrVencimentos.push(formataData(novoPrazo));
      }
      return arrVencimentos;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function montaTelaParcelas(sTipo = 'cheque') {
    if (sTipo != 'cheque') {
      $('#btn-adicionar-cheque').addClass('d-none');
    } else {
      $('#btn-adicionar-cheque').removeClass('d-none');
    }

    let dataSet = [];
    let dataSetCols = [];
    const iNumParcelas = +pegaChave('#txtNrParcelas');
    const iCodCondicao = +pegaChave('#txtCondicaoDePagamento');
    const valorTotal = parseFloat($("#txtTotalPago").val()).toFixed(2);
    let valorParcela = 0;
    if (sTipo == 'cheque') {
      valorParcela = parseFloat($("#txtTotalPago").val()).toFixed(2);
    } else {
      valorParcela = parseFloat(parseFloat(valorTotal / iNumParcelas).toFixed(2));
    }
    let guardaValor = valorParcela;
    let diferenca = 0;
    let arrayVencimentos;

    if (valorTotal > valorParcela * iNumParcelas || valorTotal < valorParcela * iNumParcelas) {
      diferenca = parseFloat(parseFloat(valorTotal - valorParcela * iNumParcelas).toFixed(2));
    }

    arrayVencimentos = await RetornaVencimentos(iCodCondicao);
    let columnKeys = sTipo == 'cheque' ? [
      "Nome",
      "CPF_CNPJ",
      "Banco",
      "Agência",
      "Conta",
      "Número",
      "Vencimento",
      "Valor",
      "CodCli",
      "Ações",
      "Impressão",
      "Ler_Cheque",
    ] : [
      "Nome",
      "CPF_CNPJ",
      "Vencimento",
      "Valor",
      "CodCli",
      "Ações",
    ];
    const sNome = $("#tabelaBaixarContas")
      .DataTable()
      .data()
      .toArray()[0].CLIENTE;
    const sCodCli = $("#tabelaBaixarContas")
      .DataTable()
      .data()
      .toArray()[0].CODCLI;
    const sCnpj = await RetornaCNPJ(
      $("#tabelaBaixarContas").DataTable().data().toArray()[0].CODCLI
    );
    insereValor(
      "#txtChequeCliente",
      $("#tabelaBaixarContas").DataTable().data().toArray()[0].CODCLI,
      sNome
    );
    const idColunaValor = sTipo == 'cheque' ? 7 : 3;
    const idColunaVencimento = sTipo == 'cheque' ? 6 : 2;
    $("#txt_cred_valor_total").val(valorTotal);
    $("#modalParcelas-titulo").html(`Pagamento com ${sTipo == 'cheque' ? 'Cheque' : 'Cartão'}`);

    columnKeys.forEach((item) => {
      dataSetCols.push({
        title: item,
        data: item,
      });
    });

    if (sTipo == 'cheque') {
      dataSetCols[2].render = function (data, type, row, meta) {
        return `<input type="text" placeholder="Banco" id="banco_col_${[
          meta.row,
        ]}_row_${[
          meta.col,
        ]}" class="input-default focus form-control validate campoBanco" required="required" readonly> `;
      };
      dataSetCols[3].render = function (data, type, row) {
        return `<input style="width: 80%" type="text" value="${data}" class="input-default focus form-control campoAgencia required">`;
      };
      dataSetCols[4].render = function (data, type, row) {
        return `<input style="width: 80%" type="text" value="${data}" class="input-default focus form-control campoConta required">`;
      };
      dataSetCols[5].render = function (data, type, row) {
        return `<input style="width: 80%" type="text" value="${data}" class="input-default focus form-control campoNumero required">`;
      };
      dataSetCols[9].render = function (data, type, row) {
        return `<button type="button" class="btn btn-sm btn-danger campoExcluirCheque">Excluir</button>`;
      };
      dataSetCols[10].render = function (data, type, row) {
        return '<button title="Imprimir na impressora de cheque" class="btn btn-primary btnCheque"><i class="fas fa-print"></i></button>';
      };
      dataSetCols[11].render = function (data, type, row) {
        return '<button title="Ler cheque" class="btn btn-primary btnLerCheque"><i class="fas fa-download"></i></button>';
      };
    }

    dataSetCols[idColunaVencimento].type = "date-br";
    dataSetCols[idColunaVencimento].render = function (data, type, row) {
      return `<input style="width: 85%" type="date" ${sTipo == 'cheque' ? '' : 'disabled'} value="${data}" class="input-default focus form-control campoVencimento required">`;
    };

    dataSetCols[idColunaValor].render = function (data, type, row) {
      return `<input style="width: 80%" type="number" step="0.01" value="${parseFloat(
        data
      ).toFixed(
        2
      )}" class="input-default focus form-control campoValor required " ${sTipo == 'cheque' ? '' : 'disabled'}>`;
    };

    if (sTipo == 'cheque') {
      dataSet.push({
        Nome: sNome,
        CPF_CNPJ: sCnpj,
        Banco: "",
        Agência: "",
        Conta: "",
        Número: "",
        Vencimento: "",
        Valor: valorParcela,
        CodCli: sCodCli,
        Ações: ""
      });
    } else {
      for (let i = 0; i < iNumParcelas; i++) {
        if (diferenca > 0 && i == 0) {
          valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
          diferenca = 0;
        } else {
          valorParcela = guardaValor;
        }
        if (diferenca < 0 && i == iNumParcelas - 1) {
          valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
        }
        dataSet.push({
          Nome: sNome,
          CPF_CNPJ: sCnpj,
          Vencimento: arrayVencimentos[i],
          Valor: valorParcela,
          CodCli: sCodCli,
          Ações: "",
        });
      }
    }

    if ($.fn.DataTable.isDataTable('#tabelaParcelas')) {
      $('#tabelaParcelas').DataTable().destroy();
    }
    $('#tabelaParcelas tbody').empty();
    $('#tabelaParcelas thead').empty();

    $("#tabelaParcelas").DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      autowidth: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
      columns: dataSetCols,
      data: dataSet,
      columnDefs: [
        {
          targets: sTipo == 'cheque' ? 8 : 4,
          visible: false,
        },
      ],
    });

    adicionaEventosCamposTabela();
    if (sTipo != 'cheque') {
      $('#btn_confirmar_cred').trigger('click');
    } else {
      $("#modalParcelas").modal("show");
    }
  }

  async function efetuaBaixaComCheque() {
    try {
      let possuiBanco = true;
      let possuiAgencia = true;
      let possuiConta = true;
      let possuiNumero = true;
      let vencimentosInValidos = true;
      for (let i = 0; i < $(".campoBanco").length; i++) {
        possuiBanco =
          $($(".campoBanco")[i]).val() != "undefined" &&
          $($(".campoBanco")[i]).val() != "";
        possuiAgencia =
          $($(".campoAgencia")[i]).val() != "undefined" &&
          $($(".campoAgencia")[i]).val() != "";
        possuiConta =
          $($(".campoConta")[i]).val() != "undefined" &&
          $($(".campoConta")[i]).val() != "";
        possuiNumero =
          $($(".campoNumero")[i]).val() != "undefined" &&
          $($(".campoNumero")[i]).val() != "";
        vencimentosInValidos =
          new Date($($(".campoVencimento")[i]).val()) == "Invalid Date";
      }
      if (vencimentosInValidos) {
        msgAlerta("Data de vencimento inválida, verifique");
        return;
      }
      if (possuiBanco == false) {
        msgAlerta("Necessário informar o campo Banco, verifique");
        return;
      }
      if (possuiAgencia == false) {
        msgAlerta("Necessário informar o campo Agência, verifique");
        return;
      }
      if (possuiConta == false) {
        msgAlerta("Necessário informar o campo Conta, verifique");
        return;
      }
      if (possuiNumero == false) {
        msgAlerta("Necessário informar o campo Número, verifique");
        return;
      }

      if ($("#txtChequeCliente").val() === "") {
        msgAlerta("Necessário informar o campo Cliente, verifique");
        return;
      }

      if ($("#txtChequeRepresentante").val() === "") {
        msgAlerta("Necessário informar o campo Representante, verifique");
        return;
      }

      if ($("#txtChequeSituacao").val() === "") {
        msgAlerta("Necessário informar o campo Situação, verifique");
        return;
      }

      if ($("#txtChequeClasse").val() === "") {
        msgAlerta("Necessário informar o campo Classe, verifique");
        return;
      }

      if ($("#txtChequeHistorico").val() === "") {
        msgAlerta("Necessário informar o campo Histórico, verifique");
        return;
      }

      const valorTotal = ArredondarValor(parseFloat($("#txt_cred_valor_total").val()), 2);
      const totalCheques = ArredondarValor($(".campoValor")
        .toArray()
        .reduce((total, atual) => (total += parseFloat($(atual).val())), 0), 2);

      if ((valorTotal > totalCheques) || (isNaN(totalCheques))) {
        msgErro(
          "Soma de Valores dos cheques deve ser maior/igual ao valor a pagar, verifique"
        );
        return;
      }

      const listaBaixas = await pegaValoresBaixa();
      const listaCheques = await pegaValoresCheques();
      const objeto = { listaCheques, listaBaixas };

      const response = await requisicao(
        (receber = "POST"),
        "/Sisplan/receber/V1/baixarecebercomcheque?",
        "",
        `JSON=${JSON.stringify(objeto)}`
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      await imprimeBaixasReceber()

      toastr
        .success("Baixa efetuado com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            window.location.href = `${BASE_URI}/receber`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function efetuaBaixaComCartao() {
    $.LoadingOverlay('show');
    try {
      let vencimentosInValidos = true;
      for (let i = 0; i < $(".campoVencimento").length; i++) {
        vencimentosInValidos =
          new Date($($(".campoVencimento")[i]).val()) == "Invalid Date";
      }
      if (vencimentosInValidos) {
        msgAlerta("Data de vencimento inválida, verifique");
        return;
      }

      const valorTotal = ArredondarValor(parseFloat($("#txt_cred_valor_total").val()), 2);
      const totalCheques = ArredondarValor($(".campoValor")
        .toArray()
        .reduce((total, atual) => (total += parseFloat($(atual).val())), 0), 2);

      if (valorTotal !== totalCheques) {
        msgErro(
          "Soma de valores deve ser igual ao valor a pagar, verifique"
        );
        return;
      }

      const listaBaixas = await pegaValoresBaixa();
      const listaCartoes = await pegaValoresCartoes();
      const objeto = { listaBaixas, listaCartoes };

      const response = await requisicao(
        (receber = "POST"),
        "/Sisplan/receber/V1/baixarecebercomcartao?",
        "",
        `JSON=${JSON.stringify(objeto)}`
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      await imprimeBaixasReceber();

      toastr
        .success("Baixa efetuado com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          async onHidden() {
            window.location.href = `${BASE_URI}/receber`;
          },
        })
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $("#btn_confirmar_cred").on("click", async function () {
    $("#btn_confirmar_cred").prop('disabled', true);
    $.LoadingOverlay('show');
    try {
      const baixaComCheque = $('#modalParcelas-titulo').html().toUpperCase().indexOf('CHEQUE') > 0;
      if (baixaComCheque) {
        await efetuaBaixaComCheque();
      } else {
        await efetuaBaixaComCartao();
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#btn_confirmar_cred").prop('disabled', false);
    }
  });

  function adicionaEventosCamposTabela() {
    // faz o rateio dos totais das outros
    $(".campoValor").on("change", function () {
      $(this).addClass("alterado");
      let qtdeParaRatear =
        $(".campoValor").length - $(".campoValor.alterado").length;
      let valorAlterado = 0;
      for (let i = 0; i < $(".campoValor.alterado").length; i++) {
        valorAlterado =
          parseFloat(valorAlterado.toFixed(2)) +
          parseFloat(
            parseFloat($($(".campoValor.alterado")[i]).val()).toFixed(2)
          );
      }
      // if (valorAlterado > parseFloat($("#txt_cred_valor_total").val())) {
      //   msgAlerta("valor da parcela não pode ser maior que o valor total.");
      //   $("#btn_dividir_valor").trigger("click");
      // } else {
      const valorTotal = ArredondarValor(parseFloat($("#txt_cred_valor_total").val()), 2);
      const totalCheques = ArredondarValor($(".campoValor")
        .toArray()
        .reduce((total, atual) => (total += parseFloat($(atual).val())), 0), 2);

      if (valorTotal >= totalCheques) {
        valorParaRatear = $("#txt_cred_valor_total").val() - valorAlterado;
        let valorRateio = parseFloat(valorParaRatear / qtdeParaRatear).toFixed(
          2
        );
        for (let i = 0; i < $(".campoValor").length; i++) {
          if (!$($(".campoValor")[i]).hasClass("alterado")) {
            $($(".campoValor")[i]).val(valorRateio);
          }
        }
      }
      // }
    });

    for (let i = 0; i < $(".campoBanco").length; i++) {
      $(`#banco_col_${i}_row_2`).pesquisa(
        `#banco_col_${i}_row_2`,
        "BANCO",
        "NOME_BANCO",
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where": null}',
        "Pesquisa Banco",
        "cadban"
      );
    }

    $(".campoExcluirCheque").unbind("click");
    $(".campoExcluirCheque").on("click", function () {
      const recNo = this.closest("tr").rowIndex - 1;
      if (recNo === 0) {
        msgErro("Não é possível excluir o primeiro cheque.");
        return;
      }
      $("#tabelaParcelas")
        .DataTable()
        .row($(this).parents("tr"))
        .remove()
        .draw(false);
    });

    $(".btnLerCheque").on("click", async function () {
      try {
        try {
          $(this).attr("disabled", "true");
          $.LoadingOverlay("show");
          const posicao = $(this).parents("tr")[0].rowIndex - 1;
          await LerCheque(posicao);
        } finally {
          $.LoadingOverlay("hide");
          $(this).removeAttr("disabled");
        }
      } catch (error) {
        msgErro("Erro ao ler cheque.");
        $(this).removeAttr("disabled");
      }
    });

    $(".btnCheque").on("click", async function () {
      try {
        try {
          $(this).attr("disabled", "true");
          $.LoadingOverlay("show");
          const posicao = $(this).parents("tr")[0].rowIndex - 1;
          await imprimirCheque(posicao);
        } finally {
          $.LoadingOverlay("hide");
          $(this).removeAttr("disabled");
        }
      } catch (error) {
        msgErro("Erro ao imprimir cheque.");
        $(this).removeAttr("disabled");
      }
    });

    $(".campoBanco").on("blur", function () {
      for (let i = 0; i < $(".campoBanco").length; i++) {
        if ($($(".campoBanco")[i]).val() == "") {
          $($(".campoBanco")[i]).val($(this).val());
        }
      }
    });

    $(".campoAgencia").on("blur", function () {
      const bLeu = preencheDadosCheque(this);
      if (bLeu) {
        for (let i = 0; i < $(".campoAgencia").length; i++) {
          if ($($(".campoAgencia")[i]).val() == "") {
            $($(".campoAgencia")[i]).val($(this).val());
          }
        }
      }
    });

    $(".campoConta").on("blur", function () {
      const bLeu = preencheDadosCheque(this);
      if (bLeu) {
        for (let i = 0; i < $(".campoConta").length; i++) {
          if ($($(".campoConta")[i]).val() == "") {
            $($(".campoConta")[i]).val($(this).val());
          }
        }
      }
    });

    $(".campoNumero").on("blur", function () {
      const bLeu = preencheDadosCheque(this);
      if (bLeu) {
        if ($(this).val() == "") {
          return;
        }
        for (let i = 0; i < $(".campoNumero").length; i++) {
          if ($($(".campoNumero")[i]).val() == "") {
            $($(".campoNumero")[i]).val(parseInt($(this).val()) + i);
          }
        }
      }
    });

    $('.campoAgencia').keydown(function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $('.campoAgencia').trigger('blur');
      }
    });

    $('.campoConta').keydown(function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $('.campoConta').trigger('blur');
      }
    });

    $('.campoNumero').keydown(function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $('.campoNumero').trigger('blur');
      }
    });
  }

  $("#btn-adicionar-cheque").on("click", function () {
    const dados = $("#tabelaParcelas").DataTable().data().toArray()[0];
    const novoCheque = {
      Nome: dados.Nome,
      CPF_CNPJ: dados.CPF_CNPJ,
      Banco: "",
      Agência: "",
      Conta: "",
      Número: "",
      Vencimento: "",
      Valor: "",
      CodCli: dados.CodCli,
    };

    $("#tabelaParcelas").DataTable().row.add(novoCheque).draw(false);
    adicionaEventosCamposTabela();
  });

  $("#btn_dividir_valor").on("click", function () {
    let qtdeParcelas = $(".campoValor").length;
    let valorTotal = parseFloat(
      parseFloat($("#txt_cred_valor_total").val()).toFixed(2)
    );
    let valorParcela = parseFloat((valorTotal / qtdeParcelas).toFixed(2));
    let guardaValor = valorParcela;

    if (
      valorTotal > valorParcela * qtdeParcelas ||
      valorTotal < valorParcela * qtdeParcelas
    ) {
      var diferenca = parseFloat(
        parseFloat((valorTotal - valorParcela * qtdeParcelas).toFixed(2))
      );
    }

    for (let i = 0; i < qtdeParcelas; i++) {
      $($(".campoValor")[i]).removeClass("alterado");
      if (diferenca > 0 && i == 0) {
        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
        diferenca = 0;
      } else {
        valorParcela = guardaValor;
      }
      if (diferenca < 0 && i == qtdeParcelas - 1) {
        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
      }
      $($(".campoValor")[i]).val(valorParcela);
    }
  });

  $('#btn-baixarAnt').on('click', async function () {

    if ($("#txtClasseAnt").val() == "") {
      msgAlerta("Classe não informada!");
      $("#btn-ClasseAnt").trigger("click");
      return;
    }

    if ($("#txtHistoricoAnt").val() == "") {
      msgAlerta("Histórico não informado!");
      $("#btn-HistoricoAnt").trigger("click");
      return;
    }

    if ($('.campoCheckManual:checked').toArray().length == 0) {
      msgAlerta('Nenhuma antecipação selecionada, impossível continuar.');
      return;
    }

    const listaBaixas = await pegaValoresReceber();
    const listaAntecipacoes = await pegaValoresAntecipacao();
    const objeto = { listaAntecipacoes, listaBaixas };

    const response = await requisicao(
      'POST',
      "/Sisplan/receber/V1/baixarecebercomantecipacao?",
      "",
      `JSON=${JSON.stringify(objeto)}`,
      300000
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    toastr
      .success("Baixa efetuado com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        async onHidden() {
          window.location.href = `${BASE_URI}/receber`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  });

  $('#btnImprimir').on('click', async function () {
    try {
      try {
        $.LoadingOverlay('show');
        let numeros = [];
        const duplicatas = await pegaValoresReceber(true);
        for (let i = 0; i < duplicatas.length; i++) {
          numeros.push(duplicatas[i].NUMERO);
        }

        const ListaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

        url = `/sisplan/impressao/v1/acesso_receber?NUMERO=${ListaNumeros}`;
        const ordem = `&TELA_ORDENACAO=Receber&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('Receber');
        arquivo = await GeraRelatorio(`${url}${ordem}&`, "GET", 15000, false, 'Receber');
        if (arquivo != undefined && arquivo != "") {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (err) {
        console.error(err);
        msgErro('Erro ao imprimir relatório.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $("#btn-baixar").on("click", async function () {
    $("#btn-baixar").prop('disabled', true);
    $.LoadingOverlay('show');
    try {
      if ($("#txtMoeda").val() == "") {
        msgAlerta("Moeda não informada!");
        $("#btnMoeda").trigger("click");
        return;
      }
      if ($("#txtCaixa").val() == "" && $("#checkCaixa").prop("checked")) {
        msgAlerta("Caixa não informado!");
        $("#btnCaixa").trigger("click");
        return;
      }
      if (!$("#divNSU").hasClass("d-none") && $("#txtNsu").val() == "") {
        msgAlerta(" NSU não informado!");
        $("#txtNsu").focus();
        return;
      }
      if (($("#txtClasse").val() == "") && (parametrosReceber[7].VALOR == 1)) { 
        await verificaMoeda();
      }
      if ($("#txtClasse").val() == "") {
        msgAlerta("Classe não informada!");
        if (parametrosReceber[7].VALOR != 1) {
          $("#btn-Classe").trigger("click");
        }
        return;
      }
      if ($("#txtHistorico").val() == "") {
        msgAlerta("Histórico não informado!");
        if (parametrosReceber[7].VALOR != 1) {
          $("#btn-Historico").trigger("click");
        }
        return;
      }

      let valDesconto = 0;
      $('.txtDesconto').map((index, item) => {
        valDesconto += item.value;
      });

      if ((parametrosReceber[8].VALOR == '2') && (valDesconto > 0) && (!validouSenhaSupervisorBaixa)) {
        await senhaSupervisor('Necessário digitar senha do supervisor para dar desconto.', () => {
          validouSenhaSupervisorBaixa = true;
          $("#btn-baixar").trigger('click');
        });
        return;
      }
      validouSenhaSupervisorBaixa = false;

      const usaTef = await verificaMoedaTef(pegaChave('#txtMoeda'));
      const moedaPix = await verificaMoedaPix(pegaChave('#txtMoeda'));

      if (moedaPix) {
        if (! await rotinaPagamentoPix()) {
          return;
        }
      }

      if (["1", "3"].includes(pegaChave("#txtTipoMoeda")) && !usaTef) {
        montaTelaParcelas(pegaChave("#txtTipoMoeda") == '1' ? 'cheque' : 'cartao');
        return;
      }

      try {
        let table = $("#tabelaBaixarContas").DataTable();
        let rows = table.rows();
        let count = rows.count();
        let response;
        let Baixas = {};
        let numeros = [];

        // valida se tem saldo
        for (let i = 0; i < rows[0].length; i++) {
          if (rows.data()[i].SALDO == 0) {
            msgAlerta("Registro já está baixado!");
            $("#tabelaBaixarContas").DataTable().rows([i]).remove().draw(false);
            if (rows[0].length == 1) {
              $("#modalBaixar").modal("hide");
            }
            return;
          }
        }

        Baixas = await pegaValoresBaixa();

        if (usaTef && !await verificaChamaTef()) {
          return;
        }

        for (let i = 0; i < count; i++) {
          if (parseFloat(Baixas[i].VALOR_PAGO) <= 0) {
            msgAlerta("Valor pago não pode ser 0");
            return;
          }
          if (Baixas[i].SALDO < 0) {
            msgAlerta("Valor pago não pode ser maior que o valor da duplicata.");
            return;
          }
          
          response = await requisicao(
            "POST",
            "/Sisplan/Receber/V1/BaixaReceber?",
            "",
            `JSON=${encodeURIComponent(JSON.stringify(Baixas[i]))}`
          );
          if (!response) {
            return;
          }
          if (response.status != 200) {
            let sErro = await response.json();
            msgErro(sErro.mensagem);
            return;
          }
        }

        await imprimeBaixasReceber();

        for (let i = 0; i < Baixas.length; i++) {
          numeros.push(Baixas[i].NUMERO);
        }

        const ListaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

        toastr
          .success("Duplicata baixada com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            async onHidden() {
              $("#tabelaBaixarContas").DataTable().rows().remove().draw(false);
              await carregaBaixas(ListaNumeros);
              if (parseFloat(Baixas.SALDO) == 0) {
                $("#modalBaixar").modal("hide");
              }
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
        $("#modalBaixar").modal("hide");
      } catch (error) {
        console.error(error);
        msgErro("Erro ao realizar baixa!");
      }
    } finally {
      $.LoadingOverlay("hide");
      $("#btn-baixar").prop('disabled', false);
    }
  });

  async function imprimeBaixasReceber() {
    const nBaixas = await pegaValoresBaixa();
    let numeros = [];
    for (let i = 0; i < nBaixas.length; i++) {
      numeros.push(nBaixas[i].NUMERO);
    }

    const listaNumeros = `'${numeros.toString().replaceAll(",", "','")}'`;

    url = `/sisplan/impressao/v1/receber?NUMERO=${listaNumeros}`;
    const bImprimeAutomatico = await verificaImprimirAutomatico('BaixasReceber');
    arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'BaixasReceber');
    if (arquivo != undefined && arquivo != "") {
      if (!bImprimeAutomatico) {
        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
      }
      await limparRelatorios();
    }

    await imprimirCupomGerencialBaixa(nBaixas);
  }

  $("#tabelaBaixarContas").on("blur", ".txtvalorPago", async function () {
    let valor = parseFloat($(this).val());
    let saldo = parseFloat(
      $(this).closest("tr")[0].childNodes[7].childNodes[0].data
    );

    if (valor > saldo) {
      msgAlerta("Valor não pode ser maior que o Saldo");
      $(this).val(saldo);
      $(this).closest("tr").find(".txtJuros").val("0");
      $(this).closest("tr").find(".txtDesconto").val("0");
    }
    atualizaValorPago();
    atualizaValorTotal();
    atualizaTotalDesconto();
    atualizaTotalJuros();
    calculaTroco();
  });

  $("#tabelaBaixarContas").on("change", ".txtPercDesconto", async function () {
    const valTotal = $($(this).closest("tr")[0].childNodes[8].childNodes[0])[0].data;
    const percDesc = $(this).val();
    const valDesc = TruncaDecimaisNova(2, (valTotal * percDesc) / 100);
    const index = $(this).closest("tr")[0].rowIndex - 1;
    $($(this).closest("tr")[0].childNodes[3].childNodes[0]).val(valDesc);
    $($(this).closest("tr")[0].childNodes[3].childNodes[0]).trigger('blur');
  });

  // desconto
  $("#tabelaBaixarContas").on("blur", ".txtDesconto", async function () {
    if (
      $($(this).closest("tr")[0].childNodes[5].childNodes[0]).val() > 0 &&
      $(this).val() > 0
    ) {
      msgAlerta("Não é possível ter juros e desconto na mesma duplicata.");
      $(this).val(0);
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
      return;
    }
    if ($($(this).closest("tr")[0].childNodes[5].childNodes[0]).val() > 0) {
      return;
    }
    if (parseFloat($(this).val()) < 0) {
      msgAlerta("Desconto não pode ser menor que 0!");
      $(this).val(0);
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
      return;
    }
    let desconto = parseFloat($(this).val());
    let saldo = parseFloat(
      $(this).closest("tr")[0].childNodes[8].childNodes[0].data
    );
    let novoValor = 0;
    let valorPago = saldo - desconto;
    const percDesc = TruncaDecimaisNova(2, (desconto / saldo) * 100);

    if (valorPago < 0) {
      msgAlerta("Valor pago não pode ser menor que 0!");
      $(this).closest("tr").find(".txtvalorPago").val(saldo);
      $(this).closest("tr").find(".txtJuros").val("0");
      $(this).val("0");
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
      return;
    }

    $(this)
      .closest("tr")
      .find(".txtvalorPago")
      .val(await TruncaDecimais(2, valorPago, novoValor));

    $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(percDesc);

    if (novoValor > saldo) {
      msgAlerta("Valor não pode ser maior que o Saldo");
      $(this).closest("tr").find(".txtvalorPago").val(saldo);
      $(this).closest("tr").find(".txtJuros").val("0");
      $(this).val("0");
      $($('.txtPercDesconto')[$(this).closest("tr")[0].rowIndex - 1]).val(0);
    }
    atualizaValorPago();
    atualizaValorTotal();
    atualizaTotalDesconto();
    atualizaTotalJuros();
    calculaTroco();
  });

  $("#tabelaBaixarContas").on("blur", ".txtJuros", async function () {
    if (
      $($(this).closest("tr")[0].childNodes[3].childNodes[0]).val() > 0 &&
      $(this).val() > 0
    ) {
      msgAlerta("Não é possível ter juros e desconto na mesma duplicata.");
      $(this).val(0);
      return;
    }
    if ($($(this).closest("tr")[0].childNodes[3].childNodes[0]).val() > 0) {
      return;
    }
    if (parseFloat($(this).val()) < 0) {
      msgAlerta("Juros não pode ser menor que 0!");
      $(this).val(0);
      return;
    }
    let juros = parseFloat($(this).val());
    let saldo = parseFloat(
      $("#tabelaBaixarContas")
        .DataTable()
        .rows($(this).closest("tr")[0])
        .data()[0].SALDO
    );
    if (isNaN(juros)) {
      juros = 0;
    }
    if (isNaN(saldo)) {
      saldo = 0;
    }
    let novoValor = 0;
    let valorPago = saldo + juros;
    let valorTotal = await TruncaDecimais(2, valorPago, novoValor);

    $(this).closest("tr").find(".txtvalorPago").val(valorTotal);
    $(this).closest("tr")[0].childNodes[8].childNodes[0].data = valorTotal;

    atualizaValorPago();
    atualizaValorTotal();
    atualizaTotalDesconto();
    atualizaTotalJuros();
    calculaTroco();
  });

  await carregaValoresPadroes();

  $(document).keypress(function (e) {
    if (e.which == 13) {
      e.preventDefault();
    }
  });

  $('#checkTodasEmpresas').on('change', function () {
    if ($('#checkTodasEmpresas')[0].checked == true) {
      carregaEmpresasDisponiveis();
    }
  });


  function atualizaTotalSelecionadas() {
    const data = $("#tabelaReceber").DataTable().rows(".selected").data();
    let valor = 0;

    for (let i = 0; i < data.length; i++) {
      valor += data[i].SALDOTOTAL
    }

    $("#txt_val_selecionadas").html(
      parseFloat(valor).toLocaleString("pt-BR", {
        minimumFractionDigits: 2,
      })
    );

  }

  function adicionaMascaraCampos() {
    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == '') {
        $(this).val('0.00');
      }
    });
  };


  async function verificaCadPadrao() {
    const PesquisaCadPadrao = {
      tabela: "TABPADRAO",
      camposSelect: ["TABPADRAO.CAMPO", "TABPADRAO.TABELA", "TABPADRAO.VALOR"],
      where: ["TABPADRAO.TABELA = 'RECEBER'"]
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCadPadrao));
    const existeCadPadrao = jsonStr.length > 0;
    return existeCadPadrao;
  }

  async function LerCheque(posicao) {
    try {

      let response = await requisicao_ecf('GET', '/cheque/imprimircheque?', "", "", 50000);

      if (!response) {
        msgErro("Não foi possível comunicar com a apiLocal.");
        return;
      }

      if (response.status != 200) {
        msgErro("Erro ao Ler cheque.");
        return;
      }

      response = await response.json();
      $($(".campoBanco")[posicao]).val(response.banco);
      $($(".campoAgencia")[posicao]).val(response.agencia);
      $($(".campoConta")[posicao]).val(response.conta);
      $($(".campoNumero")[posicao]).val(response.numero);

      return;
    } catch (err) {
      console.error(err);
      return;
    }
  }

  async function imprimirCheque(posicao) {
    try {
      const empId = getCookie('emp_id');

      const pesquisa = {
        camposSelect: ['EMPRESA.EMP_CIDADE'],
        tabela: 'EMPRESA',
        where: [`EMPRESA.EMP_ID = ${empId}`]
      };
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
      const cidade = jsonStr[0].EMP_CIDADE;

      const cheque = {
        banco: $($('.campoBanco')[posicao]).val().substring(1, $($('.campoBanco')[posicao]).val().indexOf("]")),
        cidade: cidade,
        data: $($(".campoVencimento")[posicao]).val(),
        valor: $($('.campoValor')[posicao]).val()
      };

      response = await requisicao_ecf('POST', '/cheque/imprimircheque?', "", JSON.stringify(cheque));

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro("Erro ao imprimir cheque.");
        return;
      }

      return;
    } catch (err) {
      console.error(err);
      return;
    }
  }

  async function buscaMultaEmpresa() {
    try {
      const empId = getCookie('emp_id');

      const pesquisa = {
        camposSelect: ['EMPRESA.EMP_MULTA'],
        tabela: 'EMPRESA',
        where: [`EMPRESA.EMP_ID = ${empId}`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      return jsonStr[0].EMP_MULTA == null || jsonStr[0].EMP_MULTA == '' ? 0 : jsonStr[0].EMP_MULTA;
    } catch (err) {
      console.error(err);
      return;
    }
  }

  async function buscaCondicoes(moeda) {
    if ((moeda != '') && (await temCondicoesEspecificas(moeda))) {
      $('#txtCondicaoDePagamento').unbind('autocompleta');
      $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${moeda})"]}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
      $('#btn-CondicaoDePagamento').off();
      $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
      $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${moeda})"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
    } else {
      $('#btn-CondicaoDePagamento').off();
      $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
      $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
      $('#txtCondicaoDePagamento').unbind('autocompleta');
      $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    }
    return;
  }

  async function temCondicoesEspecificas(iMoeda) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND"], "where": ["moeda = ${iMoeda}"] }`,
        null
      );

      if (!response) {
        return false;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return false;
      }
      let bTemCondicoes = jsonStr.RESULT[0].length > 0;
      return bTemCondicoes;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados da moeda.");
      return false;
    }
  }

  function montaJsonPix(nome, valor, numero) {
    return {
      calendario: {
        expiracao: 8640000
      },
      devedor: {
        cpf: '00000000000',
        nome: nome
      },
      valor: {
        original: parseFloat(valor).toFixed(2)
      },
      chave: "",
      solicitacaoPagador: `Duplicata ${numero}`
    }

  }

  async function rotinaPagamentoPix() {
    try {
      $.LoadingOverlay('show');
      const codigoMoeda = pegaChave('#txtMoeda');
      const valor = parseFloat($("#txtTotalPago").val()).toFixed(2);
      const nome = $("#tabelaBaixarContas").DataTable().data().toArray()[0].CLIENTE;
      const numero = $("#tabelaBaixarContas").DataTable().data().toArray()[0].NUMERO;
      const url = '/sisplan/pix/v1/criar?';
      const pixObject = montaJsonPix(nome, valor, numero);
      const response = await requisicao('POST', url, `JSON=${JSON.stringify(pixObject)}&MOEDA=${codigoMoeda}`, '', 300000);

      if (!response) {
        msgErro('Erro ao tentar realizar pagamento via pix.');
        return false;
      }
      const jsonRetorno = await response.json();
      if (response.status != 200) {
        msgErro('Erro ao tentar realizar pagamento via pix.');
        return false;
      } else {
        tempoSegundosPix = 300;
        const parsedJson = JSON.parse(jsonRetorno.mensagem);
        const txid = parsedJson.cob.txid;
        if (!parsedJson.base64) {
          var qrcodjs = new QRious({
            value: parsedJson.cob.brcode
          });
          parsedJson.base64 = qrcodjs.toDataURL().replace("data:image/png;base64,", "");
        }

        const pixBase64 = parsedJson.base64;
        $('#txtPixCopiaCola').val(parsedJson.cob.brcode);
        const codCli = $('#tabelaBaixarContas').DataTable().data().toArray()[0].CODCLI;
        const numero = await getWhatsapp(codCli);
        $('#txtNumeroCelular').val(numero);
        $('#modalPix').modal({
          backdrop: 'static',
          keyboard: false
        })
        // $('#modalPix').modal('show');

        const idTimer = atualizaContador();
        try {
          $('#modalPixBody').html(`<img style="width: 200px" src="data:image/png;base64,${pixBase64}" alt="pix code" />`);
          $('#modalPixBody').append('<br/><h4>Aguardando pagamento...</h4>');
          $('#modalPixBody').append(`<br/><h3 id="contadorPix">${tempoSegundosPix}</h3>`);
          $('#btn-cancelar-pix').off();
          $('#btn-cancelar-pix').on('click', function () {
            clearInterval(idTimer);
            tempoSegundosPix = 0;
            $.LoadingOverlay('hide');
          });

          $('#btn-imprimir-pix').off();
          $('#btn-imprimir-pix').on('click', async function () {
            try {
              $.LoadingOverlay('show');
              try {
                // alterado a rota
                const url = `/sisplan/impressao/v1/imprimirrelpix?`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelPix');
                const objeto = {
                  VALOR: valor,
                  QRCODE: parsedJson.cob.brcode
                }
                const arquivo = await GeraRelatorio(`${url}`, "POST", 100000, false, 'RelPix', `JSON=[${JSON.stringify(objeto)}]`);
                if (arquivo != undefined) {
                  if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                  }
                  await limparRelatorios();
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          });

          const retornoPix = await aguardaPagamentoPix(txid, codigoMoeda);
          return retornoPix === 'CONCLUIDA'
        } finally {
          $('#modalPix').modal('hide');
          $.LoadingOverlay('hide');
          clearInterval(idTimer);
          tempoSegundosPix = 0;
        }
      }
    } catch (error) {
      msgErro('Erro ao tentar realizar pagamento via pix.');
      console.error(error);
      return false;
    }
  }

  const aguardaPagamentoPix = async (txid, moeda) => {
    const url = '/sisplan/pix/v1/consultar?';
    let status = 'ATIVA';
    let tentativasComErro = 0;
    while ((tempoSegundosPix > 0) && (status === 'ATIVA') && (tentativasComErro < 6)) {
      try {
        const response = await requisicao('GET', url, `TXID=${txid}&MOEDA=${moeda}`, '', 10000);
        if (response.status == '200') {
          const jsonRetorno = await response.json();
          const parsedJson = JSON.parse(jsonRetorno.mensagem);
          status = parsedJson.status;
        }
        await aguardarXSegundos(10000);
      } catch (error) {
        tentativasComErro = tentativasComErro + 1;
        console.error(error);
      }
    }
    return status;
    // return new Promise(function(resolve) {
    //   setTimeout((resolve), tempo * 60 * 1000);
    // });
  }

  $("#btnWppPix").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const codCli = $('#tabelaBaixarContas').DataTable().data().toArray()[0].CODCLI;
      const nomeCliente = $('#tabelaBaixarContas').DataTable().data().toArray()[0].CLIENTE;
      const celular = $('#txtNumeroCelular').val();
      const pixCopiaCola = $('#txtPixCopiaCola').val();
      await enviaWhatsAppPix(codCli, nomeCliente, celular, pixCopiaCola, 'ACESSO_RECEBER_PIX')
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  const atualizaContador = () => {
    return setInterval(() => {
      tempoSegundosPix = tempoSegundosPix - 1;
      $('#contadorPix').html(tempoSegundosPix > 0 ? tempoSegundosPix : 0);
    }, 1000)
  }

  function aguardarXSegundos(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
  }

  function aplicaDescAuto(desconto) {
    for (let i = 0; i < $(".txtPercDesconto").length; i++) {
      $($(".txtPercDesconto")[i]).val(desconto);
    }
    $(".txtPercDesconto").trigger("change");
  }

  if (localStorage.getItem('@venda.cliente')) {
    const dados = localStorage.getItem('@venda.cliente');
    $("#txtClienteConsulta").append(new Option(dados, pegaChave(dados), true, true));
    $('#txtClienteConsulta').trigger('change');
    const dia01 = primeiroDia;
    const dia01ISO = dia01.toISOString();
    const dia01String = dia01ISO.substr(0, 10);
    $('#txtVenctoI').val(dia01String);
    $('#txtVenctoF').val('2500-12-31');
    localStorage.removeItem("@venda.cliente");
    $('#btnConsultar').trigger('click');
  }
  else if (localStorage.getItem('faturaByVenda')) {
    const dados = localStorage.getItem('faturaByVenda').split('&');
    $('#txtFatura').val(dados[0]);
    $("#txtClienteConsulta").append(new Option(`[${$.trim(dados[1].split('-')[0])}] - ${$.trim(dados[1].split('-')[1])}`, $.trim(dados[1].split('-')[0]), true, true));
    $('#txtClienteConsulta').trigger('change');
    $('#txtMoedaConsulta').val('');
    $('#Status').val('TODOS');
    $('#txtSituacao').val('Todos');
    $('#txtDataEmiI').val(dados[2]);
    $('#txtDataEmiF').val(dados[2]);
    $('.select2-search__field').addClass('d-none');
    $('#txtVenctoI').val('1200-01-01');
    $('#txtVenctoF').val('2500-12-31');
    $('#txtClienteConsulta').attr('disabled', true).attr('readonly', true);
    $('#btn-ClienteConsulta').attr('disabled', true).attr('readonly', true);
    $('#btn-limpa-ClienteConsulta').attr('disabled', true).attr('readonly', true);
    $('#btnConsultar').trigger('click');
    localStorage.removeItem("faturaByVenda");
  } else {
    $('#btnConsultar').trigger('click');
  }

  $("#btn-limpa-Moeda").on("click", function () {
    $.LoadingOverlay('show');
    setTimeout(function () {
      $("#divNSU").addClass("d-none");
      $("#divCondicoesDePagamento").addClass("d-none");
      $("#txtMoeda").val("");
      $("#txtTipoMoeda").val("");
      $('#txtClasse').val('');
      $('#txtConta').val('');
      // $('#txtClasseBaixa').val('');
      $("#txtHistorico").val('');
      // $("#txtHistoricoBaixa").val('');
      $('#cbNaoLancaCc').prop('checked', false);
      $('#cbNaoLancaCc').prop('disabled', false);

      if (parametrosReceber[7].VALOR == 1) {
        $('#txtClasse').prop('disabled', true);
        $('#btn-Classe').prop('disabled', true);
        $('#btn-limpa-Classe').prop('disabled', true);
        $('#txtConta').prop('disabled', true);
        $('#btnConta').prop('disabled', true);
        $('#btn-limpa-Conta').prop('disabled', true);
        $('#txtHistorico').prop('disabled', true);
        $('#btn-Historico').prop('disabled', true);
        $('#btn-limpa-Historico').prop('disabled', true);
      }
      habilitaTroco();
      $.LoadingOverlay('hide')
    }, 2000);
  });
});