$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#DadosGerais').hasClass('show'));
                    $('#DadosGerais').collapse('show');
                } else
                    if (Element.node.id == 'observacao') {
                        if (!$('#obs').hasClass('show'));
                        $('#obs').collapse('show');
                    }
            }
        });

        driver.defineSteps([{
            element: '#geral',
            popover: {
                title: 'Aba Dados Gerais',
                description: 'Nessa aba, você informará alguns dados para inclusão do contas a receber.',
                position: 'bottom'
            }
        },
        {
            element: '#DadosGerais',
            popover: {
                title: 'Campos Para Inclusão',
                description: 'Aqui você preencherá os dados do contas a receber.',
                position: 'top'
            }
        },
        {
            element: '#RepresentanteInfoTour',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#ClienteInfoTour',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#SituacaoInfoTour',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#statusreceber',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#BancoInfoTour',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtClasse',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#valorreceber',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#observacao',
            popover: {
                title: 'Aba Observação',
                description: 'Nessa aba você poderá adicionar uma observação ao contas a receber.',
                position: 'top'
            }
        },
        {
            element: '#obs',
            popover: {
                title: 'Observação',
                description: 'Aqui você poderá adicionar a observação.',
                position: 'top'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique nesse botão para gravar o contas a receber.',
                position: 'left'
            }
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique nesse botão para voltar a aba de acesso.',
                position: 'left'
            }
        },
        ]);
        // inicio tour 

        driver.start();

        const activeElement = driver.getHighlightedElement();
        // inicior tuor
        // final
    });
});

$(document).ready(async function () {
    const parametro3Receber = await CopiaParametro("RECEBER", 3);
    const permissaoUsuarioLogado = await permissaoAcessos("RECEBER");

    if (permissaoUsuarioLogado.INCLUI == 'N') {
        toastr
            .error(
                `Sem permissão para incluir!`,
                "Alerta",
                {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 2500,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/receber`;
                    },
                }
            )
            .css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            });
        return;
    }

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCNPJ_CH").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    if ($("#txtCNPJ_CH").length > 11) {
        $("#txtCNPJ_CH").mask("00.000.000/0000-00", options);
    } else {
        $("#txtCNPJ_CH").mask("000.000.000-00#", options);
    }

    // autocompleta
    $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#txtnrCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
    $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe CHAVE", "descricao"], "where": null}`);
    $('#txtRepresentante').autocompleta(3, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"]}`);
    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
    $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $("#txtConta").autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": [] }`);
    $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    $('#txtHistorico').autocompleta(1, `JSON={ "tabela": "HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null }`);

    $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
    $('#btn-Caixa').pesquisa('#txtnrCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
    $('#btn-Moeda').pesquisa('#txtMoeda', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe codigo", "descricao"], "where": null}', 'Pesquisa Moeda', 'moeda');
    $('#btn-Representante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`, 'Pesquisa Representante', 'represen');
    $('#btn-Cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Cliente', 'entidade');
    $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
    $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}', "Pesquisa Conta", "cadconta");
    $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
    $("#btnHistorico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}`, "Pesquisa Histórico", "HISTCP");

    $("#btn-limpa-Conta").on("click", function () {
        $("#txtConta").val("");
    });
    $('#btn-limpa-Classe').on('click', function () {
        $('#txtClasse').val('');
    });
    $('#btn-limpa-Representante').on('click', function () {
        $('#txtRepresentante').val('');
    });
    $('#btn-limpa-Cliente').on('click', function () {
        $('#txtCliente').val('');
    });
    $('#btn-limpa-Banco').on('click', function () {
        $('#txtBanco').val('');
    });
    $('#btn-limpa-Situacao').on('click', function () {
        $('#txtSituacao').val('');
    });
    $('#btn-limpa-Caixa').on('click', function () {
        $('#txtnrCaixa').val('');
    });
    $('#btn-limpa-Moeda').on('click', function () {
        $('#txtMoeda').val('');
        $('#dadosCartao').addClass('d-none');
        $('#cartao').addClass('d-none');
    });
    $('#btn-limpa-condicao').on('click', function () {
        $('#txtCondicaoDePagamento').val('');
        $('#txtNrParcelas').val('1');
    });
    $('#btnLimpaHistorico').on('click', function () {
        $('#txtHistorico').val('');
    });

    $('#cbNaoLancaCc').on('click', async function () {
        if (!isChecked(this)) {
            const situacao = pegaChave('#txtSituacao');
            if (situacao != '') {
                const contaCor = await buscaValor('TABSIT', 'GERA_CONTACOR', 'CODIGO', situacao);
                if (contaCor.GERA_CONTACOR == 'S') {
                    msgAlerta(`Situação "${pegaValor('#txtSituacao')}" cadastrada para não lançar conta corrente, deseja realmente alterar?`,
                        () => { $('#cbNaoLancaCc').prop('checked', false); },
                        () => { $('#cbNaoLancaCc').prop('checked', true); }
                    )
                }
            }
        }
    });

    $('#txtStatus').on('change', async function () {
        $('#cbNaoLancaCc').prop('checked', false);
        if ($('#txtStatus').val() == 'CHEQ') {
            $('#divConta').addClass('d-none');
            $('#labelNaoLancaCc').addClass('d-none');
            $('#cbNaoLancaCc').addClass('d-none');
            if (receber == "create") {
                await setarDataAtual('txtDTemissao');
            }
            bloqueiaCampoDataEmissao();
            $('#dadoscheque').removeClass('d-none');
            if (parametro3Receber == '1') {
                $('#nrCaixa').removeClass('d-none');
                $('#Moeda').removeClass('d-none');
            } else {
                $('#nrCaixa').addClass('d-none');
                $('#txtnrCaixa').val('');
                $('#Moeda').addClass('d-none');
                $('#txtMoeda').val('');
            }
            $('#cheque').collapse('show');
        } else if ($('#txtStatus').val() == 'ANTE') {
            $('#nrCaixa').removeClass('d-none');
            $('#Moeda').removeClass('d-none');
            $('#labelNaoLancaCc').removeClass('d-none');
            await validaSituacao(pegaChave('#txtSituacao'));
            $('#cbNaoLancaCc').removeClass('d-none');
            $('#divConta').removeClass('d-none');
            $('#dadoscheque').addClass('d-none')
            $('#cheque').collapse('hide')
            $('#txtEmissor_CH').val('');
            $('#txtNumero_CH').val('');
            $('#txtCNPJ_CH').val('');
            $('#txtConta_CH').val('');
            $('#txtAgencia_CH').val('');
            $('#txtBanco_CH').val('');
            if (receber == "create") {
                await setarDataAtual('txtDTemissao');
            }
            bloqueiaCampoDataEmissao();
        } else {
            $('#dadoscheque').addClass('d-none')
            $('#divConta').addClass('d-none');
            $('#cheque').collapse('hide')
            $('#txtEmissor_CH').val('');
            $('#txtNumero_CH').val('');
            $('#txtCNPJ_CH').val('');
            $('#txtConta_CH').val('');
            $('#txtAgencia_CH').val('');
            $('#txtBanco_CH').val('');
            $('#nrCaixa').addClass('d-none');
            $('#txtnrCaixa').val('');
            $('#Moeda').addClass('d-none');
            $('#txtMoeda').val('');
            $('#labelNaoLancaCc').addClass('d-none');
            $('#cbNaoLancaCc').addClass('d-none');
            bloqueiaCampoDataEmissao(false);
        }
        bloqueiaCampoConta(false);
        bloqueiaCampoBanco(false);
        $("#txtBanco").val("");
        $("#txtConta").val("");
    })

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let achaReceber = queryString.indexOf('receber/') + 8; // + 8 porque é a soma do "receber/""
    let receber = queryString.substr(achaReceber, queryString.length);
    if (receber != "create") {
        receber = atob(receber);
    }
    let numero = receber;
    if (await apenasClientesVinculadosAoRepresentante()) {
        bloqueiaFiltroEPreencheValorRepresentante('#txtRepresentante', '#btn-Representante', '#btn-limpa-Representante');
    }

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('RECEBER', getCookie('usuario'), receber);
        window.location.href = `${BASE_URI}/receber`;
    });

    $('#txtCliente').on('blur', async function () {
        if ($(this).val() != '') {
            let sCodCli = pegaChave('#txtCliente');
            await verificaCliente(sCodCli);
        }
    });

    $('#txtMoeda').on('focusout', async function () {
        const codmoeda = pegaChave(this);
        const status = $("#txtStatus").val();

        if (codmoeda != '') {
            await validaTipoMoeda();
            if (await temCondicoesEspecificas(codmoeda)) {
                $('#txtCondicaoDePagamento').unbind('autocompleta');
                $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond CHAVE", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${codmoeda})"]}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
                $('#btn-CondicaoDePagamento').off();
                $('#btn-CondicaoDePagamento').unbind('pesquisa_array');
                $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "condicao.codcond", "condicao.descricao", "condicao.nrpar"], "where": ["condicao.codcond in (select COND_MOEDA.CODCOND FROM [COND_MOEDA] COND_MOEDA WHERE COND_MOEDA.moeda=${codmoeda})"]}`, 'Pesquisa Condição de Pagamento', 'condicao');
                $('#txtCondicaoDePagamento').on('blur', async function () {
                    const validaCond = await validaCondPagto(pegaChave('#txtCondicaoDePagamento'));
                    if (!validaCond) {
                        return;
                    }
                });
            }
            const infosContaBanco = await retornaContaBancoMoeda(codmoeda);

            if (status == "ANTE") {
                if (infosContaBanco.CONTA != "") {
                    insereValor("#txtConta", infosContaBanco.CONTA, infosContaBanco.DESC_CONTA);
                    bloqueiaCampoConta(true);
                } else {
                    $("#txtConta").val("");
                    bloqueiaCampoConta(false);
                }
            
                if (infosContaBanco.BANCO != "") {
                    insereValor("#txtBanco", infosContaBanco.BANCO, infosContaBanco.NOME_BANCO);
                    bloqueiaCampoBanco(true);
                } else {
                    $("#txtBanco").val("");
                    bloqueiaCampoBanco(false);
                }
            }

        }
    });

    $('#txtSituacao').on('focusout', async function () {
        await validaSituacao(pegaChave(this));
    });

    async function verificaCliente(codcli) {
        if (codcli == '') {
            return;
        }
        try {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["ativo", "bloqueio"],"where": ["codcli = '${codcli}'"]}`, null);

            if (!response) {
                return;
            }

            let jsonEntidade = await response.json();
            if (response.status != 200) {
                jsonEntidade.RESULT[0].mensagem;
                return;
            }
            if (jsonEntidade.RESULT[0][0].BLOQUEIO == 'S') {
                msgAlerta('Cliente bloqueado, impossível continuar.');
                $('#txtCliente').val('');
            } else if (jsonEntidade.RESULT[0][0].ATIVO == 'N') {
                msgAlerta('Cliente inativo, impossível continuar.');
                $('#txtCliente').val('');
            }
        } catch (error) {
            console.error(error);
        }
    };

    $('#txtRepresentante').on('blur', async function () {
        if ($(this).val() != '') {
            let sCodRep = pegaChave('#txtRepresentante');
            await verificaRepresentante(sCodRep);
        }
    });

    $('#fatura').on('keypress', function (event) {
        let regex = new RegExp("^[0-9]+$");
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });

    $('#fatura').on('change', async function () {
        if (receber == 'create') {
            return;
        }
        await rotinaGeraLog('RECEBER', pegaValor('#txtNumero'), 'Alteração da fatura para: ' + pegaValor('#fatura'), 'Alteração');
    });

    async function verificaRepresentante(codrep) {
        if (codrep == '') {
            return;
        }
        try {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"represen", "camposSelect":["ativo"],"where": ["codrep = '${codrep}'"]}`, null);

            if (!response) {
                return;
            }

            let jsonEntidade = await response.json();
            if (response.status != 200) {
                jsonEntidade.RESULT[0].mensagem;
                return;
            }
            if (jsonEntidade.RESULT[0][0].ATIVO == 'N') {
                msgAlerta('Representante inativo, impossível continuar.');
                $('#txtRepresentante').val('');
            }
        } catch (error) {
            console.error(error);
        }
    };

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtBanco: {
                required: true,
            },
            // txtConta: {
            //     required: true,
            // },
            txtSituacao: {
                required: true,
            },
            txtValor: {
                required: true,
            },
            txtRepresentante: {
                required: true,
            },
            txtCliente: {
                required: true,
            },
            txtDTemissao: {
                max: "2500-12-31",
            },
            txtDTvencimento: {
                max: "2500-12-31",
            }
        },
        messages: {
            txtBanco: {
                required: "Informe um Banco válido."
            },
            // txtConta: {
            //     required: "Informe uma Conta."
            // },
            txtSituacao: {
                required: "Informe alguma Situação."
            },
            txtValor: {
                required: "Informe o Valor do Pagamento."
            },
            txtRepresentante: {
                required: "Informe um Representante."
            },
            txtCliente: {
                required: "Informe um Cliente."
            },
            txtDTemissao: {
                max: "Data Inválida."
            },
            txtDTvencimento: {
                max: "Data Inválida."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        },
        async submitHandler(form, event) {

            event.preventDefault();
            try {
                $.LoadingOverlay("show");
                try {

                    if ((parseFloat($('#txtValor').val()) <= 0) || ($('#txtValor').val() == "0,00")) {
                        msgAlerta('Valor não pode ser 0!');
                        return;
                    }

                    if ($('#txtStatus').val() == 0) {
                        msgAlerta('Nenhum status selecionado, impossível continuar!');
                        return
                    }

                    let geraCaixaLoja = false;
                    if ((parametro3Receber == '1') && ($('#txtStatus').val() == 'CHEQ')) {
                        await msgAlerta(
                            'Deseja lançar o valor do cheque no caixa?',
                            async function () {
                                if (pegaChave('#txtnrCaixa') == '') {
                                    msgAlerta('Necessário informar o campo caixa!');
                                    return;
                                }
                                if (pegaChave('#txtMoeda') == '') {
                                    msgAlerta('Necessário informar o campo moeda!');
                                    return;
                                }
                                geraCaixaLoja = true;
                                if (await validaCaixa(geraCaixaLoja)) {
                                    await gravaReceber();
                                }
                            },
                            async function () {
                                geraCaixaLoja = false;
                                if (await validaCaixa(geraCaixaLoja)) {
                                    await gravaReceber();
                                }
                            }
                        );
                    } else {
                        if (await validaCaixa(geraCaixaLoja)) {
                            await gravaReceber();
                        }
                    }

                    async function gravaReceber() {
                        let classe = $('#txtClasse').val().substring(1, $('#txtClasse').val().indexOf('] - '));
                        let situacao = $('#txtSituacao').val().substring(1, $('#txtSituacao').val().indexOf('] - '));
                        let representante = $('#txtRepresentante').val().substring(1, $('#txtRepresentante').val().indexOf('] - '));
                        let cliente = $('#txtCliente').val().substring(1, $('#txtCliente').val().indexOf('] - '));
                        let banco = $('#txtBanco').val().substring(1, $('#txtBanco').val().indexOf('] - '));
                        const nrCaixa = pegaChave('#txtnrCaixa');
                        const moeda = pegaChave('#txtMoeda');
                        const historico = pegaChave('#txtHistorico');
                        let ReceberC = new Object();

                        ReceberC.NUMERO = $('#txtNumero').val();
                        ReceberC.LANCAMENTO = $('#txtLancamento').val();
                        // ReceberC.VALOR = parseFloat($('#txtValorTotal').val());
                        ReceberC.VALOR = parseFloat($('#txtValor').val());
                        if (pegaValor('#txtValorPago') != '') {
                            ReceberC.VALOR_PAGO = parseFloat($('#txtValorPago').val());
                        } else {
                            ReceberC.VALOR_PAGO = 0;
                        }
                        ReceberC.VALOR2 = parseFloat($('#txtValor').val());
                        ReceberC.DT_EMISSAO = `${$('#txtDTemissao').val()}T00:00:00Z`;
                        ReceberC.DT_VENCTO = `${$('#txtDTvencimento').val()}T00:00:00Z`;
                        ReceberC.STATUS = $('#txtStatus').val();
                        ReceberC.OBS = (isChecked('#cbLancarAnte') && ($('#txtStatus').val() == 'CHEQ')) ? $('#txtObs').val() + ` - Criado antecipação para cheque ${$('#txtNumero_CH').val()}` : $('#txtObs').val();
                        ReceberC.CODREP = representante;
                        ReceberC.CODCLI = cliente;
                        ReceberC.SITUACAO = situacao;
                        ReceberC.CLASSE = classe;
                        ReceberC.BANCO = banco;
                        ReceberC.NRCAIXA = nrCaixa;
                        ReceberC.MOEDA = moeda;
                        ReceberC.FATURA = $('#fatura').val();
                        ReceberC.NRO_CUPOM = $('#nroCupom').val();
                        ReceberC.PARCELA = $('#txtParcela').val() == '' ? 0 : parseFloat($('#txtParcela').val());
                        ReceberC.PEDIDO = $('#txtPedido').val();

                        ReceberC.EMISSOR_CH = $('#txtEmissor_CH').val();
                        ReceberC.NUMERO_CH = $('#txtNumero_CH').val();
                        ReceberC.CNPJ_CH = $('#txtCNPJ_CH').val();
                        ReceberC.CONTA_CH = $('#txtConta_CH').val();
                        ReceberC.CONTA_CHEQUE = pegaChave('#txtConta');
                        ReceberC.AGENCIA_CH = $('#txtAgencia_CH').val();
                        ReceberC.BANCO_CH = $('#txtBanco_CH').val();
                        ReceberC.GERACAIXALOJA = geraCaixaLoja;
                        ReceberC.HISTORICO = historico;
                        ReceberC.NAO_LANCA_CC = isChecked('#cbNaoLancaCc');

                        if (ReceberC.CONTA_CH == '') {
                            ReceberC.CONTA_CH = pegaChave('#txtConta');
                        }

                        let response = await requisicao(receber = 'POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(ReceberC))}`);

                        if (!response) {
                            return;
                        }

                        let jsonStr = await response.json();

                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        const numero = jsonStr.numero;
                        const lancamento = jsonStr.lancamento;

                        if (isChecked('#cbLancarAnte') && (ReceberC.STATUS == 'CHEQ')) {
                            const receberClass = {
                                VALOR: ReceberC.VALOR2,
                                VALOR2: ReceberC.VALOR2,
                                DT_EMISSAO: ReceberC.DT_EMISSAO,
                                DT_VENCTO: ReceberC.DT_VENCTO,
                                STATUS: 'ANTE',
                                OBS: `Antecipação do cheque ${$('#txtNumero_CH').val()}.`,
                                CODREP: ReceberC.CODREP,
                                CODCLI: ReceberC.CODCLI,
                                SITUACAO: ReceberC.SITUACAO,
                                CLASSE: ReceberC.CLASSE,
                                BANCO: ReceberC.BANCO,
                                NRCAIXA: ReceberC.NRCAIXA,
                                MOEDA: ReceberC.MOEDA,
                                CONTA_CH: ReceberC.CONTA_CH,
                                NUMERO_CH: ReceberC.NUMERO_CH,
                                GERACAIXALOJA: geraCaixaLoja
                            };

                            response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

                            if (!response) {
                                return;
                            }

                            let jsonStr = await response.json();

                            if (response.status != 200) {
                                msgErro(jsonStr.RESULT[0].mensagem);
                                return;
                            }
                        }

                        if (ReceberC.STATUS == 'ANTE' && $('#txtMoeda').val() != '') { //duplicatas geradas através do pagamento com cartão
                            const tipo = await buscaValor('MOEDA', 'TIPO', 'CODMOE', pegaChave('#txtMoeda'));
                            let sCodCli = await retornaOperadora(pegaChave('#txtMoeda'));
                            if (tipo.TIPO == '3') {
                                let arrayVencimentos;
                                if (pegaChave('#txtCondicaoDePagamento') != '') {
                                    arrayVencimentos = await RetornaVencimentos(pegaChave('#txtCondicaoDePagamento'));
                                }
                                if (typeof arrayVencimentos == "undefined") {
                                    arrayVencimentos = [];
                                    let novoPrazo = new Date();
                                    arrayVencimentos.push(formataData(novoPrazo));
                                }
                                const valorTotal = parseFloat($('#txtValor').val());
                                const nr_parcelas = pegaChave('#txtNrParcelas');
                                const moeda = await buscaValor('MOEDA', 'BANCO, BAIXA, HISTORICO, CODSIT, CLASSE', 'CODMOE', pegaChave('#txtMoeda'));
                                const conta = await RetornaConta(pegaChave('#txtMoeda'));

                                let valorParcela = parseFloat(parseFloat(valorTotal / nr_parcelas).toFixed(2));
                                let guardaValor = valorParcela;
                                let diferenca = 0;
                                if (valorTotal > valorParcela * nr_parcelas || valorTotal < valorParcela * nr_parcelas) {
                                    diferenca = parseFloat(parseFloat(valorTotal - valorParcela * nr_parcelas).toFixed(2));
                                }

                                for (let i = 0; i < nr_parcelas; i++) {
                                    if (diferenca > 0 && i == 0) {
                                        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
                                        diferenca = 0;
                                    } else {
                                        valorParcela = guardaValor;
                                    }
                                    if (diferenca < 0 && i == nr_parcelas - 1) {
                                        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
                                    }
                                    const receberClass = {
                                        VALOR: valorParcela,
                                        VALOR2: valorParcela,
                                        DT_EMISSAO: ReceberC.DT_EMISSAO,
                                        DT_VENCTO: arrayVencimentos[i],
                                        STATUS: 'DUPL',
                                        OBS: `Duplicata gerada pela antecipação ${numero} paga com cartão`,
                                        CODREP: ReceberC.CODREP,
                                        CODCLI: sCodCli,
                                        SITUACAO: ReceberC.SITUACAO,
                                        CLASSE: moeda.CLASSE,
                                        BANCO: moeda.BANCO,
                                        NRCAIXA: ReceberC.NRCAIXA,
                                        MOEDA: ReceberC.MOEDA,
                                        CONTA_CH: conta,
                                        NUMERO_CH: ReceberC.NUMERO_CH,
                                        CARTAO_NSU: $('#txtNSU').val(),
                                        BANDEIRA: $('#select_bandeira').val(),
                                        LANCAMENTO: lancamento,
                                        PARCELA: i + 1,
                                        TAXACARTAO: true,
                                        CONDICAO: pegaChave('#txtCondicaoDePagamento'),
                                        QTDEPARCELAS: pegaChave('#txtNrParcelas'),
                                        HISTORICO: moeda.HISTORICO,
                                        SITUACAO: moeda.CODSIT
                                    };

                                    response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

                                    if (!response) {
                                        return;
                                    }

                                    let jsonStr = await response.json();

                                    if (response.status != 200) {
                                        msgErro(jsonStr.RESULT[0].mensagem);
                                        return;
                                    }

                                    const numeroB = jsonStr.numero;
                                    const taxaBandeira = jsonStr.taxa_bandeira;

                                    if (moeda.BAIXA == '1') {
                                        const receberBClass = await pegaValoresBaixa(numeroB, taxaBandeira, lancamento, valorParcela);

                                        response = await requisicao('POST', '/Sisplan/receber/V1/BaixaReceber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberBClass[0]))}`);

                                        if (!response) {
                                            return;
                                        }

                                        let jsonStr = await response.json();

                                        if (response.status != 200) {
                                            msgErro(jsonStr.RESULT[0].mensagem);
                                            return;
                                        }
                                    }
                                }
                            }
                        }

                        toastr.success(
                            `Cadastro efetuado com sucesso! ` +
                            `Número: ${numero}`,
                            'Confirmação', {
                            toastClass: 'alert',
                            iconClasses: {
                                error: 'alert-error',
                                info: 'alert-info',
                                success: 'alert-success',
                                warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            async onHidden() {
                                await deletaRegistro('RECEBER', getCookie('usuario'), numero);
                                window.location.href = `${BASE_URI}/receber`;
                            }
                        }
                        ).css({
                            "margin-top": "20%",
                            "width": "500px",
                            "max-width": "500px"
                        });
                    }

                } catch (error) {
                    console.error(error);
                    msgErro('Não foi possível gravar os dados da Duplicata: ');
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        }
    });

    if (receber != '' && receber != 'create') {
        if (await liberarRegistro('RECEBER', receber) == false) {
            window.location.href = '../receber';
        } else {
            try {
                $.LoadingOverlay("show");
                try {

                    var response = await requisicao('GET', '/Sisplan/receber/V1/Receber?', `numero=${receber}`, null);

                    if (!response) {
                        return;
                    }

                    var jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }


                    if (jsonStr.length <= 0) {
                        window.location.href = '../receber';
                        return;
                    }

                    let receberJson = jsonStr;

                    try {
                        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.CODREP", "ENTIDADE.NOME", "RECEBER.CONTA_CHEQUE", "RECEBER.PARCELA", "RECEBER.PEDIDO"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = RECEBER.CODREP"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            var representante = '';
                            return;
                        }
                        var jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        insereValor('#txtConta', jsonStr.RESULT[0][0].CONTA_CHEQUE, 'CONTA CADASTRADA');
                        insereValor('#txtParcela', jsonStr.RESULT[0][0].PARCELA);
                        insereValor('#txtPedido', jsonStr.RESULT[0][0].PEDIDO);

                        var representante = `[${jsonStr.RESULT[0][0].CODREP}] - ${jsonStr.RESULT[0][0].NOME}`;

                    } catch (error) {
                        console.error(error);
                        var representante = '';
                    }

                    try {
                        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.CODCLI", "ENTIDADE.NOME"], "leftJoin": [{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = RECEBER.CODCLI"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            var cliente = '';
                            return;
                        }
                        var jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        var cliente = `[${jsonStr.RESULT[0][0].CODCLI}] - ${jsonStr.RESULT[0][0].NOME}`;

                    } catch (error) {
                        console.error(error);
                        var cliente = '';
                    }

                    try {
                        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["CLASSE_GER.CODIGO", "CLASSE_GER.DESCRICAO"], "leftJoin": [{"tabela": "CLASSE_GER", "condicao": "RECEBER.CLASSE = CLASSE_GER.CODIGO"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            var classe = '';
                            return;
                        }
                        var jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        var classe = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

                    } catch (error) {
                        console.error(error);
                        var classe = '';
                    }

                    try {
                        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["HISTCP.HISTORICO", "HISTCP.DESCRICAO"], "leftJoin": [{"tabela": "HISTCP", "condicao": "HISTCP.HISTORICO = RECEBER.HISTORICO"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            var historico = '';
                            return;
                        }
                        var jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        var historico = `[${jsonStr.RESULT[0][0].HISTORICO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

                    } catch (error) {
                        console.error(error);
                        var historico = '';
                    }

                    try {
                        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["TABSIT.CODIGO", "TABSIT.DESCRICAO"], "leftJoin": [{"tabela": "TABSIT", "condicao": "RECEBER.SITUACAO = TABSIT.CODIGO"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);

                        if (!response) {
                            var situacao = '';
                            return;
                        }
                        var jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        var situacao = `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

                    } catch (error) {
                        console.error(error);
                        var situacao = '';
                    }

                    try {
                        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["CADBAN.BANCO", "CADBAN.NOME_BANCO"], "leftJoin": [{"tabela": "CADBAN", "condicao": "RECEBER.BANCO = CADBAN.BANCO"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            var banco = '';
                            return;
                        }
                        var jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        var banco = `[${jsonStr.RESULT[0][0].BANCO}] - ${jsonStr.RESULT[0][0].NOME_BANCO}`;

                    } catch (error) {
                        console.error(error);
                        var banco = '';
                    }

                    let caixa = '';
                    try {
                        const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.NRCAIXA", "CAIXA_LOJA.DESCRICAO"], "leftJoin": [{"tabela": "CAIXA_LOJA", "condicao": "CAIXA_LOJA.CODIGO = RECEBER.NRCAIXA"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            return;
                        }
                        const jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        caixa = `[${jsonStr.RESULT[0][0].NRCAIXA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

                    } catch (error) {
                        console.error(error);
                    }

                    let moeda = '';
                    try {
                        const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.MOEDA", "MOEDA.DESCRICAO"], "leftJoin": [{"tabela": "MOEDA", "condicao": "MOEDA.CODMOE = RECEBER.MOEDA"}], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            return;
                        }
                        const jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        moeda = `[${jsonStr.RESULT[0][0].MOEDA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

                    } catch (error) {
                        console.error(error);
                    }

                    try {
                        const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBER", "camposSelect":["RECEBER.STATUS", "RECEBER.EMISSOR_CH", "RECEBER.CNPJ_CH", "RECEBER.BANCO_CH", "RECEBER.AGENCIA_CH", "RECEBER.CONTA_CH", "RECEBER.NUMERO_CH"], "where": ["RECEBER.NUMERO = '${receber}'"]}`, null);
                        if (!response) {
                            return;
                        }
                        const jsonStr = await response.json();
                        if (response.status != 200) {
                            msgErro(jsonStr.RESULT[0].mensagem);
                            return;
                        }

                        if (jsonStr.RESULT[0][0].STATUS == 'CHEQ') {
                            $('#dadoscheque').removeClass('d-none');
                            $('#cheque').collapse('show');

                            $('#txtNumero_CH').val(jsonStr.RESULT[0][0].NUMERO_CH);
                            $('#txtCNPJ_CH').val(jsonStr.RESULT[0][0].CNPJ_CH);
                            $('#txtBanco_CH').val(jsonStr.RESULT[0][0].BANCO_CH);
                            $('#txtAgencia_CH').val(jsonStr.RESULT[0][0].AGENCIA_CH);
                            $('#txtConta_CH').val(jsonStr.RESULT[0][0].CONTA_CH);
                            $('#txtEmissor_CH').val(jsonStr.RESULT[0][0].EMISSOR_CH);
                        }

                    } catch (error) {
                        console.error(error);
                    }

                    // desabilita os campos q nao podem ser editados
                    if (receberJson[0].SALDO == 0) {
                        $('#btn-Representante').attr('disabled', 'disabled');
                        $('#btn-limpa-Representante').attr('disabled', 'disabled');
                        $('#txtRepresentante').attr('disabled', 'disabled');
                        $('#txtValor').attr('disabled', 'disabled');
                        $('#txtNotaFiscal').attr('disabled', 'disabled');
                        $('#txtSituacao').attr('disabled', 'disabled');
                        $('#txtBanco').attr('disabled', 'disabled');
                        // $('#txtDTvencimento').attr('disabled', 'disabled');
                        $('#txtDTemissao').attr('disabled', 'disabled');
                    }
                    $('#btn-Caixa').attr('disabled', 'disabled');
                    $('#btn-limpa-Caixa').attr('disabled', 'disabled');
                    $('#btn-Moeda').attr('disabled', 'disabled');
                    $('#btn-limpa-Moeda').attr('disabled', 'disabled');
                    $('#txtnrCaixa').attr('disabled', 'disabled');
                    $('#txtMoeda').attr('disabled', 'disabled');
                    $('#divNumero').removeClass('d-none');
                    $('#divDuplicata').addClass('col-md-6');

                    $('#txtNumero').val(receberJson[0].NUMERO);
                    $('#txtLancamento').val(receberJson[0].LANCAMENTO);
                    $('#txtValor').val(receberJson[0].VALOR2);
                    $('#txtValorTotal').val(receberJson[0].VALOR);
                    $('#txtDTvencimento').val(receberJson[0].DT_VENCTO);
                    $('#txtDTemissao').val(receberJson[0].DT_EMISSAO);
                    $('#txtStatus').val(receberJson[0].STATUS);
                    $('#txtObs').val(receberJson[0].OBS);

                    $('#fatura').val(receberJson[0].FATURA);
                    $('#nroCupom').val(receberJson[0].NRO_CUPOM);

                    $('#txtRepresentante').val(representante);
                    $('#txtCliente').val(cliente);
                    $('#txtSituacao').val(situacao);
                    $('#txtClasse').val(classe);
                    $('#txtBanco').val(banco);
                    $('#txtnrCaixa').val(caixa);
                    $('#txtMoeda').val(moeda);
                    $('#txtHistorico').val(historico);
                    $('#txtStatus').trigger('change');

                    if (receberJson[0].VALOR_PAGO > 0) {
                        $('#txtCliente').prop('disabled', true);
                        $('#btn-Cliente').prop('disabled', true);
                        $('#btn-limpa-Cliente').prop('disabled', true);
                        $('#txtStatus').prop('disabled', true);
                        $('#txtDTemissao').prop('disabled', true);
                    }
                    insereValor('#txtValorPago', receberJson[0].VALOR_PAGO);

                    if (await verificaSeTemBaixas(receberJson[0].NUMERO)) {
                        $('#txtValor').prop('disabled', true);
                    }
                } catch (error) {
                    console.error(error);
                    msgErro('Não foi possível buscar os dados do Receber: ');
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    } else {
        $('#txtDTemissao').val(new Date().toISOString().slice(0, 10));
        $('#txtDTvencimento').val(new Date().toISOString().slice(0, 10));
    }

    async function verificaSeTemBaixas(receber) {
        try {
            const response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"RECEBERB", "camposSelect":["NUMERO"], "where": ["NUMERO = '${receber}'"]}`, null);
            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            if (jsonStr.RESULT[0].length != 0) {
                return true;
            }
            return false;


        } catch (error) {
            console.error(error);
        }
    }

    $(function () {
        // $('#txtValor').maskMoney({
        //     decimal: ',',
        //     thousands: '.',
        //     allowZero: true,
        //     defaultZero: true
        // });
        $("#txtValor").inputmask("numeric", {
            min: 0,
            positionCaretOnClick: "select",
            digits: 2
        }).on("focus", function () {
            var that = $(this);
            setTimeout(function () {
                that.select();
            }, 1)
        });
    });

    $('.collapse').on('shown.bs.collapse', function (e) {
        let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

        clicked
            .parent()
            .find(".fa-angle-right")
            .removeClass("fa-angle-right")
            .addClass("fa-angle-down");
    })
        .on('hidden.bs.collapse', function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    async function validaCaixa(bGeraCaixa) {
        if ((bGeraCaixa) || (($('#txtStatus').val() == 'ANTE') && (pegaChave('#txtnrCaixa') != ''))) {
            const bCaixaFechado = await CaixaFechado(pegaChave('#txtnrCaixa'), $('#txtDTemissao').val());
            return !bCaixaFechado;
        } else {
            return true;
        }
    };

    async function CaixaFechado(caixa, data) {
        try {
            $.LoadingOverlay('show');
            try {
                let response = await requisicao('GET', '/Sisplan/vendas/V1/VerificaStatusCaixa?',
                    `CAIXA=${caixa}&DATA=${data}`, null);

                if (!response) {
                    return false;
                }

                var jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return false;
                }

                if (jsonStr == "true") {
                    const dataFormatada = new Intl.DateTimeFormat("pt-BR").format(
                        new Date(`${$('#txtDTemissao').val().split(" ")[0]} 23:59:59`)
                    );
                    msgAlerta(`Caixa já fechado para a data ${dataFormatada}. Para lançar o valor no caixa será necessário reabrir o mesmo.`);
                    return true;
                }

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro('Erro ao verificar se o caixa está fechado ou aberto!');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function bloqueiaCampoDataEmissao(bBloqueia = true) {
        $('#txtDTemissao').prop('disabled', bBloqueia);
        $('#txtDTemissao').prop('readonly', bBloqueia);
    };

    async function addBandeira() {
        $("#select_bandeira").empty();
        const dados = await RetornaBandeiras();
        for (const bandeira of dados) {
            const optionText = bandeira.DESCRICAO;
            const optionValue = bandeira.DESCRICAO;
            $('#select_bandeira').append(`<option value="${optionValue}">
                                                     ${optionText}
                                                  </option>`);

        }
    }

    async function RetornaBandeiras() {
        const _url = `/Sisplan/Funcoes/v1/pesquisa?`;
        const _params = `JSON={ "tabela":"bandeira", "camposSelect":["id_bandeira", "descricao"], "where": ["ativo = 'S'"], "orderby": ["ordem","descricao"]}`;

        try {
            const response = await requisicao('GET', _url, _params, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
            }
            return jsonStr['RESULT'][0];
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as bandeiras de cartões');
        }
    }

    async function validaTipoMoeda() {
        const tipo = await buscaValor('MOEDA', 'TIPO', 'CODMOE', pegaChave('#txtMoeda'));
        if (tipo.TIPO == '3') {
            $('#dadosCartao').removeClass('d-none');
            $('#cartao').removeClass('d-none');
            await addBandeira();
        } else {
            $('#dadosCartao').addClass('d-none');
            $('#cartao').addClass('d-none');
        }
    }

    async function RetornaVencimentos(iCodCondicao) {
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let arrVencimentos = [];
        try {
            let response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
                null
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let nrParcelas = jsonStr.RESULT[0].length;
            let dataAtual = new Date();
            for (let index = 0; index < nrParcelas; index++) {
                let novoPrazo = new Date();
                let nrDia = jsonStr.RESULT[0][index].PRAZO;
                novoPrazo.setDate(dataAtual.getDate() + nrDia);
                arrVencimentos.push(formataData(novoPrazo));
            }
            if (typeof arrVencimentos == "undefined") {
                let novoPrazo = new Date();
                arrVencimentos.push(formataData(novoPrazo));
            }

            return arrVencimentos;
            // alert(jsonStr['RESULT'][0]);
            // return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro("Não foi possível buscar os dados dos vencimentos.");
        }
    }

    async function RetornaConta(moeda) {
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
            let response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"MOEDA_CONTA", "camposSelect":[ "CONTA"], "where": ["MOEDA = ${moeda} AND EMPRESA = ${getCookie('empresa').substring(1, 4)}"] }`,
                null
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            return jsonStr.RESULT[0][0].CONTA;
            // alert(jsonStr['RESULT'][0]);
            // return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro("Não foi possível buscar os dados dos vencimentos.");
        }
    }

    async function retornaOperadora(moeda) {
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        let retorno = pegaChave('#txtCliente');
        try {
            let response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"MOEDA", "camposSelect":[ "USA_ADM_CARTAO", "CODCLI"], "where": ["CODMOE = ${moeda}"] }`,
                null
            );

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            if ((jsonStr.RESULT[0][0].CODCLI != '') && (jsonStr.RESULT[0][0].USA_ADM_CARTAO = 'S')) {
                retorno = jsonStr.RESULT[0][0].CODCLI;
            }
            return retorno;
            // alert(jsonStr['RESULT'][0]);
            // return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro("Não foi possível buscar os dados dos vencimentos.");
        }
    }

    async function temCondicoesEspecificas(iMoeda) {
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        try {
            let response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND"], "where": ["moeda = ${iMoeda}"] }`,
                null
            );

            if (!response) {
                return false;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return false;
            }
            let bTemCondicoes = jsonStr.RESULT[0].length > 0;
            return bTemCondicoes;
        } catch (error) {
            console.error(error);
            msgErro("Não foi possível buscar os dados da moeda.");
            return false;
        }
    }

    async function validaCondPagto(codCond) {
        if (codCond == "") {
            return;
        }

        const url = `/sisplan/funcoes/v1/pesquisa?`;
        let validaCond = Boolean;
        try {
            const response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${codCond}"] }`,
                null
            );

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                return false;
            }

            validaCond = jsonStr.RESULT[0].length > 0;

            if (!validaCond) {
                msgAlerta(
                    `Prazos não configurados, favor verificar a condição de pagamento. \r\n Código da Condição: ${codCond}`
                );
                $("#btn-limpa-moeda").trigger("click");
            }

            return validaCond;
        } catch (error) {
            return false;
        }
    }

    async function pegaValoresBaixa(numeroB, taxaBandeira, lancamento, valorParcela) {
        try {
            let valores = [];
            let objeto = {};

            objeto = {
                VALOR_PAGO: valorParcela - parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
                DESCONTO: 0,
                JUROS: 0,
                CODCLI: pegaChave('#txtCliente'),
                CODREP: pegaChave('#txtRepresentante'),
                DT_EMISSAO: new Date().toISOString().slice(0, 10),
                DT_VENCTO: new Date().toISOString().slice(0, 10),
                EMP_ID: getCookie('emp_id'),
                // LANCAMENTO: lancamento,
                DESP_COBRANCA: parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
                NUMERO: numeroB,
                VALOR: valorParcela,
                VALOR2: valorParcela,
                DT_PAGTO: new Date().toISOString().slice(0, 10),
                DT_CONT: new Date().toISOString().slice(0, 10),
                MOEDA: pegaChave("#txtMoeda"),
                NSU: $("#txtNSU").val(),
                BANDEIRA: $('#select_bandeira').val()
            };

            valores.push(objeto);
            objeto = {};

            return valores;
        } catch (error) {
            console.error(error);
            msgErro("Erro ao pegar os dados da baixa");
        }
    }

    async function validaSituacao(situacao) {
        if (situacao != '') {
            const contaCor = await buscaValor('TABSIT', 'GERA_CONTACOR', 'CODIGO', situacao);
            $('#cbNaoLancaCc').prop('checked', contaCor.GERA_CONTACOR == 'S');
        }
    }

    async function retornaContaBancoMoeda(codMoeda) {
        try {

            const pesquisaParam = {
                tabela: 'MOEDA',
                camposSelect: ["MOEDA_CONTA.CONTA", "CADCONTA.DESCRICAO DESC_CONTA", "CADCONTA.BANCO", "CADBAN.NOME_BANCO"],
                leftJoin: [{tabela: "MOEDA_CONTA", condicao: `MOEDA.CODMOE = MOEDA_CONTA.MOEDA AND MOEDA_CONTA.EMPRESA = '${getCookie("empresa").substring(1)}'`},
                           {tabela: "CADCONTA", condicao: "MOEDA_CONTA.CONTA = CADCONTA.CONTA"},
                           {tabela: "CADBAN", condicao: "CADCONTA.BANCO = CADBAN.BANCO"}],
                where: [`MOEDA.CODMOE = '${codMoeda}'`]
              }
              const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

              return  jsonStr[0];

        } catch (error) {
            console.error(error);
        }
    }

    function bloqueiaCampoConta(bloqueia = true) {
        $("#txtConta").prop("disabled", bloqueia);
        $("#btn-Conta").prop("disabled", bloqueia);
        $("#btn-limpa-Conta").prop("disabled", bloqueia);
    }

    function bloqueiaCampoBanco(bloqueia = true) {
        $("#txtBanco").prop("disabled", bloqueia);
        $("#btn-Banco").prop("disabled", bloqueia);
        $("#btn-limpa-Banco").prop("disabled", bloqueia);
    }
});