$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relatorioCliente == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioCliente: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioCliente: novasColunas }))

      $('#tabelaRelCliente').DataTable().columns().visible(true);
      $('#tabelaRelCliente').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#btnRelCliente',
        popover: {
          title: 'Tabela de cliente',
          description: 'Tabela onde os dados consultados serão listados.',
          position: 'right'
        }
      },
      {
        element: '#buttonColVis',
        popover: {
          title: 'Configurar colunas visíveis ',
          description: 'Clique aqui para selecionar as colunas que deseja retirar da tabela.',
          position: 'right'
        }
      },
      {
        element: '#buttonExcel',
        popover: {
          title: 'Botão Exportar',
          description: 'Clique aqui para exportar a tabela em CSV.',
          position: 'right'
        }
      },
      ]);
      driver.start();
    });
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });
  
  await preencheOrdenacaoTela('RelCliente');

  $('#txtOrdem').val('3');

  //Buscar automaticamente ao digitar
  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"Grupo_CLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtPais').autocompleta(3, `JSON={ "tabela":"CADPAIS", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtCidade').autocompleta(1, `JSON={ "tabela":"CIDADE", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME ||' - '|| CNPJ DESCRICAO, CNPJ"], "where": [] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
  $('#txt-cliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": [] }`, ['#txt-cnpj'], ['CNPJ'], ['CNPJ']);
  $('#txtUf').autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtEmpresa').autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "REPLACE(EMP_PAT, '_', '') CHAVE", "EMP_NOME DESCRICAO"], "where": null}`);
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);


  $('#btn-cliente-filtro').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', 'Pesquisa Cliente');
  $("#btn-grupo-filtro").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"Grupo_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"] }`, "Pesquisa Grupo", "Grupo_CLI");
  $('#btn-pais-filtro').pesquisa_serverside(['#txtPais'], ['CODIGO'], ['NOME'], '{"tabela":"CADPAIS", "camposSelect":[ "CODIGO", "NOME"], "where": null}', 'Pesquisa pais');
  $('#btn-cidade-filtro').pesquisa_serverside(['#txtCidade'], ['CODIGO'], ['NOME'], '{"tabela":"CIDADE", "camposSelect":[ "CODIGO", "NOME"], "where": null}', 'Pesquisa cidade');
  $("#btn-UfConsulta").pesquisa("#txtUf", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"] }`, "Pesquisa UF", "TABUF");
  $("#btn-EmpresaConsulta").pesquisa("#txtEmpresa", "EMP", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"EMPRESA", "camposSelect":[ "REPLACE(EMP_PAT, '_', '') EMP", "EMP_NOME"] }`, "Pesquisa Empresa", "EMPRESA");
  $("#btn-representante-filtro").pesquisa("#txtRepresentante", "CODREP", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"] }`, "Pesquisa de Representante", "REPRESEN");


  $('#txtUf').listaFiltros();
  $('#txtEmpresa').listaFiltros();

  //limpar os campos
  $('#btn-limpa-cliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btn-limpa-grupo').on('click', function () {
    $('#txtGrupo').val('');
  });

  $('#btn-limpa-pais').on('click', function () {
    $('#txtPais').val('');
  });

  $('#btn-limpa-cidade').on('click', function () {
    $('#txtCidade').val('');
  });

  $('#btn-limpa-Empresa').on('click', function () {
    $('#listaEmpresa').val('');
  });

  $('#btn-limpa-Uf').on('click', function () {
    $('#listaUf').val('');
  });

  $('#btn-limpa-representante').on('click', function () {
    $('#txtRepresentante').val('');
  });


  //limpas todos os campos
  $('#btnLimparFiltros').on('click', async function () {
    $('#dtCadastroDe').val('1200-01-01');
    $('#dtCadastroAte').val('2500-12-31');
    $('#txtCliente').val('');
    $('#txtGrupo').val('');
    $('#txtPais').val('');
    $('#dtSemComprasDesde').val('');
    $('#dtComComprasAPartir').val('');
    $('#dtSemComprasLojaDe').val('');
    $('#dtSemComprasLojaAte').val('');
    $('#txtCidade').val('');
    $('#txtListaUfs').val('');
    $('#txtListaEmpresas').val('');
    $('#txtRepresentante').val('');
    $('#cli_tipo').val(0);
    $('#cli_ativo').val(0);
    $('#cli_situacao').val(0);
    $('#cbCliente').prop('checked', false);
    $('#cbFornecedor').prop('checked', false);
    $('#cbTerceiro').prop('checked', false);
    $('#cbRepresentante').prop('checked', false);
    $('#cbProspecto').prop('checked', false);
    $('#cbFuncionario').prop('checked', false);
  });

  $('#txtUf').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtUf').trigger('blur');
      $('#txtUf').focus();
    }
  });

  $('#txtEmpresa').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtEmpresa').trigger('blur');
      $('#txtEmpresa').focus();
    }
  });

  async function retornaFiltros() {
    const cadastroDe = $('#dtCadastroDe').val();
    const cadastroAte = $('#dtCadastroAte').val();
    const dtSemComprasLojaDe = $('#dtSemComprasLojaDe').val() != '' ? $('#dtSemComprasLojaDe').val() : '';
    const dtComComprasLojaPartir = $('#dtSemComprasLojaAte').val() != '' ? $('#dtSemComprasLojaAte').val() : '';
    const dtSemComprasDesde = $('#dtSemComprasDesde').val() != '' ? $('#dtSemComprasDesde').val() : '';
    const dtComComprarAPartir = $('#dtComComprasAPartir').val() != '' ? $('#dtComComprasAPartir').val() : '';
    const cliente = pegaChave('#txtCliente');
    const representante = pegaChave('#txtRepresentante');
    const grupo = pegaChave('#txtGrupo');
    const pais = pegaChave('#txtPais');
    const cidade = pegaChave('#txtCidade');
    const ufs = await formataListas($('#listaUf').val());
    const emps = await formataListas($('#listaEmpresa').val());
    const consFinal = $('#cbCliConsumidorFinal').prop('checked') == true ? 1 : 0;

    const retorno =
      `CADASTRODE=${cadastroDe}` +
      `&CADASTROATE=${cadastroAte}` +
      `&SEMCOMPRASLOJADE=${dtSemComprasLojaDe}` +
      `&SEMCOMPRASLOJAATE=${dtComComprasLojaPartir}` +
      `&SEMCOMPRASDESDE=${dtSemComprasDesde}` +
      `&COMCOMPRASAPARTIRDE=${dtComComprarAPartir}` +
      `&CLIENTE=${cliente}` +
      `&REPRESENTANTE=${representante}` +
      `&GRUPO=${grupo}` +
      `&PAIS=${pais}` +
      `&CIDADE=${cidade}` +
      `&BUSCAPORTIPO=${$('#cli_tipo').prop('selectedIndex')}` +
      `&BUSCAPORATIVO=${$('#cli_ativo').prop('selectedIndex')}` +
      `&UFS=${ufs}` +
      `&EMPS=${emps}` +
      `&BUSCAPORSITUACAO=${$('#cli_situacao').prop('selectedIndex')}` +
      `&CONSFINAL=${consFinal}`;

    return retorno;
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relcliente?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelCliente&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelCliente');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelCliente');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($.fn.DataTable.isDataTable('#tabelaRelCliente')) {
          $('#tabelaRelCliente').DataTable().destroy();
          $('#tabelaRelCliente').empty();
        };
        
        const url = '/sisplan/impressao/v1/consultarelcliente?';
        const filtros = await retornaFiltros();

        const response = await requisicao('GET', url, filtros, null, 200000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          $('#cbCliConsumidorFinal').prop('checked', false);
          msgAlerta('Nenhum registro encontrado!');
          $('#dtCadastroDe').val('');
          $('#dtCadastroAte').val('');
          $('#txtCliente').val('');
          $('#txtGrupo').val('');
          $('#txtPais').val('');
          $('#txtCidade').val('');
          return;
        }

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        const dataSetCols = [];

        dataSetCols.push({
          "title": "CODCLI",
          "data": "CODCLI"
        });

        dataSetCols.push({
          "title": "NOME CLIENTE",
          "data": "NOME_CLI"
        });

        dataSetCols.push({
          "title": "FANTASIA",
          "data": "FANTASIA"
        });

        dataSetCols.push({
          "title": "CPF/CNPJ",
          "data": "CPF_CNPJ"
        });

        dataSetCols.push({
          "title": "ENDEREÇO",
          "data": "ENDERECO"
        });

        dataSetCols.push({
          "title": "DDD",
          "data": "DDD"
        });

        dataSetCols.push({
          "title": "TELEFONE",
          "data": "TELEFONE"
        });

        dataSetCols.push({
          "title": "UF",
          "data": "UF"
        });

        dataSetCols.push({
          "title": "CIDADE",
          "data": "NOME_CIDADE"
        });

        dataSetCols.push({
          "title": "GRUPO",
          "data": "GRUPO"
        });

        dataSetCols.push({
          "title": "CODPAIS",
          "data": "COD_PAIS"
        });

        dataSetCols.push({
          "title": "PAÍS",
          "data": "PAIS"
        });

        dataSetCols.push({
          "title": "DT_NASCIMENTO",
          "data": "DT_NASC"
        });

        dataSetCols.push({
          "title": "DATA_CADASTRO",
          "data": "DATA_CAD"
        });

        dataSetCols.push({
          "title": "EMP_CADASTRO",
          "data": "EMP_CAD"
        });

        dataSetCols.push({
          "title": "SALDO_CASHBACK",
          "data": "SALDO_CASHBACK"
        });

        if ($('#dtSemComprasDesde').val() !== '' || $('#dtComComprasAPartir').val() !== '' || ($('#dtSemComprasLojaDe').val() && $('#dtSemComprasLojaAte').val()) !== '') {
          dataSetCols.push({
            "title": "DT_RECEBER",
            "data": "DT_RECEBER"
          })
        }

        $('#tabelaRelCliente').DataTable({
          order: [],
          sort: true,
          destroy: true,
          bPaginate: true,
          paging: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "colReorder": true,
          "data": jsonStr,
          "columns": dataSetCols,
          "columnDefs": [
            // {
            //   targets: colunas.relatorioCliente ?? [],
            //   visible: false,
            // },
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                })
              },
              "targets": [15],
            }
          ],
        });

        $('#tabelaRelCliente_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelCliente_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultarelcliente?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Clientes', '#tabelaRelCliente');
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelCliente').DataTable().columns(colunas.relatorioCliente ?? []).visible(false);
        $('#tabelaRelCliente').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relatorioCliente).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelCliente').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relatorioCliente ?? [])
  })
});