$(document).ready(async function () {
  var ultimaColunaOrdenada = {
    nome: '',
    ordenacao: 'ASC'
  };



  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para Imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relEstoque == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoque: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEstoque: novasColunas }))

      $('#tabelaRelEstoque').DataTable().columns().visible(true);

      $('#tabelaRelEstoque').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  await preencheOrdenacaoTela('RelEstoque');

  $('#txtOrdem').val('3');

  // let filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

  // if (filtroDeposito = 'null') {
  //   filtroDeposito = await verificaDepositosEmpresaLogada(getCookie('empresa'));
  //   filtroDeposito = filtroDeposito == '' ? 'null' : `["CODIGO IN (${filtroDeposito})"]`;
  // }

  let filtroDeposito = await buscaDepositoEmpresaUsuario();

  const whereDeposito = filtroDeposito != '' ? `"CODIGO IN (${filtroDeposito})"` : null;

  componenteFiltro('produto', true);
  // componenteFiltro('depositoUsuario', true);
  componenteFiltro('colecao', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('cor', true);
  componenteFiltro('grupoPA', true);
  componenteFiltro('qualidade', true);
  componenteFiltro('tamanho', true);
  componenteFiltro('marca', true);
  componenteFiltro('linha', true);
  componenteFiltro('modelo', true);
//  "where": ["ATIVO = 'S'"]}
  
  $('#txtDepositoUsuario').pesquisa_variosServerside(1, `{ "tabela": "DEPOSITO", "camposSelect": ["CODIGO", "DESCRICAO", "EMPRESA"], "where": [${whereDeposito}] }`, 'CODIGO', 'DESCRICAO', 'EMPRESA');
  $('#btnDepositoUsuario').pesquisa_serversideSel('#txtDepositoUsuario', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO", "EMPRESA"], "where": [${whereDeposito}]}`, 'Pesquisa Depósito');
  $('#btnLimpaDepositoUsuario').on('click', function () {
    $('#txtDepositoUsuario').empty().trigger('change');
  })

  await carregaValoresPadroes();

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });


  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'ESTOQUE'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'DEPOSITO': {
          if (item.VALOR != '') {
            adicionaValorPadraoVarios('depositoUsuario', item.VALOR, 'VALOR PADRÃO');
            // var e = jQuery.Event("keypress");
            // e.which = 13;
            // $('#txtDepositoUsuario').trigger(e);
            // $('#listaDeposito').removeClass('d-none');
          }
          break;
        }
        case 'QUALIDADE': {
          if (item.VALOR != '') {
            adicionaValorPadraoVarios('qualidade', item.VALOR, 'VALOR PADRÃO');
          }
          break;
        }
      }
    });
  };

  limparFiltros(true);

  async function retornaFiltros() {
    const tipoItem = 'P';
    const codigo = await formataListas($('#txtProduto').val().toString());
    let deposito = await formataListas($('#txtDepositoUsuario').val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const grupo = await formataListas($('#txtGrupoPA').val().toString());
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const contemEstoque = $('#cbContemEstoque').prop('checked');
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const tamanho = await formataListas($('#txtTamanho').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const modelo = await formataListas($('#txtModelo').val().toString());
    const consideraDeposito = $('#checkDep').prop('checked');
    const consideraLote = $('#checkLot').prop('checked');
    const descontaReserva = $('#checkRes').prop('checked');
    const descontaExpedicao = $('#checkExp').prop('checked');

    deposito = deposito != ''
      ? deposito : filtroDeposito;
    const filtros = `CODIGO=${codigo}` +
      `&DEPOSITO=${deposito}` +
      `&COR=${cor}` +
      `&COLECAO=${colecao}` +
      `&GRUPO=${grupo}` +
      `&QUALIDADE=${qualidade}` +
      `&TIPOITEM=${tipoItem}` +
      `&CONTEMESTOQUE=${contemEstoque}` +
      `&ETIQUETA=${etiqueta}` +
      `&TAMANHO=${tamanho}` +
      `&MARCA=${marca}` +
      `&LINHA=${linha}` +
      `&MODELO=${modelo}` +
      `&CDEPOSITO=${consideraDeposito}` +
      `&CLOTE=${consideraLote}` +
      `&DRESERVA=${descontaReserva}` +
      `&DEXPEDICAO=${descontaExpedicao}`
      ;

    return filtros;
  }


  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/estoque?`;

        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelEstoque&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoque');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelEstoque');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function montaPesquisa(colunaOrdenacao = '') {
    try {

      const sTipoItem = 'PRODUTO';
      const tabelaEstoque = 'PA_ITEN';
      const campoQualidade = 'TIPO';
      const sCodigo = $('#txtProduto').val() != '' ? ` AND ${tabelaEstoque}.CODIGO IN (${await formataListas($('#txtProduto').val().toString())})` : '';
      const sCor = $('#txtCor').val() != '' ? ` AND ${tabelaEstoque}.COR IN (${await formataListas($('#txtCor').val().toString())})` : '';
      const sColecao = $('#txtColecao').val() != '' ? ` AND COLECAO.CODIGO IN (${await formataListas($('#txtColecao').val().toString())})` : '';
      const sGrupo = $('#txtGrupoPA').val() != '' ? ` AND ${sTipoItem}.GRUPO IN (${await formataListas($('#txtGrupoPA').val().toString())})` : '';
      const sEtiqueta = $('#txtEtiqueta').val() != '' ? ` AND PRODUTO.ETIQUETA IN (${await formataListas($('#txtEtiqueta').val().toString())})` : '';
      const sDeposito = $('#txtDepositoUsuario').val() != '' ?
        ` AND ${tabelaEstoque}.DEPOSITO IN (${await formataListas($('#txtDepositoUsuario').val().toString())})`
        : filtroDeposito != '' ? ` AND ${tabelaEstoque}.DEPOSITO IN (${filtroDeposito})` : '';
      const ordemOrdenacao = $('#txtOrdem').val();
      let orderBy = colunaOrdenacao == '' ? await retornaOrderBy(ordemOrdenacao) : colunaOrdenacao;

      const sQualidade = $('#txtQualidade').val() != '' ? ` AND ${tabelaEstoque}.TIPO IN (${await formataListas($('#txtQualidade').val().toString())})` : '';
      // const somenteEstoque = $('#cbContemEstoque').prop('checked') == true ? ` AND ${tabelaEstoque}.QUANTIDADE > 0 ` : '';
      const sTamanho = $('#txtTamanho').val() != '' ? ` AND PA_ITEN.TAM IN (${await formataListas($('#txtTamanho').val().toString())})` : '';
      const sMarca = $('#txtMarca').val() != '' ? ` AND PRODUTO.MARCA IN (${await formataListas($('#txtMarca').val().toString())})` : '';
      const sLinha = $('#txtLinha').val() != '' ? ` AND PRODUTO.LINHA IN (${await formataListas($('#txtLinha').val().toString())})` : '';
      const sModelo = $('#txtModelo').val() != '' ? ` AND PRODUTO.MODELO IN (${await formataListas($('#txtModelo').val().toString())})` : '';

      let camposSelect = '';
      let groupby;
      let cols = [];

      let qtde = '(SUM(PA_ITEN.QUANTIDADE)';

      if ($('#checkRes').prop('checked')) {
        qtde += ` - COALESCE((SELECT SUM(UDF_NVL(PED_RESERVA.QTDE))
                      FROM [PED_RESERVA] PED_RESERVA
                     WHERE PED_RESERVA.CODIGO = PA_ITEN.CODIGO
                       AND PED_RESERVA.COR = PA_ITEN.COR
                       AND PED_RESERVA.TAM = PA_ITEN.TAM
                       AND PED_RESERVA.QUAL = PA_ITEN.TIPO`;

        if ($('#checkDep').prop('checked')) {
          qtde += ' AND PED_RESERVA.DEPOSITO = PA_ITEN.DEPOSITO'
        }
        if ($('#checkLot').prop('checked')) {
          qtde += ' AND PED_RESERVA.LOTE = PA_ITEN.LOTE'
        }
        qtde += '), 0)'
      }

      if ($('#checkExp').prop('checked')) {
        qtde += ` - COALESCE((SELECT SUM(UDF_NVL(PEDIDO3.QTDE))
                       FROM [PEDIDO3] PEDIDO3
                      WHERE PEDIDO3.CODIGO = PA_ITEN.CODIGO
                        AND PEDIDO3.COR = PA_ITEN.COR
                        AND PEDIDO3.TAM = PA_ITEN.TAM
                        AND PEDIDO3.QUALIDADE = PA_ITEN.TIPO`;

        if ($('#checkDep').prop('checked')) {
          qtde += ' AND PEDIDO3.DEPOSITO = PA_ITEN.DEPOSITO'
        }
        if ($('#checkLot').prop('checked')) {
          qtde += ' AND PEDIDO3.LOTE = PA_ITEN.LOTE'
        }
        qtde += '), 0)'
      }

      qtde += ') QTDE';

      camposSelect = ["PA_ITEN.ID_PA_ITEN", "PA_ITEN.CODIGO", "PRODUTO.DESCRICAO DESC_PRODUTO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESCCOR",
        "PA_ITEN.TAM", "COLECAO.CODIGO CODCOLECAO", "COLECAO.DESCRICAO DESCCOLECAO", "PA_ITEN.DEPOSITO", "PA_ITEN.LOTE", qtde, "PA_ITEN.BARRA",
        "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PRODUTO.ETIQUETA", "ETQ_PROD.DESCRICAO DESC_ETIQUETA", "PRODUTO.GRUPO", "GRUPO_PA.DESCRICAO DESC_GRUPO",
        "TABFIS.DESCRICAO NCM", "PRODUTO.MARCA", "MARCA.DESCRICAO DESC_MARCA", "PRODUTO.FAIXA", "PA_ITEN.TIPO QUALIDADE"];

      cols = ["ID_PA_ITEN", "CODIGO", "DESC_PRODUTO", "COR", "DESCCOR", "TAM", "CODCOLECAO", "DESCCOLECAO", "DEPOSITO", "LOTE", "QUANTIDADE",
        "BARRA", "BARRA28", "BARRACLI", "ETIQUETA", "DESC_ETIQUETA", "GRUPO", "DESC_GRUPO",
        "NCM", "MARCA", "DESC_MARCA", "FAIXA", "QUALIDADE"];
      
      groupBySubSelect = ["ID_PA_ITEN", "CODIGO", "DESC_PRODUTO", "COR", "DESCCOR", "TAM", "CODCOLECAO", "DESCCOLECAO", "DEPOSITO", "LOTE", "QTDE",
      "BARRA", "BARRA28", "BARRACLI", "ETIQUETA", "DESC_ETIQUETA", "GRUPO", "DESC_GRUPO",
      "NCM", "MARCA", "DESC_MARCA", "FAIXA", "QUALIDADE"]

      const ligacaoTabelaCor = { "tabela": "CADCOR", "condicao": `CADCOR.COR = ${tabelaEstoque}.COR` };

      const ligacaoProdutoMaterial = { "tabela": `${sTipoItem}`, "condicao": `${sTipoItem}.CODIGO = ${tabelaEstoque}.CODIGO` };

      const ligacaoColecao = { "tabela": "COLECAO", "condicao": `COLECAO.CODIGO = ${sTipoItem}.COLECAO` };

      const ligacaoQualidade = { "tabela": "TABQUL", "condicao": `TABQUL.CODIGO = ${tabelaEstoque}.${campoQualidade}` };

      const ligacaoEtiqueta = { "tabela": "ETQ_PROD", "condicao": "ETQ_PROD.CODIGO = PRODUTO.ETIQUETA" };

      const ligacaoGrupo = { "tabela": "GRUPO_PA", "condicao": "GRUPO_PA.CODIGO = PRODUTO.GRUPO" };

      const ligacaoNCM = { "tabela": "TABFIS", "condicao": "TABFIS.CODIGO = PRODUTO.CODFIS" };

      const ligacaoMarca = { "tabela": "MARCA", "condicao": "MARCA.CODIGO = PRODUTO.MARCA" };

      groupby = ["PA_ITEN.ID_PA_ITEN", "PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO",
        "PA_ITEN.TAM", "COLECAO.CODIGO", "COLECAO.DESCRICAO", "PA_ITEN.DEPOSITO", "PA_ITEN.LOTE", "PA_ITEN.BARRA",
        "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PRODUTO.ETIQUETA", "ETQ_PROD.DESCRICAO", "PRODUTO.GRUPO", "GRUPO_PA.DESCRICAO",
        "TABFIS.DESCRICAO", "PRODUTO.MARCA", "MARCA.DESCRICAO", "PRODUTO.FAIXA", "PA_ITEN.TIPO"]

      if (!$('#checkDep').prop('checked')) {
        camposSelect = camposSelect.filter((e) => (e != 'PA_ITEN.ID_PA_ITEN') && (e != 'PA_ITEN.DEPOSITO'));
        groupby = groupby.filter((e) => (e != 'PA_ITEN.ID_PA_ITEN') && (e != 'PA_ITEN.DEPOSITO'));
        cols = cols.filter((e) => (e != 'ID_PA_ITEN') && (e != 'DEPOSITO'));
      }

      if ((!$('#checkDep').prop('checked')) && (!$('#checkLot').prop('checked'))) {
        groupBySubSelect = groupBySubSelect.filter((e) => (e != 'ID_PA_ITEN') && (e != 'DEPOSITO') && (e != 'LOTE'));
        camposSelect = camposSelect.filter((e) => (e != 'PA_ITEN.ID_PA_ITEN') && (e != 'PA_ITEN.DEPOSITO') && (e != 'PA_ITEN.LOTE'));
        groupby = groupby.filter((e) => (e != 'PA_ITEN.ID_PA_ITEN') && (e != 'PA_ITEN.DEPOSITO') && (e != 'PA_ITEN.LOTE'));
        cols = cols.filter((e) => (e != 'ID_PA_ITEN') && (e != 'DEPOSITO') && (e != 'LOTE'));
        orderBy = orderBy.replaceAll(',DEPOSITO', '').replaceAll('DEPOSITO,', '')
        orderBy = orderBy.replaceAll(',LOTE', '').replaceAll('LOTE,', '');
        orderBy = orderBy.replaceAll(',ID_PA_ITEN', '').replaceAll('ID_PA_ITEN,', '');
      } else if (!$('#checkDep').prop('checked')) {
        groupBySubSelect = groupBySubSelect.filter((e) => (e != 'ID_PA_ITEN') && (e != 'DEPOSITO'));
        camposSelect = camposSelect.filter((e) => (e != 'PA_ITEN.DEPOSITO') && (e != 'PA_ITEN.ID_PA_ITEN'));
        groupby = groupby.filter((e) => (e != 'PA_ITEN.DEPOSITO') && (e != 'PA_ITEN.ID_PA_ITEN'));
        cols = cols.filter((e) => (e != 'DEPOSITO') && (e != 'ID_PA_ITEN'));
        orderBy = orderBy.replaceAll(',DEPOSITO', '').replaceAll('DEPOSITO,', '');
        orderBy = orderBy.replaceAll(',ID_PA_ITEN', '').replaceAll('ID_PA_ITEN,', '');
      } else if (!$('#checkLot').prop('checked')) {
        groupBySubSelect = groupBySubSelect.filter((e) => (e != 'ID_PA_ITEN') && (e != 'LOTE'));
        camposSelect = camposSelect.filter((e) => (e != 'PA_ITEN.LOTE') && (e != 'PA_ITEN.ID_PA_ITEN'));
        groupby = groupby.filter((e) => (e != 'PA_ITEN.LOTE') && (e != 'PA_ITEN.ID_PA_ITEN'));
        cols = cols.filter((e) => (e != 'LOTE') && (e != 'ID_PA_ITEN'));
        orderBy = orderBy.replaceAll(',LOTE', '').replaceAll('LOTE,', '');
        orderBy = orderBy.replaceAll(',ID_PA_ITEN', '').replaceAll('ID_PA_ITEN,', '');
      }

      const pesquisa = {
        tabela: tabelaEstoque,
        camposSelect: camposSelect,
        leftjoin: [ligacaoTabelaCor, ligacaoProdutoMaterial, ligacaoColecao, ligacaoQualidade, ligacaoEtiqueta, ligacaoGrupo, ligacaoNCM, ligacaoMarca],
        where: [`1=1 ${sCodigo} ${sDeposito} ${sCor} ${sColecao} ${sGrupo} ${sQualidade} ${sTamanho} ${sEtiqueta} ${sMarca} ${sLinha} ${sModelo}`],
        groupby: groupby,
        orderby: [orderBy],
        camposSelectSubSelect: groupBySubSelect,
        whereSubSelect: ["QTDE > 0"],
        groupBySubSelect: groupBySubSelect
      }

      if (!$('#cbContemEstoque').prop('checked')) {
        delete pesquisa['whereSubSelect'];
      }

      return {
        pesquisa: pesquisa,
        colunas: cols
      }
    } catch (e) {
      console.log(e);
      msgErro(`Não foi possível buscar os dados: ${e}`);
    }
  }

  async function buscaDados(colunaOrdenacao = '') {
    if ($.fn.DataTable.isDataTable('#tabelaRelEstoque')) {
      $("#tabelaRelEstoque").DataTable().destroy();
      $("#tabelaRelEstoque").empty();
    }

    ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    try {
      try {
        $.LoadingOverlay("show");

        const pesquisa = await montaPesquisa(colunaOrdenacao);
        let dataSetCols = [];

        for (let i = 0; i < pesquisa.colunas.length; i++) {
          dataSetCols.push({
            'title': pesquisa.colunas[i],
            'data': pesquisa.colunas[i],
          });
        }

        // const ajaxData = {
        //   "EMPRESA": getCookie('empresa'),
        //   "JSON": `{"tabela":"${tabelaEstoque}", 
        //             "camposSelect": ${camposSelect}, 
        //             "leftJoin": [${ligacaoTabelaCor},${ligacaoProdutoMaterial},${ligacaoColecao},${ligacaoQualidade}], 
        //             "where": ["1=1 ${sCodigo} ${sDeposito} ${sCor} ${sColecao} ${sGrupo} ${sQualidade} ${somenteEstoque} ${sTamanho} ${sEtiqueta}"],
        //             "orderby": ["${orderBy}"]  
        //           }`,
        //   "CLIENTE": 'N',
        // };

        $('#tabelaRelEstoque').DataTable({
          paging: true,
          colReorder: true,
          lengthChange: true, // habilita o select para mudar a quantidade de itens por página
          lengthMenu: [10, 25, 50, 100], // opções disponíveis no select
          pageLength: 10,
          filter: false,
          info: true,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          sortable: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "GET",
            headers: {
              'Authorization': BASIC_AUTH
            },
            data: {
              EMPRESA: getCookie('empresa'),
              JSON: encodeURIComponent(JSON.stringify(pesquisa.pesquisa)),
              CLIENTE: 'N'
            },
            dataSrc: function (data) {
              const cols = pesquisa.colunas;
              const array = data.data;
              return array.map(row => {
                return row.reduce((obj, value, index) => {
                  obj[cols[index]] = value;
                  return obj;
                }, {});
              });
            }
          },
          "language": {
            "sEmptyTable": "Nenhuma consulta realizada",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhuma consulta realizada",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          columns: dataSetCols,
          columnDefs: [
            { orderable: true, targets: 0 }
          ],
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelEstoque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelEstoque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/Sisplan/Funcoes/v1/pesquisa?';
          const pesquisa = await montaPesquisa();
          await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa.pesquisa))}`, true, null, 'Relatório de Estoque de Produto', '#tabelaRelEstoque');
        })


        $('#tabelaRelEstoque').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relEstoque).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        $('#tabelaRelEstoque th').on('click', async function () {
          const nomeColuna = $(this).html();
          const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
          const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
          await buscaDados(nomeColuna + ' ' + ordenacao);
        });
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados dos itens.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelEstoque').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relEstoque ?? [])
  })

  $('#btnConsultar').on('click', async function () {
    await buscaDados();
  });

  async function retornaOrderBy(ordem) {
    let resultado;
    const pesquisa = {
      tabela: "ORDEM_TELA",
      camposSelect: ["NOME_ORD_SIST"],
      where: [`NOME_TELA = 'RelEstoque' AND ORDEM = ${ordem}`]
    };
    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    resultado = json[0].NOME_ORD_SIST; //'PA_ITEN.COR, PA_ITEN.TAM, PA_ITEN.CODIGO';
    return resultado.replaceAll(';', ',')
  }
});