$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelFaturamento',
      popover: {
        title: 'Tabela Notas',
        description: 'Aqui, após clicar em consultar ficam os dados das notas filtradas.',
        position: 'bottom'
      }
    }
    ]);
    driver.start();
  });
});

$('#btnSelecionarEmpresas').on('click', function () {
  carregaEmpresasDisponiveis();
});

$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relFuncionario == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relFuncionario: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relFuncionario: novasColunas }))

      $('#tabelaRelFuncionario').DataTable().columns().visible(true);
      // $('#tabelaRelFuncionario').DataTable().columns(novasColunas).visible(false);
      $('#tabelaRelFuncionario').DataTable().columns().every(
        function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
            }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  preencheOrdenacaoTela('RelFuncionario');
  addPesquisaAutocompleta();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    limpaFiltros();
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        // alterado a rota
        const url = `/sisplan/impressao/v1/imprimirrelfuncionario?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelFuncionario');
        const arquivo = await GeraRelatorio(`${url}${filtros}&`, 'GET', 100000, false, 'RelFuncionario');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      let dataSetCols = [];
      //  ALTERADO A ROTA
      const url = '/sisplan/impressao/v1/consultarelfuncionario?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#tabelaRelFuncionario").DataTable().clear().draw(false)
        limpaFiltros();
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        dataSetCols.push({
          'title': k,
          'data': k
        });
      });

      criaDataTablePadrao('#tabelaRelFuncionario', true, true, true, true, true, false, false, jsonStr, dataSetCols, [], [6], [], [], '', null, 'buttonColVis', 'buttonExcel', true);

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelfuncionario?';
        const filtros = await retornaFiltros();
        
        await exportaCSV(url, filtros, false, null, 'Relatório de Funcionários', '#tabelaRelFuncionario');
      });

      $('#tabelaRelFuncionario').DataTable().columns().every(
        function () {
            if ((colunasInvisiveis.relFuncionario).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
            }
        })
      // $('#tabelaRelFuncionario').DataTable().columns(colunas.relFuncionario ?? []).visible(false);
      // adicionaColunas(dataSetCols, colunas.relFuncionario ?? []);

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelFuncionario').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': $(this.header()).text()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relFuncionario ?? [])
  })

  $("#btnConsultar").trigger("click");

  function limpaFiltros() {
    $('#dtCadastroDe').val('1200-01-01');
    $('dtCadastroAte').val('2500-12-31');
    $('#dtDemissaoDe').val('dd-mm-aaaa');
    $('#dtDemissaoAte').val('dd-mm-aaaa');
    $('#dtCadSalDe').val('dd-mm-aaaa');
    $('#dtCadSalAte').val('dd-mm-aaaa')
    $('#rgTodos').prop('checked', true);
    $('#rgAtivos').prop('checked', false);
    $('#rgInativo').prop('checked', false);
    $('#txtCargo').val('');
    $('#txtCliente').val('');
    $('#txtTurnoDe').val('');
    $('#txtTurnoAte').val('');
    $('#txtFornecedor').val('');
    $('#txtObra').val('');
    $("#slTurnoDe").val("").prop("selected", true);
    $("#slTurnoAte").val("").prop("selected", true);
    $("#slEmpresa").val("").prop("selected", true);
    $("#slMesAniversario").prop('selectedIndex', 0);
  }

  async function retornaFiltros() {

    let retornaSituacao = '';
    if ($('#rgAtivos').is(':checked')) {
      retornaSituacao = 'S';
    } else if (($('#rgInativos').is(':checked'))) {
      retornaSituacao = 'N';
    }

    const sDataCadI = $('#dtCadastroDe').val();
    const sDataCadF = $('#dtCadastroAte').val();
    const sDataDemI = $('#dtDemissaoDe').val();
    const sDataDemF = $('#dtDemissaoAte').val();
    const sDataSalI = $('#dtCadSalDe').val();
    const sDataSalF = $('#dtCadSalAte').val();
    const sTurnoDe = pegaChave('#txtTurnoDe');
    const sTurnoAte = pegaChave('#txtTurnoAte');
    const sCargo = pegaChave('#txtCargo');
    const sCliente = pegaChave('#txtCliente');
    const sFornecedor = pegaChave('#txtFornecedor');
    const sObra = pegaChave('#txtObra');
    const sEmpresa = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
    : '';
    const sMesAniver = $('#slMesAniversario').val();

    const retorno =
      `DATA_CAD_DE=${sDataCadI}` +
      `&DATA_CAD_ATE=${sDataCadF}` +
      `&DATA_DEM_DE=${sDataDemI}` +
      `&DATA_DEM_ATE=${sDataDemF}` +
      `&DATA_SAL_DE=${sDataSalI}` +
      `&DATA_SAL_ATE=${sDataSalF}` +
      `&SITUACAO=${retornaSituacao}` +
      `&TURNO_DE=${sTurnoDe}` +
      `&TURNO_ATE=${sTurnoAte}` +
      `&CARGO=${sCargo}` +
      `&CLIENTE=${sCliente}` +
      `&FORNECEDOR=${sFornecedor}` +
      `&OBRA=${sObra}` +
      `&EMPRESAS_FILTRO=${sEmpresa}` +
      `&SELECT_MES_ANIVERSARIO=${sMesAniver}`
    return retorno;
  }

  function addPesquisaAutocompleta() {

    $('#txtTurnoDe').autocompleta(2, `JSON={ "tabela":"TURNO", "camposSelect":[ "TURNO CHAVE", "DESCRICAO"], "where": null}`);
    $('#btnConsultaTurnoDe').pesquisa('#txtTurnoDe', 'TURNO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TURNO", "camposSelect":[ "TURNO", "DESCRICAO" ], "where": null}', 'Pesquisar Turno', 'Turno');
    $('#btnLimpaTurnoDe').on('click', function () { $('#txtTurnoDe').val(''); });

    $('#txtTurnoAte').autocompleta(2, `JSON={ "tabela":"TURNO", "camposSelect":[ "TURNO CHAVE", "DESCRICAO"], "where": null}`);
    $('#btnConsultaTurnoAte').pesquisa('#txtTurnoAte', 'TURNO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TURNO", "camposSelect":[ "TURNO", "DESCRICAO" ], "where": null}', 'Pesquisar Turno', 'Turno');
    $('#btnLimpaTurnoAte').on('click', function () { $('#txtTurnoAte').val(''); });

    $('#txtEmpresa').autocompleta(2, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_PAT CHAVE", "EMP_NOME DESCRICAO"], "where": null}`);
    $('#btnConsultaEmpresa').pesquisa('#txtEmpresa', 'EMP_PAT', 'EMP_NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"EMPRESA", "camposSelect":[ "EMP_PAT", "EMP_NOME" ], "where": null}', 'Pesquisar Empresa', 'Empresa');
    $('#btnLimpaEmpresa').on('click', function () { $('#txtEmpresa').val(''); });

    $('#txtCliente').autocompleta(2, `JSON={ "tabela":"entidade", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnClienteConsulta').pesquisa('#txtCliente', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ" ], "where": null}', 'Pesquisar Cliente', 'Cliente');
    $('#btnlimpaCliente').on('click', function () { $('#txtCliente').val(''); });

    $('#txtCargo').autocompleta(2, `JSON={"tabela":"CARGO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnConsultaCargo').pesquisa('#txtCargo', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CARGO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisar Cargo', 'Cargo');
    $('#btnLimpaCargo').on('click', function () { $('#txtCargo').val(''); });

    $('#txtFornecedor').autocompleta(2, `JSON={ "tabela":"entidade", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnConsultaFornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ" ], "where": null}', 'Pesquisar Fornecedor', 'Fornecedor');
    $('#btnLimpaFornecedor').on('click', function () { $('#txtFornecedor').val('') });

    $('#txtObra').autocompleta(2, `JSON={ "tabela":"OBRA", "camposSelect":["CODIGO CHAVE", "CLIENTE DESCRICAO"], "where": null}`);
    $('#btnConsultaObra').pesquisa('#txtObra', 'CODIGO', 'CLIENTE', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OBRA", "camposSelect":[ "CODIGO", "CLIENTE", "PROJETO" ], "where": null}', 'Pesquisar Obra', 'Obra');
    $('#btnLimpaObra').on('click', function () { $('#txtObra').val('') });
  }
});
