$(document).ready(async function () {
  componenteFiltro("cliente", true);
  componenteFiltro("representante", true);
  componenteFiltro("classe", true);
  componenteFiltro("situacao", true);
  componenteFiltro("banco", true);
  componenteFiltro("historico", true);
  componenteFiltro("grupoCli", true);

  await preencheOrdenacaoTela("RELPOSCTASREC");

  $("#btnFiltrosRel").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnLimpaFiltros").on("click", function () {
    limpaFiltros();
  });

  $("#btnCarregaEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  $("#btnConsultar").on("click", async function () {
    await fazConsulta();
  });

  async function fazConsulta() {
    try {
      $.LoadingOverlay('show');
      try {
        const url = "/sisplan/impressao/v1/consultarelposctasrec?";
        const filtros = await retornaFiltros();
        const response = await requisicao("GET",url,`${filtros}&COD_USUARIO=${getCookie("cod_usuario")}`,"", 360000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        if (response.status == 200) {
          msgAlerta("Deu certo");
          return;
        }
      } catch (error) {
        console.error(error);
        msgErro("Não foi possível fazer consulta do relatório! Tente novamente.");
        return;
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const clientesFitlrados = await formataListas($("#txtCliente").val().toString());
    const representantesFiltrados = await formataListas($("#txtRepresentante").val().toString());
    const classesFiltradas = await formataListas($("#txtClasse").val().toString());
    const situacoesFiltradas = await formataListas($("#txtSituacao").val().toString());
    const bancosFiltrados = await formataListas($("#txtBanco").val().toString());
    const historicosFiltrados = await formataListas($("#txtSituacao").val().toString());
    const gruposCliFiltrados = await formataListas($("#txtGrupoCli").val().toString());
    const posicaoDe = $("#txtPosicaoDe").val();
    const posicaoAte = $("#txtPosicaoAte").val();
    const ordemOrdenacao = $("#txtOrdem").val();
    const filtroData = $('input[name="rdfiltroData"]:checked').val();
    const pagtoEntreDataContabil = $("#cbPagtoEntreDtContabil").is(":checked") ? true : false;
    const considerarPerdidas = $("#cbConsideraPerdidas").is(":checked") ? true : false;
    const statusFiltrados = $(".configCheckBusca");
    let statusFiltradosFormatados = "";

    for (i = 0; i < statusFiltrados.length; i++) {
      const valorCb = $(`#${statusFiltrados[i].id}`).val();
      if (statusFiltradosFormatados == "") {
        statusFiltradosFormatados = valorCb;
      } else {
        statusFiltradosFormatados = statusFiltradosFormatados + ", " + valorCb;
      }
    };

    const consideraCliente = $("#cbConsideraCliente").is(":checked") ? true : false;
    const consideraRepresentante = $("#cbConsideraRep").is(":checked") ? true : false;
    const consideraClasses = $("#cbConsideraClasse").is(":checked") ? true : false;
    const consideraSituacoes = $("#cbConsideraSituacao").is(":checked") ? true : false;
    const consideraBanco = $("#cbConsideraBanco").is(":checked") ? true : false;
    const consideraHistorico = $("#cbConsideraHistorico").is(":checked") ? true : false;
    const consideraGrupoCli = $("#cbConsideraGrupoCli").is(":checked") ? true : false;

    const filtros =
      `CLIENTES=${clientesFitlrados}&` +
      `REPRESENTATES=${representantesFiltrados}&` +
      `CLASSES=${classesFiltradas}&` +
      `BANCOS=${bancosFiltrados}&` +
      `SITUACOES=${situacoesFiltradas}&` +
      `HISTORICOS=${historicosFiltrados}&` +
      `GRUPOSCLI=${gruposCliFiltrados}&` +
      `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
      `POSICAODE=${posicaoDe}&` +
      `POSICAOATE=${posicaoAte}&` +
      `ORDEMORDENACAO=${ordemOrdenacao}&` +
      `ENTREDATA=${pagtoEntreDataContabil}&` +
      `FILTRODATA=${filtroData}&` +
      `CONSIDERACLIENTES=${consideraCliente}&` +
      `CONSIDERAREPRESENTANTE=${consideraRepresentante}&` +
      `CONSIDERACLASSES=${consideraClasses}&` +
      `CONSIDERASITUACOES=${consideraSituacoes}&` +
      `CONSIDERABANCOS=${consideraBanco}&` +
      `CONSIDERAHISTORICO=${consideraHistorico}&` +
      `CONSIDERAGRUPOSCLI=${consideraGrupoCli}&` +
      `CONSIDERAPERDIDA=${considerarPerdidas}&` +
      `STATUSFILTRADOS=${statusFiltradosFormatados}`;

    return filtros;
  }

  function limpaFiltros() {
    $("#txtPosicaoDe").val("1200-01-01");
    $("#txtPosicaoAte").val("2500-12-31");
    $("#txtCliente").empty().trigger("change");
    $("#txtRepresentante").empty().trigger("change");
    $("#txtClasse").empty().trigger("change");
    $("#txtSituacao").empty().trigger("change");
    $("#txtBanco").empty().trigger("change");
    $("#txtHistorico").empty().trigger("change");
    $("#txtGrupoCli").empty().trigger("change");
    $("#rdDataPagto").prop("checked", true);
    $("#cbPagtoEntreDtContabil").prop("checked", false);
    $("#cbConsideraPerdidas").prop("checked", false);
    $("#cbDevolucao").prop("checked", false);
    $("#cbOrcamento").prop("checked", false);
    $("#cbAvisoDebito").prop("checked", true);
    $("#cbAntecipacoes").prop("checked", false);
    $("#cbChequesDev").prop("checked", false);
    $("#cbCheques").prop("checked", false);
    $("#cbDuplicatas").prop("checked", true);

    const checksConsidera = $(".checkfiltros");

    for (let i = 0; i < checksConsidera.length; i++) {
      if (!$(`#${checksConsidera[i].id}`).is(":checked")) {
        $(`#${checksConsidera[i].id}`).prop("checked", true);
      }
    }
  }

  $("#tutorial").on("click", function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
      });
      driver.defineSteps([
        {
          element: "#btnFiltrosRel",
          popover: {
            title: "Botão Filtros",
            description:
              "Clique aqui para abrir os filtros e realizar alguma consulta.",
            position: "right",
          },
        },
        {
          element: "#btnImprimir",
          popover: {
            title: "Botão Imprimir",
            description: "Clique aqui para imprimir um relatório.",
            position: "right",
          },
        },
      ]);
      driver.start();
    });
  });
});
