<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Posição de Contas a Receber</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.231.11.1">

    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.231.11.1">
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.231.11.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.231.11.1">
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.229.22.1">
    <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.231.11.1">
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.231.11.1">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.227.20.1">
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.231.11.1">
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.231.11.1" />
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.231.11.1">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.234.11.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.234.11.1">
    <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.234.11.1">
    <style>
        .bordaCampos {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 2%;
            padding-bottom: 0%;
        }

        .bordaCampos:first-child {
            display: flex;
            flex-direction: row;
            flex-wrap: wrap;
            justify-content: flex-end;
            align-items: center;
        }

        .border-Field .textoBorda {
            font-size: 1.0em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1.0px solid var(--font-color) !important;
            padding: 0 1.0em 1.0em 1.0em !important;
            margin: 0 0 1.0em 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
            padding-bottom: 0px !important;
        }

        .form-group {
            margin-bottom: 5px;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <main class="wrapper">
        <?php
        include_once('../../menu.php');
        ?>
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Relatório de Posição de Contas a Receber</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                                <li class="breadcrumb-item active">Relatório de Posição Contas a Receber</li>
                            </ol>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <fieldset>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="buttons">
                                            <button class="btn btn-success btn-sisp" id="btnFiltrosRel" type="button"><span class="fas fa-filter"></span> Filtros</button>
                                            <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="card">
                                        <div class="col-sm-12 table-responsive card-body">
                                            <table id="tabelaPosicaoCtasRec" class="table table-sm table-select table-hover" style="white-space: nowrap" width="100%"></table>
                                            <thead>
                                                <tr></tr>
                                            </thead>
                                            <tbody>
                                                <tr></tr>
                                            </tbody>
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content" id="modalBody">
                    <div class="modal-header col-12">
                        <h4 class="modal-title">Filtros</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-row">
                            <div class="row col-lg-12 col-md-12 col-sm-12">
                                <div class="col-lg-3 col-md-12 col-sm-12">
                                    <fieldset class="form border-Field p-0">
                                        <legend class="textoBorda pb-0 mb-0">Filtro</legend>
                                        <div class="form-row">
                                            <label class="labelCheck ml-3"><input type="radio" id="rdDataPagto" checked name="rdfiltroData" value="0"><span class="checkmark"></span> Data Pagto</label>
                                            <label class="labelCheck ml-3"><input type="radio" id="rdDataContabil" name="rdfiltroData" value="1"><span class="checkmark"></span> Data Contábil</label>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-lg-5 col-md-12 col-sm-12">
                                    <fieldset class="form border-Field p-0">
                                        <legend class="textoBorda pb-0 mb-0">Opções</legend>
                                        <div class="form-rows d-flex justify-content-between">
                                            <label class="labelCheck" for="cbPagtoEntreDtContabil"><input type="checkbox" class="configCheck" id="cbPagtoEntreDtContabil"> Pagamento Entre Data Contábil</label>
                                            <label class="labelCheck" for="cbConsideraPerdidas"><input type="checkbox" class="configCheck" id="cbConsideraPerdidas"> Considerar Perdidas</label>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-lg-4 col-md-12 col-sm-12">

                                    <button id="btnCarregaEmpresas" class="btn btn-danger col-lg-12 col-md-12 col-sm-12 mt-2">Selecionar Empresas</button>
                                </div>
                            </div>
                            <div class="row col-lg-12 col-md-12 col-sm-12">
                                <div class="col-lg-2 col-md-6 col-sm-6">
                                    <label for="txtPosicaoDe">Posição do Dia:</label>
                                    <div class="relative">
                                        <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtPosicaoDe" name="PosicaoDe">
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-6 col-sm-6">
                                    <label for="txtPosicaoAte">Posição Final:</label>
                                    <div class="relative">
                                        <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtPosicaoAte" name="PosicaoAte">
                                    </div>
                                </div>
                                <div class="col-lg-8 col-md-12 col-sm-12 pt-3">
                                    <fieldset class="form border-Field p-0">
                                        <legend class="textoBorda pb-0 mb-0">Buscar</legend>
                                        <div class="form-rows d-flex justify-content-between">
                                            <label class="labelCheck" for="cbDuplicatas"><input type="checkbox" class="configCheckBusca" value="DUPL" checked id="cbDuplicatas"> Duplicatas</label>
                                            <label class="labelCheck" for="cbCheques"><input type="checkbox" class="configCheckBusca" value="CHEQ" id="cbCheques"> Cheques</label>
                                            <label class="labelCheck" for="cbChequesDev"><input type="checkbox" class="configCheckBusca" value="CHDE" id="cbChequesDev"> Cheques Dev</label>
                                            <label class="labelCheck" for="cbAntecipacoes"><input type="checkbox" class="configCheckBusca" value="ANTE" id="cbAntecipacoes"> Antecipações</label>
                                            <label class="labelCheck" for="cbAvisoDebito"><input type="checkbox" class="configCheckBusca" checked value="AVDD" id="cbAvisoDebito"> Aviso Débito</label>
                                            <label class="labelCheck" for="cbOrcamento"><input type="checkbox" class="configCheckBusca" value="ORCA" id="cbOrcamento"> Orçamento</label>
                                            <label class="labelCheck" for="cbDevolucao"><input type="checkbox" class="configCheckBusca" value="DEVO" id="cbDevolucao"> Devolução</label>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="row col-lg-12 col-md-12 col-sm-12">
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraCliente" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas os clientes selecionados na pesquisa, se desmarcado, desconsidera os clientes selecionados na pesquisa e filtra por todos os outros clientes.">
                                      <label data-error="wrong" id="lblInputCliente" data-success="right" for="txtCliente">Cliente: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtCliente" name="txtCliente" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraRep" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas os representantes selecionados na pesquisa, se desmarcado, desconsidera os representantes selecionadas na pesquisa e filtra por todos os outros representantes.">
                                      <label data-error="wrong" data-success="right" for="txtRepresentante">Representante: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtRepresentante" name="txtRepresentante" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraClasse" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas as classes gerenciais selecionadas na pesquisa, se desmarcado, desconsidera as classes gerenciais selecionadas na pesquisa e filtra por todas as outras classes gerenciais.">
                                      <label data-error="wrong" data-success="right" for="txtClasse">Classe: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtClasse" name="txtClasse" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnClasse" name="btnClasse" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaClasse" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row col-lg-12 col-md-12 col-sm-12 form-group">
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraSituacao" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas as situações selecionadas na pesquisa, se desmarcado, desconsidera as situações selecionadas na pesquisa e filtra por todas as outras situações.">
                                      <label data-error="wrong" data-success="right" for="txtSituacao">Situação: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtSituacao" name="txtSituacao" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnSituacao" name="btnSituacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaSituacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraBanco" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas os bancos selecionados na pesquisa, se desmarcado, desconsidera os bancos selecionados na pesquisa e filtra por todos os outros bancos.">
                                      <label data-error="wrong" data-success="right" for="txtBanco">Banco: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtBanco" name="txtBanco" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaBanco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraHistorio" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas os históricos selecionados na pesquisa, se desmarcado, desconsidera os históricos selecionados na pesquisa e filtra por todos os outros históricos.">
                                      <label data-error="wrong" data-success="right" for="txtHistorico">Histórico: </label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtHistorico" name="txtHistorico" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnHistorico" name="btnHistorico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaHistorico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row col-lg-12 col-md-12 col-sm-12">
                                <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                    <input type="checkbox" value="S" class="checkfiltros" id="cbConsideraGrupoCli" data-toggle="tooltip" data-placement="top" checked title="Se marcado, considera apenas os grupos cli selecionados na pesquisa, se desmarcado, desconsidera os grupo cli selecionados na pesquisa e filtra por todos os outros grupos cli.">
                                      <label data-error="wrong" data-success="right" for="txtGrupoCli">Grupo Cliente:</label>
                                    <div class="relative">
                                        <div class="input-group">
                                            <select class="js-example-programmatic js-states form-control" id="txtGrupoCli" name="txtGrupoCli" multiple="multiple"></select>
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnGrupoCli" name="btnGrupoCli" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaGrupoCli" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-start pl-0 pr-3">
                        <div class="form-row col-lg-12 col-md-12 col-sm-12">
                            <div class="col-lg-4 col-md-12 col-sm-12 form-group">
                                <label for="txtOrdem">Opção de Relatório:</label>
                                <div class="relative">
                                    <select id="txtOrdem" class="input-default focus custom-select">
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-8 col-md-12 col-sm-12 form-group d-flex justify-content-end align-items-end pr-2">
                                <button class="btn btn-primary btn-sisp mr-2" id="btnLimpaFiltros" style="background-color: #B22222; border-color: #B22222">
                                    <span class="fas fa-trash"></span> Limpar Filtros
                                </button>
                                <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                                    <span class="fas fa-search"></span> Consultar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside><!-- /.control-sidebar -->
        <?php include_once('../../footer.php'); ?>
    </main><!-- /.wrapper -->

    <script src="plugins/jquery/jquery.min.js?versao=3.235.3.3"></script>
    <script src="dist/js/jquery.maskMoney.min.js?versao=3.235.3.3"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.235.3.3"></script>
    <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.235.3.3"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.235.3.3"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.235.3.3"></script>
    <script src="dist/js/adminlte.min.js?versao=3.235.3.3"></script>
    <script src="dist/js/requisicoes.js?versao=3.235.3.3"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.235.3.3"></script>
    <script src="dist/js/valida_cpf_cnpj.js?versao=3.235.3.3"></script>
    <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.235.3.3"></script>
    <script src="dist/js/dataTables.keyTable.js?versao=3.235.3.3"></script>
    <script src="dist/js/sisplan.js?versao=3.235.3.3"></script>
    <script src="utils/funcoes.js?versao=3.235.3.3"></script>
    <script src="utils/cookies.js?versao=3.235.3.3"></script>
    <script src="dist/js/driver.min.js?versao=3.235.3.3"></script>
    <script src="config.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.235.3.3"></script>
    <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.235.3.3"></script>
    <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.235.3.3"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=2.1.7"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('RELPOSCTASREC');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/relposctasrec/relposctasrec.js?versao=3.231.11.1`;
            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');

            await insereJavaScriptPagina(sArquivo);

            habilitaCamposObrigatoriosTela(nomeTela);

            $(function() {
                $('[data-toggle="tooltip"]').tooltip()
            })
        });
    </script>

</body>

</html>