$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divTabelaVendas',
        popover: {
          title: 'Tabela Vendas',
          description: 'Aqui, após clicar em consultar ficam os dados das vendas filtradas.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relVenda == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relVenda: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relVenda: novasColunas }))

      $('#tabelaRelVenda').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelVenda').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  let utilizaMaterial = await CopiaParametro('VENDA', 17) == 1;

  if (utilizaMaterial == 1) {
    $('#radioMaterial').prop('checked', true);
    adicionaPesquiaPadraoMaterial();
  } else {
    adicionaPesquiaPadraoProduto();
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  const empId = getCookie('emp_id');
  preencheOrdenacaoTela('RelVenda');
  const apenasVendasDoRepresentanteLogado = await apenasClientesVinculadosAoRepresentante();

  function adicionaPesquiaPadraoProduto() {
    $("#lblProduto").text("Produto:");
    $('#txtMaterial').attr('id', 'txtProduto');
    $('#btnMaterial').attr('id', 'btnProduto');
    $('#btnLimpaMaterial').attr('id', 'btnLimpaProduto')
    $('#txtGrupoMA').attr('id', 'txtGrupoPA');
    $('#btnGrupoMA').attr('id', 'btnGrupoPA');
    $('#btnLimpaGrupoMA').attr('id', 'btnLimpaGrupoPA');

    $('#divEtiqueta').removeClass('d-none');
    $('#divMarca').removeClass('d-none');
    $('#divModelo').removeClass('d-none');

    componenteFiltro('venda', true);
    componenteFiltro('moeda', true);
    componenteFiltro('tipoVenda', true);
    componenteFiltro('cliente', true);
    componenteFiltro('vendedor', true);
    componenteFiltro('usuario', true);
    componenteFiltro('produto', true);
    componenteFiltro('cor', true);
    componenteFiltro('colecao', true);
    componenteFiltro('grupoPA', true);
    componenteFiltro('etiqueta', true);
    componenteFiltro('linha', true);
    componenteFiltro('marca', true);
    componenteFiltro('modelo', true);
    componenteFiltro('tabPreco', true);
  }

  function adicionaPesquiaPadraoMaterial() {
    $("#lblProduto").text("Material:");
    $('#txtProduto').attr('id', 'txtMaterial');
    $('#btnProduto').attr('id', 'btnMaterial');
    $('#btnLimpaProduto').attr('id', 'btnLimpaMaterial')
    $('#txtGrupoPA').attr('id', 'txtGrupoMA');
    $('#btnGrupoPA').attr('id', 'btnGrupoMA');
    $('#btnLimpaGrupoPA').attr('id', 'btnLimpaGrupoMA');

    $('#divEtiqueta').addClass('d-none');
    $('#divMarca').addClass('d-none');
    $('#divModelo').addClass('d-none');

    componenteFiltro('venda', true);
    componenteFiltro('moeda', true);
    componenteFiltro('tipoVenda', true);
    componenteFiltro('cliente', true);
    componenteFiltro('vendedor', true);
    componenteFiltro('usuario', true);
    componenteFiltro('material', true);
    componenteFiltro('cor', true);
    componenteFiltro('colecao', true);
    componenteFiltro('grupoMA', true);
    componenteFiltro('linha', true);
    componenteFiltro('tabPreco', true);
  }

  $('#btnFiltros').on('click', async function () {
    $('#cbEmitido').prop('checked', JSON.parse(getCookie('emitidoRelVenda') == '' ? true : getCookie('emitidoRelVenda')));
    $('#cbDevolvido').prop('checked', JSON.parse(getCookie('devolvidoRelVenda') == '' ? true : getCookie('devolvidoRelVenda')));
    $('#cbPendente').prop('checked', JSON.parse(getCookie('pendenteRelVenda') == '' ? true : getCookie('pendenteRelVenda')));
    $('#cbCancelada').prop('checked', JSON.parse(getCookie('canceladaRelVenda') == '' ? true : getCookie('canceladaRelVenda')));
    $('#cbAgrupada').prop('checked', JSON.parse(getCookie('agrupadaRelVenda') == '' ? true : getCookie('agrupadaRelVenda')));
    if (await carregaValoresPadroes()) {
      const usuario = getCookie('cod_usuario');
      const nomeUsuario = getCookie('usuario');
      insereValor($('#txtUsuario'), usuario, nomeUsuario);
    };

    if (apenasVendasDoRepresentanteLogado) {
      await bloqueiaFiltroEPreencheValorRepresentante('#txtVendedor', '#btnVendedor', '#btnLimpaVendedor');
    };

    $('#modal-filtros').modal('show');
  });


  $('#btnLimparFiltros').on('click', async function () {
    $('#dtEmissaoDe').val('');
    $('#dtEmissaoAte').val('');
    $('#txtVenda').empty().trigger('change');
    $('#txtMoeda').empty().trigger('change');
    $('#txtTipoVenda').empty().trigger('change');
    $('#txtCliente').empty().trigger('change');
    $('#txtVendedor').empty().trigger('change');
    $('#txtUsuario').empty().trigger('change');
    $('#txtProduto').empty().trigger('change');
    $('#txtMaterial').empty().trigger('change');
    $('#txtCor').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtGrupoPA').empty().trigger('change');
    $('#txtGrupoMA').empty().trigger('change');
    $("#txtEtiqueta").empty().trigger('change');
    $("#txtLinha").empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtModelo').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#rg_status').val(0);
  });

  $('#radioProduto, #radioMaterial').on('change', async function () {

    if ($('#radioMaterial').is(':checked')) {
      adicionaPesquiaPadraoMaterial();
    } else {
      adicionaPesquiaPadraoProduto();
    }
  });

  async function retornaFiltros() {

    let codigo;
    let grp;

    if ($('#radioMaterial').is(':checked')) {
      codigo = '#txtMaterial';
      grp = '#txtGrupoMA';
    } else {
      codigo = '#txtProduto';
      grp = '#txtGrupoPA';
    }

    const emissaoDe = $('#dtEmissaoDe').val();
    const emissaoAte = $('#dtEmissaoAte').val();
    const venda = await formataListas($('#txtVenda').val().toString());
    const moeda = await formataListas($('#txtMoeda').val().toString());
    const tipovenda = await formataListas($('#txtTipoVenda').val().toString());
    const cliente = await formataListas($('#txtCliente').val().toString());
    const vendedor = await formataListas($('#txtVendedor').val().toString());
    const usuario = await validaFiltroUsuario(
      await formataListas($("#txtUsuario").val().toString())
    );
    const produto = await formataListas($(codigo).val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const grupo = await formataListas($(grp).val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const modelo = await formataListas($('#txtModelo').val().toString());
    const tabela = await formataListas($('#txtTabPreco').val().toString());
    const emitido = $('#cbEmitido').prop('checked');
    const devolvido = $('#cbDevolvido').prop('checked');
    const pendente = $('#cbPendente').prop('checked');
    const cancelada = $('#cbCancelada').prop('checked');
    const agrupada = $('#cbAgrupada').prop('checked');
    const agrupaItens = $('#cbAgrupaItens').prop('checked');
    const tipoItem = $('#radioProduto').prop('checked') ? 'P' : 'M';
    const listaEmpIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];

    const retorno =
      `EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&VENDEDOR=${vendedor}` +
      `&CLIENTE=${cliente}` +
      `&VENDA=${venda}` +
      `&MOEDA=${moeda}` +
      `&TABELA=${tabela}` +
      `&PRODUTO=${produto}` +
      `&MARCA=${marca}` +
      `&TIPOVENDA=${tipovenda}` +
      `&EMITIDO=${emitido}` +
      `&DEVOLVIDO=${devolvido}` +
      `&PENDENTE=${pendente}` +
      `&CANCELADA=${cancelada}` +
      `&AGRUPADA=${agrupada}` +
      `&AGRUPAITENS=${agrupaItens}` +
      `&GRUPO=${grupo}` +
      `&TIPO_ITEM=${tipoItem}` +
      `&USR_CAIXA=${usuario}` +
      `&EMP_IDS=${listaEmpIds}` +
      `&TIPO_ITEM=${tipoItem}` +
      `&ETIQUETA=${etiqueta}` +
      `&COR=${cor}` +
      `&COLECAO=${colecao}` +
      `&LINHA=${linha}` +
      `&MODELO=${modelo}`;

    return retorno;
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/relvenda?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelVenda&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelVenda');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelVenda');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      setCookie('emitidoRelVenda', $('#cbEmitido').prop('checked'));
      setCookie('devolvidoRelVenda', $('#cbDevolvido').prop('checked'));
      setCookie('pendenteRelVenda', $('#cbPendente').prop('checked'));
      setCookie('canceladaRelVenda', $('#cbCancelada').prop('checked'));
      setCookie('agrupadaRelVenda', $('#cbAgrupada').prop('checked'));
      try {
        let dataSetCols = [];
        const url = '/sisplan/impressao/v1/consultarelvenda?';
        const filtros = await retornaFiltros();

        const response = await requisicao('GET', url, filtros, 30000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          if ($.fn.DataTable.isDataTable("#tabelaRelVenda")) {
            $("#tabelaRelVenda").DataTable().destroy();
            $("#tabelaRelVenda").empty();
          }
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaRelVenda').DataTable({
          destroy: true,
          colReorder: true,
          paging: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          data: jsonStr,
          columns: dataSetCols,
          columnDefs: [{
            "render": function (data) {
              return parseFloat(data).toLocaleString('pt-BR', {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              });

            },
            "targets": [5, 6, 14, 15, 17, 18]
          },
          {
            "type": 'date-br',
            "targets": [16],
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            }
          }
          ],
        });

        // if ($.fn.DataTable.isDataTable('#tabelaRelVenda')) {
        //   $("#tabelaRelVenda").DataTable().columns.adjust().draw(false);
        // };

        $('#tabelaRelVenda_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelVenda_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultarelvenda?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Venda', '#tabelaRelVenda');
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelVenda').DataTable().columns(colunas.relVenda ?? []).visible(false);
        $('#tabelaRelVenda').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relVenda).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelVenda').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relVenda ?? [])
  });

  $('#btn-confirmar-empresas').on('click', async function () {
    const EmpresasIds = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : ['']
    $('#txtVendedor').unbind('autocompleta');
    $('#txtVendedor').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "distinct codrep chave", "nome descricao"], "where": null}`, undefined, '', '', undefined, undefined, '', EmpresasIds);
    $('#btn-Vendedor').off();
    $('#btn-Vendedor').unbind('pesquisa');
    $('#btn-Vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "distinct codrep", "nome"]}`, 'Pesquisa Vendedor', 'represen', '', undefined, '', EmpresasIds);
  });

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'LOJA' AND CAMPO = 'RETORNA_USUARIO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    const retornaUsuarioLogado = jsonStr.length <= 0 ? false : jsonStr[0].VALOR == 'S' ? true : false;

    return retornaUsuarioLogado;
  };

});