<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cadastro de Representante</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.239.11.1">
    <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.239.11.1">
    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.239.11.1" />
    <link href='../dist/css/bootstrap.min.css?versao=3.239.11.1'>
    <link rel="stylesheet" href="../dist/css/custom.css?versao=3.239.11.1">
    <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.239.11.1">
    <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.239.11.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.239.11.1">
    <link rel="shortcut icon" href="../favicon.ico">
    <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.239.11.1">
    <!-- Toastr -->
    <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.239.11.1">
    <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.239.11.1" />
    <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.239.11.1">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        #progressbar li {
            list-style-type: none;
            font-size: 12px;
            width: 33.33333%;
            float: left;
            position: relative
        }

        .labelGeral {
            margin-top: 7px;
            margin-bottom: 3px;
        }

        .labelCheck {
            font-size: 120%;
            /* border-bottom: outset 2px;
            border-left: outset 2px; */
            padding: 0.2%;
            margin-left: 1%;
        }

        .configCheck {
            -ms-transform: scale(1.5);
            -moz-transform: scale(1.5);
            -webkit-transform: scale(1.5);
            -o-transform: scale(1.5);
            transform: scale(1.5);
            padding: 10px;
        }

        .radioTipo {
            font-size: 120%;
        }

        .bTipo {
            position: absolute;
            margin-bottom: 50%;
            font-size: 120%;
            font-weight: bolder;
        }

        .pTipo {
            margin-top: 2%;
            margin-left: -1%;
            margin-bottom: 0%;
        }

        .pCartao {
            margin-left: -1%;
            margin-bottom: 0%;
            margin-top: 2%;
        }

        .valMin {
            margin-top: 2%;
        }

        .frete {
            margin-top: 2%;
            margin-left: 0.1%;
        }

        #contas-wrap {
            margin-top: 0%;
        }

        #labelcontas {
            margin-top: 2%;
        }

        .radioTop {
            margin-left: 2%;
            margin-top: 2%;
        }

        .labelFonte {
            font-size: 100%;
            margin-top: 20%;
        }

        .radiosStyle {
            font-size: 120%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .checkboxMoeda {
            border: solid #e0e4e6;
            border-radius: 4px;
            border-width: 2px;
            padding-top: 1.6%;
            padding-bottom: 0%;
        }

        #progressbar #payment:before {
            font-family: 'Font Awesome 5 Free';
            content: "\f085" !important;
        }

        #progressbar #personal:before {
            font-family: 'Font Awesome 5 Free';
            content: "\f0c0" !important;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 0 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php
        include_once('../../../menu.php');
        ?>
        <div id="myModal" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 id="myModalLabel" class="modal-title"></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p id="myModalText"></p>
                    </div>
                    <div class="modal-footer">
                        <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
                        <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-wrapper">
            <section class="content">
                <div class="content-header">
                    <div class="container-fluid">
                        <div class="row mb-2">
                            <div class="col-sm-6 flex">
                            </div>
                            <div class="col-sm-6">
                                <ol class="breadcrumb float-sm-right">
                                    <li class="breadcrumb-item"><a href="../index">Início</a></li>
                                    <li class="breadcrumb-item"><a href="../representante">Acesso Representante</a></li>
                                    <li class="breadcrumb-item active">Cadastro de Representante</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center mt-0">
                        <div class="col-10 text-center p-0 mt-3 mb-2">
                            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                                    <h2>Cadastro de Representante
                                        <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                            <i class="fas fa-question-circle"></i>
                                        </button>
                                    </h2>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mx-0">
                                        <form id="msform">
                                            <ul id="progressbar">
                                                <li class="active" id="account"><strong>Geral</strong></li>
                                                <li id="payment"><strong>Configurações</strong></li>
                                                <li id="personal"><strong>Guias</strong></li>
                                            </ul>
                                            <p>Preencha os dados e clique em avançar para realizar o cadastro de representante</p>
                                            <fieldset class="fsPrincipal">
                                                <div class="form-card" id="formcard1">
                                                    <h2 class="fs-title">Dados Gerais</h2>
                                                    <div class="row">

                                                        <div class="row col-12 mb-2 justify-content-sm-start justify-content-center">
                                                            <div class="col-12 col-md-auto">
                                                                <fieldset class="form border-Field mb-0 pb-0">
                                                                    <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                                                      <input type="checkbox" checked id="checkAtivo">   <label for="checkAtivo">  Ativo</label>
                                                                </fieldset>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                                                            <input type="text" readonly="true" class="input-default focus form-control" id="txtCodigo" required aria-describedby="codError" name="txtCodigo" class="form-control" placeholder="Código do Representante">
                                                        </div>
                                                        <div class="col-lg-8  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtDesc">Nome *</label>
                                                            <input type="text" class="input-default focus form-control" id="txtDesc" required aria-describedby="descError" name="txtDesc" class="form-control" placeholder="Nome">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCpf">CPF/CNPJ *</label>
                                                            <input type="text" readonly class="input-default focus form-control" id="txtCpf" required aria-describedby="alqerror" name="txtCpf" placeholder="CPF/CNPJ">
                                                        </div>
                                                        <div class="col-lg-8  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtIe">Inscrição Estadual</label>
                                                            <input type="text" class="input-default focus form-control" id="txtIe" name="txtIe" placeholder="Inscrição Estadual">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCep">CEP</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCep" name="txtCep" placeholder="CEP">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCep" name="btnCep" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACep" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtBairro">Bairro</label>
                                                            <input type="text" class="input-default focus form-control" id="txtBairro" name="txtBairro" placeholder="Bairro">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtEndereco">Endereço</label>
                                                            <input type="text" class="input-default focus form-control" id="txtEndereco" name="txtEndereco" placeholder="Endereço">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtTelefone">Telefone</label>
                                                            <input type="text" class="input-default focus form-control" id="txtTelefone" name="txtTelefone" placeholder="Telefone">
                                                        </div>
                                                        <div class="col-lg-8  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtEmail">E-Mail</label>
                                                            <input type="email" class="input-default focus form-control" id="txtEmail" name="txtEmail" placeholder="exemplo@exemplo.com">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtComFat">Comissão Fat %</label>
                                                            <input type="text" class="input-default focus form-control" id="txtComFat" name="txtComFat" placeholder="Comissão Faturamento">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtComRec">Comissão Rec %</label>
                                                            <input type="text" class="input-default focus form-control" id="txtComRec" name="txtComRec" placeholder="Comissão Recebimento">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtDiaPagto">Dia Pagamento *</label>
                                                            <input type="text" class="input-default focus form-control" id="txtDiaPagto" name="txtDiaPagto" placeholder="Dia Pagamento Comissão (1 - 31)">
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtCoordenador">Coordenador</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtCoordenador" name="txtCoordenador" placeholder="Coordenador">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnCoordenador" name="btnCoordenador" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnACoordenador" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtTipoEntidade">Tipo Entidade</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtTipoEntidade" name="txtTipoEntidade" placeholder="Tipo Entidade">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnTipoEntidade" name="btnTipoEntidade" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnATipoEntidade" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4  col-12 form-group">
                                                            <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupoCliente">Grupo Cliente</label>
                                                            <div class="input-group">
                                                                <input type="text" class="input-default focus form-control" id="txtGrupoCliente" name="txtGrupoCliente" placeholder="Grupo Cliente">
                                                                <div class="input-group-append">
                                                                    <button class="btn bg-danger" id="btnGrupoCliente" name="btnGrupoCliente" data-button="absolute" type="button">
                                                                        <i class="m-0 p-0 fas fa-search"></i>
                                                                    </button>
                                                                    <button class="btn bg-danger" id="btnAGrupoCliente" type="button">
                                                                        <i class="m-0 p-0 fas fa-trash"></i>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-12 justify-content-sm-start justify-content-center">
                                                            <div class="row">
                                                                <fieldset class="form border-Field mb-0 pb-0">
                                                                    <legend class="textoBorda mb-0 pb-0">Tipo</legend>
                                                                    <div class="">
                                                                        <div class="row ">
                                                                            <div class="">
                                                                                <div class="d-block d-md-flex">
                                                                                    <div class="ml-4"><label><input type="radio" id="radioRepresentante" name="tipo"> <span class="checkmark"></span>  Representante de Vendas</label></div>
                                                                                    <div class="ml-4"><label><input type="radio" checked id="radioVendedor" name="tipo"> <span class="checkmark"></span>  Vendedor Loja</label></div>
                                                                                    <div class="ml-4"><label><input type="radio" id="radioGerente" name="tipo"><span class="checkmark"></span>  Gerente</label></div>
                                                                                    <div class="ml-4"><label><input type="radio" id="radioGuia" name="tipo"> <span class="checkmark"></span>  Guia </label></div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </fieldset>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                                <input type="button" name="avancar1" class="btn-sisp next action-button" id="avancar1" value="Avançar" />
                                                <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                                            </fieldset>
                                            <fieldset class="fsPrincipal">
                                                <div class="form-card">
                                                    <div class="row" id="tourEmpresas">
                                                        <h2>Selecionar Empresas</h2>
                                                        <div class="col-md-12 col-12">
                                                            <div class="table-responsive">
                                                                <table id="tabela-empAcesso" class="table table-sm table-select table-hover">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Sel</th>
                                                                            <th>Empresa</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-card">
                                                    <div class="row" id="tourSetores">
                                                        <h2>Selecionar Setores</h2>
                                                        <div class="col-md-12 col-12">
                                                            <div class="table-responsive">
                                                                <table id="tabelaSetores" class="table table-sm table-select table-hover" width="100%">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>Sel</th>
                                                                            <th>Codigo</th>
                                                                            <th>Setores</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="button" name="avancar2" class="next action-button" value="Avançar" id="avancar2" />
                                                <input type="button" name="voltar" class="previous action-button-previous" value="Voltar" id="voltar" />
                                            </fieldset>
                                            <fieldset class="fsPrincipal">
                                                <div class="form-card">
                                                    <h2 class="fs-title">Cadastro de Guias do Representante</h2>
                                                    <div class="row" id="tourGuias">
                                                        <label data-error="wrong" data-success="right" for="txtGuia">Guia </label>
                                                        <div class="input-group">
                                                            <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGuia" name="txtGuia" class="form-control" placeholder="Código do Guia">
                                                            <div class="input-group-append">
                                                                <button class="btn bg-danger" id="btn-Guia" name="btn-Guia" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 col-12" style="margin-top: 15px;">
                                                        <div class="table-responsive">
                                                            <table id="tabelaGuias" class="table table-sm table-select table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Codrep</th>
                                                                        <th>Nome</th>
                                                                        <th>Excluir</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <input type="button" name="next" class="btn-sisp action-button" value="Gravar" id="gravar">
                                                <input type="button" name="voltar" class="previous action-button-previous" value="Voltar" id="voltar" />
                                            </fieldset>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <?php
    include_once('../../../footer.php');
    ?>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.control-sidebar -->
    </div>

    <!-- jQuery -->
    <script src="../plugins/jquery/jquery.min.js?versao=3.239.11.1"></script>
    <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.239.11.1"></script>
    <!-- SweetAlert2 -->
    <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.239.11.1"></script>
    <script src="../plugins/toastr/toastr.min.js?versao=3.239.11.1"></script>

    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>

    <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/adminlte.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/requisicoes.js?versao=3.239.11.1"></script>
    <script src="../dist/js/cliente/entidade.js?versao=3.239.11.1"></script>
    <script src="../dist/js/loadingoverlay.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/valida_cpf_cnpj.js?versao=3.239.11.1"></script>
    <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/sisplan.js?versao=3.239.11.1"></script>
    <script src="../utils/funcoes.js?versao=3.239.11.1"></script>
    <script src="../utils/cookies.js?versao=3.239.11.1"></script>
    <script src="../dist/js/driver.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/jquery.maskMoney.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/jquery.mask.min.js?versao=3.239.11.1"></script>
    <script src="../dist/js/dataTables.keyTable2.js?versao=3.239.11.1"></script>
    <script type="text/javascript" src="../config.js?versao=3.239.11.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('REPRESENTANTE');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            const permissaoUsuarioLogado = await permissaoAcessos("REPRESENTANTE");

            if (permissaoUsuarioLogado.INCLUI == 'N') {
                await criaMensagemErro("Sem permissão para incluir!", () => {
                    window.location.href = `${BASE_URI}/representante`
                });
                return;
            }

            const queryString = window.location.href;
            const parametros = queryString.split("/");
            const representante = parametros[parametros.length - 1];

            $(window).on("beforeunload", function(e) {
                e.preventDefault();
                deletaRegistro("REPRESENTANTE", getCookie("usuario"), representante);
                return undefined;
            });

            sArquivo = `${BASE_URI}/pages/representante/cadastro_representante/representante.js?versao=3.239.11.1`;
            insereJavaScriptPagina(sArquivo);

            const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
            habilitaCamposObrigatoriosTela(nomeTela);
        });
    </script>
</body>

</html>