$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#collapseFiltros',
            popover: {
                title: 'Filtros Disponíveis',
                description: 'Filtre os dados conforme sua necessidade.',
                position: 'top'
            }
        },
        {
            element: '#tabelaRegistros_wrapper',
            popover: {
                title: 'Registros bloqueados',
                description: 'Aqui você verá os registros bloqueados, ou seja, que ficaram presos por algum usuário.',
                position: 'top'
            }
        },
        {
            element: '#btn-liberar',
            popover: {
                title: 'Botão Liberar',
                description: 'Aqui você efetuará a liberação dos registros selecionados na lista.',
                position: 'top'
            }
        }
        ]);
        //inicio tour

        driver.start();

        // inicior tuor
        //final
    });
});
$(document).ready(async function () {


    var tabelaRegistros = $('#tabelaRegistros').DataTable({
        destroy: true,
        select: true,
        keys: true,
        searching: true,
        lengthChange: false,
        scrollY: "400px",
        scrollCollapse: true,
        paging: false,
        "scrollCollapse": true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar (geral): ",
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    async function buscaRegistros() {
        var _url = `/sisplan/controleedicao/v1/controleedicao?`;
        var sTela = $('#txtTela').val();
        sTela = sTela == '' ? 'TODOS' : sTela;
        try {
            $.LoadingOverlay("Show");
            try {
                var response = await requisicao('GET', _url, `TELA=${sTela}&VALOR=${$('#txtValor').val()}&USUARIO_FILTRO=${$('#txtUsuario').val()}`, null);

                if (!response) {
                    return;
                }

                var jsonStr = await response.json()
                if (response.status != 200) {
                    msgErro(jsonStr['RESULT'][0].mensagem);
                    return;
                }

                return jsonStr;
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados do produto.');
            }
        } finally {
            $.LoadingOverlay("Hide");
        }
    }

    $('#btn-liberar').on('click', async function () {
        for (let i = 0; i < $('.campoCheck.selecionado').length; i++) {
            var indice = $('.campoCheck.selecionado')[i].closest('tr').rowIndex - 1;
            var data = $('#tabelaRegistros').DataTable().row(indice).data();
            await deletaRegistro(data.TELA, data.USUARIO, data.VALOR);
        }
        if ($('.campoCheck.selecionado').length > 0) {
            msgSucesso('Processo concluído');
        }
        $('#btn-consultar').trigger('click');
    });

    $('#btnLimparFiltros').click(async function () {
        $('#txtTela').val('');
        $('#txtUsuario').val('');
        $('#txtValor').val('');
    });

    $('#btn-consultar').on('click', async function () {

        var dataSet = await buscaRegistros();
        var dataSetCols = [];

        if (dataSet.length > 0) {
            var keys = Object.keys(dataSet[0]);
            dataSetCols.push({
                'title': 'SEL',
                'data': 'SEL',
                'width': '15px'
            });

            dataSetCols[0].render = function (data, type, row, meta) {
                return '<div class="group-default form-group">' +
                    '<div class="relative">' +
                    '<input style="height:20px" type="checkbox" id="check_col_' + [meta.row] + '_row_' + [meta.col] + '" class="input-default focus form-control validate campoCheck"> ' +
                    '</div>' +
                    '</div>';
            }

            for (var k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k]
                });
            }
            dataSetCols[4].type = 'date-br';

            tabelaRegistros = $('#tabelaRegistros').DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: true,
                lengthChange: false,
                scrollY: "400px",
                scrollCollapse: true,
                paging: false,
                "scrollCollapse": true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar (geral): ",
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                "data": dataSet,
                "columns": dataSetCols,
                "columnDefs": [{
                    className: "dt-head-center"
                }]
            });

            $('.campoCheck').on('change', function () {
                if (this.checked) {
                    $(this).addClass('selecionado');
                } else {
                    $(this).removeClass('selecionado');
                }
            });
        } else {
            tabelaRegistros = $('#tabelaRegistros').DataTable({
                autoWidth: true,
                destroy: true,
                "scrollCollapse": true,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar (geral): ",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                "data": dataSet,
                "columnDefs": [{
                    className: "dt-head-center"
                }]
            });
        }
        $('#modal-filtros').modal('hide');
    });


    $('#btn-consultar').trigger('click');
});