$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#campostour',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#tipos',
                popover: {
                    title: 'Tipo da Situação',
                    description: 'Aqui definimos para qual tipo será a situação, material ou produto.',
                    position: 'top'
                }
            },
            {
                element: '#opcoes',
                popover: {
                    title: 'Opções da Situação',
                    description: 'Aqui definimos os bloqueios que essa situação terá.',
                    position: 'top'
                }
            },
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Código',
                    description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                    position: 'top'
                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descrição',
                    description: 'Neste campo adicionamos a descrição para a situação.',
                    position: 'top'
                }
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Botão Voltar",
                    description:
                        "Ao clicar nesse botão você retorna para a tela de consulta.",
                    position: "left",
                },
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar a situação.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtCodigo').prop('disabled', true);

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let situacao = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('SITUACAO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/situacao`;
    });

    $(document).ready(async function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        if (situacao != '' && situacao != 'create') {

            if (await liberarRegistro('SITUACAO', situacao) == false) {
                window.location.href = '../situacao';
            } else {
                carregaDados(situacao);
            }
        }

        async function carregaDados(situacaoUrl) {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"sitprod", 
                            "camposSelect":["codigo", "descricao", "tipo", "bloq_fat", "bloq_prod", "bloq_qtde_max"], 
                            "where": ["codigo = '${situacaoUrl}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

                    if (jsonStr.RESULT[0][0].TIPO == 'PROD') {
                        $('#radioProduto').prop('checked', true);
                    };
                    if (jsonStr.RESULT[0][0].TIPO == 'MAT') {
                        $('#radioMaterial').prop('checked', true);
                    };
                    if (jsonStr.RESULT[0][0].BLOQ_FAT == 'S') {
                        $('#checkBloqueiaFaturamento').prop('checked', true);
                    };
                    if (jsonStr.RESULT[0][0].BLOQ_PROD == 'S') {
                        $('#checkBloqueiaProduto').prop('checked', true);
                    };
                    if (jsonStr.RESULT[0][0].BLOQ_QTDE_MAX == 'S') {
                        $('#checkBloqueiaQuantidadeMaxima').prop('checked', true);
                    };

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do preço: ${error}`);
                };
            } finally {
                $.LoadingOverlay('hide');
            }
        };

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $("#btnGravar").click(

        async function () {
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    situacao = {};

                    situacao.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('sitprod', 'sitprod', 'CODIGO', 5) : $('#txtCodigo').val();
                    situacao.DESCRICAO = $('#txtDescricao').val().toUpperCase();

                    if ($('#radioProduto').prop('checked')) {
                        situacao.TIPO = 'PRO';
                    } else {
                        situacao.TIPO = 'MAT';
                    }

                    if ($('#checkBloqueiaFaturamento').prop('checked')) {
                        situacao.BLOQ_FAT = 'S';
                    } else {
                        situacao.BLOQ_FAT = 'N';
                    }
                    if ($('#checkBloqueiaProduto').prop('checked')) {
                        situacao.BLOQ_PROD = 'S';
                    } else {
                        situacao.BLOQ_PROD = 'N';
                    }
                    if ($('#checkBloqueiaQuantidadeMaxima').prop('checked')) {
                        situacao.BLOQ_QTDE_MAX = 'S';
                    } else {
                        situacao.BLOQ_QTDE_MAX = 'N';
                    }

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/situacao?', `JSON=${encodeURIComponent(JSON.stringify(situacao))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Situação: ${situacao.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/situacao`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da situação: ${error}`);
            }

        });
});