$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true
    });

    driver.defineSteps([{
      element: '#conteudo',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro, os campos com * são obrigatórios.',
        position: 'top'
      }
    },
    {
      element: '#txtTurno',
      popover: {
        title: 'Campo Código de Turno',
        description: 'Aqui adicionamos o código que o turno terá, ele pode conter 2 dígitos.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricaoTurno',
      popover: {
        title: 'Campo Descrição de Turno',
        description: 'Aqui adicionamos a descrição para o turno que estamos cadastrando ou alterando.',
        position: 'top'
      }
    },
    {
      element: '#tmEntrada',
      popover: {
        title: 'Horário de Início',
        description: 'Aqui definimos em qual horário se inicía o turno.',
        position: 'top'
      }
    },
    {
      element: '#tmSaida',
      popover: {
        title: 'Horário de Saída',
        description: 'Aqui definimos o horário final do turno.',
        position: 'top'
      }
    },
    {
      element: '#tutorialNoturno',
      popover: {
        title: 'Noturno',
        description: 'Aqui definimos se o turno é Noturno.',
        position: 'top'
      }
    },
   
    {
      element: '#btnVoltar',
      popover: {
        title: 'Botão Voltar',
        description: 'Ao clicar, volta a tela de Acesso de Turno.',
        position: 'top'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão de Gravar',
        description: 'Ao clicar, grava o novo registro ou a alteração do registro que está em edição.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let status = parametros[parametros.length - 1];

  if (status != "" && status != "create") {
    const resultadoStatus = status.split('#');
    await consultaTabela(resultadoStatus[0]);

  }

  async function consultaTabela(turno) {

    $.LoadingOverlay('show');
    try {
      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"TURNO", "camposSelect":["TURNO", "DESCRICAO", "NOTURNO", "HORA_INI", "HORA_FIM"],
      "where": ["1=1 AND TURNO = '${turno}'"]}`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }
     
      $("#txtTurno").val(jsonStr.RESULT[0][0].TURNO);
      $('#txtDescricaoTurno').val(jsonStr.RESULT[0][0].DESCRICAO);
      $('#tmEntrada').val(jsonStr.RESULT[0][0].HORA_INI.substring(11, 16));
      $('#tmSaida').val(jsonStr.RESULT[0][0].HORA_FIM.substring(11, 16));
      if (jsonStr.RESULT[0][0].NOTURNO == "S") {
        $('#cbNoturno').prop('checked', true)
      }else{
        jsonStr.RESULT[0][0].NOTURNO == "N"
      }
    }
    finally{
      $.LoadingOverlay('hide');
    }
  }

  $('#txtTurno').change(async function () {
    try {
        $.LoadingOverlay('show');
        try {
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"turno", 
            "camposSelect":["turno"], 
            "where": ["turno = '${$('#txtTurno').val()}'"]}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (jsonStr.RESULT[0].length > 0) {
                msgAlerta('Turno já cadastrado, use outro código.');
                $('#txtTurno').val('');
            }
        } catch (error) {
            console.error(error);
        }
    } finally {
        $.LoadingOverlay('hide');
    }
});

  function formataDataEHora(seletor) {
    const data = new Date();
    data.setHours($(seletor).val().split(':')[0]);
    data.setMinutes($(seletor).val().split(':')[1]);
    return data.toISOString().slice(0, 10) + 'T' + data.toLocaleString().replace(',', '').split(' ')[1] + 'Z'
  }

  $('#btnGravar').on('click', async function gravaStatus() {

    if ($('#txtTurno').val() == '') {
      msgAlerta('Preencha o campo Código.');
      setTimeout(function () {
        $('#txtTurno').focus();
      }, 2000);
      return;
    } else if (!$('#txtDescricaoTurno').val()) {
      msgAlerta('Adicione uma descrição para este Turno.');
      setTimeout(function () {
        $('#slDiaSemana').focus();
      }, 2000);
      return;    
    }

    const horaInicio = $('#tmEntrada').val() !== '' ? formataDataEHora('#tmEntrada') : '1899-12-30 00:00:00.000';
    const horaFim = $('#tmSaida').val() !== '' ? formataDataEHora('#tmSaida') : '1899-12-30 00:00:00.000';
    try {
      let status = {};

      status.TURNO = $('#txtTurno').val();
      status.DESCRICAO = $("#txtDescricaoTurno").val().toUpperCase();
      if ($('#cbNoturno').is(':checked')) {
        status.NOTURNO = 'S'
      } else {
        status.NOTURNO = 'N'
      }
      status.HORA_INI = horaInicio;
      status.HORA_FIM = horaFim;
      
      let response = await requisicao("POST", `/Sisplan/cadastros/V1/turno?`, `JSON=${encodeURIComponent(JSON.stringify(status))}&EMP_ID=${getCookie('emp_id')}`, 15000);
      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }
      toastr.success(
        `Turno cadastrado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/turno`;
        }
      }).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (err) {
      console.log(err);
      msgAlerta('Não foi possivel gravar os dados.')
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("TURNO", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/turno`;
  });

  

});
